/**
 * Copyright (c) 2014-2023 Governikus GmbH & Co. KG, Germany
 */

#include "CardReturnCode.h"

#include "Initializer.h"
#include "moc_CardReturnCode.cpp"

using namespace governikus;


GlobalStatus CardReturnCodeUtil::toGlobalStatus(CardReturnCode pCode)
{
	switch (pCode)
	{
		case CardReturnCode::OK:
		case CardReturnCode::OK_PUK:
			return GlobalStatus::Code::No_Error;

		case CardReturnCode::UNDEFINED:
		case CardReturnCode::UNKNOWN:
			return GlobalStatus::Code::Unknown_Error;

		case CardReturnCode::CARD_NOT_FOUND:
		case CardReturnCode::RETRY_ALLOWED:
			return GlobalStatus::Code::Card_Not_Found;

		case CardReturnCode::COMMAND_FAILED:
			return GlobalStatus::Code::Card_Communication_Error;

		case CardReturnCode::PROTOCOL_ERROR:
			return GlobalStatus::Code::Card_Protocol_Error;

		case CardReturnCode::WRONG_LENGTH:
			return GlobalStatus::Code::Workflow_Wrong_Length_Error;

		case CardReturnCode::UNEXPECTED_TRANSMIT_STATUS:
			return GlobalStatus::Code::Card_Unexpected_Transmit_Status;

		case CardReturnCode::CANCELLATION_BY_USER:
			return GlobalStatus::Code::Card_Cancellation_By_User;

		case CardReturnCode::INPUT_TIME_OUT:
			return GlobalStatus::Code::Card_Input_TimeOut;

		case CardReturnCode::INVALID_PASSWORD:
		case CardReturnCode::INVALID_PIN:
		case CardReturnCode::INVALID_PIN_2:
		case CardReturnCode::INVALID_PIN_3:
		case CardReturnCode::NO_ACTIVE_PIN_SET:
			return GlobalStatus::Code::Card_Invalid_Pin;

		case CardReturnCode::INVALID_CAN:
			return GlobalStatus::Code::Card_Invalid_Can;

		case CardReturnCode::INVALID_PUK:
			return GlobalStatus::Code::Card_Invalid_Puk;

		case CardReturnCode::NEW_PIN_MISMATCH:
			return GlobalStatus::Code::Card_NewPin_Mismatch;

		case CardReturnCode::NEW_PIN_INVALID_LENGTH:
			return GlobalStatus::Code::Card_NewPin_Invalid_Length;

		case CardReturnCode::PIN_BLOCKED:
			return GlobalStatus::Code::Card_Pin_Blocked;

		case CardReturnCode::PIN_NOT_BLOCKED:
			return GlobalStatus::Code::Card_Pin_Not_Blocked;

		case CardReturnCode::PUK_INOPERATIVE:
			return GlobalStatus::Code::Card_Puk_Blocked;
	}

	Q_UNREACHABLE();
}


bool CardReturnCodeUtil::equalsWrongPacePassword(CardReturnCode pCode)
{
	switch (pCode)
	{
		case CardReturnCode::INVALID_CAN:
		case CardReturnCode::INVALID_PASSWORD:
		case CardReturnCode::INVALID_PIN:
		case CardReturnCode::INVALID_PIN_2:
		case CardReturnCode::INVALID_PIN_3:
		case CardReturnCode::INVALID_PUK:
		case CardReturnCode::NEW_PIN_MISMATCH:
		case CardReturnCode::NEW_PIN_INVALID_LENGTH:
		case CardReturnCode::PIN_NOT_BLOCKED:
		case CardReturnCode::PIN_BLOCKED:
			return true;

		case CardReturnCode::UNDEFINED:
		case CardReturnCode::RETRY_ALLOWED:
		case CardReturnCode::CARD_NOT_FOUND:
		case CardReturnCode::UNKNOWN:
		case CardReturnCode::COMMAND_FAILED:
		case CardReturnCode::PROTOCOL_ERROR:
		case CardReturnCode::WRONG_LENGTH:
		case CardReturnCode::UNEXPECTED_TRANSMIT_STATUS:
		case CardReturnCode::OK:
		case CardReturnCode::OK_PUK:
		case CardReturnCode::CANCELLATION_BY_USER:
		case CardReturnCode::PUK_INOPERATIVE:
		case CardReturnCode::NO_ACTIVE_PIN_SET:
		case CardReturnCode::INPUT_TIME_OUT:
			return false;
	}

	Q_UNREACHABLE();
}
