/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "uaocodec.h"

QT_BEGIN_NAMESPACE

#ifndef QT_NO_TEXTCODEC

#define InRange(c, lower, upper)  (((c) >= (lower)) && ((c) <= (upper)))
#define IsLatin(c)        ((c) < 0x80)
#define IsFirstByte(c)        (InRange((c), 0x81, 0xFE))
#define IsSecondByteRange1(c)        (InRange((c), 0x40, 0x7E))
#define IsSecondByteRange2(c)        (InRange((c), 0xA1, 0xFE))
#define IsSecondByte(c)        (IsSecondByteRange1(c) || IsSecondByteRange2(c))

#define        QValidChar(u)        ((u) ? QChar((ushort)(u)) : QChar(QChar::ReplacementCharacter))


int UAOCodec::_mibEnum()
{
    return 0;
}

QByteArray UAOCodec::_name()
{
    return "UAO";
}

/*
 * ucs4 to big5hkscs convert routing
 */

typedef struct {
    ushort index; /* index into big table */
    ushort used;  /* bitmask of used entries */
} Summary16;

static const ushort big5_to_ucs[] = 
{
19991, 20002, 20012, 20053, 20066, 20106, 20144, 20203, 20205, 20220,
20252, 20362, 20479, 20546, 20560, 20600, 20696, 20702, 20724, 20758,
20810, 20817, 20836, 20842, 20869, 20880, 20893, 20902, 20904, 20905,
20935, 20950, 20955, 20972, 20988, 21003, 21012, 21013, 21024, 21035,
21049, 21071, 21105, 21136, 21138, 21140, 21148, 21167, 21173, 21200,
21248, 21255, 21284, 21318, 21343, 21395, 21424, 21469, 21539, 21584,
21585, 21642, 21661,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 21667, 21684, 21712,
21795, 21823, 21836, 21843, 21853, 21868, 21918, 21929, 21996, 22005,
22051, 22096, 22140, 22154, 22164, 22176, 22191, 22232, 22272, 22361,
22373, 22399, 22405, 22409, 22433, 22444, 22452, 22464, 22472, 22483,
22511, 22596, 22636, 22674, 22682, 22706, 22712, 22757, 22779, 22786,
22795, 22800, 22808, 22811, 29836, 29837, 29849, 29851, 29860, 29876,
29881, 29896, 29900, 29904, 29907, 30018, 30037, 30062, 30093, 30110,
30172, 30252, 30287, 30289, 30323, 30324, 30373, 30425, 30478, 30479,
30552, 30578, 30583, 30584, 30586, 30587, 30616, 30639, 30654, 30659,
30661, 30667, 30685, 30694, 30708, 30750, 30781, 30786, 30788, 30795,
30801, 21782, 22775, 38964, 33883, 28948, 33398, 35158, 40236, 40206,
36527, 24674, 26214, 34510, 25785, 37772, 22107, 28485, 35532, 29001,
24012, 34633, 39464, 31658, 36107, 39255, 23597, 32331, 38938, 20518,
25458, 40568, 30783, 40633, 40634, 36046, 35715, 61305, 33931, 37284,
31331, 25776, 24061, 24214, 32865, 26965, 31466, 28710, 26812, 31095,
28060, 36841, 31074, 22178, 34687, 21093, 31108, 28300, 37271, 31622,
38956, 26717, 20397, 34222,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 31725, 34635,
20534, 26893, 27542, 24910, 20855, 30495, 20516, 32622, 30452, 27097,
24803, 25334, 21599, 38788, 22092, 20677, 22040, 34398, 22834, 22875,
22877, 22883, 22892, 22939, 22999, 23019, 23066, 23210, 23248, 23281,
23350, 23497, 23539, 23571, 23580, 23582, 23635, 23705, 23708, 23738,
23739, 23745, 23797, 23802, 23829, 23832, 23870, 23891, 23900, 23917,
23923, 23924, 23948, 23952, 23993, 24016, 24019, 24135, 24164, 24271,
24272, 24298, 24304, 24329, 24332, 24337, 24353, 24372, 24385, 24389,
24401, 24412, 24422, 24451, 24560, 24650, 24672, 24715, 24742, 24798,
24849, 24864, 24865, 24892, 24893, 24984, 25015, 25076, 25107, 25117,
25118, 25143, 24186, 27664, 21454, 20267, 20302, 21556, 22257, 22766,
22841, 22918, 23596, 20915, 20914, 28798, 35265, 35282, 36125, 36710,
20122, 26469, 20177, 20004, 21327, 23626, 20872, 24213, 25269, 19996,
20105, 29366, 31868, 32416, 21351, 36711, 37048, 38271, 38376, 20384,
20387, 20822, 21017, 21170, 21364, 22850, 24069, 26594, 27769, 20026,
32419, 32418, 32426, 32427, 32421, 32422, 32417, 32989, 33486, 35745,
35746, 35747, 36126, 36127, 20891,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 36712,
38377, 38886, 39029, 39118, 39134, 20457, 20204, 20261, 20010, 20262,
20179, 20923, 21018, 21093, 21592, 23089, 23385, 23777, 23707, 23704,
24072, 24211, 24452, 25375, 26102, 26187, 20070, 27902, 27971, 20044,
29421, 29384, 20137, 30757, 31210, 32442, 32433, 32441, 32431, 32445,
32432, 32423, 32429, 32435, 32440, 32439, 32961, 33033, 21005, 35760,
35750, 35752, 35751, 35754, 35759, 35757, 35755, 23682, 36130, 36129,
36713, 36715, 38025, 38024, 38026, 38027, 38378, 38453, 38485, 38473,
39269, 39532, 39592, 20266, 20255, 20390, 20391, 21153, 21160, 21306,
21442, 21713, 38382, 34900, 22269, 22362, 22441, 25191, 22815, 23044,
22919, 19987, 23558, 23625, 23781, 23703, 24102, 24080, 24352, 24378,
20174, 24469, 20932, 24581, 25195, 25346, 25194, 25249, 25379, 36133,
21551, 26011, 26025, 26172, 21206, 24323, 26465, 26541, 26432, 27682,
20937, 27973, 28170, 27882, 27814, 20928, 29301, 29424, 29616, 20135,
27605, 24322, 20247, 32458, 32479, 32461, 32459, 32460, 32454, 32453,
32452, 32456, 32449, 32450, 38069, 20064, 33626, 33550, 33682, 24196,
33483, 22788, 26415, 34926, 35269, 35268,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
35775, 35766, 35776, 35767, 35768, 35774, 35772, 35769, 36137, 36131,
36143, 36135, 36138, 36139, 36717, 36719, 36825, 36830, 36851, 38039,
38035, 38031, 38034, 38381, 38472, 38470, 38452, 39030, 39031, 40060,
40479, 21348, 40614, 22791, 20263, 20254, 20975, 21056, 21019, 21171,
21195, 20007, 21333, 21727, 21796, 20052, 22260, 23591, 22330, 25253,
22490, 22774, 23090, 23547, 23706, 24103, 24079, 21397, 21417, 24694,
38391, 24812, 24699, 24700, 25315, 25381, 25442, 25196, 26531, 26635,
26632, 38054, 27531, 22771, 27695, 27689, 28044, 20945, 28270, 28065,
27748, 27979, 27985, 28067, 26080, 29369, 33487, 30011, 30153, 21457,
30423, 30746, 31174, 31383, 31508, 31499, 32478, 32467, 32466, 32477,
19997, 32476, 32473, 32474, 32470, 32475, 32899, 32958, 32960, 21326,
33713, 33484, 34394, 35270, 35780, 35789, 35777, 35778, 35791, 35781,
35784, 35787, 35785, 35786, 35779, 36142, 36148, 36144, 36155, 36146,
36153, 36154, 36149, 20080, 36140, 36152, 36151, 36722, 36724, 36726,
36827, 37038, 20065, 38046, 38062, 38041, 38048, 38055, 38045, 38052,
38051, 38389, 38384, 24320, 38386, 38388, 38387,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 38431, 38454, 38451, 38887, 39033, 39034, 39035, 39274, 39277,
39272, 39278, 39276, 20911, 39533, 20081, 20538, 20256, 20165, 20542,
20260, 20588, 38130, 21183, 31215, 27719, 21527, 21596, 21595, 22253,
22278, 28034, 22359, 22366, 22488, 33556, 22885, 22920, 29233, 24574,
24582, 24698, 25439, 25250, 25443, 26500, 26198, 26197, 26104, 20250,
19994, 26497, 26472, 26722, 26539, 23681, 27807, 28781, 28287, 28369,
27815, 28902, 28860, 28800, 28949, 29239, 29422, 29502, 29682, 24403,
30415, 30544, 30529, 38606, 30860, 33410, 31509, 31908, 32463, 32482,
32465, 32485, 32486, 20041, 32673, 22307, 32928, 33050, 32959, 33041,
33636, 33479, 21494, 33716, 34398, 34383, 21495, 34568, 34476, 34917,
35013, 35815, 35813, 35814, 35797, 35799, 35800, 35801, 35811, 35802,
35805, 35803, 35809, 35810, 35808, 35807, 36156, 36164, 36158, 36159,
36160, 36161, 36162, 36165, 36739, 36733, 36732, 36734, 20892, 36816,
36798, 36829, 36807, 37049, 38068, 38067, 38073, 38072, 38078, 38080,
38085, 38057, 38082, 38083, 38089, 38091, 38044, 38093, 38079, 38086,
38392, 38504, 38589, 30005, 39044, 39037, 39039, 39036,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 39041, 39042, 39282, 39284, 39281, 39280, 39536, 39534,
39535, 40480, 20389, 20392, 21294, 21388, 23581, 21589, 21497, 21949,
21863, 21716, 22242, 22270, 23576, 22443, 22545, 23551, 26790, 22842,
22849, 22954, 23454, 23517, 23545, 23649, 23853, 23702, 24065, 24124,
24443, 24577, 24815, 24696, 24813, 24808, 25602, 25524, 25530, 30021,
33635, 26538, 28378, 28173, 27721, 28385, 28382, 28176, 28072, 28063,
27818, 28180, 28183, 28068, 33639, 23572, 33638, 29425, 29712, 29595,
30111, 30113, 30127, 30186, 23613, 30417, 30805, 31087, 31096, 31181,
31216, 27964, 31389, 31546, 31581, 32509, 32510, 32508, 32496, 32491,
32511, 32039, 32512, 32434, 32494, 32504, 32501, 32438, 32500, 32490,
32513, 32502, 32602, 38395, 33669, 30422, 33642, 33485, 34432, 35829,
35821, 35820, 35748, 35819, 35823, 35828, 35824, 35826, 35825, 35827,
35822, 23486, 36168, 36170, 36213, 36214, 36741, 36740, 36731, 36828,
36874, 36882, 38128, 38134, 38108, 38125, 38114, 38124, 38120, 38133,
38115, 38402, 38394, 38397, 38401, 38400, 38469, 39047, 39046, 39122,
39290, 39292, 39285, 39287, 39539, 32942, 39600, 40483, 40482,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 20964, 40784, 20159, 20202, 20215, 20396, 20393,
20461, 21095, 21016, 21073, 21053, 21385, 21792, 22068, 21719, 22040,
21943, 21880, 21501, 22687, 22367, 22368, 22549, 23092, 23157, 22953,
23047, 23046, 23485, 23457, 20889, 23618, 23956, 24092, 24223, 21416,
24217, 21422, 24191, 24377, 24198, 34385, 24551, 24578, 24751, 24814,
24868, 24579, 25370, 25169, 25438, 25320, 25376, 25242, 25528, 25599,
25932, 25968, 26242, 26165, 26679, 26729, 26530, 26631, 27004, 26728,
20048, 26526, 27431, 27527, 27572, 27974, 27900, 27905, 27975, 28291,
28070, 28071, 27988, 28909, 22870, 33721, 30126, 30353, 30385, 30424,
30830, 30721, 31377, 31351, 32532, 32451, 32428, 32516, 32517, 32521,
32534, 32536, 32447, 32526, 32531, 32525, 32514, 32520, 32519, 39554,
32610, 33014, 32932, 33714, 33643, 33931, 34430, 34583, 21355, 35850,
35845, 35848, 35846, 35806, 35831, 35832, 35838, 35839, 35844, 35843,
35841, 35770, 35812, 35847, 35837, 35840, 31446, 36180, 36175, 36171,
36145, 36134, 36172, 36132, 21334, 36176, 36136, 36179, 36341, 36745,
36742, 36749, 36744, 36743, 36718, 36750, 36747, 36746, 36866, 36801,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 37051, 37073, 37011, 38156, 38161, 38144,
38138, 38096, 38148, 38109, 38160, 38153, 38155, 38049, 38146, 38398,
38405, 24041, 39049, 39052, 20859, 39295, 39297, 39548, 39547, 39543,
39542, 39549, 39550, 39545, 39544, 39607, 38393, 40063, 40065, 40489,
40486, 40632, 40831, 20454, 20647, 20394, 24130, 21058, 21544, 21725,
22003, 22438, 22363, 22859, 34949, 23398, 23548, 23466, 20973, 24811,
25044, 24518, 25112, 25317, 25377, 25374, 25454, 25523, 25321, 25441,
25285, 25373, 21382, 26195, 26196, 26137, 26726, 27178, 26641, 26925,
26725, 26426, 26721, 28096, 27987, 27901, 27978, 27811, 28582, 28177,
28861, 28903, 28783, 28907, 28950, 29420, 29585, 29935, 30232, 21346,
30610, 30742, 30875, 31215, 39062, 31267, 31397, 31491, 31579, 32546,
32547, 33830, 32538, 21439, 32543, 32540, 32537, 32457, 33147, 20852,
33329, 33633, 33831, 33436, 34434, 33828, 35044, 20146, 35278, 35867,
35866, 35855, 35763, 35851, 35853, 35856, 35864, 35834, 35858, 35859,
35773, 35861, 35865, 35852, 35862, 36182, 36752, 36753, 36755, 36751,
21150, 36873, 36831, 36797, 36951, 37050, 38189, 38191, 38192, 38169,
38065,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 38050, 38177, 24405, 38126, 38181,
38182, 38175, 38178, 38193, 38414, 38543, 38505, 38745, 33148, 39050,
39048, 39057, 39060, 22836, 39059, 39056, 39302, 39279, 39300, 39301,
39559, 39560, 39558, 39608, 39612, 40077, 40501, 40490, 40495, 40493,
40499, 40857, 40863, 20248, 20607, 20648, 21169, 21659, 21523, 21387,
22489, 23156, 23252, 23351, 23604, 23654, 23679, 23896, 24110, 24357,
24212, 24691, 25103, 20987, 25380, 25319, 25311, 25601, 25947, 27609,
26279, 26723, 26816, 26727, 26633, 27183, 27539, 27617, 27870, 28392,
27982, 28059, 28389, 28073, 28493, 33829, 28799, 28891, 28905, 22681,
29406, 33719, 29615, 29815, 30184, 30103, 30699, 30970, 30710, 31699,
31914, 38214, 31937, 32553, 32489, 32554, 32533, 32551, 32503, 32541,
24635, 32437, 32555, 32420, 32549, 32358, 32550, 22768, 32874, 32852,
32824, 33043, 32966, 33080, 33037, 20020, 20030, 33392, 34103, 34015,
20111, 34684, 34632, 20149, 35099, 35274, 35868, 35876, 35878, 35762,
35854, 35875, 35874, 35466, 35879, 36186, 36187, 36141, 36185, 36235,
36758, 36759, 27586, 36757, 33286, 36824, 36808, 37213, 38208, 38209,
38170, 38190,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 38194, 38149, 38180, 38202,
38201, 38203, 38206, 38199, 38420, 38421, 38417, 38385, 38544, 38582,
34429, 38889, 39063, 39123, 39563, 39567, 40092, 40091, 40084, 40081,
40511, 40509, 28857, 25995, 19995, 22108, 22329, 22418, 23158, 25041,
25193, 25527, 25200, 25781, 25670, 25822, 25783, 26029, 27103, 26588,
27099, 26592, 27428, 24402, 27553, 27899, 28182, 28388, 28174, 28293,
27983, 28908, 28952, 29367, 29454, 29934, 30112, 30545, 30784, 31036,
31313, 31229, 31388, 31373, 31659, 31783, 31658, 31697, 31616, 31918,
32455, 32558, 32469, 32557, 32483, 32559, 32728, 32844, 32834, 33040,
33169, 26087, 33832, 34013, 33632, 34546, 34633, 35280, 35294, 35871,
35880, 35884, 35882, 36184, 36434, 36857, 36344, 36527, 36716, 36761,
36841, 21307, 37233, 38225, 38145, 38056, 38221, 38215, 38224, 38226,
38217, 38422, 38383, 38423, 38425, 26434, 21452, 38607, 40481, 39069,
39068, 39064, 39066, 39067, 39311, 39306, 39304, 39569, 39617, 40104,
40100, 40107, 40103, 40515, 40517, 40516, 22404, 22364, 23456, 24222,
24208, 24809, 24576, 25042, 25314, 26103, 27249, 26911, 27016, 27257,
28487, 28625, 27813,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 28626, 27896, 28865,
29261, 29322, 20861, 29549, 29626, 29756, 30068, 30250, 30861, 31095,
31283, 31614, 33575, 32462, 32499, 32472, 32599, 32564, 33211, 33402,
34222, 33647, 34433, 34631, 35014, 34948, 35889, 35782, 35885, 35890,
35749, 35887, 36192, 36190, 36343, 36762, 36735, 36766, 36793, 38236,
38237, 38238, 38142, 38231, 38232, 38230, 38233, 38197, 38210, 38143,
37694, 20851, 38471, 38590, 38654, 38892, 38901, 31867, 39072, 39125,
39314, 39313, 39579, 39575, 40120, 40115, 40109, 40119, 40529, 40521,
40522, 40524, 40527, 20029, 40628, 21149, 21657, 22052, 20005, 23453,
24748, 24527, 25318, 25600, 32999, 27015, 28572, 28491, 28809, 29649,
30719, 30778, 30718, 30782, 31398, 31454, 31609, 31726, 36779, 32548,
32487, 32578, 33002, 33328, 34108, 34106, 33446, 33529, 34164, 34461,
35124, 35273, 35302, 35758, 35793, 35893, 36194, 36193, 36280, 37322,
38047, 38105, 38152, 38416, 39128, 39286, 39269, 39582, 33150, 39578,
40131, 40133, 20826, 40835, 40836, 20458, 21995, 21869, 22179, 23646,
24807, 24913, 25668, 25658, 26003, 27185, 26639, 26818, 27516, 28866,
29306, 38262, 29838, 30302,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 32544, 32493,
20848, 34259, 34510, 35272, 35892, 25252, 35465, 36163, 36364, 36291,
36347, 36720, 36777, 38256, 38253, 38081, 38107, 38094, 38255, 38220,
21709, 39038, 39074, 39144, 39537, 39584, 34022, 39585, 39621, 40141,
40143, 33722, 40548, 40542, 40839, 40840, 21870, 20456, 20645, 21587,
23402, 24005, 23782, 24367, 25674, 26435, 27426, 28393, 29473, 21472,
30270, 30307, 31548, 31809, 32843, 33039, 34989, 34924, 35835, 36174,
36189, 36399, 36396, 36756, 37094, 38136, 37492, 38657, 38801, 32366,
39076, 39556, 39553, 40150, 40098, 40148, 40151, 40551, 40485, 40761,
40841, 40842, 40858, 24651, 25371, 25605, 29906, 31363, 32552, 33250,
33821, 34506, 21464, 36902, 36923, 38259, 38084, 38757, 26174, 39181,
24778, 39551, 39564, 39635, 39633, 40157, 40158, 40156, 40502, 22065,
22365, 25597, 30251, 30315, 32641, 34453, 35753, 35863, 35894, 33395,
36195, 37247, 38643, 28789, 38701, 39078, 39588, 39699, 39751, 40078,
40560, 40557, 30839, 30416, 40140, 40844, 40843, 21381, 27012, 28286,
31729, 31657, 34542, 35266, 36433, 34885, 38053, 39045, 39307, 39627,
40649, 28390, 30633, 38218, 38831,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 39540,
39589, 32518, 35872, 36495, 37245, 38075, 37550, 38179, 40132, 40072,
40681, 20991, 40550, 39562, 40563, 40510, 38074, 20162, 34381, 27538,
22439, 22395, 25099, 20451, 21037, 21389, 21593, 21370, 32424, 33543,
38023, 38022, 21591, 24362, 31059, 32446, 37071, 38028, 21072, 21286,
22261, 22445, 23045, 23741, 23811, 28062, 28172, 28867, 30502, 32448,
32464, 33003, 38030, 38032, 38037, 38029, 38379, 22955, 23899, 24701,
26720, 26536, 27817, 27976, 30066, 30743, 32471, 33757, 35271, 35765,
35790, 35794, 36150, 36147, 36730, 36725, 36728, 36911, 37075, 37124,
38059, 38060, 38043, 38063, 38061, 38058, 38390, 38503, 39032, 39275,
40697, 20251, 20603, 20325, 21794, 22450, 24047, 24493, 28828, 33557,
29426, 29614, 32488, 32480, 32481, 32671, 33645, 34545, 35795, 35798,
35817, 35796, 35804, 36241, 36738, 36737, 37036, 38090, 38088, 38064,
38066, 38070, 38157, 38092, 38077, 38076, 39043, 39040, 20971, 40702,
20606, 21787, 23901, 24123, 24747, 24749, 24580, 25132, 25111, 25247,
25248, 25532, 26724, 26473, 33637, 27986, 27812, 28829, 30386, 30720,
32507, 32498, 32495, 32506, 33715, 35275,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
35830, 36167, 38129, 38098, 38097, 38101, 38111, 38123, 38127, 38122,
38135, 38102, 38117, 39121, 21055, 21154, 21715, 21586, 23810, 23780,
24209, 24870, 25378, 26912, 27637, 39053, 28061, 28514, 28064, 28375,
29711, 29825, 30231, 32515, 32535, 32524, 32527, 32529, 33628, 33932,
33553, 33473, 35833, 35836, 35842, 36181, 37112, 38162, 38103, 38141,
38163, 38154, 38116, 38150, 38151, 38164, 38406, 38403, 38739, 39055,
39293, 39541, 39552, 40066, 40488, 21714, 21717, 21721, 23250, 23748,
24639, 27546, 27981, 28904, 29443, 29423, 30876, 31405, 32279, 32539,
33927, 33640, 33929, 33630, 33720, 33431, 34547, 35816, 35857, 35860,
35869, 37072, 38185, 38188, 38166, 38167, 38140, 38171, 38165, 38174,
38036, 38415, 38408, 38409, 38410, 38412, 38413, 40498, 40497, 21724,
24113, 24697, 25672, 58305, 27894, 29461, 29971, 30213, 30187, 30807,
31654, 31578, 31976, 32545, 32807, 33631, 33718, 34544, 35042, 35279,
35873, 35788, 35877, 36292, 38200, 38196, 38113, 38198, 38418, 39271,
40082, 40085, 40504, 40505, 40506, 40832, 24636, 25669, 25784, 27898,
30102, 32523, 32873, 33641, 34789, 34414, 35764,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 35881, 36188, 36157, 36760, 37021, 38227, 38112, 38204, 38223,
34021, 38890, 39273, 39568, 39570, 39571, 38411, 40105, 40096, 40520,
40513, 40518, 21411, 21590, 22406, 27104, 26638, 27655, 27895, 28486,
31074, 32562, 32563, 32628, 33315, 34511, 34431, 35043, 35281, 35311,
35886, 38235, 38239, 38250, 38214, 38121, 38891, 39073, 39312, 39618,
40117, 40118, 40123, 40113, 40526, 40491, 40700, 21950, 25732, 26634,
26533, 26636, 32561, 32845, 33551, 33480, 34162, 34548, 34686, 38132,
38246, 38248, 38241, 38243, 38212, 38251, 38119, 38244, 38137, 38426,
39071, 39316, 39546, 39581, 39583, 39576, 40535, 40538, 40540, 40838,
40837, 20649, 23743, 30152, 25786, 27017, 28384, 30779, 31901, 32425,
32556, 34105, 36166, 38257, 38396, 39129, 39586, 39574, 39580, 40101,
40142, 40144, 40547, 40536, 40574, 20865, 23048, 28757, 25874, 30271,
31656, 31860, 33339, 35276, 36345, 36318, 36729, 38228, 38252, 39587,
39557, 40149, 40099, 40102, 40552, 40503, 40859, 26686, 26916, 34016,
38624, 36723, 40159, 40095, 40553, 40556, 40554, 40555, 40519, 28751,
31766, 35888, 39628, 31550, 31900, 32565, 33044, 36479,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 38247, 40090, 36273, 36508, 37246, 35891, 39070, 39079,
39591, 40492, 25094, 38404, 40097, 40514, 31160, 25300, 36299, 29648,
23467, 25296, 27585, 20943, 31108, 21525, 28508, 34972, 37095, 20857,
25144, 25243, 25383, 25531, 25566, 25594, 25745, 25792, 25825, 25846,
25861, 25909, 25934, 25963, 25992, 26073, 26142, 26171, 26175, 26180,
26199, 26217, 26227, 26243, 26300, 26303, 26305, 26357, 26362, 26363,
26382, 26390, 26423, 26468, 26470, 26534, 26535, 26537, 26619, 26621,
26624, 26625, 26629, 26654, 26698, 26706, 26709, 26713, 26765, 26809,
26831, 20616, 38184, 40087, 26914, 26918,   220, 58591, 58592,   252,
58594, 58595,   220,   252, 26934, 26977, 33477, 33482, 33496, 33560,
33562, 33571, 33606, 33627, 33634, 33644, 33646, 33692, 33695, 33717,
33724, 33783, 33834, 33864, 33884, 33890, 33924, 33928, 34012, 34019,
34104, 34138, 34199, 34219, 34241, 34323, 34326,  8715, 34581, 34672,
34685, 34699, 34728, 34759, 34768, 34823, 34830, 34855, 34990,  8712,
34997, 35007, 35045, 35061, 35100, 35101, 35191, 35303, 35383, 35500,
35546, 35675, 35697, 35883, 35898, 35964, 35982, 36014, 36114,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 36169, 36173, 36209, 36360, 36410, 36464, 36505,
36528, 36529, 36549, 36550, 36558, 36579, 36620, 36721, 36727, 36775,
36847, 36878, 36921, 36965, 37001, 37086, 37141, 37334, 37339, 37342,
37345, 37349, 37366, 37372, 37417, 37420, 65287, 37465, 37495, 37613,
37690, 58701, 58702, 29227, 20866, 20886, 20023, 20843, 20799, 58709,
58710, 26409, 27706, 21378, 30098, 32896, 34916, 19974, 58718, 58719,
58720, 11927, 21241, 21269,  8225, 58725, 13316, 58727, 58728, 58729,
58730, 58731, 20981, 58733, 23662, 58735, 22231, 20128, 20907, 11904,
27079, 58741,  9550,  9688,  9689,  9794,  9654,  9668,  8597,  8252,
  182,  8704,  8616,  8596,  8962, 58755, 58756, 20124, 24746, 22311,
22258, 21307, 22769, 36920, 38560, 26628, 21942, 39365, 35585, 20870,
32257, 24540, 27431, 27572, 26716, 22885, 31311, 20206, 20385, 30011,
28784, 20250, 24724, 28023, 32117, 22730, 25040, 25313, 27579, 35226,
23398, 27005, 21917, 28167, 58794, 24059, 38501, 21223, 23515, 28450,
38306, 27475, 35251, 27671, 24112, 25135, 29344, 34384, 26087, 24613,
25312, 25369, 34394, 23777, 25375, 29421, 37111, 38911, 26241, 21220,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 35641, 21306, 39366, 21234, 58824, 24452,
33550, 24693, 25522, 28179, 32076, 34509, 36605, 32153, 40335, 25731,
30476, 20537, 21091, 38522, 22287, 26908, 27177, 38997, 39443, 21427,
21577, 23087, 35492, 24195, 28207, 37489, 21495, 22269, 40658, 31296,
30741, 28168, 25998, 27507, 21092, 38609, 21442, 26719, 24808, 36059,
27531, 27503, 20816, 36766, 28287, 23455, 20889, 33294, 25448, 37320,
23551, 21454, 34886, 24467, 28171, 29539, 32294, 31899, 20966, 23558,
31216, 28169, 28988, 22888, 26465, 29366, 20055, 27972, 21104, 30067,
32260, 22732, 23330, 35698, 37304, 35302, 22065, 23517, 23613, 22259,
31883, 37204, 31298, 38543, 39620, 26530, 25968, 25454, 28716, 22768,
25993, 38745, 31363, 25666, 32118, 23554, 27973, 25126, 36341, 37549,
28508, 36983, 36984, 32330, 31109, 30094, 22766, 20105, 33624, 25436,
25407, 24035, 31379, 35013, 20711, 23652, 32207, 39442, 22679, 24974,
34101, 36104, 33235, 23646, 32154, 22549, 23550, 24111, 28382, 28381,
25246, 27810, 28655, 21336, 22022, 22243, 26029, 24382, 36933, 26172,
37619, 24193, 24500, 32884, 25074, 22618, 36883, 37444, 28857, 36578,
20253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 38651, 28783, 24403, 20826, 30423,
31282, 38360, 24499, 27602, 29420, 35501, 23626, 38627, 24336, 24745,
33075, 25309, 24259, 22770, 26757, 21338, 34180, 40614, 32283, 30330,
39658, 25244, 27996, 27996, 25935, 25975, 20398, 25173, 20175, 36794,
22793, 27497, 33303, 31807, 21253, 23453, 25265, 27873, 32990, 30770,
35914, 39165, 22696, 27598, 28288, 33032, 40665, 35379, 34220, 36493,
19982, 35465, 25671, 27096, 35617, 26332, 26469, 38972, 20081, 35239,
31452, 38534, 26053, 20001, 29471, 32209, 28057, 22593, 31036, 21169,
25147, 38666, 40802, 26278, 27508, 24651, 32244, 37676, 28809, 21172,
27004, 37682, 28286, 24357, 20096, 26365, 22985, 23437, 23947, 27179,
26907, 21936, 31874, 36796, 27018, 21682, 40235, 38635, 26905, 25539,
39364, 20967, 26626, 36795, 20685, 23776, 26627, 20970, 21250, 30834,
30033, 30048, 22138, 37618, 22592, 26622, 20451, 26466, 31870, 21249,
20452, 20453, 20969, 21498, 21720, 22222, 22310, 22327, 22328, 22408,
22451, 22442, 22448, 22486, 22640, 22713, 22743, 23670, 23740, 23749,
23742, 23926, 24342, 24634, 25525, 26433, 26467, 26529, 26810, 26917,
26920, 27258,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 26915, 26913, 27006, 27009,
27101, 27182, 27250, 27423, 27615, 28181, 29077, 29927, 29938, 29936,
29937, 29944, 29957, 30057, 30314, 30836, 31437, 31439, 31445, 31443,
31457, 31472, 31490, 31763, 31767, 31888, 31917, 31936, 31960, 32155,
32261, 32359, 32387, 32400, 33188, 33373, 33826, 34009, 34352, 34475,
34543, 34992, 35011, 35012, 35076, 59183, 36542, 36552, 36684, 36791,
36826, 36903, 36950, 37685, 37691, 37817, 38282, 38294, 38777, 38790,
38800, 39082, 39830, 39831, 39860, 39887, 39889, 39890, 39922, 39921,
39984, 40007, 40026, 40176, 40262, 40292, 40363, 20036, 21583, 25368,
39857, 40041, 40263, 40293, 39983, 40639, 20916, 21610, 26528, 39822,
37032, 20914, 13869, 25285, 21189, 26545, 21709, 24658, 21441, 28913,
22531, 21855, 37390, 30528, 29756, 29002, 28377, 21472, 29486, 35023,
30861, 32675, 32171, 36394, 37979, 25452, 24487, 23557, 32827, 23791,
14776, 29009, 36045, 38894, 22642, 23139, 32632, 23895, 24943, 27032,
32137, 31918, 32179, 28545, 23290, 22715, 29269, 30286, 36653, 37561,
40286, 40623, 32583, 40388, 36120, 20915, 34412, 21668, 21414, 21030,
26422, 20001, 21364,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 24313, 21177, 21647,
24312, 22956, 24625, 29248, 33047, 30267, 24333, 26187, 26280, 24932,
25423, 28895, 27940, 31911, 31945, 21465, 25933, 22338, 29647, 32966,
13649, 27445, 30849, 21452, 29483, 29482, 29641, 30026, 23033, 29124,
29966, 32220, 39393, 35241, 28662, 14935, 25834, 15341, 27809, 28284,
30055, 22633, 22633, 20996, 59338, 24967, 25658, 33263, 59342, 20917,
20945, 27769, 22815, 36857, 39153, 25911, 33033, 34996, 14890, 36525,
32663, 39440, 32037, 27336, 20876, 21031, 59360, 33050, 21408, 21410,
27738, 27703, 33304, 21894, 24315, 20937, 30897, 37474, 21357, 20931,
59374, 33905, 35207, 38765, 35728, 38563, 24316, 38583, 20814, 39952,
26160, 37461, 30728, 37701, 37491, 37737, 59390, 59391, 59392, 59393,
37343, 37338, 30804, 30822, 30856, 30902, 30919, 30930, 30935,  8491,
 8651, 30948, 30958, 30960, 30961, 30965, 31026, 31027, 31030, 31064,
12307, 31065, 31089, 31102, 31107, 31110, 31111, 31121, 31129, 31135,
31141, 31202, 31217, 31220, 31274, 31290, 31301, 31333, 31420, 31426,
31433, 31451, 31465, 31486, 31500, 31527, 31529, 31554, 31555, 31573,
31599, 31666, 27102, 27129,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 37238, 33114,
33527, 21579, 33074, 32957, 33816, 37214, 37232, 37260, 33096, 59459,
17462, 33113, 32927, 59463, 21833, 21537, 21722, 21554, 21945, 21652,
59470, 30802, 30789, 30796, 59474, 33981, 33820, 33476, 59478, 33915,
35629, 59481, 22347, 59483, 59484, 22341, 34766, 22112, 21994, 22139,
32956, 59491, 30904, 27148, 21708, 31696, 31724, 31738, 31765, 31771,
31797, 31812, 31853, 31886, 31928, 31939, 31974, 31981, 31987, 31989,
31993, 59511, 31996, 32139, 32151, 32164, 32168, 32205, 32208, 32211,
32229, 32253, 27154, 27170, 27184, 27190, 27237, 59527, 59528, 59529,
59530, 59531, 59532, 59533, 59534, 27251, 27256, 59537, 59538, 27260,
27305, 27306,  9450,  9312,  9313,  9314,  9315,  9316,  9317,  9318,
 9319,  9320,  9321,  9322,  9323,  9324,  9325,  9326,  9327,  9328,
 9329,  9330,  9331, 37700, 37805, 37830, 37861, 37914, 37921, 37950,
37953, 37971, 37978, 38042, 38071, 38104, 38110, 38131, 38147, 38158,
38159, 38168, 38173, 38186, 38187, 38207, 38213, 38222, 38242, 38245,
38249, 38258, 38279, 38297, 38304, 38322, 38502, 38557, 38575, 38578,
38707, 38715, 38733, 38735, 38737,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 38741,
38756, 38763, 38769, 38802, 38834, 38898, 38973, 38996, 39077, 39107,
39130, 39150, 39197, 39200, 39267, 39296, 39303, 39309, 39315, 39317,
39356, 39368, 39410, 39606, 39641, 39646, 39695, 39753, 39794, 39811,
39839, 39867, 39907, 39925, 39936, 39940, 39963,  9398,  9399,  9400,
 9401,  9402,  9403,  9404,  9405,  9406,  9407,  9408,  9409,  9410,
 9411,  9412,  9413,  9414,  9415,  9416,  9417,  9418,  9419,  9420,
 9421,  9422,  9423,  9424,  9425,  9426,  9427,  9428,  9429,  9430,
 9431,  9432,  9433,  9434,  9435,  9436,  9437,  9438,  9439,  9440,
 9441,  9442,  9443,  9444,  9445,  9446,  9447,  9448,  9449,   174,
 8482, 59697, 59698, 40054, 10102, 10103, 10104, 10105, 10106, 10107,
10108, 10109, 10110, 10111, 40069, 40070, 40071, 40075, 40080, 40094,
40110, 40112, 40114, 40116, 40122, 40124, 40125, 40134, 40135, 40138,
40139, 40147, 40152, 40153, 40162, 40171, 40172, 40234, 40264, 40272,
40314, 40390, 40523, 40533, 40539, 40561, 40618, 40637, 40644, 40674,
40682, 40712, 40715, 40717, 40737, 40772, 40785, 40861, 64014, 64015,
64017, 64019, 64020, 64024, 64031, 64032,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
64033, 64035, 64036, 64039, 64040, 64041, 19972, 20015, 20097, 20103,
20131, 20151, 20156, 20216, 20264, 20265, 20279, 20290, 20293, 20299,
20338, 20386, 20400, 20413, 20424, 20428, 20464, 20466, 20473, 20483,
20488, 20532, 20539, 20568, 20582, 20609, 20624, 20668, 20688, 20703,
20705, 20732, 20749, 20779, 20832, 20910, 20920, 20946, 20962, 20997,
21044, 21052, 21081, 21096, 21113, 21156, 21196, 21287, 21314, 21341,
21373, 21374, 21445, 21456, 21458, 21502, 21613, 21637, 21651, 21662,
21689, 21731, 21743, 21773, 21784, 21797, 21800, 21803, 21831, 21881,
21904, 21940, 21953, 21975, 21976, 22011, 20404, 22049,  8707, 22098,
59852,  9787, 59854, 59855, 22109,  9332,  9333,  9334,  9335,  9336,
 9337,  9338,  9339,  9340,  9341,  9342,  9343,  9344,  9345,  9346,
 9347,  9348,  9349,  9350,  9351, 22113, 22153, 22155, 22174, 22177,
22193, 22201, 22207, 22230, 22255, 22293, 22301, 22322, 22333, 22335,
22339,  8660, 22398, 22410, 22413, 22416, 22428, 22459, 22462, 22468,
22494, 22526, 22546, 22562, 22599, 22620, 22623, 22643, 22695, 22698,
22704, 22709, 22710, 22731, 22736, 22752, 22789,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 22801, 22921, 22932, 22938, 22943, 22960, 22968, 22980, 23023,
23024, 23032, 23042, 23051, 23053, 23058, 23073, 23076, 23079, 23082,
23083, 23084, 23101, 23109, 23124, 23129, 23137, 23144, 23147, 23150,
23153, 23161, 23166, 23169, 23170, 23174, 23176, 23185, 23193, 23200,
23201, 23211, 23235, 23246, 23247, 23251, 23268, 23280, 23294, 23309,
23313, 23317, 23327, 23339, 23361, 23364, 23366, 23370, 23375, 23400,
23412, 23414, 23420, 23426, 23440,  9372,  9373,  9374,  9375,  9376,
 9377,  9378,  9379,  9380,  9381,  9382,  9383,  9384,  9385,  9386,
 9387,  9388,  9389,  9390,  9391,  9392,  9393,  9394,  9395,  9396,
 9397, 60009, 12850, 12849, 27307, 23446,  9352,  9353,  9354,  9355,
 9356,  9357,  9358,  9359,  9360,  9361,  9362,  9363,  9364,  9365,
 9366,  9367,  9368,  9369,  9370,  9371, 23509, 23511, 23587, 23685,
23710, 23746, 23824, 23852, 23855, 23880, 23894, 23920, 23931, 23941,
23972, 23979, 23990, 24001, 24023, 24073, 24136, 24210, 24253, 24334,
24434, 24497, 24514, 24539, 24543, 24611, 24702, 24791, 24839, 24844,
24857, 24866, 24912, 24928, 24961, 24981, 25017, 25024,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 25039, 25043, 25050, 25232, 25393,  8835, 25399, 25465,
25483, 25537, 25570, 25574, 25595, 25598, 25607, 25650, 25656, 25659,
25690, 25713, 25724, 25741, 25775, 25780, 25782, 25821, 25829, 25866,
25873, 25887, 25951, 25965, 25990, 26037, 26046, 26065, 26068, 26083,
26111, 26136, 26147, 26211, 26219, 26237, 26245, 26258, 26266, 26276,
26285, 26291, 26294, 26317, 26318, 26370, 26380, 26393, 26436, 26475,
26511, 26532, 26559, 26582, 26583,  8834, 26637, 26640, 26651, 26678,
26695, 26710, 26756, 26760, 26813, 26819, 26821, 26882, 26883, 26889,
26904, 26947, 26950, 26980, 26983, 26994, 27013, 27039, 27042, 27089,
27093, 27094, 39457, 39462, 39471, 27329, 22975, 27105, 27139, 27162,
27164, 27180, 27181, 27187, 27203, 27205, 27212, 27219, 27223, 27235,
27252, 27266, 27274, 27279, 27289, 27303, 27313, 27317, 27326, 27337,
27348, 27352, 27382, 27479, 27514, 27612, 27676, 27697, 27736, 27758,
27765, 27775, 27823, 27851, 27871, 27903, 27906, 27909, 27910, 27942,
27991, 27995, 28017, 28033, 28047, 28069, 28081, 28158, 28162, 28164,
28175, 28184, 28202, 28240, 28249, 28314, 28341, 28344, 28379,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 28410, 28420, 28427, 28428, 28438, 28439, 28468,
28477, 28502, 28537, 28554, 28573, 28575, 28603, 28606, 28627, 28633,
28664, 28675, 28747, 28749, 28752, 28756, 28764, 28775, 28791, 28793,
28811, 28815, 28832, 28835, 28837, 28838, 28839, 28868, 28876, 28880,
28886,   618,   603,   230,   652,   593,   596,   650,   605,   601,
  602,   604,   609,  7747,  7753,   330,  7739,   629,   240,   643,
  658,   679,   676,   227, 60294, 60295,   623,   632,   647, 60299,
  199,   339,   594, 65351,   715,   719, 65345, 65346, 65348, 65349,
65350, 65352, 65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360,
65362, 65363, 65364, 65365, 65366, 65367, 65370, 28917, 12832, 12833,
12834, 12835, 12836, 12837, 12838, 12839, 12840, 12841, 28926, 28933,
28957, 28969, 28971, 28972, 28979, 28981, 28987, 28990, 28992, 29007,
29035, 29045, 29047, 29052, 29054, 29068, 29070, 29073, 29078, 29090,
29091, 29101, 29108, 29111, 29114, 29137, 29149, 29163, 29184, 29193,
29198, 29199, 29206, 29207, 29220, 23204, 29230,  8838, 29271, 29276,
29332, 29444, 29456, 29505, 29556, 29580, 29583, 29592, 29596, 29598,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 29607, 29610, 29653, 29665, 29666, 29668,
29670, 29679, 29683,  8839, 29689, 29691, 29698, 29713, 29714, 29716,
29717, 29719, 29721, 29724, 29726, 29727, 29751, 29752, 29753, 29763,
29765, 29767, 29768, 29769, 29779, 29782, 29797, 29803, 29804, 29812,
29818, 29826, 21378, 24191, 20008, 24186, 20886, 23424, 21353, 11911,
60436, 21251,  9746, 33401, 17553, 11916, 11914, 20022, 60444, 21274,
60446, 60447, 11925, 60449, 60450,  9492, 20058, 36790, 24308, 20872,
20101, 60457, 20031, 60459, 60460, 20059, 21430, 36710, 32415, 35744,
36125, 40479, 38376, 38021, 38429, 25164, 27701, 20155, 24516, 28780,
11950, 21475, 27362, 39483, 39484, 39512, 39516, 39523,  9742,  8594,
 8592,  8593,  8595,  8680,  8678,  8679,  8681,  8680,  8678,  8679,
 8681,  9758,  9756,  9755,  9759, 12310, 12311,  9675, 10005, 10003,
22267,  9789, 22813, 26189, 29221, 10025, 10017,  9786,  9785, 60515,
60516, 60517, 60518, 60519, 23672,  9836,  9834, 23249, 23479, 23804,
60526,  9993,  9986, 60529, 60530, 60531, 60532, 23765, 26478, 29793,
29853, 32595, 34195, 10063, 60540, 60541, 23928, 24379, 60544,  9473,
 9475,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 60547, 60548, 60549, 60550, 60551,
60552, 60553, 60554, 60555, 60556, 60557, 60558, 60559, 60560, 60561,
39602, 39648, 39700, 39732, 39737, 39744, 39760, 39807,  9788, 32149,
 9729, 38708,  9730, 60575, 60576, 60577,  9992, 60579, 60580, 60581,
60582, 60583, 60584, 60585,  8507,  8481, 26343, 28247, 60590, 29015,
31178,  8470, 33132, 35577, 38998, 60597, 60598,  9760, 60600,  9828,
 9824,  9831,  9827,  9826,  9830,  9825,  9829, 60609, 60610, 27364,
 8478, 13250, 13272, 13217, 60616, 13221, 60618, 60619, 60620, 60621,
60622,  9745, 39809, 39819, 39821, 39901, 39913, 39917, 39924, 39967,
39968, 39974, 40019, 40029, 40059, 40204, 40214,  8626, 27397, 36073,
36082, 36099, 36113, 36124, 36218, 36265, 36288, 36353, 36366, 36422,
36456, 36465, 36478, 36480, 36534, 36537, 36540, 36547, 36580, 36589,
36594, 36656, 36673, 36682, 36773, 36787, 36792, 36810, 36815, 36872,
36915, 36919, 36964, 36972, 37289, 37302, 37316, 37370, 37384, 37395,
37409, 37416, 37419, 37429, 37436, 37441, 37464, 37469, 37471, 37483,
37486, 37505, 37508, 37513, 37519, 37553, 37562, 37567, 37588, 37595,
37603, 37605,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 37611, 37612, 37620, 37622,
37629, 37635, 37639, 37680, 37681, 37696, 37698, 37699, 37727, 37730,
37734, 37736, 37747, 37748, 37752, 37757, 37761, 37764, 37766, 37767,
37776, 37788, 37792, 37816, 37819, 37821, 37823, 37835, 37843, 37851,
37856, 37872, 37873, 37875, 37876, 37889, 37892, 37896, 37911, 37915,
37917, 37924, 37925, 37926, 37933, 37954, 37955, 37965, 37972, 37976,
37989, 37991, 37996, 38009, 38011, 38264, 38277, 38310, 38314, 38486,
38523, 38565, 38644, 38683, 38710, 38720, 38721, 38743, 38791, 38793,
38811, 38833, 38845, 38848, 38850, 38866, 38880, 38932, 38933, 38947,
38963, 39016, 39095, 39097, 39111, 39114, 39136, 39137, 39148, 39157,
40225, 40244, 40249, 40265, 40270, 40301,  8759, 40302, 40316, 40323,
40339, 40357,  8748, 40381, 27521, 27569, 40015, 40592, 40384, 60817,
60818,  9775,  9776,  9783,  9779,  9780,  9781,  9778,  9782,  9777,
40393, 40404, 40444, 40458, 40460, 40462, 40472, 40571, 40581, 40610,
40620, 40625, 40641, 40646, 40647, 40689, 40696, 40743, 39182, 39193,
39196, 39223, 39261, 39266, 39323, 39332, 39338, 39352, 39392, 39398,
39413, 39455, 32254,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 32263, 32347, 32357,
32364, 32567, 32576, 32577, 32585, 32594, 32655, 32659, 32692, 32733,
32743, 32762, 32770, 32776, 32814, 32815, 32828, 32935, 33036, 33066,
33076, 33090, 33110, 33156, 33189, 33252, 33364, 33381, 33403, 33415,
33471, 33506, 33518, 33528, 33532, 33535, 33547, 33565, 33597, 33623,
33681, 33708, 33741, 33773, 33797, 33812, 33814, 33825, 33838, 33854,
33866, 33875, 33877, 33880, 33892, 33906, 33919, 33920, 33938, 33939,
33942, 33955, 33982, 34014, 34017, 34018, 34020, 34040, 34051, 34053,
34064, 34099,  8208, 34114, 34124, 34130, 34143, 34159, 34160, 34163,
34262, 34272, 34286, 34300, 34317, 34319, 34324, 34344, 34370, 34373,
34418, 34972, 23405, 33079, 60958, 39224, 21874, 21867, 60962, 13774,
21873, 21946, 22001, 13778, 22000, 22021, 22050, 22061, 22083, 22046,
22162, 31949, 21530, 21523, 21655, 26353, 30004, 21581, 22180, 22175,
25811, 25390, 25592, 25886, 20088, 27626, 27698, 27709, 27746, 27826,
28152, 28201, 28278, 28290, 28294, 28347, 28383, 28386, 28433, 28452,
28532, 28561, 28597, 28659, 28661, 28859, 28864, 28943,  8706, 29013,
29043, 29050, 61016, 21027,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 61018, 13393,
61020, 36812, 61022, 61023,   192,   200,   204,   210,   217,   193,
  205,   211,   218,   257,   275,   299,   333,   363,   470,   196,
  203,   207,   214,   220,   198,   199,   209,   195,   213,   225,
  233,   237,   243,   250,   472,   228,   235,   239,   246,   252,
  230,   231,   241,   227,   245,   462,   283,   464,   466,   468,
  474,   197,   201, 29064,   216,   208,  7922,   222,   223,   170,
  161,   224,   232,   236,   242,   249,   476,   229, 29080, 29143,
  248,   240,  7923,   254,   255,   186,   191,   226,   234,   238,
  244,   251, 29173,   194,   202,   206,   212,   219,   184,   164,
61110,   402, 12288, 65292, 12289, 12290, 65294,  8231, 65307, 65306,
65311, 65281, 65072,  8230,  8229, 65104, 65105, 65106,   183, 65108,
65109, 65110, 65111, 65372,  8211, 65073,  8212, 65075,  9588, 65076,
65103, 65288, 65289, 65077, 65078, 65371, 65373, 65079, 65080, 12308,
12309, 65081, 65082, 12304, 12305, 65083, 65084, 12298, 12299, 65085,
65086, 12296, 12297, 65087, 65088, 12300, 12301, 65089, 65090, 12302,
12303, 65091, 65092, 65113, 65114,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 65115,
65116, 65117, 65118,  8216,  8217,  8220,  8221, 12317, 12318,  8245,
 8242, 65283, 65286, 65290,  8251,   167, 12291,  9675,  9679,  9651,
 9650,  9678,  9734,  9733,  9671,  9670,  9633,  9632,  9661,  9660,
12963,  8453,   175, 65507, 65343,   717, 65097, 65098, 65101, 65102,
65099, 65100, 65119, 65120, 65121, 65291, 65293,   215,   247,   177,
 8730, 65308, 65310, 65309,  8806,  8807,  8800,  8734,  8786,  8801,
65122, 65123, 65124, 65125, 65126, 65374,  8745,  8746,  8869,  8736,
 8735,  8895, 13266, 13265,  8747,  8750,  8757,  8756,  9792,  9794,
 8853,  8857,  8593,  8595,  8592,  8594,  8598,  8599,  8601,  8600,
 8741,  8739, 65295, 65340,  8725, 65128, 65284, 65509, 12306, 65504,
65505, 65285, 65312,  8451,  8457, 65129, 65130, 65131, 13269, 13212,
13213, 13214, 13262, 13217, 13198, 13199, 13252,   176, 20825, 20827,
20830, 20829, 20833, 20835, 21991, 29929, 31950,  9601,  9602,  9603,
 9604,  9605,  9606,  9607,  9608,  9615,  9614,  9613,  9612,  9611,
 9610,  9609,  9532,  9524,  9516,  9508,  9500,  9620,  9472,  9474,
 9621,  9484,  9488,  9492,  9496,  9581,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
 9582,  9584,  9583,  9552,  9566,  9578,  9569,  9698,  9699,  9701,
 9700,  9585,  9586,  9587, 65296, 65297, 65298, 65299, 65300, 65301,
65302, 65303, 65304, 65305,  8544,  8545,  8546,  8547,  8548,  8549,
 8550,  8551,  8552,  8553, 12321, 12322, 12323, 12324, 12325, 12326,
12327, 12328, 12329, 21313, 21316, 21317, 65313, 65314, 65315, 65316,
65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326,
65327, 65328, 65329, 65330, 65331, 65332, 65333, 65334, 65335, 65336,
65337, 65338, 65345, 65346, 65347, 65348, 65349, 65350, 65351, 65352,
65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360, 65361, 65362,
65363, 65364, 65365, 65366, 65367, 65368, 65369, 65370,   913,   914,
  915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
  925,   926,   927,   928,   929,   931,   932,   933,   934,   935,
  936,   937,   945,   946,   947,   948,   949,   950,   951,   952,
  953,   954,   955,   956,   957,   958,   959,   960,   961,   963,
  964,   965,   966,   967,   968,   969, 12549, 12550, 12551, 12552,
12553, 12554, 12555, 12556, 12557, 12558, 12559,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 12560, 12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568,
12569, 12570, 12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578,
12579, 12580, 12581, 12582, 12583, 12584, 12585,   729,   713,   714,
  711,   715,  9216,  9217,  9218,  9219,  9220,  9221,  9222,  9223,
 9224,  9225,  9226,  9227,  9228,  9229,  9230,  9231,  9232,  9233,
 9234,  9235,  9236,  9237,  9238,  9239,  9240,  9241,  9242,  9243,
 9244,  9245,  9246,  9247,  9249,  8364, 63561, 63562, 63563, 63564,
63565, 63566, 63567, 63568, 63569, 63570, 63571, 63572, 63573, 63574,
63575, 63576, 63577, 63578, 63579, 63580, 63581, 63582, 63583, 63584,
63585, 63586, 63587, 63588, 63589, 19968, 20057, 19969, 19971, 20035,
20061, 20102, 20108, 20154, 20799, 20837, 20843, 20960, 20992, 20993,
21147, 21269, 21313, 21340, 21448, 19977, 19979, 19976, 19978, 20011,
20024, 20961, 20037, 20040, 20063, 20062, 20110, 20129, 20800, 20995,
21242, 21315, 21449, 21475, 22303, 22763, 22805, 22823, 22899, 23376,
23377, 23379, 23544, 23567, 23586, 23608, 23665, 24029, 24037, 24049,
24050, 24051, 24062, 24178, 24318, 24331, 24339, 25165,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 19985, 19984, 19981, 20013, 20016, 20025, 20043, 23609,
20104, 20113, 20117, 20114, 20116, 20130, 20161, 20160, 20163, 20166,
20167, 20173, 20170, 20171, 20164, 20803, 20801, 20839, 20845, 20846,
20844, 20887, 20982, 20998, 20999, 21000, 21243, 21246, 21247, 21270,
21305, 21320, 21319, 21317, 21342, 21380, 21451, 21450, 21453, 22764,
22825, 22827, 22826, 22829, 23380, 23569, 23588, 23610, 23663, 24052,
24187, 24319, 24340, 24341, 24515, 25096, 25142, 25163, 25166, 25903,
25991, 26007, 26020, 26041, 26085, 26352, 26376, 26408, 27424, 27490,
27513, 27595, 27604, 27611, 27663, 27700, 28779, 29226, 29238, 29243,
29255, 29273, 29275, 29356, 29579, 19993, 19990, 19989, 19988, 19992,
20027, 20045, 20047, 20046, 20197, 20184, 20180, 20181, 20182, 20183,
20195, 20196, 20185, 20190, 20805, 20804, 20873, 20874, 20908, 20985,
20986, 20984, 21002, 21152, 21151, 21253, 21254, 21271, 21277, 20191,
21322, 21321, 21345, 21344, 21359, 21358, 21435, 21487, 21476, 21491,
21484, 21486, 21481, 21480, 21500, 21496, 21493, 21483, 21478, 21482,
21490, 21489, 21488, 21477, 21485, 21499, 22235, 22234, 22806,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 22830, 22833, 22900, 22902, 23381, 23427, 23612,
24040, 24039, 24038, 24066, 24067, 24179, 24188, 24321, 24344, 24343,
24517, 25098, 25171, 25172, 25170, 25169, 26021, 26086, 26414, 26412,
26410, 26411, 26413, 27491, 27597, 27665, 27664, 27704, 27713, 27712,
27710, 29359, 29572, 29577, 29916, 29926, 29976, 29983, 29992, 29993,
30000, 30001, 30002, 30003, 30091, 30333, 30382, 30399, 30446, 30683,
30690, 30707, 31034, 31166, 31348, 31435, 19998, 19999, 20050, 20051,
20073, 20121, 20132, 20134, 20133, 20223, 20233, 20249, 20234, 20245,
20237, 20240, 20241, 20239, 20210, 20214, 20219, 20208, 20211, 20221,
20225, 20235, 20809, 20807, 20806, 20808, 20840, 20849, 20877, 20912,
21015, 21009, 21010, 21006, 21014, 21155, 21256, 21281, 21280, 21360,
21361, 21513, 21519, 21516, 21514, 21520, 21505, 21515, 21508, 21521,
21517, 21512, 21507, 21518, 21510, 21522, 22240, 22238, 22237, 22323,
22320, 22312, 22317, 22316, 22319, 22313, 22809, 22810, 22839, 22840,
22916, 22904, 22915, 22909, 22905, 22914, 22913, 23383, 23384, 23431,
23432, 23429, 23433, 23546, 23574, 23673, 24030, 24070, 24182, 24180,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 24335, 24347, 24537, 24534, 25102, 25100,
25101, 25104, 25187, 25179, 25176, 25910, 26089, 26088, 26092, 26093,
26354, 26355, 26377, 26429, 26420, 26417, 26421, 27425, 27492, 27515,
27670, 27741, 27735, 27737, 27743, 27744, 27728, 27733, 27745, 27739,
27725, 27726, 28784, 29279, 29277, 30334, 31481, 31859, 31992, 32566,
32650, 32701, 32769, 32771, 32780, 32786, 32819, 32895, 32905, 32907,
32908, 33251, 33258, 33267, 33276, 33292, 33307, 33311, 33390, 33394,
33406, 34411, 34880, 34892, 34915, 35199, 38433, 20018, 20136, 20301,
20303, 20295, 20311, 20318, 20276, 20315, 20309, 20272, 20304, 20305,
20285, 20282, 20280, 20291, 20308, 20284, 20294, 20323, 20316, 20320,
20271, 20302, 20278, 20313, 20317, 20296, 20314, 20812, 20811, 20813,
20853, 20918, 20919, 21029, 21028, 21033, 21034, 21032, 21163, 21161,
21162, 21164, 21283, 21363, 21365, 21533, 21549, 21534, 21566, 21542,
21582, 21543, 21574, 21571, 21555, 21576, 21570, 21531, 21545, 21578,
21561, 21563, 21560, 21550, 21557, 21558, 21536, 21564, 21568, 21553,
21547, 21535, 21548, 22250, 22256, 22244, 22251, 22346, 22353, 22336,
22349,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 22343, 22350, 22334, 22352, 22351,
22331, 22767, 22846, 22941, 22930, 22952, 22942, 22947, 22937, 22934,
22925, 22948, 22931, 22922, 22949, 23389, 23388, 23386, 23387, 23436,
23435, 23439, 23596, 23616, 23617, 23615, 23614, 23696, 23697, 23700,
23692, 24043, 24076, 24207, 24199, 24202, 24311, 24324, 24351, 24420,
24418, 24439, 24441, 24536, 24524, 24535, 24525, 24561, 24555, 24568,
24554, 25106, 25105, 25220, 25239, 25238, 25216, 25206, 25225, 25197,
25226, 25212, 25214, 25209, 25203, 25234, 25199, 25240, 25198, 25237,
25235, 25233, 25222, 25913, 25915, 25912, 26097, 26356, 26463, 26446,
26447, 26448, 26449, 26460, 26454, 26462, 26441, 26438, 26464, 26451,
26455, 27493, 27599, 27714, 27742, 27801, 27777, 27784, 27785, 27781,
27803, 27754, 27770, 27792, 27760, 27788, 27752, 27798, 27794, 27773,
27779, 27762, 27774, 27764, 27782, 27766, 27789, 27796, 27800, 27778,
28790, 28796, 28797, 28792, 29282, 29281, 29280, 29380, 29378, 29590,
29996, 29995, 30007, 30008, 30338, 30447, 30691, 31169, 31168, 31167,
31350, 31995, 32597, 32918, 32915, 32925, 32920, 32923, 32922, 32946,
33391, 33426,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 33419, 33421, 35211, 35282,
35328, 35895, 35910, 35925, 35997, 36196, 36208, 36275, 36523, 36554,
36763, 36784, 36802, 36806, 36805, 36804, 24033, 37009, 37026, 37034,
37030, 37027, 37193, 37318, 37324, 38450, 38446, 38449, 38442, 38444,
20006, 20054, 20083, 20107, 20123, 20126, 20139, 20140, 20335, 20381,
20365, 20339, 20351, 20332, 20379, 20363, 20358, 20355, 20336, 20341,
20360, 20329, 20347, 20374, 20350, 20367, 20369, 20346, 20820, 20818,
20821, 20841, 20855, 20854, 20856, 20925, 20989, 21051, 21048, 21047,
21050, 21040, 21038, 21046, 21057, 21182, 21179, 21330, 21332, 21331,
21329, 21350, 21367, 21368, 21369, 21462, 21460, 21463, 21619, 21621,
21654, 21624, 21653, 21632, 21627, 21623, 21636, 21650, 21638, 21628,
21648, 21617, 21622, 21644, 21658, 21602, 21608, 21643, 21629, 21646,
22266, 22403, 22391, 22378, 22377, 22369, 22374, 22372, 22396, 22812,
22857, 22855, 22856, 22852, 22868, 22974, 22971, 22996, 22969, 22958,
22993, 22982, 22992, 22989, 22987, 22995, 22986, 22959, 22963, 22994,
22981, 23391, 23396, 23395, 23447, 23450, 23448, 23452, 23449, 23451,
23578, 23624, 23621,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 23622, 23735, 23713,
23736, 23721, 23723, 23729, 23731, 24088, 24090, 24086, 24085, 24091,
24081, 24184, 24218, 24215, 24220, 24213, 24214, 24310, 24358, 24359,
24361, 24448, 24449, 24447, 24444, 24541, 24544, 24573, 24565, 24575,
24591, 24596, 24623, 24629, 24598, 24618, 24597, 24609, 24615, 24617,
24619, 24603, 25110, 25109, 25151, 25150, 25152, 25215, 25289, 25292,
25284, 25279, 25282, 25273, 25298, 25307, 25259, 25299, 25300, 25291,
25288, 25256, 25277, 25276, 25296, 25305, 25287, 25293, 25269, 25306,
25265, 25304, 25302, 25303, 25286, 25260, 25294, 25918, 26023, 26044,
26106, 26132, 26131, 26124, 26118, 26114, 26126, 26112, 26127, 26133,
26122, 26119, 26381, 26379, 26477, 26507, 26517, 26481, 26524, 26483,
26487, 26503, 26525, 26519, 26479, 26480, 26495, 26505, 26494, 26512,
26485, 26522, 26515, 26492, 26474, 26482, 27427, 27494, 27495, 27519,
27667, 27675, 27875, 27880, 27891, 27825, 27852, 27877, 27827, 27837,
27838, 27836, 27874, 27819, 27861, 27859, 27832, 27844, 27833, 27841,
27822, 27863, 27845, 27889, 27839, 27835, 27873, 27867, 27850, 27820,
27887, 27868, 27862, 27872,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 28821, 28814,
28818, 28810, 28825, 29228, 29229, 29240, 29256, 29287, 29289, 29376,
29390, 29401, 29399, 29392, 29609, 29608, 29599, 29611, 29605, 30013,
30109, 30105, 30106, 30340, 30402, 30450, 30452, 30693, 30717, 31038,
31040, 31041, 31177, 31176, 31354, 31353, 31482, 31998, 32596, 32652,
32651, 32773, 32954, 32933, 32930, 32945, 32929, 32939, 32937, 32948,
32938, 32943, 33253, 33278, 33293, 33459, 33437, 33433, 33453, 33469,
33439, 33465, 33457, 33452, 33445, 33455, 33464, 33443, 33456, 33470,
33463, 34382, 34417, 21021, 34920, 36555, 36814, 36820, 36817, 37045,
37048, 37041, 37046, 37319, 37329, 38263, 38272, 38428, 38464, 38463,
38459, 38468, 38466, 38585, 38632, 38738, 38750, 20127, 20141, 20142,
20449, 20405, 20399, 20415, 20448, 20433, 20431, 20445, 20419, 20406,
20440, 20447, 20426, 20439, 20398, 20432, 20420, 20418, 20442, 20430,
20446, 20407, 20823, 20882, 20881, 20896, 21070, 21059, 21066, 21069,
21068, 21067, 21063, 21191, 21193, 21187, 21185, 21261, 21335, 21371,
21402, 21467, 21676, 21696, 21672, 21710, 21705, 21688, 21670, 21683,
21703, 21698, 21693, 21674, 21697,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 21700,
21704, 21679, 21675, 21681, 21691, 21673, 21671, 21695, 22271, 22402,
22411, 22432, 22435, 22434, 22478, 22446, 22419, 22869, 22865, 22863,
22862, 22864, 23004, 23000, 23039, 23011, 23016, 23043, 23013, 23018,
23002, 23014, 23041, 23035, 23401, 23459, 23462, 23460, 23458, 23461,
23553, 23630, 23631, 23629, 23627, 23769, 23762, 24055, 24093, 24101,
24095, 24189, 24224, 24230, 24314, 24328, 24365, 24421, 24456, 24453,
24458, 24459, 24455, 24460, 24457, 24594, 24605, 24608, 24613, 24590,
24616, 24653, 24688, 24680, 24674, 24646, 24643, 24684, 24683, 24682,
24676, 25153, 25308, 25366, 25353, 25340, 25325, 25345, 25326, 25341,
25351, 25329, 25335, 25327, 25324, 25342, 25332, 25361, 25346, 25919,
25925, 26027, 26045, 26082, 26149, 26157, 26144, 26151, 26159, 26143,
26152, 26161, 26148, 26359, 26623, 26579, 26609, 26580, 26576, 26604,
26550, 26543, 26613, 26601, 26607, 26564, 26577, 26548, 26586, 26597,
26552, 26575, 26590, 26611, 26544, 26585, 26594, 26589, 26578, 27498,
27523, 27526, 27573, 27602, 27607, 27679, 27849, 27915, 27954, 27946,
27969, 27941, 27916, 27953, 27934, 27927,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
27963, 27965, 27966, 27958, 27931, 27893, 27961, 27943, 27960, 27945,
27950, 27957, 27918, 27947, 28843, 28858, 28851, 28844, 28847, 28845,
28856, 28846, 28836, 29232, 29298, 29295, 29300, 29417, 29408, 29409,
29623, 29642, 29627, 29618, 29645, 29632, 29619, 29978, 29997, 30031,
30028, 30030, 30027, 30123, 30116, 30117, 30114, 30115, 30328, 30342,
30343, 30344, 30408, 30406, 30403, 30405, 30465, 30457, 30456, 30473,
30475, 30462, 30460, 30471, 30684, 30722, 30740, 30732, 30733, 31046,
31049, 31048, 31047, 31161, 31162, 31185, 31186, 31179, 31359, 31361,
31487, 31485, 31869, 32002, 32005, 32000, 32009, 32007, 32004, 32006,
32568, 32654, 32703, 32772, 32784, 32781, 32785, 32822, 32982, 32997,
32986, 32963, 32964, 32972, 32993, 32987, 32974, 32990, 32996, 32989,
33268, 33314, 33511, 33539, 33541, 33507, 33499, 33510, 33540, 33509,
33538, 33545, 33490, 33495, 33521, 33537, 33500, 33492, 33489, 33502,
33491, 33503, 33519, 33542, 34384, 34425, 34427, 34426, 34893, 34923,
35201, 35284, 35336, 35330, 35331, 35998, 36000, 36212, 36211, 36276,
36557, 36556, 36848, 36838, 36834, 36842, 36837,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 36845, 36843, 36836, 36840, 37066, 37070, 37057, 37059, 37195,
37194, 37325, 38274, 38480, 38475, 38476, 38477, 38754, 38761, 38859,
38893, 38899, 38913, 39080, 39131, 39135, 39318, 39321, 20056, 20147,
20492, 20493, 20515, 20463, 20518, 20517, 20472, 20521, 20502, 20486,
20540, 20511, 20506, 20498, 20497, 20474, 20480, 20500, 20520, 20465,
20513, 20491, 20505, 20504, 20467, 20462, 20525, 20522, 20478, 20523,
20489, 20860, 20900, 20901, 20898, 20941, 20940, 20934, 20939, 21078,
21084, 21076, 21083, 21085, 21290, 21375, 21407, 21405, 21471, 21736,
21776, 21761, 21815, 21756, 21733, 21746, 21766, 21754, 21780, 21737,
21741, 21729, 21769, 21742, 21738, 21734, 21799, 21767, 21757, 21775,
22275, 22276, 22466, 22484, 22475, 22467, 22537, 22799, 22871, 22872,
22874, 23057, 23064, 23068, 23071, 23067, 23059, 23020, 23072, 23075,
23081, 23077, 23052, 23049, 23403, 23640, 23472, 23475, 23478, 23476,
23470, 23477, 23481, 23480, 23556, 23633, 23637, 23632, 23789, 23805,
23803, 23786, 23784, 23792, 23798, 23809, 23796, 24046, 24109, 24107,
24235, 24237, 24231, 24369, 24466, 24465, 24464, 24665,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 24675, 24677, 24656, 24661, 24685, 24681, 24687, 24708,
24735, 24730, 24717, 24724, 24716, 24709, 24726, 25159, 25331, 25352,
25343, 25422, 25406, 25391, 25429, 25410, 25414, 25423, 25417, 25402,
25424, 25405, 25386, 25387, 25384, 25421, 25420, 25928, 25929, 26009,
26049, 26053, 26178, 26185, 26191, 26179, 26194, 26188, 26181, 26177,
26360, 26388, 26389, 26391, 26657, 26680, 26696, 26694, 26707, 26681,
26690, 26708, 26665, 26803, 26647, 26700, 26705, 26685, 26612, 26704,
26688, 26684, 26691, 26666, 26693, 26643, 26648, 26689, 27530, 27529,
27575, 27683, 27687, 27688, 27686, 27684, 27888, 28010, 28053, 28040,
28039, 28006, 28024, 28023, 27993, 28051, 28012, 28041, 28014, 27994,
28020, 28009, 28044, 28042, 28025, 28037, 28005, 28052, 28874, 28888,
28900, 28889, 28872, 28879, 29241, 29305, 29436, 29433, 29437, 29432,
29431, 29574, 29677, 29705, 29678, 29664, 29674, 29662, 30036, 30045,
30044, 30042, 30041, 30142, 30149, 30151, 30130, 30131, 30141, 30140,
30137, 30146, 30136, 30347, 30384, 30410, 30413, 30414, 30505, 30495,
30496, 30504, 30697, 30768, 30759, 30776, 30749, 30772, 30775,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 30757, 30765, 30752, 30751, 30770, 31061, 31056,
31072, 31071, 31062, 31070, 31069, 31063, 31066, 31204, 31203, 31207,
31199, 31206, 31209, 31192, 31364, 31368, 31449, 31494, 31505, 31881,
32033, 32023, 32011, 32010, 32032, 32034, 32020, 32016, 32021, 32026,
32028, 32013, 32025, 32027, 32570, 32607, 32660, 32709, 32705, 32774,
32792, 32789, 32793, 32791, 32829, 32831, 33009, 33026, 33008, 33029,
33005, 33012, 33030, 33016, 33011, 33032, 33021, 33034, 33020, 33007,
33261, 33260, 33280, 33296, 33322, 33323, 33320, 33324, 33467, 33579,
33618, 33620, 33610, 33592, 33616, 33609, 33589, 33588, 33615, 33586,
33593, 33590, 33559, 33600, 33585, 33576, 33603, 34388, 34442, 34474,
34451, 34468, 34473, 34444, 34467, 34460, 34928, 34935, 34945, 34946,
34941, 34937, 35352, 35344, 35342, 35340, 35349, 35338, 35351, 35347,
35350, 35343, 35345, 35912, 35962, 35961, 36001, 36002, 36215, 36524,
36562, 36564, 36559, 36785, 36865, 36870, 36855, 36864, 36858, 36852,
36867, 36861, 36869, 36856, 37013, 37089, 37085, 37090, 37202, 37197,
37196, 37336, 37341, 37335, 37340, 37337, 38275, 38498, 38499, 38497,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 38491, 38493, 38500, 38488, 38494, 38587,
39138, 39340, 39592, 39640, 39717, 39730, 39740, 20094, 20602, 20605,
20572, 20551, 20547, 20556, 20570, 20553, 20581, 20598, 20558, 20565,
20597, 20596, 20599, 20559, 20495, 20591, 20589, 20828, 20885, 20976,
21098, 21103, 21202, 21209, 21208, 21205, 21264, 21263, 21273, 21311,
21312, 21310, 21443, 26364, 21830, 21866, 21862, 21828, 21854, 21857,
21827, 21834, 21809, 21846, 21839, 21845, 21807, 21860, 21816, 21806,
21852, 21804, 21859, 21811, 21825, 21847, 22280, 22283, 22281, 22495,
22533, 22538, 22534, 22496, 22500, 22522, 22530, 22581, 22519, 22521,
22816, 22882, 23094, 23105, 23113, 23142, 23146, 23104, 23100, 23138,
23130, 23110, 23114, 23408, 23495, 23493, 23492, 23490, 23487, 23494,
23561, 23560, 23559, 23648, 23644, 23645, 23815, 23814, 23822, 23835,
23830, 23842, 23825, 23849, 23828, 23833, 23844, 23847, 23831, 24034,
24120, 24118, 24115, 24119, 24247, 24248, 24246, 24245, 24254, 24373,
24375, 24407, 24428, 24425, 24427, 24471, 24473, 24478, 24472, 24481,
24480, 24476, 24703, 24739, 24713, 24736, 24744, 24779, 24756, 24806,
24765,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 24773, 24763, 24757, 24796, 24764,
24792, 24789, 24774, 24799, 24760, 24794, 24775, 25114, 25115, 25160,
25504, 25511, 25458, 25494, 25506, 25509, 25463, 25447, 25496, 25514,
25457, 25513, 25481, 25475, 25499, 25451, 25512, 25476, 25480, 25497,
25505, 25516, 25490, 25487, 25472, 25467, 25449, 25448, 25466, 25949,
25942, 25937, 25945, 25943, 21855, 25935, 25944, 25941, 25940, 26012,
26011, 26028, 26063, 26059, 26060, 26062, 26205, 26202, 26212, 26216,
26214, 26206, 26361, 21207, 26395, 26753, 26799, 26786, 26771, 26805,
26751, 26742, 26801, 26791, 26775, 26800, 26755, 26820, 26797, 26758,
26757, 26772, 26781, 26792, 26783, 26785, 26754, 27442, 27578, 27627,
27628, 27691, 28046, 28092, 28147, 28121, 28082, 28129, 28108, 28132,
28155, 28154, 28165, 28103, 28107, 28079, 28113, 28078, 28126, 28153,
28088, 28151, 28149, 28101, 28114, 28186, 28085, 28122, 28139, 28120,
28138, 28145, 28142, 28136, 28102, 28100, 28074, 28140, 28095, 28134,
28921, 28937, 28938, 28925, 28911, 29245, 29309, 29313, 29468, 29467,
29462, 29459, 29465, 29575, 29701, 29706, 29699, 29702, 29694, 29709,
29920, 29942,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 29943, 29980, 29986, 30053,
30054, 30050, 30064, 30095, 30164, 30165, 30133, 30154, 30157, 30350,
30420, 30418, 30427, 30519, 30526, 30524, 30518, 30520, 30522, 30827,
30787, 30798, 31077, 31080, 31085, 31227, 31378, 31381, 31520, 31528,
31515, 31532, 31526, 31513, 31518, 31534, 31890, 31895, 31893, 32070,
32067, 32113, 32046, 32057, 32060, 32064, 32048, 32051, 32068, 32047,
32066, 32050, 32049, 32573, 32670, 32666, 32716, 32718, 32722, 32796,
32842, 32838, 33071, 33046, 33059, 33067, 33065, 33072, 33060, 33282,
33333, 33335, 33334, 33337, 33678, 33694, 33688, 33656, 33698, 33686,
33725, 33707, 33682, 33674, 33683, 33673, 33696, 33655, 33659, 33660,
33670, 33703, 34389, 24426, 34503, 34496, 34486, 34500, 34485, 34502,
34507, 34481, 34479, 34505, 34899, 34974, 34952, 34987, 34962, 34966,
34957, 34955, 35219, 35215, 35370, 35357, 35363, 35365, 35377, 35373,
35359, 35355, 35362, 35913, 35930, 36009, 36012, 36011, 36008, 36010,
36007, 36199, 36198, 36286, 36282, 36571, 36575, 36889, 36877, 36890,
36887, 36899, 36895, 36893, 36880, 36885, 36894, 36896, 36879, 36898,
36886, 36891, 36884,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 37096, 37101, 37117,
37207, 37326, 37365, 37350, 37347, 37351, 37357, 37353, 38281, 38506,
38517, 38515, 38520, 38512, 38516, 38518, 38519, 38508, 38592, 38634,
38633, 31456, 31455, 38914, 38915, 39770, 40165, 40565, 40575, 40613,
40635, 20642, 20621, 20613, 20633, 20625, 20608, 20630, 20632, 20634,
26368, 20977, 21106, 21108, 21109, 21097, 21214, 21213, 21211, 21338,
21413, 21883, 21888, 21927, 21884, 21898, 21917, 21912, 21890, 21916,
21930, 21908, 21895, 21899, 21891, 21939, 21934, 21919, 21822, 21938,
21914, 21947, 21932, 21937, 21886, 21897, 21931, 21913, 22285, 22575,
22570, 22580, 22564, 22576, 22577, 22561, 22557, 22560, 22777, 22778,
22880, 23159, 23194, 23167, 23186, 23195, 23207, 23411, 23409, 23506,
23500, 23507, 23504, 23562, 23563, 23601, 23884, 23888, 23860, 23879,
24061, 24133, 24125, 24128, 24131, 24190, 24266, 24257, 24258, 24260,
24380, 24429, 24489, 24490, 24488, 24785, 24801, 24754, 24758, 24800,
24860, 24867, 24826, 24853, 24816, 24827, 24820, 24936, 24817, 24846,
24822, 24841, 24832, 24850, 25119, 25161, 25507, 25484, 25551, 25536,
25577, 25545, 25542, 25549,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 25554, 25571,
25552, 25569, 25558, 25581, 25582, 25462, 25588, 25578, 25563, 25682,
25562, 25593, 25950, 25958, 25954, 25955, 26001, 26000, 26031, 26222,
26224, 26228, 26230, 26223, 26257, 26234, 26238, 26231, 26366, 26367,
26399, 26397, 26874, 26837, 26848, 26840, 26839, 26885, 26847, 26869,
26862, 26855, 26873, 26834, 26866, 26851, 26827, 26829, 26893, 26898,
26894, 26825, 26842, 26990, 26875, 27454, 27450, 27453, 27544, 27542,
27580, 27631, 27694, 27695, 27692, 28207, 28216, 28244, 28193, 28210,
28263, 28234, 28192, 28197, 28195, 28187, 28251, 28248, 28196, 28246,
28270, 28205, 28198, 28271, 28212, 28237, 28218, 28204, 28227, 28189,
28222, 28363, 28297, 28185, 28238, 28259, 28228, 28274, 28265, 28255,
28953, 28954, 28966, 28976, 28961, 28982, 29038, 28956, 29260, 29316,
29312, 29494, 29477, 29492, 29481, 29754, 29738, 29747, 29730, 29733,
29749, 29750, 29748, 29743, 29723, 29734, 29736, 29989, 29990, 30059,
30058, 30178, 30171, 30179, 30169, 30168, 30174, 30176, 30331, 30332,
30358, 30355, 30388, 30428, 30543, 30701, 30813, 30828, 30831, 31245,
31240, 31243, 31237, 31232, 31384,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 31383,
31382, 31461, 31459, 31561, 31574, 31558, 31568, 31570, 31572, 31565,
31563, 31567, 31569, 31903, 31909, 32094, 32080, 32104, 32085, 32043,
32110, 32114, 32097, 32102, 32098, 32112, 32115, 21892, 32724, 32725,
32779, 32850, 32901, 33109, 33108, 33099, 33105, 33102, 33081, 33094,
33086, 33100, 33107, 33140, 33298, 33308, 33769, 33795, 33784, 33805,
33760, 33733, 33803, 33729, 33775, 33777, 33780, 33879, 33802, 33776,
33804, 33740, 33789, 33778, 33738, 33848, 33806, 33796, 33756, 33799,
33748, 33759, 34395, 34527, 34521, 34541, 34516, 34523, 34532, 34512,
34526, 34903, 35009, 35010, 34993, 35203, 35222, 35387, 35424, 35413,
35422, 35388, 35393, 35412, 35419, 35408, 35398, 35380, 35386, 35382,
35414, 35937, 35970, 36015, 36028, 36019, 36029, 36033, 36027, 36032,
36020, 36023, 36022, 36031, 36024, 36234, 36229, 36225, 36302, 36317,
36299, 36314, 36305, 36300, 36315, 36294, 36603, 36600, 36604, 36764,
36910, 36917, 36913, 36920, 36914, 36918, 37122, 37109, 37129, 37118,
37219, 37221, 37327, 37396, 37397, 37411, 37385, 37406, 37389, 37392,
37383, 37393, 38292, 38287, 38283, 38289,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
38291, 38290, 38286, 38538, 38542, 38539, 38525, 38533, 38534, 38541,
38514, 38532, 38593, 38597, 38596, 38598, 38599, 38639, 38642, 38860,
38917, 38918, 38920, 39143, 39146, 39151, 39145, 39154, 39149, 39342,
39341, 40643, 40653, 40657, 20098, 20653, 20661, 20658, 20659, 20677,
20670, 20652, 20663, 20667, 20655, 20679, 21119, 21111, 21117, 21215,
21222, 21220, 21218, 21219, 21295, 21983, 21992, 21971, 21990, 21966,
21980, 21959, 21969, 21987, 21988, 21999, 21978, 21985, 21957, 21958,
21989, 21961, 22290, 22291, 22622, 22609, 22616, 22615, 22618, 22612,
22635, 22604, 22637, 22602, 22626, 22610, 22603, 22887, 23233, 23241,
23244, 23230, 23229, 23228, 23219, 23234, 23218, 23913, 23919, 24140,
24185, 24265, 24264, 24338, 24409, 24492, 24494, 24858, 24847, 24904,
24863, 24819, 24859, 24825, 24833, 24840, 24910, 24908, 24900, 24909,
24894, 24884, 24871, 24845, 24838, 24887, 25121, 25122, 25619, 25662,
25630, 25642, 25645, 25661, 25644, 25615, 25628, 25620, 25613, 25654,
25622, 25623, 25606, 25964, 26015, 26032, 26263, 26249, 26247, 26248,
26262, 26244, 26264, 26253, 26371, 27028, 26989,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 26970, 26999, 26976, 26964, 26997, 26928, 27010, 26954, 26984,
26987, 26974, 26963, 27001, 27014, 26973, 26979, 26971, 27463, 27506,
27584, 27583, 27603, 27645, 28322, 28335, 28371, 28342, 28354, 28304,
28317, 28359, 28357, 28325, 28312, 28348, 28346, 28331, 28369, 28310,
28316, 28356, 28372, 28330, 28327, 28340, 29006, 29017, 29033, 29028,
29001, 29031, 29020, 29036, 29030, 29004, 29029, 29022, 28998, 29032,
29014, 29242, 29266, 29495, 29509, 29503, 29502, 29807, 29786, 29781,
29791, 29790, 29761, 29759, 29785, 29787, 29788, 30070, 30072, 30208,
30192, 30209, 30194, 30193, 30202, 30207, 30196, 30195, 30430, 30431,
30555, 30571, 30566, 30558, 30563, 30585, 30570, 30572, 30556, 30565,
30568, 30562, 30702, 30862, 30896, 30871, 30872, 30860, 30857, 30844,
30865, 30867, 30847, 31098, 31103, 31105, 33836, 31165, 31260, 31258,
31264, 31252, 31263, 31262, 31391, 31392, 31607, 31680, 31584, 31598,
31591, 31921, 31923, 31925, 32147, 32121, 32145, 32129, 32143, 32091,
32622, 32617, 32618, 32626, 32681, 32680, 32676, 32854, 32856, 32902,
32900, 33137, 33136, 33144, 33125, 33134, 33139, 33131,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 33145, 33146, 33126, 33285, 33351, 33922, 33911, 33853,
33841, 33909, 33894, 33899, 33865, 33900, 33883, 33852, 33845, 33889,
33891, 33897, 33901, 33862, 34398, 34396, 34399, 34553, 34579, 34568,
34567, 34560, 34558, 34555, 34562, 34563, 34566, 34570, 34905, 35039,
35028, 35033, 35036, 35032, 35037, 35041, 35018, 35029, 35026, 35228,
35299, 35435, 35442, 35443, 35430, 35433, 35440, 35463, 35452, 35427,
35488, 35441, 35461, 35437, 35426, 35438, 35436, 35449, 35451, 35390,
35432, 35938, 35978, 35977, 36042, 36039, 36040, 36036, 36018, 36035,
36034, 36037, 36321, 36319, 36328, 36335, 36339, 36346, 36330, 36324,
36326, 36530, 36611, 36617, 36606, 36618, 36767, 36786, 36939, 36938,
36947, 36930, 36948, 36924, 36949, 36944, 36935, 36943, 36942, 36941,
36945, 36926, 36929, 37138, 37143, 37228, 37226, 37225, 37321, 37431,
37463, 37432, 37437, 37440, 37438, 37467, 37451, 37476, 37457, 37428,
37449, 37453, 37445, 37433, 37439, 37466, 38296, 38552, 38548, 38549,
38605, 38603, 38601, 38602, 38647, 38651, 38649, 38646, 38742, 38772,
38774, 38928, 38929, 38931, 38922, 38930, 38924, 39164, 39156,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 39165, 39166, 39347, 39345, 39348, 39649, 40169,
40578, 40718, 40723, 40736, 20711, 20718, 20709, 20694, 20717, 20698,
20693, 20687, 20689, 20721, 20686, 20713, 20834, 20979, 21123, 21122,
21297, 21421, 22014, 22016, 22043, 22039, 22013, 22036, 22022, 22025,
22029, 22030, 22007, 22038, 22047, 22024, 22032, 22006, 22296, 22294,
22645, 22654, 22659, 22675, 22666, 22649, 22661, 22653, 22781, 22821,
22818, 22820, 22890, 22889, 23265, 23270, 23273, 23255, 23254, 23256,
23267, 23413, 23518, 23527, 23521, 23525, 23526, 23528, 23522, 23524,
23519, 23565, 23650, 23940, 23943, 24155, 24163, 24149, 24151, 24148,
24275, 24278, 24330, 24390, 24432, 24505, 24903, 24895, 24907, 24951,
24930, 24931, 24927, 24922, 24920, 24949, 25130, 25735, 25688, 25684,
25764, 25720, 25695, 25722, 25681, 25703, 25652, 25709, 25723, 25970,
26017, 26071, 26070, 26274, 26280, 26269, 27036, 27048, 27029, 27073,
27054, 27091, 27083, 27035, 27063, 27067, 27051, 27060, 27088, 27085,
27053, 27084, 27046, 27075, 27043, 27465, 27468, 27699, 28467, 28436,
28414, 28435, 28404, 28457, 28478, 28448, 28460, 28431, 28418, 28450,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 28415, 28399, 28422, 28465, 28472, 28466,
28451, 28437, 28459, 28463, 28552, 28458, 28396, 28417, 28402, 28364,
28407, 29076, 29081, 29053, 29066, 29060, 29074, 29246, 29330, 29334,
29508, 29520, 29796, 29795, 29802, 29808, 29805, 29956, 30097, 30247,
30221, 30219, 30217, 30227, 30433, 30435, 30596, 30589, 30591, 30561,
30913, 30879, 30887, 30899, 30889, 30883, 31118, 31119, 31117, 31278,
31281, 31402, 31401, 31469, 31471, 31649, 31637, 31627, 31605, 31639,
31645, 31636, 31631, 31672, 31623, 31620, 31929, 31933, 31934, 32187,
32176, 32156, 32189, 32190, 32160, 32202, 32180, 32178, 32177, 32186,
32162, 32191, 32181, 32184, 32173, 32210, 32199, 32172, 32624, 32736,
32737, 32735, 32862, 32858, 32903, 33104, 33152, 33167, 33160, 33162,
33151, 33154, 33255, 33274, 33287, 33300, 33310, 33355, 33993, 33983,
33990, 33988, 33945, 33950, 33970, 33948, 33995, 33976, 33984, 34003,
33936, 33980, 34001, 33994, 34623, 34588, 34619, 34594, 34597, 34612,
34584, 34645, 34615, 34601, 35059, 35074, 35060, 35065, 35064, 35069,
35048, 35098, 35055, 35494, 35468, 35486, 35491, 35469, 35489, 35475,
35492,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 35498, 35493, 35496, 35480, 35473,
35482, 35495, 35946, 35981, 35980, 36051, 36049, 36050, 36203, 36249,
36245, 36348, 36628, 36626, 36629, 36627, 36771, 36960, 36952, 36956,
36963, 36953, 36958, 36962, 36957, 36955, 37145, 37144, 37150, 37237,
37240, 37239, 37236, 37496, 37504, 37509, 37528, 37526, 37499, 37523,
37532, 37544, 37500, 37521, 38305, 38312, 38313, 38307, 38309, 38308,
38553, 38556, 38555, 38604, 38610, 38656, 38780, 38789, 38902, 38935,
38936, 39087, 39089, 39171, 39173, 39180, 39177, 39361, 39599, 39600,
39654, 39745, 39746, 40180, 40182, 40179, 40636, 40763, 40778, 20740,
20736, 20731, 20725, 20729, 20738, 20744, 20745, 20741, 20956, 21127,
21128, 21129, 21133, 21130, 21232, 21426, 22062, 22075, 22073, 22066,
22079, 22068, 22057, 22099, 22094, 22103, 22132, 22070, 22063, 22064,
22656, 22687, 22686, 22707, 22684, 22702, 22697, 22694, 22893, 23305,
23291, 23307, 23285, 23308, 23304, 23534, 23532, 23529, 23531, 23652,
23653, 23965, 23956, 24162, 24159, 24161, 24290, 24282, 24287, 24285,
24291, 24288, 24392, 24433, 24503, 24501, 24950, 24935, 24942, 24925,
24917, 24962,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 24956, 24944, 24939, 24958,
24999, 24976, 25003, 24974, 25004, 24986, 24996, 24980, 25006, 25134,
25705, 25711, 25721, 25758, 25778, 25736, 25744, 25776, 25765, 25747,
25749, 25769, 25746, 25774, 25773, 25771, 25754, 25772, 25753, 25762,
25779, 25973, 25975, 25976, 26286, 26283, 26292, 26289, 27171, 27167,
27112, 27137, 27166, 27161, 27133, 27169, 27155, 27146, 27123, 27138,
27141, 27117, 27153, 27472, 27470, 27556, 27589, 27590, 28479, 28540,
28548, 28497, 28518, 28500, 28550, 28525, 28507, 28536, 28526, 28558,
28538, 28528, 28516, 28567, 28504, 28373, 28527, 28512, 28511, 29087,
29100, 29105, 29096, 29270, 29339, 29518, 29527, 29801, 29835, 29827,
29822, 29824, 30079, 30240, 30249, 30239, 30244, 30246, 30241, 30242,
30362, 30394, 30436, 30606, 30599, 30604, 30609, 30603, 30923, 30917,
30906, 30922, 30910, 30933, 30908, 30928, 31295, 31292, 31296, 31293,
31287, 31291, 31407, 31406, 31661, 31665, 31684, 31668, 31686, 31687,
31681, 31648, 31692, 31946, 32224, 32244, 32239, 32251, 32216, 32236,
32221, 32232, 32227, 32218, 32222, 32233, 32158, 32217, 32242, 32249,
32629, 32631, 32687,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 32745, 32806, 33179,
33180, 33181, 33184, 33178, 33176, 34071, 34109, 34074, 34030, 34092,
34093, 34067, 34065, 34083, 34081, 34068, 34028, 34085, 34047, 34054,
34690, 34676, 34678, 34656, 34662, 34680, 34664, 34649, 34647, 34636,
34643, 34907, 34909, 35088, 35079, 35090, 35091, 35093, 35082, 35516,
35538, 35527, 35524, 35477, 35531, 35576, 35506, 35529, 35522, 35519,
35504, 35542, 35533, 35510, 35513, 35547, 35916, 35918, 35948, 36064,
36062, 36070, 36068, 36076, 36077, 36066, 36067, 36060, 36074, 36065,
36205, 36255, 36259, 36395, 36368, 36381, 36386, 36367, 36393, 36383,
36385, 36382, 36538, 36637, 36635, 36639, 36649, 36646, 36650, 36636,
36638, 36645, 36969, 36974, 36968, 36973, 36983, 37168, 37165, 37159,
37169, 37255, 37257, 37259, 37251, 37573, 37563, 37559, 37610, 37548,
37604, 37569, 37555, 37564, 37586, 37575, 37616, 37554, 38317, 38321,
38660, 38662, 38663, 38665, 38752, 38797, 38795, 38799, 38945, 38955,
38940, 39091, 39178, 39187, 39186, 39192, 39389, 39376, 39391, 39387,
39377, 39381, 39378, 39385, 39607, 39662, 39663, 39719, 39749, 39748,
39799, 39791, 40198, 40201,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 40195, 40617,
40638, 40654, 22696, 40786, 20754, 20760, 20756, 20752, 20757, 20864,
20906, 20957, 21137, 21139, 21235, 22105, 22123, 22137, 22121, 22116,
22136, 22122, 22120, 22117, 22129, 22127, 22124, 22114, 22134, 22721,
22718, 22727, 22725, 22894, 23325, 23348, 23416, 23536, 23566, 24394,
25010, 24977, 25001, 24970, 25037, 25014, 25022, 25034, 25032, 25136,
25797, 25793, 25803, 25787, 25788, 25818, 25796, 25799, 25794, 25805,
25791, 25810, 25812, 25790, 25972, 26310, 26313, 26297, 26308, 26311,
26296, 27197, 27192, 27194, 27225, 27243, 27224, 27193, 27204, 27234,
27233, 27211, 27207, 27189, 27231, 27208, 27481, 27511, 27653, 28610,
28593, 28577, 28611, 28580, 28609, 28583, 28595, 28608, 28601, 28598,
28582, 28576, 28596, 29118, 29129, 29136, 29138, 29128, 29141, 29113,
29134, 29145, 29148, 29123, 29124, 29544, 29852, 29859, 29848, 29855,
29854, 29922, 29964, 29965, 30260, 30264, 30266, 30439, 30437, 30624,
30622, 30623, 30629, 30952, 30938, 30956, 30951, 31142, 31309, 31310,
31302, 31308, 31307, 31418, 31705, 31761, 31689, 31716, 31707, 31713,
31721, 31718, 31957, 31958, 32266,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 32273,
32264, 32283, 32291, 32286, 32285, 32265, 32272, 32633, 32690, 32752,
32753, 32750, 32808, 33203, 33193, 33192, 33275, 33288, 33368, 33369,
34122, 34137, 34120, 34152, 34153, 34115, 34121, 34157, 34154, 34142,
34691, 34719, 34718, 34722, 34701, 34913, 35114, 35122, 35109, 35115,
35105, 35242, 35238, 35558, 35578, 35563, 35569, 35584, 35548, 35559,
35566, 35582, 35585, 35586, 35575, 35565, 35571, 35574, 35580, 35947,
35949, 35987, 36084, 36420, 36401, 36404, 36418, 36409, 36405, 36667,
36655, 36664, 36659, 36776, 36774, 36981, 36980, 36984, 36978, 36988,
36986, 37172, 37266, 37664, 37686, 37624, 37683, 37679, 37666, 37628,
37675, 37636, 37658, 37648, 37670, 37665, 37653, 37678, 37657, 38331,
38567, 38568, 38570, 38613, 38670, 38673, 38678, 38669, 38675, 38671,
38747, 38748, 38758, 38808, 38960, 38968, 38971, 38967, 38957, 38969,
38948, 39184, 39208, 39198, 39195, 39201, 39194, 39405, 39394, 39409,
39608, 39612, 39675, 39661, 39720, 39825, 40213, 40227, 40230, 40232,
40210, 40219, 40664, 40660, 40845, 40860, 20778, 20767, 20769, 20786,
21237, 22158, 22144, 22160, 22149, 22151,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
22159, 22741, 22739, 22737, 22734, 23344, 23338, 23332, 23418, 23607,
23656, 23996, 23994, 23997, 23992, 24171, 24396, 24509, 25033, 25026,
25031, 25062, 25035, 25138, 25140, 25806, 25802, 25816, 25824, 25840,
25830, 25836, 25841, 25826, 25837, 25986, 25987, 26329, 26326, 27264,
27284, 27268, 27298, 27292, 27355, 27299, 27262, 27287, 27280, 27296,
27484, 27566, 27610, 27656, 28632, 28657, 28639, 28640, 28635, 28644,
28651, 28655, 28544, 28652, 28641, 28649, 28629, 28654, 28656, 29159,
29151, 29166, 29158, 29157, 29165, 29164, 29172, 29152, 29237, 29254,
29552, 29554, 29865, 29872, 29862, 29864, 30278, 30274, 30284, 30442,
30643, 30634, 30640, 30636, 30631, 30637, 30703, 30967, 30970, 30964,
30959, 30977, 31143, 31146, 31319, 31423, 31751, 31757, 31742, 31735,
31756, 31712, 31968, 31964, 31966, 31970, 31967, 31961, 31965, 32302,
32318, 32326, 32311, 32306, 32323, 32299, 32317, 32305, 32325, 32321,
32308, 32313, 32328, 32309, 32319, 32303, 32580, 32755, 32764, 32881,
32882, 32880, 32879, 32883, 33222, 33219, 33210, 33218, 33216, 33215,
33213, 33225, 33214, 33256, 33289, 33393, 34218,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 34180, 34174, 34204, 34193, 34196, 34223, 34203, 34183, 34216,
34186, 34407, 34752, 34769, 34739, 34770, 34758, 34731, 34747, 34746,
34760, 34763, 35131, 35126, 35140, 35128, 35133, 35244, 35598, 35607,
35609, 35611, 35594, 35616, 35613, 35588, 35600, 35905, 35903, 35955,
36090, 36093, 36092, 36088, 36091, 36264, 36425, 36427, 36424, 36426,
36676, 36670, 36674, 36677, 36671, 36991, 36989, 36996, 36993, 36994,
36992, 37177, 37283, 37278, 37276, 37709, 37762, 37672, 37749, 37706,
37733, 37707, 37656, 37758, 37740, 37723, 37744, 37722, 37716, 38346,
38347, 38348, 38344, 38342, 38577, 38584, 38614, 38684, 38686, 38816,
38867, 38982, 39094, 39221, 39425, 39423, 39854, 39851, 39850, 39853,
40251, 40255, 40587, 40655, 40670, 40668, 40669, 40667, 40766, 40779,
21474, 22165, 22190, 22745, 22744, 23352, 24413, 25059, 25139, 25844,
25842, 25854, 25862, 25850, 25851, 25847, 26039, 26332, 26406, 27315,
27308, 27331, 27323, 27320, 27330, 27310, 27311, 27487, 27512, 27567,
28681, 28683, 28670, 28678, 28666, 28689, 28687, 29179, 29180, 29182,
29176, 29559, 29557, 29863, 29887, 29973, 30294, 30296,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 30290, 30653, 30655, 30651, 30652, 30990, 31150, 31329,
31330, 31328, 31428, 31429, 31787, 31783, 31786, 31774, 31779, 31777,
31975, 32340, 32341, 32350, 32346, 32353, 32338, 32345, 32584, 32761,
32763, 32887, 32886, 33229, 33231, 33290, 34255, 34217, 34253, 34256,
34249, 34224, 34234, 34233, 34214, 34799, 34796, 34802, 34784, 35206,
35250, 35316, 35624, 35641, 35628, 35627, 35920, 36101, 36441, 36451,
36454, 36452, 36447, 36437, 36544, 36681, 36685, 36999, 36995, 37000,
37291, 37292, 37328, 37780, 37770, 37782, 37794, 37811, 37806, 37804,
37808, 37784, 37786, 37783, 38356, 38358, 38352, 38357, 38626, 38620,
38617, 38619, 38622, 38692, 38819, 38822, 38829, 38905, 38989, 38991,
38988, 38990, 38995, 39098, 39230, 39231, 39229, 39214, 39333, 39438,
39617, 39683, 39686, 39759, 39758, 39757, 39882, 39881, 39933, 39880,
39872, 40273, 40285, 40288, 40672, 40725, 40748, 20787, 22181, 22750,
22751, 22754, 23541, 40848, 24300, 25074, 25079, 25078, 25077, 25856,
25871, 26336, 26333, 27365, 27357, 27354, 27347, 28699, 28703, 28712,
28698, 28701, 28693, 28696, 29190, 29197, 29272, 29346, 29560,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 29562, 29885, 29898, 29923, 30087, 30086, 30303,
30305, 30663, 31001, 31153, 31339, 31337, 31806, 31807, 31800, 31805,
31799, 31808, 32363, 32365, 32377, 32361, 32362, 32645, 32371, 32694,
32697, 32696, 33240, 34281, 34269, 34282, 34261, 34276, 34277, 34295,
34811, 34821, 34829, 34809, 34814, 35168, 35167, 35158, 35166, 35649,
35676, 35672, 35657, 35674, 35662, 35663, 35654, 35673, 36104, 36106,
36476, 36466, 36487, 36470, 36460, 36474, 36468, 36692, 36686, 36781,
37002, 37003, 37297, 37294, 37857, 37841, 37855, 37827, 37832, 37852,
37853, 37846, 37858, 37837, 37848, 37860, 37847, 37864, 38364, 38580,
38627, 38698, 38695, 38753, 38876, 38907, 39006, 39000, 39003, 39100,
39237, 39241, 39446, 39449, 39693, 39912, 39911, 39894, 39899, 40329,
40289, 40306, 40298, 40300, 40594, 40599, 40595, 40628, 21240, 22184,
22199, 22198, 22196, 22204, 22756, 23360, 23363, 23421, 23542, 24009,
25080, 25082, 25880, 25876, 25881, 26342, 26407, 27372, 28734, 28720,
28722, 29200, 29563, 29903, 30306, 30309, 31014, 31018, 31020, 31019,
31431, 31478, 31820, 31811, 31821, 31983, 31984, 36782, 32381, 32380,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 32386, 32588, 32768, 33242, 33382, 34299,
34297, 34321, 34298, 34310, 34315, 34311, 34314, 34836, 34837, 35172,
35258, 35320, 35696, 35692, 35686, 35695, 35679, 35691, 36111, 36109,
36489, 36481, 36485, 36482, 37300, 37323, 37912, 37891, 37885, 38369,
38704, 39108, 39250, 39249, 39336, 39467, 39472, 39479, 39477, 39955,
39949, 40569, 40629, 40680, 40751, 40799, 40803, 40801, 20791, 20792,
22209, 22208, 22210, 22804, 23660, 24013, 25084, 25086, 25885, 25884,
26005, 26345, 27387, 27396, 27386, 27570, 28748, 29211, 29351, 29910,
29908, 30313, 30675, 31824, 32399, 32396, 32700, 34327, 34349, 34330,
34851, 34850, 34849, 34847, 35178, 35180, 35261, 35700, 35703, 35709,
36115, 36490, 36493, 36491, 36703, 36783, 37306, 37934, 37939, 37941,
37946, 37944, 37938, 37931, 38370, 38712, 38713, 38706, 38911, 39015,
39013, 39255, 39493, 39491, 39488, 39486, 39631, 39764, 39761, 39981,
39973, 40367, 40372, 40386, 40376, 40605, 40687, 40729, 40796, 40806,
40807, 20796, 20795, 22216, 22218, 22217, 23423, 24020, 24018, 24398,
25087, 25892, 27402, 27489, 28753, 28760, 29568, 29924, 30090, 30318,
30316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 31155, 31840, 31839, 32894, 32893,
33247, 35186, 35183, 35324, 35712, 36118, 36119, 36497, 36499, 36705,
37192, 37956, 37969, 37970, 38717, 38718, 38851, 38849, 39019, 39253,
39509, 39501, 39634, 39706, 40009, 39985, 39998, 39995, 40403, 40407,
40756, 40812, 40810, 40852, 22220, 24022, 25088, 25891, 25899, 25898,
26348, 27408, 29914, 31434, 31844, 31843, 31845, 32403, 32406, 32404,
33250, 34360, 34367, 34865, 35722, 37008, 37007, 37987, 37984, 37988,
38760, 39023, 39260, 39514, 39515, 39511, 39635, 39636, 39633, 40020,
40023, 40022, 40421, 40607, 40692, 22225, 22761, 25900, 28766, 30321,
30322, 30679, 32592, 32648, 34870, 34873, 34914, 35731, 35730, 35734,
33399, 36123, 37312, 37994, 38722, 38728, 38724, 38854, 39024, 39519,
39714, 39768, 40031, 40441, 40442, 40572, 40573, 40711, 40823, 40818,
24307, 27414, 28771, 31852, 31854, 34875, 35264, 36513, 37313, 38002,
38000, 39025, 39262, 39638, 39715, 40652, 28772, 30682, 35738, 38007,
38857, 39522, 39525, 32412, 35740, 36522, 37317, 38013, 38014, 38012,
40055, 40056, 40695, 35924, 38015, 40474, 29224, 39530, 39729, 40475,
40478, 31858,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,  9312,  9313,  9314,  9315,
 9316,  9317,  9318,  9319,  9320,  9321,  9332,  9333,  9334,  9335,
 9336,  9337,  9338,  9339,  9340,  9341,  8560,  8561,  8562,  8563,
 8564,  8565,  8566,  8567,  8568,  8569, 20022, 20031, 20101, 20128,
20866, 20886, 20907, 21241, 21304, 21353, 21430, 22794, 23424, 24027,
24186, 24191, 24308, 24400, 24417, 25908, 26080, 30098, 30326, 36789,
38582,   168,   710, 12541, 12542, 12445, 12446, 12291, 20189, 12293,
12294, 12295, 12540, 65339, 65341, 10045, 12353, 12354, 12355, 12356,
12357, 12358, 12359, 12360, 12361, 12362, 12363, 12364, 12365, 12366,
12367, 12368, 12369, 12370, 12371, 12372, 12373, 12374, 12375, 12376,
12377, 12378, 12379, 12380, 12381, 12382, 12383, 12384, 12385, 12386,
12387, 12388, 12389, 12390, 12391, 12392, 12393, 12394, 12395, 12396,
12397, 12398, 12399, 12400, 12401, 12402, 12403, 12404, 12405, 12406,
12407, 12408, 12409, 12410, 12411, 12412, 12413, 12414, 12415, 12416,
12417, 12418, 12419, 12420, 12421, 12422, 12423, 12424, 12425, 12426,
12427, 12428, 12429, 12430, 12431, 12432, 12433, 12434, 12435, 12449,
12450, 12451, 12452,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 12453, 12454, 12455,
12456, 12457, 12458, 12459, 12460, 12461, 12462, 12463, 12464, 12465,
12466, 12467, 12468, 12469, 12470, 12471, 12472, 12473, 12474, 12475,
12476, 12477, 12478, 12479, 12480, 12481, 12482, 12483, 12484, 12485,
12486, 12487, 12488, 12489, 12490, 12491, 12492, 12493, 12494, 12495,
12496, 12497, 12498, 12499, 12500, 12501, 12502, 12503, 12504, 12505,
12506, 12507, 12508, 12509, 12510, 12511, 12512, 12513, 12514, 12515,
12516, 12517, 12518, 12519, 12520, 12521, 12522, 12523, 12524, 12525,
12526, 12527, 12528, 12529, 12530, 12531, 12532, 12533, 12534,  1040,
 1041,  1042,  1043,  1044,  1045,  1025,  1046,  1047,  1048,  1049,
 1050,  1051,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,
 1060,  1061,  1062,  1063,  1064,  1065,  1066,  1067,  1068,  1069,
 1070,  1071,  1072,  1073,  1074,  1075,  1076,  1077,  1105,  1078,
 1079,  1080,  1081,  1082,  1083,  1084,  1085,  1086,  1087,  1088,
 1089,  1090,  1091,  1092,  1093,  1094,  1095,  1096,  1097,  1098,
 1099,  1100,  1101,  1102,  1103,  8679,  8632,  8633, 12751, 63462,
20058, 63464, 20994, 17553,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 40880, 20872,
40881, 63470, 63471, 63472, 63473, 63474, 63475, 63476, 63477, 63478,
63479, 63480, 63481, 63482, 12443, 12444, 12436, 12535, 12536, 12537,
12538, 12539, 65377, 65378, 65379, 65380, 65381, 65382, 65383, 65384,
65385, 65386, 65387, 65388, 65389, 65390, 65391, 65392, 65393, 65394,
65395, 65396, 65506, 65508, 65287, 65282, 12849,  8470,  8481, 65397,
65398, 65399, 65400, 65401, 65402, 65403, 65404, 65405, 65406, 65407,
65408, 65409, 65410, 65411, 65412, 65413, 65414, 65415, 65416, 65417,
65418, 65419, 65420, 65421, 65422, 65423, 65424, 65425, 65426, 65427,
65428, 65429, 65430, 65431, 65432, 65433, 65434, 65435, 65436, 65437,
65438, 65439, 20034, 20060, 20981, 21274, 21378, 19975, 19980, 20039,
20109, 22231, 64012, 23662, 24435, 19983, 20871, 19982, 20014, 20115,
20162, 20169, 20168, 20888, 21244, 21356, 21433, 22304, 22787, 22828,
23568, 24063, 26081, 27571, 27596, 27668, 29247, 20017, 20028, 20200,
20188, 20201, 20193, 20189, 20186, 21004, 21276, 21324, 22306, 22307,
22807, 22831, 23425, 23428, 23570, 23611, 23668, 23667, 24068, 24192,
24194, 24521, 25097, 25168, 27669,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 27702,
27715, 27711, 27707, 29358, 29360, 29578, 31160, 32906, 38430, 20238,
20248, 20268, 20213, 20244, 20209, 20224, 20215, 20232, 20253, 20226,
20229, 20258, 20243, 20228, 20212, 20242, 20913, 21011, 21001, 21008,
21158, 21282, 21279, 21325, 21386, 21511, 22241, 22239, 22318, 22314,
22324, 22844, 22912, 22908, 22917, 22907, 22910, 22903, 22911, 23382,
23573, 23589, 23676, 23674, 23675, 23678, 24031, 24181, 24196, 24322,
24346, 24436, 24533, 24532, 24527, 25180, 25182, 25188, 25185, 25190,
25186, 25177, 25184, 25178, 25189, 26095, 26094, 26430, 26425, 26424,
26427, 26426, 26431, 26428, 26419, 27672, 27718, 27730, 27740, 27727,
27722, 27732, 27723, 27724, 28785, 29278, 29364, 29365, 29582, 29994,
30335, 31349, 32593, 33400, 33404, 33408, 33405, 33407, 34381, 35198,
37017, 37015, 37016, 37019, 37012, 38434, 38436, 38432, 38435, 20310,
20283, 20322, 20297, 20307, 20324, 20286, 20327, 20306, 20319, 20289,
20312, 20269, 20275, 20287, 20321, 20879, 20921, 21020, 21022, 21025,
21165, 21166, 21257, 21347, 21362, 21390, 21391, 21552, 21559, 21546,
21588, 21573, 21529, 21532, 21541, 21528,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
21565, 21583, 21569, 21544, 21540, 21575, 22254, 22247, 22245, 22337,
22341, 22348, 22345, 22347, 22354, 22790, 22848, 22950, 22936, 22944,
22935, 22926, 22946, 22928, 22927, 22951, 22945, 23438, 23442, 23592,
23594, 23693, 23695, 23688, 23691, 23689, 23698, 23690, 23686, 23699,
23701, 24032, 24074, 24078, 24203, 24201, 24204, 24200, 24205, 24325,
24349, 24440, 24438, 24530, 24529, 24528, 24557, 24552, 24558, 24563,
24545, 24548, 24547, 24570, 24559, 24567, 24571, 24576, 24564, 25146,
25219, 25228, 25230, 25231, 25236, 25223, 25201, 25211, 25210, 25200,
25217, 25224, 25207, 25213, 25202, 25204, 25911, 26096, 26100, 26099,
26098, 26101, 26437, 26439, 26457, 26453, 26444, 26440, 26461, 26445,
26458, 26443, 27600, 27673, 27674, 27768, 27751, 27755, 27780, 27787,
27791, 27761, 27759, 27753, 27802, 27757, 27783, 27797, 27804, 27750,
27763, 27749, 27771, 27790, 28788, 28794, 29283, 29375, 29373, 29379,
29382, 29377, 29370, 29381, 29589, 29591, 29587, 29588, 29586, 30010,
30009, 30100, 30101, 30337, 31037, 32820, 32917, 32921, 32912, 32914,
32924, 33424, 33423, 33413, 33422, 33425, 33427,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 33418, 33411, 33412, 35960, 36809, 36799, 37023, 37025, 37029,
37022, 37031, 37024, 38448, 38440, 38447, 38445, 20019, 20376, 20348,
20357, 20349, 20352, 20359, 20342, 20340, 20361, 20356, 20343, 20300,
20375, 20330, 20378, 20345, 20353, 20344, 20368, 20380, 20372, 20382,
20370, 20354, 20373, 20331, 20334, 20894, 20924, 20926, 21045, 21042,
21043, 21062, 21041, 21180, 21258, 21259, 21308, 21394, 21396, 21639,
21631, 21633, 21649, 21634, 21640, 21611, 21626, 21630, 21605, 21612,
21620, 21606, 21645, 21615, 21601, 21600, 21656, 21603, 21607, 21604,
22263, 22265, 22383, 22386, 22381, 22379, 22385, 22384, 22390, 22400,
22389, 22395, 22387, 22388, 22370, 22376, 22397, 22796, 22853, 22965,
22970, 22991, 22990, 22962, 22988, 22977, 22966, 22972, 22979, 22998,
22961, 22973, 22976, 22984, 22964, 22983, 23394, 23397, 23443, 23445,
23620, 23623, 23726, 23716, 23712, 23733, 23727, 23720, 23724, 23711,
23715, 23725, 23714, 23722, 23719, 23709, 23717, 23734, 23728, 23718,
24087, 24084, 24089, 24360, 24354, 24355, 24356, 24404, 24450, 24446,
24445, 24542, 24549, 24621, 24614, 24601, 24626, 24587,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 24628, 24586, 24599, 24627, 24602, 24606, 24620, 24610,
24589, 24592, 24622, 24595, 24593, 24588, 24585, 24604, 25108, 25149,
25261, 25268, 25297, 25278, 25258, 25270, 25290, 25262, 25267, 25263,
25275, 25257, 25264, 25272, 25917, 26024, 26043, 26121, 26108, 26116,
26130, 26120, 26107, 26115, 26123, 26125, 26117, 26109, 26129, 26128,
26358, 26378, 26501, 26476, 26510, 26514, 26486, 26491, 26520, 26502,
26500, 26484, 26509, 26508, 26490, 26527, 26513, 26521, 26499, 26493,
26497, 26488, 26489, 26516, 27429, 27520, 27518, 27614, 27677, 27795,
27884, 27883, 27886, 27865, 27830, 27860, 27821, 27879, 27831, 27856,
27842, 27834, 27843, 27846, 27885, 27890, 27858, 27869, 27828, 27786,
27805, 27776, 27870, 27840, 27952, 27853, 27847, 27824, 27897, 27855,
27881, 27857, 28820, 28824, 28805, 28819, 28806, 28804, 28817, 28822,
28802, 28826, 28803, 29290, 29398, 29387, 29400, 29385, 29404, 29394,
29396, 29402, 29388, 29393, 29604, 29601, 29613, 29606, 29602, 29600,
29612, 29597, 29917, 29928, 30015, 30016, 30014, 30092, 30104, 30383,
30451, 30449, 30448, 30453, 30712, 30716, 30713, 30715, 30714,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 30711, 31042, 31039, 31173, 31352, 31355, 31483,
31861, 31997, 32821, 32911, 32942, 32931, 32952, 32949, 32941, 33312,
33440, 33472, 33451, 33434, 33432, 33435, 33461, 33447, 33454, 33468,
33438, 33466, 33460, 33448, 33441, 33449, 33474, 33444, 33475, 33462,
33442, 34416, 34415, 34413, 34414, 35926, 36818, 36811, 36819, 36813,
36822, 36821, 36823, 37042, 37044, 37039, 37043, 37040, 38457, 38461,
38460, 38458, 38467, 20429, 20421, 20435, 20402, 20425, 20427, 20417,
20436, 20444, 20441, 20411, 20403, 20443, 20423, 20438, 20410, 20416,
20409, 20460, 21060, 21065, 21184, 21186, 21309, 21372, 21399, 21398,
21401, 21400, 21690, 21665, 21677, 21669, 21711, 21699, 33549, 21687,
21678, 21718, 21686, 21701, 21702, 21664, 21616, 21692, 21666, 21694,
21618, 21726, 21680, 22453, 22430, 22431, 22436, 22412, 22423, 22429,
22427, 22420, 22424, 22415, 22425, 22437, 22426, 22421, 22772, 22797,
22867, 23009, 23006, 23022, 23040, 23025, 23005, 23034, 23037, 23036,
23030, 23012, 23026, 23031, 23003, 23017, 23027, 23029, 23008, 23038,
23028, 23021, 23464, 23628, 23760, 23768, 23756, 23767, 23755, 23771,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 23774, 23770, 23753, 23751, 23754, 23766,
23763, 23764, 23759, 23752, 23750, 23758, 23775, 23800, 24057, 24097,
24098, 24099, 24096, 24100, 24240, 24228, 24226, 24219, 24227, 24229,
24327, 24366, 24406, 24454, 24631, 24633, 24660, 24690, 24670, 24645,
24659, 24647, 24649, 24667, 24652, 24640, 24642, 24671, 24612, 24644,
24664, 24678, 24686, 25154, 25155, 25295, 25357, 25355, 25333, 25358,
25347, 25323, 25337, 25359, 25356, 25336, 25334, 25344, 25363, 25364,
25338, 25365, 25339, 25328, 25921, 25923, 26026, 26047, 26166, 26145,
26162, 26165, 26140, 26150, 26146, 26163, 26155, 26170, 26141, 26164,
26169, 26158, 26383, 26384, 26561, 26610, 26568, 26554, 26588, 26555,
26616, 26584, 26560, 26551, 26565, 26603, 26596, 26591, 26549, 26573,
26547, 26615, 26614, 26606, 26595, 26562, 26553, 26574, 26599, 26608,
26546, 26620, 26566, 26605, 26572, 26542, 26598, 26587, 26618, 26569,
26570, 26563, 26602, 26571, 27432, 27522, 27524, 27574, 27606, 27608,
27616, 27680, 27681, 27944, 27956, 27949, 27935, 27964, 27967, 27922,
27914, 27866, 27955, 27908, 27929, 27962, 27930, 27921, 27904, 27933,
27970,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 27905, 27928, 27959, 27907, 27919,
27968, 27911, 27936, 27948, 27912, 27938, 27913, 27920, 28855, 28831,
28862, 28849, 28848, 28833, 28852, 28853, 28841, 29249, 29257, 29258,
29292, 29296, 29299, 29294, 29386, 29412, 29416, 29419, 29407, 29418,
29414, 29411, 29573, 29644, 29634, 29640, 29637, 29625, 29622, 29621,
29620, 29675, 29631, 29639, 29630, 29635, 29638, 29624, 29643, 29932,
29934, 29998, 30023, 30024, 30119, 30122, 30329, 30404, 30472, 30467,
30468, 30469, 30474, 30455, 30459, 30458, 30695, 30696, 30726, 30737,
30738, 30725, 30736, 30735, 30734, 30729, 30723, 30739, 31050, 31052,
31051, 31045, 31044, 31189, 31181, 31183, 31190, 31182, 31360, 31358,
31441, 31488, 31489, 31866, 31864, 31865, 31871, 31872, 31873, 32003,
32008, 32001, 32600, 32657, 32653, 32702, 32775, 32782, 32783, 32788,
32823, 32984, 32967, 32992, 32977, 32968, 32962, 32976, 32965, 32995,
32985, 32988, 32970, 32981, 32969, 32975, 32983, 32998, 32973, 33279,
33313, 33428, 33497, 33534, 33529, 33543, 33512, 33536, 33493, 33594,
33515, 33494, 33524, 33516, 33505, 33522, 33525, 33548, 33531, 33526,
33520, 33514,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 33508, 33504, 33530, 33523,
33517, 34423, 34420, 34428, 34419, 34881, 34894, 34919, 34922, 34921,
35283, 35332, 35335, 36210, 36835, 36833, 36846, 36832, 37105, 37053,
37055, 37077, 37061, 37054, 37063, 37067, 37064, 37332, 37331, 38484,
38479, 38481, 38483, 38474, 38478, 20510, 20485, 20487, 20499, 20514,
20528, 20507, 20469, 20468, 20531, 20535, 20524, 20470, 20471, 20503,
20508, 20512, 20519, 20533, 20527, 20529, 20494, 20826, 20884, 20883,
20938, 20932, 20933, 20936, 20942, 21089, 21082, 21074, 21086, 21087,
21077, 21090, 21197, 21262, 21406, 21798, 21730, 21783, 21778, 21735,
21747, 21732, 21786, 21759, 21764, 21768, 21739, 21777, 21765, 21745,
21770, 21755, 21751, 21752, 21728, 21774, 21763, 21771, 22273, 22274,
22476, 22578, 22485, 22482, 22458, 22470, 22461, 22460, 22456, 22454,
22463, 22471, 22480, 22457, 22465, 22798, 22858, 23065, 23062, 23085,
23086, 23061, 23055, 23063, 23050, 23070, 23091, 23404, 23463, 23469,
23468, 23555, 23638, 23636, 23788, 23807, 23790, 23793, 23799, 23808,
23801, 24105, 24104, 24232, 24238, 24234, 24236, 24371, 24368, 24423,
24669, 24666, 24679,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 24641, 24738, 24712,
24704, 24722, 24705, 24733, 24707, 24725, 24731, 24727, 24711, 24732,
24718, 25113, 25158, 25330, 25360, 25430, 25388, 25412, 25413, 25398,
25411, 25572, 25401, 25419, 25418, 25404, 25385, 25409, 25396, 25432,
25428, 25433, 25389, 25415, 25395, 25434, 25425, 25400, 25431, 25408,
25416, 25930, 25926, 26054, 26051, 26052, 26050, 26186, 26207, 26183,
26193, 26386, 26387, 26655, 26650, 26697, 26674, 26675, 26683, 26699,
26703, 26646, 26673, 26652, 26677, 26667, 26669, 26671, 26702, 26692,
26676, 26653, 26642, 26644, 26662, 26664, 26670, 26701, 26682, 26661,
26656, 27436, 27439, 27437, 27441, 27444, 27501, 32898, 27528, 27622,
27620, 27624, 27619, 27618, 27623, 27685, 28026, 28003, 28004, 28022,
27917, 28001, 28050, 27992, 28002, 28013, 28015, 28049, 28045, 28143,
28031, 28038, 27998, 28007, 28000, 28055, 28016, 28028, 27999, 28034,
28056, 27951, 28008, 28043, 28030, 28032, 28036, 27926, 28035, 28027,
28029, 28021, 28048, 28892, 28883, 28881, 28893, 28875, 32569, 28898,
28887, 28882, 28894, 28896, 28884, 28877, 28869, 28870, 28871, 28890,
28878, 28897, 29250, 29304,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 29303, 29302,
29440, 29434, 29428, 29438, 29430, 29427, 29435, 29441, 29651, 29657,
29669, 29654, 29628, 29671, 29667, 29673, 29660, 29650, 29659, 29652,
29661, 29658, 29655, 29656, 29672, 29918, 29919, 29940, 29941, 29985,
30043, 30047, 30128, 30145, 30139, 30148, 30144, 30143, 30134, 30138,
30346, 30409, 30493, 30491, 30480, 30483, 30482, 30499, 30481, 30485,
30489, 30490, 30498, 30503, 30755, 30764, 30754, 30773, 30767, 30760,
30766, 30763, 30753, 30761, 30771, 30762, 30769, 31060, 31067, 31055,
31068, 31059, 31058, 31057, 31211, 31212, 31200, 31214, 31213, 31210,
31196, 31198, 31197, 31366, 31369, 31365, 31371, 31372, 31370, 31367,
31448, 31504, 31492, 31507, 31493, 31503, 31496, 31498, 31502, 31497,
31506, 31876, 31889, 31882, 31884, 31880, 31885, 31877, 32030, 32029,
32017, 32014, 32024, 32022, 32019, 32031, 32018, 32015, 32012, 32604,
32609, 32606, 32608, 32605, 32603, 32662, 32658, 32707, 32706, 32704,
32790, 32830, 32825, 33018, 33010, 33017, 33013, 33025, 33019, 33024,
33281, 33327, 33317, 33587, 33581, 33604, 33561, 33617, 33573, 33622,
33599, 33601, 33574, 33564, 33570,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 33602,
33614, 33563, 33578, 33544, 33596, 33613, 33558, 33572, 33568, 33591,
33583, 33577, 33607, 33605, 33612, 33619, 33566, 33580, 33611, 33575,
33608, 34387, 34386, 34466, 34472, 34454, 34445, 34449, 34462, 34439,
34455, 34438, 34443, 34458, 34437, 34469, 34457, 34465, 34471, 34453,
34456, 34446, 34461, 34448, 34452, 34883, 34884, 34925, 34933, 34934,
34930, 34944, 34929, 34943, 34927, 34947, 34942, 34932, 34940, 35346,
35911, 35927, 35963, 36004, 36003, 36214, 36216, 36277, 36279, 36278,
36561, 36563, 36862, 36853, 36866, 36863, 36859, 36868, 36860, 36854,
37078, 37088, 37081, 37082, 37091, 37087, 37093, 37080, 37083, 37079,
37084, 37092, 37200, 37198, 37199, 37333, 37346, 37338, 38492, 38495,
38588, 39139, 39647, 39727, 20095, 20592, 20586, 20577, 20574, 20576,
20563, 20555, 20573, 20594, 20552, 20557, 20545, 20571, 20554, 20578,
20501, 20549, 20575, 20585, 20587, 20579, 20580, 20550, 20544, 20590,
20595, 20567, 20561, 20944, 21099, 21101, 21100, 21102, 21206, 21203,
21293, 21404, 21877, 21878, 21820, 21837, 21840, 21812, 21802, 21841,
21858, 21814, 21813, 21808, 21842, 21829,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
21772, 21810, 21861, 21838, 21817, 21832, 21805, 21819, 21824, 21835,
22282, 22279, 22523, 22548, 22498, 22518, 22492, 22516, 22528, 22509,
22525, 22536, 22520, 22539, 22515, 22479, 22535, 22510, 22499, 22514,
22501, 22508, 22497, 22542, 22524, 22544, 22503, 22529, 22540, 22513,
22505, 22512, 22541, 22532, 22876, 23136, 23128, 23125, 23143, 23134,
23096, 23093, 23149, 23120, 23135, 23141, 23148, 23123, 23140, 23127,
23107, 23133, 23122, 23108, 23131, 23112, 23182, 23102, 23117, 23097,
23116, 23152, 23145, 23111, 23121, 23126, 23106, 23132, 23410, 23406,
23489, 23488, 23641, 23838, 23819, 23837, 23834, 23840, 23820, 23848,
23821, 23846, 23845, 23823, 23856, 23826, 23843, 23839, 23854, 24126,
24116, 24241, 24244, 24249, 24242, 24243, 24374, 24376, 24475, 24470,
24479, 24714, 24720, 24710, 24766, 24752, 24762, 24787, 24788, 24783,
24804, 24793, 24797, 24776, 24753, 24795, 24759, 24778, 24767, 24771,
24781, 24768, 25394, 25445, 25482, 25474, 25469, 25533, 25502, 25517,
25501, 25495, 25515, 25486, 25455, 25479, 25488, 25454, 25519, 25461,
25500, 25453, 25518, 25468, 25508, 25403, 25503,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 25464, 25477, 25473, 25489, 25485, 25456, 25939, 26061, 26213,
26209, 26203, 26201, 26204, 26210, 26392, 26745, 26759, 26768, 26780,
26733, 26734, 26798, 26795, 26966, 26735, 26787, 26796, 26793, 26741,
26740, 26802, 26767, 26743, 26770, 26748, 26731, 26738, 26794, 26752,
26737, 26750, 26779, 26774, 26763, 26784, 26761, 26788, 26744, 26747,
26769, 26764, 26762, 26749, 27446, 27443, 27447, 27448, 27537, 27535,
27533, 27534, 27532, 27690, 28096, 28075, 28084, 28083, 28276, 28076,
28137, 28130, 28087, 28150, 28116, 28160, 28104, 28128, 28127, 28118,
28094, 28133, 28124, 28125, 28123, 28148, 28106, 28093, 28141, 28144,
28090, 28117, 28098, 28111, 28105, 28112, 28146, 28115, 28157, 28119,
28109, 28131, 28091, 28922, 28941, 28919, 28951, 28916, 28940, 28912,
28932, 28915, 28944, 28924, 28927, 28934, 28947, 28928, 28920, 28918,
28939, 28930, 28942, 29310, 29307, 29308, 29311, 29469, 29463, 29447,
29457, 29464, 29450, 29448, 29439, 29455, 29470, 29576, 29686, 29688,
29685, 29700, 29697, 29693, 29703, 29696, 29690, 29692, 29695, 29708,
29707, 29684, 29704, 30052, 30051, 30158, 30162, 30159,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 30155, 30156, 30161, 30160, 30351, 30345, 30419, 30521,
30511, 30509, 30513, 30514, 30516, 30515, 30525, 30501, 30523, 30517,
30792, 30802, 30793, 30797, 30794, 30796, 30758, 30789, 30800, 31076,
31079, 31081, 31082, 31075, 31083, 31073, 31163, 31226, 31224, 31222,
31223, 31375, 31380, 31376, 31541, 31559, 31540, 31525, 31536, 31522,
31524, 31539, 31512, 31530, 31517, 31537, 31531, 31533, 31535, 31538,
31544, 31514, 31523, 31892, 31896, 31894, 31907, 32053, 32061, 32056,
32054, 32058, 32069, 32044, 32041, 32065, 32071, 32062, 32063, 32074,
32059, 32040, 32611, 32661, 32668, 32669, 32667, 32714, 32715, 32717,
32720, 32721, 32711, 32719, 32713, 32799, 32798, 32795, 32839, 32835,
32840, 33048, 33061, 33049, 33051, 33069, 33055, 33068, 33054, 33057,
33045, 33063, 33053, 33058, 33297, 33336, 33331, 33338, 33332, 33330,
33396, 33680, 33699, 33704, 33677, 33658, 33651, 33700, 33652, 33679,
33665, 33685, 33689, 33653, 33684, 33705, 33661, 33667, 33676, 33693,
33691, 33706, 33675, 33662, 33701, 33711, 33672, 33687, 33712, 33663,
33702, 33671, 33710, 33654, 33690, 34393, 34390, 34495, 34487,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 34498, 34497, 34501, 34490, 34480, 34504, 34489,
34483, 34488, 34508, 34484, 34491, 34492, 34499, 34493, 34494, 34898,
34953, 34965, 34984, 34978, 34986, 34970, 34961, 34977, 34975, 34968,
34983, 34969, 34971, 34967, 34980, 34988, 34956, 34963, 34958, 35202,
35286, 35289, 35285, 35376, 35367, 35372, 35358, 35897, 35899, 35932,
35933, 35965, 36005, 36221, 36219, 36217, 36284, 36290, 36281, 36287,
36289, 36568, 36574, 36573, 36572, 36567, 36576, 36577, 36900, 36875,
36881, 36892, 36876, 36897, 37103, 37098, 37104, 37108, 37106, 37107,
37076, 37099, 37100, 37097, 37206, 37208, 37210, 37203, 37205, 37356,
37364, 37361, 37363, 37368, 37348, 37369, 37354, 37355, 37367, 37352,
37358, 38266, 38278, 38280, 38524, 38509, 38507, 38513, 38511, 38591,
38762, 38916, 39141, 39319, 20635, 20629, 20628, 20638, 20619, 20643,
20611, 20620, 20622, 20637, 20584, 20636, 20626, 20610, 20615, 20831,
20948, 21266, 21265, 21412, 21415, 21905, 21928, 21925, 21933, 21879,
22085, 21922, 21907, 21896, 21903, 21941, 21889, 21923, 21906, 21924,
21885, 21900, 21926, 21887, 21909, 21921, 21902, 22284, 22569, 22583,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 22553, 22558, 22567, 22563, 22568, 22517,
22600, 22565, 22556, 22555, 22579, 22591, 22582, 22574, 22585, 22584,
22573, 22572, 22587, 22881, 23215, 23188, 23199, 23162, 23202, 23198,
23160, 23206, 23164, 23205, 23212, 23189, 23214, 23095, 23172, 23178,
23191, 23171, 23179, 23209, 23163, 23165, 23180, 23196, 23183, 23187,
23197, 23530, 23501, 23499, 23508, 23505, 23498, 23502, 23564, 23600,
23863, 23875, 23915, 23873, 23883, 23871, 23861, 23889, 23886, 23893,
23859, 23866, 23890, 23869, 23857, 23897, 23874, 23865, 23881, 23864,
23868, 23858, 23862, 23872, 23877, 24132, 24129, 24408, 24486, 24485,
24491, 24777, 24761, 24780, 24802, 24782, 24772, 24852, 24818, 24842,
24854, 24837, 24821, 24851, 24824, 24828, 24830, 24769, 24835, 24856,
24861, 24848, 24831, 24836, 24843, 25162, 25492, 25521, 25520, 25550,
25573, 25576, 25583, 25539, 25757, 25587, 25546, 25568, 25590, 25557,
25586, 25589, 25697, 25567, 25534, 25565, 25564, 25540, 25560, 25555,
25538, 25543, 25548, 25547, 25544, 25584, 25559, 25561, 25906, 25959,
25962, 25956, 25948, 25960, 25957, 25996, 26013, 26014, 26030, 26064,
26066,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 26236, 26220, 26235, 26240, 26225,
26233, 26218, 26226, 26369, 26892, 26835, 26884, 26844, 26922, 26860,
26858, 26865, 26895, 26838, 26871, 26859, 26852, 26870, 26899, 26896,
26867, 26849, 26887, 26828, 26888, 26992, 26804, 26897, 26863, 26822,
26900, 26872, 26832, 26877, 26876, 26856, 26891, 26890, 26903, 26830,
26824, 26845, 26846, 26854, 26868, 26833, 26886, 26836, 26857, 26901,
26917, 26823, 27449, 27451, 27455, 27452, 27540, 27543, 27545, 27541,
27581, 27632, 27634, 27635, 27696, 28156, 28230, 28231, 28191, 28233,
28296, 28220, 28221, 28229, 28258, 28203, 28223, 28225, 28253, 28275,
28188, 28211, 28235, 28224, 28241, 28219, 28163, 28206, 28254, 28264,
28252, 28257, 28209, 28200, 28256, 28273, 28267, 28217, 28194, 28208,
28243, 28261, 28199, 28280, 28260, 28279, 28245, 28281, 28242, 28262,
28213, 28214, 28250, 28960, 28958, 28975, 28923, 28974, 28977, 28963,
28965, 28962, 28978, 28959, 28968, 28986, 28955, 29259, 29274, 29320,
29321, 29318, 29317, 29323, 29458, 29451, 29488, 29474, 29489, 29491,
29479, 29490, 29485, 29478, 29475, 29493, 29452, 29742, 29740, 29744,
29739, 29718,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 29722, 29729, 29741, 29745,
29732, 29731, 29725, 29737, 29728, 29746, 29947, 29999, 30063, 30060,
30183, 30170, 30177, 30182, 30173, 30175, 30180, 30167, 30357, 30354,
30426, 30534, 30535, 30532, 30541, 30533, 30538, 30542, 30539, 30540,
30686, 30700, 30816, 30820, 30821, 30812, 30829, 30833, 30826, 30830,
30832, 30825, 30824, 30814, 30818, 31092, 31091, 31090, 31088, 31234,
31242, 31235, 31244, 31236, 31385, 31462, 31460, 31562, 31547, 31556,
31560, 31564, 31566, 31552, 31576, 31557, 31906, 31902, 31912, 31905,
32088, 32111, 32099, 32083, 32086, 32103, 32106, 32079, 32109, 32092,
32107, 32082, 32084, 32105, 32081, 32095, 32078, 32574, 32575, 32613,
32614, 32674, 32672, 32673, 32727, 32849, 32847, 32848, 33022, 32980,
33091, 33098, 33106, 33103, 33095, 33085, 33101, 33082, 33254, 33262,
33271, 33272, 33273, 33284, 33340, 33341, 33343, 33397, 33595, 33743,
33785, 33827, 33728, 33768, 33810, 33767, 33764, 33788, 33782, 33808,
33734, 33736, 33771, 33763, 33727, 33793, 33757, 33765, 33752, 33791,
33761, 33739, 33742, 33750, 33781, 33737, 33801, 33807, 33758, 33809,
33798, 33730, 33779,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 33749, 33786, 33735,
33745, 33770, 33811, 33731, 33772, 33774, 33732, 33787, 33751, 33762,
33819, 33755, 33790, 34520, 34530, 34534, 34515, 34531, 34522, 34538,
34525, 34539, 34524, 34540, 34537, 34519, 34536, 34513, 34888, 34902,
34901, 35002, 35031, 35001, 35000, 35008, 35006, 34998, 35004, 34999,
35005, 34994, 35073, 35017, 35221, 35224, 35223, 35293, 35290, 35291,
35406, 35405, 35385, 35417, 35392, 35415, 35416, 35396, 35397, 35410,
35400, 35409, 35402, 35404, 35407, 35935, 35969, 35968, 36026, 36030,
36016, 36025, 36021, 36228, 36224, 36233, 36312, 36307, 36301, 36295,
36310, 36316, 36303, 36309, 36313, 36296, 36311, 36293, 36591, 36599,
36602, 36601, 36582, 36590, 36581, 36597, 36583, 36584, 36598, 36587,
36593, 36588, 36596, 36585, 36909, 36916, 36911, 37126, 37164, 37124,
37119, 37116, 37128, 37113, 37115, 37121, 37120, 37127, 37125, 37123,
37217, 37220, 37215, 37218, 37216, 37377, 37386, 37413, 37379, 37402,
37414, 37391, 37388, 37376, 37394, 37375, 37373, 37382, 37380, 37415,
37378, 37404, 37412, 37401, 37399, 37381, 37398, 38267, 38285, 38284,
38288, 38535, 38526, 38536,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 38537, 38531,
38528, 38594, 38600, 38595, 38641, 38640, 38764, 38768, 38766, 38919,
39081, 39147, 40166, 40697, 20099, 20100, 20150, 20669, 20671, 20678,
20654, 20676, 20682, 20660, 20680, 20674, 20656, 20673, 20666, 20657,
20683, 20681, 20662, 20664, 20951, 21114, 21112, 21115, 21116, 21955,
21979, 21964, 21968, 21963, 21962, 21981, 21952, 21972, 21956, 21993,
21951, 21970, 21901, 21967, 21973, 21986, 21974, 21960, 22002, 21965,
21977, 21954, 22292, 22611, 22632, 22628, 22607, 22605, 22601, 22639,
22613, 22606, 22621, 22617, 22629, 22619, 22589, 22627, 22641, 22780,
23239, 23236, 23243, 23226, 23224, 23217, 23221, 23216, 23231, 23240,
23227, 23238, 23223, 23232, 23242, 23220, 23222, 23245, 23225, 23184,
23510, 23512, 23513, 23583, 23603, 23921, 23907, 23882, 23909, 23922,
23916, 23902, 23912, 23911, 23906, 24048, 24143, 24142, 24138, 24141,
24139, 24261, 24268, 24262, 24267, 24263, 24384, 24495, 24493, 24823,
24905, 24906, 24875, 24901, 24886, 24882, 24878, 24902, 24879, 24911,
24873, 24896, 25120, 37224, 25123, 25125, 25124, 25541, 25585, 25579,
25616, 25618, 25609, 25632, 25636,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 25651,
25667, 25631, 25621, 25624, 25657, 25655, 25634, 25635, 25612, 25638,
25648, 25640, 25665, 25653, 25647, 25610, 25626, 25664, 25637, 25639,
25611, 25575, 25627, 25646, 25633, 25614, 25967, 26002, 26067, 26246,
26252, 26261, 26256, 26251, 26250, 26265, 26260, 26232, 26400, 26982,
26975, 26936, 26958, 26978, 26993, 26943, 26949, 26986, 26937, 26946,
26967, 26969, 27002, 26952, 26953, 26933, 26988, 26931, 26941, 26981,
26864, 27000, 26932, 26985, 26944, 26991, 26948, 26998, 26968, 26945,
26996, 26956, 26939, 26955, 26935, 26972, 26959, 26961, 26930, 26962,
26927, 27003, 26940, 27462, 27461, 27459, 27458, 27464, 27457, 27547,
64013, 27643, 27644, 27641, 27639, 27640, 28315, 28374, 28360, 28303,
28352, 28319, 28307, 28308, 28320, 28337, 28345, 28358, 28370, 28349,
28353, 28318, 28361, 28343, 28336, 28365, 28326, 28367, 28338, 28350,
28355, 28380, 28376, 28313, 28306, 28302, 28301, 28324, 28321, 28351,
28339, 28368, 28362, 28311, 28334, 28323, 28999, 29012, 29010, 29027,
29024, 28993, 29021, 29026, 29042, 29048, 29034, 29025, 28994, 29016,
28995, 29003, 29040, 29023, 29008, 29011,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
28996, 29005, 29018, 29263, 29325, 29324, 29329, 29328, 29326, 29500,
29506, 29499, 29498, 29504, 29514, 29513, 29764, 29770, 29771, 29778,
29777, 29783, 29760, 29775, 29776, 29774, 29762, 29766, 29773, 29780,
29921, 29951, 29950, 29949, 29981, 30073, 30071, 27011, 30191, 30223,
30211, 30199, 30206, 30204, 30201, 30200, 30224, 30203, 30198, 30189,
30197, 30205, 30361, 30389, 30429, 30549, 30559, 30560, 30546, 30550,
30554, 30569, 30567, 30548, 30553, 30573, 30688, 30855, 30874, 30868,
30863, 30852, 30869, 30853, 30854, 30881, 30851, 30841, 30873, 30848,
30870, 30843, 31100, 31106, 31101, 31097, 31249, 31256, 31257, 31250,
31255, 31253, 31266, 31251, 31259, 31248, 31395, 31394, 31390, 31467,
31590, 31588, 31597, 31604, 31593, 31602, 31589, 31603, 31601, 31600,
31585, 31608, 31606, 31587, 31922, 31924, 31919, 32136, 32134, 32128,
32141, 32127, 32133, 32122, 32142, 32123, 32131, 32124, 32140, 32148,
32132, 32125, 32146, 32621, 32619, 32615, 32616, 32620, 32678, 32677,
32679, 32731, 32732, 32801, 33124, 33120, 33143, 33116, 33129, 33115,
33122, 33138, 26401, 33118, 33142, 33127, 33135,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 33092, 33121, 33309, 33353, 33348, 33344, 33346, 33349, 34033,
33855, 33878, 33910, 33913, 33935, 33933, 33893, 33873, 33856, 33926,
33895, 33840, 33869, 33917, 33882, 33881, 33908, 33907, 33885, 34055,
33886, 33847, 33850, 33844, 33914, 33859, 33912, 33842, 33861, 33833,
33753, 33867, 33839, 33858, 33837, 33887, 33904, 33849, 33870, 33868,
33874, 33903, 33989, 33934, 33851, 33863, 33846, 33843, 33896, 33918,
33860, 33835, 33888, 33876, 33902, 33872, 34571, 34564, 34551, 34572,
34554, 34518, 34549, 34637, 34552, 34574, 34569, 34561, 34550, 34573,
34565, 35030, 35019, 35021, 35022, 35038, 35035, 35034, 35020, 35024,
35205, 35227, 35295, 35301, 35300, 35297, 35296, 35298, 35292, 35302,
35446, 35462, 35455, 35425, 35391, 35447, 35458, 35460, 35445, 35459,
35457, 35444, 35450, 35900, 35915, 35914, 35941, 35940, 35942, 35974,
35972, 35973, 36044, 36200, 36201, 36241, 36236, 36238, 36239, 36237,
36243, 36244, 36240, 36242, 36336, 36320, 36332, 36337, 36334, 36304,
36329, 36323, 36322, 36327, 36338, 36331, 36340, 36614, 36607, 36609,
36608, 36613, 36615, 36616, 36610, 36619, 36946, 36927,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 36932, 36937, 36925, 37136, 37133, 37135, 37137, 37142,
37140, 37131, 37134, 37230, 37231, 37448, 37458, 37424, 37434, 37478,
37427, 37477, 37470, 37507, 37422, 37450, 37446, 37485, 37484, 37455,
37472, 37479, 37487, 37430, 37473, 37488, 37425, 37460, 37475, 37456,
37490, 37454, 37459, 37452, 37462, 37426, 38303, 38300, 38302, 38299,
38546, 38547, 38545, 38551, 38606, 38650, 38653, 38648, 38645, 38771,
38775, 38776, 38770, 38927, 38925, 38926, 39084, 39158, 39161, 39343,
39346, 39344, 39349, 39597, 39595, 39771, 40170, 40173, 40167, 40576,
40701, 20710, 20692, 20695, 20712, 20723, 20699, 20714, 20701, 20708,
20691, 20716, 20720, 20719, 20707, 20704, 20952, 21120, 21121, 21225,
21227, 21296, 21420, 22055, 22037, 22028, 22034, 22012, 22031, 22044,
22017, 22035, 22018, 22010, 22045, 22020, 22015, 22009, 22665, 22652,
22672, 22680, 22662, 22657, 22655, 22644, 22667, 22650, 22663, 22673,
22670, 22646, 22658, 22664, 22651, 22676, 22671, 22782, 22891, 23260,
23278, 23269, 23253, 23274, 23258, 23277, 23275, 23283, 23266, 23264,
23259, 23276, 23262, 23261, 23257, 23272, 23263, 23415, 23520,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 23523, 23651, 23938, 23936, 23933, 23942, 23930,
23937, 23927, 23946, 23945, 23944, 23934, 23932, 23949, 23929, 23935,
24152, 24153, 24147, 24280, 24273, 24279, 24270, 24284, 24277, 24281,
24274, 24276, 24388, 24387, 24431, 24502, 24876, 24872, 24897, 24926,
24945, 24947, 24914, 24915, 24946, 24940, 24960, 24948, 24916, 24954,
24923, 24933, 24891, 24938, 24929, 24918, 25129, 25127, 25131, 25643,
25677, 25691, 25693, 25716, 25718, 25714, 25715, 25725, 25717, 25702,
25766, 25678, 25730, 25694, 25692, 25675, 25683, 25696, 25680, 25727,
25663, 25708, 25707, 25689, 25701, 25719, 25971, 26016, 26273, 26272,
26271, 26373, 26372, 26402, 27057, 27062, 27081, 27040, 27086, 27030,
27056, 27052, 27068, 27025, 27033, 27022, 27047, 27021, 27049, 27070,
27055, 27071, 27076, 27069, 27044, 27092, 27065, 27082, 27034, 27087,
27059, 27027, 27050, 27041, 27038, 27097, 27031, 27024, 27074, 27061,
27045, 27078, 27466, 27469, 27467, 27550, 27551, 27552, 27587, 27588,
27646, 28366, 28405, 28401, 28419, 28453, 28408, 28471, 28411, 28462,
28425, 28494, 28441, 28442, 28455, 28440, 28475, 28434, 28397, 28426,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 28470, 28531, 28409, 28398, 28461, 28480,
28464, 28476, 28469, 28395, 28423, 28430, 28483, 28421, 28413, 28406,
28473, 28444, 28412, 28474, 28447, 28429, 28446, 28424, 28449, 29063,
29072, 29065, 29056, 29061, 29058, 29071, 29051, 29062, 29057, 29079,
29252, 29267, 29335, 29333, 29331, 29507, 29517, 29521, 29516, 29794,
29811, 29809, 29813, 29810, 29799, 29806, 29952, 29954, 29955, 30077,
30096, 30230, 30216, 30220, 30229, 30225, 30218, 30228, 30392, 30593,
30588, 30597, 30594, 30574, 30592, 30575, 30590, 30595, 30898, 30890,
30900, 30893, 30888, 30846, 30891, 30878, 30885, 30880, 30892, 30882,
30884, 31128, 31114, 31115, 31126, 31125, 31124, 31123, 31127, 31112,
31122, 31120, 31275, 31306, 31280, 31279, 31272, 31270, 31400, 31403,
31404, 31470, 31624, 31644, 31626, 31633, 31632, 31638, 31629, 31628,
31643, 31630, 31621, 31640, 21124, 31641, 31652, 31618, 31931, 31935,
31932, 31930, 32167, 32183, 32194, 32163, 32170, 32193, 32192, 32197,
32157, 32206, 32196, 32198, 32203, 32204, 32175, 32185, 32150, 32188,
32159, 32166, 32174, 32169, 32161, 32201, 32627, 32738, 32739, 32741,
32734,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 32804, 32861, 32860, 33161, 33158,
33155, 33159, 33165, 33164, 33163, 33301, 33943, 33956, 33953, 33951,
33978, 33998, 33986, 33964, 33966, 33963, 33977, 33972, 33985, 33997,
33962, 33946, 33969, 34000, 33949, 33959, 33979, 33954, 33940, 33991,
33996, 33947, 33961, 33967, 33960, 34006, 33944, 33974, 33999, 33952,
34007, 34004, 34002, 34011, 33968, 33937, 34401, 34611, 34595, 34600,
34667, 34624, 34606, 34590, 34593, 34585, 34587, 34627, 34604, 34625,
34622, 34630, 34592, 34610, 34602, 34605, 34620, 34578, 34618, 34609,
34613, 34626, 34598, 34599, 34616, 34596, 34586, 34608, 34577, 35063,
35047, 35057, 35058, 35066, 35070, 35054, 35068, 35062, 35067, 35056,
35052, 35051, 35229, 35233, 35231, 35230, 35305, 35307, 35304, 35499,
35481, 35467, 35474, 35471, 35478, 35901, 35944, 35945, 36053, 36047,
36055, 36246, 36361, 36354, 36351, 36365, 36349, 36362, 36355, 36359,
36358, 36357, 36350, 36352, 36356, 36624, 36625, 36622, 36621, 37155,
37148, 37152, 37154, 37151, 37149, 37146, 37156, 37153, 37147, 37242,
37234, 37241, 37235, 37541, 37540, 37494, 37531, 37498, 37536, 37524,
37546, 37517,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 37542, 37530, 37547, 37497,
37527, 37503, 37539, 37614, 37518, 37506, 37525, 37538, 37501, 37512,
37537, 37514, 37510, 37516, 37529, 37543, 37502, 37511, 37545, 37533,
37515, 37421, 38558, 38561, 38655, 38744, 38781, 38778, 38782, 38787,
38784, 38786, 38779, 38788, 38785, 38783, 38862, 38861, 38934, 39085,
39086, 39170, 39168, 39175, 39325, 39324, 39363, 39353, 39355, 39354,
39362, 39357, 39367, 39601, 39651, 39655, 39742, 39743, 39776, 39777,
39775, 40177, 40178, 40181, 40615, 20735, 20739, 20784, 20728, 20742,
20743, 20726, 20734, 20747, 20748, 20733, 20746, 21131, 21132, 21233,
21231, 22088, 22082, 22092, 22069, 22081, 22090, 22089, 22086, 22104,
22106, 22080, 22067, 22077, 22060, 22078, 22072, 22058, 22074, 22298,
22699, 22685, 22705, 22688, 22691, 22703, 22700, 22693, 22689, 22783,
23295, 23284, 23293, 23287, 23286, 23299, 23288, 23298, 23289, 23297,
23303, 23301, 23311, 23655, 23961, 23959, 23967, 23954, 23970, 23955,
23957, 23968, 23964, 23969, 23962, 23966, 24169, 24157, 24160, 24156,
32243, 24283, 24286, 24289, 24393, 24498, 24971, 24963, 24953, 25009,
25008, 24994, 24969,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 24987, 24979, 25007,
25005, 24991, 24978, 25002, 24993, 24973, 24934, 25011, 25133, 25710,
25712, 25750, 25760, 25733, 25751, 25756, 25743, 25739, 25738, 25740,
25763, 25759, 25704, 25777, 25752, 25974, 25978, 25977, 25979, 26034,
26035, 26293, 26288, 26281, 26290, 26295, 26282, 26287, 27136, 27142,
27159, 27109, 27128, 27157, 27121, 27108, 27168, 27135, 27116, 27106,
27163, 27165, 27134, 27175, 27122, 27118, 27156, 27127, 27111, 27200,
27144, 27110, 27131, 27149, 27132, 27115, 27145, 27140, 27160, 27173,
27151, 27126, 27174, 27143, 27124, 27158, 27473, 27557, 27555, 27554,
27558, 27649, 27648, 27647, 27650, 28481, 28454, 28542, 28551, 28614,
28562, 28557, 28553, 28556, 28514, 28495, 28549, 28506, 28566, 28534,
28524, 28546, 28501, 28530, 28498, 28496, 28503, 28564, 28563, 28509,
28416, 28513, 28523, 28541, 28519, 28560, 28499, 28555, 28521, 28543,
28565, 28515, 28535, 28522, 28539, 29106, 29103, 29083, 29104, 29088,
29082, 29097, 29109, 29085, 29093, 29086, 29092, 29089, 29098, 29084,
29095, 29107, 29336, 29338, 29528, 29522, 29534, 29535, 29536, 29533,
29531, 29537, 29530, 29529,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 29538, 29831,
29833, 29834, 29830, 29825, 29821, 29829, 29832, 29820, 29817, 29960,
29959, 30078, 30245, 30238, 30233, 30237, 30236, 30243, 30234, 30248,
30235, 30364, 30365, 30366, 30363, 30605, 30607, 30601, 30600, 30925,
30907, 30927, 30924, 30929, 30926, 30932, 30920, 30915, 30916, 30921,
31130, 31137, 31136, 31132, 31138, 31131, 27510, 31289, 31410, 31412,
31411, 31671, 31691, 31678, 31660, 31694, 31663, 31673, 31690, 31669,
31941, 31944, 31948, 31947, 32247, 32219, 32234, 32231, 32215, 32225,
32259, 32250, 32230, 32246, 32241, 32240, 32238, 32223, 32630, 32684,
32688, 32685, 32749, 32747, 32746, 32748, 32742, 32744, 32868, 32871,
33187, 33183, 33182, 33173, 33186, 33177, 33175, 33302, 33359, 33363,
33362, 33360, 33358, 33361, 34084, 34107, 34063, 34048, 34089, 34062,
34057, 34061, 34079, 34058, 34087, 34076, 34043, 34091, 34042, 34056,
34060, 34036, 34090, 34034, 34069, 34039, 34027, 34035, 34044, 34066,
34026, 34025, 34070, 34046, 34088, 34077, 34094, 34050, 34045, 34078,
34038, 34097, 34086, 34023, 34024, 34032, 34031, 34041, 34072, 34080,
34096, 34059, 34073, 34095, 34402,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 34646,
34659, 34660, 34679, 34785, 34675, 34648, 34644, 34651, 34642, 34657,
34650, 34641, 34654, 34669, 34666, 34640, 34638, 34655, 34653, 34671,
34668, 34682, 34670, 34652, 34661, 34639, 34683, 34677, 34658, 34663,
34665, 34906, 35077, 35084, 35092, 35083, 35095, 35096, 35097, 35078,
35094, 35089, 35086, 35081, 35234, 35236, 35235, 35309, 35312, 35308,
35535, 35526, 35512, 35539, 35537, 35540, 35541, 35515, 35543, 35518,
35520, 35525, 35544, 35523, 35514, 35517, 35545, 35902, 35917, 35983,
36069, 36063, 36057, 36072, 36058, 36061, 36071, 36256, 36252, 36257,
36251, 36384, 36387, 36389, 36388, 36398, 36373, 36379, 36374, 36369,
36377, 36390, 36391, 36372, 36370, 36376, 36371, 36380, 36375, 36378,
36652, 36644, 36632, 36634, 36640, 36643, 36630, 36631, 36979, 36976,
36975, 36967, 36971, 37167, 37163, 37161, 37162, 37170, 37158, 37166,
37253, 37254, 37258, 37249, 37250, 37252, 37248, 37584, 37571, 37572,
37568, 37593, 37558, 37583, 37617, 37599, 37592, 37609, 37591, 37597,
37580, 37615, 37570, 37608, 37578, 37576, 37582, 37606, 37581, 37589,
37577, 37600, 37598, 37607, 37585, 37587,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
37557, 37601, 37574, 37556, 38268, 38316, 38315, 38318, 38320, 38564,
38562, 38611, 38661, 38664, 38658, 38746, 38794, 38798, 38792, 38864,
38863, 38942, 38941, 38950, 38953, 38952, 38944, 38939, 38951, 39090,
39176, 39162, 39185, 39188, 39190, 39191, 39189, 39388, 39373, 39375,
39379, 39380, 39374, 39369, 39382, 39384, 39371, 39383, 39372, 39603,
39660, 39659, 39667, 39666, 39665, 39750, 39747, 39783, 39796, 39793,
39782, 39798, 39797, 39792, 39784, 39780, 39788, 40188, 40186, 40189,
40191, 40183, 40199, 40192, 40185, 40187, 40200, 40197, 40196, 40579,
40659, 40719, 40720, 20764, 20755, 20759, 20762, 20753, 20958, 21300,
21473, 22128, 22112, 22126, 22131, 22118, 22115, 22125, 22130, 22110,
22135, 22300, 22299, 22728, 22717, 22729, 22719, 22714, 22722, 22716,
22726, 23319, 23321, 23323, 23329, 23316, 23315, 23312, 23318, 23336,
23322, 23328, 23326, 23535, 23980, 23985, 23977, 23975, 23989, 23984,
23982, 23978, 23976, 23986, 23981, 23983, 23988, 24167, 24168, 24166,
24175, 24297, 24295, 24294, 24296, 24293, 24395, 24508, 24989, 25000,
24982, 25029, 25012, 25030, 25025, 25036, 25018,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 25023, 25016, 24972, 25815, 25814, 25808, 25807, 25801, 25789,
25737, 25795, 25819, 25843, 25817, 25907, 25983, 25980, 26018, 26312,
26302, 26304, 26314, 26315, 26319, 26301, 26299, 26298, 26316, 26403,
27188, 27238, 27209, 27239, 27186, 27240, 27198, 27229, 27245, 27254,
27227, 27217, 27176, 27226, 27195, 27199, 27201, 27242, 27236, 27216,
27215, 27220, 27247, 27241, 27232, 27196, 27230, 27222, 27221, 27213,
27214, 27206, 27477, 27476, 27478, 27559, 27562, 27563, 27592, 27591,
27652, 27651, 27654, 28589, 28619, 28579, 28615, 28604, 28622, 28616,
28510, 28612, 28605, 28574, 28618, 28584, 28676, 28581, 28590, 28602,
28588, 28586, 28623, 28607, 28600, 28578, 28617, 28587, 28621, 28591,
28594, 28592, 29125, 29122, 29119, 29112, 29142, 29120, 29121, 29131,
29140, 29130, 29127, 29135, 29117, 29144, 29116, 29126, 29146, 29147,
29341, 29342, 29545, 29542, 29543, 29548, 29541, 29547, 29546, 29823,
29850, 29856, 29844, 29842, 29845, 29857, 29963, 30080, 30255, 30253,
30257, 30269, 30259, 30268, 30261, 30258, 30256, 30395, 30438, 30618,
30621, 30625, 30620, 30619, 30626, 30627, 30613, 30617,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 30615, 30941, 30953, 30949, 30954, 30942, 30947, 30939,
30945, 30946, 30957, 30943, 30944, 31140, 31300, 31304, 31303, 31414,
31416, 31413, 31409, 31415, 31710, 31715, 31719, 31709, 31701, 31717,
31706, 31720, 31737, 31700, 31722, 31714, 31708, 31723, 31704, 31711,
31954, 31956, 31959, 31952, 31953, 32274, 32289, 32279, 32268, 32287,
32288, 32275, 32270, 32284, 32277, 32282, 32290, 32267, 32271, 32278,
32269, 32276, 32293, 32292, 32579, 32635, 32636, 32634, 32689, 32751,
32810, 32809, 32876, 33201, 33190, 33198, 33209, 33205, 33195, 33200,
33196, 33204, 33202, 33207, 33191, 33266, 33365, 33366, 33367, 34134,
34117, 34155, 34125, 34131, 34145, 34136, 34112, 34118, 34148, 34113,
34146, 34116, 34129, 34119, 34147, 34110, 34139, 34161, 34126, 34158,
34165, 34133, 34151, 34144, 34188, 34150, 34141, 34132, 34149, 34156,
34403, 34405, 34404, 34715, 34703, 34711, 34707, 34706, 34696, 34689,
34710, 34712, 34681, 34695, 34723, 34693, 34704, 34705, 34717, 34692,
34708, 34716, 34714, 34697, 35102, 35110, 35120, 35117, 35118, 35111,
35121, 35106, 35113, 35107, 35119, 35116, 35103, 35313, 35552,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 35554, 35570, 35572, 35573, 35549, 35604, 35556,
35551, 35568, 35528, 35550, 35553, 35560, 35583, 35567, 35579, 35985,
35986, 35984, 36085, 36078, 36081, 36080, 36083, 36204, 36206, 36261,
36263, 36403, 36414, 36408, 36416, 36421, 36406, 36412, 36413, 36417,
36400, 36415, 36541, 36662, 36654, 36661, 36658, 36665, 36663, 36660,
36982, 36985, 36987, 36998, 37114, 37171, 37173, 37174, 37267, 37264,
37265, 37261, 37263, 37671, 37662, 37640, 37663, 37638, 37647, 37754,
37688, 37692, 37659, 37667, 37650, 37633, 37702, 37677, 37646, 37645,
37579, 37661, 37626, 37669, 37651, 37625, 37623, 37684, 37634, 37668,
37631, 37673, 37689, 37685, 37674, 37652, 37644, 37643, 37630, 37641,
37632, 37627, 37654, 38332, 38349, 38334, 38329, 38330, 38326, 38335,
38325, 38333, 38569, 38612, 38667, 38674, 38672, 38809, 38807, 38804,
38896, 38904, 38965, 38959, 38962, 39204, 39199, 39207, 39209, 39326,
39406, 39404, 39397, 39396, 39408, 39395, 39402, 39401, 39399, 39609,
39615, 39604, 39611, 39670, 39674, 39673, 39671, 39731, 39808, 39813,
39815, 39804, 39806, 39803, 39810, 39827, 39826, 39824, 39802, 39829,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 39805, 39816, 40229, 40215, 40224, 40222,
40212, 40233, 40221, 40216, 40226, 40208, 40217, 40223, 40584, 40582,
40583, 40622, 40621, 40661, 40662, 40698, 40722, 40765, 20774, 20773,
20770, 20772, 20768, 20777, 21236, 22163, 22156, 22157, 22150, 22148,
22147, 22142, 22146, 22143, 22145, 22742, 22740, 22735, 22738, 23341,
23333, 23346, 23331, 23340, 23335, 23334, 23343, 23342, 23419, 23537,
23538, 23991, 24172, 24170, 24510, 24507, 25027, 25013, 25020, 25063,
25056, 25061, 25060, 25064, 25054, 25839, 25833, 25827, 25835, 25828,
25832, 25985, 25984, 26038, 26074, 26322, 27277, 27286, 27265, 27301,
27273, 27295, 27291, 27297, 27294, 27271, 27283, 27278, 27285, 27267,
27304, 27300, 27281, 27263, 27302, 27290, 27269, 27276, 27282, 27483,
27565, 27657, 28620, 28585, 28660, 28628, 28643, 28636, 28653, 28647,
28646, 28638, 28658, 28637, 28642, 28648, 29153, 29169, 29160, 29170,
29156, 29168, 29154, 29555, 29550, 29551, 29847, 29874, 29867, 29840,
29866, 29869, 29873, 29861, 29871, 29968, 29969, 29970, 29967, 30084,
30275, 30280, 30281, 30279, 30372, 30441, 30645, 30635, 30642, 30647,
30646,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 30644, 30641, 30632, 30704, 30963,
30973, 30978, 30971, 30972, 30962, 30981, 30969, 30974, 30980, 31147,
31144, 31324, 31323, 31318, 31320, 31316, 31322, 31422, 31424, 31425,
31749, 31759, 31730, 31744, 31743, 31739, 31758, 31732, 31755, 31731,
31746, 31753, 31747, 31745, 31736, 31741, 31750, 31728, 31729, 31760,
31754, 31976, 32301, 32316, 32322, 32307, 38984, 32312, 32298, 32329,
32320, 32327, 32297, 32332, 32304, 32315, 32310, 32324, 32314, 32581,
32639, 32638, 32637, 32756, 32754, 32812, 33211, 33220, 33228, 33226,
33221, 33223, 33212, 33257, 33371, 33370, 33372, 34179, 34176, 34191,
34215, 34197, 34208, 34187, 34211, 34171, 34212, 34202, 34206, 34167,
34172, 34185, 34209, 34170, 34168, 34135, 34190, 34198, 34182, 34189,
34201, 34205, 34177, 34210, 34178, 34184, 34181, 34169, 34166, 34200,
34192, 34207, 34408, 34750, 34730, 34733, 34757, 34736, 34732, 34745,
34741, 34748, 34734, 34761, 34755, 34754, 34764, 34743, 34735, 34756,
34762, 34740, 34742, 34751, 34744, 34749, 34782, 34738, 35125, 35123,
35132, 35134, 35137, 35154, 35127, 35138, 35245, 35247, 35246, 35314,
35315, 35614,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 35608, 35606, 35601, 35589,
35595, 35618, 35599, 35602, 35605, 35591, 35597, 35592, 35590, 35612,
35603, 35610, 35919, 35952, 35954, 35953, 35951, 35989, 35988, 36089,
36207, 36430, 36429, 36435, 36432, 36428, 36423, 36675, 36672, 36997,
36990, 37176, 37274, 37282, 37275, 37273, 37279, 37281, 37277, 37280,
37793, 37763, 37807, 37732, 37718, 37703, 37756, 37720, 37724, 37750,
37705, 37712, 37713, 37728, 37741, 37775, 37708, 37738, 37753, 37719,
37717, 37714, 37711, 37745, 37751, 37755, 37729, 37726, 37731, 37735,
37760, 37710, 37721, 38343, 38336, 38345, 38339, 38341, 38327, 38574,
38576, 38572, 38688, 38687, 38680, 38685, 38681, 38810, 38817, 38812,
38814, 38813, 38869, 38868, 38897, 38977, 38980, 38986, 38985, 38981,
38979, 39205, 39211, 39212, 39210, 39219, 39218, 39215, 39213, 39217,
39216, 39320, 39331, 39329, 39426, 39418, 39412, 39415, 39417, 39416,
39414, 39419, 39421, 39422, 39420, 39427, 39614, 39678, 39677, 39681,
39676, 39752, 39834, 39848, 39838, 39835, 39846, 39841, 39845, 39844,
39814, 39842, 39840, 39855, 40243, 40257, 40295, 40246, 40238, 40239,
40241, 40248, 40240,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 40261, 40258, 40259,
40254, 40247, 40256, 40253, 32757, 40237, 40586, 40585, 40589, 40624,
40648, 40666, 40699, 40703, 40740, 40739, 40738, 40788, 40864, 20785,
20781, 20782, 22168, 22172, 22167, 22170, 22173, 22169, 22896, 23356,
23657, 23658, 24000, 24173, 24174, 25048, 25055, 25069, 25070, 25073,
25066, 25072, 25067, 25046, 25065, 25855, 25860, 25853, 25848, 25857,
25859, 25852, 26004, 26075, 26330, 26331, 26328, 27333, 27321, 27325,
27361, 27334, 27322, 27318, 27319, 27335, 27316, 27309, 27486, 27593,
27659, 28679, 28684, 28685, 28673, 28677, 28692, 28686, 28671, 28672,
28667, 28710, 28668, 28663, 28682, 29185, 29183, 29177, 29187, 29181,
29558, 29880, 29888, 29877, 29889, 29886, 29878, 29883, 29890, 29972,
29971, 30300, 30308, 30297, 30288, 30291, 30295, 30298, 30374, 30397,
30444, 30658, 30650, 30975, 30988, 30995, 30996, 30985, 30992, 30994,
30993, 31149, 31148, 31327, 31772, 31785, 31769, 31776, 31775, 31789,
31773, 31782, 31784, 31778, 31781, 31792, 32348, 32336, 32342, 32355,
32344, 32354, 32351, 32337, 32352, 32343, 32339, 32693, 32691, 32759,
32760, 32885, 33233, 33234,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 33232, 33375,
33374, 34228, 34246, 34240, 34243, 34242, 34227, 34229, 34237, 34247,
34244, 34239, 34251, 34254, 34248, 34245, 34225, 34230, 34258, 34340,
34232, 34231, 34238, 34409, 34791, 34790, 34786, 34779, 34795, 34794,
34789, 34783, 34803, 34788, 34772, 34780, 34771, 34797, 34776, 34787,
34724, 34775, 34777, 34817, 34804, 34792, 34781, 35155, 35147, 35151,
35148, 35142, 35152, 35153, 35145, 35626, 35623, 35619, 35635, 35632,
35637, 35655, 35631, 35644, 35646, 35633, 35621, 35639, 35622, 35638,
35630, 35620, 35643, 35645, 35642, 35906, 35957, 35993, 35992, 35991,
36094, 36100, 36098, 36096, 36444, 36450, 36448, 36439, 36438, 36446,
36453, 36455, 36443, 36442, 36449, 36445, 36457, 36436, 36678, 36679,
36680, 36683, 37160, 37178, 37179, 37182, 37288, 37285, 37287, 37295,
37290, 37813, 37772, 37778, 37815, 37787, 37789, 37769, 37799, 37774,
37802, 37790, 37798, 37781, 37768, 37785, 37791, 37773, 37809, 37777,
37810, 37796, 37800, 37812, 37795, 37797, 38354, 38355, 38353, 38579,
38615, 38618, 24002, 38623, 38616, 38621, 38691, 38690, 38693, 38828,
38830, 38824, 38827, 38820, 38826,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 38818,
38821, 38871, 38873, 38870, 38872, 38906, 38992, 38993, 38994, 39096,
39233, 39228, 39226, 39439, 39435, 39433, 39437, 39428, 39441, 39434,
39429, 39431, 39430, 39616, 39644, 39688, 39684, 39685, 39721, 39733,
39754, 39756, 39755, 39879, 39878, 39875, 39871, 39873, 39861, 39864,
39891, 39862, 39876, 39865, 39869, 40284, 40275, 40271, 40266, 40283,
40267, 40281, 40278, 40268, 40279, 40274, 40276, 40287, 40280, 40282,
40590, 40588, 40671, 40705, 40704, 40726, 40741, 40747, 40746, 40745,
40744, 40780, 40789, 20788, 20789, 21142, 21239, 21428, 22187, 22189,
22182, 22183, 22186, 22188, 22746, 22749, 22747, 22802, 23357, 23358,
23359, 24003, 24176, 24511, 25083, 25863, 25872, 25869, 25865, 25868,
25870, 25988, 26078, 26077, 26334, 27367, 27360, 27340, 27345, 27353,
27339, 27359, 27356, 27344, 27371, 27343, 27341, 27358, 27488, 27568,
27660, 28697, 28711, 28704, 28694, 28715, 28705, 28706, 28707, 28713,
28695, 28708, 28700, 28714, 29196, 29194, 29191, 29186, 29189, 29349,
29350, 29348, 29347, 29345, 29899, 29893, 29879, 29891, 29974, 30304,
30665, 30666, 30660, 30705, 31005, 31003,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
31009, 31004, 30999, 31006, 31152, 31335, 31336, 31795, 31804, 31801,
31788, 31803, 31980, 31978, 32374, 32373, 32376, 32368, 32375, 32367,
32378, 32370, 32372, 32360, 32587, 32586, 32643, 32646, 32695, 32765,
32766, 32888, 33239, 33237, 33380, 33377, 33379, 34283, 34289, 34285,
34265, 34273, 34280, 34266, 34263, 34284, 34290, 34296, 34264, 34271,
34275, 34268, 34257, 34288, 34278, 34287, 34270, 34274, 34816, 34810,
34819, 34806, 34807, 34825, 34828, 34827, 34822, 34812, 34824, 34815,
34826, 34818, 35170, 35162, 35163, 35159, 35169, 35164, 35160, 35165,
35161, 35208, 35255, 35254, 35318, 35664, 35656, 35658, 35648, 35667,
35670, 35668, 35659, 35669, 35665, 35650, 35666, 35671, 35907, 35959,
35958, 35994, 36102, 36103, 36105, 36268, 36266, 36269, 36267, 36461,
36472, 36467, 36458, 36463, 36475, 36546, 36690, 36689, 36687, 36688,
36691, 36788, 37184, 37183, 37296, 37293, 37854, 37831, 37839, 37826,
37850, 37840, 37881, 37868, 37836, 37849, 37801, 37862, 37834, 37844,
37870, 37859, 37845, 37828, 37838, 37824, 37842, 37863, 38269, 38362,
38363, 38625, 38697, 38699, 38700, 38696, 38694,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 38835, 38839, 38838, 38877, 38878, 38879, 39004, 39001, 39005,
38999, 39103, 39101, 39099, 39102, 39240, 39239, 39235, 39334, 39335,
39450, 39445, 39461, 39453, 39460, 39451, 39458, 39456, 39463, 39459,
39454, 39452, 39444, 39618, 39691, 39690, 39694, 39692, 39735, 39914,
39915, 39904, 39902, 39908, 39910, 39906, 39920, 39892, 39895, 39916,
39900, 39897, 39909, 39893, 39905, 39898, 40311, 40321, 40330, 40324,
40328, 40305, 40320, 40312, 40326, 40331, 40332, 40317, 40299, 40308,
40309, 40304, 40297, 40325, 40307, 40315, 40322, 40303, 40313, 40319,
40327, 40296, 40596, 40593, 40640, 40700, 40749, 40768, 40769, 40781,
40790, 40791, 40792, 21303, 22194, 22197, 22195, 22755, 23365, 24006,
24007, 24302, 24303, 24512, 24513, 25081, 25879, 25878, 25877, 25875,
26079, 26344, 26339, 26340, 27379, 27376, 27370, 27368, 27385, 27377,
27374, 27375, 28732, 28725, 28719, 28727, 28724, 28721, 28738, 28728,
28735, 28730, 28729, 28736, 28731, 28723, 28737, 29203, 29204, 29352,
29565, 29564, 29882, 30379, 30378, 30398, 30445, 30668, 30670, 30671,
30669, 30706, 31013, 31011, 31015, 31016, 31012, 31017,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 31154, 31342, 31340, 31341, 31479, 31817, 31816, 31818,
31815, 31813, 31982, 32379, 32382, 32385, 32384, 32698, 32767, 32889,
33243, 33241, 33291, 33384, 33385, 34338, 34303, 34305, 34302, 34331,
34304, 34294, 34308, 34313, 34309, 34316, 34301, 34841, 34832, 34833,
34839, 34835, 34838, 35171, 35174, 35257, 35319, 35680, 35690, 35677,
35688, 35683, 35685, 35687, 35693, 36270, 36486, 36488, 36484, 36697,
36694, 36695, 36693, 36696, 36698, 37005, 37187, 37185, 37303, 37301,
37298, 37299, 37899, 37907, 37883, 37920, 37903, 37908, 37886, 37909,
37904, 37928, 37913, 37901, 37877, 37888, 37879, 37895, 37902, 37910,
37906, 37882, 37897, 37880, 37898, 37887, 37884, 37900, 37878, 37905,
37894, 38366, 38368, 38367, 38702, 38703, 38841, 38843, 38909, 38910,
39008, 39010, 39011, 39007, 39105, 39106, 39248, 39246, 39257, 39244,
39243, 39251, 39474, 39476, 39473, 39468, 39466, 39478, 39465, 39470,
39480, 39469, 39623, 39626, 39622, 39696, 39698, 39697, 39947, 39944,
39927, 39941, 39954, 39928, 40000, 39943, 39950, 39942, 39959, 39956,
39945, 40351, 40345, 40356, 40349, 40338, 40344, 40336, 40347,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 40352, 40340, 40348, 40362, 40343, 40353, 40346,
40354, 40360, 40350, 40355, 40383, 40361, 40342, 40358, 40359, 40601,
40603, 40602, 40677, 40676, 40679, 40678, 40752, 40750, 40795, 40800,
40798, 40797, 40793, 40849, 20794, 20793, 21144, 21143, 22211, 22205,
22206, 23368, 23367, 24011, 24015, 24305, 25085, 25883, 27394, 27388,
27395, 27384, 27392, 28739, 28740, 28746, 28744, 28745, 28741, 28742,
29213, 29210, 29209, 29566, 29975, 30314, 30672, 31021, 31025, 31023,
31828, 31827, 31986, 32394, 32391, 32392, 32395, 32390, 32397, 32589,
32699, 32816, 33245, 34328, 34346, 34342, 34335, 34339, 34332, 34329,
34343, 34350, 34337, 34336, 34345, 34334, 34341, 34857, 34845, 34843,
34848, 34852, 34844, 34859, 34890, 35181, 35177, 35182, 35179, 35322,
35705, 35704, 35653, 35706, 35707, 36112, 36116, 36271, 36494, 36492,
36702, 36699, 36701, 37190, 37188, 37189, 37305, 37951, 37947, 37942,
37929, 37949, 37948, 37936, 37945, 37930, 37943, 37932, 37952, 37937,
38373, 38372, 38371, 38709, 38714, 38847, 38881, 39012, 39113, 39110,
39104, 39256, 39254, 39481, 39485, 39494, 39492, 39490, 39489, 39482,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 39487, 39629, 39701, 39703, 39704, 39702,
39738, 39762, 39979, 39965, 39964, 39980, 39971, 39976, 39977, 39972,
39969, 40375, 40374, 40380, 40385, 40391, 40394, 40399, 40382, 40389,
40387, 40379, 40373, 40398, 40377, 40378, 40364, 40392, 40369, 40365,
40396, 40371, 40397, 40370, 40570, 40604, 40683, 40686, 40685, 40731,
40728, 40730, 40753, 40782, 40805, 40804, 40850, 20153, 22214, 22213,
22219, 22897, 23371, 23372, 24021, 24017, 24306, 25889, 25888, 25894,
25890, 27403, 27400, 27401, 27661, 28757, 28758, 28759, 28754, 29214,
29215, 29353, 29567, 29912, 29909, 29913, 29911, 30317, 30381, 31029,
31156, 31344, 31345, 31831, 31836, 31833, 31835, 31834, 31988, 31985,
32401, 32591, 32647, 33246, 33387, 34356, 34357, 34355, 34348, 34354,
34358, 34860, 34856, 34854, 34858, 34853, 35185, 35263, 35262, 35323,
35710, 35716, 35714, 35718, 35717, 35711, 36117, 36501, 36500, 36506,
36498, 36496, 36502, 36503, 36704, 36706, 37191, 37964, 37968, 37962,
37963, 37967, 37959, 37957, 37960, 37961, 37958, 38719, 38883, 39018,
39017, 39115, 39252, 39259, 39502, 39507, 39508, 39500, 39503, 39496,
39498,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 39497, 39506, 39504, 39632, 39705,
39723, 39739, 39766, 39765, 40006, 40008, 39999, 40004, 39993, 39987,
40001, 39996, 39991, 39988, 39986, 39997, 39990, 40411, 40402, 40414,
40410, 40395, 40400, 40412, 40401, 40415, 40425, 40409, 40408, 40406,
40437, 40405, 40413, 40630, 40688, 40757, 40755, 40754, 40770, 40811,
40853, 40866, 20797, 21145, 22760, 22759, 22898, 23373, 24024, 34863,
24399, 25089, 25091, 25092, 25897, 25893, 26006, 26347, 27409, 27410,
27407, 27594, 28763, 28762, 29218, 29570, 29569, 29571, 30320, 30676,
31847, 31846, 32405, 33388, 34362, 34368, 34361, 34364, 34353, 34363,
34366, 34864, 34866, 34862, 34867, 35190, 35188, 35187, 35326, 35724,
35726, 35723, 35720, 35909, 36121, 36504, 36708, 36707, 37308, 37986,
37973, 37981, 37975, 37982, 38852, 38853, 38912, 39510, 39513, 39710,
39711, 39712, 40018, 40024, 40016, 40010, 40013, 40011, 40021, 40025,
40012, 40014, 40443, 40439, 40431, 40419, 40427, 40440, 40420, 40438,
40417, 40430, 40422, 40434, 40432, 40418, 40428, 40436, 40435, 40424,
40429, 40642, 40656, 40690, 40691, 40710, 40732, 40760, 40759, 40758,
40771, 40783,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 40817, 40816, 40814, 40815,
22227, 22221, 23374, 23661, 25901, 26349, 26350, 27411, 28767, 28769,
28765, 28768, 29219, 29915, 29925, 30677, 31032, 31159, 31158, 31850,
32407, 32649, 33389, 34371, 34872, 34871, 34869, 34891, 35732, 35733,
36510, 36511, 36512, 36509, 37310, 37309, 37314, 37995, 37992, 37993,
38629, 38726, 38723, 38727, 38855, 38885, 39518, 39637, 39769, 40035,
40039, 40038, 40034, 40030, 40032, 40450, 40446, 40455, 40451, 40454,
40453, 40448, 40449, 40457, 40447, 40445, 40452, 40608, 40734, 40774,
40820, 40821, 40822, 22228, 25902, 26040, 27416, 27417, 27415, 27418,
28770, 29222, 29354, 30680, 30681, 31033, 31849, 31851, 31990, 32410,
32408, 32411, 32409, 33248, 33249, 34374, 34375, 34376, 35193, 35194,
35196, 35195, 35327, 35736, 35737, 36517, 36516, 36515, 37998, 37997,
37999, 38001, 38003, 38729, 39026, 39263, 40040, 40046, 40045, 40459,
40461, 40464, 40463, 40466, 40465, 40609, 40693, 40713, 40775, 40824,
40827, 40826, 40825, 22302, 28774, 31855, 34876, 36274, 36518, 37315,
38004, 38008, 38006, 38005, 39520, 40052, 40051, 40049, 40053, 40468,
40467, 40694, 40714,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 40868, 28776, 28773,
31991, 34410, 34878, 34877, 34879, 35742, 35996, 36521, 36553, 38731,
39027, 39028, 39116, 39265, 39339, 39524, 39526, 39527, 39716, 40469,
40471, 40776, 25095, 27422, 29223, 34380, 36520, 38018, 38016, 38017,
39529, 39528, 39726, 40473, 29225, 34379, 35743, 38019, 40057, 40631,
30325, 39531, 40058, 40477, 28777, 28778, 40612, 40830, 40777, 40856,
30849, 37561, 35023, 22715, 24658, 31911, 23290,  9556,  9574,  9559,
 9568,  9580,  9571,  9562,  9577,  9565,  9554,  9572,  9557,  9566,
 9578,  9569,  9560,  9575,  9563,  9555,  9573,  9558,  9567,  9579,
 9570,  9561,  9576,  9564,  9553,  9552,  9581,  9582,  9584,  9583,
 9619, 57344, 57345, 57346, 57347, 57348, 57349, 57350, 57351, 57352,
57353, 57354, 57355, 57356, 57357, 57358, 57359, 57360, 57361, 57362,
57363, 57364, 57365, 57366, 57367, 57368, 57369, 57370, 57371, 57372,
57373, 57374, 57375, 57376, 57377, 57378, 57379, 29234, 29244, 29286,
29314, 29327, 29343, 29357, 29361, 29368, 29374, 29389, 29403, 29476,
29487, 29496, 29497, 29629, 29646, 29681, 29814, 29858, 29953, 29977,
29987, 30012, 30020, 30025,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 30029, 30061,
30082, 30083, 30089, 30124, 30166, 30185, 30272, 30285, 30292, 30312,
30336, 30339, 30352, 30391, 30393, 30477, 30494, 30531, 30744, 30748,
30777, 30780, 30791, 30806, 30842, 30901, 30905, 30918, 30937, 30983,
31024, 31028, 31035, 31104, 31133, 31171, 31201, 31238, 31246, 31299,
31312, 31427, 31442, 31458, 31463, 31480, 31542, 31586, 31596, 31610,
31611, 31642, 31646, 31647, 31650, 31655, 31734, 31762, 31764, 31823,
31830, 31832, 31915, 31994, 32072, 32075, 32119, 32212, 32213, 32214,
32228, 32333, 32349, 32383, 32393, 32398, 32402, 32468, 32497, 32530,
32560, 32625, 32642, 32686, 32710, 32800, 32802, 32805, 32817, 32863,
32872, 32940, 32951, 20890, 21526, 21524, 13535, 19581, 25283, 57508,
57509, 57510, 21707, 57512, 21948, 32950, 20903, 57516, 57517, 57518,
21779, 33318, 57521, 21790, 21982, 25529, 26776, 57526, 21762, 21865,
30132, 25596, 40580, 37418, 57533, 57534, 57535, 35015, 24734, 22053,
28997, 23282, 57541, 21135, 22095, 30611, 34694, 36397, 33206, 13822,
29174, 57550, 34820, 37765, 57553, 57554, 30310, 57556, 40050, 57558,
25294, 57560, 40598, 18825, 31955,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 36570,
40619, 25831, 57567, 33450, 26471, 28018, 30982, 31172, 32590, 34798,
57575, 33726, 34351, 35237, 17935, 57580, 39112, 39232, 39245, 39436,
39639, 40600, 40742, 57588, 20227, 57590, 20281, 20274, 20395, 20566,
57595, 20526, 20646, 20697, 20750, 20717, 20737, 20980, 21023, 21088,
21079, 21146, 21201, 21216, 21217, 20947, 20959, 30022, 20990, 21298,
21292, 21299, 21419, 21418, 40846, 21609, 21660, 21466, 27338, 21875,
57625, 13782, 57627, 22033, 22093, 57630, 22100, 13811, 57633, 22342,
22394, 22375, 22586, 22502, 22493, 22592, 57641, 22566, 22748, 22967,
23001, 23584, 57647, 23761, 23785, 23878, 23950, 57652, 24053, 24075,
24082, 24110, 24158, 57658, 24397, 31357, 23491, 31419, 57663, 57664,
24484, 24506, 24508, 57668, 24695, 24740, 24755, 24829, 24880, 57674,
24988, 24921, 24957, 24924, 25471, 25058, 28885, 25145, 25192, 25221,
25218, 25254, 25301, 25444, 25397, 25744, 14940, 26184, 26215, 26398,
26627, 26540, 26617, 26806, 26924, 26881, 26880, 26826, 26995, 27008,
26942, 57706, 27058, 27072, 27018, 27130, 27113, 27314, 27218, 27293,
27421, 27474, 27642, 15569, 27854, 28239,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
28089, 28484, 57723, 28634, 28801, 31180, 28980, 15820, 29046, 57730,
57731, 29205, 29264, 29319, 29484, 29362, 29410, 29442, 29512, 29480,
29519, 29553, 25989, 57744, 29789, 29800, 29982, 30035, 30074, 30369,
30412, 30500, 30507, 16485, 30803, 30931, 30936, 40318, 30895, 57760,
24898, 31145, 39994, 31188, 57765, 31277, 31294, 31305, 31453, 31450,
30147, 30215, 30210, 57774, 30311, 30319, 22048, 35431, 40727, 31519,
31634, 31651, 31695, 57784, 31740, 31810, 31825, 31837, 31856, 31870,
31878, 31875, 31916, 31943, 31938, 57796, 31962, 57798, 32077, 32090,
32245, 32295, 32366, 40597, 21107, 32797, 32866, 32867, 32870, 32859,
32934, 33027, 40577, 33224, 57815, 36768, 33270, 33306, 57819, 34673,
34729, 34700, 40606, 34753, 40476, 57826, 34774, 34805, 34831, 34840,
34861, 34882, 34885, 39989, 34926, 34986, 34976, 25245, 35139, 35149,
29042, 34910, 57843, 33533, 17591, 33488, 33669, 40194, 40809, 33824,
57851, 34010, 33965, 17659, 34123, 57856, 34306, 34320, 25553, 35209,
35210, 35220, 40005, 35260, 35454, 35401, 35596, 35651, 35713, 35660,
57871, 36013, 36075, 36087, 36108, 36226, 36262,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 36308, 36392, 36431, 36471, 36469, 36519, 36633, 57885, 36700,
40260, 37060, 37201, 57890, 37212, 37209, 37223, 37244, 37262, 37307,
40616, 36950, 36940, 37374, 37474, 37566, 37739, 37742, 37818, 37927,
38295, 38311, 57909, 38456, 57911, 38531, 38550, 38529, 38589, 38659,
38689, 38705, 38751, 38815, 38836, 38840, 38842, 38846, 38856, 40639,
38943, 38958, 40869, 38983, 38987, 39014, 39020, 39092, 40794, 39132,
39142, 39234, 39225, 39227, 40787, 39242, 40773, 19326, 39386, 31432,
39610, 39613, 40706, 39722, 57951, 39725, 39650, 39682, 39679, 19463,
39689, 19460, 19515, 39823, 39837, 39856, 39948, 39957, 39946, 39935,
39982, 33000, 33001, 33004, 33038, 27705, 20074, 38465, 22770, 31074,
26658, 57978, 57979, 33031, 22487, 17642, 25653, 34100, 16607, 57986,
26906, 39938, 30129, 33747, 29041, 27147, 57993, 27258, 39668, 57996,
57997, 30649, 25904, 28054, 22071, 26405, 27179, 32093, 36961, 20120,
31910, 31545, 58009, 22901, 14023, 28799, 58013, 28299, 58015, 58016,
38749, 37584, 22356, 58020, 16089, 58022, 58023, 24985, 29792, 28991,
31022, 23190, 37704, 26254, 20477, 37697, 13908, 23925,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 28702, 25979, 28813, 24269, 58039, 24743, 31408, 24419,
58043, 29687, 58045, 29800, 30132, 58048, 39785,   189,  8531,  8532,
  188,   190,  8533,  8534,  8535,  8536,  8537,  8538, 34450, 34464,
34477, 34482, 34725, 34737,  8539,  8540,  8541,  8542, 34778, 34895,
34912, 34951, 34959, 34960, 35046, 35071, 35072, 35108, 35143, 35156,
35173, 35200, 35217, 35356, 35369, 35371, 35384, 35389,  8978, 35472,
35476, 35484, 35497, 35503, 35508, 35562, 35615,  8240, 35647, 35661,
35678, 35682, 35689, 35739, 35921, 35995, 35999, 36052, 36054, 33042,
33073, 33078, 33119, 33133, 33149, 33171, 33194, 33208, 33217, 33321,
33325, 33326, 33342, 33378, 33386, 33416
};

static const char ucs_to_big5[][2] =
{
    {'\x00','\x00'},{'\x00','\x01'},{'\x00','\x02'},{'\x00','\x03'},{'\x00','\x04'},
    {'\x00','\x05'},{'\x00','\x06'},{'\x00','\x07'},{'\x00','\x08'},{'\x00','\x09'},
    {'\x00','\x0a'},{'\x00','\x0b'},{'\x00','\x0c'},{'\x00','\x0d'},{'\x00','\x0e'},
    {'\x00','\x0f'},{'\x00','\x10'},{'\x00','\x11'},{'\x00','\x12'},{'\x00','\x13'},
    {'\x00','\x14'},{'\x00','\x15'},{'\x00','\x16'},{'\x00','\x17'},{'\x00','\x18'},
    {'\x00','\x19'},{'\x00','\x1a'},{'\x00','\x1b'},{'\x00','\x1c'},{'\x00','\x1d'},
    {'\x00','\x1e'},{'\x00','\x1f'},{'\x00','\x20'},{'\x00','\x21'},{'\x00','\x22'},
    {'\x00','\x23'},{'\x00','\x24'},{'\x00','\x25'},{'\x00','\x26'},{'\x00','\x27'},
    {'\x00','\x28'},{'\x00','\x29'},{'\x00','\x2a'},{'\x00','\x2b'},{'\x00','\x2c'},
    {'\x00','\x2d'},{'\x00','\x2e'},{'\x00','\x2f'},{'\x00','\x30'},{'\x00','\x31'},
    {'\x00','\x32'},{'\x00','\x33'},{'\x00','\x34'},{'\x00','\x35'},{'\x00','\x36'},
    {'\x00','\x37'},{'\x00','\x38'},{'\x00','\x39'},{'\x00','\x3a'},{'\x00','\x3b'},
    {'\x00','\x3c'},{'\x00','\x3d'},{'\x00','\x3e'},{'\x00','\x3f'},{'\x00','\x40'},
    {'\x00','\x41'},{'\x00','\x42'},{'\x00','\x43'},{'\x00','\x44'},{'\x00','\x45'},
    {'\x00','\x46'},{'\x00','\x47'},{'\x00','\x48'},{'\x00','\x49'},{'\x00','\x4a'},
    {'\x00','\x4b'},{'\x00','\x4c'},{'\x00','\x4d'},{'\x00','\x4e'},{'\x00','\x4f'},
    {'\x00','\x50'},{'\x00','\x51'},{'\x00','\x52'},{'\x00','\x53'},{'\x00','\x54'},
    {'\x00','\x55'},{'\x00','\x56'},{'\x00','\x57'},{'\x00','\x58'},{'\x00','\x59'},
    {'\x00','\x5a'},{'\x00','\x5b'},{'\x00','\x5c'},{'\x00','\x5d'},{'\x00','\x5e'},
    {'\x00','\x5f'},{'\x00','\x60'},{'\x00','\x61'},{'\x00','\x62'},{'\x00','\x63'},
    {'\x00','\x64'},{'\x00','\x65'},{'\x00','\x66'},{'\x00','\x67'},{'\x00','\x68'},
    {'\x00','\x69'},{'\x00','\x6a'},{'\x00','\x6b'},{'\x00','\x6c'},{'\x00','\x6d'},
    {'\x00','\x6e'},{'\x00','\x6f'},{'\x00','\x70'},{'\x00','\x71'},{'\x00','\x72'},
    {'\x00','\x73'},{'\x00','\x74'},{'\x00','\x75'},{'\x00','\x76'},{'\x00','\x77'},
    {'\x00','\x78'},{'\x00','\x79'},{'\x00','\x7a'},{'\x00','\x7b'},{'\x00','\x7c'},
    {'\x00','\x7d'},{'\x00','\x7e'},{'\x00','\x7f'},{'\x00','\x80'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa0','\xdf'},{'\xa2','\x46'},{'\xa2','\x47'},{'\xa0','\xfc'},
    {'\xa2','\x44'},{'\x7c','\x20'},{'\xa1','\xb1'},{'\xc6','\xd8'},{'\x63','\x20'},
    {'\xa0','\xde'},{'\x00','\x00'},{'\x00','\x00'},{'\x2d','\x20'},{'\x97','\xfb'},
    {'\xa1','\xc2'},{'\xa2','\x58'},{'\xa1','\xd3'},{'\x32','\x20'},{'\x33','\x20'},
    {'\xa1','\xac'},{'\xa3','\x67'},{'\x91','\xf8'},{'\xa1','\x50'},{'\xa0','\xfb'},
    {'\x31','\x20'},{'\xa0','\xee'},{'\x00','\x00'},{'\xfe','\xb3'},{'\xfe','\xb0'},
    {'\xfe','\xb4'},{'\xa0','\xef'},{'\xa0','\xa7'},{'\xa0','\xac'},{'\xa0','\xf6'},
    {'\xa0','\xbe'},{'\xa0','\xb6'},{'\xa0','\xd6'},{'\xa0','\xbb'},{'\xa0','\xbc'},
    {'\xa0','\xa8'},{'\xa0','\xd7'},{'\xa0','\xf7'},{'\xa0','\xb7'},{'\xa0','\xa9'},
    {'\xa0','\xad'},{'\xa0','\xf8'},{'\xa0','\xb8'},{'\xa0','\xda'},{'\xa0','\xbd'},
    {'\xa0','\xaa'},{'\xa0','\xae'},{'\xa0','\xf9'},{'\xa0','\xbf'},{'\xa0','\xb9'},
    {'\xa1','\xd1'},{'\xa0','\xd9'},{'\xa0','\xab'},{'\xa0','\xaf'},{'\xa0','\xfa'},
    {'\xa0','\xba'},{'\x59','\x20'},{'\xa0','\xdc'},{'\xa0','\xdd'},{'\xa0','\xe0'},
    {'\xa0','\xc0'},{'\xa0','\xf0'},{'\xa0','\xce'},{'\xa0','\xc6'},{'\xa0','\xe6'},
    {'\xa0','\xcb'},{'\xa0','\xcc'},{'\xa0','\xe1'},{'\xa0','\xc1'},{'\xa0','\xf1'},
    {'\xa0','\xc7'},{'\xa0','\xe2'},{'\xa0','\xc2'},{'\xa0','\xf2'},{'\xa0','\xc8'},
    {'\xa0','\xea'},{'\xa0','\xcd'},{'\xa0','\xe3'},{'\xa0','\xc3'},{'\xa0','\xf3'},
    {'\xa0','\xcf'},{'\xa0','\xc9'},{'\xa1','\xd2'},{'\xa0','\xe9'},{'\xa0','\xe4'},
    {'\xa0','\xc4'},{'\xa0','\xf4'},{'\xa0','\xca'},{'\x79','\x20'},{'\xa0','\xec'},
    {'\xa0','\xed'},{'\x00','\x00'},{'\xa0','\xb0'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa0','\xb1'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xd1'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xb2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9b','\xd5'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xb3'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xe5'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xb4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xfe'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xd0'},{'\x00','\x00'},{'\xa0','\xd2'},
    {'\x00','\x00'},{'\xa0','\xd3'},{'\x00','\x00'},{'\xa0','\xd4'},{'\x00','\x00'},
    {'\xa0','\xb5'},{'\x00','\x00'},{'\xa0','\xc5'},{'\x00','\x00'},{'\xa0','\xd5'},
    {'\x00','\x00'},{'\xa0','\xe5'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xcb'},{'\x9b','\xe6'},
    {'\x00','\x00'},{'\x9b','\xcc'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9b','\xcf'},{'\x9b','\xd0'},{'\x9b','\xc8'},{'\x9b','\xd1'},
    {'\x9b','\xce'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xd2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xc7'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xe0'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xd7'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xe1'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xd9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xe2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9b','\xcd'},{'\x00','\x00'},{'\x9b','\xca'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xda'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9b','\xdc'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xdb'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc6','\xd9'},{'\xa3','\xbe'},{'\x00','\x00'},{'\xa3','\xbc'},{'\xa3','\xbd'},
    {'\xa3','\xbf'},{'\x00','\x00'},{'\xa1','\xc5'},{'\x00','\x00'},{'\x9b','\xe9'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa3','\xbb'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa3','\x44'},{'\xa3','\x45'},
    {'\xa3','\x46'},{'\xa3','\x47'},{'\xa3','\x48'},{'\xa3','\x49'},{'\xa3','\x4a'},
    {'\xa3','\x4b'},{'\xa3','\x4c'},{'\xa3','\x4d'},{'\xa3','\x4e'},{'\xa3','\x4f'},
    {'\xa3','\x50'},{'\xa3','\x51'},{'\xa3','\x52'},{'\xa3','\x53'},{'\xa3','\x54'},
    {'\x00','\x00'},{'\xa3','\x55'},{'\xa3','\x56'},{'\xa3','\x57'},{'\xa3','\x58'},
    {'\xa3','\x59'},{'\xa3','\x5a'},{'\xa3','\x5b'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa3','\x5c'},{'\xa3','\x5d'},{'\xa3','\x5e'},{'\xa3','\x5f'},{'\xa3','\x60'},
    {'\xa3','\x61'},{'\xa3','\x62'},{'\xa3','\x63'},{'\xa3','\x64'},{'\xa3','\x65'},
    {'\xa3','\x66'},{'\xa3','\x67'},{'\xa3','\x68'},{'\xa3','\x69'},{'\xa3','\x6a'},
    {'\xa3','\x6b'},{'\xa3','\x6c'},{'\x00','\x00'},{'\xa3','\x6d'},{'\xa3','\x6e'},
    {'\xa3','\x6f'},{'\xa3','\x70'},{'\xa3','\x71'},{'\xa3','\x72'},{'\xa3','\x73'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc7','\xf9'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc7','\xf3'},{'\xc7','\xf4'},{'\xc7','\xf5'},{'\xc7','\xf6'},{'\xc7','\xf7'},
    {'\xc7','\xf8'},{'\xc7','\xfa'},{'\xc7','\xfb'},{'\xc7','\xfc'},{'\xc7','\xfd'},
    {'\xc7','\xfe'},{'\xc8','\x40'},{'\xc8','\x41'},{'\xc8','\x42'},{'\xc8','\x43'},
    {'\xc8','\x44'},{'\xc8','\x45'},{'\xc8','\x46'},{'\xc8','\x47'},{'\xc8','\x48'},
    {'\xc8','\x49'},{'\xc8','\x4a'},{'\xc8','\x4b'},{'\xc8','\x4c'},{'\xc8','\x4d'},
    {'\xc8','\x4e'},{'\xc8','\x4f'},{'\xc8','\x50'},{'\xc8','\x51'},{'\xc8','\x52'},
    {'\xc8','\x53'},{'\xc8','\x54'},{'\xc8','\x55'},{'\xc8','\x56'},{'\xc8','\x57'},
    {'\xc8','\x58'},{'\xc8','\x59'},{'\xc8','\x5a'},{'\xc8','\x5c'},{'\xc8','\x5d'},
    {'\xc8','\x5e'},{'\xc8','\x5f'},{'\xc8','\x60'},{'\xc8','\x61'},{'\xc8','\x62'},
    {'\xc8','\x63'},{'\xc8','\x64'},{'\xc8','\x65'},{'\xc8','\x66'},{'\xc8','\x67'},
    {'\xc8','\x68'},{'\xc8','\x69'},{'\xc8','\x6a'},{'\xc8','\x6b'},{'\xc8','\x6c'},
    {'\xc8','\x6d'},{'\xc8','\x6e'},{'\xc8','\x6f'},{'\xc8','\x70'},{'\xc8','\x71'},
    {'\xc8','\x72'},{'\xc8','\x73'},{'\xc8','\x74'},{'\xc8','\x75'},{'\x00','\x00'},
    {'\xc8','\x5b'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xd6'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xd3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9b','\xd4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xdb'},{'\xa0','\xeb'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9f','\xec'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\x56'},{'\xa1','\x58'},{'\xa2','\x77'},{'\xa1','\xfc'},
    {'\x00','\x00'},{'\xa1','\xa5'},{'\xa1','\xa6'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa1','\xa7'},{'\xa1','\xa8'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xcf'},
    {'\x91','\xde'},{'\xa1','\x45'},{'\x00','\x00'},{'\xa3','\xbb'},{'\xa1','\x4c'},
    {'\xa1','\x4b'},{'\xa1','\x45'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfe','\xe2'},{'\x00','\x00'},{'\xa1','\xac'},{'\xa1','\xb2'},{'\x00','\x00'},
    {'\xa1','\xab'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xb0'},{'\x91','\xf7'},{'\x00','\x00'},{'\xa1','\xc3'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa3','\xe1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa2','\x4a'},{'\x00','\x00'},{'\xa1','\xc1'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa2','\x4b'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9d','\xcf'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xe2'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9d','\xc9'},{'\x97','\xfc'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x96','\x52'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xc8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfe','\xb1'},{'\xfe','\xb2'},{'\xfe','\xb5'},{'\xfe','\xb6'},
    {'\xfe','\xb7'},{'\xfe','\xb8'},{'\xfe','\xb9'},{'\xfe','\xba'},{'\xfe','\xc1'},
    {'\xfe','\xc2'},{'\xfe','\xc3'},{'\xfe','\xc4'},{'\x00','\x00'},{'\xa2','\xb9'},
    {'\xa2','\xba'},{'\xa2','\xbb'},{'\xa2','\xbc'},{'\xa2','\xbd'},{'\xa2','\xbe'},
    {'\xa2','\xbf'},{'\xa2','\xc0'},{'\xa2','\xc1'},{'\xa2','\xc2'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc6','\xb5'},{'\xc6','\xb6'},{'\xc6','\xb7'},{'\xc6','\xb8'},{'\xc6','\xb9'},
    {'\xc6','\xba'},{'\xc6','\xbb'},{'\xc6','\xbc'},{'\xc6','\xbd'},{'\xc6','\xbe'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xf6'},{'\xa1','\xf4'},{'\xa1','\xf7'},
    {'\xa1','\xf5'},{'\x91','\xfb'},{'\x91','\xf6'},{'\xa1','\xf8'},{'\xa1','\xf9'},
    {'\xa1','\xfb'},{'\xa1','\xfa'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x91','\xfa'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9d','\xfd'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc8','\x77'},{'\xc8','\x78'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x96','\x53'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x99','\x65'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\x4a'},{'\xc8','\x76'},
    {'\x9d','\x49'},{'\x9d','\x4c'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x91','\xf9'},
    {'\x00','\x00'},{'\xa0','\x79'},{'\x98','\xf9'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xbe'},{'\x91','\x6b'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x91','\x5f'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa3','\x53'},
    {'\x00','\x00'},{'\xa3','\x55'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa2','\x41'},{'\xa2','\x42'},{'\x00','\x00'},{'\xa2','\x58'},{'\x00','\x00'},
    {'\xa1','\xd4'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xdb'},
    {'\xa1','\xe8'},{'\xa1','\xe7'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xfd'},
    {'\x00','\x00'},{'\xa1','\xfc'},{'\x00','\x00'},{'\xa3','\x4e'},{'\xa2','\xe4'},
    {'\xa1','\xe4'},{'\xa1','\xe5'},{'\xa1','\xec'},{'\x9f','\x4c'},{'\x00','\x00'},
    {'\xa1','\xed'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xef'},{'\xa1','\xee'},{'\xa1','\x47'},{'\x9f','\x46'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xdc'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa1','\xda'},{'\xa1','\xdd'},{'\x00','\x00'},{'\xa1','\xdd'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xd8'},{'\xa1','\xd9'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9a','\xe0'},
    {'\x9a','\xa6'},{'\x00','\x00'},{'\x00','\x00'},{'\x9c','\x72'},{'\x9c','\xaa'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xf2'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xf3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xe6'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa1','\xe9'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x91','\xfc'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa1','\x5b'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xfe','\xd9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa3','\xc0'},{'\xa3','\xc1'},{'\xa3','\xc2'},{'\xa3','\xc3'},
    {'\xa3','\xc4'},{'\xa3','\xc5'},{'\xa3','\xc6'},{'\xa3','\xc7'},{'\xa3','\xc8'},
    {'\xa3','\xc9'},{'\xa3','\xca'},{'\xa3','\xcb'},{'\xa3','\xcc'},{'\xa3','\xcd'},
    {'\xa3','\xce'},{'\xa3','\xcf'},{'\xa3','\xd0'},{'\xa3','\xd1'},{'\xa3','\xd2'},
    {'\xa3','\xd3'},{'\xa3','\xd4'},{'\xa3','\xd5'},{'\xa3','\xd6'},{'\xa3','\xd7'},
    {'\xa3','\xd8'},{'\xa3','\xd9'},{'\xa3','\xda'},{'\xa3','\xdb'},{'\xa3','\xdc'},
    {'\xa3','\xdd'},{'\xa3','\xde'},{'\xa3','\xdf'},{'\x00','\x00'},{'\xa3','\xe0'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xa1'},{'\xc6','\xa2'},{'\xc6','\xa3'},
    {'\xc6','\xa4'},{'\xc6','\xa5'},{'\xc6','\xa6'},{'\xc6','\xa7'},{'\xc6','\xa8'},
    {'\xc6','\xa9'},{'\xc6','\xaa'},{'\x97','\x4b'},{'\x97','\x4c'},{'\x97','\x4d'},
    {'\x97','\x4e'},{'\x97','\x4f'},{'\x97','\x50'},{'\x97','\x51'},{'\x97','\x52'},
    {'\x97','\x53'},{'\x97','\x54'},{'\xc6','\xab'},{'\xc6','\xac'},{'\xc6','\xad'},
    {'\xc6','\xae'},{'\xc6','\xaf'},{'\xc6','\xb0'},{'\xc6','\xb1'},{'\xc6','\xb2'},
    {'\xc6','\xb3'},{'\xc6','\xb4'},{'\x99','\x4b'},{'\x99','\x4c'},{'\x99','\x4d'},
    {'\x99','\x4e'},{'\x99','\x4f'},{'\x99','\x50'},{'\x99','\x51'},{'\x99','\x52'},
    {'\x99','\x53'},{'\x99','\x54'},{'\x9a','\x41'},{'\x9a','\x42'},{'\x9a','\x43'},
    {'\x9a','\x44'},{'\x9a','\x45'},{'\x9a','\x46'},{'\x9a','\x47'},{'\x9a','\x48'},
    {'\x9a','\x49'},{'\x9a','\x4a'},{'\x9a','\x4b'},{'\x9a','\x4c'},{'\x9a','\x4d'},
    {'\x9a','\x4e'},{'\x9a','\x4f'},{'\x9a','\x50'},{'\x9a','\x51'},{'\x9a','\x52'},
    {'\x9a','\x53'},{'\x9a','\x54'},{'\x99','\xe1'},{'\x99','\xe2'},{'\x99','\xe3'},
    {'\x99','\xe4'},{'\x99','\xe5'},{'\x99','\xe6'},{'\x99','\xe7'},{'\x99','\xe8'},
    {'\x99','\xe9'},{'\x99','\xea'},{'\x99','\xeb'},{'\x99','\xec'},{'\x99','\xed'},
    {'\x99','\xee'},{'\x99','\xef'},{'\x99','\xf0'},{'\x99','\xf1'},{'\x99','\xf2'},
    {'\x99','\xf3'},{'\x99','\xf4'},{'\x99','\xf5'},{'\x99','\xf6'},{'\x99','\xf7'},
    {'\x99','\xf8'},{'\x99','\xf9'},{'\x99','\xfa'},{'\x97','\xc7'},{'\x97','\xc8'},
    {'\x97','\xc9'},{'\x97','\xca'},{'\x97','\xcb'},{'\x97','\xcc'},{'\x97','\xcd'},
    {'\x97','\xce'},{'\x97','\xcf'},{'\x97','\xd0'},{'\x97','\xd1'},{'\x97','\xd2'},
    {'\x97','\xd3'},{'\x97','\xd4'},{'\x97','\xd5'},{'\x97','\xd6'},{'\x97','\xd7'},
    {'\x97','\xd8'},{'\x97','\xd9'},{'\x97','\xda'},{'\x97','\xdb'},{'\x97','\xdc'},
    {'\x97','\xdd'},{'\x97','\xde'},{'\x97','\xdf'},{'\x97','\xe0'},{'\x97','\xe1'},
    {'\x97','\xe2'},{'\x97','\xe3'},{'\x97','\xe4'},{'\x97','\xe5'},{'\x97','\xe6'},
    {'\x97','\xe7'},{'\x97','\xe8'},{'\x97','\xe9'},{'\x97','\xea'},{'\x97','\xeb'},
    {'\x97','\xec'},{'\x97','\xed'},{'\x97','\xee'},{'\x97','\xef'},{'\x97','\xf0'},
    {'\x97','\xf1'},{'\x97','\xf2'},{'\x97','\xf3'},{'\x97','\xf4'},{'\x97','\xf5'},
    {'\x97','\xf6'},{'\x97','\xf7'},{'\x97','\xf8'},{'\x97','\xf9'},{'\x97','\xfa'},
    {'\x97','\x40'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa2','\x77'},{'\x9d','\x7d'},{'\xa2','\x78'},
    {'\x9d','\x7e'},{'\xa1','\x4c'},{'\xa1','\x4c'},{'\xa1','\x4a'},{'\xa1','\x4a'},
    {'\xa1','\x4b'},{'\xa1','\x4b'},{'\xa1','\x55'},{'\xa1','\x55'},{'\xa2','\x7a'},
    {'\xa2','\x7a'},{'\xa2','\x7a'},{'\xa2','\x7a'},{'\xa2','\x7b'},{'\xa2','\x7b'},
    {'\xa2','\x7b'},{'\xa2','\x7b'},{'\xa2','\x7c'},{'\xa2','\x7c'},{'\xa2','\x7c'},
    {'\xa2','\x7c'},{'\xa2','\x7d'},{'\xa2','\x7d'},{'\xa2','\x7d'},{'\xa2','\x7d'},
    {'\xa2','\x75'},{'\xa2','\x75'},{'\xa2','\x75'},{'\xa2','\x75'},{'\xa2','\x75'},
    {'\xa2','\x75'},{'\xa2','\x75'},{'\xa2','\x75'},{'\xa2','\x74'},{'\xa2','\x74'},
    {'\xa2','\x74'},{'\xa2','\x74'},{'\xa2','\x74'},{'\xa2','\x74'},{'\xa2','\x74'},
    {'\xa2','\x74'},{'\xa2','\x73'},{'\xa2','\x73'},{'\xa2','\x73'},{'\xa2','\x73'},
    {'\xa2','\x73'},{'\xa2','\x73'},{'\xa2','\x73'},{'\xa2','\x73'},{'\xa2','\x72'},
    {'\xa2','\x72'},{'\xa2','\x72'},{'\xa2','\x72'},{'\xa2','\x72'},{'\xa2','\x72'},
    {'\xa2','\x72'},{'\xa2','\x72'},{'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},
    {'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},
    {'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},
    {'\xa2','\x71'},{'\xa2','\x71'},{'\xa2','\x71'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x91','\xf0'},{'\x00','\x00'},{'\xf9','\xf9'},{'\xf9','\xf8'},{'\xf9','\xe6'},
    {'\xf9','\xef'},{'\xf9','\xdd'},{'\xf9','\xe8'},{'\xf9','\xf1'},{'\xf9','\xdf'},
    {'\xf9','\xec'},{'\xf9','\xf5'},{'\xf9','\xe3'},{'\xf9','\xee'},{'\xf9','\xf7'},
    {'\xf9','\xe5'},{'\xf9','\xe9'},{'\xf9','\xf2'},{'\xf9','\xe0'},{'\xf9','\xeb'},
    {'\xf9','\xf4'},{'\xf9','\xe2'},{'\xf9','\xe7'},{'\xf9','\xf0'},{'\xf9','\xde'},
    {'\xf9','\xed'},{'\xf9','\xf6'},{'\xf9','\xe4'},{'\xf9','\xea'},{'\xf9','\xf3'},
    {'\xf9','\xe1'},{'\xa2','\x7e'},{'\xa2','\xa1'},{'\xa2','\xa3'},{'\xa2','\xa2'},
    {'\xa2','\xac'},{'\xa2','\xad'},{'\xa2','\xae'},{'\xa1','\x5a'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa2','\x62'},{'\xa2','\x63'},{'\xa2','\x64'},{'\xa2','\x65'},
    {'\xa2','\x66'},{'\xa2','\x67'},{'\xa2','\x68'},{'\xa2','\x69'},{'\xa2','\x70'},
    {'\xa2','\x6f'},{'\xa2','\x6e'},{'\xa2','\x6d'},{'\xa2','\x6c'},{'\xa2','\x6b'},
    {'\xa2','\x6a'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xf9','\xfe'},
    {'\xa2','\x76'},{'\xa2','\x79'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xbd'},{'\xa1','\xbc'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa1','\xb6'},{'\xa1','\xb5'},{'\x00','\x00'},{'\x00','\x00'},{'\x91','\xf4'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa1','\xbf'},{'\xa1','\xbe'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x91','\xf5'},{'\x00','\x00'},
    {'\xa1','\xbb'},{'\xa1','\xba'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa1','\xb3'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xb7'},{'\xa1','\xb4'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x91','\xf1'},{'\x91','\xf2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa2','\xa8'},{'\xa2','\xa9'},
    {'\xa2','\xab'},{'\xa2','\xaa'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xb3'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xba'},
    {'\x9d','\xbc'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xb9'},{'\xa1','\xb8'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xf3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9d','\x40'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9d','\xed'},{'\x9c','\xd1'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9d','\x4f'},{'\x9d','\x4e'},{'\x00','\x00'},{'\x9d','\x4d'},{'\x9d','\x50'},
    {'\x9d','\xd5'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9f','\x55'},{'\x9f','\x56'},{'\x9f','\x5d'},{'\x9f','\x5b'},{'\x9f','\x58'},
    {'\x9f','\x59'},{'\x9f','\x5a'},{'\x9f','\x5c'},{'\x9f','\x57'},{'\x00','\x00'},
    {'\x9d','\x5e'},{'\x9d','\x5d'},{'\x98','\xfc'},{'\x9d','\xb8'},{'\x9d','\x57'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa1','\xf0'},{'\xa1','\xf2'},{'\xa1','\xf1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xd8'},
    {'\x9d','\xdd'},{'\x9d','\xdb'},{'\x9d','\xda'},{'\x9d','\xd7'},{'\x9d','\xde'},
    {'\x9d','\xdc'},{'\x9d','\xd9'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\x66'},
    {'\x00','\x00'},{'\x9d','\x65'},{'\xa2','\xea'},{'\x00','\x00'},{'\xa1','\xad'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9d','\x6c'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xc0'},{'\x9d','\x6b'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\x55'},{'\x00','\x00'},
    {'\x9d','\x54'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9d','\x5c'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9d','\x5b'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc6','\xe6'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\x77'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x98','\x41'},{'\x98','\x42'},{'\x98','\x43'},
    {'\x98','\x44'},{'\x98','\x45'},{'\x98','\x46'},{'\x98','\x47'},{'\x98','\x48'},
    {'\x98','\x49'},{'\x98','\x4a'},{'\xc6','\xa1'},{'\xc6','\xa2'},{'\xc6','\xa3'},
    {'\xc6','\xa4'},{'\xc6','\xa5'},{'\xc6','\xa6'},{'\xc6','\xa7'},{'\xc6','\xa8'},
    {'\xc6','\xa9'},{'\xc6','\xaa'},{'\x98','\x41'},{'\x98','\x42'},{'\x98','\x43'},
    {'\x98','\x44'},{'\x98','\x45'},{'\x98','\x46'},{'\x98','\x47'},{'\x98','\x48'},
    {'\x98','\x49'},{'\x98','\x4a'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x91','\xed'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9c','\xce'},{'\x00','\x00'},{'\x00','\x00'},{'\x9c','\xd5'},
    {'\x00','\x00'},{'\x9c','\xd4'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9c','\xdb'},{'\x00','\x00'},{'\x91','\xdb'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x91','\xc9'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9c','\xf7'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xbf'},
    {'\xc6','\xc0'},{'\x00','\x00'},{'\xc6','\xc1'},{'\x00','\x00'},{'\xc6','\xc2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xc3'},
    {'\xc6','\xc4'},{'\xc6','\xc5'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc6','\xc6'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xc7'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xc8'},{'\x00','\x00'},{'\xc6','\xc9'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc6','\xca'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc6','\xcb'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xcc'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xcd'},{'\xc6','\xce'},
    {'\xc6','\xcf'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xd0'},
    {'\xc6','\xd1'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xd2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xd3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc6','\xd4'},{'\xc6','\xd5'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xd6'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xd7'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa1','\x40'},{'\xa1','\x42'},
    {'\xa1','\x43'},{'\xa1','\xb2'},{'\x00','\x00'},{'\xc6','\xe0'},{'\xc6','\xe1'},
    {'\xc6','\xe2'},{'\xa1','\x71'},{'\xa1','\x72'},{'\xa1','\x6d'},{'\xa1','\x6e'},
    {'\xa1','\x75'},{'\xa1','\x76'},{'\xa1','\x79'},{'\xa1','\x7a'},{'\xa1','\x69'},
    {'\xa1','\x6a'},{'\xa2','\x45'},{'\x96','\x5d'},{'\xa1','\x65'},{'\xa1','\x66'},
    {'\x9d','\x51'},{'\x9d','\x52'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xe3'},{'\xa1','\xa9'},{'\xa1','\xaa'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa2','\xc3'},{'\xa2','\xc4'},{'\xa2','\xc5'},{'\xa2','\xc6'},
    {'\xa2','\xc7'},{'\xa2','\xc8'},{'\xa2','\xc9'},{'\xa2','\xca'},{'\xa2','\xcb'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa1','\xca'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa2','\xcc'},
    {'\xa2','\xcd'},{'\xa2','\xce'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xe7'},{'\xc6','\xe8'},
    {'\xc6','\xe9'},{'\xc6','\xea'},{'\xc6','\xeb'},{'\xc6','\xec'},{'\xc6','\xed'},
    {'\xc6','\xee'},{'\xc6','\xef'},{'\xc6','\xf0'},{'\xc6','\xf1'},{'\xc6','\xf2'},
    {'\xc6','\xf3'},{'\xc6','\xf4'},{'\xc6','\xf5'},{'\xc6','\xf6'},{'\xc6','\xf7'},
    {'\xc6','\xf8'},{'\xc6','\xf9'},{'\xc6','\xfa'},{'\xc6','\xfb'},{'\xc6','\xfc'},
    {'\xc6','\xfd'},{'\xc6','\xfe'},{'\xc7','\x40'},{'\xc7','\x41'},{'\xc7','\x42'},
    {'\xc7','\x43'},{'\xc7','\x44'},{'\xc7','\x45'},{'\xc7','\x46'},{'\xc7','\x47'},
    {'\xc7','\x48'},{'\xc7','\x49'},{'\xc7','\x4a'},{'\xc7','\x4b'},{'\xc7','\x4c'},
    {'\xc7','\x4d'},{'\xc7','\x4e'},{'\xc7','\x4f'},{'\xc7','\x50'},{'\xc7','\x51'},
    {'\xc7','\x52'},{'\xc7','\x53'},{'\xc7','\x54'},{'\xc7','\x55'},{'\xc7','\x56'},
    {'\xc7','\x57'},{'\xc7','\x58'},{'\xc7','\x59'},{'\xc7','\x5a'},{'\xc7','\x5b'},
    {'\xc7','\x5c'},{'\xc7','\x5d'},{'\xc7','\x5e'},{'\xc7','\x5f'},{'\xc7','\x60'},
    {'\xc7','\x61'},{'\xc7','\x62'},{'\xc7','\x63'},{'\xc7','\x64'},{'\xc7','\x65'},
    {'\xc7','\x66'},{'\xc7','\x67'},{'\xc7','\x68'},{'\xc7','\x69'},{'\xc7','\x6a'},
    {'\xc7','\x6b'},{'\xc7','\x6c'},{'\xc7','\x6d'},{'\xc7','\x6e'},{'\xc7','\x6f'},
    {'\xc7','\x70'},{'\xc7','\x71'},{'\xc7','\x72'},{'\xc7','\x73'},{'\xc7','\x74'},
    {'\xc7','\x75'},{'\xc7','\x76'},{'\xc7','\x77'},{'\xc7','\x78'},{'\xc7','\x79'},
    {'\xc7','\x7a'},{'\xc8','\xb3'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc8','\xb1'},{'\xc8','\xb2'},
    {'\xc6','\xdc'},{'\xc6','\xdd'},{'\x00','\x00'},{'\x00','\x00'},{'\xc7','\x7b'},
    {'\xc7','\x7c'},{'\xc7','\x7d'},{'\xc7','\x7e'},{'\xc7','\xa1'},{'\xc7','\xa2'},
    {'\xc7','\xa3'},{'\xc7','\xa4'},{'\xc7','\xa5'},{'\xc7','\xa6'},{'\xc7','\xa7'},
    {'\xc7','\xa8'},{'\xc7','\xa9'},{'\xc7','\xaa'},{'\xc7','\xab'},{'\xc7','\xac'},
    {'\xc7','\xad'},{'\xc7','\xae'},{'\xc7','\xaf'},{'\xc7','\xb0'},{'\xc7','\xb1'},
    {'\xc7','\xb2'},{'\xc7','\xb3'},{'\xc7','\xb4'},{'\xc7','\xb5'},{'\xc7','\xb6'},
    {'\xc7','\xb7'},{'\xc7','\xb8'},{'\xc7','\xb9'},{'\xc7','\xba'},{'\xc7','\xbb'},
    {'\xc7','\xbc'},{'\xc7','\xbd'},{'\xc7','\xbe'},{'\xc7','\xbf'},{'\xc7','\xc0'},
    {'\xc7','\xc1'},{'\xc7','\xc2'},{'\xc7','\xc3'},{'\xc7','\xc4'},{'\xc7','\xc5'},
    {'\xc7','\xc6'},{'\xc7','\xc7'},{'\xc7','\xc8'},{'\xc7','\xc9'},{'\xc7','\xca'},
    {'\xc7','\xcb'},{'\xc7','\xcc'},{'\xc7','\xcd'},{'\xc7','\xce'},{'\xc7','\xcf'},
    {'\xc7','\xd0'},{'\xc7','\xd1'},{'\xc7','\xd2'},{'\xc7','\xd3'},{'\xc7','\xd4'},
    {'\xc7','\xd5'},{'\xc7','\xd6'},{'\xc7','\xd7'},{'\xc7','\xd8'},{'\xc7','\xd9'},
    {'\xc7','\xda'},{'\xc7','\xdb'},{'\xc7','\xdc'},{'\xc7','\xdd'},{'\xc7','\xde'},
    {'\xc7','\xdf'},{'\xc7','\xe0'},{'\xc7','\xe1'},{'\xc7','\xe2'},{'\xc7','\xe3'},
    {'\xc7','\xe4'},{'\xc7','\xe5'},{'\xc7','\xe6'},{'\xc7','\xe7'},{'\xc7','\xe8'},
    {'\xc7','\xe9'},{'\xc7','\xea'},{'\xc7','\xeb'},{'\xc7','\xec'},{'\xc7','\xed'},
    {'\xc7','\xee'},{'\xc7','\xef'},{'\xc7','\xf0'},{'\xc7','\xf1'},{'\xc7','\xf2'},
    {'\xc8','\xb4'},{'\xc8','\xb5'},{'\xc8','\xb6'},{'\xc8','\xb7'},{'\xc8','\xb8'},
    {'\xc6','\xe3'},{'\xc6','\xda'},{'\xc6','\xdb'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa3','\x74'},
    {'\xa3','\x75'},{'\xa3','\x76'},{'\xa3','\x77'},{'\xa3','\x78'},{'\xa3','\x79'},
    {'\xa3','\x7a'},{'\xa3','\x7b'},{'\xa3','\x7c'},{'\xa3','\x7d'},{'\xa3','\x7e'},
    {'\xa3','\xa1'},{'\xa3','\xa2'},{'\xa3','\xa3'},{'\xa3','\xa4'},{'\xa3','\xa5'},
    {'\xa3','\xa6'},{'\xa3','\xa7'},{'\xa3','\xa8'},{'\xa3','\xa9'},{'\xa3','\xaa'},
    {'\xa3','\xab'},{'\xa3','\xac'},{'\xa3','\xad'},{'\xa3','\xae'},{'\xa3','\xaf'},
    {'\xa3','\xb0'},{'\xa3','\xb1'},{'\xa3','\xb2'},{'\xa3','\xb3'},{'\xa3','\xb4'},
    {'\xa3','\xb5'},{'\xa3','\xb6'},{'\xa3','\xb7'},{'\xa3','\xb8'},{'\xa3','\xb9'},
    {'\xa3','\xba'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa4','\x40'},{'\xa4','\x47'},{'\xa4','\x54'},{'\xa5','\x7c'},{'\xa4','\x57'},
    {'\xa4','\xa4'},{'\xa4','\x55'},{'\xa5','\xd2'},{'\xa4','\x41'},{'\xa4','\xfe'},
    {'\xa4','\x42'},{'\xa4','\xd1'},{'\xa6','\x61'},{'\xa4','\x48'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc8','\x79'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9c','\x41'},{'\x9c','\x42'},{'\x9c','\x43'},
    {'\x9c','\x44'},{'\x9c','\x45'},{'\x9c','\x46'},{'\x9c','\x47'},{'\x9c','\x48'},
    {'\x9c','\x49'},{'\x9c','\x4a'},{'\xa4','\xeb'},{'\xa4','\xf5'},{'\xa4','\xf4'},
    {'\xa4','\xec'},{'\xaa','\xf7'},{'\xa4','\x67'},{'\xa4','\xe9'},{'\x99','\xfd'},
    {'\x99','\xfc'},{'\xaa','\xc0'},{'\xa6','\x57'},{'\xaf','\x53'},{'\xb0','\x5d'},
    {'\xaf','\xac'},{'\xb3','\xd2'},{'\xa5','\x4e'},{'\xa9','\x49'},{'\xbe','\xc7'},
    {'\xba','\xca'},{'\xa5','\xf8'},{'\xb8','\xea'},{'\xa8','\xf3'},{'\xb2','\xbd'},
    {'\xa5','\xf0'},{'\xa6','\xdb'},{'\xa6','\xdc'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa4','\x40'},{'\xa4','\x47'},
    {'\xa4','\x54'},{'\xa5','\x7c'},{'\xa4','\xad'},{'\xa4','\xbb'},{'\xa4','\x43'},
    {'\xa4','\x4b'},{'\xa4','\x45'},{'\xa4','\x51'},{'\xa4','\xeb'},{'\xa4','\xf5'},
    {'\xa4','\xf4'},{'\xa4','\xec'},{'\xaa','\xf7'},{'\xa4','\x67'},{'\xa4','\xe9'},
    {'\xae','\xe8'},{'\xa6','\xb3'},{'\xaa','\xc0'},{'\xa6','\x57'},{'\xaf','\x53'},
    {'\xb0','\x5d'},{'\xaf','\xac'},{'\xb3','\xd2'},{'\xaf','\xb5'},{'\xa8','\x6b'},
    {'\xa4','\x6b'},{'\xbe','\x41'},{'\xc0','\x75'},{'\xa6','\x4c'},{'\xaa','\x60'},
    {'\xb6','\xb5'},{'\xa5','\xf0'},{'\xbc','\x67'},{'\xa1','\xc0'},{'\xa4','\x57'},
    {'\xa4','\xa4'},{'\xa4','\x55'},{'\xa5','\xaa'},{'\xa5','\x6b'},{'\xc2','\xe5'},
    {'\xa9','\x76'},{'\xbe','\xc7'},{'\xba','\xca'},{'\xa5','\xf8'},{'\xb8','\xea'},
    {'\xa8','\xf3'},{'\xa9','\x5d'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x48','\x67'},
    {'\x00','\x00'},{'\x65','\x56'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x64','\x61'},{'\x41','\x55'},{'\x00','\x00'},{'\x6f','\x56'},{'\x70','\x63'},
    {'\x64','\x6d'},{'\x00','\x00'},{'\x00','\x00'},{'\x49','\x55'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x70','\x41'},
    {'\x6e','\x41'},{'\x00','\x00'},{'\x6d','\x41'},{'\x6b','\x41'},{'\x4b','\x42'},
    {'\x4d','\x42'},{'\x47','\x42'},{'\x00','\x00'},{'\x00','\x00'},{'\x70','\x46'},
    {'\x6e','\x46'},{'\x00','\x00'},{'\x00','\x00'},{'\xa2','\x55'},{'\xa2','\x56'},
    {'\x48','\x7a'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x66','\x6d'},
    {'\x6e','\x6d'},{'\x00','\x00'},{'\xa2','\x50'},{'\xa2','\x51'},{'\xa2','\x52'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa2','\x54'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9d','\xe7'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x50','\x61'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x70','\x73'},{'\x6e','\x73'},{'\x00','\x00'},
    {'\x6d','\x73'},{'\x70','\x56'},{'\x6e','\x56'},{'\x00','\x00'},{'\x6d','\x56'},
    {'\x6b','\x56'},{'\x4d','\x56'},{'\x70','\x57'},{'\x6e','\x57'},{'\x00','\x00'},
    {'\x6d','\x57'},{'\x6b','\x57'},{'\x4d','\x57'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9d','\xe3'},{'\x42','\x71'},{'\xa2','\x57'},{'\x63','\x64'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x64','\x42'},{'\x47','\x79'},{'\x68','\x61'},{'\x48','\x50'},
    {'\x69','\x6e'},{'\x4b','\x4b'},{'\xa2','\x53'},{'\x6b','\x74'},{'\x6c','\x6d'},
    {'\xa1','\xeb'},{'\xa1','\xea'},{'\x6c','\x78'},{'\x6d','\x62'},{'\xa2','\x4f'},
    {'\x00','\x00'},{'\x50','\x48'},{'\x9d','\xe4'},{'\x00','\x00'},{'\x50','\x52'},
    {'\x73','\x72'},{'\x53','\x76'},{'\x57','\x62'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x91','\xe0'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\xa2'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfb','\x44'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x95','\xb8'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\x48'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\x4c'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xfb','\xdf'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfb','\xe5'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xfb','\x6f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x95','\x42'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xfe','\x7d'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xfe','\x67'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x95','\x5e'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x95','\xde'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x95','\xc7'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfc','\x61'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x95','\xc9'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xfc','\x7c'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfc','\xa8'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xfe','\x71'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfc','\xc2'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xfe','\x4d'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x96','\xad'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9c','\xd3'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfd','\x5e'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xfe','\x4a'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xfd','\x67'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfb','\xb0'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfb','\x7d'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfd','\xe3'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfd','\xf1'},{'\x00','\x00'},{'\x00','\x00'},{'\xfd','\xef'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfd','\xf2'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfb','\x45'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa4','\x40'},{'\xa4','\x42'},
    {'\x00','\x00'},{'\xa4','\x43'},{'\x98','\xa7'},{'\x00','\x00'},{'\x91','\xd7'},
    {'\xc9','\x45'},{'\xa4','\x56'},{'\xa4','\x54'},{'\xa4','\x57'},{'\xa4','\x55'},
    {'\xc9','\x46'},{'\xa4','\xa3'},{'\xc9','\x4f'},{'\xc9','\x4d'},{'\xa4','\xa2'},
    {'\xa4','\xa1'},{'\x00','\x00'},{'\x83','\xfd'},{'\xa5','\x42'},{'\xa5','\x41'},
    {'\xa5','\x40'},{'\x81','\x40'},{'\xa5','\x43'},{'\xa4','\xfe'},{'\x85','\xd2'},
    {'\x8a','\xbd'},{'\x83','\x5b'},{'\x85','\x46'},{'\xa5','\xe0'},{'\xa5','\xe1'},
    {'\x00','\x00'},{'\x93','\xe5'},{'\x81','\x41'},{'\x00','\x00'},{'\x83','\x55'},
    {'\x8b','\xf2'},{'\xa8','\xc3'},{'\x84','\xca'},{'\x9c','\xc9'},{'\x00','\x00'},
    {'\x83','\xaa'},{'\xa4','\x58'},{'\x81','\x42'},{'\xa4','\xa4'},{'\xc9','\x50'},
    {'\x98','\xa8'},{'\xa4','\xa5'},{'\xc9','\x63'},{'\xa6','\xea'},{'\xcb','\xb1'},
    {'\x8a','\x5a'},{'\x00','\x00'},{'\xc6','\xbf'},{'\x91','\xcc'},{'\xa4','\x59'},
    {'\xa4','\xa6'},{'\x83','\x6f'},{'\xa5','\x44'},{'\xc9','\x64'},{'\x8b','\xed'},
    {'\x8a','\x5b'},{'\xc6','\xc0'},{'\x00','\x00'},{'\x00','\x00'},{'\xc9','\x40'},
    {'\xa4','\x44'},{'\x94','\xf2'},{'\xa4','\x5b'},{'\x00','\x00'},{'\xc9','\x47'},
    {'\xa4','\x5c'},{'\x85','\xf3'},{'\x00','\x00'},{'\xa4','\xa7'},{'\x83','\xbf'},
    {'\xa5','\x45'},{'\xa5','\x47'},{'\xa5','\x46'},{'\x87','\xe4'},{'\x00','\x00'},
    {'\xa5','\xe2'},{'\xa5','\xe3'},{'\x84','\xce'},{'\x81','\x43'},{'\xa8','\xc4'},
    {'\x92','\xe9'},{'\xad','\xbc'},{'\xa4','\x41'},{'\x9c','\xdf'},{'\x9c','\xe8'},
    {'\xc9','\x41'},{'\xa4','\x45'},{'\xa4','\x5e'},{'\xa4','\x5d'},{'\x84','\x74'},
    {'\x85','\x70'},{'\x81','\x44'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x83','\xbc'},{'\x00','\x00'},{'\x00','\x00'},{'\xa5','\xe4'},{'\xfe','\x41'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x85','\x67'},{'\x85','\xaf'},{'\x00','\x00'},{'\xa8','\xc5'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\x61'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xb0','\xae'},
    {'\xd4','\x4b'},{'\x93','\xfa'},{'\x98','\xa9'},{'\xb6','\xc3'},{'\xdc','\xb1'},
    {'\xdc','\xb2'},{'\xc6','\xc1'},{'\xa4','\x46'},{'\x98','\xaa'},{'\xa4','\xa9'},
    {'\x83','\x5c'},{'\x81','\x45'},{'\xa8','\xc6'},{'\xa4','\x47'},{'\xc9','\x48'},
    {'\xa4','\x5f'},{'\x8a','\x5f'},{'\x00','\x00'},{'\xa4','\xaa'},{'\xa4','\xac'},
    {'\xc9','\x51'},{'\xa4','\xad'},{'\xa4','\xab'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfe','\x62'},{'\xa5','\xe5'},{'\x83','\x52'},{'\xa8','\xc7'},{'\x92','\x40'},
    {'\x00','\x00'},{'\xa8','\xc8'},{'\xab','\x45'},{'\xc6','\xc2'},{'\xa4','\x60'},
    {'\xa4','\xae'},{'\x98','\xab'},{'\xa5','\xe6'},{'\xa5','\xe8'},{'\xa5','\xe7'},
    {'\x84','\x64'},{'\xa6','\xeb'},{'\x83','\xc2'},{'\x00','\x00'},{'\xa8','\xc9'},
    {'\xa8','\xca'},{'\xab','\x46'},{'\xab','\x47'},{'\x00','\x00'},{'\x81','\x46'},
    {'\x00','\x00'},{'\x89','\x5d'},{'\xad','\xbd'},{'\x00','\x00'},{'\x8a','\x62'},
    {'\xdc','\xb3'},{'\x98','\xac'},{'\x00','\x00'},{'\xf6','\xd6'},{'\xa4','\x48'},
    {'\x9c','\xf4'},{'\x98','\xad'},{'\x00','\x00'},{'\x00','\x00'},{'\x87','\xa3'},
    {'\xa4','\xb0'},{'\xa4','\xaf'},{'\xc9','\x52'},{'\xa4','\xb1'},{'\xa4','\xb7'},
    {'\x85','\xb2'},{'\xa4','\xb2'},{'\xa4','\xb3'},{'\xc9','\x54'},{'\xc9','\x53'},
    {'\xa4','\xb5'},{'\xa4','\xb6'},{'\x00','\x00'},{'\xa4','\xb4'},{'\x84','\x47'},
    {'\x93','\xc2'},{'\x00','\x00'},{'\x83','\x54'},{'\x00','\x00'},{'\x83','\xac'},
    {'\xa5','\x4a'},{'\xa5','\x4b'},{'\xa5','\x4c'},{'\xa5','\x4d'},{'\xa5','\x49'},
    {'\xa5','\x50'},{'\xc9','\x6a'},{'\x00','\x00'},{'\xc9','\x66'},{'\xc9','\x69'},
    {'\xa5','\x51'},{'\xa5','\x61'},{'\x00','\x00'},{'\xc9','\x68'},{'\x00','\x00'},
    {'\xa5','\x4e'},{'\xa5','\x4f'},{'\xa5','\x48'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc9','\x65'},{'\xc9','\x67'},{'\x87','\xa4'},{'\x81','\x47'},{'\x83','\xa8'},
    {'\x81','\x48'},{'\x92','\x54'},{'\x00','\x00'},{'\xa5','\xf5'},{'\xc9','\xb0'},
    {'\xa5','\xf2'},{'\xa5','\xf6'},{'\xc9','\xba'},{'\xc9','\xae'},{'\xa5','\xf3'},
    {'\xc9','\xb2'},{'\x98','\xae'},{'\x00','\x00'},{'\x00','\x00'},{'\xa5','\xf4'},
    {'\x81','\x49'},{'\xa5','\xf7'},{'\x00','\x00'},{'\xa5','\xe9'},{'\xc9','\xb1'},
    {'\xa5','\xf8'},{'\xc9','\xb5'},{'\xfb','\xba'},{'\xc9','\xb9'},{'\xc9','\xb6'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc9','\xb3'},{'\xa5','\xea'},{'\xa5','\xec'},
    {'\xa5','\xf9'},{'\x00','\x00'},{'\xa5','\xee'},{'\xc9','\xab'},{'\xa5','\xf1'},
    {'\xa5','\xef'},{'\xa5','\xf0'},{'\xc9','\xbb'},{'\xc9','\xb8'},{'\xc9','\xaf'},
    {'\xa5','\xed'},{'\x00','\x00'},{'\x84','\x67'},{'\xc9','\xac'},{'\xa5','\xeb'},
    {'\x85','\xd1'},{'\x8d','\xfd'},{'\x81','\x4a'},{'\xc9','\xb4'},{'\x84','\xc4'},
    {'\x83','\xec'},{'\x85','\xb1'},{'\x00','\x00'},{'\xc9','\xb7'},{'\x00','\x00'},
    {'\x85','\xb4'},{'\x83','\xa9'},{'\x83','\xab'},{'\x84','\xc3'},{'\x98','\xaf'},
    {'\x98','\xb0'},{'\x83','\xeb'},{'\x83','\x43'},{'\xc9','\xad'},{'\xca','\x66'},
    {'\x00','\x00'},{'\xa7','\x42'},{'\xa6','\xf4'},{'\x00','\x00'},{'\xfb','\xbd'},
    {'\xca','\x67'},{'\xa6','\xf1'},{'\x00','\x00'},{'\xa7','\x44'},{'\x98','\xb1'},
    {'\xa6','\xf9'},{'\xfb','\xbc'},{'\xa6','\xf8'},{'\xca','\x5b'},{'\xa6','\xfc'},
    {'\xa6','\xf7'},{'\xca','\x60'},{'\xca','\x68'},{'\x00','\x00'},{'\xca','\x64'},
    {'\x98','\xb2'},{'\xa6','\xfa'},{'\x00','\x00'},{'\x98','\xb3'},{'\xa6','\xfd'},
    {'\xa6','\xee'},{'\xa7','\x47'},{'\xca','\x5d'},{'\x00','\x00'},{'\x98','\xb4'},
    {'\xcb','\xbd'},{'\xa6','\xec'},{'\xa7','\x43'},{'\xa6','\xed'},{'\xa6','\xf5'},
    {'\xa6','\xf6'},{'\xca','\x62'},{'\xca','\x5e'},{'\xa6','\xfb'},{'\xa6','\xf3'},
    {'\xca','\x5a'},{'\xa6','\xef'},{'\xca','\x65'},{'\xa7','\x45'},{'\xa7','\x48'},
    {'\xa6','\xf2'},{'\xa7','\x40'},{'\xa7','\x46'},{'\xa6','\xf0'},{'\xca','\x63'},
    {'\xa7','\x41'},{'\xca','\x69'},{'\xca','\x5c'},{'\xa6','\xfe'},{'\xca','\x5f'},
    {'\x8e','\x40'},{'\x00','\x00'},{'\xca','\x61'},{'\x00','\x00'},{'\xa8','\xd8'},
    {'\xcb','\xbf'},{'\xcb','\xcb'},{'\xa8','\xd0'},{'\x00','\x00'},{'\xcb','\xcc'},
    {'\xa8','\xcb'},{'\xa8','\xd5'},{'\x00','\x00'},{'\x98','\xb5'},{'\xa8','\xce'},
    {'\xcb','\xb9'},{'\xa8','\xd6'},{'\xcb','\xb8'},{'\xcb','\xbc'},{'\xcb','\xc3'},
    {'\xcb','\xc1'},{'\xa8','\xde'},{'\xa8','\xd9'},{'\xcb','\xb3'},{'\xcb','\xb5'},
    {'\xa8','\xdb'},{'\xa8','\xcf'},{'\xcb','\xb6'},{'\xcb','\xc2'},{'\xcb','\xc9'},
    {'\xa8','\xd4'},{'\xcb','\xbb'},{'\xcb','\xb4'},{'\xa8','\xd3'},{'\xcb','\xb7'},
    {'\xa8','\xd7'},{'\xcb','\xba'},{'\x81','\x4b'},{'\xa8','\xd2'},{'\x00','\x00'},
    {'\xa8','\xcd'},{'\x00','\x00'},{'\xa8','\xdc'},{'\xcb','\xc4'},{'\xa8','\xdd'},
    {'\xcb','\xc8'},{'\x00','\x00'},{'\xcb','\xc6'},{'\xcb','\xca'},{'\xa8','\xda'},
    {'\xcb','\xbe'},{'\xcb','\xb2'},{'\x00','\x00'},{'\xcb','\xc0'},{'\xa8','\xd1'},
    {'\xcb','\xc5'},{'\xa8','\xcc'},{'\xcb','\xc7'},{'\x00','\x00'},{'\x83','\x65'},
    {'\x92','\x55'},{'\x98','\xb6'},{'\x83','\x66'},{'\x00','\x00'},{'\x86','\xab'},
    {'\x83','\xed'},{'\x83','\xee'},{'\x86','\xac'},{'\x87','\xa7'},{'\x88','\xca'},
    {'\xfb','\xbe'},{'\x87','\xa6'},{'\x82','\x7d'},{'\xab','\x56'},{'\xab','\x4a'},
    {'\x98','\xb7'},{'\x00','\x00'},{'\xcd','\xe0'},{'\xcd','\xe8'},{'\x98','\xf7'},
    {'\xab','\x49'},{'\xab','\x51'},{'\xab','\x5d'},{'\x00','\x00'},{'\xcd','\xee'},
    {'\xcd','\xec'},{'\xcd','\xe7'},{'\x00','\x00'},{'\x98','\xb8'},{'\x00','\x00'},
    {'\xab','\x4b'},{'\xcd','\xed'},{'\xcd','\xe3'},{'\xab','\x59'},{'\xab','\x50'},
    {'\xab','\x58'},{'\xcd','\xde'},{'\x00','\x00'},{'\xcd','\xea'},{'\x98','\xb9'},
    {'\xcd','\xe1'},{'\xab','\x54'},{'\xcd','\xe2'},{'\x98','\xba'},{'\xcd','\xdd'},
    {'\xab','\x5b'},{'\xab','\x4e'},{'\xab','\x57'},{'\xab','\x4d'},{'\x00','\x00'},
    {'\xcd','\xdf'},{'\xcd','\xe4'},{'\x00','\x00'},{'\xcd','\xeb'},{'\xab','\x55'},
    {'\xab','\x52'},{'\xcd','\xe6'},{'\xab','\x5a'},{'\xcd','\xe9'},{'\xcd','\xe5'},
    {'\xab','\x4f'},{'\xab','\x5c'},{'\xab','\x53'},{'\xab','\x4c'},{'\xab','\x48'},
    {'\x00','\x00'},{'\x8d','\xb9'},{'\x94','\x5f'},{'\x94','\x60'},{'\x88','\xc8'},
    {'\x00','\x00'},{'\x8c','\xc8'},{'\x83','\xa7'},{'\x8c','\x6c'},{'\x00','\x00'},
    {'\xcd','\xef'},{'\x87','\xa8'},{'\xad','\xd7'},{'\xad','\xc1'},{'\x98','\xbb'},
    {'\xad','\xd1'},{'\x98','\xbc'},{'\xad','\xd6'},{'\xd0','\xd0'},{'\xd0','\xcf'},
    {'\xd0','\xd4'},{'\xd0','\xd5'},{'\xad','\xc4'},{'\x98','\xbd'},{'\xad','\xcd'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xfe','\x7b'},{'\xad','\xda'},{'\x81','\x4c'},
    {'\xad','\xce'},{'\x00','\x00'},{'\x00','\x00'},{'\x98','\xbe'},{'\x00','\x00'},
    {'\xd0','\xc9'},{'\xad','\xc7'},{'\xd0','\xca'},{'\x98','\xbf'},{'\xad','\xdc'},
    {'\x00','\x00'},{'\xad','\xd3'},{'\xad','\xbe'},{'\xad','\xbf'},{'\xd0','\xdd'},
    {'\xb0','\xbf'},{'\x00','\x00'},{'\xad','\xcc'},{'\xad','\xcb'},{'\xd0','\xcb'},
    {'\xad','\xcf'},{'\xd4','\x5b'},{'\xad','\xc6'},{'\xd0','\xd6'},{'\xad','\xd5'},
    {'\xad','\xd4'},{'\xad','\xca'},{'\xd0','\xce'},{'\xd0','\xd7'},{'\x00','\x00'},
    {'\xd0','\xc8'},{'\xad','\xc9'},{'\xd0','\xd8'},{'\xad','\xd2'},{'\xd0','\xcc'},
    {'\xad','\xc0'},{'\x82','\xa9'},{'\xad','\xc3'},{'\xad','\xc2'},{'\xd0','\xd9'},
    {'\xad','\xd0'},{'\xad','\xc5'},{'\xad','\xd9'},{'\xad','\xdb'},{'\xd0','\xd3'},
    {'\xad','\xd8'},{'\xfb','\xc1'},{'\xd0','\xdb'},{'\xd0','\xcd'},{'\xd0','\xdc'},
    {'\x00','\x00'},{'\xd0','\xd1'},{'\x98','\xc0'},{'\xd0','\xda'},{'\x82','\xa3'},
    {'\xd0','\xd2'},{'\x00','\x00'},{'\x92','\xb2'},{'\x85','\xb0'},{'\x98','\xc1'},
    {'\xad','\xc8'},{'\x00','\x00'},{'\x85','\xb3'},{'\x00','\x00'},{'\xd4','\x63'},
    {'\xd4','\x57'},{'\x81','\x4d'},{'\xb0','\xb3'},{'\x00','\x00'},{'\xd4','\x5c'},
    {'\xd4','\x62'},{'\xb0','\xb2'},{'\xd4','\x55'},{'\xb0','\xb6'},{'\xd4','\x59'},
    {'\xd4','\x52'},{'\xb0','\xb4'},{'\xd4','\x56'},{'\xb0','\xb9'},{'\xb0','\xbe'},
    {'\x81','\x4e'},{'\xd4','\x67'},{'\x00','\x00'},{'\xd4','\x51'},{'\x00','\x00'},
    {'\xb0','\xba'},{'\xfb','\xbf'},{'\xd4','\x66'},{'\x98','\xc2'},{'\x00','\x00'},
    {'\xb0','\xb5'},{'\xd4','\x58'},{'\xb0','\xb1'},{'\xd4','\x53'},{'\xd4','\x4f'},
    {'\xd4','\x5d'},{'\xd4','\x50'},{'\xd4','\x4e'},{'\xd4','\x5a'},{'\xd4','\x60'},
    {'\xd4','\x61'},{'\xb0','\xb7'},{'\x98','\xc3'},{'\x00','\x00'},{'\xd8','\x5b'},
    {'\xd4','\x5e'},{'\xd4','\x4d'},{'\xd4','\x5f'},{'\x85','\xb5'},{'\xb0','\xc1'},
    {'\xd4','\x64'},{'\xb0','\xc0'},{'\xd4','\x4c'},{'\x00','\x00'},{'\xd4','\x54'},
    {'\xd4','\x65'},{'\xb0','\xbc'},{'\xb0','\xbb'},{'\xb0','\xb8'},{'\xb0','\xbd'},
    {'\x81','\x4f'},{'\x00','\x00'},{'\xb0','\xaf'},{'\x8d','\xfe'},{'\x00','\x00'},
    {'\xb0','\xb0'},{'\x8e','\x65'},{'\x89','\xc8'},{'\xb3','\xc8'},{'\x98','\xc4'},
    {'\xd8','\x5e'},{'\xd8','\x57'},{'\x00','\x00'},{'\xb3','\xc5'},{'\x00','\x00'},
    {'\xd8','\x5f'},{'\x90','\xf0'},{'\x00','\x00'},{'\x00','\x00'},{'\xd8','\x55'},
    {'\xd8','\x58'},{'\xb3','\xc4'},{'\xd8','\x59'},{'\x00','\x00'},{'\x98','\xc5'},
    {'\xb3','\xc7'},{'\xd8','\x5d'},{'\x00','\x00'},{'\xd8','\x53'},{'\xd8','\x52'},
    {'\xb3','\xc9'},{'\x00','\x00'},{'\xb3','\xca'},{'\xb3','\xc6'},{'\xb3','\xcb'},
    {'\xd8','\x51'},{'\xd8','\x5c'},{'\xd8','\x5a'},{'\xd8','\x54'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb3','\xc3'},{'\xd8','\x56'},{'\x00','\x00'},
    {'\x8c','\xc9'},{'\xfb','\xc2'},{'\x88','\xc9'},{'\x89','\xc9'},{'\x8f','\xfb'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb6','\xca'},{'\xb6','\xc4'},{'\xdc','\xb7'},
    {'\xb6','\xcd'},{'\xdc','\xbd'},{'\xdc','\xc0'},{'\xb6','\xc6'},{'\xb6','\xc7'},
    {'\xdc','\xba'},{'\xb6','\xc5'},{'\xdc','\xc3'},{'\xb6','\xcb'},{'\xdc','\xc4'},
    {'\x00','\x00'},{'\xdc','\xbf'},{'\xb6','\xcc'},{'\x98','\xc6'},{'\xdc','\xb4'},
    {'\xb6','\xc9'},{'\xdc','\xb5'},{'\x00','\x00'},{'\xdc','\xbe'},{'\xdc','\xbc'},
    {'\x00','\x00'},{'\xdc','\xb8'},{'\xb6','\xc8'},{'\xdc','\xb6'},{'\xb6','\xce'},
    {'\xdc','\xbb'},{'\xdc','\xc2'},{'\xdc','\xb9'},{'\xdc','\xc1'},{'\x00','\x00'},
    {'\x94','\x4f'},{'\xb9','\xb6'},{'\xb9','\xb3'},{'\x98','\xc7'},{'\xb9','\xb4'},
    {'\x00','\x00'},{'\xe0','\xf9'},{'\xe0','\xf1'},{'\xb9','\xb2'},{'\xb9','\xaf'},
    {'\xe0','\xf2'},{'\x81','\x50'},{'\xfb','\xc3'},{'\xb9','\xb1'},{'\xe0','\xf5'},
    {'\x00','\x00'},{'\xe0','\xf7'},{'\x81','\x51'},{'\x98','\xc8'},{'\xe0','\xfe'},
    {'\x98','\xc9'},{'\x00','\x00'},{'\xe0','\xfd'},{'\xe0','\xf8'},{'\xb9','\xae'},
    {'\xe0','\xf0'},{'\xb9','\xac'},{'\xe0','\xf3'},{'\xb9','\xb7'},{'\xe0','\xf6'},
    {'\x00','\x00'},{'\xe0','\xfa'},{'\xb9','\xb0'},{'\xb9','\xad'},{'\xe0','\xfc'},
    {'\xe0','\xfb'},{'\xb9','\xb5'},{'\x00','\x00'},{'\xe0','\xf4'},{'\x81','\x52'},
    {'\xbb','\xf8'},{'\xe4','\xec'},{'\x00','\x00'},{'\xe4','\xe9'},{'\xbb','\xf9'},
    {'\x00','\x00'},{'\xbb','\xf7'},{'\x98','\xca'},{'\xe4','\xf0'},{'\xe4','\xed'},
    {'\xe4','\xe6'},{'\xbb','\xf6'},{'\xfb','\xc6'},{'\xbb','\xfa'},{'\xe4','\xe7'},
    {'\xbb','\xf5'},{'\xbb','\xfd'},{'\xe4','\xea'},{'\xe4','\xeb'},{'\xbb','\xfb'},
    {'\xbb','\xfc'},{'\xe4','\xf1'},{'\xe4','\xee'},{'\xe4','\xef'},{'\x98','\xcb'},
    {'\xfb','\xc4'},{'\x00','\x00'},{'\xbe','\xaa'},{'\xe8','\xf8'},{'\xbe','\xa7'},
    {'\xe8','\xf5'},{'\xbe','\xa9'},{'\xbe','\xab'},{'\x81','\x53'},{'\xe8','\xf6'},
    {'\xbe','\xa8'},{'\x00','\x00'},{'\xe8','\xf7'},{'\x00','\x00'},{'\xe8','\xf4'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc0','\x76'},{'\xec','\xbd'},{'\xc0','\x77'},
    {'\xec','\xbb'},{'\x00','\x00'},{'\xec','\xbc'},{'\xec','\xba'},{'\xec','\xb9'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xec','\xbe'},{'\xc0','\x75'},{'\x98','\xcc'},
    {'\x00','\x00'},{'\xef','\xb8'},{'\xef','\xb9'},{'\x00','\x00'},{'\xe4','\xe8'},
    {'\xef','\xb7'},{'\xc0','\x78'},{'\xc3','\x5f'},{'\xf1','\xeb'},{'\xf1','\xec'},
    {'\x00','\x00'},{'\xc4','\xd7'},{'\xc4','\xd8'},{'\xf5','\xc1'},{'\xf5','\xc0'},
    {'\xc5','\x6c'},{'\xc5','\x6b'},{'\xf7','\xd0'},{'\x00','\x00'},{'\xa4','\x49'},
    {'\xa4','\x61'},{'\xa4','\xb9'},{'\x00','\x00'},{'\xa4','\xb8'},{'\xa5','\x53'},
    {'\xa5','\x52'},{'\xa5','\xfc'},{'\xa5','\xfb'},{'\xa5','\xfd'},{'\xa5','\xfa'},
    {'\x81','\x54'},{'\xa7','\x4a'},{'\xa7','\x49'},{'\xa7','\x4b'},{'\x95','\xfc'},
    {'\x00','\x00'},{'\x92','\xd1'},{'\x81','\x55'},{'\xa8','\xe0'},{'\x00','\x00'},
    {'\xa8','\xdf'},{'\xa8','\xe1'},{'\x83','\x67'},{'\xab','\x5e'},{'\x00','\x00'},
    {'\xa2','\x59'},{'\xd0','\xde'},{'\xa2','\x5a'},{'\xb0','\xc2'},{'\xa2','\x5c'},
    {'\xa2','\x5b'},{'\xd8','\x60'},{'\x98','\xcd'},{'\xa2','\x5d'},{'\xb9','\xb8'},
    {'\xa2','\x5e'},{'\x81','\x56'},{'\xa4','\x4a'},{'\x00','\x00'},{'\xa4','\xba'},
    {'\xa5','\xfe'},{'\xa8','\xe2'},{'\x81','\x57'},{'\xa4','\x4b'},{'\xa4','\xbd'},
    {'\xa4','\xbb'},{'\xa4','\xbc'},{'\x00','\x00'},{'\x8c','\xa3'},{'\xa6','\x40'},
    {'\x00','\x00'},{'\x8b','\xd7'},{'\x89','\x55'},{'\xa7','\x4c'},{'\xa8','\xe4'},
    {'\xa8','\xe3'},{'\xa8','\xe5'},{'\x90','\xbc'},{'\x00','\x00'},{'\x88','\xb5'},
    {'\xad','\xdd'},{'\x8b','\xa6'},{'\x00','\x00'},{'\x00','\x00'},{'\xbe','\xac'},
    {'\x90','\x54'},{'\xc6','\xc3'},{'\x00','\x00'},{'\x00','\x00'},{'\x81','\x58'},
    {'\x92','\x4c'},{'\xc9','\x4e'},{'\x83','\x58'},{'\xa5','\x54'},{'\xa5','\x55'},
    {'\x00','\x00'},{'\x95','\xe4'},{'\xa6','\x41'},{'\x00','\x00'},{'\xca','\x6a'},
    {'\x81','\x59'},{'\xab','\x60'},{'\xab','\x5f'},{'\xd0','\xe0'},{'\xd0','\xdf'},
    {'\xb0','\xc3'},{'\xc6','\xc4'},{'\xa4','\xbe'},{'\xc9','\x55'},{'\x87','\xc0'},
    {'\xfb','\x41'},{'\x83','\x7e'},{'\x86','\x61'},{'\x81','\x5a'},{'\xcb','\xcd'},
    {'\x00','\x00'},{'\xab','\x61'},{'\x00','\x00'},{'\xad','\xe0'},{'\x00','\x00'},
    {'\xad','\xde'},{'\xad','\xdf'},{'\x81','\x5b'},{'\xfb','\x4e'},{'\x81','\x5c'},
    {'\x81','\x5d'},{'\xbe','\xad'},{'\xc6','\xc5'},{'\xa5','\x56'},{'\x00','\x00'},
    {'\x98','\xce'},{'\x85','\xad'},{'\xa6','\x42'},{'\xc9','\xbc'},{'\x83','\x4c'},
    {'\x83','\x4b'},{'\x94','\xfb'},{'\x95','\xd5'},{'\xa7','\x4d'},{'\xa7','\x4e'},
    {'\x98','\xcf'},{'\xca','\x6b'},{'\x00','\x00'},{'\x83','\xad'},{'\xcb','\xce'},
    {'\xa8','\xe6'},{'\xcb','\xcf'},{'\x00','\x00'},{'\x84','\x60'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x95','\xf3'},{'\xd0','\xe2'},{'\xd0','\xe3'},{'\xad','\xe3'},
    {'\x81','\x5e'},{'\xd0','\xe4'},{'\x84','\x5b'},{'\xd0','\xe1'},{'\xad','\xe4'},
    {'\xad','\xe2'},{'\xad','\xe1'},{'\xd0','\xe5'},{'\x90','\xb6'},{'\xd4','\x68'},
    {'\x84','\xee'},{'\x98','\xd0'},{'\xfb','\xcf'},{'\xd8','\x61'},{'\x00','\x00'},
    {'\x81','\x5f'},{'\xdc','\xc5'},{'\xe1','\x40'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x81','\x60'},{'\xbb','\xfe'},{'\xbe','\xae'},{'\xe8','\xf9'},{'\xfb','\xd0'},
    {'\xa4','\x4c'},{'\xa4','\x5a'},{'\x98','\xd1'},{'\x00','\x00'},{'\x87','\xa1'},
    {'\x00','\x00'},{'\x92','\xe1'},{'\x94','\x4c'},{'\x00','\x00'},{'\x94','\x61'},
    {'\x94','\x52'},{'\x8e','\x63'},{'\x81','\x61'},{'\x88','\xd7'},{'\x00','\x00'},
    {'\x84','\xc5'},{'\xb0','\xc4'},{'\xb3','\xcd'},{'\x00','\x00'},{'\xb9','\xb9'},
    {'\xfb','\xc7'},{'\xc9','\x42'},{'\xa4','\xbf'},{'\x00','\x00'},{'\xa5','\x59'},
    {'\xa5','\x57'},{'\xa5','\x58'},{'\x89','\xdb'},{'\x81','\x62'},{'\xa8','\xe7'},
    {'\xfb','\xd2'},{'\x8d','\xad'},{'\xa4','\x4d'},{'\xa4','\x4e'},{'\xc8','\x7d'},
    {'\xa4','\x62'},{'\x95','\xcf'},{'\x98','\xd2'},{'\xa4','\xc0'},{'\xa4','\xc1'},
    {'\xa4','\xc2'},{'\xc9','\xbe'},{'\xa5','\x5a'},{'\x81','\x63'},{'\xc9','\x6b'},
    {'\x83','\xd2'},{'\xa6','\x46'},{'\x00','\x00'},{'\xc9','\xbf'},{'\xa6','\x44'},
    {'\xa6','\x45'},{'\xc9','\xbd'},{'\x81','\x64'},{'\x81','\x65'},{'\xa6','\x47'},
    {'\xa6','\x43'},{'\x87','\xaa'},{'\x83','\x68'},{'\x83','\xae'},{'\x84','\xc7'},
    {'\xca','\x6c'},{'\xaa','\xec'},{'\xca','\x6d'},{'\xfb','\xc8'},{'\x81','\x66'},
    {'\xca','\x6e'},{'\x00','\x00'},{'\xa0','\x7e'},{'\xa7','\x50'},{'\xa7','\x4f'},
    {'\x95','\x7b'},{'\x95','\xe5'},{'\xa7','\x53'},{'\xa7','\x51'},{'\xa7','\x52'},
    {'\x81','\x67'},{'\x00','\x00'},{'\x8d','\xba'},{'\xa8','\xed'},{'\x00','\x00'},
    {'\xa8','\xec'},{'\xcb','\xd4'},{'\xcb','\xd1'},{'\xcb','\xd2'},{'\x98','\xd3'},
    {'\xcb','\xd0'},{'\xa8','\xee'},{'\xa8','\xea'},{'\xa8','\xe9'},{'\x81','\x68'},
    {'\xa8','\xeb'},{'\xa8','\xe8'},{'\x98','\xd4'},{'\x87','\xac'},{'\x00','\x00'},
    {'\x8e','\xaf'},{'\x84','\xc6'},{'\xa8','\xef'},{'\x88','\xcc'},{'\xab','\x63'},
    {'\xcd','\xf0'},{'\x00','\x00'},{'\xcb','\xd3'},{'\xab','\x68'},{'\x00','\x00'},
    {'\xcd','\xf1'},{'\xab','\x64'},{'\xab','\x67'},{'\xab','\x66'},{'\xab','\x65'},
    {'\xab','\x62'},{'\x81','\x69'},{'\x8d','\xc8'},{'\x87','\xab'},{'\xd0','\xe8'},
    {'\x00','\x00'},{'\xad','\xe7'},{'\xd0','\xeb'},{'\xad','\xe5'},{'\xfb','\xca'},
    {'\x00','\x00'},{'\x98','\xd5'},{'\xd0','\xe7'},{'\xad','\xe8'},{'\xad','\xe6'},
    {'\xad','\xe9'},{'\xd0','\xe9'},{'\xd0','\xea'},{'\xfb','\xc9'},{'\xd0','\xe6'},
    {'\xd0','\xec'},{'\x92','\xb3'},{'\x92','\xc9'},{'\x82','\x76'},{'\x00','\x00'},
    {'\x87','\xa9'},{'\x98','\xd6'},{'\xb3','\xd1'},{'\xb0','\xc5'},{'\xd4','\x69'},
    {'\xd4','\x6b'},{'\xd4','\x6a'},{'\xd4','\x6c'},{'\xb0','\xc6'},{'\x92','\xeb'},
    {'\x81','\x6a'},{'\xb3','\xce'},{'\xfc','\xf5'},{'\xb3','\xcf'},{'\xb3','\xd0'},
    {'\x00','\x00'},{'\xb6','\xd0'},{'\xdc','\xc7'},{'\x98','\xd7'},{'\xdc','\xc6'},
    {'\xdc','\xc8'},{'\xdc','\xc9'},{'\xb6','\xd1'},{'\x00','\x00'},{'\xb6','\xcf'},
    {'\xe1','\x41'},{'\xe1','\x42'},{'\xb9','\xbb'},{'\xb9','\xba'},{'\xe3','\x5a'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xbc','\x40'},{'\xbc','\x41'},{'\xbc','\x42'},
    {'\xbc','\x44'},{'\xe4','\xf2'},{'\xe4','\xf3'},{'\xbc','\x43'},{'\x00','\x00'},
    {'\xfb','\x69'},{'\x81','\x6b'},{'\xbe','\xaf'},{'\x81','\x6c'},{'\xbe','\xb0'},
    {'\x81','\x6d'},{'\x00','\x00'},{'\xf1','\xed'},{'\xf5','\xc3'},{'\xf5','\xc2'},
    {'\xf7','\xd1'},{'\xfb','\xcb'},{'\xa4','\x4f'},{'\x81','\x6e'},{'\x8b','\xef'},
    {'\x89','\x74'},{'\xa5','\x5c'},{'\xa5','\x5b'},{'\x83','\xef'},{'\x8e','\xb0'},
    {'\xa6','\x48'},{'\x98','\xd8'},{'\x00','\x00'},{'\xc9','\xc0'},{'\x00','\x00'},
    {'\x83','\xf0'},{'\xa7','\x55'},{'\xa7','\x56'},{'\xa7','\x54'},{'\xa7','\x57'},
    {'\xca','\x6f'},{'\xca','\x70'},{'\x81','\x6f'},{'\x00','\x00'},{'\x89','\xca'},
    {'\x83','\x69'},{'\x84','\xc8'},{'\x93','\xf5'},{'\x81','\x70'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x95','\xa2'},{'\x00','\x00'},{'\xa8','\xf1'},
    {'\xcb','\xd5'},{'\x00','\x00'},{'\xa8','\xf0'},{'\x85','\xb7'},{'\xcd','\xf2'},
    {'\xab','\x6c'},{'\xcd','\xf3'},{'\xab','\x6b'},{'\x00','\x00'},{'\x95','\x44'},
    {'\x00','\x00'},{'\xab','\x69'},{'\x00','\x00'},{'\xab','\x6a'},{'\x00','\x00'},
    {'\x84','\xc9'},{'\x98','\xd9'},{'\xd0','\xed'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x81','\x71'},{'\xfb','\xcc'},{'\xb0','\xc7'},{'\xd4','\x6e'},{'\x00','\x00'},
    {'\xb0','\xca'},{'\xd4','\x6d'},{'\xb1','\xe5'},{'\xb0','\xc9'},{'\xb0','\xc8'},
    {'\x00','\x00'},{'\xb3','\xd4'},{'\x00','\x00'},{'\xb3','\xd3'},{'\xb3','\xd2'},
    {'\xb6','\xd2'},{'\xfb','\xcd'},{'\xfb','\xce'},{'\xb6','\xd5'},{'\xb6','\xd6'},
    {'\xb6','\xd4'},{'\x00','\x00'},{'\xb6','\xd3'},{'\x92','\x68'},{'\x00','\x00'},
    {'\xe1','\x43'},{'\x00','\x00'},{'\xe1','\x44'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe4','\xf5'},{'\xbc','\x45'},{'\xe4','\xf4'},{'\x92','\xa4'},
    {'\xbe','\xb1'},{'\xec','\xbf'},{'\xc0','\x79'},{'\x00','\x00'},{'\xf1','\xee'},
    {'\xc4','\x55'},{'\xc6','\xc6'},{'\xa4','\x63'},{'\xa4','\xc3'},{'\xc9','\x56'},
    {'\x00','\x00'},{'\xa4','\xc4'},{'\xa4','\xc5'},{'\x81','\x72'},{'\x94','\x5e'},
    {'\x94','\x53'},{'\x9c','\xd0'},{'\x00','\x00'},{'\xa5','\x5d'},{'\xa5','\x5e'},
    {'\x81','\x73'},{'\xa6','\x49'},{'\xca','\x71'},{'\xcb','\xd6'},{'\xcb','\xd7'},
    {'\x00','\x00'},{'\xab','\x6d'},{'\xd0','\xee'},{'\xb0','\xcc'},{'\xb0','\xcb'},
    {'\xd8','\x63'},{'\xd8','\x62'},{'\x00','\x00'},{'\x00','\x00'},{'\xa4','\x50'},
    {'\xa4','\xc6'},{'\xa5','\x5f'},{'\x00','\x00'},{'\xb0','\xcd'},{'\xc9','\x43'},
    {'\x00','\x00'},{'\xc9','\x6c'},{'\xa5','\x60'},{'\x00','\x00'},{'\xc9','\xc2'},
    {'\xa6','\x4b'},{'\xa6','\x4a'},{'\xc9','\xc1'},{'\xa7','\x58'},{'\x81','\x74'},
    {'\x00','\x00'},{'\x8d','\xc9'},{'\x98','\xda'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xad','\xea'},{'\x00','\x00'},{'\xfb','\xd4'},{'\xd4','\x6f'},{'\x86','\xad'},
    {'\xb6','\xd7'},{'\xe1','\x45'},{'\xb9','\xbc'},{'\xfb','\xd3'},{'\xfb','\xd5'},
    {'\xe8','\xfa'},{'\x00','\x00'},{'\x00','\x00'},{'\xf3','\xfd'},{'\xc6','\xc7'},
    {'\xa4','\xc7'},{'\x83','\xf1'},{'\x8b','\x4b'},{'\xcb','\xd8'},{'\xcd','\xf4'},
    {'\xb0','\xd0'},{'\xb0','\xce'},{'\xb0','\xcf'},{'\xa4','\x51'},{'\x98','\xdb'},
    {'\xa4','\x64'},{'\xa2','\xcd'},{'\xa4','\xca'},{'\x81','\x75'},{'\xa4','\xc9'},
    {'\xa4','\xc8'},{'\xa5','\x63'},{'\xa5','\x62'},{'\x00','\x00'},{'\xc9','\x6d'},
    {'\xc9','\xc3'},{'\x85','\x4f'},{'\x83','\x56'},{'\x00','\x00'},{'\xa8','\xf5'},
    {'\xa8','\xf2'},{'\xa8','\xf4'},{'\xa8','\xf3'},{'\x84','\xcb'},{'\x88','\x6f'},
    {'\xab','\x6e'},{'\x93','\x6d'},{'\x00','\x00'},{'\xb3','\xd5'},{'\x00','\x00'},
    {'\xa4','\x52'},{'\x98','\xdc'},{'\xa4','\xcb'},{'\x81','\x76'},{'\xa5','\x65'},
    {'\xa5','\x64'},{'\x89','\x41'},{'\xca','\x72'},{'\x84','\xc0'},{'\x00','\x00'},
    {'\xa8','\xf6'},{'\x83','\x60'},{'\x00','\x00'},{'\xc6','\xc8'},{'\x00','\x00'},
    {'\x88','\x55'},{'\xc9','\x57'},{'\x95','\xf2'},{'\xa5','\x67'},{'\xa5','\x66'},
    {'\xa6','\x4c'},{'\xa6','\x4d'},{'\xca','\x73'},{'\xa7','\x59'},{'\x83','\x6a'},
    {'\xa7','\x5a'},{'\x00','\x00'},{'\xa8','\xf7'},{'\xa8','\xf8'},{'\xa8','\xf9'},
    {'\x8d','\xbd'},{'\xab','\x6f'},{'\xcd','\xf5'},{'\x98','\xdd'},{'\x98','\xde'},
    {'\xad','\xeb'},{'\x00','\x00'},{'\x00','\x00'},{'\xc9','\x44'},{'\x00','\x00'},
    {'\xa4','\xcc'},{'\x8d','\x6d'},{'\x88','\xe5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x87','\xad'},{'\xc9','\xc4'},{'\x89','\xcd'},{'\x86','\xae'},{'\x8d','\xbb'},
    {'\xca','\x74'},{'\xca','\x75'},{'\x00','\x00'},{'\x00','\x00'},{'\xcb','\xd9'},
    {'\x81','\x77'},{'\xcb','\xda'},{'\x84','\xda'},{'\xcd','\xf7'},{'\xcd','\xf6'},
    {'\xcd','\xf9'},{'\xcd','\xf8'},{'\xab','\x70'},{'\x00','\x00'},{'\xd4','\x70'},
    {'\xad','\xed'},{'\xd0','\xef'},{'\xad','\xec'},{'\x95','\xe8'},{'\x00','\x00'},
    {'\x95','\xe9'},{'\x8f','\xb6'},{'\xd8','\x64'},{'\xb3','\xd6'},{'\x95','\x7a'},
    {'\xd8','\x65'},{'\x87','\xc5'},{'\x84','\xdb'},{'\xfb','\xd7'},{'\xfb','\xd6'},
    {'\xe1','\x46'},{'\xb9','\xbd'},{'\x87','\xc7'},{'\x00','\x00'},{'\x81','\x78'},
    {'\x00','\x00'},{'\xbc','\x46'},{'\x92','\xba'},{'\xf1','\xef'},{'\x00','\x00'},
    {'\xc6','\xc9'},{'\x00','\x00'},{'\x00','\x00'},{'\xc9','\x58'},{'\x00','\x00'},
    {'\xa5','\x68'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x89','\x4f'},
    {'\x00','\x00'},{'\x95','\x48'},{'\x83','\xf2'},{'\xb0','\xd1'},{'\x00','\x00'},
    {'\x98','\xdf'},{'\x00','\x00'},{'\x00','\x00'},{'\xa4','\x53'},{'\xa4','\x65'},
    {'\xa4','\xce'},{'\xa4','\xcd'},{'\x8b','\x5a'},{'\xa4','\xcf'},{'\x83','\x42'},
    {'\x00','\x00'},{'\x98','\xe0'},{'\x84','\xfa'},{'\x98','\xe1'},{'\x00','\x00'},
    {'\xa8','\xfb'},{'\x00','\x00'},{'\xa8','\xfa'},{'\xa8','\xfc'},{'\x8d','\x40'},
    {'\x95','\xb3'},{'\xfb','\xdb'},{'\xab','\x71'},{'\x00','\x00'},{'\x81','\x79'},
    {'\x00','\x00'},{'\xad','\xee'},{'\x8c','\xd4'},{'\xe8','\xfb'},{'\xc2','\x4f'},
    {'\xa4','\x66'},{'\xa5','\x6a'},{'\xa5','\x79'},{'\xa5','\x74'},{'\x00','\x00'},
    {'\xa5','\x6f'},{'\xa5','\x6e'},{'\xa5','\x75'},{'\xa5','\x73'},{'\xa5','\x6c'},
    {'\xa5','\x7a'},{'\xa5','\x6d'},{'\xa5','\x69'},{'\xa5','\x78'},{'\xa5','\x77'},
    {'\xa5','\x76'},{'\xa5','\x6b'},{'\x00','\x00'},{'\xa5','\x72'},{'\x85','\xfc'},
    {'\x86','\x41'},{'\xa5','\x71'},{'\x86','\xb1'},{'\x94','\x62'},{'\xa5','\x7b'},
    {'\xa5','\x70'},{'\x87','\xb4'},{'\x98','\xe2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa6','\x53'},{'\x00','\x00'},{'\xa6','\x59'},{'\xa6','\x55'},{'\x00','\x00'},
    {'\xa6','\x5b'},{'\xc9','\xc5'},{'\xa6','\x58'},{'\xa6','\x4e'},{'\xa6','\x51'},
    {'\xa6','\x54'},{'\xa6','\x50'},{'\xa6','\x57'},{'\xa6','\x5a'},{'\xa6','\x4f'},
    {'\xa6','\x52'},{'\xa6','\x56'},{'\xa6','\x5c'},{'\x89','\xcc'},{'\xfb','\x43'},
    {'\x90','\xb8'},{'\xfb','\x42'},{'\x85','\xba'},{'\xca','\x7e'},{'\xca','\x7b'},
    {'\xa0','\x55'},{'\xa7','\x67'},{'\xca','\x7c'},{'\xa7','\x5b'},{'\xa7','\x5d'},
    {'\xa7','\x75'},{'\xa7','\x70'},{'\x96','\xb2'},{'\x00','\x00'},{'\x81','\x7a'},
    {'\xca','\xa5'},{'\xca','\x7d'},{'\xa7','\x5f'},{'\xa7','\x61'},{'\xca','\xa4'},
    {'\xa7','\x68'},{'\xca','\x78'},{'\xa7','\x74'},{'\xa7','\x76'},{'\xa7','\x5c'},
    {'\xa7','\x6d'},{'\x84','\x51'},{'\xca','\x76'},{'\xa7','\x73'},{'\x96','\xb4'},
    {'\xa7','\x64'},{'\x83','\x45'},{'\xa7','\x6e'},{'\xa7','\x6f'},{'\xca','\x77'},
    {'\xa7','\x6c'},{'\xa7','\x6a'},{'\x00','\x00'},{'\xa7','\x6b'},{'\xa7','\x71'},
    {'\xca','\xa1'},{'\xa7','\x5e'},{'\x00','\x00'},{'\xa7','\x72'},{'\xca','\xa3'},
    {'\xa7','\x66'},{'\xa7','\x63'},{'\x00','\x00'},{'\xca','\x7a'},{'\xa7','\x62'},
    {'\xca','\xa6'},{'\xa7','\x65'},{'\x92','\xbb'},{'\xa7','\x69'},{'\x96','\xa4'},
    {'\x00','\x00'},{'\xa0','\x5a'},{'\xa7','\x60'},{'\xca','\xa2'},{'\x81','\x7b'},
    {'\x81','\x7c'},{'\x8e','\xb2'},{'\x8c','\xca'},{'\xca','\x79'},{'\x86','\xb0'},
    {'\x8f','\xb7'},{'\x8d','\xc2'},{'\x83','\xb0'},{'\x8d','\xbc'},{'\x00','\x00'},
    {'\x85','\xbc'},{'\x85','\xbb'},{'\x00','\x00'},{'\x00','\x00'},{'\x82','\xaf'},
    {'\xcb','\xeb'},{'\xcb','\xea'},{'\xa9','\x4f'},{'\xcb','\xed'},{'\xcb','\xef'},
    {'\xcb','\xe4'},{'\xcb','\xe7'},{'\xcb','\xee'},{'\xa9','\x50'},{'\xfb','\xd9'},
    {'\x94','\xfc'},{'\xcb','\xe1'},{'\xcb','\xe5'},{'\x98','\xe3'},{'\x00','\x00'},
    {'\xcb','\xe9'},{'\xce','\x49'},{'\xa9','\x4b'},{'\xce','\x4d'},{'\xa8','\xfd'},
    {'\xcb','\xe6'},{'\xa8','\xfe'},{'\xa9','\x4c'},{'\xa9','\x45'},{'\xa9','\x41'},
    {'\x00','\x00'},{'\xcb','\xe2'},{'\xa9','\x44'},{'\xa9','\x49'},{'\xa9','\x52'},
    {'\xcb','\xe3'},{'\xcb','\xdc'},{'\xa9','\x43'},{'\xcb','\xdd'},{'\xcb','\xdf'},
    {'\x00','\x00'},{'\xa9','\x46'},{'\x98','\xe4'},{'\xa9','\x48'},{'\xcb','\xdb'},
    {'\xcb','\xe0'},{'\x00','\x00'},{'\x81','\x7d'},{'\xa9','\x51'},{'\xa9','\x4d'},
    {'\xcb','\xe8'},{'\xa9','\x53'},{'\x95','\xa3'},{'\xa9','\x4a'},{'\xcb','\xde'},
    {'\xa9','\x47'},{'\x98','\xe5'},{'\x96','\xb6'},{'\xa9','\x42'},{'\xa9','\x40'},
    {'\xa0','\x57'},{'\xcb','\xec'},{'\x8b','\xf0'},{'\xa9','\x4e'},{'\x89','\xcb'},
    {'\xfb','\xda'},{'\x81','\x7e'},{'\x98','\xe6'},{'\x00','\x00'},{'\xce','\x48'},
    {'\xcd','\xfb'},{'\xce','\x4b'},{'\x81','\xa1'},{'\x95','\x79'},{'\xcd','\xfd'},
    {'\xab','\x78'},{'\xab','\xa8'},{'\xab','\x74'},{'\xab','\xa7'},{'\xab','\x7d'},
    {'\xab','\xa4'},{'\xab','\x72'},{'\xcd','\xfc'},{'\xce','\x43'},{'\xab','\xa3'},
    {'\xce','\x4f'},{'\xab','\xa5'},{'\x94','\x46'},{'\xab','\x79'},{'\x81','\xa2'},
    {'\x00','\x00'},{'\xce','\x45'},{'\xce','\x42'},{'\xab','\x77'},{'\x98','\xe7'},
    {'\xcd','\xfa'},{'\xab','\xa6'},{'\xce','\x4a'},{'\xab','\x7c'},{'\xce','\x4c'},
    {'\xab','\xa9'},{'\xab','\x73'},{'\xab','\x7e'},{'\xab','\x7b'},{'\xce','\x40'},
    {'\xab','\xa1'},{'\xce','\x46'},{'\xce','\x47'},{'\xab','\x7a'},{'\xab','\xa2'},
    {'\xab','\x76'},{'\x00','\x00'},{'\xfb','\x4a'},{'\x96','\xcf'},{'\x8c','\xb7'},
    {'\xab','\x75'},{'\xcd','\xfe'},{'\x81','\xa3'},{'\x83','\xf3'},{'\x8e','\xe2'},
    {'\x8e','\xb1'},{'\x86','\xb4'},{'\x8e','\xe3'},{'\xce','\x44'},{'\x87','\xb0'},
    {'\x94','\x63'},{'\x8e','\xe4'},{'\x96','\xb3'},{'\x00','\x00'},{'\x8f','\x4f'},
    {'\x88','\xce'},{'\xce','\x4e'},{'\x84','\xcc'},{'\xd1','\x44'},{'\xad','\xfb'},
    {'\xd0','\xf1'},{'\x98','\xe8'},{'\xd0','\xf6'},{'\xad','\xf4'},{'\xae','\x40'},
    {'\xd0','\xf4'},{'\xad','\xef'},{'\xad','\xf9'},{'\xad','\xfe'},{'\xd0','\xfb'},
    {'\x00','\x00'},{'\xad','\xfa'},{'\xad','\xfd'},{'\x98','\xe9'},{'\x00','\x00'},
    {'\xd0','\xfe'},{'\xad','\xf5'},{'\xd0','\xf5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd1','\x42'},{'\xd1','\x43'},{'\x00','\x00'},{'\xad','\xf7'},
    {'\xd1','\x41'},{'\xad','\xf3'},{'\xae','\x43'},{'\x00','\x00'},{'\xd0','\xf8'},
    {'\x00','\x00'},{'\xad','\xf1'},{'\xfb','\x5a'},{'\xd1','\x46'},{'\xd0','\xf9'},
    {'\xd0','\xfd'},{'\xad','\xf6'},{'\xae','\x42'},{'\xd0','\xfa'},{'\xad','\xfc'},
    {'\xd1','\x40'},{'\xd1','\x47'},{'\xd4','\xa1'},{'\x98','\xea'},{'\xd1','\x45'},
    {'\xae','\x44'},{'\xad','\xf0'},{'\xd0','\xfc'},{'\xd0','\xf3'},{'\xfb','\x52'},
    {'\xad','\xf8'},{'\x00','\x00'},{'\x82','\x40'},{'\xd0','\xf2'},{'\x98','\xeb'},
    {'\x00','\x00'},{'\xd0','\xf7'},{'\x8e','\x66'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfb','\x55'},{'\x00','\x00'},{'\x87','\xae'},{'\x00','\x00'},{'\x8e','\x41'},
    {'\x81','\xa4'},{'\x84','\xcd'},{'\x98','\xec'},{'\xd0','\xf0'},{'\xae','\x41'},
    {'\x98','\xed'},{'\x00','\x00'},{'\xd4','\x77'},{'\x98','\xee'},{'\xb0','\xe4'},
    {'\xd4','\xa7'},{'\xb0','\xe2'},{'\xb0','\xdf'},{'\xd4','\x7c'},{'\xb0','\xdb'},
    {'\xd4','\xa2'},{'\xb0','\xe6'},{'\xd4','\x76'},{'\xd4','\x7b'},{'\xd4','\x7a'},
    {'\xad','\xf2'},{'\xb0','\xe1'},{'\xd4','\xa5'},{'\x00','\x00'},{'\xd4','\xa8'},
    {'\xd4','\x73'},{'\x00','\x00'},{'\xb3','\xe8'},{'\x81','\xa5'},{'\xd4','\xa9'},
    {'\xb0','\xe7'},{'\x00','\x00'},{'\xb0','\xd9'},{'\xb0','\xd6'},{'\xd4','\x7e'},
    {'\xb0','\xd3'},{'\x98','\xef'},{'\xd4','\xa6'},{'\x96','\xb1'},{'\xb0','\xda'},
    {'\xd4','\xaa'},{'\x81','\xa6'},{'\xd4','\x74'},{'\xd4','\xa4'},{'\xb0','\xdd'},
    {'\xd4','\x75'},{'\xd4','\x78'},{'\xd4','\x7d'},{'\x81','\xa7'},{'\x00','\x00'},
    {'\xb0','\xde'},{'\xb0','\xdc'},{'\xb0','\xe8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb0','\xe3'},{'\x81','\xa8'},{'\xb0','\xd7'},
    {'\xb1','\xd2'},{'\x00','\x00'},{'\xb0','\xd8'},{'\xd4','\x79'},{'\xb0','\xe5'},
    {'\xb0','\xe0'},{'\xd4','\xa3'},{'\xb0','\xd5'},{'\x86','\xb3'},{'\x00','\x00'},
    {'\xfb','\x5b'},{'\xb0','\xd4'},{'\xa0','\x46'},{'\x81','\xa9'},{'\x8c','\x6e'},
    {'\x8c','\xc7'},{'\x00','\x00'},{'\x00','\x00'},{'\xa0','\x49'},{'\xa0','\x45'},
    {'\xfb','\xdd'},{'\x00','\x00'},{'\xd4','\x71'},{'\xd4','\x72'},{'\xd8','\x6a'},
    {'\x87','\xb3'},{'\x98','\xf0'},{'\x00','\x00'},{'\xb3','\xd7'},{'\xb3','\xda'},
    {'\xd8','\x75'},{'\xb3','\xee'},{'\xd8','\x78'},{'\xb3','\xd8'},{'\xd8','\x71'},
    {'\xb3','\xde'},{'\xb3','\xe4'},{'\xb5','\xbd'},{'\x00','\x00'},{'\x95','\xed'},
    {'\xb3','\xe2'},{'\xd8','\x6e'},{'\xb3','\xef'},{'\xb3','\xdb'},{'\xb3','\xe3'},
    {'\xd8','\x76'},{'\xdc','\xd7'},{'\xd8','\x7b'},{'\xd8','\x6f'},{'\x98','\xf1'},
    {'\xd8','\x66'},{'\xd8','\x73'},{'\xd8','\x6d'},{'\xb3','\xe1'},{'\xd8','\x79'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb3','\xdd'},{'\xb3','\xf1'},{'\xb3','\xea'},
    {'\x00','\x00'},{'\xb3','\xdf'},{'\xb3','\xdc'},{'\x81','\xaa'},{'\xb3','\xe7'},
    {'\x00','\x00'},{'\xd8','\x7a'},{'\xd8','\x6c'},{'\xd8','\x72'},{'\xd8','\x74'},
    {'\xd8','\x68'},{'\xd8','\x77'},{'\xb3','\xd9'},{'\xd8','\x67'},{'\x81','\xab'},
    {'\xb3','\xe0'},{'\xb3','\xf0'},{'\xb3','\xec'},{'\xd8','\x69'},{'\xb3','\xe6'},
    {'\x00','\x00'},{'\x94','\x42'},{'\xb3','\xed'},{'\xb3','\xe9'},{'\xb3','\xe5'},
    {'\x98','\xf2'},{'\xd8','\x70'},{'\x92','\x49'},{'\x87','\xb2'},{'\x00','\x00'},
    {'\x96','\xb5'},{'\xa0','\x4a'},{'\xb3','\xeb'},{'\xfb','\x4c'},{'\x86','\xb2'},
    {'\x8f','\xd9'},{'\xdc','\xd5'},{'\xdc','\xd1'},{'\x98','\xf3'},{'\xdc','\xe0'},
    {'\xdc','\xca'},{'\xdc','\xd3'},{'\xb6','\xe5'},{'\xb6','\xe6'},{'\xb6','\xde'},
    {'\xdc','\xdc'},{'\xb6','\xe8'},{'\xdc','\xcf'},{'\xdc','\xce'},{'\xdc','\xcc'},
    {'\xdc','\xde'},{'\xb6','\xdc'},{'\xdc','\xd8'},{'\xdc','\xcd'},{'\xb6','\xdf'},
    {'\xdc','\xd6'},{'\xb6','\xda'},{'\xdc','\xd2'},{'\xdc','\xd9'},{'\xdc','\xdb'},
    {'\x98','\xf4'},{'\x98','\xf5'},{'\xdc','\xdf'},{'\xb6','\xe3'},{'\xdc','\xcb'},
    {'\xb6','\xdd'},{'\xdc','\xd0'},{'\xfb','\x56'},{'\xb6','\xd8'},{'\x00','\x00'},
    {'\xb6','\xe4'},{'\xdc','\xda'},{'\xb6','\xe0'},{'\xb6','\xe1'},{'\xb6','\xe7'},
    {'\xb6','\xdb'},{'\xa2','\x5f'},{'\xb6','\xd9'},{'\xdc','\xd4'},{'\x96','\xc9'},
    {'\x8c','\x6d'},{'\x81','\xac'},{'\x00','\x00'},{'\x00','\x00'},{'\xb6','\xe2'},
    {'\xa0','\x4d'},{'\xa0','\x4b'},{'\xdc','\xdd'},{'\x88','\xcf'},{'\x00','\x00'},
    {'\x81','\xad'},{'\xb9','\xcd'},{'\xb9','\xc8'},{'\x00','\x00'},{'\xe1','\x55'},
    {'\xe1','\x51'},{'\x98','\xf6'},{'\xe1','\x4b'},{'\xb9','\xc2'},{'\xb9','\xbe'},
    {'\xe1','\x54'},{'\xb9','\xbf'},{'\xe1','\x4e'},{'\xe1','\x50'},{'\x00','\x00'},
    {'\xe1','\x53'},{'\xa0','\x4e'},{'\xb9','\xc4'},{'\x00','\x00'},{'\xb9','\xcb'},
    {'\xb9','\xc5'},{'\x00','\x00'},{'\x00','\x00'},{'\xe1','\x49'},{'\xb9','\xc6'},
    {'\xb9','\xc7'},{'\xe1','\x4c'},{'\xb9','\xcc'},{'\xfb','\xe1'},{'\xe1','\x4a'},
    {'\xe1','\x4f'},{'\xb9','\xc3'},{'\xe1','\x48'},{'\xb9','\xc9'},{'\xb9','\xc1'},
    {'\x82','\xb3'},{'\x00','\x00'},{'\x00','\x00'},{'\xb9','\xc0'},{'\xe1','\x4d'},
    {'\xe1','\x52'},{'\xa0','\x52'},{'\xb9','\xca'},{'\xfc','\xd9'},{'\x98','\xf8'},
    {'\xa0','\x4f'},{'\x81','\xae'},{'\x8b','\xf1'},{'\xfb','\x65'},{'\x00','\x00'},
    {'\xe1','\x47'},{'\x00','\x00'},{'\xbc','\x4d'},{'\xe5','\x47'},{'\x00','\x00'},
    {'\xe5','\x44'},{'\xa0','\x50'},{'\xbc','\x47'},{'\xbc','\x53'},{'\xbc','\x54'},
    {'\x8d','\x51'},{'\xbc','\x4a'},{'\xe5','\x42'},{'\xbc','\x4c'},{'\xe4','\xf9'},
    {'\xbc','\x52'},{'\xfe','\x5d'},{'\xe5','\x46'},{'\xbc','\x49'},{'\xe5','\x48'},
    {'\xbc','\x48'},{'\x00','\x00'},{'\xe5','\x43'},{'\xe5','\x45'},{'\xbc','\x4b'},
    {'\xe5','\x41'},{'\xe4','\xfa'},{'\xe4','\xf7'},{'\xa0','\x51'},{'\x00','\x00'},
    {'\xd8','\x6b'},{'\xe4','\xfd'},{'\x00','\x00'},{'\xe4','\xf6'},{'\xe4','\xfc'},
    {'\xe4','\xfb'},{'\x00','\x00'},{'\xe4','\xf8'},{'\xfb','\xe2'},{'\xbc','\x4f'},
    {'\xfb','\x6a'},{'\x81','\xaf'},{'\x00','\x00'},{'\x98','\xfa'},{'\xbc','\x4e'},
    {'\xfb','\xe4'},{'\x00','\x00'},{'\x00','\x00'},{'\xbc','\x50'},{'\xe4','\xfe'},
    {'\xbe','\xb2'},{'\xe5','\x40'},{'\x82','\x4f'},{'\x8a','\xbe'},{'\x99','\x40'},
    {'\xe9','\x45'},{'\x00','\x00'},{'\xe8','\xfd'},{'\x99','\x55'},{'\xbe','\xbe'},
    {'\xe9','\x42'},{'\xbe','\xb6'},{'\xbe','\xba'},{'\xe9','\x41'},{'\x00','\x00'},
    {'\xbe','\xb9'},{'\xbe','\xb5'},{'\xbe','\xb8'},{'\xbe','\xb3'},{'\xbe','\xbd'},
    {'\xe9','\x43'},{'\xe8','\xfe'},{'\xbe','\xbc'},{'\xe8','\xfc'},{'\xbe','\xbb'},
    {'\xe9','\x44'},{'\xe9','\x40'},{'\xbc','\x51'},{'\x00','\x00'},{'\xbe','\xbf'},
    {'\xe9','\x46'},{'\xbe','\xb7'},{'\xbe','\xb4'},{'\x94','\x57'},{'\x96','\xca'},
    {'\x81','\xb0'},{'\x00','\x00'},{'\xec','\xc6'},{'\xec','\xc8'},{'\xc0','\x7b'},
    {'\xec','\xc9'},{'\xec','\xc7'},{'\xec','\xc5'},{'\xec','\xc4'},{'\xc0','\x7d'},
    {'\xec','\xc3'},{'\xc0','\x7e'},{'\x00','\x00'},{'\x99','\x56'},{'\x81','\xb1'},
    {'\x99','\x57'},{'\xec','\xc1'},{'\xec','\xc2'},{'\xc0','\x7a'},{'\xc0','\xa1'},
    {'\xc0','\x7c'},{'\x00','\x00'},{'\xa0','\x53'},{'\xec','\xc0'},{'\x81','\xb2'},
    {'\xc2','\x50'},{'\x00','\x00'},{'\xef','\xbc'},{'\xef','\xba'},{'\xef','\xbf'},
    {'\xef','\xbd'},{'\x00','\x00'},{'\xef','\xbb'},{'\xef','\xbe'},{'\x99','\x58'},
    {'\xa0','\x5c'},{'\x81','\xb3'},{'\x99','\x59'},{'\x82','\x74'},{'\x8c','\x6f'},
    {'\xa0','\x5b'},{'\xc3','\x60'},{'\xf1','\xf2'},{'\xf1','\xf3'},{'\xc4','\x56'},
    {'\x00','\x00'},{'\xf1','\xf4'},{'\xf1','\xf0'},{'\xf1','\xf5'},{'\xf1','\xf1'},
    {'\xc2','\x51'},{'\x81','\xb4'},{'\x00','\x00'},{'\x99','\x5a'},{'\xf3','\xfe'},
    {'\xf4','\x41'},{'\xc4','\x59'},{'\xf4','\x40'},{'\xc4','\x58'},{'\xc4','\x57'},
    {'\x00','\x00'},{'\x99','\x5b'},{'\x00','\x00'},{'\x00','\x00'},{'\xc4','\x5a'},
    {'\xf5','\xc5'},{'\xf5','\xc6'},{'\x99','\x5c'},{'\xc4','\xda'},{'\xc4','\xd9'},
    {'\xc4','\xdb'},{'\xf5','\xc4'},{'\x00','\x00'},{'\xf6','\xd8'},{'\xf6','\xd7'},
    {'\x00','\x00'},{'\xc5','\x6d'},{'\xc5','\x6f'},{'\xc5','\x6e'},{'\xf6','\xd9'},
    {'\xc5','\xc8'},{'\xf8','\xa6'},{'\x94','\x64'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc5','\xf1'},{'\x00','\x00'},{'\xf8','\xa5'},{'\xf8','\xee'},{'\x00','\x00'},
    {'\x99','\x5d'},{'\xc9','\x49'},{'\x81','\xb5'},{'\x00','\x00'},{'\xa5','\x7d'},
    {'\xa5','\x7c'},{'\x00','\x00'},{'\xa6','\x5f'},{'\xa6','\x5e'},{'\xc9','\xc7'},
    {'\xa6','\x5d'},{'\xc9','\xc6'},{'\x86','\xb5'},{'\x93','\x6f'},{'\xa7','\x79'},
    {'\xca','\xa9'},{'\x00','\x00'},{'\xca','\xa8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa7','\x77'},{'\xa7','\x7a'},{'\x00','\x00'},{'\x85','\xbd'},{'\xca','\xa7'},
    {'\x99','\x5e'},{'\xa7','\x78'},{'\x83','\x46'},{'\x92','\x43'},{'\x92','\xf6'},
    {'\x84','\xcf'},{'\x8d','\xca'},{'\x00','\x00'},{'\xcb','\xf0'},{'\x00','\x00'},
    {'\xcb','\xf1'},{'\xa9','\x54'},{'\x9d','\x56'},{'\x00','\x00'},{'\x83','\xf6'},
    {'\x86','\xb6'},{'\xab','\xaa'},{'\x81','\xb6'},{'\xd1','\x48'},{'\xd1','\x49'},
    {'\xae','\x45'},{'\xae','\x46'},{'\x00','\x00'},{'\x85','\xbe'},{'\xd4','\xac'},
    {'\xb0','\xe9'},{'\xb0','\xeb'},{'\xd4','\xab'},{'\xb0','\xea'},{'\xd8','\x7c'},
    {'\xb3','\xf2'},{'\x00','\x00'},{'\x92','\xb5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb6','\xe9'},{'\xb6','\xea'},{'\xdc','\xe1'},{'\x99','\x5f'},{'\xb9','\xcf'},
    {'\x00','\x00'},{'\xb9','\xce'},{'\x00','\x00'},{'\xe5','\x49'},{'\xe9','\x48'},
    {'\xe9','\x47'},{'\x99','\x60'},{'\xf9','\x6b'},{'\xa4','\x67'},{'\xc9','\x59'},
    {'\x00','\x00'},{'\xc9','\x6e'},{'\xc9','\x6f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x94','\x65'},{'\x92','\x42'},{'\xa6','\x62'},{'\xa6','\x66'},{'\xc9','\xc9'},
    {'\x00','\x00'},{'\xa6','\x64'},{'\xa6','\x63'},{'\xc9','\xc8'},{'\xa6','\x65'},
    {'\xa6','\x61'},{'\x00','\x00'},{'\x99','\x61'},{'\xa6','\x60'},{'\xc9','\xca'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x94','\x66'},{'\x94','\x67'},{'\x8a','\xbf'},
    {'\x84','\xd1'},{'\xa7','\xa6'},{'\x00','\x00'},{'\x99','\x62'},{'\xa7','\xa3'},
    {'\x99','\x63'},{'\xa7','\x7d'},{'\xca','\xaa'},{'\x95','\xb5'},{'\x99','\x64'},
    {'\x00','\x00'},{'\xca','\xab'},{'\xfb','\xe7'},{'\xa7','\xa1'},{'\x00','\x00'},
    {'\xca','\xad'},{'\xa7','\x7b'},{'\xca','\xae'},{'\xca','\xac'},{'\xa7','\x7e'},
    {'\xa7','\xa2'},{'\xa7','\xa5'},{'\xa7','\xa4'},{'\xa7','\x7c'},{'\xca','\xaf'},
    {'\x00','\x00'},{'\xfe','\x6f'},{'\x00','\x00'},{'\x00','\x00'},{'\x85','\xc0'},
    {'\x00','\x00'},{'\x81','\xb7'},{'\x83','\xf7'},{'\x88','\xd1'},{'\x8b','\x6f'},
    {'\x8d','\x52'},{'\x85','\xc1'},{'\x87','\xb6'},{'\x87','\xb7'},{'\xa9','\x59'},
    {'\xcb','\xfe'},{'\x00','\x00'},{'\xa9','\x5b'},{'\x81','\xb8'},{'\xa9','\x5a'},
    {'\xfb','\xe9'},{'\xcc','\x40'},{'\xa9','\x58'},{'\xa9','\x57'},{'\xcb','\xf5'},
    {'\x00','\x00'},{'\xcb','\xf4'},{'\x00','\x00'},{'\xcb','\xf2'},{'\xcb','\xf7'},
    {'\xcb','\xf6'},{'\xcb','\xf3'},{'\xcb','\xfc'},{'\xcb','\xfd'},{'\xcb','\xfa'},
    {'\xcb','\xf8'},{'\xa9','\x56'},{'\x00','\x00'},{'\x00','\x00'},{'\xfb','\xe8'},
    {'\xcb','\xfb'},{'\xa9','\x5c'},{'\xcc','\x41'},{'\x99','\x66'},{'\x81','\xb9'},
    {'\xcb','\xf9'},{'\x00','\x00'},{'\xab','\xab'},{'\xa9','\x55'},{'\x8b','\x6e'},
    {'\x81','\xba'},{'\x8f','\xb8'},{'\x00','\x00'},{'\x94','\x68'},{'\x81','\xbb'},
    {'\x99','\x67'},{'\xab','\xac'},{'\xce','\x54'},{'\x99','\x68'},{'\x00','\x00'},
    {'\xce','\x5a'},{'\x99','\x69'},{'\x00','\x00'},{'\x8a','\xc0'},{'\xab','\xb2'},
    {'\xce','\x58'},{'\xce','\x5e'},{'\x00','\x00'},{'\xce','\x55'},{'\xce','\x59'},
    {'\xce','\x5b'},{'\xce','\x5d'},{'\xce','\x57'},{'\x99','\x6a'},{'\xce','\x56'},
    {'\xce','\x51'},{'\xce','\x52'},{'\xab','\xad'},{'\x81','\xbc'},{'\xab','\xaf'},
    {'\xab','\xae'},{'\xce','\x53'},{'\xce','\x5c'},{'\x88','\xd0'},{'\x8d','\xb6'},
    {'\x00','\x00'},{'\x83','\xf8'},{'\x94','\x6a'},{'\x86','\xb8'},{'\x81','\xbd'},
    {'\x8d','\xcb'},{'\xab','\xb1'},{'\x00','\x00'},{'\x94','\x6b'},{'\x00','\x00'},
    {'\x8e','\x42'},{'\x94','\x69'},{'\x81','\xbe'},{'\xce','\x50'},{'\xd1','\x53'},
    {'\x00','\x00'},{'\xd1','\x52'},{'\xd1','\x57'},{'\xd1','\x4e'},{'\x99','\x6b'},
    {'\xd1','\x51'},{'\xd1','\x50'},{'\x99','\x6c'},{'\xd1','\x54'},{'\x81','\xbf'},
    {'\xd1','\x58'},{'\xae','\x47'},{'\xae','\x4a'},{'\x99','\x6d'},{'\x00','\x00'},
    {'\xd1','\x4f'},{'\xd1','\x55'},{'\x81','\xc0'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xae','\x49'},{'\xd1','\x4a'},{'\x00','\x00'},{'\xab','\xb0'},{'\xd4','\xba'},
    {'\xd1','\x56'},{'\x00','\x00'},{'\xd1','\x4d'},{'\x81','\xc1'},{'\xae','\x48'},
    {'\xd1','\x4c'},{'\x94','\x6c'},{'\xfe','\x49'},{'\x85','\xc2'},{'\x89','\xce'},
    {'\x84','\xd3'},{'\x00','\x00'},{'\xd4','\xb1'},{'\xfb','\xec'},{'\x99','\x6e'},
    {'\xb0','\xec'},{'\xb0','\xf0'},{'\xd4','\xc1'},{'\xd4','\xaf'},{'\xd4','\xbd'},
    {'\xb0','\xf1'},{'\xd4','\xbf'},{'\xfb','\xeb'},{'\xd4','\xc5'},{'\x00','\x00'},
    {'\xd4','\xc9'},{'\x00','\x00'},{'\x00','\x00'},{'\xd4','\xc0'},{'\xd4','\xb4'},
    {'\xd4','\xbc'},{'\x81','\xc2'},{'\xd4','\xca'},{'\xd4','\xc8'},{'\xd4','\xbe'},
    {'\xd4','\xb9'},{'\xd4','\xb2'},{'\xd8','\xa6'},{'\xd4','\xb0'},{'\xb0','\xf5'},
    {'\xd4','\xb7'},{'\xb0','\xf6'},{'\xb0','\xf2'},{'\xd4','\xad'},{'\xd4','\xc3'},
    {'\xd4','\xb5'},{'\x99','\x6f'},{'\x00','\x00'},{'\xd4','\xb3'},{'\xd4','\xc6'},
    {'\xb0','\xf3'},{'\x95','\x4a'},{'\xd4','\xcc'},{'\xb0','\xed'},{'\xb0','\xef'},
    {'\xd4','\xbb'},{'\xd4','\xb6'},{'\xae','\x4b'},{'\xb0','\xee'},{'\xd4','\xb8'},
    {'\xd4','\xc7'},{'\xd4','\xcb'},{'\xd4','\xc2'},{'\x00','\x00'},{'\xd4','\xc4'},
    {'\x86','\xb9'},{'\x99','\x70'},{'\x00','\x00'},{'\xd4','\xae'},{'\x87','\xb8'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xd8','\xa1'},{'\x00','\x00'},
    {'\xd8','\xaa'},{'\xd8','\xa9'},{'\xb3','\xfa'},{'\xd8','\xa2'},{'\x00','\x00'},
    {'\xb3','\xfb'},{'\xb3','\xf9'},{'\x99','\x71'},{'\xd8','\xa4'},{'\xb3','\xf6'},
    {'\xd8','\xa8'},{'\xfb','\xef'},{'\xd8','\xa3'},{'\xd8','\xa5'},{'\xd8','\x7d'},
    {'\xb3','\xf4'},{'\x00','\x00'},{'\xd8','\xb2'},{'\xd8','\xb1'},{'\xd8','\xae'},
    {'\xb3','\xf3'},{'\xb3','\xf7'},{'\xb3','\xf8'},{'\xd1','\x4b'},{'\xd8','\xab'},
    {'\xb3','\xf5'},{'\xb0','\xf4'},{'\xd8','\xad'},{'\xd8','\x7e'},{'\xd8','\xb0'},
    {'\xd8','\xaf'},{'\xfb','\xea'},{'\xd8','\xb3'},{'\x00','\x00'},{'\xdc','\xef'},
    {'\x00','\x00'},{'\xd8','\xac'},{'\x94','\x59'},{'\x93','\xe9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x81','\xc3'},{'\x00','\x00'},{'\x00','\x00'},{'\x99','\x72'},
    {'\xd8','\xa7'},{'\xdc','\xe7'},{'\xb6','\xf4'},{'\xb6','\xf7'},{'\xb6','\xf2'},
    {'\xdc','\xe6'},{'\xdc','\xea'},{'\xdc','\xe5'},{'\x00','\x00'},{'\xb6','\xec'},
    {'\xb6','\xf6'},{'\xdc','\xe2'},{'\xb6','\xf0'},{'\xdc','\xe9'},{'\x00','\x00'},
    {'\xb6','\xee'},{'\xb6','\xed'},{'\xdc','\xec'},{'\xb6','\xef'},{'\xdc','\xee'},
    {'\x99','\x73'},{'\xdc','\xeb'},{'\xb6','\xeb'},{'\x99','\x74'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xb6','\xf5'},{'\xdc','\xf0'},{'\xdc','\xe4'},{'\xdc','\xed'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xdc','\xe3'},{'\x95','\xcd'},{'\x00','\x00'},
    {'\xb6','\xf1'},{'\x81','\xc4'},{'\xb6','\xf3'},{'\x00','\x00'},{'\xdc','\xe8'},
    {'\x94','\x6d'},{'\xdc','\xf1'},{'\x95','\x62'},{'\x99','\x75'},{'\xe1','\x5d'},
    {'\xb9','\xd0'},{'\xe1','\x63'},{'\x00','\x00'},{'\x00','\x00'},{'\xb9','\xd5'},
    {'\xe1','\x5f'},{'\xe1','\x66'},{'\xe1','\x57'},{'\xb9','\xd7'},{'\xb9','\xd1'},
    {'\xe1','\x5c'},{'\xbc','\x55'},{'\xe1','\x5b'},{'\xe1','\x64'},{'\xb9','\xd2'},
    {'\x00','\x00'},{'\xb9','\xd6'},{'\xe1','\x5a'},{'\xe1','\x60'},{'\xe1','\x65'},
    {'\xe1','\x56'},{'\xb9','\xd4'},{'\xe1','\x5e'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe1','\x62'},{'\xe1','\x68'},{'\xe1','\x58'},{'\xe1','\x61'},{'\x81','\xc5'},
    {'\xb9','\xd3'},{'\xe1','\x67'},{'\x00','\x00'},{'\x00','\x00'},{'\x93','\x5e'},
    {'\xe1','\x59'},{'\x89','\xf5'},{'\x81','\xc6'},{'\x00','\x00'},{'\xbc','\x59'},
    {'\xe5','\x4b'},{'\xbc','\x57'},{'\xbc','\x56'},{'\xe5','\x4d'},{'\xe5','\x52'},
    {'\x00','\x00'},{'\xe5','\x4e'},{'\x00','\x00'},{'\xe5','\x51'},{'\xbc','\x5c'},
    {'\x99','\x76'},{'\xbe','\xa5'},{'\xbc','\x5b'},{'\x99','\x77'},{'\xe5','\x4a'},
    {'\xe5','\x50'},{'\x00','\x00'},{'\xbc','\x5a'},{'\xe5','\x4f'},{'\x99','\x78'},
    {'\xe5','\x4c'},{'\x81','\xc7'},{'\xbc','\x58'},{'\x00','\x00'},{'\x99','\x79'},
    {'\x99','\x7a'},{'\x00','\x00'},{'\x81','\xc8'},{'\x94','\x6e'},{'\xe9','\x4d'},
    {'\xf9','\xd9'},{'\xe9','\x4f'},{'\xe9','\x4a'},{'\xbe','\xc1'},{'\xe9','\x4c'},
    {'\x00','\x00'},{'\xbe','\xc0'},{'\xe9','\x4e'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xbe','\xc3'},{'\xe9','\x50'},{'\xbe','\xc2'},{'\xe9','\x49'},{'\xe9','\x4b'},
    {'\x92','\x5c'},{'\x99','\x7b'},{'\x92','\xee'},{'\x00','\x00'},{'\xc0','\xa5'},
    {'\xec','\xcc'},{'\x99','\x7c'},{'\xc0','\xa4'},{'\xec','\xcd'},{'\xc0','\xa3'},
    {'\xec','\xcb'},{'\xc0','\xa2'},{'\xec','\xca'},{'\x94','\x6f'},{'\xc2','\x53'},
    {'\xc2','\x52'},{'\xf1','\xf6'},{'\xf1','\xf8'},{'\xfb','\xf0'},{'\xf1','\xf7'},
    {'\xc3','\x61'},{'\xc3','\x62'},{'\x99','\x7d'},{'\x00','\x00'},{'\xc3','\x63'},
    {'\xf4','\x42'},{'\xc4','\x5b'},{'\x81','\xc9'},{'\x00','\x00'},{'\xf7','\xd3'},
    {'\xf7','\xd2'},{'\xc5','\xf2'},{'\x00','\x00'},{'\xa4','\x68'},{'\xa4','\xd0'},
    {'\x00','\x00'},{'\x83','\x47'},{'\xa7','\xa7'},{'\x8a','\x52'},{'\x92','\x45'},
    {'\x93','\xb3'},{'\x84','\xea'},{'\xce','\x5f'},{'\x00','\x00'},{'\x84','\xd4'},
    {'\x82','\x41'},{'\x00','\x00'},{'\xb3','\xfc'},{'\xb3','\xfd'},{'\x81','\xca'},
    {'\xdc','\xf2'},{'\xb9','\xd8'},{'\xe1','\x69'},{'\xe5','\x53'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x81','\xcb'},{'\xc9','\x5a'},{'\x84','\x7a'},{'\x99','\x7e'},
    {'\xca','\xb0'},{'\x84','\xc2'},{'\x00','\x00'},{'\x93','\xc4'},{'\xc6','\xca'},
    {'\x81','\xcc'},{'\xcc','\x42'},{'\xce','\x60'},{'\xd1','\x59'},{'\xae','\x4c'},
    {'\x81','\xcd'},{'\x99','\xa1'},{'\xf1','\xf9'},{'\x00','\x00'},{'\xc4','\xdc'},
    {'\xa4','\x69'},{'\xa5','\x7e'},{'\xc9','\x70'},{'\x81','\xce'},{'\xa6','\x67'},
    {'\xa6','\x68'},{'\x81','\xcf'},{'\xa9','\x5d'},{'\x9d','\x58'},{'\x00','\x00'},
    {'\x83','\xfa'},{'\xb0','\xf7'},{'\x00','\x00'},{'\xb9','\xda'},{'\x00','\x00'},
    {'\xb9','\xdb'},{'\xb9','\xd9'},{'\x00','\x00'},{'\xa4','\x6a'},{'\x00','\x00'},
    {'\xa4','\xd1'},{'\xa4','\xd3'},{'\xa4','\xd2'},{'\xc9','\x5b'},{'\xa4','\xd4'},
    {'\xa5','\xa1'},{'\xc9','\x71'},{'\x00','\x00'},{'\xa5','\xa2'},{'\x82','\xb5'},
    {'\x00','\x00'},{'\x89','\xb3'},{'\x00','\x00'},{'\x00','\x00'},{'\xa6','\x69'},
    {'\xa6','\x6a'},{'\x83','\x48'},{'\x86','\xbc'},{'\x00','\x00'},{'\xc9','\xcb'},
    {'\x00','\x00'},{'\xa7','\xa8'},{'\x00','\x00'},{'\xca','\xb1'},{'\x86','\xbd'},
    {'\x83','\x6b'},{'\x00','\x00'},{'\xa9','\x61'},{'\xcc','\x43'},{'\x00','\x00'},
    {'\xa9','\x5f'},{'\xa9','\x60'},{'\xa9','\x5e'},{'\xd1','\x5a'},{'\x88','\xd2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xab','\xb6'},{'\xab','\xb5'},{'\xab','\xb7'},
    {'\xab','\xb4'},{'\x00','\x00'},{'\xce','\x61'},{'\xa9','\x62'},{'\xab','\xb3'},
    {'\x87','\xf2'},{'\xae','\x4d'},{'\xae','\x4e'},{'\x00','\x00'},{'\xae','\x4f'},
    {'\x82','\xb6'},{'\xd4','\xcd'},{'\x82','\xb7'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb3','\xfe'},{'\xd8','\xb4'},{'\xb0','\xf8'},{'\x82','\xb8'},{'\x00','\x00'},
    {'\x85','\xc4'},{'\x00','\x00'},{'\xb6','\xf8'},{'\x92','\xe6'},{'\xb9','\xdd'},
    {'\xb9','\xdc'},{'\xe1','\x6a'},{'\x82','\xb9'},{'\xbc','\x5d'},{'\xbe','\xc4'},
    {'\x00','\x00'},{'\xef','\xc0'},{'\xf6','\xda'},{'\xf7','\xd4'},{'\xa4','\x6b'},
    {'\xa5','\xa3'},{'\xfe','\x66'},{'\xa5','\xa4'},{'\xc9','\xd1'},{'\xa6','\x6c'},
    {'\xa6','\x6f'},{'\x00','\x00'},{'\xc9','\xcf'},{'\xc9','\xcd'},{'\xa6','\x6e'},
    {'\xc9','\xd0'},{'\xc9','\xd2'},{'\xc9','\xcc'},{'\xa6','\x71'},{'\xa6','\x70'},
    {'\xa6','\x6d'},{'\xa6','\x6b'},{'\xc9','\xce'},{'\x83','\x49'},{'\x83','\xfc'},
    {'\x85','\xc5'},{'\x99','\xa2'},{'\xa7','\xb3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xa7','\xb0'},{'\xca','\xb6'},{'\xca','\xb9'},{'\xca','\xb8'},{'\x00','\x00'},
    {'\xa7','\xaa'},{'\xa7','\xb2'},{'\x99','\xa3'},{'\x00','\x00'},{'\xa7','\xaf'},
    {'\xca','\xb5'},{'\xca','\xb3'},{'\xa7','\xae'},{'\x99','\xa4'},{'\x82','\xba'},
    {'\x00','\x00'},{'\xa7','\xa9'},{'\xa7','\xac'},{'\x99','\xa5'},{'\xca','\xb4'},
    {'\xca','\xbb'},{'\xca','\xb7'},{'\xa7','\xad'},{'\xa7','\xb1'},{'\xa7','\xb4'},
    {'\xca','\xb2'},{'\xca','\xba'},{'\xa7','\xab'},{'\x87','\xbb'},{'\x86','\xbe'},
    {'\x8d','\xdb'},{'\x95','\xa5'},{'\x00','\x00'},{'\xa9','\x67'},{'\xa9','\x6f'},
    {'\x99','\xa6'},{'\xcc','\x4f'},{'\xcc','\x48'},{'\xa9','\x70'},{'\xcc','\x53'},
    {'\xcc','\x44'},{'\xcc','\x4b'},{'\xfb','\xf1'},{'\x99','\xa7'},{'\xa9','\x66'},
    {'\xcc','\x45'},{'\xa9','\x64'},{'\xcc','\x4c'},{'\xcc','\x50'},{'\xa9','\x63'},
    {'\x9b','\x40'},{'\xcc','\x51'},{'\xcc','\x4a'},{'\x00','\x00'},{'\xcc','\x4d'},
    {'\x99','\xa8'},{'\xa9','\x72'},{'\xa9','\x69'},{'\xcc','\x54'},{'\xcc','\x52'},
    {'\x93','\xfc'},{'\xa9','\x6e'},{'\xa9','\x6c'},{'\xcc','\x49'},{'\xa9','\x6b'},
    {'\xcc','\x47'},{'\xcc','\x46'},{'\xa9','\x6a'},{'\xa9','\x68'},{'\xa9','\x71'},
    {'\xa9','\x6d'},{'\xa9','\x65'},{'\x00','\x00'},{'\xcc','\x4e'},{'\x82','\xbb'},
    {'\xab','\xb9'},{'\xfb','\xf2'},{'\xab','\xc0'},{'\xce','\x6f'},{'\xab','\xb8'},
    {'\xce','\x67'},{'\xce','\x63'},{'\x00','\x00'},{'\xce','\x73'},{'\xce','\x62'},
    {'\x00','\x00'},{'\xab','\xbb'},{'\xce','\x6c'},{'\xab','\xbe'},{'\xab','\xc1'},
    {'\x00','\x00'},{'\xab','\xbc'},{'\xce','\x70'},{'\xab','\xbf'},{'\x82','\xbc'},
    {'\xae','\x56'},{'\xce','\x76'},{'\xce','\x64'},{'\x99','\xa9'},{'\x99','\xaa'},
    {'\xce','\x66'},{'\xce','\x6d'},{'\xce','\x71'},{'\xce','\x75'},{'\xce','\x72'},
    {'\xce','\x6b'},{'\xce','\x6e'},{'\x99','\xab'},{'\x95','\xc0'},{'\xce','\x68'},
    {'\xab','\xc3'},{'\xce','\x6a'},{'\xce','\x69'},{'\xce','\x74'},{'\xab','\xba'},
    {'\xce','\x65'},{'\xab','\xc2'},{'\x99','\xac'},{'\xab','\xbd'},{'\x83','\xfb'},
    {'\x8d','\xcc'},{'\x87','\xbd'},{'\x87','\xbc'},{'\x90','\x55'},{'\xae','\x5c'},
    {'\xd1','\x62'},{'\x99','\xad'},{'\xae','\x5b'},{'\x99','\xae'},{'\x00','\x00'},
    {'\xd1','\x60'},{'\x00','\x00'},{'\xae','\x50'},{'\x99','\xaf'},{'\xae','\x55'},
    {'\x00','\x00'},{'\xd1','\x5f'},{'\xd1','\x5c'},{'\xd1','\x61'},{'\xae','\x51'},
    {'\xd1','\x5b'},{'\x82','\xbd'},{'\xae','\x54'},{'\xae','\x52'},{'\x00','\x00'},
    {'\xd1','\x63'},{'\xae','\x53'},{'\xae','\x57'},{'\x99','\xb0'},{'\x00','\x00'},
    {'\xae','\x58'},{'\x99','\xb1'},{'\xae','\x5a'},{'\x00','\x00'},{'\x99','\xb2'},
    {'\x00','\x00'},{'\xae','\x59'},{'\x99','\xb3'},{'\x99','\xb4'},{'\x99','\xb5'},
    {'\xd1','\x5d'},{'\xd1','\x5e'},{'\x92','\xbc'},{'\x00','\x00'},{'\x83','\xb1'},
    {'\x84','\xd5'},{'\xd1','\x64'},{'\x87','\xb9'},{'\xd4','\xd4'},{'\xb0','\xf9'},
    {'\xd8','\xc2'},{'\xd4','\xd3'},{'\xd4','\xe6'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb1','\x40'},{'\x99','\xb6'},{'\xd4','\xe4'},{'\x00','\x00'},{'\xb0','\xfe'},
    {'\xb0','\xfa'},{'\xd4','\xed'},{'\xd4','\xdd'},{'\xd4','\xe0'},{'\x99','\xb7'},
    {'\xb1','\x43'},{'\xd4','\xea'},{'\xd4','\xe2'},{'\xb0','\xfb'},{'\xb1','\x44'},
    {'\x00','\x00'},{'\xd4','\xe7'},{'\xd4','\xe5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xd4','\xd6'},{'\xd4','\xeb'},{'\xd4','\xdf'},{'\xd4','\xda'},{'\x99','\xb8'},
    {'\xd4','\xd0'},{'\xd4','\xec'},{'\xd4','\xdc'},{'\xd4','\xcf'},{'\x99','\xb9'},
    {'\xb1','\x42'},{'\xd4','\xe1'},{'\xd4','\xee'},{'\xd4','\xde'},{'\xd4','\xd2'},
    {'\xd4','\xd7'},{'\xd4','\xce'},{'\x99','\xba'},{'\xb1','\x41'},{'\x95','\x63'},
    {'\xd4','\xdb'},{'\xd4','\xd8'},{'\xb0','\xfc'},{'\xd4','\xd1'},{'\x99','\xbb'},
    {'\xd4','\xe9'},{'\xb0','\xfd'},{'\x99','\xbc'},{'\xd4','\xd9'},{'\xd4','\xd5'},
    {'\x99','\xbd'},{'\x00','\x00'},{'\xd4','\xe8'},{'\x99','\xbe'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x89','\xcf'},{'\x87','\xba'},{'\x8a','\xc1'},{'\xb4','\x40'},
    {'\xd8','\xbb'},{'\x99','\xbf'},{'\xd8','\xb8'},{'\xd8','\xc9'},{'\xd8','\xbd'},
    {'\xd8','\xca'},{'\x99','\xc0'},{'\xb4','\x42'},{'\x00','\x00'},{'\x99','\xc1'},
    {'\x99','\xc2'},{'\xd8','\xc6'},{'\xd8','\xc3'},{'\x00','\x00'},{'\x99','\xc3'},
    {'\x00','\x00'},{'\x99','\xc4'},{'\x00','\x00'},{'\xd8','\xc4'},{'\xd8','\xc7'},
    {'\xd8','\xcb'},{'\x00','\x00'},{'\xd4','\xe3'},{'\xd8','\xcd'},{'\xdd','\x47'},
    {'\x99','\xc5'},{'\xb4','\x43'},{'\xd8','\xce'},{'\xd8','\xb6'},{'\xd8','\xc0'},
    {'\xfe','\x78'},{'\xd8','\xc5'},{'\x00','\x00'},{'\x99','\xc6'},{'\xb4','\x41'},
    {'\xb4','\x44'},{'\xd8','\xcc'},{'\xd8','\xcf'},{'\xd8','\xba'},{'\xd8','\xb7'},
    {'\x99','\xc7'},{'\x99','\xc8'},{'\xd8','\xb9'},{'\x00','\x00'},{'\x9c','\x70'},
    {'\xd8','\xbe'},{'\xd8','\xbc'},{'\xb4','\x45'},{'\x00','\x00'},{'\xd8','\xc8'},
    {'\x82','\xbe'},{'\x99','\xc9'},{'\xd8','\xbf'},{'\x00','\x00'},{'\xd8','\xc1'},
    {'\xd8','\xb5'},{'\xdc','\xfa'},{'\xdc','\xf8'},{'\xb7','\x42'},{'\xb7','\x40'},
    {'\xdd','\x43'},{'\xdc','\xf9'},{'\xdd','\x44'},{'\xdd','\x40'},{'\xdc','\xf7'},
    {'\xdd','\x46'},{'\xdc','\xf6'},{'\xdc','\xfd'},{'\xb6','\xfe'},{'\xb6','\xfd'},
    {'\xb6','\xfc'},{'\xdc','\xfb'},{'\xdd','\x41'},{'\xb6','\xf9'},{'\xb7','\x41'},
    {'\x99','\xca'},{'\xdc','\xf4'},{'\x00','\x00'},{'\xdc','\xfe'},{'\xdc','\xf3'},
    {'\xdc','\xfc'},{'\xb6','\xfa'},{'\xdd','\x42'},{'\xdc','\xf5'},{'\xb6','\xfb'},
    {'\xdd','\x45'},{'\x99','\xcb'},{'\x99','\xcc'},{'\x82','\xbf'},{'\x9d','\x67'},
    {'\x8e','\xe5'},{'\x99','\xcd'},{'\x89','\xd0'},{'\xe1','\x6e'},{'\xb9','\xe2'},
    {'\xb9','\xe1'},{'\xb9','\xe3'},{'\xe1','\x7a'},{'\xe1','\x70'},{'\xe1','\x76'},
    {'\xe1','\x6b'},{'\xe1','\x79'},{'\xe1','\x78'},{'\xe1','\x7c'},{'\xe1','\x75'},
    {'\xb9','\xde'},{'\xe1','\x74'},{'\xb9','\xe4'},{'\x99','\xce'},{'\xe1','\x6d'},
    {'\xb9','\xdf'},{'\x00','\x00'},{'\xe1','\x7b'},{'\xb9','\xe0'},{'\xe1','\x6f'},
    {'\xe1','\x72'},{'\xe1','\x77'},{'\xe1','\x71'},{'\xe1','\x6c'},{'\x00','\x00'},
    {'\x99','\xcf'},{'\x82','\xc0'},{'\xfb','\x67'},{'\xe1','\x73'},{'\xe5','\x55'},
    {'\xbc','\x61'},{'\xe5','\x58'},{'\xe5','\x57'},{'\xe5','\x5a'},{'\xe5','\x5c'},
    {'\xf9','\xdc'},{'\xbc','\x5f'},{'\x00','\x00'},{'\xe5','\x56'},{'\x99','\xd0'},
    {'\xe5','\x54'},{'\x00','\x00'},{'\xe5','\x5d'},{'\xe5','\x5b'},{'\xe5','\x59'},
    {'\x00','\x00'},{'\xe5','\x5f'},{'\x00','\x00'},{'\xe5','\x5e'},{'\xbc','\x63'},
    {'\xbc','\x5e'},{'\x00','\x00'},{'\xbc','\x60'},{'\xbc','\x62'},{'\x99','\xd1'},
    {'\x00','\x00'},{'\xe5','\x60'},{'\xe9','\x57'},{'\x99','\xd2'},{'\x00','\x00'},
    {'\xe9','\x56'},{'\xe9','\x55'},{'\x99','\xd3'},{'\xe9','\x58'},{'\xe9','\x51'},
    {'\x00','\x00'},{'\xe9','\x52'},{'\xe9','\x5a'},{'\xe9','\x53'},{'\x00','\x00'},
    {'\xbe','\xc5'},{'\xe9','\x5c'},{'\x99','\xd4'},{'\xe9','\x5b'},{'\xe9','\x54'},
    {'\x92','\xef'},{'\xec','\xd1'},{'\xc0','\xa8'},{'\xec','\xcf'},{'\xec','\xd4'},
    {'\xec','\xd3'},{'\xe9','\x59'},{'\x00','\x00'},{'\xc0','\xa7'},{'\x99','\xd5'},
    {'\xec','\xd2'},{'\xec','\xce'},{'\xec','\xd6'},{'\xec','\xd5'},{'\xc0','\xa6'},
    {'\x00','\x00'},{'\xec','\xd0'},{'\x00','\x00'},{'\xbe','\xc6'},{'\x00','\x00'},
    {'\x82','\xc1'},{'\x89','\xd1'},{'\xc2','\x54'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xef','\xc1'},{'\xf1','\xfa'},{'\xf1','\xfb'},{'\xf1','\xfc'},
    {'\xc4','\x5c'},{'\x99','\xd6'},{'\x00','\x00'},{'\xc4','\x5d'},{'\x99','\xd7'},
    {'\xf4','\x43'},{'\x99','\xd8'},{'\xf5','\xc8'},{'\xf5','\xc7'},{'\x00','\x00'},
    {'\x99','\xd9'},{'\xf6','\xdb'},{'\xf6','\xdc'},{'\xf7','\xd5'},{'\xf8','\xa7'},
    {'\x99','\xda'},{'\xa4','\x6c'},{'\xa4','\x6d'},{'\x00','\x00'},{'\xa4','\x6e'},
    {'\xa4','\xd5'},{'\xa5','\xa5'},{'\xc9','\xd3'},{'\xa6','\x72'},{'\xa6','\x73'},
    {'\x83','\xb2'},{'\xa7','\xb7'},{'\xa7','\xb8'},{'\xa7','\xb6'},{'\xa7','\xb5'},
    {'\x00','\x00'},{'\xa9','\x73'},{'\x00','\x00'},{'\x00','\x00'},{'\xcc','\x55'},
    {'\xa9','\x75'},{'\xa9','\x74'},{'\xcc','\x56'},{'\x88','\xd4'},{'\x00','\x00'},
    {'\x99','\xdb'},{'\xab','\xc4'},{'\x8c','\xcb'},{'\xae','\x5d'},{'\xd1','\x65'},
    {'\xa0','\x41'},{'\xd4','\xf0'},{'\x00','\x00'},{'\xb1','\x45'},{'\xb4','\x47'},
    {'\xd4','\xef'},{'\xb4','\x46'},{'\x99','\xdc'},{'\xb9','\xe5'},{'\x99','\xdd'},
    {'\xe1','\x7d'},{'\xbe','\xc7'},{'\x00','\x00'},{'\xc0','\xa9'},{'\xec','\xd7'},
    {'\x99','\xde'},{'\xc4','\x5e'},{'\x00','\x00'},{'\xc5','\x70'},{'\xc6','\xcb'},
    {'\xc9','\x72'},{'\x99','\xdf'},{'\xa5','\xa6'},{'\xc9','\x73'},{'\xa6','\x76'},
    {'\x00','\x00'},{'\xa6','\x74'},{'\xa6','\x75'},{'\xa6','\x77'},{'\x00','\x00'},
    {'\xa7','\xba'},{'\xa7','\xb9'},{'\x93','\xfd'},{'\xca','\xbc'},{'\xa7','\xbb'},
    {'\x99','\xe0'},{'\x00','\x00'},{'\xca','\xbd'},{'\xcc','\x57'},{'\x00','\x00'},
    {'\xcc','\x58'},{'\x9a','\x40'},{'\xa9','\x76'},{'\xa9','\x78'},{'\xa9','\x7a'},
    {'\xa9','\x77'},{'\xa9','\x7b'},{'\xa9','\x79'},{'\x8b','\xf3'},{'\x86','\xbf'},
    {'\x92','\xd4'},{'\x8b','\x70'},{'\x87','\xbf'},{'\xab','\xc8'},{'\xab','\xc5'},
    {'\xab','\xc7'},{'\xab','\xc9'},{'\xab','\xc6'},{'\xd1','\x66'},{'\xce','\x77'},
    {'\x00','\x00'},{'\x88','\xd6'},{'\x90','\xb3'},{'\xd1','\x68'},{'\xd1','\x67'},
    {'\xae','\x63'},{'\x00','\x00'},{'\xae','\x5f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xae','\x60'},{'\xae','\x62'},{'\xae','\x64'},{'\xae','\x61'},{'\x9d','\x68'},
    {'\xae','\x66'},{'\xae','\x65'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x87','\xbe'},{'\x87','\x59'},{'\xb1','\x4a'},{'\xd4','\xf2'},{'\xd4','\xf1'},
    {'\xb1','\x49'},{'\xfc','\x43'},{'\xb1','\x48'},{'\xb1','\x47'},{'\xb1','\x4b'},
    {'\xb1','\x46'},{'\x00','\x00'},{'\x82','\xc2'},{'\xd8','\xd5'},{'\xd8','\xd2'},
    {'\xb4','\x49'},{'\xd8','\xd1'},{'\xd8','\xd6'},{'\x00','\x00'},{'\xb4','\x4b'},
    {'\xd8','\xd4'},{'\xb4','\x48'},{'\xb4','\x4a'},{'\xd8','\xd3'},{'\x9a','\x55'},
    {'\xdd','\x48'},{'\x9a','\x56'},{'\xdd','\x49'},{'\xdd','\x4a'},{'\x00','\x00'},
    {'\x92','\x69'},{'\x00','\x00'},{'\x86','\xc0'},{'\xb9','\xe6'},{'\xb9','\xee'},
    {'\xe1','\x7e'},{'\xb9','\xe8'},{'\xb9','\xec'},{'\xe1','\xa1'},{'\xb9','\xed'},
    {'\xb9','\xe9'},{'\xb9','\xea'},{'\xb9','\xe7'},{'\xb9','\xeb'},{'\xbc','\x66'},
    {'\xd8','\xd0'},{'\xbc','\x67'},{'\xbc','\x65'},{'\x00','\x00'},{'\xbc','\x64'},
    {'\xe9','\x5d'},{'\xbe','\xc8'},{'\xec','\xd8'},{'\xec','\xd9'},{'\x82','\xc3'},
    {'\x00','\x00'},{'\xc3','\x64'},{'\xc4','\x5f'},{'\x00','\x00'},{'\xa4','\x6f'},
    {'\x86','\xc1'},{'\xa6','\x78'},{'\x84','\xd6'},{'\x88','\xd5'},{'\x00','\x00'},
    {'\x93','\x66'},{'\x86','\xba'},{'\x00','\x00'},{'\xab','\xca'},{'\x93','\x47'},
    {'\xd1','\x69'},{'\xae','\x67'},{'\x95','\x5b'},{'\x92','\xe2'},{'\xb1','\x4e'},
    {'\xb1','\x4d'},{'\xb1','\x4c'},{'\xb4','\x4c'},{'\xb4','\x4d'},{'\xd8','\xd7'},
    {'\xb9','\xef'},{'\xbe','\xc9'},{'\xa4','\x70'},{'\xc9','\x5c'},{'\xa4','\xd6'},
    {'\xc9','\x74'},{'\x82','\xc4'},{'\x86','\xe0'},{'\xc9','\xd4'},{'\xa6','\x79'},
    {'\x00','\x00'},{'\x86','\xb7'},{'\x00','\x00'},{'\xa9','\x7c'},{'\x00','\x00'},
    {'\x82','\xc5'},{'\x86','\xaf'},{'\x82','\xc6'},{'\xdd','\x4b'},{'\xfb','\xf3'},
    {'\x00','\x00'},{'\xa4','\x71'},{'\x9a','\x57'},{'\xa4','\xd7'},{'\xc9','\xd5'},
    {'\x00','\x00'},{'\x84','\xd0'},{'\xca','\xbe'},{'\x00','\x00'},{'\xca','\xbf'},
    {'\x00','\x00'},{'\xa7','\xbc'},{'\x82','\x59'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xd8','\xd8'},{'\xb4','\x4e'},{'\x00','\x00'},{'\xdd','\x4c'},{'\x89','\xd2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc0','\xaa'},{'\xa4','\x72'},{'\xa4','\xa8'},
    {'\xa4','\xd8'},{'\xc9','\x75'},{'\xa5','\xa7'},{'\x86','\xe9'},{'\xa7','\xc0'},
    {'\xa7','\xbf'},{'\xa7','\xbd'},{'\xa7','\xbe'},{'\x87','\xc1'},{'\x00','\x00'},
    {'\xcc','\x59'},{'\xa9','\x7e'},{'\xa9','\xa1'},{'\xcc','\x5a'},{'\xa9','\x7d'},
    {'\x84','\x40'},{'\x83','\x57'},{'\xab','\xce'},{'\xce','\x78'},{'\xab','\xcd'},
    {'\xab','\xcb'},{'\xab','\xcc'},{'\xae','\x6a'},{'\xae','\x68'},{'\x00','\x00'},
    {'\x82','\xc7'},{'\xd1','\x6b'},{'\xae','\x69'},{'\xd1','\x6a'},{'\x00','\x00'},
    {'\xae','\x5e'},{'\xd4','\xf3'},{'\x00','\x00'},{'\x00','\x00'},{'\xb1','\x50'},
    {'\xb1','\x51'},{'\x8c','\x70'},{'\x00','\x00'},{'\xb1','\x4f'},{'\x86','\xc2'},
    {'\xb9','\xf0'},{'\xe1','\xa2'},{'\xbc','\x68'},{'\xbc','\x69'},{'\x89','\xd3'},
    {'\xe5','\x61'},{'\xc0','\xab'},{'\xef','\xc2'},{'\xef','\xc3'},{'\x00','\x00'},
    {'\xc4','\xdd'},{'\xf8','\xa8'},{'\xc9','\x4b'},{'\xa4','\xd9'},{'\x00','\x00'},
    {'\xa4','\x73'},{'\x00','\x00'},{'\xc9','\x77'},{'\xc9','\x76'},{'\x00','\x00'},
    {'\x94','\x70'},{'\x00','\x00'},{'\x9d','\x64'},{'\xa6','\x7a'},{'\xc9','\xd7'},
    {'\xc9','\xd8'},{'\xc9','\xd6'},{'\x00','\x00'},{'\xc9','\xd9'},{'\x89','\xd4'},
    {'\x00','\x00'},{'\x85','\xd7'},{'\x83','\xdb'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9a','\x58'},{'\xca','\xc7'},{'\x00','\x00'},{'\xca','\xc2'},{'\xca','\xc4'},
    {'\xca','\xc6'},{'\xca','\xc3'},{'\xa7','\xc4'},{'\xca','\xc0'},{'\x00','\x00'},
    {'\xca','\xc1'},{'\xa7','\xc1'},{'\xa7','\xc2'},{'\xca','\xc5'},{'\xca','\xc8'},
    {'\xa7','\xc3'},{'\xca','\xc9'},{'\x86','\xc4'},{'\x84','\x42'},{'\x83','\xb5'},
    {'\x82','\xc8'},{'\x84','\xd7'},{'\x83','\xb4'},{'\x82','\xc9'},{'\xcc','\x68'},
    {'\x9a','\x59'},{'\xcc','\x62'},{'\xcc','\x5d'},{'\xa9','\xa3'},{'\xcc','\x65'},
    {'\xcc','\x63'},{'\xcc','\x5c'},{'\xcc','\x69'},{'\xcc','\x6c'},{'\xcc','\x67'},
    {'\xcc','\x60'},{'\xa9','\xa5'},{'\xcc','\x66'},{'\xa9','\xa6'},{'\xcc','\x61'},
    {'\xcc','\x64'},{'\xcc','\x5b'},{'\xcc','\x5f'},{'\xcc','\x6b'},{'\xa9','\xa7'},
    {'\x00','\x00'},{'\xa9','\xa8'},{'\x00','\x00'},{'\xcc','\x5e'},{'\xcc','\x6a'},
    {'\xa9','\xa2'},{'\xa9','\xa4'},{'\x00','\x00'},{'\x82','\xca'},{'\x82','\xcb'},
    {'\x94','\x71'},{'\x8d','\xcd'},{'\x94','\x73'},{'\x8f','\xfc'},{'\x00','\x00'},
    {'\x82','\xcc'},{'\x9a','\x5a'},{'\x00','\x00'},{'\x8e','\xe6'},{'\x94','\x72'},
    {'\xce','\xab'},{'\xce','\xa4'},{'\xce','\xaa'},{'\xce','\xa3'},{'\xce','\xa5'},
    {'\xce','\x7d'},{'\xce','\x7b'},{'\x00','\x00'},{'\xce','\xac'},{'\xce','\xa9'},
    {'\xce','\x79'},{'\xfb','\xf5'},{'\xab','\xd0'},{'\xce','\xa7'},{'\xce','\xa8'},
    {'\x9d','\x71'},{'\xce','\xa6'},{'\xce','\x7c'},{'\xce','\x7a'},{'\xab','\xcf'},
    {'\xce','\xa2'},{'\xce','\x7e'},{'\x00','\x00'},{'\x00','\x00'},{'\xce','\xa1'},
    {'\xce','\xad'},{'\x94','\x50'},{'\x83','\xb3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x8e','\xb4'},{'\x84','\x41'},{'\x8c','\xcd'},{'\x00','\x00'},{'\xae','\x6f'},
    {'\xfb','\xf6'},{'\xae','\x6e'},{'\x00','\x00'},{'\xd1','\x6c'},{'\xae','\x6b'},
    {'\xd1','\x6e'},{'\x95','\x5d'},{'\xae','\x70'},{'\xd1','\x6f'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xae','\x73'},{'\x82','\xcd'},{'\xae','\x71'},{'\xd1','\x70'},
    {'\xce','\xae'},{'\xd1','\x72'},{'\x82','\xce'},{'\xae','\x6d'},{'\x9d','\x69'},
    {'\xae','\x6c'},{'\x00','\x00'},{'\xd1','\x6d'},{'\xd1','\x71'},{'\xae','\x72'},
    {'\x8e','\xb3'},{'\x8d','\xce'},{'\x00','\x00'},{'\x00','\x00'},{'\xb1','\x53'},
    {'\xb1','\x52'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xd4','\xf5'},
    {'\xd4','\xf9'},{'\xd4','\xfb'},{'\xb1','\x54'},{'\xd4','\xfe'},{'\x9a','\x5b'},
    {'\xb1','\x58'},{'\xd5','\x41'},{'\x00','\x00'},{'\xb1','\x5a'},{'\x82','\xcf'},
    {'\xb1','\x56'},{'\xb1','\x5e'},{'\x82','\xd0'},{'\xb1','\x5b'},{'\xd4','\xf7'},
    {'\xb1','\x55'},{'\x00','\x00'},{'\xd4','\xf6'},{'\xd4','\xf4'},{'\xd5','\x43'},
    {'\xd4','\xf8'},{'\x00','\x00'},{'\xb1','\x57'},{'\xd5','\x42'},{'\xb1','\x5c'},
    {'\xd4','\xfd'},{'\xd4','\xfc'},{'\xb1','\x5d'},{'\xd4','\xfa'},{'\xb1','\x59'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9a','\x5c'},{'\x86','\xc3'},{'\xd5','\x44'},
    {'\x9a','\x5d'},{'\xd5','\x40'},{'\xd8','\xe7'},{'\xd8','\xee'},{'\xd8','\xe3'},
    {'\xb4','\x51'},{'\xd8','\xdf'},{'\xd8','\xef'},{'\xd8','\xd9'},{'\xd8','\xec'},
    {'\xd8','\xea'},{'\xd8','\xe4'},{'\x00','\x00'},{'\xd8','\xed'},{'\xd8','\xe6'},
    {'\x82','\xd1'},{'\xd8','\xde'},{'\xd8','\xf0'},{'\xd8','\xdc'},{'\xd8','\xe9'},
    {'\xd8','\xda'},{'\x00','\x00'},{'\xd8','\xf1'},{'\xfb','\xf7'},{'\xb4','\x52'},
    {'\x9a','\x5e'},{'\xd8','\xeb'},{'\xdd','\x4f'},{'\xd8','\xdd'},{'\xb4','\x4f'},
    {'\x00','\x00'},{'\xd8','\xe1'},{'\x00','\x00'},{'\xb4','\x50'},{'\xd8','\xe0'},
    {'\xd8','\xe5'},{'\x82','\xd2'},{'\x00','\x00'},{'\xd8','\xe2'},{'\x9a','\x5f'},
    {'\x95','\x65'},{'\x89','\xd5'},{'\xd8','\xe8'},{'\x00','\x00'},{'\x8d','\xdc'},
    {'\x82','\xd3'},{'\x8e','\x67'},{'\xdd','\x53'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xdd','\x56'},{'\xdd','\x4e'},{'\x00','\x00'},{'\xdd','\x50'},
    {'\x00','\x00'},{'\xdd','\x55'},{'\xdd','\x54'},{'\xb7','\x43'},{'\x00','\x00'},
    {'\xd8','\xdb'},{'\xdd','\x52'},{'\x82','\xd4'},{'\x00','\x00'},{'\xb7','\x44'},
    {'\x9a','\x60'},{'\xdd','\x4d'},{'\xdd','\x51'},{'\x82','\xd5'},{'\x82','\xd6'},
    {'\xfe','\x7e'},{'\x94','\x74'},{'\xe1','\xa9'},{'\x9d','\x7a'},{'\xe1','\xb0'},
    {'\xe1','\xa7'},{'\x9a','\x61'},{'\xe1','\xae'},{'\xe1','\xa5'},{'\xe1','\xad'},
    {'\xe1','\xb1'},{'\xe1','\xa4'},{'\xe1','\xa8'},{'\xe1','\xa3'},{'\x00','\x00'},
    {'\xb9','\xf1'},{'\x9a','\x62'},{'\xe1','\xa6'},{'\xb9','\xf2'},{'\xe1','\xac'},
    {'\xe1','\xab'},{'\xe1','\xaa'},{'\x93','\xfe'},{'\x82','\xd7'},{'\xe1','\xaf'},
    {'\xfb','\xf8'},{'\x00','\x00'},{'\x82','\xd8'},{'\x00','\x00'},{'\xe5','\x65'},
    {'\xe5','\x67'},{'\xbc','\x6b'},{'\xe5','\x68'},{'\x00','\x00'},{'\xe5','\x63'},
    {'\x00','\x00'},{'\xe5','\x62'},{'\xe5','\x6c'},{'\x00','\x00'},{'\xe5','\x6a'},
    {'\xbc','\x6a'},{'\xe5','\x6d'},{'\xe5','\x64'},{'\xe5','\x69'},{'\xe5','\x6b'},
    {'\xe5','\x66'},{'\x00','\x00'},{'\x9a','\x63'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe9','\x61'},{'\xe9','\x66'},{'\xe9','\x60'},{'\xe9','\x65'},{'\x9a','\x64'},
    {'\xe9','\x5e'},{'\xe9','\x68'},{'\xe9','\x64'},{'\xe9','\x69'},{'\xe9','\x63'},
    {'\xe9','\x5f'},{'\xe9','\x67'},{'\x00','\x00'},{'\xe9','\x6a'},{'\xe9','\x62'},
    {'\x9a','\x65'},{'\xec','\xda'},{'\xc0','\xaf'},{'\x82','\xd9'},{'\xc0','\xad'},
    {'\x00','\x00'},{'\xc0','\xac'},{'\xc0','\xae'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xef','\xc4'},{'\x9a','\x66'},{'\xf1','\x72'},{'\xf1','\xfd'},{'\x00','\x00'},
    {'\x8c','\xcc'},{'\xf4','\x44'},{'\xf4','\x45'},{'\x00','\x00'},{'\xc4','\x60'},
    {'\x00','\x00'},{'\xf5','\xc9'},{'\x82','\x53'},{'\xc4','\xde'},{'\x00','\x00'},
    {'\xf5','\xca'},{'\x82','\xda'},{'\xf6','\xde'},{'\xc5','\x72'},{'\x82','\xdb'},
    {'\xc5','\x71'},{'\xf6','\xdd'},{'\xc5','\xc9'},{'\x9a','\x67'},{'\xf7','\xd6'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xcc'},{'\x00','\x00'},{'\xa4','\x74'},
    {'\xa6','\x7b'},{'\xc9','\xda'},{'\xca','\xca'},{'\xa8','\xb5'},{'\xb1','\x5f'},
    {'\x93','\x57'},{'\x00','\x00'},{'\xa4','\x75'},{'\xa5','\xaa'},{'\xa5','\xa9'},
    {'\xa5','\xa8'},{'\x88','\xb2'},{'\x00','\x00'},{'\xa7','\xc5'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xae','\x74'},{'\x8e','\x43'},{'\xdd','\x57'},{'\xa4','\x76'},
    {'\xa4','\x77'},{'\xa4','\x78'},{'\xa4','\xda'},{'\xfb','\xfa'},{'\x00','\x00'},
    {'\xab','\xd1'},{'\x00','\x00'},{'\xce','\xaf'},{'\x00','\x00'},{'\x92','\x66'},
    {'\x00','\x00'},{'\xb4','\x53'},{'\xa4','\x79'},{'\xc9','\x5d'},{'\x00','\x00'},
    {'\x86','\xc5'},{'\xa5','\xab'},{'\xa5','\xac'},{'\xc9','\x78'},{'\x83','\x6c'},
    {'\xa6','\x7c'},{'\x00','\x00'},{'\x83','\xb6'},{'\x9a','\x68'},{'\xca','\xcb'},
    {'\xfb','\xfb'},{'\xa7','\xc6'},{'\x00','\x00'},{'\xca','\xcc'},{'\x84','\xd9'},
    {'\x84','\x44'},{'\xa9','\xae'},{'\xfb','\xfc'},{'\x00','\x00'},{'\xcc','\x6e'},
    {'\xa9','\xac'},{'\xa9','\xab'},{'\xcc','\x6d'},{'\xa9','\xa9'},{'\xcc','\x6f'},
    {'\xa9','\xaa'},{'\xa9','\xad'},{'\x87','\xc3'},{'\xab','\xd2'},{'\x00','\x00'},
    {'\xab','\xd4'},{'\xce','\xb3'},{'\xce','\xb0'},{'\xce','\xb1'},{'\xce','\xb2'},
    {'\xce','\xb4'},{'\xab','\xd3'},{'\x84','\x43'},{'\x84','\xd8'},{'\xd1','\x74'},
    {'\xd1','\x73'},{'\x00','\x00'},{'\xae','\x76'},{'\x00','\x00'},{'\xae','\x75'},
    {'\x89','\xd6'},{'\x93','\x67'},{'\x92','\x6f'},{'\x8f','\x50'},{'\x00','\x00'},
    {'\xb1','\x62'},{'\xd5','\x46'},{'\x00','\x00'},{'\xb1','\x61'},{'\xb1','\x63'},
    {'\xb1','\x60'},{'\x00','\x00'},{'\x00','\x00'},{'\x8e','\x68'},{'\x86','\xc6'},
    {'\xb4','\x55'},{'\xd5','\x45'},{'\x00','\x00'},{'\xb4','\x56'},{'\xd8','\xf3'},
    {'\x88','\xcb'},{'\xb4','\x57'},{'\xd8','\xf2'},{'\xb4','\x54'},{'\x00','\x00'},
    {'\x82','\xdc'},{'\x9a','\x69'},{'\x00','\x00'},{'\xdd','\x5a'},{'\xdd','\x5c'},
    {'\xb7','\x45'},{'\xdd','\x5b'},{'\xdd','\x59'},{'\xdd','\x58'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xe1','\xb4'},{'\xb9','\xf7'},{'\xb9','\xf5'},
    {'\x00','\x00'},{'\xb9','\xf6'},{'\xe1','\xb2'},{'\xe1','\xb3'},{'\x00','\x00'},
    {'\xb9','\xf3'},{'\xe5','\x71'},{'\xe5','\x6f'},{'\xfb','\xfe'},{'\xbc','\x6d'},
    {'\xe5','\x70'},{'\xbc','\x6e'},{'\xbc','\x6c'},{'\xb9','\xf4'},{'\x82','\xdd'},
    {'\x00','\x00'},{'\xe9','\x6d'},{'\xe9','\x6b'},{'\xe9','\x6c'},{'\xe5','\x6e'},
    {'\xec','\xdc'},{'\xc0','\xb0'},{'\xec','\xdb'},{'\xef','\xc5'},{'\xef','\xc6'},
    {'\xe9','\x6e'},{'\xf1','\xfe'},{'\x00','\x00'},{'\xa4','\x7a'},{'\xa5','\xad'},
    {'\xa6','\x7e'},{'\xc9','\xdb'},{'\xa6','\x7d'},{'\x00','\x00'},{'\xa9','\xaf'},
    {'\xb7','\x46'},{'\xc6','\xcd'},{'\xa4','\xdb'},{'\xa5','\xae'},{'\xab','\xd5'},
    {'\xb4','\x58'},{'\xc6','\xce'},{'\xc9','\x79'},{'\x93','\x75'},{'\xc9','\x7a'},
    {'\x92','\xbe'},{'\xc9','\xdc'},{'\x00','\x00'},{'\x87','\xca'},{'\xa7','\xc8'},
    {'\xca','\xd0'},{'\xca','\xce'},{'\xa7','\xc9'},{'\xca','\xcd'},{'\xca','\xcf'},
    {'\xca','\xd1'},{'\x00','\x00'},{'\xa7','\xc7'},{'\x8b','\x72'},{'\x8e','\xb5'},
    {'\x9a','\x6a'},{'\x83','\xb7'},{'\x89','\xd8'},{'\xa9','\xb3'},{'\xa9','\xb4'},
    {'\xa9','\xb1'},{'\x00','\x00'},{'\x87','\xc6'},{'\xa9','\xb0'},{'\xce','\xb8'},
    {'\xa9','\xb2'},{'\x00','\x00'},{'\x8b','\x71'},{'\x87','\xc4'},{'\xab','\xd6'},
    {'\x00','\x00'},{'\xce','\xb7'},{'\xce','\xb9'},{'\xce','\xb6'},{'\xce','\xba'},
    {'\xab','\xd7'},{'\xae','\x79'},{'\xd1','\x75'},{'\x00','\x00'},{'\xd1','\x77'},
    {'\xae','\x77'},{'\xd1','\x78'},{'\xae','\x78'},{'\xd1','\x76'},{'\x00','\x00'},
    {'\xce','\xb5'},{'\xd5','\x47'},{'\xd5','\x4a'},{'\xd5','\x4b'},{'\xd5','\x48'},
    {'\xb1','\x67'},{'\xb1','\x66'},{'\xb1','\x64'},{'\xb1','\x65'},{'\xd5','\x49'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9a','\x6b'},{'\xb1','\x68'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb4','\x5a'},{'\xb4','\x5b'},{'\x93','\xb2'},
    {'\xb4','\x5c'},{'\xdd','\x5d'},{'\xdd','\x5f'},{'\xdd','\x61'},{'\xb7','\x48'},
    {'\xb7','\x47'},{'\xb4','\x59'},{'\xdd','\x60'},{'\xdd','\x5e'},{'\xfe','\xa4'},
    {'\xe1','\xb8'},{'\x82','\xde'},{'\x82','\xdf'},{'\xe1','\xb6'},{'\xe1','\xbc'},
    {'\xb9','\xf8'},{'\xe1','\xbd'},{'\xe1','\xba'},{'\xb9','\xf9'},{'\xe1','\xb7'},
    {'\xe1','\xb5'},{'\xe1','\xbb'},{'\xbc','\x70'},{'\xe5','\x73'},{'\xe1','\xb9'},
    {'\xbc','\x72'},{'\xe5','\x74'},{'\xbc','\x71'},{'\xbc','\x74'},{'\xe5','\x75'},
    {'\xbc','\x6f'},{'\xbc','\x73'},{'\x00','\x00'},{'\xe9','\x73'},{'\xe9','\x71'},
    {'\xe9','\x70'},{'\xe9','\x72'},{'\xe9','\x6f'},{'\x82','\xe0'},{'\x00','\x00'},
    {'\xc3','\x66'},{'\x00','\x00'},{'\xf4','\x46'},{'\xf4','\x47'},{'\x82','\xe1'},
    {'\xf5','\xcb'},{'\xf6','\xdf'},{'\xc6','\x55'},{'\xc6','\xcf'},{'\x00','\x00'},
    {'\xa9','\xb5'},{'\xa7','\xca'},{'\x95','\xa4'},{'\x95','\xa1'},{'\xab','\xd8'},
    {'\x95','\xee'},{'\x95','\xfa'},{'\x00','\x00'},{'\xa4','\x7b'},{'\xa4','\xdc'},
    {'\x85','\x7b'},{'\xa5','\xaf'},{'\xc9','\xdd'},{'\x84','\x56'},{'\xa7','\xcb'},
    {'\xca','\xd2'},{'\x00','\x00'},{'\xce','\xbb'},{'\xab','\xd9'},{'\x82','\xe2'},
    {'\xb9','\xfa'},{'\xa4','\x7c'},{'\x82','\xe3'},{'\x95','\xaa'},{'\x9a','\x6c'},
    {'\xa6','\xa1'},{'\x93','\xae'},{'\x82','\xe4'},{'\xb7','\x49'},{'\xa4','\x7d'},
    {'\xa4','\xdd'},{'\xa4','\xde'},{'\x94','\x75'},{'\xa5','\xb1'},{'\xa5','\xb0'},
    {'\x00','\x00'},{'\xc9','\xde'},{'\xa6','\xa2'},{'\x00','\x00'},{'\xca','\xd3'},
    {'\x00','\x00'},{'\xa7','\xcc'},{'\x84','\x45'},{'\x82','\xe5'},{'\xcc','\x71'},
    {'\xcc','\x72'},{'\xcc','\x73'},{'\x93','\xf9'},{'\xa9','\xb6'},{'\xa9','\xb7'},
    {'\xcc','\x70'},{'\xa9','\xb8'},{'\x8d','\xc3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xab','\xda'},{'\xce','\xbc'},{'\x8c','\xce'},{'\xd1','\x7a'},{'\xae','\x7a'},
    {'\x00','\x00'},{'\xd1','\x79'},{'\x82','\xe6'},{'\xb1','\x69'},{'\xd5','\x4c'},
    {'\xb1','\x6a'},{'\xd5','\x4d'},{'\x87','\xc9'},{'\x84','\x46'},{'\x9d','\x7b'},
    {'\xb4','\x5d'},{'\x00','\x00'},{'\x93','\x71'},{'\x00','\x00'},{'\xdd','\x62'},
    {'\x82','\xe7'},{'\x00','\x00'},{'\xe1','\xbf'},{'\xe1','\xbe'},{'\x82','\xe8'},
    {'\xb9','\xfb'},{'\x00','\x00'},{'\xbc','\x75'},{'\xe5','\x76'},{'\xbe','\xca'},
    {'\xe9','\x74'},{'\xc0','\xb1'},{'\xfc','\x41'},{'\xc5','\x73'},{'\xf7','\xd8'},
    {'\xc6','\xd0'},{'\x82','\xe9'},{'\x8a','\xd0'},{'\x85','\xe5'},{'\xcc','\x74'},
    {'\x89','\xa3'},{'\xce','\xbd'},{'\xb1','\x6b'},{'\xd8','\xf4'},{'\xb7','\x4a'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x82','\xea'},{'\xc2','\x55'},{'\xc2','\x55'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\xd1'},{'\xa7','\xce'},{'\xfe','\xa8'},
    {'\xa7','\xcd'},{'\xab','\xdb'},{'\x82','\xeb'},{'\xd1','\x7b'},{'\x00','\x00'},
    {'\xb1','\x6d'},{'\xb3','\x43'},{'\xb1','\x6e'},{'\xb1','\x6c'},{'\xb4','\x5e'},
    {'\x00','\x00'},{'\xe1','\xc0'},{'\xb9','\xfc'},{'\xbc','\x76'},{'\x9a','\x6d'},
    {'\xc9','\x4c'},{'\xc9','\xdf'},{'\x00','\x00'},{'\xca','\xd5'},{'\xa7','\xcf'},
    {'\xca','\xd4'},{'\xa7','\xd0'},{'\x00','\x00'},{'\x86','\xc7'},{'\xa9','\xbc'},
    {'\xcc','\x77'},{'\xcc','\x76'},{'\xa9','\xbb'},{'\xa9','\xb9'},{'\xa9','\xba'},
    {'\xcc','\x75'},{'\x82','\xec'},{'\x92','\xa6'},{'\xab','\xdd'},{'\xce','\xbe'},
    {'\xab','\xe0'},{'\xab','\xdc'},{'\xab','\xe2'},{'\xab','\xde'},{'\xab','\xdf'},
    {'\xab','\xe1'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xae','\x7d'},
    {'\xae','\x7c'},{'\xae','\x7b'},{'\x92','\xdc'},{'\x00','\x00'},{'\x84','\x48'},
    {'\xd5','\x4f'},{'\xb1','\x6f'},{'\xb1','\x72'},{'\xb1','\x70'},{'\x00','\x00'},
    {'\xd5','\x4e'},{'\xb1','\x75'},{'\x00','\x00'},{'\xb1','\x71'},{'\xd5','\x50'},
    {'\xb1','\x74'},{'\xb1','\x73'},{'\x00','\x00'},{'\x00','\x00'},{'\xfc','\x47'},
    {'\xd8','\xf6'},{'\xd8','\xf5'},{'\x95','\x5a'},{'\xb4','\x61'},{'\xb4','\x5f'},
    {'\xb4','\x60'},{'\xd8','\xf7'},{'\xb7','\x4b'},{'\xdd','\x64'},{'\xb7','\x4c'},
    {'\xdd','\x63'},{'\x00','\x00'},{'\x9a','\x6e'},{'\xe5','\x77'},{'\x93','\xa8'},
    {'\x93','\x76'},{'\xbc','\x78'},{'\xe1','\xc1'},{'\xbc','\x77'},{'\x00','\x00'},
    {'\xb9','\xfd'},{'\xfc','\x48'},{'\xec','\xde'},{'\xe9','\x75'},{'\xc0','\xb2'},
    {'\xec','\xdd'},{'\xf2','\x40'},{'\xf4','\x48'},{'\xf4','\x49'},{'\x9a','\x6f'},
    {'\xa4','\xdf'},{'\x9c','\xf5'},{'\xa5','\xb2'},{'\x88','\xda'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc9','\x7b'},{'\x00','\x00'},{'\x00','\x00'},{'\xa7','\xd2'},
    {'\xa7','\xd4'},{'\x00','\x00'},{'\xc9','\xe2'},{'\xca','\xd8'},{'\xca','\xd7'},
    {'\xca','\xd6'},{'\x00','\x00'},{'\xc9','\xe1'},{'\xc9','\xe0'},{'\xa6','\xa4'},
    {'\xa7','\xd3'},{'\xa7','\xd1'},{'\xa6','\xa3'},{'\x00','\x00'},{'\x9a','\x70'},
    {'\x92','\x4e'},{'\xa9','\xbd'},{'\xcc','\x78'},{'\x9a','\x71'},{'\xa9','\xbe'},
    {'\xca','\xdd'},{'\x00','\x00'},{'\xca','\xdf'},{'\xca','\xde'},{'\xcc','\x79'},
    {'\x00','\x00'},{'\x87','\xcc'},{'\xca','\xda'},{'\x00','\x00'},{'\xa7','\xd8'},
    {'\xa7','\xd6'},{'\x00','\x00'},{'\xca','\xd9'},{'\xca','\xdb'},{'\xca','\xe1'},
    {'\x82','\xed'},{'\xa7','\xd5'},{'\x00','\x00'},{'\xca','\xdc'},{'\xca','\xe5'},
    {'\xa9','\xc0'},{'\x00','\x00'},{'\xca','\xe2'},{'\xa7','\xd7'},{'\x00','\x00'},
    {'\xca','\xe0'},{'\xca','\xe3'},{'\x00','\x00'},{'\xa9','\xbf'},{'\x85','\xc7'},
    {'\xa9','\xc1'},{'\xca','\xe4'},{'\x86','\xc8'},{'\x87','\xcd'},{'\x87','\xd1'},
    {'\x8e','\x6b'},{'\x84','\x4a'},{'\x85','\xc8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xcc','\xaf'},{'\xcc','\xa2'},{'\xcc','\x7e'},{'\xcc','\xae'},{'\xcc','\xa9'},
    {'\xab','\xe7'},{'\xa9','\xc2'},{'\xcc','\xaa'},{'\xcc','\xad'},{'\xab','\xe3'},
    {'\xcc','\xac'},{'\xa9','\xc3'},{'\xa9','\xc8'},{'\xa9','\xc6'},{'\xcc','\xa3'},
    {'\x00','\x00'},{'\xcc','\x7c'},{'\xcc','\xa5'},{'\xa9','\xcd'},{'\xcc','\xb0'},
    {'\xab','\xe4'},{'\xcc','\xa6'},{'\x00','\x00'},{'\xab','\xe5'},{'\xa9','\xc9'},
    {'\xcc','\xa8'},{'\x9a','\x72'},{'\xce','\xcd'},{'\xab','\xe6'},{'\xcc','\x7b'},
    {'\xa9','\xca'},{'\xab','\xe8'},{'\xa9','\xcb'},{'\xa9','\xc7'},{'\xa9','\xcc'},
    {'\xcc','\xa7'},{'\xcc','\x7a'},{'\xcc','\xab'},{'\xa9','\xc4'},{'\x00','\x00'},
    {'\x95','\xa6'},{'\xcc','\x7d'},{'\xcc','\xa4'},{'\xcc','\xa1'},{'\xa9','\xc5'},
    {'\x00','\x00'},{'\xce','\xbf'},{'\x00','\x00'},{'\xce','\xc0'},{'\x94','\x76'},
    {'\x8a','\x4b'},{'\x8f','\x74'},{'\x00','\x00'},{'\x00','\x00'},{'\x8e','\xe7'},
    {'\xce','\xca'},{'\xd1','\xa1'},{'\xce','\xcb'},{'\xab','\xee'},{'\xce','\xce'},
    {'\xce','\xc4'},{'\xab','\xed'},{'\xce','\xc6'},{'\x00','\x00'},{'\xce','\xc7'},
    {'\x82','\xee'},{'\x8c','\xf6'},{'\xce','\xc9'},{'\xab','\xe9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xae','\xa3'},{'\x00','\x00'},{'\xf9','\xda'},{'\xce','\xc5'},
    {'\xce','\xc1'},{'\xae','\xa4'},{'\x00','\x00'},{'\x00','\x00'},{'\xce','\xcf'},
    {'\xae','\x7e'},{'\xd1','\x7d'},{'\xce','\xc8'},{'\x00','\x00'},{'\xd1','\x7c'},
    {'\xce','\xc3'},{'\xce','\xcc'},{'\x82','\xef'},{'\x00','\x00'},{'\xab','\xec'},
    {'\xae','\xa1'},{'\xab','\xf2'},{'\xae','\xa2'},{'\xce','\xd0'},{'\xd1','\x7e'},
    {'\xab','\xeb'},{'\xae','\xa6'},{'\xab','\xf1'},{'\xab','\xf0'},{'\xab','\xef'},
    {'\xae','\xa5'},{'\xce','\xd1'},{'\xae','\xa7'},{'\xab','\xea'},{'\x00','\x00'},
    {'\xce','\xc2'},{'\x89','\xd9'},{'\x00','\x00'},{'\x92','\xa8'},{'\x84','\xdc'},
    {'\xfc','\x4b'},{'\x86','\xca'},{'\x8f','\x51'},{'\x85','\xc9'},{'\x84','\xdf'},
    {'\x84','\xe0'},{'\x8d','\xdd'},{'\x9a','\x73'},{'\xb1','\x76'},{'\xd1','\xa4'},
    {'\xd1','\xa6'},{'\x00','\x00'},{'\xd1','\xa8'},{'\xae','\xa8'},{'\xae','\xae'},
    {'\xd5','\x53'},{'\xd1','\xac'},{'\xd1','\xa3'},{'\xb1','\x78'},{'\xd5','\x51'},
    {'\x82','\xf0'},{'\xae','\xad'},{'\xae','\xab'},{'\xd1','\xae'},{'\x00','\x00'},
    {'\xd5','\x52'},{'\x00','\x00'},{'\xd1','\xa5'},{'\x00','\x00'},{'\xae','\xac'},
    {'\xd1','\xa9'},{'\xae','\xaf'},{'\xd1','\xab'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xae','\xaa'},{'\xd1','\xaa'},{'\xd1','\xad'},{'\xd1','\xa7'},{'\xfb','\x64'},
    {'\xae','\xa9'},{'\xb1','\x79'},{'\x00','\x00'},{'\xd1','\xa2'},{'\xb1','\x77'},
    {'\xfc','\x4c'},{'\x00','\x00'},{'\x82','\xf1'},{'\xfe','\xa6'},{'\xb1','\x7a'},
    {'\x93','\xaf'},{'\x92','\x41'},{'\x8e','\x69'},{'\x8b','\xf4'},{'\x8e','\x6a'},
    {'\x00','\x00'},{'\x87','\xce'},{'\xd5','\x55'},{'\xd5','\x5e'},{'\xb4','\x64'},
    {'\xfc','\x4d'},{'\xb1','\x7c'},{'\xb1','\xa3'},{'\xb4','\x65'},{'\xd5','\x60'},
    {'\xb1','\xaa'},{'\xd8','\xf9'},{'\xd5','\x56'},{'\xb1','\xa2'},{'\xb1','\xa5'},
    {'\xb1','\x7e'},{'\xd5','\x54'},{'\xd5','\x62'},{'\xd5','\x65'},{'\xd9','\x49'},
    {'\x00','\x00'},{'\xd5','\x63'},{'\xd8','\xfd'},{'\xb1','\xa1'},{'\xb1','\xa8'},
    {'\xb1','\xac'},{'\xd5','\x5d'},{'\xd8','\xf8'},{'\xd5','\x61'},{'\xb1','\x7b'},
    {'\xd8','\xfa'},{'\xd5','\x64'},{'\xd8','\xfc'},{'\xd5','\x59'},{'\x00','\x00'},
    {'\xb4','\x62'},{'\x00','\x00'},{'\xd5','\x57'},{'\xd5','\x58'},{'\xb1','\xa7'},
    {'\x00','\x00'},{'\x9a','\x74'},{'\xb1','\xa6'},{'\xd5','\x5b'},{'\xb1','\xab'},
    {'\xd5','\x5f'},{'\xb1','\xa4'},{'\xd5','\x5c'},{'\x82','\xf2'},{'\xb1','\xa9'},
    {'\xb4','\x66'},{'\xb4','\x63'},{'\xd8','\xfb'},{'\x82','\xad'},{'\xd5','\x5a'},
    {'\x00','\x00'},{'\xb1','\x7d'},{'\x8c','\x71'},{'\x86','\xcc'},{'\x8b','\x73'},
    {'\x00','\x00'},{'\x88','\xd8'},{'\x84','\xde'},{'\x86','\xcb'},{'\x87','\xcf'},
    {'\x86','\xc9'},{'\xb4','\x6b'},{'\xb4','\x6f'},{'\xd9','\x40'},{'\xb7','\x51'},
    {'\xb4','\x6d'},{'\xd9','\x44'},{'\xb4','\x71'},{'\xdd','\x65'},{'\xd9','\x46'},
    {'\xb7','\x53'},{'\xb4','\x69'},{'\xb4','\x6c'},{'\xd9','\x47'},{'\xfc','\x4e'},
    {'\xd9','\x48'},{'\xd9','\x4e'},{'\xb4','\x73'},{'\xb7','\x54'},{'\x00','\x00'},
    {'\xd9','\x4a'},{'\xd9','\x4f'},{'\xd9','\x43'},{'\xb7','\x5e'},{'\x9a','\x75'},
    {'\xb7','\x55'},{'\xb4','\x72'},{'\xd9','\x41'},{'\xd9','\x50'},{'\x9a','\x76'},
    {'\xb7','\x5d'},{'\xb4','\x70'},{'\xb7','\x4e'},{'\xd9','\x4d'},{'\x82','\xf3'},
    {'\xb4','\x74'},{'\xd9','\x45'},{'\xd8','\xfe'},{'\xb4','\x6a'},{'\xd9','\x42'},
    {'\x00','\x00'},{'\xd9','\x4b'},{'\x9a','\x77'},{'\xb7','\x4d'},{'\xb7','\x52'},
    {'\xb4','\x67'},{'\xd9','\x4c'},{'\x00','\x00'},{'\xb7','\x50'},{'\x82','\xf4'},
    {'\x82','\xf5'},{'\x9a','\x78'},{'\xb4','\x68'},{'\x87','\xd0'},{'\x00','\x00'},
    {'\x8e','\xb6'},{'\xb7','\x5c'},{'\xe1','\xc3'},{'\xdd','\x70'},{'\x00','\x00'},
    {'\xdd','\x68'},{'\xe1','\xc2'},{'\x00','\x00'},{'\xdd','\x6c'},{'\xdd','\x6e'},
    {'\xfc','\x4f'},{'\x00','\x00'},{'\xdd','\x6b'},{'\x00','\x00'},{'\xb7','\x5b'},
    {'\x00','\x00'},{'\xdd','\x6a'},{'\xb7','\x5f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe1','\xd2'},{'\x82','\xf6'},{'\x82','\xf7'},{'\xb7','\x5a'},
    {'\xba','\x40'},{'\xdd','\x71'},{'\xe1','\xc4'},{'\xfc','\xc9'},{'\x00','\x00'},
    {'\xb7','\x58'},{'\xdd','\x69'},{'\xdd','\x6d'},{'\xb9','\xfe'},{'\xb7','\x4f'},
    {'\xdd','\x66'},{'\xdd','\x67'},{'\xba','\x41'},{'\xb7','\x57'},{'\xb7','\x59'},
    {'\xb7','\x56'},{'\xdd','\x6f'},{'\x9a','\x79'},{'\x8c','\x72'},{'\xe1','\xc8'},
    {'\xe1','\xc9'},{'\xe1','\xce'},{'\xbc','\x7d'},{'\xe1','\xd5'},{'\x00','\x00'},
    {'\xba','\x47'},{'\xfc','\x52'},{'\xba','\x46'},{'\xe1','\xd0'},{'\xfc','\x54'},
    {'\xbc','\x7c'},{'\xe1','\xc5'},{'\xba','\x45'},{'\x9a','\x7a'},{'\xe1','\xd4'},
    {'\xba','\x43'},{'\xba','\x44'},{'\x95','\xad'},{'\xe1','\xd1'},{'\xe5','\xaa'},
    {'\xbc','\x7a'},{'\xb4','\x6e'},{'\x00','\x00'},{'\xe1','\xd3'},{'\xbc','\xa3'},
    {'\xe1','\xcb'},{'\x00','\x00'},{'\xbc','\x7b'},{'\x95','\x66'},{'\xbc','\xa2'},
    {'\xe1','\xc6'},{'\xe1','\xca'},{'\xe1','\xc7'},{'\xe1','\xcd'},{'\xba','\x48'},
    {'\xbc','\x79'},{'\xba','\x42'},{'\x00','\x00'},{'\xe5','\x7a'},{'\xe1','\xcf'},
    {'\x00','\x00'},{'\xbc','\xa1'},{'\xfc','\x53'},{'\xbc','\xa4'},{'\x00','\x00'},
    {'\xe1','\xcc'},{'\x9a','\x7b'},{'\xbc','\x7e'},{'\xe5','\x79'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x95','\xd1'},{'\x00','\x00'},{'\xe5','\x7e'},
    {'\xbe','\xce'},{'\xe5','\x78'},{'\xe9','\xa3'},{'\xe5','\xa9'},{'\xbc','\xa8'},
    {'\x00','\x00'},{'\xbc','\xa6'},{'\xbe','\xcc'},{'\xe5','\xa6'},{'\xe5','\xa2'},
    {'\xbc','\xac'},{'\x9a','\x7c'},{'\xe9','\x78'},{'\x00','\x00'},{'\x82','\xf8'},
    {'\xfe','\x74'},{'\xbc','\xaa'},{'\xe5','\xa1'},{'\xfc','\x51'},{'\xe9','\x76'},
    {'\x00','\x00'},{'\xe5','\xa5'},{'\x00','\x00'},{'\xe5','\xa8'},{'\xe5','\x7d'},
    {'\x00','\x00'},{'\xbc','\xab'},{'\x00','\x00'},{'\x00','\x00'},{'\xbc','\xa5'},
    {'\xe9','\x77'},{'\xbe','\xcd'},{'\xe5','\xa7'},{'\xbc','\xa7'},{'\xbc','\xa9'},
    {'\xe5','\xa4'},{'\xbc','\xad'},{'\xe5','\xa3'},{'\xe5','\x7c'},{'\xe5','\x7b'},
    {'\xbe','\xcb'},{'\xe5','\xab'},{'\xe9','\x7a'},{'\xec','\xe0'},{'\xbe','\xd0'},
    {'\x82','\xf9'},{'\xe9','\xa2'},{'\x9a','\x7d'},{'\xe9','\x7e'},{'\x00','\x00'},
    {'\xec','\xe1'},{'\x00','\x00'},{'\xbe','\xd1'},{'\xe9','\xa1'},{'\x9a','\x7e'},
    {'\xe9','\x7c'},{'\xc0','\xb4'},{'\xec','\xdf'},{'\x00','\x00'},{'\xe9','\x79'},
    {'\xe9','\x7b'},{'\xc0','\xb5'},{'\xbe','\xd3'},{'\xc0','\xb3'},{'\xbe','\xd2'},
    {'\xc0','\xb7'},{'\xe9','\x7d'},{'\xbe','\xcf'},{'\x00','\x00'},{'\x9a','\xa1'},
    {'\x92','\x5d'},{'\x8a','\xc2'},{'\x8b','\x75'},{'\x9a','\xa2'},{'\x88','\xd9'},
    {'\x00','\x00'},{'\xef','\xcf'},{'\x00','\x00'},{'\xef','\xc7'},{'\x00','\x00'},
    {'\x9a','\xa3'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xec','\xe7'},
    {'\xef','\xc8'},{'\xec','\xe3'},{'\x00','\x00'},{'\xfc','\x56'},{'\xc2','\x56'},
    {'\xec','\xe5'},{'\xec','\xe4'},{'\xc0','\xb6'},{'\xec','\xe2'},{'\xec','\xe6'},
    {'\xef','\xd0'},{'\xef','\xcc'},{'\xef','\xce'},{'\x00','\x00'},{'\xef','\xc9'},
    {'\xef','\xca'},{'\x00','\x00'},{'\xef','\xcd'},{'\xef','\xcb'},{'\xc3','\x67'},
    {'\x00','\x00'},{'\x82','\xfa'},{'\xc3','\x6a'},{'\xc3','\x69'},{'\xc3','\x68'},
    {'\xc4','\x61'},{'\xf4','\x4a'},{'\xc4','\x62'},{'\xf2','\x41'},{'\xc4','\xdf'},
    {'\xf5','\xcc'},{'\xc4','\xe0'},{'\xc5','\x74'},{'\xc5','\xca'},{'\xf7','\xd9'},
    {'\x00','\x00'},{'\xf7','\xda'},{'\xf7','\xdb'},{'\x00','\x00'},{'\x90','\xab'},
    {'\xf9','\xba'},{'\xa4','\xe0'},{'\xc9','\x7c'},{'\xa5','\xb3'},{'\x8d','\xb8'},
    {'\xa6','\xa6'},{'\xa6','\xa7'},{'\xa6','\xa5'},{'\x89','\xda'},{'\xa6','\xa8'},
    {'\xa7','\xda'},{'\xa7','\xd9'},{'\x82','\xfb'},{'\xcc','\xb1'},{'\xa9','\xcf'},
    {'\xa9','\xce'},{'\x8e','\x6d'},{'\x88','\xdb'},{'\xd1','\xaf'},{'\xb1','\xad'},
    {'\xb1','\xae'},{'\x00','\x00'},{'\x82','\xfc'},{'\x82','\xfd'},{'\xb4','\x75'},
    {'\xdd','\x72'},{'\xb7','\x60'},{'\xb7','\x61'},{'\xdd','\x74'},{'\xdd','\x76'},
    {'\xdd','\x75'},{'\x93','\x49'},{'\xe1','\xd7'},{'\x00','\x00'},{'\xe1','\xd6'},
    {'\xba','\x49'},{'\xe1','\xd8'},{'\x8e','\x6c'},{'\xe5','\xac'},{'\xbc','\xae'},
    {'\x92','\x70'},{'\xbe','\xd4'},{'\x00','\x00'},{'\xc0','\xb8'},{'\xc2','\x57'},
    {'\xc0','\xb9'},{'\x00','\x00'},{'\xa4','\xe1'},{'\x82','\xfe'},{'\x90','\xbd'},
    {'\xfc','\x58'},{'\xca','\xe6'},{'\x93','\xec'},{'\x00','\x00'},{'\xcc','\xb2'},
    {'\xa9','\xd1'},{'\xa9','\xd0'},{'\xa9','\xd2'},{'\xab','\xf3'},{'\xce','\xd2'},
    {'\xce','\xd3'},{'\x00','\x00'},{'\x00','\x00'},{'\xd1','\xb0'},{'\xae','\xb0'},
    {'\xb1','\xaf'},{'\xb4','\x76'},{'\xd9','\x51'},{'\xa4','\xe2'},{'\x9c','\xf2'},
    {'\xa4','\x7e'},{'\xa4','\xe3'},{'\x00','\x00'},{'\xc9','\x7d'},{'\xa5','\xb7'},
    {'\xa5','\xb6'},{'\xa5','\xb4'},{'\xa5','\xb5'},{'\x93','\xc1'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa6','\xab'},{'\xc9','\xe9'},{'\xc9','\xeb'},{'\xa6','\xaa'},
    {'\xc9','\xe3'},{'\x00','\x00'},{'\xc9','\xe4'},{'\x00','\x00'},{'\xc9','\xea'},
    {'\xc9','\xe6'},{'\xc9','\xe8'},{'\xa6','\xa9'},{'\xc9','\xe5'},{'\xc9','\xec'},
    {'\xc9','\xe7'},{'\x83','\xf9'},{'\xfc','\x59'},{'\x8a','\xc3'},{'\x84','\x4d'},
    {'\x84','\x4b'},{'\x84','\xe4'},{'\xa7','\xe1'},{'\xa7','\xea'},{'\xa7','\xe8'},
    {'\xca','\xf0'},{'\xca','\xed'},{'\xca','\xf5'},{'\xa7','\xe6'},{'\xca','\xf6'},
    {'\x00','\x00'},{'\xa7','\xdf'},{'\xca','\xf3'},{'\x00','\x00'},{'\xa7','\xe5'},
    {'\xca','\xef'},{'\xca','\xee'},{'\xa7','\xe3'},{'\xca','\xf4'},{'\xa7','\xe4'},
    {'\xa9','\xd3'},{'\xa7','\xde'},{'\xca','\xf1'},{'\xfc','\x5b'},{'\xca','\xe7'},
    {'\xa7','\xdb'},{'\xfc','\x5a'},{'\xa7','\xee'},{'\xca','\xec'},{'\xca','\xf2'},
    {'\xa7','\xe0'},{'\xa7','\xe2'},{'\x00','\x00'},{'\xca','\xe8'},{'\x00','\x00'},
    {'\xca','\xe9'},{'\xca','\xea'},{'\x9a','\xa4'},{'\xa7','\xed'},{'\xa7','\xe7'},
    {'\xa7','\xec'},{'\xca','\xeb'},{'\xa7','\xeb'},{'\xa7','\xdd'},{'\xa7','\xdc'},
    {'\xa7','\xe9'},{'\x00','\x00'},{'\x87','\xd7'},{'\x90','\xbe'},{'\x93','\xbb'},
    {'\xfd','\x57'},{'\x93','\x6a'},{'\x8e','\x6e'},{'\x8e','\x6f'},{'\x84','\x4e'},
    {'\x85','\xcb'},{'\x00','\x00'},{'\x8c','\xa8'},{'\x84','\xd2'},{'\xfc','\x5c'},
    {'\x00','\x00'},{'\xa9','\xe1'},{'\xcc','\xbe'},{'\xcc','\xb7'},{'\xa9','\xdc'},
    {'\xa9','\xef'},{'\xcc','\xb3'},{'\xcc','\xba'},{'\xcc','\xbc'},{'\xcc','\xbf'},
    {'\xa9','\xea'},{'\x00','\x00'},{'\xcc','\xbb'},{'\xcc','\xb4'},{'\xa9','\xe8'},
    {'\xcc','\xb8'},{'\x00','\x00'},{'\xcc','\xc0'},{'\xa9','\xd9'},{'\x00','\x00'},
    {'\xcc','\xbd'},{'\xa9','\xe3'},{'\xa9','\xe2'},{'\xcc','\xb6'},{'\xa9','\xd7'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa9','\xd8'},{'\xfb','\x46'},{'\xa9','\xd6'},
    {'\x88','\xe3'},{'\xa9','\xee'},{'\xa9','\xe6'},{'\xa9','\xe0'},{'\xa9','\xd4'},
    {'\xcc','\xb9'},{'\xa9','\xdf'},{'\xa9','\xd5'},{'\xa9','\xe7'},{'\xa9','\xf0'},
    {'\xce','\xd4'},{'\xa9','\xe4'},{'\xcc','\xb5'},{'\xa9','\xda'},{'\xa9','\xdd'},
    {'\xa9','\xde'},{'\xfc','\x5d'},{'\xa9','\xec'},{'\xa9','\xed'},{'\xa9','\xeb'},
    {'\xa9','\xe5'},{'\xa9','\xe9'},{'\xa9','\xdb'},{'\xab','\xf4'},{'\x93','\xb1'},
    {'\x00','\x00'},{'\x89','\xde'},{'\x92','\x75'},{'\x92','\x5e'},{'\x8b','\x76'},
    {'\x84','\xe1'},{'\x00','\x00'},{'\x88','\xdc'},{'\x8b','\xf6'},{'\x89','\xdd'},
    {'\x87','\xd5'},{'\x88','\xe1'},{'\x00','\x00'},{'\xce','\xda'},{'\xac','\x41'},
    {'\xab','\xf8'},{'\xab','\xfa'},{'\xac','\x40'},{'\xce','\xe6'},{'\xab','\xfd'},
    {'\xd1','\xb1'},{'\xae','\xb1'},{'\xac','\x43'},{'\xce','\xd7'},{'\xce','\xdf'},
    {'\xab','\xfe'},{'\xce','\xde'},{'\xce','\xdb'},{'\xce','\xe3'},{'\xce','\xe5'},
    {'\xab','\xf7'},{'\xab','\xfb'},{'\xac','\x42'},{'\xae','\xb3'},{'\xce','\xe0'},
    {'\xab','\xf9'},{'\xac','\x45'},{'\xce','\xd9'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xab','\xfc'},{'\xae','\xb2'},{'\xab','\xf6'},{'\x00','\x00'},
    {'\xce','\xd6'},{'\xce','\xdd'},{'\xce','\xd5'},{'\xce','\xd8'},{'\xce','\xdc'},
    {'\xd1','\xb2'},{'\xac','\x44'},{'\x00','\x00'},{'\xce','\xe1'},{'\xce','\xe2'},
    {'\xce','\xe4'},{'\xab','\xf5'},{'\x00','\x00'},{'\x94','\xf4'},{'\x92','\x76'},
    {'\x87','\xd2'},{'\x8c','\xf7'},{'\x00','\x00'},{'\x88','\xe4'},{'\x88','\xde'},
    {'\x83','\xb9'},{'\x87','\xd6'},{'\x88','\xdd'},{'\x8e','\xb7'},{'\x84','\x4f'},
    {'\x89','\xdc'},{'\x84','\xe2'},{'\x00','\x00'},{'\x90','\xbf'},{'\xae','\xc1'},
    {'\xd1','\xbe'},{'\xae','\xbf'},{'\xae','\xc0'},{'\xd1','\xb4'},{'\xd1','\xc4'},
    {'\xa0','\x5e'},{'\xae','\xb6'},{'\x00','\x00'},{'\x9a','\xa5'},{'\xd5','\x66'},
    {'\xd1','\xc6'},{'\xd1','\xc0'},{'\xfc','\x5f'},{'\xd1','\xb7'},{'\x9a','\xa7'},
    {'\xd1','\xc9'},{'\xd1','\xba'},{'\xae','\xbc'},{'\xd5','\x7d'},{'\xd1','\xbd'},
    {'\xae','\xbe'},{'\xae','\xb5'},{'\x93','\x56'},{'\xd1','\xcb'},{'\xd1','\xbf'},
    {'\xae','\xb8'},{'\xd1','\xb8'},{'\xd1','\xb5'},{'\xd1','\xb6'},{'\xae','\xb9'},
    {'\xd1','\xc5'},{'\xd1','\xcc'},{'\xae','\xbb'},{'\xd1','\xbc'},{'\xd1','\xbb'},
    {'\xae','\xc3'},{'\xae','\xc2'},{'\xae','\xb4'},{'\xae','\xba'},{'\xae','\xbd'},
    {'\xd1','\xc8'},{'\x00','\x00'},{'\x00','\x00'},{'\xd1','\xc2'},{'\xae','\xb7'},
    {'\xd1','\xb3'},{'\xd1','\xca'},{'\xd1','\xc1'},{'\xd1','\xc3'},{'\xd1','\xc7'},
    {'\x00','\x00'},{'\x93','\x55'},{'\x00','\x00'},{'\x87','\xd4'},{'\x85','\xca'},
    {'\x00','\x00'},{'\x88','\xe2'},{'\x84','\xe3'},{'\x85','\xcc'},{'\xfc','\x5e'},
    {'\xd5','\x67'},{'\x00','\x00'},{'\xb1','\xb7'},{'\xb1','\xcb'},{'\xb1','\xca'},
    {'\x00','\x00'},{'\xb1','\xbf'},{'\x95','\x59'},{'\xd5','\x79'},{'\xd5','\x75'},
    {'\xd5','\x72'},{'\xd5','\xa6'},{'\xb1','\xba'},{'\xb1','\xb2'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd5','\x77'},{'\xb4','\xa8'},{'\xb1','\xb6'},{'\xd5','\xa1'},
    {'\x9a','\xa8'},{'\xb1','\xcc'},{'\xb1','\xc9'},{'\xd5','\x7b'},{'\xd5','\x6a'},
    {'\x00','\x00'},{'\xfc','\x55'},{'\xb1','\xc8'},{'\xd5','\xa3'},{'\xd5','\x69'},
    {'\xb1','\xbd'},{'\xb1','\xc1'},{'\xd5','\xa2'},{'\x00','\x00'},{'\xd5','\x73'},
    {'\xb1','\xc2'},{'\xb1','\xbc'},{'\xd5','\x68'},{'\x9a','\xa9'},{'\xb4','\x78'},
    {'\xd5','\xa5'},{'\xd5','\x71'},{'\xb1','\xc7'},{'\xd5','\x74'},{'\xd5','\xa4'},
    {'\xb1','\xc6'},{'\x00','\x00'},{'\xd9','\x52'},{'\x00','\x00'},{'\xb1','\xb3'},
    {'\xd5','\x6f'},{'\xb1','\xb8'},{'\xb1','\xc3'},{'\x00','\x00'},{'\xb1','\xbe'},
    {'\xd5','\x78'},{'\xd5','\x6e'},{'\xd5','\x6c'},{'\xd5','\x7e'},{'\xb1','\xb0'},
    {'\xb1','\xc4'},{'\xb1','\xb4'},{'\xb4','\x77'},{'\xd5','\x7c'},{'\xb1','\xb5'},
    {'\x00','\x00'},{'\xb1','\xb1'},{'\xb1','\xc0'},{'\xb1','\xbb'},{'\xb1','\xb9'},
    {'\xd5','\x70'},{'\xb1','\xc5'},{'\xd5','\x6d'},{'\xd5','\x7a'},{'\xd5','\x76'},
    {'\xd9','\x54'},{'\xd9','\x53'},{'\x92','\xa9'},{'\x88','\xe0'},{'\x86','\xce'},
    {'\x94','\x77'},{'\x00','\x00'},{'\x8a','\xc4'},{'\x87','\xd8'},{'\xfb','\x57'},
    {'\x86','\xcf'},{'\x90','\xc0'},{'\x8e','\x70'},{'\xd5','\x6b'},{'\xd9','\x64'},
    {'\x00','\x00'},{'\xb4','\x7a'},{'\x9a','\xaa'},{'\xd9','\x6a'},{'\xd9','\x59'},
    {'\xd9','\x67'},{'\xdd','\x77'},{'\xb4','\x7d'},{'\xd9','\x6b'},{'\xd9','\x6e'},
    {'\xb4','\x7c'},{'\xd9','\x5c'},{'\xd9','\x6d'},{'\xd9','\x6c'},{'\xb4','\x7e'},
    {'\xd9','\x55'},{'\xb4','\x79'},{'\xb4','\xa3'},{'\xfd','\x6c'},{'\xb4','\xa1'},
    {'\xd9','\x69'},{'\x00','\x00'},{'\xd9','\x5f'},{'\xb4','\xa5'},{'\xd9','\x70'},
    {'\xd9','\x68'},{'\xd9','\x71'},{'\xb4','\xad'},{'\xb4','\xab'},{'\xd9','\x66'},
    {'\xd9','\x65'},{'\x90','\xc1'},{'\xd9','\x63'},{'\xd9','\x5d'},{'\xb4','\xa4'},
    {'\x9a','\xab'},{'\xb4','\xa2'},{'\xd1','\xb9'},{'\xd9','\x56'},{'\x9a','\xac'},
    {'\xdd','\xb7'},{'\xd9','\x57'},{'\xb4','\x7b'},{'\xb4','\xaa'},{'\xdd','\x79'},
    {'\x00','\x00'},{'\xb4','\xa6'},{'\xb4','\xa7'},{'\xd9','\x58'},{'\xd9','\x6f'},
    {'\xdd','\x78'},{'\xd9','\x60'},{'\xd9','\x5b'},{'\xb4','\xa9'},{'\xd9','\x61'},
    {'\xd9','\x5e'},{'\x00','\x00'},{'\xa0','\x5f'},{'\xb4','\xae'},{'\x90','\xc2'},
    {'\x9a','\xad'},{'\xfb','\x5d'},{'\x8d','\x53'},{'\x9a','\xae'},{'\x87','\xd9'},
    {'\x8b','\xf7'},{'\x89','\xdf'},{'\x86','\xcd'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x8c','\xf8'},{'\xb7','\x70'},{'\x9a','\xaf'},{'\x00','\x00'},{'\xdd','\x7c'},
    {'\xdd','\xb1'},{'\xdd','\xb6'},{'\xdd','\xaa'},{'\xb7','\x6c'},{'\xdd','\xbb'},
    {'\xb7','\x69'},{'\xdd','\x7a'},{'\x00','\x00'},{'\xdd','\x7b'},{'\xb7','\x62'},
    {'\xb7','\x6b'},{'\xdd','\xa4'},{'\xb7','\x6e'},{'\xb7','\x6f'},{'\xdd','\xa5'},
    {'\x00','\x00'},{'\xdd','\xb2'},{'\xdd','\xb8'},{'\xb7','\x6a'},{'\x00','\x00'},
    {'\xb7','\x64'},{'\xdd','\xa3'},{'\xdd','\x7d'},{'\xdd','\xba'},{'\xdd','\xa8'},
    {'\xdd','\xa9'},{'\xdd','\x7e'},{'\xdd','\xb4'},{'\xdd','\xab'},{'\xdd','\xb5'},
    {'\xdd','\xad'},{'\x00','\x00'},{'\xb7','\x65'},{'\xe1','\xd9'},{'\xb7','\x68'},
    {'\xb7','\x66'},{'\xdd','\xb9'},{'\xdd','\xb0'},{'\xdd','\xac'},{'\x00','\x00'},
    {'\x9a','\xb0'},{'\xdd','\xa1'},{'\xba','\x53'},{'\xdd','\xaf'},{'\xb7','\x6d'},
    {'\xdd','\xa7'},{'\x9a','\xb1'},{'\xdd','\xa6'},{'\x8c','\x74'},{'\x9a','\xb2'},
    {'\x00','\x00'},{'\xb7','\x67'},{'\xb7','\x63'},{'\xe1','\xee'},{'\xdd','\xb3'},
    {'\xdd','\xae'},{'\x93','\x45'},{'\xdd','\xa2'},{'\x8c','\x73'},{'\x8f','\x75'},
    {'\x8a','\xc7'},{'\x93','\xda'},{'\x8f','\x52'},{'\x00','\x00'},{'\x8c','\xcf'},
    {'\xe1','\xe9'},{'\x00','\x00'},{'\xe1','\xda'},{'\xe1','\xe5'},{'\x00','\x00'},
    {'\xe1','\xec'},{'\xba','\x51'},{'\xb4','\xac'},{'\xe1','\xea'},{'\xba','\x4c'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xba','\x4b'},{'\xe1','\xf1'},
    {'\x9a','\xb3'},{'\xe1','\xdb'},{'\xe1','\xe8'},{'\xe1','\xdc'},{'\xe1','\xe7'},
    {'\xba','\x4f'},{'\xe1','\xeb'},{'\xd9','\x62'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe1','\xf2'},{'\xe1','\xe3'},{'\xba','\x52'},{'\xe5','\xba'},
    {'\xbc','\xaf'},{'\x00','\x00'},{'\xe1','\xf0'},{'\xe1','\xef'},{'\xba','\x54'},
    {'\xe5','\xad'},{'\xbc','\xb0'},{'\xe5','\xae'},{'\x9a','\xb4'},{'\xe1','\xdf'},
    {'\xe1','\xe0'},{'\xe1','\xdd'},{'\xe1','\xe2'},{'\xe1','\xde'},{'\xe1','\xf3'},
    {'\xba','\x4e'},{'\xbc','\xb1'},{'\xba','\x50'},{'\xba','\x55'},{'\x9a','\xb5'},
    {'\xe1','\xe1'},{'\x00','\x00'},{'\xe1','\xed'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe1','\xe6'},{'\x92','\xb0'},{'\x8f','\xda'},{'\xe5','\xb1'},{'\x00','\x00'},
    {'\xba','\x4a'},{'\xbc','\xb4'},{'\xe9','\xaa'},{'\xe5','\xb6'},{'\xe5','\xb5'},
    {'\xe5','\xb7'},{'\x9a','\xb6'},{'\x00','\x00'},{'\xe5','\xb4'},{'\xbc','\xb5'},
    {'\x90','\xc3'},{'\xbc','\xbb'},{'\xbc','\xb8'},{'\x00','\x00'},{'\xbc','\xb9'},
    {'\xe5','\xaf'},{'\xe5','\xb2'},{'\xe5','\xbc'},{'\xbc','\xc1'},{'\xbc','\xbf'},
    {'\x00','\x00'},{'\xe5','\xb3'},{'\xd9','\x5a'},{'\xbc','\xb2'},{'\xe5','\xb9'},
    {'\xe5','\xb0'},{'\x00','\x00'},{'\xbc','\xc2'},{'\xe5','\xb8'},{'\xba','\x4d'},
    {'\xbc','\xb7'},{'\xe1','\xe4'},{'\x00','\x00'},{'\x00','\x00'},{'\xbc','\xba'},
    {'\x00','\x00'},{'\xbc','\xbe'},{'\xbc','\xc0'},{'\xbc','\xbd'},{'\xbc','\xbc'},
    {'\x9a','\xb7'},{'\xbc','\xb6'},{'\xe5','\xbb'},{'\xbc','\xb3'},{'\xbc','\xc3'},
    {'\x9a','\xb8'},{'\x8a','\xc6'},{'\x9a','\xb9'},{'\x8a','\xc9'},{'\x8f','\x76'},
    {'\x82','\x4d'},{'\x8f','\xfe'},{'\xbe','\xd8'},{'\xbe','\xd9'},{'\xe9','\xa9'},
    {'\xbe','\xe2'},{'\xbe','\xdf'},{'\x90','\xc4'},{'\xbe','\xd6'},{'\xbe','\xdd'},
    {'\xe9','\xab'},{'\xbe','\xdb'},{'\xbe','\xd5'},{'\x00','\x00'},{'\xbe','\xdc'},
    {'\x00','\x00'},{'\xe9','\xa8'},{'\xc0','\xbb'},{'\xbe','\xd7'},{'\x00','\x00'},
    {'\xbe','\xde'},{'\xc0','\xba'},{'\xe9','\xa7'},{'\xe9','\xa6'},{'\x00','\x00'},
    {'\xbe','\xe0'},{'\xa0','\x5d'},{'\xbe','\xe1'},{'\x00','\x00'},{'\xe9','\xa5'},
    {'\xe9','\xa4'},{'\xc0','\xbc'},{'\xe9','\xae'},{'\xbe','\xda'},{'\xe9','\xac'},
    {'\x00','\x00'},{'\x9a','\xba'},{'\x8a','\xc8'},{'\x00','\x00'},{'\xc0','\xbd'},
    {'\x90','\xc5'},{'\xc0','\xc2'},{'\xec','\xea'},{'\xec','\xec'},{'\x9a','\xbb'},
    {'\xc0','\xbf'},{'\xfb','\xa3'},{'\xec','\xed'},{'\xec','\xe9'},{'\x95','\xc8'},
    {'\xec','\xeb'},{'\xc0','\xc0'},{'\xc0','\xc3'},{'\x00','\x00'},{'\xec','\xe8'},
    {'\xc0','\xbe'},{'\xc0','\xc1'},{'\xc2','\x59'},{'\xe9','\xad'},{'\xc2','\x58'},
    {'\x00','\x00'},{'\x90','\xc6'},{'\xc2','\x5e'},{'\xef','\xd4'},{'\x00','\x00'},
    {'\xc2','\x5c'},{'\xc2','\x5d'},{'\xef','\xd7'},{'\xef','\xd3'},{'\xc2','\x5a'},
    {'\xef','\xd1'},{'\xc3','\x6b'},{'\xef','\xd5'},{'\x00','\x00'},{'\xef','\xd6'},
    {'\xef','\xd2'},{'\x90','\xc7'},{'\xc2','\x5b'},{'\xf2','\x42'},{'\x00','\x00'},
    {'\xf2','\x45'},{'\x9a','\xbc'},{'\x00','\x00'},{'\xf2','\x46'},{'\xf2','\x44'},
    {'\xf2','\x47'},{'\xc3','\x6c'},{'\xf2','\x43'},{'\x9a','\xbd'},{'\x90','\x57'},
    {'\xf4','\x4e'},{'\xc4','\x64'},{'\xf4','\x4d'},{'\xf4','\x4c'},{'\xf4','\x4b'},
    {'\xc4','\x63'},{'\xc4','\x65'},{'\x00','\x00'},{'\xf5','\xcd'},{'\xc4','\xe2'},
    {'\xc4','\xe1'},{'\xa0','\x60'},{'\x9a','\xbe'},{'\xf6','\xe1'},{'\xf6','\xe0'},
    {'\xf6','\xe3'},{'\xc5','\xcb'},{'\xc5','\x75'},{'\xf7','\xdd'},{'\xf6','\xe2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf7','\xdc'},{'\xc5','\xcd'},{'\xc5','\xcc'},
    {'\xc5','\xf3'},{'\xf8','\xa9'},{'\xf8','\xef'},{'\xa4','\xe4'},{'\xfe','\x5b'},
    {'\x00','\x00'},{'\xd9','\x72'},{'\xe9','\xaf'},{'\xc6','\xd2'},{'\x90','\xc8'},
    {'\xa6','\xac'},{'\xca','\xf7'},{'\xa7','\xf1'},{'\xa7','\xef'},{'\x00','\x00'},
    {'\xa7','\xf0'},{'\x00','\x00'},{'\xcc','\xc1'},{'\xa9','\xf1'},{'\xac','\x46'},
    {'\x00','\x00'},{'\xce','\xe7'},{'\x00','\x00'},{'\xce','\xe8'},{'\x00','\x00'},
    {'\xac','\x47'},{'\xd1','\xce'},{'\x00','\x00'},{'\xae','\xc4'},{'\xae','\xc5'},
    {'\xd1','\xcd'},{'\x00','\x00'},{'\x87','\xda'},{'\x95','\xb4'},{'\x90','\xc9'},
    {'\xb1','\xd3'},{'\x00','\x00'},{'\xb1','\xcf'},{'\x00','\x00'},{'\xd5','\xa7'},
    {'\xb1','\xd6'},{'\xb1','\xd5'},{'\xb1','\xce'},{'\xb1','\xd1'},{'\xb1','\xd4'},
    {'\xb1','\xd0'},{'\x00','\x00'},{'\x89','\xe0'},{'\xd9','\x76'},{'\xb1','\xcd'},
    {'\xb4','\xaf'},{'\x9a','\xbf'},{'\x00','\x00'},{'\x00','\x00'},{'\xb4','\xb1'},
    {'\xb4','\xb2'},{'\xd9','\x75'},{'\xd9','\x78'},{'\xb4','\xb0'},{'\xd9','\x73'},
    {'\xd9','\x77'},{'\x00','\x00'},{'\xd9','\x74'},{'\x90','\xca'},{'\xb7','\x71'},
    {'\x9a','\xc0'},{'\x00','\x00'},{'\xdd','\xbc'},{'\x87','\xdb'},{'\x00','\x00'},
    {'\xba','\x56'},{'\xe1','\xf4'},{'\xbe','\xe3'},{'\xbc','\xc4'},{'\xe5','\xbd'},
    {'\xbc','\xc5'},{'\xbc','\xc6'},{'\xe5','\xbf'},{'\xe5','\xbe'},{'\xe5','\xc0'},
    {'\xe9','\xb1'},{'\x00','\x00'},{'\x00','\x00'},{'\xe9','\xb0'},{'\xec','\xef'},
    {'\xec','\xee'},{'\xc0','\xc4'},{'\xc0','\xc5'},{'\xf2','\x48'},{'\xfc','\xb7'},
    {'\x9a','\xc1'},{'\xa4','\xe5'},{'\x90','\xcb'},{'\x93','\x42'},{'\x00','\x00'},
    {'\x8a','\xbc'},{'\xd9','\x79'},{'\x00','\x00'},{'\x92','\xc7'},{'\x00','\x00'},
    {'\xb4','\xb4'},{'\xb4','\xb3'},{'\xdd','\xbd'},{'\x8c','\x75'},{'\xef','\xd8'},
    {'\xc4','\xe3'},{'\xf7','\xde'},{'\xa4','\xe6'},{'\x00','\x00'},{'\xae','\xc6'},
    {'\x00','\x00'},{'\xb1','\xd8'},{'\xb1','\xd7'},{'\xd9','\x7a'},{'\xd9','\x7b'},
    {'\xb7','\x72'},{'\xe1','\xf5'},{'\xba','\x57'},{'\xe9','\xb2'},{'\x00','\x00'},
    {'\xa4','\xe7'},{'\xa5','\xb8'},{'\x00','\x00'},{'\xa9','\xf2'},{'\xcc','\xc2'},
    {'\x84','\x53'},{'\xce','\xe9'},{'\xac','\x48'},{'\xb1','\xd9'},{'\x8a','\xca'},
    {'\xd9','\x7c'},{'\xb4','\xb5'},{'\xb7','\x73'},{'\x00','\x00'},{'\xe5','\xc1'},
    {'\xe5','\xc2'},{'\x00','\x00'},{'\x9a','\xc2'},{'\xec','\xf0'},{'\xc2','\x5f'},
    {'\xf8','\xf0'},{'\xa4','\xe8'},{'\x00','\x00'},{'\xcc','\xc3'},{'\xa9','\xf3'},
    {'\xac','\x49'},{'\x9a','\xc3'},{'\xce','\xea'},{'\x00','\x00'},{'\xae','\xc7'},
    {'\xd1','\xd2'},{'\xd1','\xd0'},{'\xd1','\xd1'},{'\xae','\xc8'},{'\xd1','\xcf'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xb1','\xdb'},
    {'\xb1','\xdc'},{'\xd5','\xa8'},{'\xb1','\xdd'},{'\xb1','\xda'},{'\xd9','\x7d'},
    {'\x9a','\xc4'},{'\xd9','\x7e'},{'\xdd','\xbe'},{'\x9a','\xc5'},{'\x00','\x00'},
    {'\xba','\x59'},{'\xba','\x58'},{'\x00','\x00'},{'\x90','\xcc'},{'\xec','\xf1'},
    {'\xef','\xd9'},{'\x00','\x00'},{'\xf2','\x4a'},{'\xf2','\x49'},{'\xf4','\x4f'},
    {'\xc6','\xd3'},{'\xc9','\x5e'},{'\xac','\x4a'},{'\x9a','\xc6'},{'\x00','\x00'},
    {'\xa4','\xe9'},{'\xa5','\xb9'},{'\x8a','\xf6'},{'\xa6','\xae'},{'\xa6','\xad'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xa6','\xaf'},{'\xa6','\xb0'},{'\xc9','\xee'},
    {'\xc9','\xed'},{'\xca','\xf8'},{'\xa7','\xf2'},{'\xca','\xfb'},{'\xca','\xfa'},
    {'\xca','\xf9'},{'\xca','\xfc'},{'\x83','\xba'},{'\x8b','\x77'},{'\x85','\xd0'},
    {'\x00','\x00'},{'\xa9','\xf4'},{'\xcc','\xc9'},{'\xcc','\xc5'},{'\xcc','\xce'},
    {'\x00','\x00'},{'\x9a','\xc7'},{'\xa9','\xfb'},{'\x00','\x00'},{'\xa9','\xf9'},
    {'\xcc','\xca'},{'\xcc','\xc6'},{'\xcc','\xcd'},{'\xa9','\xf8'},{'\xaa','\x40'},
    {'\xcc','\xc8'},{'\xcc','\xc4'},{'\xa9','\xfe'},{'\xcc','\xcb'},{'\xa9','\xf7'},
    {'\xcc','\xcc'},{'\xa9','\xfa'},{'\xa9','\xfc'},{'\xcc','\xd0'},{'\xcc','\xcf'},
    {'\xcc','\xc7'},{'\xa9','\xf6'},{'\xa9','\xf5'},{'\xa9','\xfd'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9a','\xc8'},{'\x88','\xe8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xce','\xef'},{'\xce','\xf5'},{'\x90','\xcd'},{'\xac','\x50'},{'\xac','\x4d'},
    {'\xce','\xec'},{'\xce','\xf1'},{'\x9a','\xc9'},{'\xac','\x53'},{'\xac','\x4b'},
    {'\xce','\xf0'},{'\xac','\x4e'},{'\xac','\x51'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xce','\xf3'},{'\x00','\x00'},{'\xac','\x4c'},{'\xce','\xf8'},{'\xac','\x4f'},
    {'\x95','\xfe'},{'\xac','\x52'},{'\xce','\xed'},{'\xce','\xf2'},{'\xce','\xf6'},
    {'\xce','\xee'},{'\xce','\xeb'},{'\x00','\x00'},{'\x00','\x00'},{'\xce','\xf7'},
    {'\xce','\xf4'},{'\x90','\xce'},{'\x84','\x54'},{'\x00','\x00'},{'\x8d','\x46'},
    {'\x90','\xcf'},{'\x00','\x00'},{'\xae','\xd0'},{'\xae','\xc9'},{'\xae','\xcc'},
    {'\x90','\xd0'},{'\xae','\xcf'},{'\x00','\x00'},{'\xd1','\xd5'},{'\xfc','\x62'},
    {'\xae','\xca'},{'\xd1','\xd3'},{'\x83','\xbb'},{'\xae','\xce'},{'\x9d','\x59'},
    {'\x00','\x00'},{'\xae','\xcb'},{'\x00','\x00'},{'\xd1','\xd6'},{'\xae','\xcd'},
    {'\x88','\xe6'},{'\x88','\xe7'},{'\x85','\xcf'},{'\x85','\xce'},{'\x90','\xd1'},
    {'\x00','\x00'},{'\xd5','\xac'},{'\xb1','\xdf'},{'\xd5','\xab'},{'\xd5','\xad'},
    {'\xb1','\xde'},{'\xb1','\xe3'},{'\xd1','\xd4'},{'\x00','\x00'},{'\xd5','\xaa'},
    {'\xd5','\xae'},{'\x9a','\xca'},{'\xb1','\xe0'},{'\xd5','\xa9'},{'\xb1','\xe2'},
    {'\xfc','\x63'},{'\xb1','\xe1'},{'\x90','\xd2'},{'\xd9','\xa7'},{'\x9a','\xcb'},
    {'\xd9','\xa2'},{'\x00','\x00'},{'\xb4','\xb6'},{'\xb4','\xba'},{'\xb4','\xb7'},
    {'\xd9','\xa5'},{'\xd9','\xa8'},{'\x90','\xd3'},{'\xb4','\xb8'},{'\x00','\x00'},
    {'\xb4','\xb9'},{'\xb4','\xbe'},{'\xdd','\xc7'},{'\xd9','\xa6'},{'\xb4','\xbc'},
    {'\xd9','\xa3'},{'\xd9','\xa1'},{'\x9a','\xcc'},{'\xb4','\xbd'},{'\x00','\x00'},
    {'\xd9','\xa4'},{'\x92','\x7d'},{'\x87','\xdc'},{'\x90','\xd4'},{'\xb7','\x79'},
    {'\x9a','\xcd'},{'\xdd','\xbf'},{'\xb7','\x76'},{'\xb7','\x77'},{'\xb7','\x75'},
    {'\xdd','\xc4'},{'\xdd','\xc3'},{'\xdd','\xc0'},{'\xb7','\x7b'},{'\xfe','\x7a'},
    {'\x00','\x00'},{'\xdd','\xc2'},{'\xb4','\xbb'},{'\x9a','\xce'},{'\x00','\x00'},
    {'\xdd','\xc6'},{'\xdd','\xc1'},{'\xb7','\x78'},{'\xb7','\x74'},{'\xb7','\x7a'},
    {'\xdd','\xc5'},{'\x9a','\xcf'},{'\x00','\x00'},{'\x00','\x00'},{'\xba','\x5c'},
    {'\x00','\x00'},{'\xe1','\xf8'},{'\xe1','\xf7'},{'\xe1','\xf6'},{'\xba','\x5a'},
    {'\x00','\x00'},{'\x9a','\xd0'},{'\x00','\x00'},{'\x93','\xef'},{'\x89','\xe2'},
    {'\xba','\x5b'},{'\xe5','\xc5'},{'\xe5','\xc8'},{'\xbc','\xc8'},{'\x00','\x00'},
    {'\x9a','\xd1'},{'\xbc','\xc7'},{'\xe5','\xc9'},{'\xe5','\xc4'},{'\xbc','\xca'},
    {'\xe5','\xc6'},{'\x9a','\xd2'},{'\xbc','\xc9'},{'\xe5','\xc3'},{'\x9a','\xd3'},
    {'\xe5','\xc7'},{'\xbe','\xe9'},{'\xbe','\xe6'},{'\xe9','\xbb'},{'\xe9','\xba'},
    {'\x90','\xd5'},{'\xe9','\xb9'},{'\xe9','\xb4'},{'\x90','\xd6'},{'\xe9','\xb5'},
    {'\x90','\xd7'},{'\x00','\x00'},{'\x00','\x00'},{'\xbe','\xe7'},{'\x00','\x00'},
    {'\xbe','\xe4'},{'\xbe','\xe8'},{'\xe9','\xb3'},{'\xbe','\xe5'},{'\xe9','\xb6'},
    {'\xe9','\xb7'},{'\xe9','\xbc'},{'\x9a','\xd4'},{'\x9a','\xd5'},{'\xe9','\xb8'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xec','\xf2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc0','\xc7'},{'\x00','\x00'},{'\xef','\xdc'},{'\xc0','\xc6'},
    {'\xef','\xda'},{'\xef','\xdb'},{'\xc2','\x60'},{'\xc3','\x6e'},{'\xf2','\x4b'},
    {'\x00','\x00'},{'\xc3','\x6d'},{'\x00','\x00'},{'\x00','\x00'},{'\xf4','\x51'},
    {'\xf4','\x52'},{'\x00','\x00'},{'\xc4','\x66'},{'\x9d','\xca'},{'\xf4','\x50'},
    {'\xc4','\xe4'},{'\x00','\x00'},{'\xf7','\xdf'},{'\xc5','\xce'},{'\xf8','\xaa'},
    {'\xf8','\xab'},{'\x00','\x00'},{'\xa4','\xea'},{'\xa0','\x58'},{'\xa6','\xb1'},
    {'\xa6','\xb2'},{'\xa7','\xf3'},{'\x90','\xd8'},{'\xcc','\xd1'},{'\xac','\x54'},
    {'\xae','\xd1'},{'\xb1','\xe4'},{'\x90','\xd9'},{'\x90','\xda'},{'\xb0','\xd2'},
    {'\x93','\xfb'},{'\xb4','\xbf'},{'\xb4','\xc0'},{'\xb3','\xcc'},{'\xd9','\xa9'},
    {'\x9a','\xd6'},{'\xb7','\x7c'},{'\xe1','\xfa'},{'\xe1','\xf9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xa4','\xeb'},{'\xa6','\xb3'},{'\xcc','\xd2'},{'\xaa','\x42'},
    {'\x9a','\xd7'},{'\xaa','\x41'},{'\x90','\xdb'},{'\xce','\xf9'},{'\xce','\xfa'},
    {'\x00','\x00'},{'\xd1','\xd7'},{'\xd1','\xd8'},{'\xae','\xd2'},{'\xae','\xd3'},
    {'\x90','\xdc'},{'\xae','\xd4'},{'\xd5','\xaf'},{'\x9a','\xd8'},{'\x00','\x00'},
    {'\xb1','\xe6'},{'\x00','\x00'},{'\xb4','\xc2'},{'\xfc','\x64'},{'\xb4','\xc1'},
    {'\xdd','\xc8'},{'\xdf','\x7a'},{'\xe1','\xfb'},{'\xe9','\xbd'},{'\x00','\x00'},
    {'\xfe','\x5e'},{'\xc2','\x61'},{'\xc4','\x67'},{'\xa4','\xec'},{'\x91','\xd1'},
    {'\xa5','\xbc'},{'\xa5','\xbd'},{'\xa5','\xbb'},{'\xa5','\xbe'},{'\xa5','\xba'},
    {'\x84','\x7b'},{'\x00','\x00'},{'\xa6','\xb6'},{'\x00','\x00'},{'\xc9','\xf6'},
    {'\xa6','\xb5'},{'\xa6','\xb7'},{'\x95','\x7c'},{'\x90','\xdd'},{'\xc9','\xf1'},
    {'\xc9','\xf0'},{'\xc9','\xf3'},{'\xc9','\xf2'},{'\xc9','\xf5'},{'\xa6','\xb4'},
    {'\xc9','\xef'},{'\xc9','\xf4'},{'\x84','\x59'},{'\x94','\x78'},{'\x8b','\x59'},
    {'\x8c','\xd0'},{'\x9a','\xd9'},{'\xca','\xfd'},{'\xa7','\xfd'},{'\xca','\xfe'},
    {'\xcb','\x43'},{'\xa7','\xfc'},{'\x00','\x00'},{'\xcb','\x47'},{'\xcb','\x42'},
    {'\xcb','\x45'},{'\xa7','\xf5'},{'\xa7','\xf6'},{'\xa7','\xf7'},{'\xa7','\xf8'},
    {'\x00','\x00'},{'\xa8','\x40'},{'\x00','\x00'},{'\xcb','\x41'},{'\xa7','\xfa'},
    {'\xa8','\x41'},{'\x00','\x00'},{'\xcb','\x40'},{'\xcb','\x46'},{'\x00','\x00'},
    {'\xa7','\xf9'},{'\xcb','\x44'},{'\xa7','\xfb'},{'\xa7','\xf4'},{'\xa7','\xfe'},
    {'\x84','\x57'},{'\x94','\x5c'},{'\x94','\x79'},{'\x90','\xde'},{'\x83','\x53'},
    {'\x90','\xdf'},{'\xfb','\xa6'},{'\x85','\xd4'},{'\x8e','\x72'},{'\xaa','\x57'},
    {'\x9a','\xda'},{'\xcc','\xd4'},{'\xaa','\x43'},{'\x9d','\x72'},{'\xaa','\x4d'},
    {'\xaa','\x4e'},{'\xaa','\x46'},{'\xaa','\x58'},{'\xaa','\x48'},{'\xcc','\xdc'},
    {'\xaa','\x53'},{'\xcc','\xd7'},{'\xaa','\x49'},{'\xcc','\xe6'},{'\xcc','\xe7'},
    {'\xcc','\xdf'},{'\xcc','\xd8'},{'\xaa','\x56'},{'\xcc','\xe4'},{'\xaa','\x51'},
    {'\xaa','\x4f'},{'\x00','\x00'},{'\xcc','\xe5'},{'\x00','\x00'},{'\xcc','\xe3'},
    {'\xcc','\xdb'},{'\xcc','\xd3'},{'\xcc','\xda'},{'\xaa','\x4a'},{'\x00','\x00'},
    {'\xaa','\x50'},{'\x00','\x00'},{'\xaa','\x44'},{'\xcc','\xde'},{'\xcc','\xdd'},
    {'\xcc','\xd5'},{'\x9a','\xdb'},{'\xaa','\x52'},{'\xcc','\xe1'},{'\xcc','\xd6'},
    {'\xaa','\x55'},{'\xcc','\xe8'},{'\xaa','\x45'},{'\x00','\x00'},{'\xaa','\x4c'},
    {'\xcc','\xd9'},{'\xcc','\xe2'},{'\xaa','\x54'},{'\x00','\x00'},{'\xaa','\x47'},
    {'\xaa','\x4b'},{'\x87','\xe5'},{'\xcc','\xe0'},{'\x94','\xfd'},{'\x94','\x7a'},
    {'\x87','\xe0'},{'\x84','\xe5'},{'\x9a','\xdc'},{'\x8f','\xdc'},{'\x90','\xe0'},
    {'\x90','\xe1'},{'\x8d','\xdf'},{'\x90','\xe2'},{'\x86','\xd2'},{'\x85','\xd6'},
    {'\xfc','\x66'},{'\x84','\x58'},{'\xcf','\x5b'},{'\xac','\x5c'},{'\xac','\x69'},
    {'\x95','\x45'},{'\xcf','\x56'},{'\xcf','\x4c'},{'\xac','\x62'},{'\xcf','\x4a'},
    {'\xac','\x5b'},{'\xcf','\x45'},{'\xac','\x65'},{'\xcf','\x52'},{'\xce','\xfe'},
    {'\xcf','\x41'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9a','\xdd'},
    {'\xcf','\x44'},{'\xce','\xfb'},{'\xcf','\x51'},{'\xcf','\x61'},{'\xac','\x60'},
    {'\xcf','\x46'},{'\xcf','\x58'},{'\x00','\x00'},{'\xce','\xfd'},{'\xcf','\x5f'},
    {'\xcf','\x60'},{'\xcf','\x63'},{'\xcf','\x5a'},{'\xcf','\x4b'},{'\xcf','\x53'},
    {'\xac','\x66'},{'\xac','\x59'},{'\xac','\x61'},{'\xac','\x6d'},{'\xac','\x56'},
    {'\xac','\x58'},{'\x00','\x00'},{'\x9a','\xde'},{'\x9a','\xdf'},{'\xcf','\x43'},
    {'\xac','\x6a'},{'\xac','\x63'},{'\xcf','\x5d'},{'\xcf','\x40'},{'\xac','\x6c'},
    {'\xac','\x67'},{'\xcf','\x49'},{'\x8a','\xce'},{'\x00','\x00'},{'\xac','\x6b'},
    {'\xcf','\x50'},{'\xcf','\x48'},{'\xac','\x64'},{'\xcf','\x5c'},{'\xcf','\x54'},
    {'\x00','\x00'},{'\xac','\x5e'},{'\xcf','\x62'},{'\xcf','\x47'},{'\xac','\x5a'},
    {'\xcf','\x59'},{'\xcf','\x4f'},{'\xac','\x5f'},{'\xcf','\x55'},{'\xac','\x57'},
    {'\xce','\xfc'},{'\xac','\x68'},{'\xae','\xe3'},{'\xac','\x5d'},{'\xcf','\x4e'},
    {'\xcf','\x4d'},{'\xcf','\x42'},{'\xfc','\x67'},{'\xcf','\x5e'},{'\x90','\xe3'},
    {'\xcf','\x57'},{'\x90','\xe4'},{'\x94','\x5a'},{'\xac','\x55'},{'\x90','\xe5'},
    {'\x90','\xe6'},{'\x94','\x4d'},{'\x94','\x51'},{'\x92','\x48'},{'\x90','\xe7'},
    {'\x00','\x00'},{'\x87','\xe1'},{'\x84','\xe7'},{'\x89','\xe6'},{'\x8f','\xdb'},
    {'\x84','\xe6'},{'\x8f','\xdd'},{'\x9a','\xe1'},{'\x8f','\xba'},{'\x8c','\x77'},
    {'\x9a','\xe2'},{'\x88','\xeb'},{'\xd1','\xec'},{'\xae','\xea'},{'\xd1','\xed'},
    {'\x00','\x00'},{'\xd1','\xe1'},{'\xae','\xdf'},{'\xae','\xeb'},{'\x00','\x00'},
    {'\xd1','\xda'},{'\x9a','\xe3'},{'\xd1','\xe3'},{'\xd1','\xeb'},{'\x90','\xe8'},
    {'\xd1','\xd9'},{'\xd1','\xf4'},{'\xae','\xd5'},{'\xfe','\x45'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd1','\xf3'},{'\xd1','\xee'},{'\x00','\x00'},{'\xd1','\xef'},
    {'\xae','\xdd'},{'\xae','\xe8'},{'\xd1','\xe5'},{'\x00','\x00'},{'\xd1','\xe6'},
    {'\xd1','\xf0'},{'\xd1','\xe7'},{'\x00','\x00'},{'\xd1','\xe2'},{'\xd1','\xdc'},
    {'\xd1','\xdd'},{'\xd1','\xea'},{'\xd1','\xe4'},{'\x9a','\xe4'},{'\x87','\xde'},
    {'\xae','\xd6'},{'\xae','\xda'},{'\xd1','\xf2'},{'\xd1','\xde'},{'\xae','\xe6'},
    {'\xae','\xe2'},{'\x90','\x6a'},{'\x00','\x00'},{'\xae','\xe5'},{'\xae','\xec'},
    {'\xae','\xdb'},{'\xae','\xe7'},{'\xd1','\xe9'},{'\xae','\xe9'},{'\xae','\xd8'},
    {'\x9a','\xe5'},{'\xae','\xd7'},{'\xd1','\xdb'},{'\x90','\xe9'},{'\xd1','\xdf'},
    {'\xae','\xe0'},{'\xd1','\xf1'},{'\xd1','\xe8'},{'\xd1','\xe0'},{'\xae','\xe4'},
    {'\xae','\xe1'},{'\x90','\xea'},{'\xae','\xd9'},{'\xae','\xdc'},{'\x90','\xeb'},
    {'\x9a','\xe6'},{'\x00','\x00'},{'\x00','\x00'},{'\x90','\xec'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x92','\x51'},{'\x82','\x7c'},{'\x00','\x00'},{'\x92','\xcc'},
    {'\x8d','\xde'},{'\x88','\xef'},{'\x85','\xd5'},{'\x89','\xe3'},{'\x8e','\x71'},
    {'\x88','\xed'},{'\x88','\xe9'},{'\x89','\xe5'},{'\x87','\xe3'},{'\x87','\xdf'},
    {'\x00','\x00'},{'\xd5','\xc4'},{'\x00','\x00'},{'\xd5','\xb4'},{'\xd5','\xb5'},
    {'\xd5','\xb9'},{'\x00','\x00'},{'\xd5','\xc8'},{'\xd5','\xc5'},{'\x00','\x00'},
    {'\xd5','\xbe'},{'\xd5','\xbd'},{'\xb1','\xed'},{'\xd5','\xc1'},{'\xd5','\xd0'},
    {'\xd5','\xb0'},{'\x00','\x00'},{'\xd5','\xd1'},{'\xd5','\xc3'},{'\xd5','\xd5'},
    {'\xd5','\xc9'},{'\xb1','\xec'},{'\xd5','\xc7'},{'\xb1','\xe7'},{'\xb1','\xfc'},
    {'\xb1','\xf2'},{'\x9a','\xe7'},{'\xb1','\xf6'},{'\xb1','\xf5'},{'\xd5','\xb1'},
    {'\x9a','\xe8'},{'\xd5','\xce'},{'\xd5','\xd4'},{'\xd5','\xcc'},{'\xd5','\xd3'},
    {'\x90','\xed'},{'\x00','\x00'},{'\xd5','\xc0'},{'\xd5','\xb2'},{'\xd5','\xd2'},
    {'\xd5','\xc2'},{'\xb1','\xea'},{'\xb1','\xf7'},{'\x00','\x00'},{'\xd5','\xcb'},
    {'\xb1','\xf0'},{'\xfb','\x58'},{'\x00','\x00'},{'\x00','\x00'},{'\xd5','\xca'},
    {'\xd5','\xb3'},{'\xb1','\xf8'},{'\x00','\x00'},{'\xb1','\xfa'},{'\xd5','\xcd'},
    {'\xb1','\xfb'},{'\xb1','\xe9'},{'\xd5','\xba'},{'\xd5','\xcf'},{'\x00','\x00'},
    {'\x86','\xbb'},{'\xb1','\xef'},{'\xb1','\xf9'},{'\xd5','\xbc'},{'\xd5','\xc6'},
    {'\xd5','\xb7'},{'\xd5','\xbb'},{'\xb1','\xf4'},{'\xd5','\xb6'},{'\xb1','\xe8'},
    {'\xb1','\xf1'},{'\xb1','\xee'},{'\xd5','\xbf'},{'\xae','\xde'},{'\xd9','\xc0'},
    {'\xb1','\xeb'},{'\xfc','\x68'},{'\x00','\x00'},{'\x00','\x00'},{'\x90','\xee'},
    {'\x94','\x7b'},{'\x00','\x00'},{'\x82','\x6f'},{'\x9a','\xe9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x89','\xe4'},{'\x00','\x00'},{'\x8c','\x78'},{'\x9a','\xea'},
    {'\xb1','\xf3'},{'\x9a','\xeb'},{'\xd9','\xc3'},{'\xd9','\xd9'},{'\xd9','\xce'},
    {'\xb4','\xd6'},{'\xfc','\x6c'},{'\xb4','\xd1'},{'\xd9','\xbd'},{'\xb4','\xd2'},
    {'\xd9','\xcd'},{'\x90','\xef'},{'\xd9','\xc6'},{'\xd9','\xd3'},{'\xb4','\xce'},
    {'\xd9','\xab'},{'\xd9','\xd5'},{'\xb4','\xc4'},{'\xd9','\xb3'},{'\xb4','\xc7'},
    {'\xb4','\xc6'},{'\x00','\x00'},{'\xb4','\xd7'},{'\x00','\x00'},{'\xd9','\xad'},
    {'\xd9','\xcf'},{'\xd9','\xd0'},{'\xb4','\xc9'},{'\xb4','\xc5'},{'\xd9','\xbb'},
    {'\x00','\x00'},{'\xb4','\xd0'},{'\xd9','\xb6'},{'\x00','\x00'},{'\xd9','\xd1'},
    {'\xb4','\xcc'},{'\xd9','\xc9'},{'\xd9','\xd6'},{'\xd9','\xb0'},{'\xd9','\xb5'},
    {'\xd9','\xaf'},{'\x00','\x00'},{'\xb4','\xcb'},{'\xd9','\xc2'},{'\xdd','\xde'},
    {'\xd9','\xb1'},{'\xb4','\xcf'},{'\xd9','\xba'},{'\xd9','\xd2'},{'\xb4','\xca'},
    {'\xd9','\xb7'},{'\xd9','\xb4'},{'\xd9','\xc5'},{'\xb4','\xcd'},{'\xb4','\xc3'},
    {'\xb4','\xd9'},{'\xd9','\xc8'},{'\xd9','\xc7'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xfc','\x6b'},{'\xfc','\x6a'},{'\x9a','\xec'},{'\x9a','\xed'},{'\xd9','\xac'},
    {'\xb4','\xc8'},{'\xd9','\xd4'},{'\xd9','\xbc'},{'\xd9','\xbe'},{'\x9a','\xee'},
    {'\xd9','\xcb'},{'\xd9','\xca'},{'\xd9','\xaa'},{'\xb4','\xd3'},{'\xb4','\xd5'},
    {'\xd9','\xb2'},{'\xd9','\xb9'},{'\xd9','\xc1'},{'\xb4','\xd4'},{'\xd9','\xb8'},
    {'\xd9','\xc4'},{'\xd9','\xd7'},{'\x00','\x00'},{'\xd9','\xcc'},{'\x9a','\xef'},
    {'\x94','\x49'},{'\xfe','\x4f'},{'\x94','\x41'},{'\x92','\xb6'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8b','\x79'},{'\x8e','\xb8'},{'\x94','\xa2'},{'\x90','\xf3'},
    {'\x94','\xa1'},{'\x90','\x6b'},{'\xd9','\xd8'},{'\x90','\xf4'},{'\x00','\x00'},
    {'\x94','\x7d'},{'\x00','\x00'},{'\xd9','\xae'},{'\x00','\x00'},{'\xfc','\x69'},
    {'\x88','\xec'},{'\x00','\x00'},{'\xdd','\xf2'},{'\xb7','\xa6'},{'\x00','\x00'},
    {'\xdd','\xf0'},{'\xdd','\xdb'},{'\xdd','\xe0'},{'\xdd','\xd9'},{'\x90','\xfd'},
    {'\xdd','\xec'},{'\xdd','\xcb'},{'\xdd','\xd2'},{'\x00','\x00'},{'\xdd','\xea'},
    {'\xdd','\xf4'},{'\xdd','\xdc'},{'\xfc','\x6f'},{'\xdd','\xcf'},{'\xdd','\xe2'},
    {'\xdd','\xe7'},{'\xdd','\xd3'},{'\x9a','\xf0'},{'\xdd','\xe4'},{'\xdd','\xd0'},
    {'\x9a','\xf1'},{'\x00','\x00'},{'\xdd','\xd7'},{'\xdd','\xd8'},{'\xb7','\xa8'},
    {'\xdd','\xeb'},{'\xdd','\xe9'},{'\x00','\x00'},{'\xdd','\xcc'},{'\xdd','\xee'},
    {'\x00','\x00'},{'\xdd','\xef'},{'\xdd','\xf1'},{'\xb7','\xac'},{'\xb7','\xa4'},
    {'\x82','\x6c'},{'\xd5','\xb8'},{'\xdd','\xd4'},{'\xdd','\xe6'},{'\xdd','\xd5'},
    {'\xb7','\xa1'},{'\xb7','\xb1'},{'\xdd','\xed'},{'\xb7','\xaf'},{'\xb7','\xab'},
    {'\xdd','\xca'},{'\xb7','\xa3'},{'\x90','\xfe'},{'\xdd','\xcd'},{'\xb7','\xb0'},
    {'\x9a','\xf2'},{'\xdd','\xdd'},{'\xdd','\xc9'},{'\x9a','\xf3'},{'\xb7','\xa9'},
    {'\xdd','\xe1'},{'\xdd','\xd1'},{'\xb7','\xaa'},{'\xdd','\xda'},{'\xb7','\x7e'},
    {'\xb4','\xd8'},{'\xdd','\xe3'},{'\xd9','\xbf'},{'\xdd','\xce'},{'\x9a','\xf4'},
    {'\xfc','\x6d'},{'\xdd','\xe8'},{'\xb7','\xa5'},{'\xdd','\xe5'},{'\xb7','\xa2'},
    {'\xdd','\xdf'},{'\xb7','\xad'},{'\xdd','\xd6'},{'\xdd','\xf3'},{'\x87','\xe2'},
    {'\x92','\x62'},{'\x94','\xa3'},{'\x00','\x00'},{'\xfc','\x6e'},{'\x94','\xa4'},
    {'\xb7','\xa7'},{'\xde','\xc6'},{'\x8d','\x6e'},{'\x9a','\xf5'},{'\xb7','\xae'},
    {'\x8b','\xf9'},{'\x8b','\x7a'},{'\x90','\x40'},{'\x94','\x45'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe2','\x4a'},{'\xe2','\x48'},{'\x00','\x00'},{'\xe2','\x5e'},
    {'\xe2','\x46'},{'\x00','\x00'},{'\xe2','\x58'},{'\xb7','\x7d'},{'\xba','\x5f'},
    {'\xe2','\x42'},{'\xe2','\x5d'},{'\x95','\x67'},{'\xe2','\x47'},{'\xe2','\x55'},
    {'\xba','\x64'},{'\xba','\x5d'},{'\x00','\x00'},{'\xe2','\x5b'},{'\x9a','\xf6'},
    {'\xe2','\x40'},{'\xe2','\x5a'},{'\x9a','\xf7'},{'\xba','\x6f'},{'\xe2','\x51'},
    {'\xe2','\x61'},{'\xba','\x6d'},{'\xe2','\x49'},{'\xba','\x5e'},{'\xe2','\x4b'},
    {'\xe2','\x59'},{'\xba','\x67'},{'\xe2','\x44'},{'\xba','\x6b'},{'\xba','\x61'},
    {'\xe2','\x4d'},{'\xe2','\x43'},{'\xe1','\xfc'},{'\xfc','\x71'},{'\xe2','\x57'},
    {'\xba','\x68'},{'\xe2','\x60'},{'\xe1','\xfd'},{'\xba','\x65'},{'\x00','\x00'},
    {'\xe2','\x53'},{'\x00','\x00'},{'\xba','\x66'},{'\xe2','\x45'},{'\xe2','\x50'},
    {'\xe2','\x4c'},{'\xe2','\x4e'},{'\xfc','\x72'},{'\xba','\x60'},{'\xe2','\x5f'},
    {'\xba','\x6e'},{'\xe2','\x4f'},{'\x00','\x00'},{'\xe2','\x62'},{'\x91','\xee'},
    {'\x00','\x00'},{'\xe1','\xfe'},{'\xe2','\x54'},{'\xba','\x63'},{'\xba','\x6c'},
    {'\xba','\x6a'},{'\xe2','\x41'},{'\xe2','\x56'},{'\xba','\x69'},{'\x9a','\xf8'},
    {'\x00','\x00'},{'\xba','\x62'},{'\xe2','\x52'},{'\x9a','\xf9'},{'\x9a','\xfa'},
    {'\x00','\x00'},{'\x93','\xdb'},{'\xe2','\x5c'},{'\x00','\x00'},{'\x8a','\xcd'},
    {'\x00','\x00'},{'\x94','\xa5'},{'\x96','\x7d'},{'\x8a','\xcb'},{'\x8f','\xb9'},
    {'\x9b','\x41'},{'\xe5','\xd5'},{'\x00','\x00'},{'\xe5','\xd1'},{'\xe5','\xcd'},
    {'\xe5','\xe1'},{'\xe5','\xde'},{'\xbc','\xcd'},{'\xfc','\x75'},{'\x00','\x00'},
    {'\xe5','\xe5'},{'\xe5','\xd4'},{'\xbc','\xd8'},{'\xe5','\xdb'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe5','\xd0'},{'\xe5','\xda'},{'\xbc','\xd5'},{'\xe5','\xee'},
    {'\x00','\x00'},{'\xe5','\xeb'},{'\xe5','\xdd'},{'\xe5','\xce'},{'\x96','\x7e'},
    {'\xfc','\x74'},{'\xe5','\xe2'},{'\xe5','\xe4'},{'\xbc','\xd1'},{'\xe5','\xd8'},
    {'\xe5','\xd3'},{'\xe5','\xca'},{'\xbc','\xce'},{'\xbc','\xd6'},{'\x9b','\x42'},
    {'\xe5','\xe7'},{'\xbc','\xd7'},{'\xe5','\xcb'},{'\xe5','\xed'},{'\xe5','\xe0'},
    {'\xe5','\xe6'},{'\xbc','\xd4'},{'\xfe','\x54'},{'\x96','\xce'},{'\xe5','\xe3'},
    {'\x00','\x00'},{'\xe5','\xea'},{'\x00','\x00'},{'\xbc','\xd9'},{'\x96','\xeb'},
    {'\xbc','\xd3'},{'\xe5','\xdc'},{'\xe5','\xcf'},{'\xe5','\xef'},{'\xe5','\xcc'},
    {'\xe5','\xe8'},{'\xbc','\xd0'},{'\x9b','\x43'},{'\xe5','\xd6'},{'\x9b','\x44'},
    {'\xe5','\xd7'},{'\xbc','\xcf'},{'\xbc','\xcc'},{'\xe5','\xd2'},{'\xbc','\xd2'},
    {'\x96','\xec'},{'\xbc','\xcb'},{'\x00','\x00'},{'\xe5','\xe9'},{'\xe5','\xec'},
    {'\xe5','\xd9'},{'\xe9','\xca'},{'\x92','\xb7'},{'\x88','\xea'},{'\x94','\x40'},
    {'\x9b','\x45'},{'\x9b','\x46'},{'\x94','\xa6'},{'\x89','\xe7'},{'\x96','\xed'},
    {'\x8c','\x76'},{'\xe9','\xc2'},{'\x9b','\x47'},{'\xe9','\xbe'},{'\xbe','\xf6'},
    {'\x96','\xee'},{'\x00','\x00'},{'\xbe','\xeb'},{'\xbe','\xf0'},{'\xbe','\xec'},
    {'\xe9','\xcc'},{'\xe9','\xd7'},{'\xbe','\xea'},{'\xe9','\xc4'},{'\xe9','\xcd'},
    {'\xe5','\xdf'},{'\xe9','\xce'},{'\x00','\x00'},{'\x9b','\x48'},{'\xbe','\xf1'},
    {'\x9b','\x49'},{'\xe9','\xdd'},{'\xbe','\xf5'},{'\xbe','\xf8'},{'\xe9','\xc0'},
    {'\x00','\x00'},{'\xbe','\xf4'},{'\x9b','\x4a'},{'\xe9','\xdb'},{'\xe9','\xdc'},
    {'\xe9','\xd2'},{'\xe9','\xd1'},{'\xe9','\xc9'},{'\xfc','\x77'},{'\x9b','\x4b'},
    {'\xe9','\xd3'},{'\xe9','\xda'},{'\xe9','\xd9'},{'\x9b','\x4c'},{'\xbe','\xef'},
    {'\xbe','\xed'},{'\xe9','\xcb'},{'\xe9','\xc8'},{'\x00','\x00'},{'\xe9','\xc5'},
    {'\xe9','\xd8'},{'\xbe','\xf7'},{'\xe9','\xd6'},{'\xbe','\xf3'},{'\xbe','\xf2'},
    {'\x9b','\x4d'},{'\xe9','\xd0'},{'\x96','\xef'},{'\xe9','\xbf'},{'\xe9','\xc1'},
    {'\xe9','\xc3'},{'\xe9','\xd5'},{'\xe9','\xcf'},{'\xbe','\xee'},{'\x00','\x00'},
    {'\xe9','\xc6'},{'\x00','\x00'},{'\xe9','\xd4'},{'\x00','\x00'},{'\x8b','\x78'},
    {'\x94','\xa7'},{'\x96','\xf8'},{'\x9b','\x4e'},{'\x00','\x00'},{'\xe9','\xc7'},
    {'\x00','\x00'},{'\x96','\xf9'},{'\x8b','\x7b'},{'\x94','\x7e'},{'\x00','\x00'},
    {'\x96','\xfc'},{'\x00','\x00'},{'\xc0','\xcf'},{'\xed','\x45'},{'\xc0','\xc8'},
    {'\xec','\xf5'},{'\x9b','\x4f'},{'\xed','\x41'},{'\xc0','\xca'},{'\xed','\x48'},
    {'\x00','\x00'},{'\xec','\xfc'},{'\x00','\x00'},{'\xec','\xf7'},{'\x9b','\x50'},
    {'\x00','\x00'},{'\xed','\x49'},{'\xec','\xf3'},{'\xec','\xfe'},{'\x9b','\x51'},
    {'\xc0','\xd1'},{'\xed','\x44'},{'\xed','\x4a'},{'\xec','\xfd'},{'\xc0','\xc9'},
    {'\xed','\x40'},{'\xec','\xf4'},{'\xc0','\xd0'},{'\x00','\x00'},{'\x9b','\x52'},
    {'\xed','\x47'},{'\xec','\xf9'},{'\xc0','\xcc'},{'\xfc','\x78'},{'\xec','\xfb'},
    {'\xec','\xf8'},{'\xc0','\xd2'},{'\xec','\xfa'},{'\xc0','\xcb'},{'\xc0','\xce'},
    {'\xed','\x43'},{'\xec','\xf6'},{'\xed','\x46'},{'\x9b','\x53'},{'\xed','\x42'},
    {'\x96','\xfd'},{'\x96','\xfe'},{'\x99','\xfe'},{'\xc2','\x63'},{'\xef','\xe7'},
    {'\xc2','\x68'},{'\xc2','\x69'},{'\x00','\x00'},{'\x9b','\x54'},{'\xfc','\x76'},
    {'\xc2','\x62'},{'\xef','\xe6'},{'\x9b','\x55'},{'\xef','\xe3'},{'\xef','\xe4'},
    {'\xc2','\x66'},{'\xef','\xde'},{'\xef','\xe2'},{'\xc2','\x65'},{'\x00','\x00'},
    {'\xef','\xdf'},{'\x9b','\x56'},{'\x00','\x00'},{'\x00','\x00'},{'\x9a','\xfe'},
    {'\xc2','\x67'},{'\xc2','\x64'},{'\x00','\x00'},{'\xef','\xdd'},{'\xef','\xe1'},
    {'\xef','\xe5'},{'\x95','\xe3'},{'\x9b','\x57'},{'\xfb','\xdc'},{'\xf2','\x51'},
    {'\xf2','\x4e'},{'\xf2','\x57'},{'\x00','\x00'},{'\xf2','\x56'},{'\xf2','\x54'},
    {'\xf2','\x4f'},{'\x00','\x00'},{'\xc3','\x72'},{'\x9b','\x58'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9b','\x59'},{'\xf2','\x50'},{'\xc3','\x71'},
    {'\xc0','\xcd'},{'\xf2','\x53'},{'\xc3','\x70'},{'\xf2','\x58'},{'\xf2','\x52'},
    {'\xf2','\x4d'},{'\xef','\xe0'},{'\x9c','\xf9'},{'\x00','\x00'},{'\x9d','\xe1'},
    {'\xc3','\x6f'},{'\x00','\x00'},{'\xf2','\x4c'},{'\xf4','\x56'},{'\x00','\x00'},
    {'\xf4','\x55'},{'\xf2','\x55'},{'\xc4','\x68'},{'\x00','\x00'},{'\xf4','\x59'},
    {'\xf4','\x5a'},{'\xf4','\x54'},{'\xf4','\x58'},{'\x00','\x00'},{'\xf4','\x53'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9b','\x5a'},{'\x00','\x00'},{'\xf5','\xd1'},
    {'\xf4','\x57'},{'\xc4','\xe7'},{'\xc4','\xe5'},{'\xf5','\xcf'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf5','\xd2'},{'\x00','\x00'},{'\xf5','\xce'},
    {'\xf5','\xd0'},{'\xc4','\xe6'},{'\x9d','\xfe'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf6','\xe5'},{'\xf6','\xe6'},{'\xc5','\x76'},{'\xf6','\xe4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf7','\xe2'},{'\xc5','\xcf'},{'\xf7','\xe0'},
    {'\xf7','\xe1'},{'\xf8','\xac'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\x56'},
    {'\xf8','\xf3'},{'\xf8','\xf1'},{'\xf8','\xf2'},{'\xf8','\xf4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfc','\x79'},{'\xf9','\xbb'},{'\x94','\xa8'},{'\xa4','\xed'},
    {'\xa6','\xb8'},{'\x8c','\xd1'},{'\xaa','\x59'},{'\x8a','\xcf'},{'\xcc','\xe9'},
    {'\x00','\x00'},{'\x87','\xe6'},{'\xcf','\x64'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd1','\xf5'},{'\xd1','\xf7'},{'\x00','\x00'},{'\xd1','\xf6'},
    {'\x00','\x00'},{'\xd1','\xf8'},{'\xb1','\xfd'},{'\xd5','\xd7'},{'\xd1','\xf9'},
    {'\x95','\xb9'},{'\xd5','\xd6'},{'\xd5','\xd8'},{'\xd5','\xd9'},{'\xd9','\xda'},
    {'\xb4','\xdb'},{'\xd9','\xdb'},{'\xd9','\xdd'},{'\xb4','\xdc'},{'\xb4','\xda'},
    {'\xd9','\xdc'},{'\x00','\x00'},{'\xdd','\xfa'},{'\xdd','\xf8'},{'\xdd','\xf7'},
    {'\x00','\x00'},{'\xdd','\xf6'},{'\xdd','\xf5'},{'\xb7','\xb2'},{'\xdd','\xf9'},
    {'\xba','\x70'},{'\xe2','\x63'},{'\xe2','\x65'},{'\xba','\x71'},{'\xe2','\x64'},
    {'\xbc','\xdb'},{'\x00','\x00'},{'\xbc','\xda'},{'\xe5','\xf0'},{'\xfc','\x7a'},
    {'\x92','\x6c'},{'\xe9','\xdf'},{'\xe9','\xde'},{'\xe9','\xe0'},{'\x9b','\x5b'},
    {'\x00','\x00'},{'\xbe','\xf9'},{'\x00','\x00'},{'\xed','\x4b'},{'\xc0','\xd3'},
    {'\x00','\x00'},{'\xef','\xe8'},{'\xc2','\x6a'},{'\xf2','\x59'},{'\xc5','\x77'},
    {'\xa4','\xee'},{'\xa5','\xbf'},{'\xa6','\xb9'},{'\xa8','\x42'},{'\xaa','\x5a'},
    {'\xaa','\x5b'},{'\x00','\x00'},{'\x93','\xc5'},{'\xac','\x6e'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd1','\xfa'},{'\x00','\x00'},{'\x92','\xd0'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xb7','\xb3'},{'\x92','\xc8'},{'\x93','\xf0'},{'\x00','\x00'},
    {'\xe6','\xd1'},{'\xbe','\xfa'},{'\xc2','\x6b'},{'\xa4','\xef'},{'\x9b','\x5c'},
    {'\xa6','\xba'},{'\x8c','\x79'},{'\x00','\x00'},{'\xcc','\xeb'},{'\xaa','\x5c'},
    {'\xcc','\xea'},{'\x9f','\x4e'},{'\xcf','\x65'},{'\xac','\x6f'},{'\xcf','\x66'},
    {'\x00','\x00'},{'\xac','\x70'},{'\x87','\xe7'},{'\xd1','\xfc'},{'\xae','\xee'},
    {'\xae','\xed'},{'\x92','\xcf'},{'\xd5','\xde'},{'\xd5','\xdc'},{'\xd5','\xdd'},
    {'\xd5','\xdb'},{'\x00','\x00'},{'\xd5','\xda'},{'\x8d','\xb5'},{'\x89','\xe8'},
    {'\xd9','\xde'},{'\xd9','\xe1'},{'\xb4','\xde'},{'\xd9','\xdf'},{'\xb4','\xdd'},
    {'\xd9','\xe0'},{'\x8e','\xe8'},{'\xdd','\xfb'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe2','\x66'},{'\xe2','\x67'},{'\xe2','\x68'},{'\x8a','\xd1'},{'\xe5','\xf3'},
    {'\xe5','\xf2'},{'\xbc','\xdc'},{'\xe5','\xf1'},{'\xe5','\xf4'},{'\xe9','\xe1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xe9','\xe2'},{'\xe9','\xe3'},{'\x00','\x00'},
    {'\xed','\x4c'},{'\xc0','\xd4'},{'\xc2','\x6c'},{'\xf2','\x5a'},{'\x9f','\x4f'},
    {'\xc4','\xe8'},{'\xc9','\x5f'},{'\x87','\xe8'},{'\xac','\x71'},{'\xcf','\x67'},
    {'\xae','\xef'},{'\x00','\x00'},{'\x00','\x00'},{'\xb1','\xfe'},{'\x92','\x5f'},
    {'\xb4','\xdf'},{'\xd9','\xe2'},{'\x00','\x00'},{'\xb7','\xb5'},{'\xb7','\xb4'},
    {'\x90','\xb5'},{'\x8a','\x75'},{'\xe2','\x69'},{'\xe2','\x6a'},{'\xbc','\xdd'},
    {'\xbc','\xde'},{'\xe9','\xe5'},{'\xe9','\xe4'},{'\xef','\xe9'},{'\xf7','\xe3'},
    {'\xa4','\xf0'},{'\xc9','\x60'},{'\xa5','\xc0'},{'\x93','\xd1'},{'\xa8','\x43'},
    {'\xcb','\x48'},{'\x00','\x00'},{'\xac','\x72'},{'\xb7','\xb6'},{'\xa4','\xf1'},
    {'\x84','\x65'},{'\xcf','\x68'},{'\xac','\x73'},{'\xcf','\x69'},{'\x89','\xe1'},
    {'\xc0','\xd5'},{'\xa4','\xf2'},{'\x9b','\x5d'},{'\x00','\x00'},{'\xcc','\xec'},
    {'\x94','\xa9'},{'\xcf','\x6a'},{'\x89','\xe9'},{'\xd2','\x42'},{'\xd2','\x41'},
    {'\xd1','\xfe'},{'\x00','\x00'},{'\xd1','\xfd'},{'\xd2','\x43'},{'\xd2','\x40'},
    {'\x00','\x00'},{'\xa0','\x62'},{'\xb2','\x40'},{'\xb2','\x41'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xb4','\xe0'},{'\xd9','\xe3'},{'\x00','\x00'},{'\xd9','\xe4'},
    {'\xd9','\xe5'},{'\x00','\x00'},{'\x8e','\xb9'},{'\x00','\x00'},{'\xde','\x41'},
    {'\xde','\x42'},{'\xde','\x40'},{'\xfc','\x7b'},{'\xdd','\xfd'},{'\xdd','\xfe'},
    {'\xb7','\xb7'},{'\xe2','\x6b'},{'\xe5','\xf7'},{'\xe5','\xf6'},{'\xe5','\xf5'},
    {'\xe5','\xf8'},{'\xe9','\xe7'},{'\xe9','\xe6'},{'\xbe','\xfb'},{'\xe9','\xe8'},
    {'\x8f','\xbb'},{'\xc0','\xd6'},{'\xed','\x4d'},{'\x00','\x00'},{'\xef','\xea'},
    {'\xf2','\x5b'},{'\xf6','\xe7'},{'\x00','\x00'},{'\xa4','\xf3'},{'\xa5','\xc2'},
    {'\xa5','\xc1'},{'\x00','\x00'},{'\xaa','\x5d'},{'\xc9','\x61'},{'\xc9','\x7e'},
    {'\xa6','\xbb'},{'\x92','\x6e'},{'\xc9','\xf7'},{'\xcb','\x49'},{'\xcb','\x4a'},
    {'\xaa','\x5e'},{'\x9b','\x5e'},{'\xcc','\xed'},{'\x00','\x00'},{'\xac','\x74'},
    {'\xcf','\x6b'},{'\xcf','\x6c'},{'\x84','\x5a'},{'\xae','\xf0'},{'\xae','\xf4'},
    {'\xd2','\x44'},{'\xae','\xf3'},{'\xae','\xf1'},{'\xae','\xf2'},{'\x84','\xec'},
    {'\xd5','\xdf'},{'\xb2','\x42'},{'\xb4','\xe3'},{'\x00','\x00'},{'\xb4','\xe1'},
    {'\xb4','\xe2'},{'\xd9','\xe6'},{'\x9b','\x5f'},{'\xa0','\x63'},{'\xba','\x72'},
    {'\xa4','\xf4'},{'\x9c','\xf3'},{'\xc9','\xa1'},{'\x95','\xeb'},{'\xa5','\xc3'},
    {'\xfe','\x40'},{'\x91','\xd2'},{'\xc9','\xa4'},{'\x00','\x00'},{'\xa0','\x64'},
    {'\xa5','\xc6'},{'\xc9','\xa3'},{'\xa5','\xc5'},{'\xa5','\xc4'},{'\xa8','\x44'},
    {'\xc9','\xa2'},{'\x00','\x00'},{'\x00','\x00'},{'\xc9','\xf8'},{'\x85','\xb9'},
    {'\x00','\x00'},{'\x86','\xd5'},{'\xc9','\xfc'},{'\xc9','\xfe'},{'\xca','\x40'},
    {'\xa6','\xc5'},{'\xa6','\xc6'},{'\xc9','\xfb'},{'\xa6','\xc1'},{'\x00','\x00'},
    {'\xc9','\xf9'},{'\x00','\x00'},{'\xc9','\xfd'},{'\xa6','\xc2'},{'\x00','\x00'},
    {'\xa6','\xbd'},{'\x9b','\x60'},{'\xa6','\xbe'},{'\x95','\xea'},{'\xa6','\xc4'},
    {'\xc9','\xfa'},{'\xa6','\xbc'},{'\xa8','\x45'},{'\xa6','\xbf'},{'\xa6','\xc0'},
    {'\xa6','\xc3'},{'\xa0','\x65'},{'\x00','\x00'},{'\x84','\xf1'},{'\xcb','\x5b'},
    {'\xcb','\x59'},{'\xcb','\x4c'},{'\xa8','\x51'},{'\xcb','\x53'},{'\xa8','\x4c'},
    {'\xcb','\x4d'},{'\x00','\x00'},{'\xcb','\x55'},{'\x9b','\x61'},{'\xcb','\x52'},
    {'\xa8','\x4f'},{'\xcb','\x51'},{'\xa8','\x56'},{'\xcb','\x5a'},{'\xa8','\x58'},
    {'\x9b','\x62'},{'\xa8','\x5a'},{'\x00','\x00'},{'\xcb','\x4b'},{'\x83','\x6e'},
    {'\xa8','\x4d'},{'\xcb','\x5c'},{'\x00','\x00'},{'\xa8','\x54'},{'\xa8','\x57'},
    {'\x9b','\x63'},{'\xcd','\x45'},{'\xa8','\x47'},{'\xa8','\x5e'},{'\xa8','\x55'},
    {'\xcb','\x4e'},{'\xa8','\x4a'},{'\xa8','\x59'},{'\xcb','\x56'},{'\xa8','\x48'},
    {'\xa8','\x49'},{'\xcd','\x43'},{'\xcb','\x4f'},{'\xa8','\x50'},{'\xa8','\x5b'},
    {'\xcb','\x5d'},{'\xcb','\x50'},{'\xa8','\x4e'},{'\x00','\x00'},{'\xa8','\x53'},
    {'\xcc','\xee'},{'\xa8','\x5c'},{'\xcb','\x57'},{'\xa8','\x52'},{'\x00','\x00'},
    {'\xa8','\x5d'},{'\xa8','\x46'},{'\xcb','\x54'},{'\xa8','\x4b'},{'\xcb','\x58'},
    {'\xcd','\x44'},{'\x00','\x00'},{'\x85','\xd8'},{'\x00','\x00'},{'\x95','\xca'},
    {'\x93','\x6b'},{'\x88','\xf4'},{'\x8e','\x75'},{'\x8b','\x7e'},{'\x84','\x5f'},
    {'\x85','\xdc'},{'\x00','\x00'},{'\x8d','\xe0'},{'\x86','\xdb'},{'\xaa','\x6a'},
    {'\xaa','\x7a'},{'\xcc','\xf5'},{'\xaa','\x71'},{'\x9b','\x64'},{'\xcd','\x4b'},
    {'\xaa','\x62'},{'\xa0','\x66'},{'\xaa','\x65'},{'\xcd','\x42'},{'\x00','\x00'},
    {'\xcc','\xf3'},{'\xcc','\xf7'},{'\xaa','\x6d'},{'\xaa','\x6f'},{'\xcc','\xfa'},
    {'\xaa','\x76'},{'\xaa','\x68'},{'\xaa','\x66'},{'\xaa','\x67'},{'\xaa','\x75'},
    {'\xcd','\x47'},{'\xaa','\x70'},{'\xcc','\xf9'},{'\xcc','\xfb'},{'\xaa','\x6e'},
    {'\xaa','\x73'},{'\xcc','\xfc'},{'\xcd','\x4a'},{'\x00','\x00'},{'\xac','\x75'},
    {'\xaa','\x79'},{'\x9b','\x65'},{'\xaa','\x63'},{'\xcd','\x49'},{'\xfc','\x7d'},
    {'\xcd','\x4d'},{'\xcc','\xf8'},{'\xcd','\x4f'},{'\xcd','\x40'},{'\xaa','\x6c'},
    {'\xcc','\xf4'},{'\xaa','\x6b'},{'\xaa','\x7d'},{'\xaa','\x72'},{'\x00','\x00'},
    {'\xcc','\xf2'},{'\xcf','\x75'},{'\xaa','\x78'},{'\xaa','\x7c'},{'\xcd','\x41'},
    {'\xcd','\x46'},{'\x9b','\x66'},{'\xaa','\x7e'},{'\xaa','\x77'},{'\xaa','\x69'},
    {'\xaa','\x5f'},{'\x00','\x00'},{'\xaa','\x64'},{'\x00','\x00'},{'\xcc','\xf6'},
    {'\xaa','\x60'},{'\xcd','\x4e'},{'\x84','\x5e'},{'\xcc','\xf0'},{'\xcc','\xef'},
    {'\xcc','\xfd'},{'\xcc','\xf1'},{'\xaa','\x7b'},{'\xae','\xf5'},{'\xaa','\x74'},
    {'\xcc','\xfe'},{'\xaa','\x61'},{'\x00','\x00'},{'\xac','\xa6'},{'\x8f','\x54'},
    {'\x8f','\xbc'},{'\x8b','\xa2'},{'\xcd','\x4c'},{'\x8f','\x77'},{'\x8a','\xd2'},
    {'\x87','\xea'},{'\x88','\xf2'},{'\x83','\xbd'},{'\x9b','\x67'},{'\xcf','\x7c'},
    {'\xcf','\xa1'},{'\x9b','\x68'},{'\xcf','\xa4'},{'\xcf','\x77'},{'\x9b','\x69'},
    {'\x9b','\x6a'},{'\xcf','\xa7'},{'\xcf','\xaa'},{'\xcf','\xac'},{'\xcf','\x74'},
    {'\xac','\x76'},{'\xac','\x7b'},{'\xd2','\x49'},{'\xac','\xad'},{'\xcf','\xa5'},
    {'\xcf','\xad'},{'\xcf','\x7b'},{'\xcf','\x73'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd2','\x64'},{'\xac','\x7e'},{'\xcf','\xa2'},{'\xcf','\x78'},
    {'\xcf','\x7a'},{'\xac','\xa5'},{'\x00','\x00'},{'\xcf','\x7d'},{'\xac','\x7d'},
    {'\xcf','\x70'},{'\xcf','\xa8'},{'\x00','\x00'},{'\xcf','\xab'},{'\x00','\x00'},
    {'\x95','\xb0'},{'\xac','\x7a'},{'\x9b','\x6b'},{'\xac','\xa8'},{'\xcf','\x6d'},
    {'\xac','\xaa'},{'\xac','\x78'},{'\xac','\xae'},{'\xcf','\xa9'},{'\xcf','\x6f'},
    {'\xac','\xab'},{'\xd2','\x5e'},{'\xcd','\x48'},{'\xac','\x7c'},{'\xac','\x77'},
    {'\xcf','\x76'},{'\xcf','\x6e'},{'\xac','\xac'},{'\xac','\xa4'},{'\xcf','\xa3'},
    {'\xac','\xa9'},{'\xac','\xa7'},{'\xcf','\x79'},{'\xac','\xa1'},{'\xcf','\x71'},
    {'\xac','\xa2'},{'\xac','\xa3'},{'\xcf','\x72'},{'\xcf','\xa6'},{'\xac','\x79'},
    {'\xcf','\x7e'},{'\x83','\xbe'},{'\x92','\xea'},{'\x93','\x48'},{'\x87','\xe9'},
    {'\x87','\xec'},{'\x8d','\xe1'},{'\x00','\x00'},{'\x88','\xf3'},{'\x84','\xf2'},
    {'\x00','\x00'},{'\x8e','\xe9'},{'\x89','\xec'},{'\x8a','\xd7'},{'\x00','\x00'},
    {'\x84','\xf3'},{'\x8e','\x74'},{'\x88','\xf1'},{'\x87','\xf0'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x9b','\x6c'},{'\xd2','\x4c'},{'\xae','\xfd'},{'\xaf','\x43'},
    {'\x9b','\x6d'},{'\x93','\xbd'},{'\x00','\x00'},{'\xd2','\x55'},{'\xd2','\x5b'},
    {'\xd2','\x57'},{'\xd2','\x4a'},{'\xd2','\x4d'},{'\xd2','\x46'},{'\xd2','\x47'},
    {'\xaf','\x4a'},{'\xae','\xfa'},{'\xd2','\x56'},{'\xd2','\x5f'},{'\xaf','\x45'},
    {'\xae','\xf6'},{'\x00','\x00'},{'\xaf','\x40'},{'\xd2','\x4e'},{'\xaf','\x42'},
    {'\xd2','\x4f'},{'\xd2','\x59'},{'\x9b','\x6e'},{'\xfb','\xa7'},{'\x00','\x00'},
    {'\xaf','\x44'},{'\xd2','\x68'},{'\xd2','\x48'},{'\xae','\xfc'},{'\xae','\xfb'},
    {'\xaf','\x48'},{'\xd2','\x45'},{'\xd2','\x66'},{'\xd2','\x5a'},{'\xd2','\x67'},
    {'\xd2','\x61'},{'\xd2','\x53'},{'\xd2','\x62'},{'\x9b','\x6f'},{'\xd2','\x5c'},
    {'\xd2','\x65'},{'\xd2','\x63'},{'\xaf','\x49'},{'\xd2','\x54'},{'\xae','\xf9'},
    {'\xae','\xf8'},{'\xaf','\x41'},{'\xaf','\x47'},{'\xd2','\x60'},{'\xaf','\x46'},
    {'\xd2','\x51'},{'\xb2','\x43'},{'\x9b','\x70'},{'\xd2','\x69'},{'\xd2','\x50'},
    {'\xd2','\x4b'},{'\xae','\xfe'},{'\xaf','\x4b'},{'\xae','\xf7'},{'\xfe','\x5c'},
    {'\xd2','\x58'},{'\xd2','\x5d'},{'\x93','\xe8'},{'\x00','\x00'},{'\x89','\xed'},
    {'\x82','\x71'},{'\x8e','\xbb'},{'\x8d','\xcf'},{'\x86','\xda'},{'\x8e','\xbd'},
    {'\x84','\xf0'},{'\x00','\x00'},{'\x84','\xf4'},{'\x86','\xde'},{'\x9b','\x71'},
    {'\x87','\xee'},{'\x87','\xef'},{'\x86','\xd9'},{'\x89','\xef'},{'\xb2','\x65'},
    {'\xd5','\xe1'},{'\xd5','\xe5'},{'\x00','\x00'},{'\xb2','\x52'},{'\xb2','\x50'},
    {'\x00','\x00'},{'\x9b','\x72'},{'\xb2','\x47'},{'\xd5','\xe3'},{'\xd5','\xe2'},
    {'\xb2','\x5b'},{'\x00','\x00'},{'\xd5','\xe8'},{'\xb2','\x55'},{'\xfc','\xa1'},
    {'\xd5','\xfa'},{'\xd6','\x47'},{'\xb2','\x44'},{'\xd5','\xf7'},{'\xd5','\xf0'},
    {'\xb2','\x67'},{'\xd5','\xe0'},{'\x00','\x00'},{'\xd5','\xfc'},{'\x00','\x00'},
    {'\xb2','\x64'},{'\xb2','\x58'},{'\xb2','\x63'},{'\xb2','\x4e'},{'\xd5','\xec'},
    {'\xd5','\xfe'},{'\xd5','\xf6'},{'\xb2','\x4f'},{'\xb2','\x49'},{'\xd6','\x45'},
    {'\x00','\x00'},{'\xd5','\xfd'},{'\xd6','\x40'},{'\xb2','\x51'},{'\xb2','\x59'},
    {'\xd6','\x42'},{'\xd5','\xea'},{'\xd5','\xfb'},{'\xd5','\xef'},{'\xd6','\x44'},
    {'\xb2','\x5e'},{'\xb2','\x46'},{'\xb2','\x5c'},{'\xd5','\xf4'},{'\xd5','\xf2'},
    {'\xd5','\xf3'},{'\xb2','\x53'},{'\xd5','\xee'},{'\xd5','\xed'},{'\xb2','\x48'},
    {'\xd5','\xe7'},{'\xd6','\x46'},{'\xb2','\x4a'},{'\xd5','\xf1'},{'\xb2','\x68'},
    {'\x00','\x00'},{'\xb2','\x62'},{'\xd5','\xe6'},{'\xb2','\x5f'},{'\xb2','\x5d'},
    {'\xb2','\x66'},{'\xd5','\xf8'},{'\xb2','\x61'},{'\xd2','\x52'},{'\xd5','\xf9'},
    {'\xb2','\x60'},{'\xd6','\x41'},{'\xb2','\x45'},{'\xd5','\xf5'},{'\xb2','\x57'},
    {'\xd5','\xe9'},{'\xb2','\x56'},{'\xa0','\x67'},{'\xb2','\x54'},{'\xb2','\x4c'},
    {'\xb2','\x4b'},{'\xd9','\xe7'},{'\xd6','\x43'},{'\x9b','\x73'},{'\x00','\x00'},
    {'\xd5','\xeb'},{'\x00','\x00'},{'\x9b','\x74'},{'\xd9','\xfc'},{'\x9b','\x75'},
    {'\xb2','\x4d'},{'\x00','\x00'},{'\x92','\x64'},{'\x92','\xc6'},{'\x92','\xe4'},
    {'\x84','\x5d'},{'\x92','\xdd'},{'\x8d','\xd0'},{'\x86','\xd4'},{'\x8a','\xd5'},
    {'\x9b','\x76'},{'\x86','\xd8'},{'\x88','\xf6'},{'\x00','\x00'},{'\x92','\xaa'},
    {'\x86','\xdc'},{'\x94','\xaa'},{'\x8a','\xd3'},{'\x86','\xdd'},{'\x9b','\x77'},
    {'\xb5','\x41'},{'\xb2','\x5a'},{'\xb4','\xee'},{'\xd9','\xf6'},{'\xb4','\xfc'},
    {'\x00','\x00'},{'\xd9','\xea'},{'\xb4','\xeb'},{'\xb4','\xe7'},{'\xda','\x49'},
    {'\xb4','\xed'},{'\xb4','\xf1'},{'\xb4','\xec'},{'\xb4','\xf5'},{'\xda','\x4d'},
    {'\xda','\x44'},{'\xa0','\x68'},{'\x9b','\x78'},{'\xd9','\xf1'},{'\xb4','\xfa'},
    {'\xb4','\xf4'},{'\xd9','\xfd'},{'\xb4','\xe4'},{'\xda','\x4a'},{'\xda','\x43'},
    {'\xb4','\xe8'},{'\xd9','\xf7'},{'\xb4','\xf7'},{'\xda','\x55'},{'\xda','\x56'},
    {'\x00','\x00'},{'\xb4','\xe5'},{'\xda','\x48'},{'\xb4','\xf9'},{'\xd9','\xfb'},
    {'\xd9','\xed'},{'\xd9','\xee'},{'\xb4','\xfd'},{'\xd9','\xf2'},{'\xd9','\xf9'},
    {'\xd9','\xf3'},{'\x00','\x00'},{'\xb4','\xfb'},{'\xb5','\x44'},{'\xd9','\xef'},
    {'\xd9','\xe8'},{'\xd9','\xe9'},{'\x00','\x00'},{'\xd9','\xeb'},{'\xb4','\xea'},
    {'\xd9','\xf8'},{'\x00','\x00'},{'\xb4','\xf8'},{'\xb5','\x42'},{'\xfc','\x7e'},
    {'\x9b','\x79'},{'\xd9','\xfa'},{'\xda','\x53'},{'\xda','\x4b'},{'\xb4','\xe6'},
    {'\xda','\x51'},{'\xb4','\xf2'},{'\x9d','\xcb'},{'\xb4','\xf0'},{'\x9b','\x7a'},
    {'\xda','\x57'},{'\xb4','\xef'},{'\xda','\x41'},{'\xd9','\xf4'},{'\xd9','\xfe'},
    {'\xb5','\x47'},{'\xda','\x45'},{'\xda','\x42'},{'\xd9','\xf0'},{'\xb5','\x43'},
    {'\xda','\x4f'},{'\xda','\x4c'},{'\xda','\x54'},{'\xb4','\xe9'},{'\xda','\x40'},
    {'\xb5','\x46'},{'\x00','\x00'},{'\xda','\x47'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb4','\xf3'},{'\xb4','\xf6'},{'\x00','\x00'},{'\xda','\x46'},{'\xb5','\x45'},
    {'\xd9','\xf5'},{'\xd5','\xe4'},{'\x00','\x00'},{'\xa0','\x69'},{'\xda','\x50'},
    {'\xda','\x4e'},{'\xda','\x52'},{'\x00','\x00'},{'\x00','\x00'},{'\x95','\xcb'},
    {'\x00','\x00'},{'\x8d','\x6f'},{'\x85','\xda'},{'\x93','\xd2'},{'\x00','\x00'},
    {'\xa0','\x6a'},{'\x87','\xed'},{'\x00','\x00'},{'\x8a','\xd6'},{'\xa0','\x6b'},
    {'\x00','\x00'},{'\xd9','\xec'},{'\xb5','\x40'},{'\x00','\x00'},{'\xfe','\x6a'},
    {'\x82','\x78'},{'\xde','\x61'},{'\xde','\x60'},{'\xde','\x46'},{'\xb7','\xbd'},
    {'\x00','\x00'},{'\xde','\x5f'},{'\xde','\x49'},{'\xde','\x4a'},{'\x00','\x00'},
    {'\xb7','\xc7'},{'\xde','\x68'},{'\xb7','\xc2'},{'\xde','\x5e'},{'\x9b','\x7b'},
    {'\xde','\x43'},{'\xb7','\xc8'},{'\xb7','\xbe'},{'\xde','\x52'},{'\xde','\x48'},
    {'\xde','\x4b'},{'\xde','\x63'},{'\xb7','\xb8'},{'\xde','\x6a'},{'\xde','\x62'},
    {'\xb7','\xc1'},{'\xde','\x57'},{'\xb7','\xcc'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb7','\xcb'},{'\xb7','\xc5'},{'\x00','\x00'},{'\x00','\x00'},{'\xde','\x69'},
    {'\xb7','\xb9'},{'\xde','\x55'},{'\xde','\x4c'},{'\xde','\x59'},{'\xde','\x65'},
    {'\xb7','\xcd'},{'\x9b','\x7c'},{'\xb7','\xbb'},{'\xde','\x54'},{'\x9b','\x7d'},
    {'\xde','\x4d'},{'\xb7','\xc4'},{'\xa0','\x6c'},{'\xb7','\xc3'},{'\xde','\x50'},
    {'\xde','\x5a'},{'\xde','\x64'},{'\xde','\x47'},{'\xde','\x51'},{'\xb7','\xbc'},
    {'\xde','\x5b'},{'\xb7','\xc9'},{'\xb7','\xc0'},{'\xde','\x4e'},{'\xb7','\xbf'},
    {'\xde','\x45'},{'\xde','\x53'},{'\xde','\x67'},{'\xb4','\xfe'},{'\xba','\xb0'},
    {'\xde','\x56'},{'\xe2','\x6c'},{'\xde','\x58'},{'\xde','\x66'},{'\xb7','\xc6'},
    {'\xde','\x4f'},{'\xb7','\xba'},{'\xb7','\xca'},{'\xbc','\xf0'},{'\xde','\x44'},
    {'\x8e','\xbe'},{'\xde','\x5d'},{'\x95','\x50'},{'\x86','\xd3'},{'\x9b','\x7e'},
    {'\xde','\x5c'},{'\x93','\x69'},{'\x86','\xd7'},{'\xa0','\x6d'},{'\x90','\x41'},
    {'\x86','\xd6'},{'\xa0','\x6e'},{'\x00','\x00'},{'\x8a','\xd4'},{'\x89','\xee'},
    {'\x8d','\x7b'},{'\x00','\x00'},{'\x89','\xeb'},{'\x8c','\xd2'},{'\x00','\x00'},
    {'\xe2','\xaa'},{'\xba','\xad'},{'\xe2','\x7d'},{'\xe2','\xa4'},{'\xba','\xa2'},
    {'\x00','\x00'},{'\xe2','\x6e'},{'\xba','\xaf'},{'\x00','\x00'},{'\xba','\x77'},
    {'\xe2','\x6d'},{'\xe2','\xb0'},{'\xba','\xb1'},{'\xe2','\x71'},{'\xe2','\xa3'},
    {'\x9b','\xa1'},{'\xe2','\x73'},{'\xe2','\xb3'},{'\xe2','\xaf'},{'\xba','\x75'},
    {'\xba','\xa1'},{'\xe6','\x53'},{'\xba','\xae'},{'\xba','\x7d'},{'\xe2','\x6f'},
    {'\x9b','\xa2'},{'\xe2','\xae'},{'\xba','\xa3'},{'\xe2','\xab'},{'\xe2','\xb8'},
    {'\xe2','\x75'},{'\xe2','\x7e'},{'\x9b','\xa3'},{'\x9b','\xa4'},{'\xe2','\xb6'},
    {'\xe2','\xac'},{'\xba','\x7c'},{'\x00','\x00'},{'\xa0','\x6f'},{'\xe2','\x7c'},
    {'\xba','\x76'},{'\xba','\x74'},{'\xba','\xa8'},{'\x9b','\xa5'},{'\x9b','\xa6'},
    {'\xe2','\x7a'},{'\xe2','\x77'},{'\xe2','\x78'},{'\x00','\x00'},{'\xe2','\xb2'},
    {'\x00','\x00'},{'\xe2','\xb7'},{'\xe2','\xb5'},{'\xba','\x7a'},{'\xe2','\xb9'},
    {'\xba','\x7e'},{'\xba','\xa7'},{'\xa0','\x70'},{'\xe2','\x70'},{'\xe5','\xfa'},
    {'\xe2','\x79'},{'\x00','\x00'},{'\xba','\x78'},{'\xba','\xac'},{'\xba','\xa9'},
    {'\xba','\x7b'},{'\xe2','\xa5'},{'\xe2','\x74'},{'\xba','\xaa'},{'\xe2','\xa7'},
    {'\xba','\xa4'},{'\xba','\xa6'},{'\xba','\x73'},{'\x9b','\xa7'},{'\xe2','\xa9'},
    {'\xe2','\xa1'},{'\xe2','\x72'},{'\xba','\xa5'},{'\xe2','\xb1'},{'\xe2','\xb4'},
    {'\xe2','\x7b'},{'\xe2','\xa8'},{'\x9b','\xa8'},{'\xba','\x79'},{'\xbc','\xdf'},
    {'\xe2','\xa6'},{'\xe5','\xf9'},{'\x00','\x00'},{'\xe2','\xad'},{'\xfc','\xa2'},
    {'\x82','\x50'},{'\x8f','\xbd'},{'\x8b','\x7c'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8b','\xfb'},{'\x00','\x00'},{'\x89','\xf0'},{'\xe2','\x76'},
    {'\xe6','\x44'},{'\xe6','\x4e'},{'\xbc','\xe2'},{'\xe6','\x4d'},{'\xe6','\x59'},
    {'\xbc','\xe4'},{'\xe6','\x4b'},{'\x9b','\xa9'},{'\xe6','\x4f'},{'\xbc','\xef'},
    {'\x00','\x00'},{'\xe6','\x46'},{'\xbc','\xe7'},{'\x90','\xb9'},{'\xe6','\x52'},
    {'\xe9','\xf0'},{'\xbc','\xf3'},{'\xbc','\xf2'},{'\xe6','\x54'},{'\xe6','\x43'},
    {'\xe6','\x5e'},{'\xbc','\xed'},{'\x00','\x00'},{'\xbc','\xe3'},{'\xe6','\x57'},
    {'\x00','\x00'},{'\xe6','\x5b'},{'\xe6','\x60'},{'\xe6','\x55'},{'\xe6','\x49'},
    {'\xbc','\xe6'},{'\xbc','\xe9'},{'\xbc','\xf1'},{'\xbc','\xec'},{'\x00','\x00'},
    {'\xe6','\x4c'},{'\xe2','\xa2'},{'\xa0','\x71'},{'\x00','\x00'},{'\xe6','\x48'},
    {'\xe6','\x5f'},{'\xbc','\xe8'},{'\x9b','\xaa'},{'\xbc','\xeb'},{'\xe6','\x61'},
    {'\xbc','\xe0'},{'\xe6','\x56'},{'\xe5','\xfb'},{'\xe6','\x5c'},{'\xc0','\xdf'},
    {'\x95','\x6b'},{'\xe6','\x4a'},{'\x00','\x00'},{'\xbc','\xe1'},{'\xe6','\x45'},
    {'\xbc','\xe5'},{'\xe5','\xfc'},{'\xba','\xab'},{'\xe6','\x41'},{'\x9b','\xab'},
    {'\xe6','\x5a'},{'\xe6','\x42'},{'\xe6','\x40'},{'\xbc','\xea'},{'\x00','\x00'},
    {'\xe6','\x58'},{'\xa0','\x72'},{'\xe5','\xfe'},{'\xe6','\x51'},{'\xe6','\x50'},
    {'\xe6','\x5d'},{'\xe6','\x47'},{'\xbc','\xee'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x8b','\xfa'},{'\x9b','\xac'},{'\xe9','\xf3'},
    {'\x9b','\xad'},{'\xbf','\x49'},{'\xbe','\xfe'},{'\xea','\x40'},{'\xe9','\xeb'},
    {'\xbf','\x41'},{'\xe9','\xf7'},{'\xbf','\x48'},{'\xbf','\x43'},{'\xe9','\xf5'},
    {'\xed','\x4f'},{'\xe9','\xfb'},{'\xea','\x42'},{'\xe9','\xfa'},{'\xe9','\xe9'},
    {'\xe9','\xf8'},{'\xea','\x44'},{'\xea','\x46'},{'\xbe','\xfd'},{'\xea','\x45'},
    {'\xbf','\x44'},{'\xbf','\x4a'},{'\xa0','\x73'},{'\xbf','\x47'},{'\x00','\x00'},
    {'\xe9','\xfe'},{'\xbf','\x46'},{'\xe9','\xf9'},{'\x9b','\xae'},{'\xe9','\xed'},
    {'\xe9','\xf2'},{'\x9b','\xaf'},{'\xe9','\xfd'},{'\xbf','\x45'},{'\xbf','\x42'},
    {'\xbe','\xfc'},{'\xbf','\x40'},{'\xe9','\xf1'},{'\x00','\x00'},{'\xe5','\xfd'},
    {'\xe9','\xec'},{'\xe9','\xef'},{'\xea','\x41'},{'\xe9','\xf4'},{'\xe9','\xea'},
    {'\xed','\x4e'},{'\xea','\x43'},{'\xe9','\xee'},{'\xe9','\xfc'},{'\x00','\x00'},
    {'\x8b','\x7d'},{'\x8b','\xa1'},{'\x9b','\xb0'},{'\xed','\x51'},{'\xc0','\xe3'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc0','\xd7'},{'\x9b','\xb1'},{'\xfc','\xa4'},
    {'\xc0','\xdb'},{'\xed','\x53'},{'\xed','\x59'},{'\xed','\x57'},{'\xc0','\xd9'},
    {'\xc0','\xda'},{'\xc0','\xe1'},{'\xed','\x5a'},{'\xed','\x52'},{'\xc0','\xdc'},
    {'\x00','\x00'},{'\xed','\x56'},{'\xed','\x55'},{'\xed','\x5b'},{'\xc0','\xe2'},
    {'\x00','\x00'},{'\xc0','\xdd'},{'\xc0','\xe0'},{'\xed','\x54'},{'\xc0','\xe4'},
    {'\xc0','\xde'},{'\xc0','\xe5'},{'\xc0','\xd8'},{'\xed','\x58'},{'\xa0','\x74'},
    {'\xed','\x50'},{'\xa0','\x75'},{'\x95','\xc6'},{'\xef','\xf7'},{'\x9b','\xb2'},
    {'\x00','\x00'},{'\xc2','\x71'},{'\xef','\xf4'},{'\xef','\xf6'},{'\x00','\x00'},
    {'\xc2','\x6f'},{'\xef','\xf2'},{'\xef','\xf3'},{'\xef','\xee'},{'\x00','\x00'},
    {'\x9b','\xb3'},{'\xe9','\xf6'},{'\xef','\xef'},{'\xc2','\x70'},{'\xef','\xeb'},
    {'\x00','\x00'},{'\xc2','\x6d'},{'\xef','\xf8'},{'\xc2','\x6e'},{'\xef','\xec'},
    {'\xef','\xed'},{'\xef','\xf1'},{'\xc2','\x73'},{'\x00','\x00'},{'\xc2','\x72'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xef','\xf0'},{'\xc3','\x78'},{'\xf2','\x5f'},
    {'\xf2','\x65'},{'\xc3','\x79'},{'\xf2','\x5c'},{'\xc3','\x76'},{'\xc3','\x73'},
    {'\xf2','\x67'},{'\xc3','\x77'},{'\xfe','\xa1'},{'\xc3','\x74'},{'\xf2','\x5e'},
    {'\xf2','\x61'},{'\xf2','\x62'},{'\xf2','\x63'},{'\xf2','\x66'},{'\x00','\x00'},
    {'\xef','\xf5'},{'\xf2','\x5d'},{'\xc3','\x75'},{'\xf2','\x64'},{'\xf2','\x68'},
    {'\xf2','\x60'},{'\x93','\x40'},{'\x00','\x00'},{'\x00','\x00'},{'\xf4','\x5d'},
    {'\xc4','\x6a'},{'\xf4','\x60'},{'\xc4','\x6b'},{'\xf4','\x68'},{'\xf4','\x5f'},
    {'\xf4','\x5c'},{'\x00','\x00'},{'\xf4','\x5e'},{'\xf4','\x62'},{'\xf4','\x65'},
    {'\xf4','\x64'},{'\xf4','\x67'},{'\xf4','\x5b'},{'\x00','\x00'},{'\xc4','\x69'},
    {'\xf4','\x63'},{'\xf4','\x66'},{'\xf4','\x69'},{'\xf4','\x61'},{'\xf5','\xd3'},
    {'\xf5','\xd4'},{'\xf5','\xd8'},{'\xf5','\xd9'},{'\x00','\x00'},{'\xf5','\xd6'},
    {'\xf5','\xd7'},{'\xf5','\xd5'},{'\x9b','\xb4'},{'\xc4','\xe9'},{'\x9b','\xb5'},
    {'\x00','\x00'},{'\x90','\x76'},{'\x9b','\xb6'},{'\xc5','\x78'},{'\xf6','\xeb'},
    {'\x00','\x00'},{'\x9b','\xb7'},{'\xf6','\xe8'},{'\xf6','\xe9'},{'\xf6','\xea'},
    {'\xc5','\x79'},{'\x00','\x00'},{'\xf7','\xe5'},{'\xf7','\xe4'},{'\x9b','\xb8'},
    {'\xf8','\xaf'},{'\xc5','\xf4'},{'\xf8','\xad'},{'\xf8','\xb0'},{'\xf8','\xae'},
    {'\xf8','\xf5'},{'\xc6','\x57'},{'\xc6','\x65'},{'\xf9','\xa3'},{'\xf9','\x6c'},
    {'\x9b','\xb9'},{'\xf9','\xa2'},{'\xf9','\xd0'},{'\xf9','\xd1'},{'\xa4','\xf5'},
    {'\x9c','\xf6'},{'\x85','\xd9'},{'\x00','\x00'},{'\x88','\xf9'},{'\xa6','\xc7'},
    {'\xca','\x41'},{'\x00','\x00'},{'\x00','\x00'},{'\xcb','\x5e'},{'\x8d','\x5f'},
    {'\xa8','\x5f'},{'\x9b','\xba'},{'\xa8','\x62'},{'\x9b','\xbb'},{'\xcb','\x5f'},
    {'\x00','\x00'},{'\xa8','\x60'},{'\xa8','\x61'},{'\x83','\x4d'},{'\x89','\xf2'},
    {'\x85','\xdf'},{'\xfc','\xa5'},{'\xcd','\x58'},{'\xcd','\x5a'},{'\xcd','\x55'},
    {'\xcd','\x52'},{'\xcd','\x54'},{'\x00','\x00'},{'\x00','\x00'},{'\x93','\xf4'},
    {'\xaa','\xa4'},{'\x9b','\xbc'},{'\x00','\x00'},{'\xfe','\xa3'},{'\xaa','\xa2'},
    {'\x9b','\xbd'},{'\x00','\x00'},{'\xcd','\x56'},{'\xaa','\xa3'},{'\xcd','\x53'},
    {'\xcd','\x50'},{'\xaa','\xa1'},{'\xcd','\x57'},{'\x00','\x00'},{'\xcd','\x51'},
    {'\xaa','\xa5'},{'\xcd','\x59'},{'\x00','\x00'},{'\x8e','\x45'},{'\x8e','\x76'},
    {'\x00','\x00'},{'\xcf','\xaf'},{'\x9b','\xbe'},{'\xcf','\xb3'},{'\x00','\x00'},
    {'\x9b','\xbf'},{'\xac','\xb7'},{'\x9b','\xc0'},{'\x9b','\xc1'},{'\x9b','\xc2'},
    {'\x00','\x00'},{'\xcf','\xb6'},{'\x00','\x00'},{'\xac','\xaf'},{'\xac','\xb2'},
    {'\xac','\xb4'},{'\xac','\xb6'},{'\xac','\xb3'},{'\xcf','\xb2'},{'\xcf','\xb1'},
    {'\x00','\x00'},{'\xac','\xb1'},{'\xcf','\xb4'},{'\xcf','\xb5'},{'\x00','\x00'},
    {'\xcf','\xae'},{'\xac','\xb5'},{'\x8a','\xbb'},{'\xac','\xb0'},{'\xa0','\x76'},
    {'\x85','\xde'},{'\x88','\xf7'},{'\xcf','\xb0'},{'\x00','\x00'},{'\xa0','\x77'},
    {'\x8b','\xa3'},{'\x8c','\x7a'},{'\x8d','\xd1'},{'\x9b','\xc3'},{'\xd2','\x77'},
    {'\xd2','\x78'},{'\xd2','\x79'},{'\xaf','\x50'},{'\x00','\x00'},{'\xaf','\x4c'},
    {'\xd2','\x6e'},{'\x9b','\xc4'},{'\xd2','\x76'},{'\xd2','\x7b'},{'\xaf','\x51'},
    {'\x9b','\xc5'},{'\xd2','\x6c'},{'\xd2','\x72'},{'\xd2','\x6b'},{'\xd2','\x75'},
    {'\xfc','\x57'},{'\x9b','\xc6'},{'\xd2','\x71'},{'\xaf','\x4d'},{'\xaf','\x4f'},
    {'\xd2','\x7a'},{'\x89','\xf3'},{'\xd2','\x6a'},{'\xd2','\x6d'},{'\xd2','\x73'},
    {'\x95','\xaf'},{'\xd2','\x74'},{'\xd2','\x7c'},{'\xd2','\x70'},{'\x00','\x00'},
    {'\xaf','\x4e'},{'\x00','\x00'},{'\x85','\xdd'},{'\x88','\xf8'},{'\x8e','\xea'},
    {'\x89','\xf4'},{'\x00','\x00'},{'\x88','\xfa'},{'\x8a','\xd8'},{'\x87','\xf1'},
    {'\x00','\x00'},{'\xb2','\x6d'},{'\xd6','\x4e'},{'\x95','\x49'},{'\x00','\x00'},
    {'\xd6','\x50'},{'\xd6','\x4c'},{'\x9c','\x40'},{'\xd6','\x58'},{'\xd6','\x4a'},
    {'\xd6','\x57'},{'\xb2','\x69'},{'\xd6','\x48'},{'\xda','\x5b'},{'\xd6','\x52'},
    {'\xb2','\x6c'},{'\x9c','\x4b'},{'\xd6','\x53'},{'\xd6','\x56'},{'\x00','\x00'},
    {'\xd6','\x5a'},{'\x00','\x00'},{'\xd6','\x4f'},{'\x9c','\x4c'},{'\xd6','\x54'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb2','\x6a'},{'\xb2','\x6b'},{'\xd6','\x59'},
    {'\xd6','\x4d'},{'\xd6','\x49'},{'\xd6','\x5b'},{'\xa0','\x78'},{'\xd6','\x51'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xd6','\x55'},{'\x82','\x44'},{'\x85','\xe0'},
    {'\x88','\xfb'},{'\xd6','\x4b'},{'\x8a','\xd9'},{'\xb5','\x48'},{'\xb5','\x49'},
    {'\xda','\x65'},{'\xb5','\x4f'},{'\x9c','\x4d'},{'\xda','\x59'},{'\xda','\x62'},
    {'\xda','\x58'},{'\xb5','\x4c'},{'\xda','\x60'},{'\xda','\x5e'},{'\x00','\x00'},
    {'\xda','\x5f'},{'\xb5','\x4a'},{'\x00','\x00'},{'\xda','\x63'},{'\x9c','\x4e'},
    {'\x00','\x00'},{'\x9c','\x4f'},{'\x9c','\x50'},{'\x00','\x00'},{'\xda','\x5c'},
    {'\xda','\x5a'},{'\xb5','\x4b'},{'\xda','\x5d'},{'\xda','\x61'},{'\x9c','\x51'},
    {'\xfc','\xa7'},{'\x9c','\x52'},{'\xb5','\x4d'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xda','\x64'},{'\x9c','\x53'},{'\x92','\xe5'},{'\x00','\x00'},
    {'\x9c','\x54'},{'\xfe','\x76'},{'\x9c','\x55'},{'\xde','\x70'},{'\xde','\x77'},
    {'\xde','\x79'},{'\xde','\xa1'},{'\xfb','\x66'},{'\xb7','\xda'},{'\xde','\x6b'},
    {'\x00','\x00'},{'\xb7','\xd2'},{'\x95','\x4f'},{'\xde','\x7a'},{'\xb7','\xd7'},
    {'\xde','\xa2'},{'\xb7','\xce'},{'\x9c','\x56'},{'\xde','\x7d'},{'\x95','\x5f'},
    {'\xde','\x6d'},{'\xde','\x7e'},{'\xde','\x6c'},{'\xa0','\x7a'},{'\xb7','\xdc'},
    {'\x9d','\xcd'},{'\xde','\x78'},{'\xb7','\xcf'},{'\xde','\xa3'},{'\x00','\x00'},
    {'\xb7','\xd4'},{'\xde','\x71'},{'\xb7','\xd9'},{'\xde','\x7c'},{'\xde','\x6f'},
    {'\xde','\x76'},{'\xde','\x72'},{'\xde','\x6e'},{'\xb7','\xd1'},{'\xb7','\xd8'},
    {'\xb7','\xd6'},{'\xb7','\xd3'},{'\xb7','\xdb'},{'\xb7','\xd0'},{'\xde','\x75'},
    {'\x9c','\x57'},{'\xb7','\xd5'},{'\x00','\x00'},{'\xb5','\x4e'},{'\x00','\x00'},
    {'\xde','\x7b'},{'\xfe','\x53'},{'\xde','\x73'},{'\xa0','\x7b'},{'\x00','\x00'},
    {'\x9c','\x58'},{'\xfc','\xa9'},{'\x9c','\x59'},{'\xde','\x74'},{'\x00','\x00'},
    {'\xa0','\x7c'},{'\xe2','\xc1'},{'\x9c','\x5a'},{'\xba','\xb4'},{'\x9c','\x5b'},
    {'\x00','\x00'},{'\xe2','\xbd'},{'\xe2','\xc3'},{'\xe2','\xbf'},{'\x00','\x00'},
    {'\xba','\xb6'},{'\xe2','\xbe'},{'\xe2','\xc2'},{'\xe2','\xba'},{'\xa0','\xd8'},
    {'\xe2','\xbc'},{'\xba','\xb5'},{'\x00','\x00'},{'\x9c','\x5c'},{'\x00','\x00'},
    {'\x9c','\x5d'},{'\xe2','\xc0'},{'\xe2','\xbb'},{'\x9c','\x5e'},{'\xba','\xb7'},
    {'\x00','\x00'},{'\xba','\xb2'},{'\x94','\xab'},{'\x9c','\x5f'},{'\xe2','\xc4'},
    {'\xa0','\xe7'},{'\xba','\xb3'},{'\xe6','\x67'},{'\xe6','\x64'},{'\xe6','\x70'},
    {'\xe6','\x6a'},{'\xe6','\x6c'},{'\xbc','\xf4'},{'\xe6','\x66'},{'\xe6','\x6e'},
    {'\x9c','\x60'},{'\x9c','\x61'},{'\xe6','\x6d'},{'\xe6','\x6b'},{'\x00','\x00'},
    {'\xe6','\x71'},{'\xbc','\xf7'},{'\xe6','\x68'},{'\xe6','\x6f'},{'\x00','\x00'},
    {'\xbc','\xf5'},{'\x9c','\x62'},{'\x00','\x00'},{'\xe6','\x63'},{'\xe6','\x65'},
    {'\xbc','\xf6'},{'\xe6','\x62'},{'\xe6','\x72'},{'\x9c','\x63'},{'\xe6','\x69'},
    {'\x00','\x00'},{'\x9c','\x64'},{'\xea','\x4a'},{'\xbf','\x51'},{'\x9c','\x65'},
    {'\x00','\x00'},{'\xea','\x55'},{'\xea','\x53'},{'\xbf','\x4b'},{'\xea','\x49'},
    {'\xea','\x4c'},{'\xea','\x4d'},{'\xea','\x48'},{'\xbf','\x55'},{'\xbf','\x56'},
    {'\xea','\x47'},{'\xea','\x56'},{'\xea','\x51'},{'\xbf','\x4f'},{'\xbf','\x4c'},
    {'\xea','\x50'},{'\xea','\x4e'},{'\x00','\x00'},{'\x00','\x00'},{'\xbf','\x52'},
    {'\xea','\x52'},{'\xbf','\x4d'},{'\x9c','\x66'},{'\xbf','\x4e'},{'\x00','\x00'},
    {'\xea','\x4f'},{'\xbf','\x50'},{'\xea','\x4b'},{'\xa0','\xe8'},{'\xea','\x54'},
    {'\xbf','\x53'},{'\xea','\x57'},{'\xea','\x58'},{'\xbf','\x54'},{'\x9c','\x67'},
    {'\x00','\x00'},{'\xc0','\xe7'},{'\xc0','\xee'},{'\xed','\x5c'},{'\xed','\x62'},
    {'\x00','\x00'},{'\xed','\x60'},{'\xc0','\xea'},{'\xc0','\xe9'},{'\xc0','\xe6'},
    {'\xed','\x5e'},{'\x00','\x00'},{'\x00','\x00'},{'\x9c','\x68'},{'\xc0','\xec'},
    {'\xc0','\xeb'},{'\xc0','\xe8'},{'\x00','\x00'},{'\xed','\x61'},{'\xed','\x5d'},
    {'\xed','\x5f'},{'\x00','\x00'},{'\xc0','\xed'},{'\xa0','\xf5'},{'\xfb','\x70'},
    {'\x00','\x00'},{'\xc2','\x77'},{'\xef','\xfb'},{'\x00','\x00'},{'\xc2','\x74'},
    {'\xc2','\x75'},{'\xef','\xfd'},{'\xc2','\x76'},{'\xef','\xfa'},{'\x9c','\x69'},
    {'\xef','\xf9'},{'\xf2','\x6c'},{'\xef','\xfc'},{'\x00','\x00'},{'\xf2','\x6d'},
    {'\xc3','\x7a'},{'\xf2','\x6b'},{'\x00','\x00'},{'\x9c','\x6a'},{'\xf2','\x6a'},
    {'\x00','\x00'},{'\xf2','\x69'},{'\xc3','\x7b'},{'\x9c','\x6b'},{'\x9c','\x6c'},
    {'\xc4','\x6c'},{'\x00','\x00'},{'\x00','\x00'},{'\xf4','\x6a'},{'\xf4','\x6b'},
    {'\xfc','\xac'},{'\x9c','\x6d'},{'\x9c','\x6e'},{'\x00','\x00'},{'\xf5','\xdc'},
    {'\xf5','\xdb'},{'\xc4','\xea'},{'\x00','\x00'},{'\xf5','\xda'},{'\xf6','\xec'},
    {'\xf6','\xed'},{'\x00','\x00'},{'\x00','\x00'},{'\xf7','\xe6'},{'\xf8','\xb1'},
    {'\x9c','\x6f'},{'\x9d','\x5a'},{'\xf8','\xf6'},{'\xf9','\xbc'},{'\xc6','\x79'},
    {'\xf9','\xc6'},{'\xa4','\xf6'},{'\x91','\xc9'},{'\xaa','\xa6'},{'\xaa','\xa7'},
    {'\x9c','\x71'},{'\x00','\x00'},{'\xac','\xb8'},{'\x85','\xc6'},{'\xfa','\x64'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc0','\xef'},{'\xa4','\xf7'},{'\x85','\xe1'},
    {'\xaa','\xa8'},{'\xaf','\x52'},{'\xb7','\xdd'},{'\xa4','\xf8'},{'\xfa','\x65'},
    {'\xb2','\x6e'},{'\xba','\xb8'},{'\xc9','\x62'},{'\x95','\xa7'},{'\xcf','\xb7'},
    {'\xd2','\x7d'},{'\x00','\x00'},{'\xe2','\xc5'},{'\x00','\x00'},{'\xc0','\xf0'},
    {'\xa4','\xf9'},{'\xaa','\xa9'},{'\xcf','\xb8'},{'\xcf','\xb9'},{'\xda','\x66'},
    {'\xb5','\x50'},{'\x8b','\xa4'},{'\x00','\x00'},{'\xde','\xa4'},{'\xfc','\xad'},
    {'\x00','\x00'},{'\xb7','\xde'},{'\xe2','\xc6'},{'\x00','\x00'},{'\x95','\x6e'},
    {'\xbc','\xf8'},{'\x9c','\x73'},{'\xc3','\x7c'},{'\xa4','\xfa'},{'\xda','\x67'},
    {'\xa4','\xfb'},{'\x9c','\x74'},{'\xa6','\xc9'},{'\xca','\x42'},{'\xa6','\xc8'},
    {'\xa8','\x65'},{'\xa8','\x64'},{'\xa8','\x63'},{'\xcb','\x60'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfa','\x66'},{'\xaa','\xaa'},{'\x00','\x00'},{'\xaa','\xab'},
    {'\xcd','\x5b'},{'\x00','\x00'},{'\xcf','\xba'},{'\x00','\x00'},{'\xcf','\xbd'},
    {'\xac','\xba'},{'\xcf','\xbb'},{'\x00','\x00'},{'\xac','\xb9'},{'\xcf','\xbc'},
    {'\xac','\xbb'},{'\x84','\x61'},{'\xd2','\xa2'},{'\xd2','\xa1'},{'\xd2','\x7e'},
    {'\xaf','\x53'},{'\x8c','\x7b'},{'\xd6','\x5d'},{'\xd6','\x5e'},{'\xb2','\x6f'},
    {'\xd6','\x5c'},{'\xd6','\x5f'},{'\xb5','\x52'},{'\xb2','\x70'},{'\xfa','\x67'},
    {'\x00','\x00'},{'\xb5','\x51'},{'\xda','\x6b'},{'\xda','\x6a'},{'\xfc','\xae'},
    {'\xda','\x68'},{'\xda','\x69'},{'\x8b','\xa5'},{'\xda','\x6c'},{'\xde','\xa6'},
    {'\xde','\xa5'},{'\xde','\xa9'},{'\xfa','\x68'},{'\xde','\xa8'},{'\xde','\xa7'},
    {'\xba','\xb9'},{'\xe2','\xc9'},{'\x9c','\x75'},{'\xe2','\xc8'},{'\xba','\xba'},
    {'\xe2','\xc7'},{'\xe6','\x73'},{'\x00','\x00'},{'\xe6','\x74'},{'\xbc','\xf9'},
    {'\x00','\x00'},{'\xea','\x59'},{'\xea','\x5a'},{'\xfa','\x69'},{'\x92','\x71'},
    {'\xf2','\x72'},{'\xc3','\x7d'},{'\xf2','\x71'},{'\xf2','\x70'},{'\xf2','\x6e'},
    {'\xf2','\x6f'},{'\xc4','\xeb'},{'\xf4','\x6c'},{'\xf6','\xee'},{'\xf8','\xf7'},
    {'\x00','\x00'},{'\xa4','\xfc'},{'\xfa','\x6a'},{'\xc9','\xa5'},{'\xa5','\xc7'},
    {'\xc9','\xa6'},{'\xfa','\x6b'},{'\xfc','\xb0'},{'\x00','\x00'},{'\xca','\x43'},
    {'\xca','\x44'},{'\x83','\x5d'},{'\x8a','\xda'},{'\xfa','\x6c'},{'\x84','\xf6'},
    {'\xcb','\x66'},{'\x00','\x00'},{'\x00','\x00'},{'\xcb','\x62'},{'\xfa','\x6d'},
    {'\xcb','\x61'},{'\xaa','\xac'},{'\xcb','\x65'},{'\xa8','\x67'},{'\xcb','\x63'},
    {'\xa8','\x66'},{'\xcb','\x67'},{'\xcb','\x64'},{'\x00','\x00'},{'\x83','\xc1'},
    {'\xcd','\x5f'},{'\xcf','\xbe'},{'\xcd','\x5d'},{'\xcd','\x64'},{'\xfa','\x6e'},
    {'\xaa','\xad'},{'\x00','\x00'},{'\xaa','\xb0'},{'\xcd','\x65'},{'\xcd','\x61'},
    {'\x00','\x00'},{'\xcd','\x62'},{'\x00','\x00'},{'\xcd','\x5c'},{'\xaa','\xaf'},
    {'\xcd','\x5e'},{'\xaa','\xae'},{'\xcd','\x63'},{'\xfa','\x6f'},{'\xcd','\x60'},
    {'\x00','\x00'},{'\x89','\xf6'},{'\xcf','\xc2'},{'\xac','\xbd'},{'\xac','\xbe'},
    {'\xfc','\xb1'},{'\xcf','\xc5'},{'\xcf','\xbf'},{'\x00','\x00'},{'\xcf','\xc4'},
    {'\x00','\x00'},{'\xcf','\xc0'},{'\xac','\xbc'},{'\xcf','\xc3'},{'\xcf','\xc1'},
    {'\x88','\xfc'},{'\x83','\xc0'},{'\x85','\xe2'},{'\x8e','\xec'},{'\x84','\x62'},
    {'\x86','\xe2'},{'\x8e','\x47'},{'\xd2','\xa8'},{'\xd2','\xa5'},{'\x00','\x00'},
    {'\xd2','\xa7'},{'\xaf','\x58'},{'\xaf','\x57'},{'\xaf','\x55'},{'\xd2','\xa4'},
    {'\xd2','\xa9'},{'\xaf','\x54'},{'\xaf','\x56'},{'\xd2','\xa6'},{'\xd6','\x67'},
    {'\xd2','\xa3'},{'\xd2','\xaa'},{'\xfc','\xb2'},{'\x8e','\xeb'},{'\x9c','\x76'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xd6','\x62'},{'\xd6','\x66'},{'\x00','\x00'},
    {'\xd6','\x65'},{'\xda','\x6e'},{'\xda','\x79'},{'\x00','\x00'},{'\x8a','\xdb'},
    {'\xd6','\x68'},{'\x9c','\x77'},{'\xd6','\x63'},{'\xda','\x6d'},{'\xb2','\x74'},
    {'\x00','\x00'},{'\x8f','\x55'},{'\xb2','\x73'},{'\xd6','\x61'},{'\xd6','\x64'},
    {'\xb2','\x75'},{'\x00','\x00'},{'\xb2','\x72'},{'\xb2','\x71'},{'\xd6','\x60'},
    {'\xd6','\x69'},{'\x93','\xe6'},{'\x00','\x00'},{'\x8c','\xd3'},{'\xda','\x70'},
    {'\xda','\x77'},{'\xfa','\x70'},{'\xb5','\x54'},{'\xda','\x76'},{'\xda','\x73'},
    {'\xfc','\xb4'},{'\xb5','\x56'},{'\x95','\xbd'},{'\x95','\xbc'},{'\xfc','\xaf'},
    {'\xda','\x75'},{'\x95','\x52'},{'\xfa','\x71'},{'\xda','\x6f'},{'\xda','\x71'},
    {'\xda','\x74'},{'\xda','\x72'},{'\xb5','\x55'},{'\xda','\x78'},{'\xb5','\x53'},
    {'\xb7','\xdf'},{'\xfa','\x72'},{'\xfa','\x73'},{'\xde','\xad'},{'\xde','\xac'},
    {'\xde','\xaa'},{'\x00','\x00'},{'\xb7','\xe2'},{'\xb7','\xe1'},{'\xde','\xae'},
    {'\x9c','\x78'},{'\xde','\xab'},{'\xe2','\xca'},{'\xba','\xbb'},{'\xb7','\xe0'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xfc','\xb3'},{'\xde','\xb0'},{'\xde','\xaf'},
    {'\x00','\x00'},{'\xe2','\xcd'},{'\xe2','\xcb'},{'\xbc','\xfa'},{'\xfc','\xb5'},
    {'\xba','\xbc'},{'\xe2','\xcc'},{'\xe6','\x76'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xbc','\xfb'},{'\xe6','\x75'},{'\xe6','\x7e'},
    {'\xe6','\x7d'},{'\xe6','\x7b'},{'\x00','\x00'},{'\xe6','\x7a'},{'\xe6','\x77'},
    {'\xe6','\x78'},{'\xe6','\x79'},{'\xe6','\x7c'},{'\xe6','\xa1'},{'\x92','\xde'},
    {'\x00','\x00'},{'\xea','\x5f'},{'\xea','\x5c'},{'\xea','\x5d'},{'\xbf','\x57'},
    {'\xea','\x5b'},{'\xea','\x61'},{'\xea','\x60'},{'\xea','\x5e'},{'\x8b','\xa7'},
    {'\xed','\x64'},{'\xed','\x65'},{'\xc0','\xf1'},{'\xfc','\xb6'},{'\xc0','\xf2'},
    {'\xed','\x63'},{'\x9c','\x79'},{'\xc2','\x79'},{'\xef','\xfe'},{'\xc2','\x78'},
    {'\xc3','\x7e'},{'\x00','\x00'},{'\xc3','\xa1'},{'\xc4','\x6d'},{'\xf4','\x6e'},
    {'\xf4','\x6d'},{'\xf5','\xdd'},{'\xf6','\xef'},{'\xc5','\x7a'},{'\xf7','\xe8'},
    {'\xf7','\xe7'},{'\xf7','\xe9'},{'\xa5','\xc8'},{'\xcf','\xc6'},{'\xaf','\x59'},
    {'\xb2','\x76'},{'\xd6','\x6a'},{'\xa5','\xc9'},{'\xc9','\xa7'},{'\xa4','\xfd'},
    {'\x9c','\x7a'},{'\x00','\x00'},{'\xca','\x45'},{'\x9c','\x7b'},{'\x00','\x00'},
    {'\x88','\xfd'},{'\xcb','\x6c'},{'\xcb','\x6a'},{'\xcb','\x6b'},{'\xcb','\x68'},
    {'\xa8','\x68'},{'\xcb','\x69'},{'\x9c','\x7c'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x86','\xe4'},{'\x9c','\x7d'},{'\xcd','\x6d'},{'\x9c','\x7e'},{'\xaa','\xb3'},
    {'\xcd','\x6b'},{'\xcd','\x67'},{'\xcd','\x6a'},{'\x00','\x00'},{'\xcd','\x66'},
    {'\xaa','\xb5'},{'\xcd','\x69'},{'\x9c','\xa1'},{'\xaa','\xb2'},{'\xaa','\xb1'},
    {'\x9c','\xa2'},{'\xaa','\xb4'},{'\xcd','\x6c'},{'\xcd','\x68'},{'\x8e','\x48'},
    {'\x89','\xf8'},{'\x84','\x63'},{'\x00','\x00'},{'\xac','\xc2'},{'\xac','\xc5'},
    {'\xcf','\xce'},{'\xcf','\xcd'},{'\xcf','\xcc'},{'\xac','\xbf'},{'\xcf','\xd5'},
    {'\xcf','\xcb'},{'\x8b','\xa8'},{'\xac','\xc1'},{'\xd2','\xaf'},{'\xfa','\x74'},
    {'\xcf','\xd2'},{'\xcf','\xd0'},{'\xac','\xc4'},{'\x00','\x00'},{'\xcf','\xc8'},
    {'\xcf','\xd3'},{'\x00','\x00'},{'\xcf','\xca'},{'\xcf','\xd4'},{'\xcf','\xd1'},
    {'\xcf','\xc9'},{'\x95','\xbe'},{'\xac','\xc0'},{'\xcf','\xd6'},{'\xcf','\xc7'},
    {'\xac','\xc3'},{'\xfa','\x75'},{'\x95','\xb6'},{'\x90','\xb2'},{'\x8b','\xfd'},
    {'\xd2','\xb4'},{'\xd2','\xab'},{'\xd2','\xb6'},{'\x9c','\xa3'},{'\xd2','\xae'},
    {'\xd2','\xb9'},{'\xd2','\xba'},{'\xd2','\xac'},{'\xd2','\xb8'},{'\xd2','\xb5'},
    {'\xd2','\xb3'},{'\xd2','\xb7'},{'\xaf','\x5f'},{'\x00','\x00'},{'\xaf','\x5d'},
    {'\x9c','\xa4'},{'\x9c','\xa5'},{'\xd2','\xb1'},{'\x9c','\xa6'},{'\xd2','\xad'},
    {'\x9c','\xa7'},{'\xd2','\xb0'},{'\xd2','\xbb'},{'\xd2','\xb2'},{'\xaf','\x5e'},
    {'\xcf','\xcf'},{'\x00','\x00'},{'\xaf','\x5a'},{'\xaf','\x5c'},{'\x9c','\xa8'},
    {'\x00','\x00'},{'\xfa','\x76'},{'\x85','\xe4'},{'\x9c','\xa9'},{'\xd6','\x78'},
    {'\xd6','\x6d'},{'\xd6','\x6b'},{'\xfe','\xaa'},{'\xd6','\x6c'},{'\x9c','\xab'},
    {'\xd6','\x73'},{'\x9c','\xac'},{'\xd6','\x74'},{'\xd6','\x70'},{'\xb2','\x7b'},
    {'\xd6','\x75'},{'\xd6','\x72'},{'\xd6','\x6f'},{'\x9c','\xad'},{'\xb2','\x79'},
    {'\xd6','\x6e'},{'\xb2','\x77'},{'\xb2','\x7a'},{'\xd6','\x71'},{'\xd6','\x79'},
    {'\xaf','\x5b'},{'\xb2','\x78'},{'\xd6','\x77'},{'\xd6','\x76'},{'\xb2','\x7c'},
    {'\x00','\x00'},{'\x8e','\xbf'},{'\x86','\xe3'},{'\x9c','\xae'},{'\x9c','\xaf'},
    {'\x00','\x00'},{'\x9c','\xb0'},{'\x9c','\xb1'},{'\xda','\x7e'},{'\x9c','\xb2'},
    {'\x00','\x00'},{'\x9c','\xb3'},{'\xda','\xa1'},{'\xb5','\x60'},{'\x9c','\xb4'},
    {'\xda','\xa7'},{'\x9c','\xb5'},{'\x9c','\xb6'},{'\xda','\xa9'},{'\xda','\xa2'},
    {'\xb5','\x5a'},{'\xda','\xa6'},{'\xda','\xa5'},{'\xb5','\x5b'},{'\xb5','\x61'},
    {'\x00','\x00'},{'\xb5','\x62'},{'\xda','\xa8'},{'\xb5','\x58'},{'\xda','\x7d'},
    {'\xda','\x7b'},{'\xda','\xa3'},{'\xda','\x7a'},{'\xb5','\x5f'},{'\xda','\x7c'},
    {'\xda','\xa4'},{'\xda','\xaa'},{'\xb5','\x59'},{'\xb5','\x5e'},{'\xb5','\x5c'},
    {'\xb5','\x5d'},{'\x9c','\xb7'},{'\x9c','\xb8'},{'\x9c','\xb9'},{'\xb5','\x57'},
    {'\x00','\x00'},{'\x8b','\xa9'},{'\x00','\x00'},{'\x00','\x00'},{'\xb7','\xe9'},
    {'\xde','\xb7'},{'\xb7','\xe8'},{'\xde','\xbb'},{'\x9c','\xba'},{'\xde','\xb1'},
    {'\x9c','\xbb'},{'\xde','\xbc'},{'\x9c','\xbc'},{'\x9c','\xbd'},{'\x9c','\xbe'},
    {'\xde','\xb2'},{'\xde','\xb3'},{'\x00','\x00'},{'\xde','\xbd'},{'\xde','\xba'},
    {'\xde','\xb8'},{'\xde','\xb9'},{'\xde','\xb5'},{'\xde','\xb4'},{'\x9c','\xbf'},
    {'\xde','\xbe'},{'\xb7','\xe5'},{'\x9c','\xc0'},{'\xde','\xb6'},{'\x00','\x00'},
    {'\xb7','\xea'},{'\xb7','\xe4'},{'\xb7','\xeb'},{'\xb7','\xec'},{'\xfc','\xb9'},
    {'\xb7','\xe7'},{'\xb7','\xe6'},{'\xfe','\x75'},{'\x9d','\x73'},{'\xe2','\xce'},
    {'\xba','\xbe'},{'\xba','\xbd'},{'\x9c','\xc1'},{'\x00','\x00'},{'\xe2','\xd3'},
    {'\xfe','\xac'},{'\xbc','\xfc'},{'\xba','\xbf'},{'\x9c','\xc2'},{'\x9c','\xc3'},
    {'\xba','\xc1'},{'\xe2','\xd4'},{'\xb7','\xe3'},{'\xba','\xc0'},{'\xe2','\xd0'},
    {'\xe2','\xd2'},{'\xe2','\xcf'},{'\x9c','\xc4'},{'\xe2','\xd1'},{'\xfa','\x77'},
    {'\x89','\xf9'},{'\x00','\x00'},{'\xe6','\xab'},{'\x9c','\xc5'},{'\x00','\x00'},
    {'\xe6','\xaa'},{'\xe6','\xa7'},{'\xbd','\x40'},{'\xea','\x62'},{'\xbd','\x41'},
    {'\xe6','\xa6'},{'\x9c','\xc6'},{'\xbc','\xfe'},{'\x00','\x00'},{'\xe6','\xa8'},
    {'\xe6','\xa5'},{'\xe6','\xa2'},{'\xe6','\xa9'},{'\xe6','\xa3'},{'\xe6','\xa4'},
    {'\xbc','\xfd'},{'\x81','\xd0'},{'\x81','\xd1'},{'\x8c','\x7d'},{'\x00','\x00'},
    {'\xed','\x69'},{'\x00','\x00'},{'\xea','\x66'},{'\x00','\x00'},{'\xea','\x65'},
    {'\xea','\x67'},{'\x00','\x00'},{'\xed','\x66'},{'\xbf','\x5a'},{'\x81','\xd2'},
    {'\xea','\x63'},{'\x81','\xd3'},{'\xbf','\x58'},{'\x9d','\x74'},{'\xbf','\x5c'},
    {'\xbf','\x5b'},{'\xea','\x64'},{'\xea','\x68'},{'\xfa','\x78'},{'\xbf','\x59'},
    {'\x81','\xd4'},{'\xed','\x6d'},{'\xc0','\xf5'},{'\xc2','\x7a'},{'\xc0','\xf6'},
    {'\xc0','\xf3'},{'\xed','\x6a'},{'\xed','\x68'},{'\x00','\x00'},{'\xed','\x6b'},
    {'\x00','\x00'},{'\xed','\x6e'},{'\xc0','\xf4'},{'\xed','\x6c'},{'\xed','\x67'},
    {'\x00','\x00'},{'\x81','\xd5'},{'\xf0','\x42'},{'\xf0','\x45'},{'\xf2','\x75'},
    {'\xf0','\x40'},{'\x81','\xd6'},{'\xf4','\x6f'},{'\xf0','\x46'},{'\x00','\x00'},
    {'\xc3','\xa2'},{'\xf0','\x44'},{'\xc2','\x7b'},{'\xf0','\x41'},{'\xf0','\x43'},
    {'\xf0','\x47'},{'\xf2','\x76'},{'\x00','\x00'},{'\xf2','\x74'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x81','\xd7'},{'\x00','\x00'},{'\xc3','\xa3'},{'\xf2','\x73'},
    {'\x81','\xd8'},{'\x00','\x00'},{'\x00','\x00'},{'\xc4','\x6e'},{'\x81','\xd9'},
    {'\x00','\x00'},{'\x8c','\xf9'},{'\x81','\xda'},{'\xc4','\xed'},{'\xf6','\xf1'},
    {'\xc4','\xec'},{'\xf6','\xf3'},{'\xf6','\xf0'},{'\xf6','\xf2'},{'\xc5','\xd0'},
    {'\xf8','\xb2'},{'\xa5','\xca'},{'\xcd','\x6e'},{'\xd2','\xbc'},{'\xd2','\xbd'},
    {'\xb2','\x7d'},{'\xde','\xbf'},{'\xbf','\x5d'},{'\xc3','\xa4'},{'\xc5','\x7b'},
    {'\xf8','\xb3'},{'\xa5','\xcb'},{'\x94','\xac'},{'\xcd','\x6f'},{'\xa2','\x60'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xcf','\xd7'},{'\x00','\x00'},{'\xcf','\xd8'},
    {'\x88','\xfe'},{'\x94','\xae'},{'\x94','\xaf'},{'\x94','\xad'},{'\x00','\x00'},
    {'\xd2','\xbe'},{'\xd2','\xbf'},{'\xb2','\x7e'},{'\xb2','\xa1'},{'\x94','\xb0'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xda','\xab'},{'\x00','\x00'},{'\xde','\xc2'},
    {'\xde','\xc1'},{'\xde','\xc0'},{'\xe2','\xd5'},{'\xfa','\x79'},{'\xe2','\xd6'},
    {'\xe2','\xd7'},{'\xba','\xc2'},{'\x94','\xb1'},{'\x00','\x00'},{'\xe6','\xad'},
    {'\xe6','\xac'},{'\x00','\x00'},{'\x00','\x00'},{'\xea','\x69'},{'\xbf','\x5e'},
    {'\xbf','\x5f'},{'\x95','\xc2'},{'\xed','\x72'},{'\xed','\x6f'},{'\xed','\x70'},
    {'\xed','\x71'},{'\xf0','\x49'},{'\xf0','\x48'},{'\xc2','\x7c'},{'\xf2','\x77'},
    {'\xf5','\xde'},{'\xa5','\xcc'},{'\xfa','\x7a'},{'\xac','\xc6'},{'\x00','\x00'},
    {'\xb2','\xa2'},{'\xde','\xc3'},{'\xfc','\xbb'},{'\xa5','\xcd'},{'\x00','\x00'},
    {'\xd2','\xc0'},{'\xb2','\xa3'},{'\xfa','\x7b'},{'\x00','\x00'},{'\xb5','\x63'},
    {'\xb5','\x64'},{'\x00','\x00'},{'\xa5','\xce'},{'\xa5','\xcf'},{'\xca','\x46'},
    {'\xa8','\x6a'},{'\xa8','\x69'},{'\xac','\xc7'},{'\xcf','\xd9'},{'\xda','\xac'},
    {'\xa5','\xd0'},{'\xa5','\xd1'},{'\xa5','\xd2'},{'\xa5','\xd3'},{'\xa0','\x59'},
    {'\x86','\x7a'},{'\x00','\x00'},{'\xa8','\x6b'},{'\xa8','\x6c'},{'\xcb','\x6e'},
    {'\xcb','\x6d'},{'\x84','\xf8'},{'\xfa','\x7c'},{'\xaa','\xb6'},{'\xcd','\x72'},
    {'\xcd','\x70'},{'\xcd','\x71'},{'\x00','\x00'},{'\x81','\xdb'},{'\x00','\x00'},
    {'\xfa','\x7d'},{'\x86','\xd0'},{'\xfb','\xd1'},{'\xcf','\xda'},{'\xcf','\xdb'},
    {'\xfa','\x7e'},{'\x95','\xbf'},{'\xac','\xcb'},{'\xac','\xc9'},{'\xfa','\xa1'},
    {'\xac','\xca'},{'\xac','\xc8'},{'\x00','\x00'},{'\x94','\x55'},{'\x00','\x00'},
    {'\xfc','\xbc'},{'\xaf','\x60'},{'\x81','\xdc'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xaf','\x64'},{'\xaf','\x63'},{'\xd2','\xc1'},{'\xaf','\x62'},
    {'\xaf','\x61'},{'\x00','\x00'},{'\xd2','\xc2'},{'\x94','\x56'},{'\x00','\x00'},
    {'\xb2','\xa6'},{'\xd6','\x7b'},{'\xd6','\x7a'},{'\xb2','\xa4'},{'\xb2','\xa5'},
    {'\x95','\xcc'},{'\x00','\x00'},{'\x94','\xb2'},{'\xb5','\x66'},{'\xb5','\x65'},
    {'\xda','\xae'},{'\xfa','\xa2'},{'\x81','\xdd'},{'\xda','\xad'},{'\xb2','\xa7'},
    {'\x00','\x00'},{'\x8d','\xe2'},{'\x92','\xec'},{'\x8b','\xaa'},{'\x00','\x00'},
    {'\xb7','\xed'},{'\xde','\xc5'},{'\xb7','\xee'},{'\xde','\xc4'},{'\xfc','\xbd'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xe2','\xd8'},{'\xe6','\xae'},{'\xbd','\x42'},
    {'\xea','\x6a'},{'\x00','\x00'},{'\xfa','\xa3'},{'\xfa','\xa4'},{'\xed','\x73'},
    {'\x00','\x00'},{'\xc3','\xa6'},{'\xc3','\xa5'},{'\x00','\x00'},{'\xfa','\xa5'},
    {'\xc5','\x7c'},{'\xa5','\xd4'},{'\xcd','\x73'},{'\x81','\xde'},{'\x93','\x51'},
    {'\xb2','\xa8'},{'\xe2','\xd9'},{'\xba','\xc3'},{'\xc6','\xd4'},{'\x00','\x00'},
    {'\xcb','\x6f'},{'\xcb','\x70'},{'\x8f','\x78'},{'\x89','\xfb'},{'\xcd','\x74'},
    {'\xaa','\xb8'},{'\xaa','\xb9'},{'\x00','\x00'},{'\x00','\x00'},{'\xaa','\xb7'},
    {'\x81','\xdf'},{'\x86','\xe5'},{'\x8a','\xdd'},{'\x86','\xe6'},{'\xac','\xcf'},
    {'\xac','\xd0'},{'\xac','\xcd'},{'\xac','\xce'},{'\x00','\x00'},{'\xcf','\xdc'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xcf','\xdd'},{'\xac','\xcc'},{'\xfa','\xa6'},
    {'\x00','\x00'},{'\x87','\xf4'},{'\x86','\xe7'},{'\xd2','\xc3'},{'\xfe','\x51'},
    {'\xaf','\x68'},{'\xaf','\x69'},{'\xfb','\x5c'},{'\xb2','\xab'},{'\xd2','\xc9'},
    {'\x00','\x00'},{'\xaf','\x6e'},{'\xaf','\x6c'},{'\xd2','\xca'},{'\xd2','\xc5'},
    {'\xaf','\x6b'},{'\xaf','\x6a'},{'\xaf','\x65'},{'\xd2','\xc8'},{'\xd2','\xc7'},
    {'\xd2','\xc4'},{'\xaf','\x6d'},{'\xfc','\xd3'},{'\xd2','\xc6'},{'\xaf','\x66'},
    {'\x00','\x00'},{'\xaf','\x67'},{'\x8f','\xfd'},{'\x84','\xf9'},{'\xb2','\xac'},
    {'\xd6','\xa1'},{'\xd6','\xa2'},{'\xb2','\xad'},{'\xd6','\x7c'},{'\xd6','\x7e'},
    {'\xd6','\xa4'},{'\xd6','\xa3'},{'\xd6','\x7d'},{'\x00','\x00'},{'\xb2','\xa9'},
    {'\xb2','\xaa'},{'\xfa','\xa7'},{'\xda','\xb6'},{'\xb5','\x6b'},{'\xb5','\x6a'},
    {'\xda','\xb0'},{'\xb5','\x68'},{'\x81','\xe0'},{'\xda','\xb3'},{'\xb5','\x6c'},
    {'\xda','\xb4'},{'\xb5','\x6d'},{'\xda','\xb1'},{'\xb5','\x67'},{'\xb5','\x69'},
    {'\xda','\xb5'},{'\x00','\x00'},{'\xda','\xb2'},{'\xda','\xaf'},{'\x89','\xfa'},
    {'\xfa','\xa8'},{'\x86','\xe8'},{'\x8f','\x58'},{'\x00','\x00'},{'\xde','\xd2'},
    {'\x00','\x00'},{'\xde','\xc7'},{'\xb7','\xf0'},{'\xb7','\xf3'},{'\xb7','\xf2'},
    {'\xb7','\xf7'},{'\xb7','\xf6'},{'\xde','\xd3'},{'\xde','\xd1'},{'\xde','\xca'},
    {'\xde','\xce'},{'\xde','\xcd'},{'\xb7','\xf4'},{'\xde','\xd0'},{'\xde','\xcc'},
    {'\xde','\xd4'},{'\xde','\xcb'},{'\xb7','\xf5'},{'\xb7','\xef'},{'\xb7','\xf1'},
    {'\xfc','\xd5'},{'\xde','\xc9'},{'\x00','\x00'},{'\x8f','\x57'},{'\x00','\x00'},
    {'\xfc','\xd4'},{'\xe2','\xdb'},{'\xba','\xc7'},{'\xe2','\xdf'},{'\xba','\xc6'},
    {'\xe2','\xdc'},{'\xba','\xc5'},{'\x00','\x00'},{'\xde','\xc8'},{'\xde','\xcf'},
    {'\xe2','\xde'},{'\x00','\x00'},{'\xba','\xc8'},{'\xe2','\xe0'},{'\xe2','\xdd'},
    {'\xe2','\xda'},{'\x8e','\xc1'},{'\x89','\x40'},{'\xe6','\xb1'},{'\xe6','\xb5'},
    {'\xe6','\xb7'},{'\xe6','\xb3'},{'\xe6','\xb2'},{'\xe6','\xb0'},{'\xbd','\x45'},
    {'\xbd','\x43'},{'\xbd','\x48'},{'\xbd','\x49'},{'\xe6','\xb4'},{'\xbd','\x46'},
    {'\xe6','\xaf'},{'\xbd','\x47'},{'\xba','\xc4'},{'\xe6','\xb6'},{'\xbd','\x44'},
    {'\x8b','\xab'},{'\x8d','\x54'},{'\x81','\xe1'},{'\xea','\x6c'},{'\x00','\x00'},
    {'\xea','\x6b'},{'\xea','\x73'},{'\xea','\x6d'},{'\xea','\x72'},{'\xea','\x6f'},
    {'\xbf','\x60'},{'\xea','\x71'},{'\x00','\x00'},{'\x00','\x00'},{'\xbf','\x61'},
    {'\x00','\x00'},{'\xbf','\x62'},{'\x95','\xa9'},{'\xea','\x70'},{'\xea','\x6e'},
    {'\x8c','\xd5'},{'\x90','\x58'},{'\xfa','\xa9'},{'\x00','\x00'},{'\xc0','\xf8'},
    {'\xed','\x74'},{'\x00','\x00'},{'\x00','\x00'},{'\xc0','\xf7'},{'\xed','\x77'},
    {'\xed','\x75'},{'\xed','\x76'},{'\x00','\x00'},{'\x00','\x00'},{'\xc0','\xf9'},
    {'\xfa','\xaa'},{'\x95','\x6f'},{'\x81','\xe2'},{'\xf0','\x4d'},{'\x81','\xe3'},
    {'\xc2','\xa1'},{'\xf0','\x4e'},{'\xfa','\xab'},{'\x00','\x00'},{'\xc2','\x7d'},
    {'\xf0','\x4f'},{'\xc2','\x7e'},{'\xf0','\x4c'},{'\xf0','\x50'},{'\x00','\x00'},
    {'\xf0','\x4a'},{'\x00','\x00'},{'\x8c','\x7e'},{'\xc3','\xa7'},{'\xf2','\x78'},
    {'\xc3','\xa8'},{'\xc4','\x6f'},{'\x8c','\xd6'},{'\xf0','\x4b'},{'\xc4','\x70'},
    {'\xfb','\x76'},{'\xfc','\xd7'},{'\xfa','\xac'},{'\xc4','\xee'},{'\xf5','\xdf'},
    {'\x8d','\x55'},{'\xc5','\x7e'},{'\xf6','\xf4'},{'\xc5','\x7d'},{'\xfc','\xd8'},
    {'\xf7','\xea'},{'\xc5','\xf5'},{'\xc5','\xf6'},{'\x81','\xe4'},{'\x81','\xe5'},
    {'\xf9','\xcc'},{'\xc6','\xd5'},{'\x00','\x00'},{'\xac','\xd1'},{'\xcf','\xde'},
    {'\x93','\xb9'},{'\xb5','\x6e'},{'\xb5','\x6f'},{'\xa5','\xd5'},{'\xa6','\xca'},
    {'\xca','\x47'},{'\xfa','\xad'},{'\xcb','\x71'},{'\xa8','\x6d'},{'\xfa','\xae'},
    {'\xaa','\xba'},{'\x00','\x00'},{'\xac','\xd2'},{'\xac','\xd3'},{'\xac','\xd4'},
    {'\xd6','\xa6'},{'\xd2','\xcb'},{'\xaf','\x6f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb2','\xae'},{'\xd6','\xa5'},{'\xfa','\xaf'},{'\x87','\xf5'},{'\xda','\xb8'},
    {'\xb5','\x71'},{'\x00','\x00'},{'\xda','\xb7'},{'\xb5','\x70'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xde','\xd5'},{'\xbd','\x4a'},{'\xe6','\xbb'},{'\xe6','\xb8'},
    {'\xe6','\xb9'},{'\xe6','\xba'},{'\x00','\x00'},{'\x00','\x00'},{'\xfc','\xbe'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xed','\x78'},{'\x81','\xe6'},{'\xf0','\x51'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xf4','\x71'},{'\xf4','\x70'},
    {'\x00','\x00'},{'\xf6','\xf5'},{'\xa5','\xd6'},{'\xcd','\x75'},{'\xaf','\x70'},
    {'\x87','\xf6'},{'\x8e','\x77'},{'\x00','\x00'},{'\xb5','\x72'},{'\xde','\xd6'},
    {'\x00','\x00'},{'\xfa','\xb0'},{'\xe2','\xe1'},{'\xfa','\xb1'},{'\xbd','\x4b'},
    {'\xea','\x74'},{'\x00','\x00'},{'\xf0','\x52'},{'\xf4','\x72'},{'\xa5','\xd7'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xaa','\xbb'},{'\xac','\xd7'},{'\xcf','\xdf'},
    {'\xac','\xd8'},{'\xac','\xd6'},{'\x00','\x00'},{'\xac','\xd5'},{'\xd2','\xcc'},
    {'\xaf','\x71'},{'\x00','\x00'},{'\xfc','\xbf'},{'\xaf','\x72'},{'\xaf','\x73'},
    {'\x85','\xe6'},{'\x8d','\x69'},{'\x86','\xea'},{'\xb2','\xb0'},{'\xd6','\xa7'},
    {'\xb2','\xaf'},{'\x00','\x00'},{'\x87','\x49'},{'\x84','\xfb'},{'\x87','\xf7'},
    {'\x81','\xe7'},{'\xda','\xb9'},{'\xb2','\xb1'},{'\xb5','\x73'},{'\xde','\xd7'},
    {'\xb7','\xf8'},{'\xb7','\xf9'},{'\x00','\x00'},{'\xba','\xc9'},{'\x00','\x00'},
    {'\xba','\xca'},{'\xbd','\x4c'},{'\xbf','\x64'},{'\xea','\x75'},{'\xbf','\x63'},
    {'\x00','\x00'},{'\xed','\x79'},{'\xc0','\xfa'},{'\x00','\x00'},{'\xf0','\x53'},
    {'\xf4','\x73'},{'\xa5','\xd8'},{'\xa8','\x6e'},{'\xcd','\x78'},{'\xcd','\x77'},
    {'\xaa','\xbc'},{'\xcd','\x76'},{'\xaa','\xbd'},{'\xcd','\x79'},{'\x00','\x00'},
    {'\xcf','\xe5'},{'\xac','\xdb'},{'\xac','\xda'},{'\xcf','\xe7'},{'\xcf','\xe6'},
    {'\xac','\xdf'},{'\x00','\x00'},{'\xac','\xde'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xac','\xd9'},{'\x00','\x00'},{'\xcf','\xe1'},{'\xcf','\xe2'},{'\xcf','\xe3'},
    {'\x00','\x00'},{'\xac','\xe0'},{'\xcf','\xe0'},{'\xac','\xdc'},{'\xcf','\xe4'},
    {'\xac','\xdd'},{'\x92','\xb1'},{'\xfa','\xb2'},{'\x81','\xe8'},{'\x81','\xe9'},
    {'\xd2','\xcf'},{'\xd2','\xd3'},{'\xd2','\xd1'},{'\xd2','\xd0'},{'\x00','\x00'},
    {'\xd2','\xd4'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xd2','\xd5'},
    {'\xd2','\xd6'},{'\xd2','\xce'},{'\x00','\x00'},{'\xd2','\xcd'},{'\xfa','\xb3'},
    {'\xaf','\x75'},{'\xaf','\x76'},{'\x00','\x00'},{'\xd2','\xd7'},{'\xd2','\xd2'},
    {'\xfc','\xc0'},{'\xd6','\xb0'},{'\x8d','\xd2'},{'\xd2','\xd8'},{'\xaf','\x77'},
    {'\xaf','\x74'},{'\x00','\x00'},{'\xfc','\xc1'},{'\x00','\x00'},{'\xd6','\xaa'},
    {'\x00','\x00'},{'\xd6','\xa9'},{'\x00','\x00'},{'\xd6','\xab'},{'\xd6','\xac'},
    {'\xd6','\xae'},{'\xd6','\xad'},{'\xd6','\xb2'},{'\xb2','\xb5'},{'\xb2','\xb2'},
    {'\xb2','\xb6'},{'\xd6','\xa8'},{'\xb2','\xb7'},{'\xd6','\xb1'},{'\xb2','\xb4'},
    {'\xd6','\xaf'},{'\xb2','\xb3'},{'\x00','\x00'},{'\x95','\x4d'},{'\x85','\xe8'},
    {'\x00','\x00'},{'\xfa','\xb4'},{'\xda','\xbc'},{'\xda','\xbe'},{'\xda','\xba'},
    {'\xda','\xbb'},{'\x00','\x00'},{'\x00','\x00'},{'\xda','\xbf'},{'\xda','\xc1'},
    {'\xda','\xc2'},{'\xda','\xbd'},{'\xda','\xc0'},{'\xb5','\x74'},{'\x85','\xe7'},
    {'\x8a','\xde'},{'\xde','\xdb'},{'\x00','\x00'},{'\xde','\xe0'},{'\xde','\xd8'},
    {'\xde','\xdc'},{'\x00','\x00'},{'\x81','\xea'},{'\xde','\xe1'},{'\xde','\xdd'},
    {'\xb7','\xfa'},{'\xb8','\x43'},{'\x00','\x00'},{'\xb7','\xfd'},{'\xde','\xd9'},
    {'\xde','\xda'},{'\xba','\xce'},{'\xb8','\x46'},{'\xb7','\xfe'},{'\x00','\x00'},
    {'\xb8','\x44'},{'\xb7','\xfc'},{'\xde','\xdf'},{'\xb8','\x45'},{'\xde','\xde'},
    {'\xb8','\x41'},{'\xb7','\xfb'},{'\xb8','\x42'},{'\xde','\xe2'},{'\xe2','\xe6'},
    {'\xe2','\xe8'},{'\x00','\x00'},{'\x00','\x00'},{'\x81','\xeb'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x81','\xec'},{'\x81','\xed'},
    {'\xb8','\x40'},{'\x81','\xee'},{'\x81','\xef'},{'\xe2','\xe3'},{'\xba','\xcc'},
    {'\xe2','\xe9'},{'\xba','\xcd'},{'\xe2','\xe7'},{'\xe2','\xe2'},{'\xe2','\xe5'},
    {'\xe2','\xea'},{'\xba','\xcb'},{'\xe2','\xe4'},{'\x00','\x00'},{'\xbd','\x4e'},
    {'\xe6','\xbf'},{'\xe6','\xbe'},{'\x00','\x00'},{'\xbd','\x51'},{'\xbd','\x4f'},
    {'\xe6','\xbc'},{'\xbd','\x4d'},{'\xe6','\xbd'},{'\x00','\x00'},{'\xbd','\x50'},
    {'\x89','\x42'},{'\xfb','\x6b'},{'\x00','\x00'},{'\xea','\x7d'},{'\x00','\x00'},
    {'\xea','\xa1'},{'\x81','\xf0'},{'\xea','\x7e'},{'\xea','\x76'},{'\xea','\x7a'},
    {'\xea','\x79'},{'\xea','\x77'},{'\xbf','\x66'},{'\xbf','\x67'},{'\xbf','\x65'},
    {'\xea','\x78'},{'\xea','\x7b'},{'\xea','\x7c'},{'\x00','\x00'},{'\xbf','\x68'},
    {'\x00','\x00'},{'\xc1','\x40'},{'\xed','\xa3'},{'\x8d','\x7c'},{'\xc0','\xfc'},
    {'\xed','\x7b'},{'\xc0','\xfe'},{'\xc1','\x41'},{'\x00','\x00'},{'\x81','\xf1'},
    {'\xc0','\xfd'},{'\xed','\xa2'},{'\xed','\x7c'},{'\xc0','\xfb'},{'\xed','\xa1'},
    {'\xed','\x7a'},{'\xed','\x7e'},{'\xed','\x7d'},{'\x00','\x00'},{'\xfe','\x5a'},
    {'\xf0','\x55'},{'\xc2','\xa4'},{'\xc2','\xa5'},{'\xc2','\xa2'},{'\x81','\xf2'},
    {'\xc2','\xa3'},{'\x00','\x00'},{'\x00','\x00'},{'\xf0','\x54'},{'\x81','\xf3'},
    {'\xf2','\x7b'},{'\x81','\xf4'},{'\x00','\x00'},{'\xc3','\xa9'},{'\x00','\x00'},
    {'\xf2','\x79'},{'\xf2','\x7a'},{'\x81','\xf5'},{'\xf4','\x74'},{'\xf4','\x77'},
    {'\xf4','\x75'},{'\xf4','\x76'},{'\xf5','\xe0'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc4','\xef'},{'\xf7','\xeb'},{'\xf8','\xb4'},{'\x00','\x00'},{'\xc5','\xf7'},
    {'\xf8','\xf8'},{'\xf8','\xf9'},{'\xc6','\x66'},{'\xa5','\xd9'},{'\xac','\xe1'},
    {'\x81','\xf6'},{'\xda','\xc3'},{'\x00','\x00'},{'\xde','\xe3'},{'\x00','\x00'},
    {'\xa5','\xda'},{'\xa8','\x6f'},{'\x00','\x00'},{'\xaa','\xbe'},{'\x81','\xf7'},
    {'\xcf','\xe8'},{'\xcf','\xe9'},{'\xaf','\x78'},{'\x00','\x00'},{'\x89','\xfc'},
    {'\xda','\xc4'},{'\xb5','\x75'},{'\xb8','\x47'},{'\xc1','\x42'},{'\xed','\xa4'},
    {'\xf2','\x7c'},{'\xf4','\x78'},{'\xa5','\xdb'},{'\x81','\xf8'},{'\x00','\x00'},
    {'\x89','\xfe'},{'\xcd','\xa1'},{'\xcd','\x7a'},{'\xcd','\x7c'},{'\xcd','\x7e'},
    {'\xcd','\x7d'},{'\xcd','\x7b'},{'\xaa','\xbf'},{'\x8c','\x41'},{'\x8b','\xfe'},
    {'\x8e','\x78'},{'\x87','\xf9'},{'\xac','\xe2'},{'\xcf','\xf2'},{'\x00','\x00'},
    {'\xcf','\xed'},{'\xcf','\xea'},{'\x00','\x00'},{'\x96','\x41'},{'\xcf','\xf1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xac','\xe4'},{'\xac','\xe5'},{'\xcf','\xf0'},
    {'\xcf','\xef'},{'\xcf','\xee'},{'\xcf','\xeb'},{'\xcf','\xec'},{'\xcf','\xf3'},
    {'\xac','\xe3'},{'\x92','\xc5'},{'\x89','\x43'},{'\x8d','\xe3'},{'\xfa','\xb5'},
    {'\x00','\x00'},{'\x84','\xfc'},{'\x00','\x00'},{'\xfa','\xb6'},{'\xaf','\x7c'},
    {'\x81','\xf9'},{'\xaf','\xa4'},{'\xaf','\xa3'},{'\xd2','\xe1'},{'\xd2','\xdb'},
    {'\xd2','\xd9'},{'\x00','\x00'},{'\xaf','\xa1'},{'\xd6','\xb9'},{'\xaf','\x7a'},
    {'\xd2','\xde'},{'\xd2','\xe2'},{'\xd2','\xe4'},{'\xd2','\xe0'},{'\xd2','\xda'},
    {'\xaf','\xa2'},{'\xd2','\xdf'},{'\xd2','\xdd'},{'\xaf','\x79'},{'\xd2','\xe5'},
    {'\xaf','\xa5'},{'\xd2','\xe3'},{'\xaf','\x7d'},{'\xd2','\xdc'},{'\x00','\x00'},
    {'\xaf','\x7e'},{'\xaf','\x7b'},{'\xfa','\xb7'},{'\x8c','\x40'},{'\x90','\x42'},
    {'\xfa','\xb8'},{'\x81','\xfa'},{'\x8c','\x42'},{'\x82','\x5f'},{'\x8a','\xdf'},
    {'\x00','\x00'},{'\x81','\xfb'},{'\xb2','\xb9'},{'\x81','\xfc'},{'\xd6','\xba'},
    {'\x00','\x00'},{'\xfa','\xb9'},{'\xd6','\xb3'},{'\xd6','\xb5'},{'\xd6','\xb7'},
    {'\x81','\xfd'},{'\xd6','\xb8'},{'\xd6','\xb6'},{'\xb2','\xba'},{'\x00','\x00'},
    {'\xd6','\xbb'},{'\x81','\xfe'},{'\xd6','\xb4'},{'\xfc','\xc3'},{'\x96','\x4b'},
    {'\x86','\xeb'},{'\xfa','\xba'},{'\x8f','\x59'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xda','\xc8'},{'\xb5','\x76'},{'\xda','\xd0'},
    {'\x00','\x00'},{'\xda','\xc5'},{'\x00','\x00'},{'\xda','\xd1'},{'\x00','\x00'},
    {'\xda','\xc6'},{'\xda','\xc7'},{'\x96','\x4c'},{'\x00','\x00'},{'\xda','\xcf'},
    {'\xda','\xce'},{'\xda','\xcb'},{'\xb2','\xb8'},{'\xb5','\x77'},{'\xda','\xc9'},
    {'\xda','\xcc'},{'\xb5','\x78'},{'\xda','\xcd'},{'\xda','\xca'},{'\x94','\x54'},
    {'\x00','\x00'},{'\x94','\xb4'},{'\x00','\x00'},{'\x00','\x00'},{'\x8d','\x68'},
    {'\x00','\x00'},{'\xde','\xee'},{'\xfa','\xbb'},{'\xde','\xf2'},{'\xb8','\x4e'},
    {'\x00','\x00'},{'\xe2','\xf0'},{'\xb8','\x51'},{'\xde','\xf0'},{'\xf9','\xd6'},
    {'\x00','\x00'},{'\xde','\xed'},{'\xde','\xe8'},{'\xde','\xea'},{'\xde','\xeb'},
    {'\xde','\xe4'},{'\x96','\x4d'},{'\xb8','\x4d'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb8','\x4c'},{'\x8b','\xac'},{'\xb8','\x48'},{'\xde','\xe7'},{'\x00','\x00'},
    {'\xb8','\x4f'},{'\x00','\x00'},{'\xb8','\x50'},{'\xde','\xe6'},{'\xde','\xe9'},
    {'\xde','\xf1'},{'\xb8','\x4a'},{'\xb8','\x4b'},{'\xde','\xef'},{'\xde','\xe5'},
    {'\x89','\x44'},{'\x8e','\xed'},{'\x00','\x00'},{'\xe2','\xf2'},{'\xba','\xd0'},
    {'\xe2','\xf4'},{'\xde','\xec'},{'\xe2','\xf6'},{'\xba','\xd4'},{'\xe2','\xf7'},
    {'\xe2','\xf3'},{'\x00','\x00'},{'\xba','\xd1'},{'\xe2','\xef'},{'\xba','\xd3'},
    {'\xe2','\xec'},{'\xe2','\xf1'},{'\xe2','\xf5'},{'\xe2','\xee'},{'\x00','\x00'},
    {'\xfc','\xc7'},{'\xb8','\x49'},{'\x95','\xf0'},{'\xe2','\xeb'},{'\xba','\xd2'},
    {'\xe2','\xed'},{'\xfa','\xbc'},{'\x96','\x4e'},{'\x00','\x00'},{'\x96','\xcd'},
    {'\xfa','\xbd'},{'\xbd','\x54'},{'\xe6','\xc1'},{'\xbd','\x58'},{'\x00','\x00'},
    {'\xbd','\x56'},{'\x00','\x00'},{'\x00','\x00'},{'\xba','\xcf'},{'\x00','\x00'},
    {'\xe6','\xc8'},{'\xe6','\xc9'},{'\xbd','\x53'},{'\xfa','\xbe'},{'\x96','\x4f'},
    {'\xe6','\xc7'},{'\xe6','\xca'},{'\xbd','\x55'},{'\xbd','\x52'},{'\xe6','\xc3'},
    {'\xe6','\xc0'},{'\xe6','\xc5'},{'\xe6','\xc2'},{'\xbd','\x59'},{'\xe6','\xc4'},
    {'\x96','\x50'},{'\xfc','\xc4'},{'\xe6','\xc6'},{'\xbd','\x57'},{'\x00','\x00'},
    {'\x96','\x51'},{'\xfc','\xc5'},{'\xfa','\xbf'},{'\xbf','\x6a'},{'\xea','\xa8'},
    {'\x00','\x00'},{'\xea','\xa2'},{'\xea','\xa6'},{'\xea','\xac'},{'\xea','\xad'},
    {'\xea','\xa9'},{'\xea','\xaa'},{'\xea','\xa7'},{'\x96','\x54'},{'\xea','\xa4'},
    {'\x00','\x00'},{'\xbf','\x6c'},{'\xbf','\x69'},{'\xea','\xa3'},{'\xea','\xa5'},
    {'\x00','\x00'},{'\xbf','\x6b'},{'\xea','\xab'},{'\x96','\x55'},{'\xc1','\x46'},
    {'\x96','\x56'},{'\x96','\x57'},{'\xed','\xaa'},{'\xed','\xa5'},{'\xc1','\x45'},
    {'\x96','\x58'},{'\x00','\x00'},{'\xc1','\x43'},{'\x00','\x00'},{'\xed','\xac'},
    {'\xc1','\x44'},{'\xed','\xa8'},{'\xed','\xa9'},{'\xed','\xa6'},{'\xed','\xad'},
    {'\xf0','\x56'},{'\x00','\x00'},{'\xc1','\x47'},{'\xed','\xa7'},{'\x00','\x00'},
    {'\xed','\xae'},{'\xed','\xab'},{'\xfb','\xa8'},{'\xfa','\xc0'},{'\x00','\x00'},
    {'\xf0','\x5a'},{'\x00','\x00'},{'\x00','\x00'},{'\xf0','\x57'},{'\x00','\x00'},
    {'\xc2','\xa6'},{'\x00','\x00'},{'\xf0','\x5b'},{'\xf0','\x5d'},{'\xf0','\x5c'},
    {'\xf0','\x58'},{'\xf0','\x59'},{'\x00','\x00'},{'\x00','\x00'},{'\xf2','\xa3'},
    {'\x00','\x00'},{'\xc3','\xaa'},{'\x00','\x00'},{'\xf2','\x7e'},{'\xf2','\xa2'},
    {'\xf2','\x7d'},{'\xf2','\xa4'},{'\x00','\x00'},{'\x00','\x00'},{'\xf2','\xa1'},
    {'\x00','\x00'},{'\xf4','\x7a'},{'\xf4','\x7d'},{'\xf4','\x79'},{'\xc4','\x71'},
    {'\xf4','\x7b'},{'\xf4','\x7c'},{'\xf4','\x7e'},{'\xc4','\x72'},{'\xc4','\x74'},
    {'\xc4','\x73'},{'\xf5','\xe1'},{'\xfe','\x77'},{'\xf5','\xe3'},{'\xfa','\xc1'},
    {'\xf5','\xe2'},{'\x96','\x59'},{'\x96','\x5a'},{'\xfa','\xc2'},{'\xf6','\xf6'},
    {'\x96','\x5b'},{'\x00','\x00'},{'\xf8','\xb5'},{'\xf8','\xfa'},{'\xa5','\xdc'},
    {'\xfa','\xc3'},{'\x8a','\xe0'},{'\xcb','\x72'},{'\xaa','\xc0'},{'\xcd','\xa3'},
    {'\xaa','\xc1'},{'\xaa','\xc2'},{'\xcd','\xa2'},{'\x00','\x00'},{'\xcf','\xf8'},
    {'\xcf','\xf7'},{'\xac','\xe6'},{'\xac','\xe9'},{'\xac','\xe8'},{'\xac','\xe7'},
    {'\xcf','\xf4'},{'\xcf','\xf6'},{'\xcf','\xf5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xd2','\xe8'},{'\xaf','\xa7'},{'\xd2','\xec'},{'\xd2','\xeb'},{'\xd2','\xea'},
    {'\xd2','\xe6'},{'\xaf','\xa6'},{'\xaf','\xaa'},{'\xaf','\xad'},{'\x96','\x5c'},
    {'\x96','\x5e'},{'\xaf','\xae'},{'\xd2','\xe7'},{'\xd2','\xe9'},{'\xaf','\xac'},
    {'\xaf','\xab'},{'\xaf','\xa9'},{'\xaf','\xa8'},{'\xd6','\xc2'},{'\x8f','\xbe'},
    {'\xd6','\xc0'},{'\xd6','\xbc'},{'\xb2','\xbb'},{'\x00','\x00'},{'\xd6','\xbd'},
    {'\xb2','\xbc'},{'\xd6','\xbe'},{'\xd6','\xbf'},{'\xd6','\xc1'},{'\x00','\x00'},
    {'\xb2','\xbd'},{'\x00','\x00'},{'\x86','\xec'},{'\xda','\xd5'},{'\x96','\x5f'},
    {'\xda','\xd4'},{'\xda','\xd3'},{'\xda','\xd2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x82','\x70'},{'\x86','\xed'},{'\xde','\xf6'},{'\xb8','\x52'},{'\x00','\x00'},
    {'\xde','\xf3'},{'\xde','\xf5'},{'\x96','\x60'},{'\xb8','\x53'},{'\xfa','\xc4'},
    {'\xb8','\x54'},{'\xde','\xf4'},{'\x96','\x61'},{'\x82','\x77'},{'\x93','\x50'},
    {'\x96','\x62'},{'\x96','\x63'},{'\xe3','\x41'},{'\x00','\x00'},{'\xe2','\xf9'},
    {'\xe2','\xfa'},{'\x00','\x00'},{'\xba','\xd7'},{'\xba','\xd5'},{'\xba','\xd6'},
    {'\xe3','\x43'},{'\x96','\x64'},{'\xe3','\x42'},{'\xe2','\xfe'},{'\xe2','\xfd'},
    {'\xe2','\xfc'},{'\xe2','\xfb'},{'\xe3','\x40'},{'\xe2','\xf8'},{'\x96','\x65'},
    {'\xe6','\xcb'},{'\xe6','\xd0'},{'\xe6','\xce'},{'\xfa','\xc5'},{'\x00','\x00'},
    {'\x96','\x66'},{'\xe6','\xcd'},{'\xe6','\xcc'},{'\xe6','\xcf'},{'\x00','\x00'},
    {'\xea','\xae'},{'\x96','\x67'},{'\xbf','\x6d'},{'\xc1','\x48'},{'\xed','\xb0'},
    {'\xfc','\xca'},{'\xc1','\x49'},{'\xed','\xaf'},{'\xf0','\x5f'},{'\xf0','\x5e'},
    {'\xc2','\xa7'},{'\x00','\x00'},{'\xf2','\xa5'},{'\xc3','\xab'},{'\xf4','\xa1'},
    {'\xc5','\xa1'},{'\xf6','\xf7'},{'\x00','\x00'},{'\xf8','\xb7'},{'\xf8','\xb6'},
    {'\xc9','\xa8'},{'\xac','\xea'},{'\xac','\xeb'},{'\xd6','\xc3'},{'\x00','\x00'},
    {'\xb8','\x56'},{'\xa5','\xdd'},{'\xa8','\x72'},{'\xa8','\x71'},{'\xa8','\x70'},
    {'\x00','\x00'},{'\xfa','\xc6'},{'\xfb','\xa9'},{'\xcd','\xa4'},{'\x84','\xfd'},
    {'\x00','\x00'},{'\xaa','\xc4'},{'\xaa','\xc3'},{'\x9d','\xce'},{'\xac','\xee'},
    {'\xfc','\xa6'},{'\xcf','\xfa'},{'\xcf','\xfd'},{'\xcf','\xfb'},{'\x00','\x00'},
    {'\xac','\xec'},{'\xac','\xed'},{'\x00','\x00'},{'\xfc','\xcc'},{'\xcf','\xf9'},
    {'\xcf','\xfc'},{'\x00','\x00'},{'\xaf','\xb5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd2','\xf3'},{'\xd2','\xf5'},{'\xd2','\xf4'},{'\xaf','\xb2'},
    {'\xd2','\xef'},{'\xfa','\xc7'},{'\x96','\x68'},{'\xaf','\xb0'},{'\xaf','\xaf'},
    {'\x00','\x00'},{'\xaf','\xb3'},{'\xaf','\xb1'},{'\x00','\x00'},{'\xaf','\xb4'},
    {'\xd2','\xf2'},{'\xd2','\xed'},{'\xd2','\xee'},{'\xd2','\xf1'},{'\xd2','\xf0'},
    {'\x85','\xb8'},{'\x86','\xef'},{'\x96','\x69'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x96','\x6a'},{'\x00','\x00'},{'\xd6','\xc6'},{'\xd6','\xc7'},{'\xd6','\xc5'},
    {'\x00','\x00'},{'\xd6','\xc4'},{'\xb2','\xbe'},{'\x00','\x00'},{'\x8a','\xe2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb5','\x7d'},{'\x00','\x00'},{'\xda','\xd6'},
    {'\xda','\xd8'},{'\xda','\xda'},{'\xb5','\x7c'},{'\xfa','\xc8'},{'\x00','\x00'},
    {'\xb5','\x7a'},{'\x00','\x00'},{'\xda','\xd7'},{'\xb5','\x7b'},{'\xda','\xd9'},
    {'\xb5','\x79'},{'\xfa','\xc9'},{'\x00','\x00'},{'\xdf','\x41'},{'\xde','\xf7'},
    {'\xde','\xfa'},{'\xde','\xfe'},{'\xb8','\x5a'},{'\xde','\xfc'},{'\x00','\x00'},
    {'\xde','\xfb'},{'\xde','\xf8'},{'\xde','\xf9'},{'\xb8','\x58'},{'\xdf','\x40'},
    {'\xb8','\x57'},{'\x00','\x00'},{'\xb8','\x5c'},{'\xb8','\x5b'},{'\xb8','\x59'},
    {'\x00','\x00'},{'\xde','\xfd'},{'\x89','\x47'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe3','\x49'},{'\x00','\x00'},{'\xe3','\x48'},{'\x00','\x00'},{'\x96','\x6b'},
    {'\xe3','\x44'},{'\x00','\x00'},{'\xfc','\xce'},{'\xba','\xd8'},{'\xe3','\x47'},
    {'\xe3','\x46'},{'\xba','\xd9'},{'\x93','\xa6'},{'\x8b','\xae'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xbd','\x5e'},{'\x00','\x00'},{'\xe6','\xd2'},
    {'\x96','\x6c'},{'\xbd','\x5f'},{'\xbd','\x5b'},{'\xbd','\x5d'},{'\xfc','\xcf'},
    {'\xbd','\x5a'},{'\xbd','\x5c'},{'\x00','\x00'},{'\x92','\xf9'},{'\xfa','\xca'},
    {'\xea','\xaf'},{'\x96','\x6d'},{'\xbf','\x70'},{'\xea','\xb1'},{'\xea','\xb0'},
    {'\xfc','\xd0'},{'\xe3','\x45'},{'\xbf','\x72'},{'\xbf','\x71'},{'\xbf','\x6e'},
    {'\xbf','\x6f'},{'\x92','\x53'},{'\xfa','\xcb'},{'\x8a','\xe1'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xed','\xb5'},{'\x00','\x00'},{'\xed','\xb3'},{'\xc1','\x4a'},
    {'\xed','\xb4'},{'\x00','\x00'},{'\xed','\xb6'},{'\xed','\xb2'},{'\xed','\xb1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf0','\x60'},{'\xc2','\xaa'},{'\xc2','\xa8'},
    {'\xc2','\xa9'},{'\x82','\x67'},{'\x00','\x00'},{'\x96','\x6e'},{'\x00','\x00'},
    {'\xf2','\xa6'},{'\xf2','\xa7'},{'\xc3','\xad'},{'\x00','\x00'},{'\xc3','\xac'},
    {'\xf4','\xa3'},{'\xf4','\xa4'},{'\xf4','\xa2'},{'\x00','\x00'},{'\xf6','\xf8'},
    {'\xf6','\xf9'},{'\x00','\x00'},{'\x00','\x00'},{'\xa5','\xde'},{'\xca','\x48'},
    {'\xa8','\x73'},{'\x87','\xfb'},{'\xcd','\xa5'},{'\xaa','\xc6'},{'\xaa','\xc5'},
    {'\xcd','\xa6'},{'\x00','\x00'},{'\xfc','\x42'},{'\xd0','\x40'},{'\xac','\xef'},
    {'\xcf','\xfe'},{'\xac','\xf0'},{'\x00','\x00'},{'\x8c','\xfa'},{'\xaf','\xb6'},
    {'\xd2','\xf8'},{'\xd2','\xf6'},{'\xd2','\xfc'},{'\xaf','\xb7'},{'\xd2','\xf7'},
    {'\xd2','\xfb'},{'\xd2','\xf9'},{'\xd2','\xfa'},{'\x8a','\xe4'},{'\x00','\x00'},
    {'\xd6','\xc8'},{'\xd6','\xca'},{'\x87','\xfa'},{'\xb2','\xbf'},{'\x93','\x58'},
    {'\xd6','\xc9'},{'\xb2','\xc0'},{'\xb5','\xa2'},{'\xb5','\xa1'},{'\xb5','\x7e'},
    {'\xda','\xdb'},{'\x00','\x00'},{'\x00','\x00'},{'\x8a','\xe3'},{'\x86','\xf1'},
    {'\xdf','\x44'},{'\xb8','\x5d'},{'\xb8','\x5e'},{'\x00','\x00'},{'\xdf','\x43'},
    {'\xdf','\x42'},{'\x00','\x00'},{'\x89','\x48'},{'\x8c','\x43'},{'\x00','\x00'},
    {'\xe3','\x4a'},{'\xba','\xdb'},{'\xba','\xda'},{'\xe3','\x4b'},{'\xe3','\x4c'},
    {'\x8e','\xee'},{'\xbd','\x61'},{'\xbd','\x60'},{'\xfe','\xa7'},{'\xea','\xb5'},
    {'\xe6','\xd3'},{'\xe6','\xd5'},{'\xe6','\xd4'},{'\xea','\xb4'},{'\xea','\xb2'},
    {'\xea','\xb6'},{'\xea','\xb3'},{'\x00','\x00'},{'\xbf','\x73'},{'\xfc','\x44'},
    {'\x96','\x6f'},{'\x00','\x00'},{'\xed','\xb7'},{'\xc1','\x4b'},{'\xed','\xb8'},
    {'\xed','\xb9'},{'\x96','\x70'},{'\xfa','\xcc'},{'\xc2','\xab'},{'\xc2','\xac'},
    {'\x00','\x00'},{'\xc4','\x75'},{'\xfd','\xe5'},{'\x96','\x71'},{'\xc5','\xd1'},
    {'\xa5','\xdf'},{'\x00','\x00'},{'\x94','\xb5'},{'\x00','\x00'},{'\x94','\xb6'},
    {'\x00','\x00'},{'\xd0','\x41'},{'\xfa','\xcd'},{'\x94','\xb8'},{'\x00','\x00'},
    {'\x94','\xb7'},{'\x88','\x67'},{'\x00','\x00'},{'\xd2','\xfd'},{'\xaf','\xb8'},
    {'\xfc','\xd2'},{'\x96','\x72'},{'\x93','\xe2'},{'\xfc','\xd1'},{'\x8c','\x44'},
    {'\xb3','\xba'},{'\xb3','\xb9'},{'\x94','\xb9'},{'\xfa','\xce'},{'\xb5','\xa4'},
    {'\xda','\xdd'},{'\xb5','\xa3'},{'\xda','\xdc'},{'\xfa','\xcf'},{'\x00','\x00'},
    {'\x96','\x73'},{'\x82','\x6d'},{'\xdf','\x45'},{'\x00','\x00'},{'\xba','\xdc'},
    {'\xe3','\x4d'},{'\xba','\xdd'},{'\x94','\xba'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc4','\x76'},{'\xf4','\xa5'},
    {'\xfa','\xd0'},{'\xa6','\xcb'},{'\xaa','\xc7'},{'\xcd','\xa7'},{'\x00','\x00'},
    {'\xac','\xf2'},{'\x96','\x74'},{'\xac','\xf1'},{'\xd0','\x42'},{'\xd0','\x43'},
    {'\x94','\xbb'},{'\x89','\x49'},{'\xd3','\x40'},{'\xd3','\x42'},{'\xaf','\xb9'},
    {'\x00','\x00'},{'\xd3','\x44'},{'\xd3','\x47'},{'\xd3','\x45'},{'\x85','\x41'},
    {'\x96','\x75'},{'\x00','\x00'},{'\xd3','\x46'},{'\xd3','\x43'},{'\xd2','\xfe'},
    {'\xaf','\xba'},{'\xd3','\x48'},{'\xd3','\x41'},{'\x85','\x40'},{'\x85','\xec'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xd6','\xd3'},{'\xb2','\xc6'},{'\xd6','\xdc'},
    {'\xb2','\xc3'},{'\x00','\x00'},{'\xd6','\xd5'},{'\xb2','\xc7'},{'\xfc','\xdc'},
    {'\xb2','\xc1'},{'\x00','\x00'},{'\xd6','\xd0'},{'\xd6','\xdd'},{'\xd6','\xd1'},
    {'\xd6','\xce'},{'\xb2','\xc5'},{'\x96','\x76'},{'\xb2','\xc2'},{'\x96','\x77'},
    {'\xd6','\xd4'},{'\xd6','\xd7'},{'\xb2','\xc4'},{'\xd6','\xd8'},{'\xb2','\xc8'},
    {'\xd6','\xd9'},{'\xd6','\xcf'},{'\xd6','\xd6'},{'\xd6','\xda'},{'\xd6','\xd2'},
    {'\xd6','\xcd'},{'\xd6','\xcb'},{'\xfa','\xd1'},{'\x00','\x00'},{'\xd6','\xdb'},
    {'\xfe','\x64'},{'\x86','\xf2'},{'\xda','\xdf'},{'\x8c','\xd7'},{'\x00','\x00'},
    {'\x90','\x7a'},{'\x00','\x00'},{'\xda','\xe4'},{'\x00','\x00'},{'\x96','\x78'},
    {'\x96','\x79'},{'\xda','\xe0'},{'\xda','\xe6'},{'\xb5','\xa7'},{'\xd6','\xcc'},
    {'\xda','\xe1'},{'\xb5','\xa5'},{'\xda','\xde'},{'\xb5','\xac'},{'\xda','\xe2'},
    {'\xb5','\xab'},{'\xda','\xe3'},{'\xb5','\xad'},{'\xb5','\xa8'},{'\xb5','\xae'},
    {'\xb5','\xa9'},{'\x00','\x00'},{'\xb5','\xaa'},{'\x96','\x7a'},{'\xb5','\xa6'},
    {'\x00','\x00'},{'\xda','\xe5'},{'\x00','\x00'},{'\x8f','\x5b'},{'\x89','\x4a'},
    {'\x00','\x00'},{'\x86','\xf3'},{'\x00','\x00'},{'\x00','\x00'},{'\xb8','\x61'},
    {'\xdf','\x50'},{'\xfa','\xd2'},{'\xdf','\x53'},{'\xdf','\x47'},{'\xdf','\x4c'},
    {'\xdf','\x46'},{'\xb8','\x63'},{'\x00','\x00'},{'\xdf','\x4a'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xfa','\xd3'},{'\xdf','\x48'},{'\xb8','\x62'},{'\x96','\x7b'},
    {'\xdf','\x4f'},{'\xdf','\x4e'},{'\xdf','\x4b'},{'\xdf','\x4d'},{'\xdf','\x49'},
    {'\xba','\xe1'},{'\xdf','\x52'},{'\xb8','\x5f'},{'\xdf','\x51'},{'\x8c','\x45'},
    {'\xfa','\xd4'},{'\xfa','\xd5'},{'\x00','\x00'},{'\x00','\x00'},{'\x8b','\xaf'},
    {'\x00','\x00'},{'\x8a','\xe9'},{'\x00','\x00'},{'\xe3','\x5d'},{'\x00','\x00'},
    {'\xba','\xe8'},{'\xe3','\x58'},{'\x82','\x7a'},{'\xba','\xe7'},{'\xe3','\x4e'},
    {'\x00','\x00'},{'\xe3','\x50'},{'\xba','\xe0'},{'\xe3','\x55'},{'\xe3','\x54'},
    {'\xe3','\x57'},{'\xba','\xe5'},{'\xe3','\x52'},{'\xe3','\x51'},{'\xfc','\xdd'},
    {'\x00','\x00'},{'\xba','\xe4'},{'\xba','\xdf'},{'\xe3','\x53'},{'\xba','\xe2'},
    {'\xe3','\x59'},{'\xe3','\x5b'},{'\xfa','\xd6'},{'\xe3','\x56'},{'\xe3','\x4f'},
    {'\xba','\xe3'},{'\xfa','\xd7'},{'\xfa','\xd8'},{'\xbd','\x69'},{'\xba','\xde'},
    {'\xfa','\xd9'},{'\xfc','\xde'},{'\xe3','\x5c'},{'\x00','\x00'},{'\x8f','\x5a'},
    {'\xfa','\xda'},{'\x90','\x59'},{'\x8d','\x71'},{'\x8a','\xe7'},{'\x8a','\xe5'},
    {'\xe6','\xd9'},{'\xbd','\x62'},{'\x00','\x00'},{'\xe6','\xdb'},{'\x00','\x00'},
    {'\xbd','\x63'},{'\x96','\x7c'},{'\x00','\x00'},{'\xbd','\x65'},{'\xe6','\xde'},
    {'\x00','\x00'},{'\xe6','\xd6'},{'\xba','\xe6'},{'\xe6','\xdc'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xe6','\xd8'},{'\x00','\x00'},
    {'\xb8','\x60'},{'\xbd','\x68'},{'\x00','\x00'},{'\x00','\x00'},{'\xbd','\x64'},
    {'\x00','\x00'},{'\xbd','\x66'},{'\xbd','\x67'},{'\x00','\x00'},{'\xbf','\x76'},
    {'\xe6','\xdd'},{'\xe6','\xd7'},{'\xbd','\x6a'},{'\x00','\x00'},{'\xe6','\xda'},
    {'\xfc','\xdf'},{'\x96','\xd0'},{'\x8a','\xe8'},{'\x00','\x00'},{'\x8a','\x40'},
    {'\xea','\xc0'},{'\xea','\xbb'},{'\x00','\x00'},{'\x00','\x00'},{'\xea','\xc5'},
    {'\xbf','\x74'},{'\xea','\xbd'},{'\xbf','\x78'},{'\xea','\xc3'},{'\xea','\xba'},
    {'\xea','\xb7'},{'\xea','\xc6'},{'\xc1','\x51'},{'\xbf','\x79'},{'\xea','\xc2'},
    {'\xea','\xb8'},{'\xbf','\x77'},{'\xea','\xbc'},{'\xbf','\x7b'},{'\xea','\xb9'},
    {'\xea','\xbe'},{'\xbf','\x7a'},{'\xea','\xc1'},{'\xea','\xc4'},{'\x96','\xd1'},
    {'\x82','\xa1'},{'\x8c','\x46'},{'\x00','\x00'},{'\xed','\xcb'},{'\xed','\xcc'},
    {'\xed','\xbc'},{'\xed','\xc3'},{'\xed','\xc1'},{'\x00','\x00'},{'\xfa','\xdb'},
    {'\xc1','\x4f'},{'\xed','\xc8'},{'\xea','\xbf'},{'\x96','\xd2'},{'\xed','\xbf'},
    {'\xfc','\xe1'},{'\xed','\xc9'},{'\xc1','\x4e'},{'\xed','\xbe'},{'\xed','\xbd'},
    {'\xed','\xc7'},{'\xed','\xc4'},{'\xed','\xc6'},{'\x00','\x00'},{'\xed','\xba'},
    {'\xed','\xca'},{'\xc1','\x4c'},{'\x00','\x00'},{'\xed','\xc5'},{'\xed','\xce'},
    {'\xed','\xc2'},{'\xc1','\x50'},{'\xc1','\x4d'},{'\xed','\xc0'},{'\xed','\xbb'},
    {'\xed','\xcd'},{'\xbf','\x75'},{'\xfa','\xdc'},{'\x94','\xbc'},{'\xfa','\xdd'},
    {'\x96','\xd3'},{'\x90','\x77'},{'\x94','\xbd'},{'\x00','\x00'},{'\xf0','\x63'},
    {'\x00','\x00'},{'\x96','\xd4'},{'\xf0','\x61'},{'\xf0','\x67'},{'\xc2','\xb0'},
    {'\xf0','\x65'},{'\xf0','\x64'},{'\xc2','\xb2'},{'\xf0','\x6a'},{'\xc2','\xb1'},
    {'\x00','\x00'},{'\xf0','\x6b'},{'\xf0','\x68'},{'\xc2','\xae'},{'\xf0','\x69'},
    {'\xf0','\x62'},{'\xc2','\xaf'},{'\xc2','\xad'},{'\xf2','\xab'},{'\xf0','\x66'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf0','\x6c'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf2','\xa8'},{'\x00','\x00'},{'\x96','\xd5'},{'\x00','\x00'},{'\xc3','\xb2'},
    {'\xc3','\xb0'},{'\xf2','\xaa'},{'\x00','\x00'},{'\xf2','\xac'},{'\xf2','\xa9'},
    {'\xc3','\xb1'},{'\xc3','\xae'},{'\xc3','\xaf'},{'\xc3','\xb3'},{'\x8c','\xd8'},
    {'\xfc','\xe2'},{'\xc4','\x78'},{'\x96','\xd6'},{'\xf4','\xaa'},{'\x00','\x00'},
    {'\xf4','\xa9'},{'\xf4','\xa7'},{'\xf4','\xa6'},{'\xf4','\xa8'},{'\x00','\x00'},
    {'\xc4','\x77'},{'\xc4','\x79'},{'\x00','\x00'},{'\xfa','\xde'},{'\xc4','\xf0'},
    {'\xfc','\xe3'},{'\x00','\x00'},{'\xf5','\xe5'},{'\xf5','\xe4'},{'\x00','\x00'},
    {'\xfa','\xdf'},{'\xf6','\xfa'},{'\xfa','\xe0'},{'\xf6','\xfc'},{'\xf6','\xfe'},
    {'\xf6','\xfd'},{'\xf6','\xfb'},{'\xfc','\xe4'},{'\x00','\x00'},{'\xc5','\xa3'},
    {'\xc5','\xa2'},{'\x00','\x00'},{'\x00','\x00'},{'\xc5','\xd3'},{'\xc5','\xd2'},
    {'\xc5','\xd4'},{'\xf7','\xed'},{'\xf7','\xec'},{'\x00','\x00'},{'\xf8','\xfb'},
    {'\xf8','\xb8'},{'\xf8','\xfc'},{'\xc6','\x58'},{'\x96','\xd7'},{'\xc6','\x59'},
    {'\xf9','\x6d'},{'\xfc','\xe5'},{'\x00','\x00'},{'\xc6','\x7e'},{'\xa6','\xcc'},
    {'\x90','\x5a'},{'\xcd','\xa8'},{'\x00','\x00'},{'\x00','\x00'},{'\xd0','\x45'},
    {'\xd0','\x46'},{'\xd0','\x44'},{'\x8b','\xdd'},{'\x83','\x5e'},{'\xac','\xf3'},
    {'\xfc','\xe6'},{'\xd0','\x47'},{'\xd0','\x48'},{'\xd0','\x49'},{'\x94','\x43'},
    {'\xfc','\xe8'},{'\xd3','\x49'},{'\xd3','\x4f'},{'\xfc','\xe7'},{'\x00','\x00'},
    {'\xd3','\x4d'},{'\xaf','\xbb'},{'\xd3','\x4b'},{'\x92','\xf7'},{'\xd3','\x4c'},
    {'\xd3','\x4e'},{'\x96','\xd8'},{'\x00','\x00'},{'\x94','\xbe'},{'\xd3','\x4a'},
    {'\xb2','\xc9'},{'\x00','\x00'},{'\xd6','\xde'},{'\xb2','\xcb'},{'\xd6','\xe0'},
    {'\xb2','\xca'},{'\xd6','\xdf'},{'\x00','\x00'},{'\x00','\x00'},{'\x92','\xe0'},
    {'\x90','\x7b'},{'\x90','\x43'},{'\xda','\xe8'},{'\xb5','\xaf'},{'\x00','\x00'},
    {'\xda','\xea'},{'\xda','\xe7'},{'\xd6','\xe1'},{'\x85','\xed'},{'\xb5','\xb0'},
    {'\xfe','\x63'},{'\xf9','\xdb'},{'\xda','\xe9'},{'\x00','\x00'},{'\x8a','\x41'},
    {'\xfa','\xe1'},{'\xfc','\xe9'},{'\x94','\xbf'},{'\x8a','\xea'},{'\xdf','\x56'},
    {'\x00','\x00'},{'\xb8','\x64'},{'\xdf','\x54'},{'\xb8','\x65'},{'\xdf','\x55'},
    {'\xb8','\x66'},{'\x00','\x00'},{'\x00','\x00'},{'\x96','\xd9'},{'\xba','\xe9'},
    {'\xe3','\x61'},{'\xe3','\x5e'},{'\xe3','\x60'},{'\xba','\xea'},{'\xba','\xeb'},
    {'\xe3','\x5f'},{'\x94','\xc0'},{'\x8a','\x43'},{'\xfc','\xeb'},{'\x96','\xda'},
    {'\x00','\x00'},{'\xe6','\xdf'},{'\x00','\x00'},{'\xfc','\xea'},{'\xe6','\xe0'},
    {'\x95','\xb2'},{'\xbd','\x6b'},{'\xe6','\xe2'},{'\xe6','\xe1'},{'\xa0','\x54'},
    {'\xa2','\x61'},{'\x00','\x00'},{'\xea','\xca'},{'\xea','\xcb'},{'\xea','\xc7'},
    {'\xfb','\x7e'},{'\xea','\xc8'},{'\xbf','\x7c'},{'\xbf','\x7d'},{'\xea','\xc9'},
    {'\x94','\xc1'},{'\xc1','\x57'},{'\xfc','\xed'},{'\x00','\x00'},{'\xc1','\x53'},
    {'\xc1','\x58'},{'\xc1','\x54'},{'\xc1','\x56'},{'\xc1','\x52'},{'\x00','\x00'},
    {'\xc1','\x55'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x96','\xdb'},
    {'\xc2','\xb3'},{'\xed','\xcf'},{'\x00','\x00'},{'\xf2','\xae'},{'\x00','\x00'},
    {'\xf2','\xad'},{'\x96','\xdc'},{'\xf4','\xab'},{'\xc4','\x7a'},{'\xc4','\x7b'},
    {'\xf7','\x41'},{'\xf5','\xe6'},{'\x96','\xdd'},{'\xf7','\x40'},{'\x96','\xde'},
    {'\xf8','\xfd'},{'\xf9','\xa4'},{'\xa6','\xcd'},{'\x96','\xdf'},{'\xfa','\xe2'},
    {'\xa8','\x74'},{'\x96','\xe1'},{'\xcd','\xa9'},{'\xaa','\xc8'},{'\x00','\x00'},
    {'\xac','\xf6'},{'\xd0','\x4c'},{'\xac','\xf4'},{'\xd0','\x4a'},{'\xac','\xf9'},
    {'\xac','\xf5'},{'\xac','\xfa'},{'\xac','\xf8'},{'\xd0','\x4b'},{'\xac','\xf7'},
    {'\xaf','\xbf'},{'\xaf','\xbe'},{'\xd3','\x5a'},{'\xaf','\xc7'},{'\xd3','\x53'},
    {'\xd3','\x59'},{'\xaf','\xc3'},{'\xd3','\x52'},{'\xd3','\x58'},{'\xd3','\x56'},
    {'\xaf','\xc2'},{'\xaf','\xc4'},{'\xd3','\x55'},{'\xaf','\xbd'},{'\xd3','\x54'},
    {'\xaf','\xc8'},{'\xaf','\xc5'},{'\xaf','\xc9'},{'\xaf','\xc6'},{'\xd3','\x51'},
    {'\xd3','\x50'},{'\xd3','\x57'},{'\xaf','\xc0'},{'\xaf','\xbc'},{'\xaf','\xc1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x95','\xe2'},{'\x00','\x00'},{'\x86','\xfa'},
    {'\xd6','\xf0'},{'\xd6','\xe9'},{'\x00','\x00'},{'\xb5','\xb5'},{'\xd6','\xe8'},
    {'\x00','\x00'},{'\xb2','\xcf'},{'\xb2','\xd6'},{'\xb2','\xd3'},{'\xb2','\xd9'},
    {'\xb2','\xd8'},{'\xb2','\xd4'},{'\x00','\x00'},{'\xd6','\xe2'},{'\xd6','\xe5'},
    {'\x00','\x00'},{'\xd6','\xe4'},{'\xb2','\xd0'},{'\xd6','\xe6'},{'\xd6','\xef'},
    {'\xb2','\xd1'},{'\xd6','\xe3'},{'\xd6','\xec'},{'\xd6','\xed'},{'\xb2','\xd2'},
    {'\xd6','\xea'},{'\xb2','\xd7'},{'\xb2','\xcd'},{'\xb2','\xd5'},{'\xd6','\xe7'},
    {'\xb2','\xcc'},{'\xd6','\xeb'},{'\xfa','\xe3'},{'\x00','\x00'},{'\xd6','\xee'},
    {'\xfa','\xe4'},{'\x92','\xab'},{'\xfc','\xef'},{'\xda','\xfb'},{'\xda','\xf2'},
    {'\xb5','\xb2'},{'\xda','\xf9'},{'\xda','\xf6'},{'\xda','\xee'},{'\xda','\xf7'},
    {'\xb5','\xb4'},{'\xda','\xef'},{'\x00','\x00'},{'\xda','\xeb'},{'\x00','\x00'},
    {'\xfc','\xf0'},{'\xb8','\x6c'},{'\xda','\xf4'},{'\xfe','\x60'},{'\xb5','\xb1'},
    {'\xda','\xfa'},{'\x00','\x00'},{'\xb5','\xb8'},{'\xb5','\xba'},{'\xda','\xed'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb5','\xb9'},{'\xda','\xf0'},{'\xb5','\xb3'},
    {'\xda','\xf8'},{'\xda','\xf1'},{'\xda','\xf5'},{'\x00','\x00'},{'\xda','\xf3'},
    {'\xb5','\xb6'},{'\xda','\xec'},{'\xb5','\xbb'},{'\xb2','\xce'},{'\xb5','\xb7'},
    {'\xb5','\xbc'},{'\x00','\x00'},{'\x92','\x5b'},{'\x93','\x46'},{'\xfa','\xe5'},
    {'\x00','\x00'},{'\xb8','\x68'},{'\xdf','\x5d'},{'\xdf','\x5f'},{'\xdf','\x61'},
    {'\xdf','\x65'},{'\x00','\x00'},{'\xdf','\x5b'},{'\xdf','\x59'},{'\xb8','\x6a'},
    {'\x00','\x00'},{'\xdf','\x60'},{'\xdf','\x64'},{'\xdf','\x5c'},{'\xdf','\x58'},
    {'\x00','\x00'},{'\xdf','\x57'},{'\x95','\x68'},{'\x00','\x00'},{'\x96','\xe2'},
    {'\xdf','\x62'},{'\xdf','\x5a'},{'\xdf','\x5e'},{'\xb8','\x6b'},{'\x00','\x00'},
    {'\xb8','\x69'},{'\xdf','\x66'},{'\xb8','\x67'},{'\xdf','\x63'},{'\x9d','\xb9'},
    {'\xe3','\x72'},{'\x96','\xe3'},{'\x00','\x00'},{'\x92','\xae'},{'\x93','\x64'},
    {'\x94','\xc2'},{'\xba','\xee'},{'\xe3','\x6a'},{'\xbd','\x78'},{'\xe3','\x74'},
    {'\xba','\xf1'},{'\xe3','\x78'},{'\xba','\xf7'},{'\xe3','\x65'},{'\x96','\xe4'},
    {'\x00','\x00'},{'\xe3','\x75'},{'\xe3','\x62'},{'\x96','\xe5'},{'\xe3','\x77'},
    {'\xe3','\x66'},{'\x95','\x56'},{'\xba','\xfe'},{'\xba','\xfb'},{'\xe3','\x76'},
    {'\xe3','\x70'},{'\xba','\xed'},{'\xba','\xf5'},{'\xba','\xf4'},{'\x95','\x6a'},
    {'\xba','\xf3'},{'\xba','\xf9'},{'\x00','\x00'},{'\xe3','\x63'},{'\xba','\xfa'},
    {'\xe3','\x71'},{'\xba','\xf6'},{'\xba','\xec'},{'\xe3','\x73'},{'\xba','\xef'},
    {'\xba','\xf0'},{'\xba','\xf8'},{'\xe3','\x68'},{'\xe3','\x67'},{'\xe3','\x64'},
    {'\x00','\x00'},{'\xe3','\x6c'},{'\xe3','\x69'},{'\xe3','\x6d'},{'\xba','\xfd'},
    {'\x00','\x00'},{'\xe3','\x79'},{'\xba','\xf2'},{'\xe3','\x6e'},{'\xe3','\x6f'},
    {'\x96','\xe6'},{'\xe3','\x6b'},{'\x93','\x5c'},{'\x96','\xe7'},{'\x93','\xe7'},
    {'\xba','\xfc'},{'\x96','\xe8'},{'\xfa','\xe6'},{'\xfa','\xe7'},{'\xfa','\xe8'},
    {'\xe6','\xe7'},{'\xbd','\x70'},{'\xbd','\x79'},{'\xbd','\x75'},{'\xe6','\xe4'},
    {'\x95','\xc3'},{'\xbd','\x72'},{'\xbd','\x76'},{'\xe6','\xf0'},{'\xbd','\x6c'},
    {'\xe6','\xe8'},{'\x00','\x00'},{'\xbd','\x74'},{'\xfa','\xe9'},{'\x96','\xe9'},
    {'\xe6','\xeb'},{'\xe6','\xe6'},{'\xbd','\x73'},{'\xbd','\x77'},{'\xe6','\xe5'},
    {'\x00','\x00'},{'\xbd','\x71'},{'\x00','\x00'},{'\xe6','\xef'},{'\xbd','\x6e'},
    {'\xe6','\xee'},{'\xe6','\xed'},{'\xbd','\x7a'},{'\xe5','\x72'},{'\xbd','\x6d'},
    {'\xfc','\xf1'},{'\xe6','\xec'},{'\xe6','\xe3'},{'\x00','\x00'},{'\xbd','\x7b'},
    {'\xe6','\xea'},{'\xbd','\x6f'},{'\x00','\x00'},{'\x96','\xea'},{'\x9f','\x7e'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x92','\x4d'},{'\x00','\x00'},{'\xe6','\xe9'},
    {'\x92','\xed'},{'\x94','\xc3'},{'\x00','\x00'},{'\x9f','\xa1'},{'\xbf','\xa2'},
    {'\xbf','\xa7'},{'\xbf','\x7e'},{'\xea','\xd8'},{'\xea','\xcf'},{'\xea','\xdb'},
    {'\xea','\xd3'},{'\xea','\xd9'},{'\xbf','\xa8'},{'\xbf','\xa1'},{'\xea','\xcc'},
    {'\xea','\xd2'},{'\xea','\xdc'},{'\xea','\xd5'},{'\xea','\xda'},{'\xea','\xce'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xea','\xd6'},{'\xbf','\xa3'},{'\xea','\xd4'},
    {'\xbf','\xa6'},{'\xbf','\xa5'},{'\xea','\xd0'},{'\xea','\xd1'},{'\xea','\xcd'},
    {'\xea','\xd7'},{'\xbf','\xa4'},{'\xea','\xde'},{'\xea','\xdd'},{'\x92','\xdf'},
    {'\xfc','\xf2'},{'\x00','\x00'},{'\xed','\xda'},{'\xed','\xd6'},{'\xc1','\x5f'},
    {'\x00','\x00'},{'\xed','\xd0'},{'\xc1','\x59'},{'\xc1','\x69'},{'\xed','\xdc'},
    {'\xc1','\x61'},{'\xc1','\x5d'},{'\xed','\xd3'},{'\xc1','\x64'},{'\xc1','\x67'},
    {'\xed','\xde'},{'\xc1','\x5c'},{'\xed','\xd5'},{'\xc1','\x65'},{'\xed','\xe0'},
    {'\xed','\xdd'},{'\xed','\xd1'},{'\xc1','\x60'},{'\xc1','\x5a'},{'\xc1','\x68'},
    {'\xed','\xd8'},{'\xc1','\x63'},{'\xed','\xd2'},{'\xc1','\x5e'},{'\xed','\xdf'},
    {'\xc1','\x62'},{'\xc1','\x5b'},{'\xed','\xd9'},{'\xc1','\x66'},{'\xed','\xd7'},
    {'\x93','\x4f'},{'\x82','\x5a'},{'\xed','\xdb'},{'\xfa','\xea'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xf0','\x6e'},{'\xf0','\x74'},{'\xc2','\xb9'},{'\xf0','\x77'},
    {'\xc2','\xb4'},{'\xc2','\xb5'},{'\xf0','\x6f'},{'\xf0','\x76'},{'\xf0','\x71'},
    {'\xc2','\xba'},{'\xc2','\xb7'},{'\x9f','\xa2'},{'\xf0','\x6d'},{'\xfa','\xeb'},
    {'\xc2','\xb6'},{'\xf0','\x73'},{'\xf0','\x75'},{'\xc2','\xb8'},{'\xf0','\x72'},
    {'\xf0','\x70'},{'\x00','\x00'},{'\x9f','\xa3'},{'\x8a','\x50'},{'\x94','\xc4'},
    {'\xf2','\xb8'},{'\xc3','\xb7'},{'\xc3','\xb8'},{'\xc3','\xb4'},{'\x9f','\xa4'},
    {'\xc3','\xb5'},{'\x8c','\xe8'},{'\xf2','\xb4'},{'\xf2','\xb2'},{'\x00','\x00'},
    {'\xf2','\xb6'},{'\xc3','\xba'},{'\xf2','\xb7'},{'\xf2','\xb0'},{'\xf2','\xaf'},
    {'\xf2','\xb3'},{'\xf2','\xb1'},{'\xc3','\xb6'},{'\xf2','\xb5'},{'\xf4','\xac'},
    {'\xc4','\x7e'},{'\xc4','\x7d'},{'\xf4','\xad'},{'\xfa','\xec'},{'\xf4','\xaf'},
    {'\xf4','\xae'},{'\xc4','\xa1'},{'\x94','\xc5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf5','\xeb'},{'\xf5','\xe8'},{'\xf5','\xe9'},{'\xfa','\xed'},{'\xf5','\xe7'},
    {'\xf5','\xea'},{'\xc4','\xf2'},{'\xf5','\xec'},{'\xfa','\xee'},{'\xc4','\xf1'},
    {'\x94','\xc6'},{'\xf7','\x42'},{'\xfa','\xef'},{'\xc5','\xd5'},{'\xc5','\xd7'},
    {'\xf7','\xee'},{'\xc5','\xd6'},{'\xf8','\xb9'},{'\xf9','\x40'},{'\xf9','\x42'},
    {'\xf8','\xfe'},{'\xf9','\x41'},{'\xc6','\x6c'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9c','\xeb'},{'\x83','\x5f'},{'\x83','\x76'},{'\x83','\x71'},{'\x83','\x70'},
    {'\x8a','\x4e'},{'\x83','\x74'},{'\x83','\x75'},{'\x83','\xcb'},{'\x8d','\xbe'},
    {'\x90','\x44'},{'\x83','\x72'},{'\x83','\x73'},{'\x87','\xfe'},{'\x83','\xcc'},
    {'\x00','\x00'},{'\x83','\xc8'},{'\x83','\xca'},{'\x83','\xc6'},{'\x86','\xfc'},
    {'\x83','\xcd'},{'\x00','\x00'},{'\x8a','\x4c'},{'\x87','\x41'},{'\x83','\xcf'},
    {'\x83','\xce'},{'\x83','\xc7'},{'\x83','\xc5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x83','\xc9'},{'\x8d','\xc5'},{'\x88','\x45'},{'\x8d','\xd3'},{'\x84','\x71'},
    {'\x84','\x72'},{'\x87','\xfd'},{'\x84','\x6f'},{'\x84','\x6e'},{'\x84','\x6d'},
    {'\x8a','\xeb'},{'\x84','\x70'},{'\x89','\x53'},{'\x84','\x68'},{'\x84','\x6b'},
    {'\x84','\x6c'},{'\x84','\x6a'},{'\x8b','\xb1'},{'\x85','\xee'},{'\x8d','\xd4'},
    {'\x85','\xf0'},{'\x85','\x44'},{'\x85','\x43'},{'\xfa','\xf0'},{'\x8a','\xed'},
    {'\x85','\x4a'},{'\x8d','\xe4'},{'\x8b','\xb3'},{'\x85','\x48'},{'\x85','\x49'},
    {'\x85','\x4b'},{'\x85','\x47'},{'\x85','\x45'},{'\x85','\x42'},{'\x84','\x69'},
    {'\x8e','\x4a'},{'\x8e','\x4b'},{'\x85','\xef'},{'\x8a','\xef'},{'\x00','\x00'},
    {'\x85','\xf1'},{'\x85','\xf2'},{'\x8c','\x49'},{'\x8e','\x49'},{'\x8a','\x45'},
    {'\x87','\x43'},{'\x86','\xf8'},{'\x00','\x00'},{'\x8c','\xa2'},{'\x86','\xfd'},
    {'\x8e','\x7b'},{'\x86','\xf7'},{'\xfa','\xf1'},{'\x8e','\x7a'},{'\x8b','\xb2'},
    {'\x87','\x42'},{'\x87','\x40'},{'\x87','\x45'},{'\x8a','\x49'},{'\x86','\xfe'},
    {'\x00','\x00'},{'\x8e','\x7c'},{'\x8e','\x79'},{'\x86','\xf6'},{'\x86','\xf4'},
    {'\x86','\xf5'},{'\x86','\xf9'},{'\x86','\xfb'},{'\x87','\x44'},{'\x88','\x49'},
    {'\x8e','\xc2'},{'\x88','\x40'},{'\x88','\x41'},{'\x8d','\xa3'},{'\x88','\x4b'},
    {'\x88','\x4a'},{'\x88','\x42'},{'\x00','\x00'},{'\x8f','\x79'},{'\x8e','\xc4'},
    {'\x88','\x48'},{'\x88','\x46'},{'\x8e','\xc5'},{'\x00','\x00'},{'\x8e','\xc6'},
    {'\xfa','\xf2'},{'\x88','\x47'},{'\x87','\xfc'},{'\x8a','\x47'},{'\x88','\x43'},
    {'\x8e','\xc3'},{'\x88','\x44'},{'\x89','\x52'},{'\x89','\x4e'},{'\x8e','\xf0'},
    {'\x89','\x51'},{'\x8a','\x4a'},{'\x00','\x00'},{'\x89','\x50'},{'\x8c','\xa1'},
    {'\x8f','\x5d'},{'\x89','\x4b'},{'\x89','\x4c'},{'\x8c','\x48'},{'\x8a','\x4f'},
    {'\x8a','\x51'},{'\x8a','\x48'},{'\x8c','\xfb'},{'\x8a','\x44'},{'\x8a','\x46'},
    {'\x8a','\x4d'},{'\x90','\x45'},{'\x8a','\xee'},{'\x8a','\xec'},{'\x8a','\xf0'},
    {'\xfa','\xf3'},{'\x8f','\xde'},{'\x8f','\xbf'},{'\x8f','\xc0'},{'\x8b','\xb5'},
    {'\x90','\x7c'},{'\xa6','\xce'},{'\x9f','\xa5'},{'\xac','\xfb'},{'\xd2','\x6f'},
    {'\xaf','\xca'},{'\x00','\x00'},{'\x00','\x00'},{'\xb2','\xda'},{'\xda','\xfc'},
    {'\xda','\xfd'},{'\x9f','\xa6'},{'\x9f','\xa7'},{'\x8c','\x4a'},{'\xea','\xdf'},
    {'\xc1','\x6a'},{'\xed','\xe1'},{'\x00','\x00'},{'\x95','\x74'},{'\xc2','\xbb'},
    {'\x9f','\xa8'},{'\xf2','\xba'},{'\xf2','\xb9'},{'\xc4','\xa2'},{'\xf5','\xed'},
    {'\xfb','\xaa'},{'\xf7','\x43'},{'\xc5','\xf8'},{'\xca','\x49'},{'\x9f','\xa9'},
    {'\x9d','\x75'},{'\xaa','\xc9'},{'\xa8','\x75'},{'\x00','\x00'},{'\x8b','\xb4'},
    {'\xd0','\x4d'},{'\x00','\x00'},{'\x87','\x46'},{'\xd3','\x60'},{'\xd3','\x5b'},
    {'\xd3','\x5f'},{'\xd3','\x5d'},{'\xaf','\xcb'},{'\xd3','\x5e'},{'\xd3','\x5c'},
    {'\x88','\x4d'},{'\xd6','\xf1'},{'\x00','\x00'},{'\xda','\xfe'},{'\xdb','\x40'},
    {'\xdf','\x69'},{'\xdf','\x6a'},{'\xb8','\x6e'},{'\xb8','\x6f'},{'\xdf','\x68'},
    {'\xdf','\x6b'},{'\xdf','\x67'},{'\xb8','\x6d'},{'\x00','\x00'},{'\xbb','\x40'},
    {'\xfa','\xf4'},{'\xb8','\x70'},{'\xe3','\x7a'},{'\x8f','\xc1'},{'\xbd','\x7c'},
    {'\xe6','\xf1'},{'\xbd','\x7d'},{'\x95','\x64'},{'\xbf','\xa9'},{'\xea','\xe2'},
    {'\xea','\xe0'},{'\xea','\xe1'},{'\xed','\xe4'},{'\xed','\xe3'},{'\xed','\xe2'},
    {'\x00','\x00'},{'\x8d','\x56'},{'\xfa','\xf5'},{'\xf2','\xbb'},{'\x00','\x00'},
    {'\xc3','\xb9'},{'\xf2','\xbc'},{'\xf7','\x44'},{'\xc5','\xf9'},{'\xf8','\xba'},
    {'\xa6','\xcf'},{'\xaa','\xcb'},{'\xaa','\xca'},{'\xd0','\x4f'},{'\xac','\xfc'},
    {'\x9f','\xaa'},{'\x00','\x00'},{'\xd0','\x4e'},{'\xd3','\x62'},{'\x9f','\xab'},
    {'\xaf','\xcc'},{'\xd6','\xf2'},{'\xd3','\x61'},{'\x95','\xe0'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xb2','\xdc'},{'\xd6','\xf5'},{'\xd6','\xf3'},{'\xd6','\xf4'},
    {'\xb2','\xdb'},{'\x8e','\x4c'},{'\xdb','\x42'},{'\xdb','\x43'},{'\xdb','\x41'},
    {'\x95','\x55'},{'\xb8','\x73'},{'\xdf','\x6d'},{'\xdf','\x6c'},{'\xdf','\x6e'},
    {'\xb8','\x72'},{'\xb8','\x71'},{'\x00','\x00'},{'\x00','\x00'},{'\xe6','\xf2'},
    {'\xe6','\xf4'},{'\xfa','\xf6'},{'\xbd','\x7e'},{'\xe6','\xf3'},{'\xea','\xe3'},
    {'\xbf','\xaa'},{'\xf0','\x79'},{'\x9f','\xac'},{'\xf0','\x78'},{'\xc3','\xbb'},
    {'\xf2','\xbd'},{'\xc3','\xbd'},{'\xc3','\xbc'},{'\xf4','\xb0'},{'\xf5','\xee'},
    {'\xc4','\xf3'},{'\xa6','\xd0'},{'\xd0','\x50'},{'\xac','\xfd'},{'\xd3','\x65'},
    {'\xaf','\xce'},{'\xd3','\x64'},{'\xd3','\x63'},{'\x00','\x00'},{'\xaf','\xcd'},
    {'\xfa','\xf7'},{'\xd6','\xfb'},{'\x00','\x00'},{'\xd6','\xfd'},{'\xd6','\xf6'},
    {'\xd6','\xf7'},{'\xb2','\xdd'},{'\xd6','\xf8'},{'\xb2','\xde'},{'\xd6','\xfc'},
    {'\xd6','\xf9'},{'\xd6','\xfa'},{'\xb2','\xdf'},{'\x00','\x00'},{'\xb5','\xbe'},
    {'\xb5','\xbf'},{'\x00','\x00'},{'\xdb','\x44'},{'\x8a','\xf1'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xdf','\x6f'},{'\xdf','\x70'},{'\x9f','\xad'},{'\xe3','\x7e'},
    {'\xbb','\x43'},{'\xbb','\x41'},{'\xbb','\x42'},{'\xe3','\x7b'},{'\xe3','\x7c'},
    {'\x00','\x00'},{'\xe3','\x7d'},{'\xe6','\xf9'},{'\x9f','\xae'},{'\xe6','\xfa'},
    {'\xbd','\xa1'},{'\xe6','\xf7'},{'\xe6','\xf6'},{'\xe6','\xf8'},{'\xe6','\xf5'},
    {'\xbf','\xad'},{'\xea','\xe4'},{'\xbf','\xab'},{'\xbf','\xac'},{'\xed','\xe6'},
    {'\xc1','\x6b'},{'\xed','\xe5'},{'\xef','\xa8'},{'\x00','\x00'},{'\xf0','\x7a'},
    {'\xf0','\x7b'},{'\xc2','\xbc'},{'\x9f','\xaf'},{'\xc2','\xbd'},{'\xc1','\x6c'},
    {'\xf2','\xbe'},{'\xf2','\xbf'},{'\xf4','\xb1'},{'\xc4','\xa3'},{'\xa6','\xd1'},
    {'\x9f','\xb0'},{'\xa6','\xd2'},{'\xac','\xfe'},{'\xaa','\xcc'},{'\xaf','\xcf'},
    {'\xd0','\x51'},{'\x9f','\xb1'},{'\x00','\x00'},{'\x00','\x00'},{'\xb5','\xc0'},
    {'\xa6','\xd3'},{'\xad','\x41'},{'\xd0','\x52'},{'\xd0','\x53'},{'\xad','\x40'},
    {'\xad','\x42'},{'\xa6','\xd4'},{'\x00','\x00'},{'\xd0','\x54'},{'\xaf','\xd1'},
    {'\xd3','\x66'},{'\xaf','\xd3'},{'\xaf','\xd0'},{'\xaf','\xd2'},{'\x00','\x00'},
    {'\xd7','\x41'},{'\xb2','\xe0'},{'\xfc','\xf6'},{'\xd7','\x40'},{'\xd6','\xfe'},
    {'\xfa','\xf8'},{'\xdf','\x71'},{'\xfa','\xf9'},{'\x00','\x00'},{'\xe3','\xa1'},
    {'\xfa','\xfa'},{'\xbd','\xa2'},{'\x8f','\x5e'},{'\xbf','\xae'},{'\xea','\xe6'},
    {'\xea','\xe5'},{'\x00','\x00'},{'\xed','\xe7'},{'\x00','\x00'},{'\x9f','\xb2'},
    {'\x9f','\xb3'},{'\xf5','\xef'},{'\xfa','\xfb'},{'\x00','\x00'},{'\xa6','\xd5'},
    {'\xcb','\x73'},{'\xcd','\xaa'},{'\xad','\x43'},{'\xd0','\x55'},{'\x8a','\x55'},
    {'\xd3','\x68'},{'\x00','\x00'},{'\x95','\x5c'},{'\x9f','\xb4'},{'\xaf','\xd4'},
    {'\xd3','\x67'},{'\xaf','\xd5'},{'\x00','\x00'},{'\x00','\x00'},{'\x8a','\xf3'},
    {'\xd7','\x43'},{'\x00','\x00'},{'\x00','\x00'},{'\xb2','\xe2'},{'\xd7','\x42'},
    {'\xd7','\x44'},{'\x00','\x00'},{'\xb2','\xe1'},{'\x8c','\xd9'},{'\x8a','\xf2'},
    {'\x8f','\xdf'},{'\x00','\x00'},{'\xdb','\x46'},{'\xdb','\x47'},{'\xdb','\x45'},
    {'\xb5','\xc1'},{'\x00','\x00'},{'\x8a','\x54'},{'\x00','\x00'},{'\xb8','\x74'},
    {'\x00','\x00'},{'\xb8','\x75'},{'\x00','\x00'},{'\xbb','\x45'},{'\xfc','\xfa'},
    {'\xe3','\xa3'},{'\xe3','\xa2'},{'\xbb','\x44'},{'\xfa','\xfc'},{'\x00','\x00'},
    {'\x82','\x6b'},{'\xfc','\xf7'},{'\xfc','\xf8'},{'\xe6','\xfb'},{'\x00','\x00'},
    {'\xfc','\xf9'},{'\xe6','\xfc'},{'\xfa','\xfd'},{'\x8f','\x7a'},{'\x8a','\x53'},
    {'\x00','\x00'},{'\xea','\xe7'},{'\x00','\x00'},{'\x00','\x00'},{'\xc1','\x70'},
    {'\xc1','\x6f'},{'\xc1','\x6d'},{'\xc1','\x6e'},{'\xc1','\x71'},{'\x93','\x77'},
    {'\xf0','\x7c'},{'\xc2','\xbf'},{'\xc2','\xbe'},{'\xf2','\xc0'},{'\xf4','\xb2'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc5','\xa5'},{'\xc5','\xa4'},
    {'\xa6','\xd6'},{'\x91','\xd5'},{'\x00','\x00'},{'\xd1','\xfb'},{'\x85','\x4c'},
    {'\xb8','\x77'},{'\xb5','\xc2'},{'\xb8','\x76'},{'\xbb','\x46'},{'\x00','\x00'},
    {'\xa6','\xd7'},{'\xc9','\xa9'},{'\xa6','\xd8'},{'\xa6','\xd9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xcd','\xab'},{'\xcb','\x76'},{'\x00','\x00'},{'\xcb','\x77'},
    {'\xa8','\x77'},{'\x00','\x00'},{'\xcb','\x74'},{'\xa8','\x76'},{'\x00','\x00'},
    {'\xa8','\x79'},{'\xcb','\x75'},{'\xa8','\x7b'},{'\xa8','\x7a'},{'\xcb','\x78'},
    {'\xa8','\x78'},{'\x00','\x00'},{'\x96','\xaf'},{'\x85','\xf6'},{'\xaa','\xd1'},
    {'\xaa','\xcf'},{'\xcd','\xad'},{'\x88','\x4f'},{'\xaa','\xce'},{'\xfc','\xfb'},
    {'\x9f','\xb5'},{'\x00','\x00'},{'\xaa','\xd3'},{'\xaa','\xd5'},{'\xaa','\xd2'},
    {'\xfa','\xfe'},{'\xcd','\xb0'},{'\xcd','\xac'},{'\xaa','\xd6'},{'\x00','\x00'},
    {'\xaa','\xd0'},{'\xa8','\x7c'},{'\x00','\x00'},{'\xaa','\xd4'},{'\xcd','\xaf'},
    {'\xfb','\x4d'},{'\xfb','\x40'},{'\xcd','\xae'},{'\x00','\x00'},{'\xaa','\xcd'},
    {'\x00','\x00'},{'\x96','\xcb'},{'\x96','\xa6'},{'\x85','\x4d'},{'\x85','\xf8'},
    {'\x85','\x4e'},{'\x83','\xd0'},{'\xd0','\x5b'},{'\xad','\x47'},{'\xad','\x48'},
    {'\xd0','\x5d'},{'\x8a','\x57'},{'\xd0','\x57'},{'\xd0','\x5a'},{'\xd0','\x63'},
    {'\xd0','\x61'},{'\x00','\x00'},{'\xad','\x49'},{'\xd0','\x67'},{'\xad','\x4c'},
    {'\xd0','\x64'},{'\xd0','\x5c'},{'\xd0','\x59'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xdb','\x49'},{'\xd0','\x62'},{'\xad','\x44'},{'\xd0','\x65'},{'\xd0','\x56'},
    {'\xd0','\x5f'},{'\xad','\x46'},{'\xad','\x4b'},{'\xd0','\x60'},{'\xad','\x4f'},
    {'\xad','\x4d'},{'\x00','\x00'},{'\xd0','\x58'},{'\xad','\x4a'},{'\x00','\x00'},
    {'\xd0','\x5e'},{'\xad','\x4e'},{'\xad','\x45'},{'\xd0','\x66'},{'\x8b','\xf8'},
    {'\xfd','\xfb'},{'\xfd','\xfc'},{'\x8c','\x4b'},{'\x8d','\xd5'},{'\xfd','\xfd'},
    {'\xaf','\xda'},{'\x00','\x00'},{'\xaf','\xe3'},{'\xaf','\xd8'},{'\xaf','\xd6'},
    {'\xd3','\x6a'},{'\xaf','\xde'},{'\xaf','\xdb'},{'\xd3','\x6c'},{'\x88','\x4e'},
    {'\x00','\x00'},{'\xaf','\xdd'},{'\xd3','\x6b'},{'\xd3','\x69'},{'\xd3','\x6e'},
    {'\xaf','\xe2'},{'\xaf','\xe0'},{'\xdb','\x48'},{'\x00','\x00'},{'\xd3','\x6f'},
    {'\xd3','\x6d'},{'\xaf','\xd7'},{'\xfc','\xfc'},{'\x00','\x00'},{'\xaf','\xd9'},
    {'\xaf','\xdc'},{'\xfe','\x48'},{'\xaf','\xdf'},{'\x83','\xd1'},{'\xaf','\xe1'},
    {'\x00','\x00'},{'\x9f','\xb6'},{'\x8a','\x59'},{'\xfd','\xfe'},{'\x8c','\xda'},
    {'\x8a','\xf4'},{'\x85','\xf9'},{'\xfe','\xee'},{'\x8a','\x56'},{'\x90','\x7d'},
    {'\xd7','\x4e'},{'\xb2','\xe4'},{'\x95','\xa8'},{'\xd7','\x45'},{'\xd7','\x47'},
    {'\x85','\xf7'},{'\xd7','\x48'},{'\x00','\x00'},{'\xd7','\x50'},{'\xd7','\x4c'},
    {'\xd7','\x4a'},{'\x00','\x00'},{'\xd7','\x4d'},{'\xd7','\x51'},{'\xb2','\xe5'},
    {'\xb2','\xe9'},{'\xd7','\x46'},{'\x00','\x00'},{'\xd7','\x4f'},{'\x00','\x00'},
    {'\xb2','\xe7'},{'\x9f','\xb7'},{'\xb2','\xe6'},{'\xd7','\x4b'},{'\xd7','\x49'},
    {'\x00','\x00'},{'\xb2','\xe3'},{'\xb2','\xe8'},{'\xfe','\xef'},{'\x96','\xa5'},
    {'\x93','\xb0'},{'\x9f','\xb8'},{'\x00','\x00'},{'\xfe','\xf0'},{'\xa0','\x42'},
    {'\x8a','\x58'},{'\xb5','\xc8'},{'\xdb','\x51'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xdb','\x4f'},{'\xb5','\xca'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x9f','\xb9'},{'\xdb','\x4a'},{'\xdf','\xa1'},{'\x00','\x00'},{'\xb5','\xc9'},
    {'\xdb','\x4e'},{'\x96','\xab'},{'\x00','\x00'},{'\xdb','\x4b'},{'\xb5','\xc5'},
    {'\xb5','\xcb'},{'\xdb','\x50'},{'\xb5','\xc7'},{'\xdb','\x4d'},{'\xbb','\x47'},
    {'\xb5','\xc6'},{'\xdb','\x4c'},{'\xb5','\xcc'},{'\xb5','\xc4'},{'\xb5','\xc3'},
    {'\x9f','\xba'},{'\x00','\x00'},{'\x00','\x00'},{'\x96','\xae'},{'\x96','\xa2'},
    {'\xdf','\x77'},{'\xdf','\x75'},{'\x00','\x00'},{'\xdf','\x7b'},{'\xfe','\xf1'},
    {'\xdf','\x73'},{'\xdf','\xa2'},{'\xdf','\x78'},{'\x00','\x00'},{'\xdf','\x72'},
    {'\xb8','\x7b'},{'\xb8','\xa3'},{'\xdf','\x7d'},{'\x00','\x00'},{'\xdf','\x76'},
    {'\x00','\x00'},{'\xb8','\x7e'},{'\x9d','\xd0'},{'\xfe','\xf2'},{'\xb8','\x7c'},
    {'\xdf','\x7e'},{'\xb8','\x79'},{'\xb8','\x78'},{'\xdf','\x79'},{'\xb8','\x7d'},
    {'\xb5','\xcd'},{'\x00','\x00'},{'\xdf','\x7c'},{'\xdf','\x74'},{'\xb8','\x7a'},
    {'\xb8','\xa1'},{'\xb8','\xa2'},{'\x89','\x54'},{'\x89','\xae'},{'\xfe','\xf3'},
    {'\x8c','\x65'},{'\xbb','\x4c'},{'\xbb','\x48'},{'\x00','\x00'},{'\xbb','\x4d'},
    {'\xe3','\xa6'},{'\x9f','\xbb'},{'\x00','\x00'},{'\xe3','\xa5'},{'\xe3','\xa7'},
    {'\xbb','\x4a'},{'\xe3','\xa4'},{'\xbb','\x4b'},{'\xe3','\xaa'},{'\xe3','\xa9'},
    {'\xe3','\xa8'},{'\x00','\x00'},{'\xbb','\x49'},{'\x00','\x00'},{'\x8a','\xf5'},
    {'\x00','\x00'},{'\xfe','\xf4'},{'\x00','\x00'},{'\xe7','\x41'},{'\x00','\x00'},
    {'\xe7','\x44'},{'\xbd','\xa8'},{'\xe7','\x43'},{'\xbd','\xa7'},{'\xbd','\xa3'},
    {'\xbd','\xa4'},{'\xbd','\xa5'},{'\xe7','\x40'},{'\xe6','\xfe'},{'\xbd','\xa6'},
    {'\x00','\x00'},{'\xe7','\x42'},{'\xe6','\xfd'},{'\x94','\xc7'},{'\x9f','\xbc'},
    {'\xea','\xe9'},{'\xea','\xf3'},{'\xbf','\xb1'},{'\xbf','\xb0'},{'\xfe','\xf5'},
    {'\xea','\xed'},{'\xea','\xef'},{'\x00','\x00'},{'\xea','\xea'},{'\x00','\x00'},
    {'\xea','\xee'},{'\xea','\xe8'},{'\xea','\xf1'},{'\xbf','\xaf'},{'\xea','\xf0'},
    {'\xea','\xec'},{'\xfb','\x6e'},{'\xea','\xf2'},{'\xfe','\xf6'},{'\xea','\xeb'},
    {'\xc1','\x74'},{'\xed','\xe8'},{'\xed','\xee'},{'\xc1','\x78'},{'\xc1','\x7a'},
    {'\xc1','\x77'},{'\xc1','\x76'},{'\xfe','\xf7'},{'\xc1','\x75'},{'\xc1','\x73'},
    {'\xed','\xe9'},{'\xed','\xec'},{'\xc1','\x72'},{'\xed','\xed'},{'\xfc','\xfe'},
    {'\xc1','\x79'},{'\xed','\xeb'},{'\x00','\x00'},{'\xed','\xea'},{'\xc2','\xc0'},
    {'\x00','\x00'},{'\xc2','\xc1'},{'\xf0','\xa1'},{'\xf0','\x7d'},{'\xf0','\x7e'},
    {'\x93','\x62'},{'\x00','\x00'},{'\xf2','\xc2'},{'\x00','\x00'},{'\xf2','\xc1'},
    {'\xc3','\xbe'},{'\xf4','\xb4'},{'\xc4','\xa4'},{'\xf4','\xb3'},{'\x00','\x00'},
    {'\xf5','\xf0'},{'\xf7','\x45'},{'\xc5','\xa6'},{'\xf9','\x43'},{'\xf9','\x44'},
    {'\xc5','\xd8'},{'\xa6','\xda'},{'\x9f','\xbd'},{'\xaa','\xd7'},{'\xdb','\x52'},
    {'\xbb','\x4e'},{'\xc1','\x7b'},{'\xed','\xef'},{'\xa6','\xdb'},{'\x00','\x00'},
    {'\xaf','\xe5'},{'\xaf','\xe4'},{'\xdb','\x53'},{'\x95','\xd3'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xea','\xf4'},{'\xa6','\xdc'},{'\xad','\x50'},{'\x00','\x00'},
    {'\xfd','\x42'},{'\xdb','\x54'},{'\xdb','\x55'},{'\xdb','\x56'},{'\xbb','\x4f'},
    {'\xbf','\xb2'},{'\xa6','\xdd'},{'\x00','\x00'},{'\xaa','\xd8'},{'\xd0','\x68'},
    {'\xaf','\xe6'},{'\xd3','\x70'},{'\xb2','\xea'},{'\x00','\x00'},{'\xdb','\x57'},
    {'\xb8','\xa4'},{'\x8a','\x77'},{'\xbb','\x50'},{'\xbf','\xb3'},{'\xc1','\x7c'},
    {'\xc2','\xc2'},{'\xf4','\xb5'},{'\xa6','\xde'},{'\xaa','\xd9'},{'\x92','\xd6'},
    {'\x00','\x00'},{'\xaf','\xe7'},{'\xd7','\x52'},{'\xb5','\xce'},{'\x00','\x00'},
    {'\xbb','\x51'},{'\xe3','\xab'},{'\xe7','\x45'},{'\x93','\xc6'},{'\x95','\xec'},
    {'\x00','\x00'},{'\xfd','\x43'},{'\xa6','\xdf'},{'\xb5','\xcf'},{'\xdf','\xa3'},
    {'\xbb','\x52'},{'\xa6','\xe0'},{'\xcd','\xb1'},{'\xd0','\x69'},{'\xad','\x51'},
    {'\x8f','\xc2'},{'\x00','\x00'},{'\xd3','\x72'},{'\xfb','\x53'},{'\x00','\x00'},
    {'\xaf','\xea'},{'\xfe','\xf8'},{'\xaf','\xe8'},{'\xaf','\xe9'},{'\xaf','\xeb'},
    {'\xfe','\xf9'},{'\xfe','\xfa'},{'\xd3','\x71'},{'\x8c','\x4c'},{'\x89','\x56'},
    {'\xd7','\x57'},{'\xd7','\x54'},{'\xd7','\x56'},{'\xb2','\xeb'},{'\xb2','\xed'},
    {'\xb2','\xec'},{'\xd7','\x53'},{'\xb2','\xee'},{'\xd7','\x55'},{'\x90','\x5b'},
    {'\xdb','\x58'},{'\xdb','\x59'},{'\xfe','\xfb'},{'\xdb','\x5a'},{'\xdf','\xa6'},
    {'\x00','\x00'},{'\xdf','\xa7'},{'\x00','\x00'},{'\xdf','\xa5'},{'\xdf','\xa8'},
    {'\x00','\x00'},{'\xb8','\xa5'},{'\x00','\x00'},{'\xdf','\xa4'},{'\x00','\x00'},
    {'\xbb','\x53'},{'\x00','\x00'},{'\x00','\x00'},{'\xe7','\x4a'},{'\xe7','\x46'},
    {'\xe7','\x49'},{'\xe7','\x4b'},{'\xe7','\x48'},{'\xe7','\x47'},{'\x9f','\xbe'},
    {'\xea','\xf5'},{'\xea','\xf6'},{'\xea','\xf7'},{'\xbf','\xb4'},{'\xbf','\xb5'},
    {'\xed','\xf1'},{'\xed','\xf0'},{'\xed','\xf2'},{'\x94','\xc8'},{'\xf0','\xa3'},
    {'\xf0','\xa2'},{'\x00','\x00'},{'\xf2','\xc4'},{'\xfe','\xfc'},{'\xf2','\xc5'},
    {'\xf2','\xc3'},{'\x9f','\xbf'},{'\xc4','\xa5'},{'\x00','\x00'},{'\xf4','\xb6'},
    {'\xf4','\xb7'},{'\xfe','\xfd'},{'\xf7','\x46'},{'\xf7','\xef'},{'\xf8','\xbb'},
    {'\xa6','\xe1'},{'\xa8','\x7d'},{'\x8a','\x5c'},{'\xc1','\x7d'},{'\xa6','\xe2'},
    {'\x8d','\x5b'},{'\xd7','\x58'},{'\xdb','\x5b'},{'\x82','\x45'},{'\xc6','\x41'},
    {'\xca','\x4a'},{'\x9c','\xd2'},{'\x8b','\xb7'},{'\x9f','\xc0'},{'\xca','\x4b'},
    {'\xca','\x4d'},{'\xa6','\xe3'},{'\xca','\x4e'},{'\xca','\x4c'},{'\x00','\x00'},
    {'\x85','\xeb'},{'\xcb','\xa2'},{'\xcb','\xa3'},{'\xcb','\x7b'},{'\x00','\x00'},
    {'\x9f','\xc1'},{'\xfe','\xfe'},{'\x00','\x00'},{'\xcb','\xa1'},{'\xa8','\xa1'},
    {'\x00','\x00'},{'\xa8','\xa2'},{'\xcb','\x7c'},{'\xcb','\x7a'},{'\xcb','\x79'},
    {'\xcb','\x7d'},{'\xa8','\x7e'},{'\xcb','\x7e'},{'\xd0','\x6a'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8e','\xf6'},{'\xcd','\xb6'},{'\xaa','\xdc'},{'\xcd','\xb5'},
    {'\xcd','\xb7'},{'\x89','\x59'},{'\xaa','\xdb'},{'\xcd','\xbc'},{'\xaa','\xdf'},
    {'\xcd','\xb2'},{'\xcd','\xc0'},{'\xcd','\xc6'},{'\xaa','\xe6'},{'\xcd','\xc3'},
    {'\xaa','\xe3'},{'\x8c','\x4f'},{'\xcd','\xb9'},{'\xcd','\xbf'},{'\xcd','\xc1'},
    {'\xfb','\xa5'},{'\xcd','\xb4'},{'\xaa','\xe2'},{'\xaa','\xdd'},{'\xcd','\xba'},
    {'\xaa','\xe4'},{'\xaa','\xe7'},{'\xaa','\xe1'},{'\x00','\x00'},{'\xaa','\xda'},
    {'\xcd','\xbe'},{'\xcd','\xb8'},{'\xcd','\xc5'},{'\xaa','\xe9'},{'\xaa','\xe5'},
    {'\xaa','\xe0'},{'\xcd','\xbd'},{'\xaf','\xec'},{'\xcd','\xbb'},{'\xaa','\xde'},
    {'\xaa','\xe8'},{'\x9f','\xc2'},{'\xcd','\xb3'},{'\x8e','\xca'},{'\xcd','\xc2'},
    {'\xcd','\xc4'},{'\x96','\xbe'},{'\x91','\x40'},{'\x00','\x00'},{'\x85','\xfb'},
    {'\x8f','\xe1'},{'\x00','\x00'},{'\x91','\x41'},{'\x84','\x79'},{'\x85','\x51'},
    {'\x87','\x4b'},{'\x83','\x78'},{'\x84','\xf7'},{'\xfd','\x5f'},{'\xad','\x62'},
    {'\xad','\x5c'},{'\xad','\x64'},{'\xad','\x61'},{'\xd0','\x71'},{'\xd0','\x74'},
    {'\xad','\x5d'},{'\x91','\x42'},{'\xd0','\x6b'},{'\x00','\x00'},{'\xad','\x56'},
    {'\xad','\x60'},{'\x00','\x00'},{'\xad','\x63'},{'\xad','\x65'},{'\xd0','\xa2'},
    {'\xd0','\x77'},{'\x9f','\xc3'},{'\xad','\x55'},{'\xd0','\xa1'},{'\xad','\x59'},
    {'\xad','\x57'},{'\xad','\x52'},{'\xd0','\x6f'},{'\x00','\x00'},{'\xd0','\x7e'},
    {'\xd0','\x73'},{'\xd0','\x76'},{'\xd0','\xa5'},{'\x9f','\xc4'},{'\xad','\x66'},
    {'\xd0','\x7d'},{'\xad','\x5e'},{'\xd0','\x78'},{'\xd0','\xa4'},{'\xd0','\x75'},
    {'\xd0','\x79'},{'\xd0','\x7c'},{'\x96','\xa3'},{'\x9f','\xc5'},{'\xd0','\x6d'},
    {'\xd0','\xa3'},{'\xd0','\x7b'},{'\x9f','\xc6'},{'\xfd','\x5d'},{'\xd0','\x6c'},
    {'\x9f','\xc7'},{'\xd0','\x70'},{'\xad','\x5f'},{'\xad','\x5a'},{'\xad','\x53'},
    {'\xad','\x58'},{'\xad','\x54'},{'\xad','\x67'},{'\xd0','\x6e'},{'\xd3','\xa5'},
    {'\xad','\x5b'},{'\x00','\x00'},{'\x9f','\xc8'},{'\xd0','\x7a'},{'\xce','\x41'},
    {'\x92','\xa7'},{'\x8f','\xe0'},{'\x00','\x00'},{'\x8e','\xc9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x85','\xc3'},{'\x8e','\x46'},{'\xd3','\xa8'},{'\xaf','\xfa'},
    {'\x91','\x43'},{'\xd3','\x76'},{'\x91','\x44'},{'\xd3','\xa3'},{'\xd3','\x7d'},
    {'\x9f','\xc9'},{'\xd3','\xb2'},{'\x00','\x00'},{'\xd3','\xaa'},{'\x00','\x00'},
    {'\xd3','\x7e'},{'\x91','\x45'},{'\xd3','\xa9'},{'\xd3','\x78'},{'\xd3','\x7c'},
    {'\xd3','\xb5'},{'\xaf','\xfd'},{'\xd3','\xad'},{'\xd3','\xa4'},{'\xaf','\xed'},
    {'\xd3','\xb3'},{'\xd3','\x74'},{'\x00','\x00'},{'\xd3','\xac'},{'\x00','\x00'},
    {'\xaf','\xfc'},{'\xaf','\xf7'},{'\xd3','\x73'},{'\xaf','\xf5'},{'\xaf','\xf4'},
    {'\xaf','\xf9'},{'\xd3','\xab'},{'\xaf','\xf1'},{'\xaf','\xf8'},{'\xd0','\x72'},
    {'\xdb','\x5c'},{'\xd3','\xa6'},{'\x9f','\xca'},{'\x00','\x00'},{'\xd3','\x7a'},
    {'\xaf','\xfb'},{'\xd3','\x7b'},{'\xd3','\xa1'},{'\xaf','\xfe'},{'\xd3','\x75'},
    {'\xd3','\xaf'},{'\x91','\x46'},{'\xd3','\xae'},{'\xd3','\xb6'},{'\xaf','\xf3'},
    {'\xaf','\xf0'},{'\xd3','\xb4'},{'\xd3','\xb0'},{'\xd3','\xa7'},{'\xd3','\xa2'},
    {'\xaf','\xf6'},{'\xaf','\xf2'},{'\xd3','\x77'},{'\xaf','\xee'},{'\xd3','\xb1'},
    {'\xaf','\xef'},{'\x00','\x00'},{'\xd3','\x79'},{'\x9f','\xcb'},{'\x93','\x54'},
    {'\x00','\x00'},{'\x84','\x75'},{'\x91','\x47'},{'\x8e','\xc7'},{'\x00','\x00'},
    {'\x8e','\xf4'},{'\x8f','\x5f'},{'\x8a','\xf9'},{'\x89','\x57'},{'\x91','\x48'},
    {'\x86','\xd1'},{'\x85','\xfa'},{'\x8e','\x73'},{'\x86','\xe1'},{'\x86','\xdf'},
    {'\x8e','\xf2'},{'\x8f','\x7b'},{'\x87','\x4a'},{'\x88','\x51'},{'\x91','\x49'},
    {'\x8e','\x4d'},{'\x91','\x4a'},{'\x8b','\xb9'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd7','\x5e'},{'\xd7','\x60'},{'\xd7','\x65'},{'\xd7','\x79'},
    {'\xb2','\xfc'},{'\xb2','\xf2'},{'\x00','\x00'},{'\xd7','\x5d'},{'\xb2','\xfd'},
    {'\xb2','\xfe'},{'\xd7','\x68'},{'\xd7','\x6f'},{'\xd7','\x75'},{'\x00','\x00'},
    {'\xd7','\x62'},{'\x00','\x00'},{'\xd7','\x69'},{'\x00','\x00'},{'\x87','\x48'},
    {'\xb3','\x40'},{'\xd7','\x77'},{'\xd7','\x72'},{'\xb2','\xfa'},{'\xb2','\xf8'},
    {'\xd7','\x6e'},{'\xd7','\x6a'},{'\xd7','\x5c'},{'\xb2','\xef'},{'\xd7','\x61'},
    {'\xd7','\x59'},{'\x9f','\xcc'},{'\xb2','\xf7'},{'\xb2','\xf9'},{'\xd7','\x66'},
    {'\xd7','\x63'},{'\xb2','\xf4'},{'\xd7','\x73'},{'\xb2','\xf1'},{'\xd7','\x64'},
    {'\xd7','\x7a'},{'\xd7','\x6c'},{'\x91','\x4b'},{'\xd7','\x6b'},{'\xb2','\xf0'},
    {'\x91','\x4c'},{'\xb2','\xfb'},{'\x00','\x00'},{'\xb2','\xf3'},{'\xd7','\x5a'},
    {'\xd7','\x5f'},{'\xd7','\x70'},{'\xd7','\x76'},{'\xb3','\x41'},{'\xd7','\x5b'},
    {'\xd7','\x67'},{'\xd7','\x6d'},{'\xb2','\xf6'},{'\x9f','\xcd'},{'\x00','\x00'},
    {'\xd7','\x78'},{'\xd7','\x71'},{'\xd7','\x74'},{'\x85','\x50'},{'\x88','\x50'},
    {'\x8e','\x7d'},{'\x85','\xfd'},{'\x91','\x4d'},{'\x8f','\x60'},{'\x89','\xf7'},
    {'\x8e','\xf5'},{'\x87','\xf3'},{'\x8c','\xc2'},{'\x00','\x00'},{'\x91','\x4e'},
    {'\xb2','\xf5'},{'\xfb','\xad'},{'\xdb','\x6c'},{'\xdb','\x60'},{'\xb5','\xd7'},
    {'\xdb','\x7d'},{'\xdb','\xa7'},{'\xdb','\xaa'},{'\xb5','\xd5'},{'\xdb','\x68'},
    {'\xdb','\xa3'},{'\xdb','\x69'},{'\xdb','\x77'},{'\xb5','\xe2'},{'\xdb','\x73'},
    {'\xb5','\xdf'},{'\x9f','\xce'},{'\xdb','\x74'},{'\xdb','\x5d'},{'\x00','\x00'},
    {'\xdb','\xa4'},{'\x00','\x00'},{'\xfe','\x52'},{'\xb5','\xe8'},{'\xdb','\xa1'},
    {'\xdb','\x75'},{'\xdb','\xac'},{'\xdb','\x70'},{'\xdf','\xc8'},{'\x00','\x00'},
    {'\xdb','\xaf'},{'\xb5','\xe6'},{'\xdb','\x6e'},{'\xdb','\x7a'},{'\xb5','\xe9'},
    {'\xb5','\xd4'},{'\xdb','\x72'},{'\xdb','\xad'},{'\xdb','\x6b'},{'\xdb','\x64'},
    {'\xdb','\x6f'},{'\x00','\x00'},{'\xdb','\x63'},{'\xdb','\x61'},{'\xb5','\xd0'},
    {'\xdb','\xa5'},{'\xdb','\x6a'},{'\xdb','\xa8'},{'\x9f','\xcf'},{'\xdb','\xa9'},
    {'\xb5','\xd8'},{'\xb5','\xdd'},{'\xb5','\xd9'},{'\xb5','\xe1'},{'\xdb','\x7e'},
    {'\xb5','\xda'},{'\xdb','\x76'},{'\xdb','\x66'},{'\x91','\x4f'},{'\xb5','\xd2'},
    {'\xdb','\x5e'},{'\xdb','\xa2'},{'\xdb','\xab'},{'\xdb','\x65'},{'\xb5','\xe0'},
    {'\xdb','\xb0'},{'\xdb','\x71'},{'\x00','\x00'},{'\xdb','\x6d'},{'\x00','\x00'},
    {'\xb5','\xd1'},{'\xb5','\xe5'},{'\x9f','\xd0'},{'\xdb','\x7c'},{'\xb5','\xe7'},
    {'\x00','\x00'},{'\xdb','\x78'},{'\xb5','\xdc'},{'\xb5','\xd6'},{'\xb5','\xde'},
    {'\xb5','\xd3'},{'\xb5','\xe4'},{'\xdb','\x79'},{'\xdb','\x67'},{'\xdb','\x7b'},
    {'\xdb','\x62'},{'\xdb','\xa6'},{'\x9f','\xd1'},{'\x00','\x00'},{'\x9f','\xd2'},
    {'\x00','\x00'},{'\x96','\xa7'},{'\x00','\x00'},{'\x00','\x00'},{'\xdb','\xae'},
    {'\x96','\xbd'},{'\x8c','\xfd'},{'\x00','\x00'},{'\x00','\x00'},{'\xfd','\x63'},
    {'\x9f','\xd3'},{'\x94','\xc9'},{'\xdb','\x5f'},{'\x89','\x5b'},{'\x89','\xf1'},
    {'\x89','\x4d'},{'\x89','\x58'},{'\x8a','\xf7'},{'\xdf','\xc7'},{'\x91','\x50'},
    {'\xdf','\xdd'},{'\xb8','\x55'},{'\xdf','\xcc'},{'\x9f','\xd4'},{'\xdf','\xca'},
    {'\xdf','\xb5'},{'\xb8','\xa9'},{'\xdf','\xc5'},{'\xdf','\xd9'},{'\xdf','\xc1'},
    {'\xb8','\xb1'},{'\xdf','\xd8'},{'\xdf','\xbf'},{'\xb5','\xe3'},{'\xdf','\xcf'},
    {'\xdf','\xc0'},{'\xdf','\xd6'},{'\xb8','\xb0'},{'\xb8','\xa8'},{'\x9f','\xd5'},
    {'\xdf','\xaa'},{'\xdf','\xb2'},{'\x00','\x00'},{'\xdf','\xcb'},{'\xdf','\xc3'},
    {'\xdf','\xdc'},{'\xdf','\xc6'},{'\xb8','\xb6'},{'\xdf','\xd7'},{'\x91','\x51'},
    {'\xb8','\xad'},{'\x9f','\xd6'},{'\xdf','\xc9'},{'\xdf','\xd1'},{'\xdf','\xb6'},
    {'\xdf','\xd0'},{'\x00','\x00'},{'\xdf','\xe1'},{'\xdf','\xb1'},{'\xdf','\xd2'},
    {'\x9f','\xd7'},{'\xdf','\xdf'},{'\x9f','\xd8'},{'\xdf','\xab'},{'\xb5','\xdb'},
    {'\x9f','\xd9'},{'\xdf','\xb9'},{'\xdf','\xb8'},{'\xb8','\xaf'},{'\x91','\x52'},
    {'\xdf','\xbc'},{'\xdf','\xbe'},{'\xdf','\xcd'},{'\xdf','\xde'},{'\xb8','\xb2'},
    {'\x91','\x53'},{'\xb8','\xb3'},{'\x9f','\xda'},{'\xdf','\xb0'},{'\xb8','\xab'},
    {'\xdf','\xb4'},{'\xdf','\xda'},{'\xb8','\xb4'},{'\x00','\x00'},{'\xb8','\xac'},
    {'\xb8','\xae'},{'\xb8','\xb5'},{'\xdf','\xe0'},{'\xdf','\xd3'},{'\xdf','\xce'},
    {'\x95','\xf5'},{'\x9f','\xdb'},{'\xdf','\xbb'},{'\xdf','\xba'},{'\xb8','\xaa'},
    {'\xdf','\xac'},{'\xb8','\xa7'},{'\xdf','\xc4'},{'\xdf','\xad'},{'\xdf','\xc2'},
    {'\x96','\xc0'},{'\x00','\x00'},{'\xdf','\xb7'},{'\xdf','\xdb'},{'\x9f','\xdc'},
    {'\x9f','\xdd'},{'\x00','\x00'},{'\xb8','\xa6'},{'\x00','\x00'},{'\x91','\x54'},
    {'\x00','\x00'},{'\xdf','\xb3'},{'\x8e','\xf1'},{'\x91','\x55'},{'\x8e','\xf3'},
    {'\x00','\x00'},{'\x88','\x52'},{'\x8e','\xc8'},{'\xdf','\xaf'},{'\xdf','\xd5'},
    {'\xdf','\xae'},{'\xbb','\x60'},{'\xe3','\xd3'},{'\x9f','\xde'},{'\x9f','\xdf'},
    {'\xe3','\xc2'},{'\x00','\x00'},{'\x9f','\xe0'},{'\xe3','\xac'},{'\xe3','\xca'},
    {'\xbb','\x58'},{'\xe3','\xbb'},{'\xe3','\xc5'},{'\xbb','\x5b'},{'\xe3','\xbe'},
    {'\xbb','\x59'},{'\xe3','\xaf'},{'\xe3','\xcd'},{'\xe3','\xae'},{'\xe3','\xc1'},
    {'\x9f','\xe1'},{'\xe3','\xad'},{'\x00','\x00'},{'\x00','\x00'},{'\xe3','\xbf'},
    {'\xe3','\xc8'},{'\xe3','\xc6'},{'\xe3','\xba'},{'\xe3','\xb5'},{'\xe3','\xb3'},
    {'\xfd','\x66'},{'\xe3','\xb4'},{'\xe3','\xc7'},{'\xe3','\xd2'},{'\xe3','\xbc'},
    {'\xbb','\x5a'},{'\x00','\x00'},{'\xe3','\xb7'},{'\x00','\x00'},{'\xe3','\xcb'},
    {'\x00','\x00'},{'\xbb','\x5d'},{'\xe3','\xb6'},{'\xe3','\xb0'},{'\xe3','\xc0'},
    {'\xbb','\x61'},{'\x96','\xbc'},{'\x9f','\xe2'},{'\xbb','\x55'},{'\xbb','\x5e'},
    {'\xe3','\xb8'},{'\xe3','\xb2'},{'\x00','\x00'},{'\xbb','\x57'},{'\xdf','\xd4'},
    {'\xbb','\x56'},{'\xe3','\xc3'},{'\x00','\x00'},{'\xbb','\x54'},{'\xbb','\x63'},
    {'\xbb','\x5c'},{'\xe3','\xc4'},{'\xe3','\xb9'},{'\xe3','\xb1'},{'\xe3','\xcc'},
    {'\xe3','\xbd'},{'\xbb','\x62'},{'\xe3','\xd0'},{'\xbb','\x5f'},{'\xe3','\xcf'},
    {'\x00','\x00'},{'\xe3','\xc9'},{'\xe3','\xce'},{'\x00','\x00'},{'\x94','\xca'},
    {'\xfd','\x65'},{'\xe3','\xd1'},{'\x91','\x56'},{'\x8a','\xf8'},{'\x9f','\xe3'},
    {'\x8a','\x5e'},{'\x90','\x6c'},{'\x9f','\xe4'},{'\x9f','\xe5'},{'\x91','\x57'},
    {'\x9f','\xe6'},{'\x8f','\xaa'},{'\x8c','\xbd'},{'\xe7','\x73'},{'\xe7','\x74'},
    {'\xe7','\x67'},{'\xe7','\x66'},{'\xe7','\x62'},{'\xbd','\xb4'},{'\x00','\x00'},
    {'\xbd','\xac'},{'\xe7','\x76'},{'\xe7','\x75'},{'\xdf','\xa9'},{'\xe7','\x5f'},
    {'\xe7','\x63'},{'\xe7','\x5d'},{'\x00','\x00'},{'\xe7','\x70'},{'\xe7','\x61'},
    {'\x9f','\xe7'},{'\xe7','\x77'},{'\xe7','\x5a'},{'\xe7','\x58'},{'\xe7','\x64'},
    {'\xe7','\x6e'},{'\xe7','\x69'},{'\xbd','\xb6'},{'\xe7','\x4f'},{'\x00','\x00'},
    {'\xe7','\x6d'},{'\x9f','\xe8'},{'\x00','\x00'},{'\x9f','\xe9'},{'\xbd','\xb7'},
    {'\xdf','\xbd'},{'\xe7','\x5b'},{'\xe7','\x52'},{'\xe7','\x55'},{'\xe7','\x7b'},
    {'\xe7','\x5c'},{'\xe7','\x53'},{'\xe7','\x51'},{'\xe7','\x4e'},{'\x9f','\xea'},
    {'\xbd','\xb0'},{'\xe7','\x65'},{'\xbd','\xaf'},{'\xbd','\xb3'},{'\xe7','\x60'},
    {'\xe7','\x68'},{'\xbd','\xa9'},{'\xe7','\x78'},{'\xe7','\x7c'},{'\xbd','\xab'},
    {'\x00','\x00'},{'\xe7','\x57'},{'\xe7','\x6b'},{'\xe7','\x6f'},{'\xe7','\x54'},
    {'\xe7','\x79'},{'\xbd','\xb2'},{'\x00','\x00'},{'\xbd','\xb1'},{'\xe7','\x4c'},
    {'\xbd','\xb5'},{'\xe7','\x72'},{'\xe7','\x56'},{'\xe7','\x6a'},{'\xe7','\x50'},
    {'\xe7','\x5e'},{'\xe7','\x59'},{'\xbd','\xad'},{'\xbd','\xae'},{'\xe7','\x6c'},
    {'\xe7','\x7d'},{'\xe7','\x7a'},{'\xe7','\x71'},{'\x00','\x00'},{'\x9f','\xeb'},
    {'\xfe','\x4c'},{'\x93','\x60'},{'\x00','\x00'},{'\x8a','\x5d'},{'\x91','\x58'},
    {'\x90','\x46'},{'\x8c','\x4e'},{'\xe7','\x4d'},{'\x8c','\x4d'},{'\xbd','\xaa'},
    {'\xeb','\x49'},{'\x00','\x00'},{'\xeb','\x40'},{'\xeb','\x43'},{'\x9f','\xed'},
    {'\xbf','\xbb'},{'\xeb','\x45'},{'\xea','\xf9'},{'\xeb','\x41'},{'\xeb','\x47'},
    {'\xbf','\xb8'},{'\xbf','\xbc'},{'\xbf','\xb6'},{'\xfd','\x68'},{'\x9f','\xee'},
    {'\xea','\xfb'},{'\xeb','\x4c'},{'\x00','\x00'},{'\x00','\x00'},{'\xeb','\x46'},
    {'\x9f','\xef'},{'\xea','\xfc'},{'\xeb','\x55'},{'\xeb','\x4f'},{'\xea','\xf8'},
    {'\xee','\x46'},{'\xea','\xfe'},{'\xbf','\xb7'},{'\x91','\x59'},{'\xeb','\x4a'},
    {'\x00','\x00'},{'\xeb','\x54'},{'\xbf','\xbf'},{'\x9f','\xf0'},{'\xeb','\x51'},
    {'\xea','\xfd'},{'\xeb','\x44'},{'\xeb','\x48'},{'\xeb','\x42'},{'\xeb','\x56'},
    {'\xeb','\x53'},{'\xeb','\x50'},{'\xbf','\xb9'},{'\xbf','\xba'},{'\xbf','\xbe'},
    {'\xea','\xfa'},{'\xeb','\x57'},{'\xbf','\xbd'},{'\xeb','\x4d'},{'\x9f','\xf1'},
    {'\x9f','\xf2'},{'\xeb','\x4b'},{'\x8f','\xe2'},{'\x9f','\xf3'},{'\x8c','\x51'},
    {'\xeb','\x4e'},{'\xee','\x53'},{'\xee','\x40'},{'\xee','\x45'},{'\xee','\x52'},
    {'\xee','\x44'},{'\xed','\xfb'},{'\xee','\x41'},{'\x00','\x00'},{'\xc1','\xa2'},
    {'\x00','\x00'},{'\xed','\xf4'},{'\xee','\x4d'},{'\xee','\x4f'},{'\xed','\xf3'},
    {'\xc1','\xa1'},{'\xee','\x51'},{'\xee','\x49'},{'\xc1','\xa8'},{'\xee','\x50'},
    {'\xee','\x42'},{'\xc1','\xaa'},{'\xed','\xf9'},{'\xeb','\x52'},{'\xee','\x4a'},
    {'\xee','\x47'},{'\xed','\xf5'},{'\xee','\x55'},{'\xc1','\xa4'},{'\x00','\x00'},
    {'\x9d','\x76'},{'\xc1','\xa5'},{'\xed','\xf7'},{'\xee','\x48'},{'\x91','\x5a'},
    {'\xee','\x54'},{'\xee','\x4b'},{'\xed','\xfd'},{'\xc1','\xa7'},{'\xc1','\xa3'},
    {'\xee','\x4c'},{'\xed','\xfe'},{'\xee','\x56'},{'\xed','\xf8'},{'\xee','\x43'},
    {'\xee','\x4e'},{'\xed','\xfa'},{'\xed','\xfc'},{'\x00','\x00'},{'\xc2','\xcb'},
    {'\xed','\xf6'},{'\xc1','\xa9'},{'\xc2','\xc4'},{'\xc1','\x7e'},{'\x91','\x5b'},
    {'\x93','\xd6'},{'\x00','\x00'},{'\x82','\x7e'},{'\xc1','\xa6'},{'\xc2','\xc8'},
    {'\xf0','\xb3'},{'\x00','\x00'},{'\xf0','\xa9'},{'\xf0','\xa4'},{'\xf0','\xaa'},
    {'\xf0','\xb4'},{'\xf0','\xb8'},{'\xf0','\xb7'},{'\xc2','\xca'},{'\xc2','\xc9'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf0','\xab'},{'\xf0','\xb9'},{'\xf0','\xae'},
    {'\xf0','\xa6'},{'\x91','\x5c'},{'\xf0','\xa8'},{'\xf0','\xa7'},{'\xf0','\xad'},
    {'\xf0','\xb2'},{'\xf0','\xa5'},{'\xf0','\xac'},{'\xf0','\xb1'},{'\xc2','\xc7'},
    {'\x00','\x00'},{'\xf0','\xaf'},{'\x00','\x00'},{'\xc2','\xc5'},{'\xf0','\xb0'},
    {'\xc2','\xc3'},{'\xc2','\xc6'},{'\xf2','\xd5'},{'\xf0','\xb5'},{'\x8c','\xa4'},
    {'\x00','\x00'},{'\xc3','\xc2'},{'\x9f','\xf4'},{'\xf2','\xcd'},{'\xf2','\xd1'},
    {'\xf2','\xc9'},{'\xf2','\xcc'},{'\x00','\x00'},{'\xf2','\xd4'},{'\xc3','\xc0'},
    {'\xf2','\xd9'},{'\xf2','\xd2'},{'\x9f','\xf5'},{'\xf2','\xca'},{'\xf2','\xda'},
    {'\xf2','\xd3'},{'\xc3','\xc3'},{'\xc3','\xc4'},{'\xf2','\xd7'},{'\x00','\x00'},
    {'\xf2','\xcb'},{'\xc3','\xbf'},{'\xc3','\xc1'},{'\xf2','\xc6'},{'\xf2','\xce'},
    {'\xf2','\xc8'},{'\x9f','\xf6'},{'\xf2','\xd8'},{'\xf2','\xd6'},{'\xf2','\xc7'},
    {'\xf2','\xcf'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xf4','\xbe'},
    {'\xc3','\xc5'},{'\xf2','\xd0'},{'\xc4','\xa7'},{'\xc4','\xa9'},{'\xc4','\xa6'},
    {'\x9f','\xf7'},{'\xf4','\xc3'},{'\xf4','\xbb'},{'\xf4','\xb9'},{'\xf4','\xbd'},
    {'\xf4','\xba'},{'\xfd','\x6a'},{'\x00','\x00'},{'\xf4','\xbf'},{'\xf4','\xc1'},
    {'\xc4','\xaa'},{'\xc4','\xac'},{'\x00','\x00'},{'\xf4','\xc0'},{'\xc4','\xad'},
    {'\xc4','\xab'},{'\xf4','\xc2'},{'\x9f','\xf8'},{'\x00','\x00'},{'\x9f','\xf9'},
    {'\xfd','\x6b'},{'\xc4','\xa8'},{'\x00','\x00'},{'\x91','\x5d'},{'\x9f','\xfa'},
    {'\x00','\x00'},{'\x91','\x5e'},{'\xc4','\xf4'},{'\xf5','\xf1'},{'\xf5','\xf7'},
    {'\xc4','\xf6'},{'\xf4','\xbc'},{'\xf5','\xf6'},{'\x00','\x00'},{'\xf5','\xfd'},
    {'\xf5','\xf4'},{'\xf5','\xfb'},{'\xf5','\xfa'},{'\xf4','\xb8'},{'\xf5','\xf5'},
    {'\xf0','\xb6'},{'\xf5','\xfe'},{'\xf5','\xf3'},{'\xf5','\xf8'},{'\x9f','\xfb'},
    {'\xf5','\xfc'},{'\xf5','\xf2'},{'\x00','\x00'},{'\xf7','\x4a'},{'\xc4','\xf5'},
    {'\xf5','\xf9'},{'\xfb','\xae'},{'\x94','\xcb'},{'\xf7','\xf4'},{'\xf7','\x4b'},
    {'\xf7','\x49'},{'\xf7','\x47'},{'\xf7','\x48'},{'\xf7','\x4c'},{'\x00','\x00'},
    {'\xc5','\xd9'},{'\xf7','\xf2'},{'\xf7','\xf0'},{'\xf7','\xf5'},{'\xf7','\xf3'},
    {'\x00','\x00'},{'\xf7','\xf6'},{'\xc5','\xda'},{'\xf7','\xf1'},{'\x00','\x00'},
    {'\x9f','\xfc'},{'\xf8','\xbc'},{'\x00','\x00'},{'\x9f','\xfd'},{'\xf9','\x45'},
    {'\xf9','\x46'},{'\xf9','\x47'},{'\x00','\x00'},{'\x00','\x00'},{'\xf9','\xc7'},
    {'\xf9','\xbd'},{'\xca','\x4f'},{'\xaa','\xea'},{'\x86','\x40'},{'\xad','\x68'},
    {'\x87','\xcb'},{'\xd3','\xb8'},{'\xd3','\xb7'},{'\xb0','\x40'},{'\xb3','\x42'},
    {'\xd7','\x7c'},{'\x00','\x00'},{'\x00','\x00'},{'\xd7','\x7b'},{'\x85','\x52'},
    {'\xb5','\xea'},{'\xb8','\xb8'},{'\x00','\x00'},{'\xb8','\xb7'},{'\xb8','\xb9'},
    {'\x00','\x00'},{'\xe3','\xd4'},{'\xe7','\x7e'},{'\xeb','\x58'},{'\xeb','\x5a'},
    {'\xeb','\x59'},{'\x00','\x00'},{'\xc1','\xab'},{'\xee','\x57'},{'\xf0','\xba'},
    {'\xf9','\xa5'},{'\xa6','\xe4'},{'\x95','\x78'},{'\xcd','\xc9'},{'\xcd','\xca'},
    {'\xcd','\xc8'},{'\xcd','\xc7'},{'\xaa','\xeb'},{'\x9f','\xfe'},{'\xd0','\xa9'},
    {'\xd0','\xa7'},{'\x00','\x00'},{'\x00','\x00'},{'\xd0','\xa6'},{'\x00','\x00'},
    {'\xad','\x69'},{'\xad','\x6b'},{'\xad','\x6a'},{'\xd0','\xa8'},{'\x8a','\xaf'},
    {'\x88','\x53'},{'\x8f','\xc4'},{'\x87','\x4c'},{'\x8b','\xba'},{'\x89','\x5a'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xd3','\xc4'},{'\xd3','\xc1'},{'\xd3','\xbf'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb0','\x41'},{'\xd3','\xc2'},{'\xb0','\x46'},
    {'\xd3','\xbc'},{'\xd3','\xcb'},{'\x00','\x00'},{'\xd3','\xcd'},{'\xd3','\xbd'},
    {'\xfe','\xbb'},{'\xb0','\x43'},{'\xd3','\xce'},{'\xd3','\xc9'},{'\xd3','\xbb'},
    {'\xd3','\xc0'},{'\xd3','\xca'},{'\xd3','\xc6'},{'\xd3','\xc3'},{'\x00','\x00'},
    {'\xb0','\x48'},{'\xd3','\xcc'},{'\xd3','\xbe'},{'\x00','\x00'},{'\xfe','\xbc'},
    {'\xd3','\xc7'},{'\xd3','\xb9'},{'\xb0','\x47'},{'\xb0','\x44'},{'\xd3','\xc5'},
    {'\x00','\x00'},{'\xd3','\xc8'},{'\xd3','\xba'},{'\xb0','\x45'},{'\xb0','\x42'},
    {'\x94','\xcc'},{'\x86','\x43'},{'\xfe','\xbd'},{'\x00','\x00'},{'\xb3','\x4c'},
    {'\xd7','\xa5'},{'\xb3','\x4b'},{'\xfe','\xbe'},{'\xd7','\xa8'},{'\xd7','\xab'},
    {'\xb3','\x48'},{'\xb3','\x46'},{'\xd7','\x7e'},{'\xd7','\xa9'},{'\xd7','\xa7'},
    {'\xd7','\xa4'},{'\xd7','\xac'},{'\xd7','\xad'},{'\xd7','\xaf'},{'\xd7','\xb0'},
    {'\xd7','\x7d'},{'\xb3','\x45'},{'\xd7','\xa2'},{'\xd7','\xa1'},{'\xd7','\xae'},
    {'\xb3','\x47'},{'\xd7','\xa3'},{'\xb3','\x49'},{'\xb3','\x44'},{'\xd7','\xa6'},
    {'\xb3','\x4d'},{'\x8c','\xfe'},{'\xb3','\x4a'},{'\xd7','\xaa'},{'\x92','\xac'},
    {'\x82','\x4c'},{'\x8f','\xc3'},{'\xb5','\xf1'},{'\xdb','\xbf'},{'\x00','\x00'},
    {'\xdb','\xb4'},{'\xb5','\xee'},{'\x00','\x00'},{'\xdf','\xe7'},{'\xdb','\xbd'},
    {'\xdb','\xb1'},{'\xb5','\xec'},{'\xdb','\xb6'},{'\xb5','\xef'},{'\xdb','\xba'},
    {'\xdb','\xb8'},{'\xb5','\xf2'},{'\xb5','\xeb'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xdb','\xb2'},{'\xdb','\xb5'},{'\xb5','\xf0'},{'\x00','\x00'},{'\xdb','\xb3'},
    {'\x00','\x00'},{'\xdb','\xbe'},{'\xdb','\xbc'},{'\xdb','\xb7'},{'\xdb','\xb9'},
    {'\xdb','\xbb'},{'\xb5','\xed'},{'\x8d','\x72'},{'\x94','\xcd'},{'\x8f','\x61'},
    {'\x8e','\x4e'},{'\x8a','\xfa'},{'\x8e','\xf7'},{'\x8f','\xe3'},{'\xdf','\xe8'},
    {'\xdf','\xee'},{'\xdf','\xe4'},{'\xdf','\xea'},{'\xb8','\xba'},{'\xdf','\xe6'},
    {'\xb8','\xc0'},{'\x00','\x00'},{'\x00','\x00'},{'\xb8','\xbf'},{'\x00','\x00'},
    {'\xb8','\xbe'},{'\xdf','\xed'},{'\xb8','\xc1'},{'\xb8','\xc2'},{'\xdf','\xe3'},
    {'\xdf','\xf0'},{'\xb8','\xc3'},{'\xb8','\xbd'},{'\xb8','\xbc'},{'\xdf','\xec'},
    {'\xb8','\xc4'},{'\xdf','\xe2'},{'\xdf','\xe5'},{'\xdf','\xef'},{'\xdf','\xeb'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xe3','\xf4'},{'\xe3','\xe9'},{'\xb8','\xbb'},
    {'\x00','\x00'},{'\x91','\x60'},{'\x00','\x00'},{'\x88','\x54'},{'\xbb','\x6a'},
    {'\xe3','\xdd'},{'\xe3','\xf2'},{'\xe3','\xde'},{'\xbb','\x65'},{'\x00','\x00'},
    {'\xe3','\xdb'},{'\x00','\x00'},{'\xe3','\xe4'},{'\xe3','\xdc'},{'\xbb','\x67'},
    {'\xe3','\xd6'},{'\xe3','\xf1'},{'\xbb','\x68'},{'\xe3','\xee'},{'\xe3','\xef'},
    {'\xe3','\xd7'},{'\xbb','\x6d'},{'\xe3','\xe6'},{'\x00','\x00'},{'\xe3','\xe0'},
    {'\xe3','\xe7'},{'\xe3','\xda'},{'\x00','\x00'},{'\xe3','\xf3'},{'\xe3','\xeb'},
    {'\xe3','\xe5'},{'\xe3','\xd5'},{'\xbb','\x69'},{'\xe3','\xec'},{'\x00','\x00'},
    {'\xbb','\x6c'},{'\xe3','\xf0'},{'\x00','\x00'},{'\xe3','\xea'},{'\xbb','\x66'},
    {'\xe3','\xe8'},{'\x00','\x00'},{'\xe3','\xe2'},{'\xbb','\x64'},{'\xe3','\xd9'},
    {'\xe3','\xe1'},{'\xe3','\xed'},{'\xe3','\xdf'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe3','\xe3'},{'\x8b','\xbb'},{'\x8a','\x61'},{'\x8a','\xfb'},{'\x00','\x00'},
    {'\x82','\xa2'},{'\xbd','\xc1'},{'\xdf','\xe9'},{'\xe7','\xb2'},{'\xe7','\xbb'},
    {'\xe7','\xb1'},{'\xe7','\xad'},{'\xe7','\xaa'},{'\xbd','\xc2'},{'\xe7','\xa8'},
    {'\xbb','\x6b'},{'\xe7','\xa1'},{'\xbd','\xc0'},{'\xe7','\xa7'},{'\xbd','\xbf'},
    {'\xe7','\xac'},{'\xe7','\xa9'},{'\xe7','\xb9'},{'\xe7','\xb4'},{'\xe7','\xae'},
    {'\xe7','\xb3'},{'\xbd','\xbb'},{'\xe7','\xab'},{'\xe7','\xbe'},{'\xe7','\xa2'},
    {'\xe7','\xa3'},{'\xe7','\xba'},{'\xbd','\xbc'},{'\xe7','\xbf'},{'\xbd','\xbe'},
    {'\xe7','\xc0'},{'\xe7','\xb0'},{'\xe3','\xd8'},{'\xe7','\xb6'},{'\xe7','\xaf'},
    {'\xe7','\xb8'},{'\xe7','\xb5'},{'\x91','\x61'},{'\xfd','\x45'},{'\x00','\x00'},
    {'\xe7','\xa6'},{'\xbd','\xb9'},{'\xe7','\xbd'},{'\xbd','\xba'},{'\xe7','\xa4'},
    {'\xbd','\xbd'},{'\xeb','\x64'},{'\xe7','\xb7'},{'\xe7','\xbc'},{'\x8a','\x60'},
    {'\x91','\x62'},{'\x8f','\xe4'},{'\x82','\x75'},{'\x00','\x00'},{'\xeb','\x61'},
    {'\xbd','\xb8'},{'\xbf','\xc0'},{'\xeb','\x6b'},{'\xeb','\x67'},{'\xfb','\x6c'},
    {'\xeb','\x65'},{'\xeb','\x60'},{'\xeb','\x6f'},{'\x00','\x00'},{'\x91','\x63'},
    {'\xfd','\x47'},{'\xbf','\xc4'},{'\x00','\x00'},{'\xeb','\x5c'},{'\xeb','\x68'},
    {'\xeb','\x69'},{'\xeb','\x5f'},{'\xeb','\x5e'},{'\xeb','\x6c'},{'\x00','\x00'},
    {'\xeb','\x62'},{'\xeb','\x5d'},{'\xeb','\x63'},{'\x00','\x00'},{'\xeb','\x6e'},
    {'\xeb','\x5b'},{'\xeb','\x6d'},{'\xeb','\x6a'},{'\xbf','\xc2'},{'\xbf','\xc1'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xbf','\xc3'},{'\xeb','\x66'},{'\xf0','\xcb'},
    {'\xfe','\xbf'},{'\x00','\x00'},{'\x00','\x00'},{'\x91','\x64'},{'\xfd','\x46'},
    {'\xee','\x59'},{'\xc1','\xb1'},{'\xee','\x5d'},{'\xee','\x5a'},{'\xee','\x61'},
    {'\xee','\x67'},{'\xee','\x5c'},{'\xfe','\xc0'},{'\xee','\x70'},{'\xc1','\xae'},
    {'\xee','\x6a'},{'\xee','\x5f'},{'\xee','\x6b'},{'\xee','\x66'},{'\xee','\x6d'},
    {'\xee','\x5e'},{'\xc1','\xb3'},{'\xc1','\xb2'},{'\xee','\x60'},{'\xee','\x6e'},
    {'\xee','\x58'},{'\xee','\x6c'},{'\xc1','\xac'},{'\xfd','\x49'},{'\xee','\x64'},
    {'\xee','\x63'},{'\xee','\x68'},{'\xee','\x5b'},{'\xc1','\xb0'},{'\x91','\x65'},
    {'\xc1','\xb4'},{'\xee','\x62'},{'\xee','\x69'},{'\xc1','\xb5'},{'\xee','\x65'},
    {'\x00','\x00'},{'\x96','\xc7'},{'\x00','\x00'},{'\x91','\x66'},{'\xc1','\xad'},
    {'\xc1','\xaf'},{'\xf0','\xc7'},{'\xf0','\xc5'},{'\x00','\x00'},{'\xfd','\x4c'},
    {'\xf0','\xcc'},{'\xf0','\xc9'},{'\xf0','\xcd'},{'\xfe','\xc5'},{'\xf0','\xbe'},
    {'\xf0','\xc6'},{'\xf0','\xd1'},{'\xee','\x6f'},{'\xf0','\xc2'},{'\xc2','\xcf'},
    {'\xe7','\xa5'},{'\xf0','\xbd'},{'\xf0','\xca'},{'\xf0','\xc4'},{'\xf0','\xc1'},
    {'\xf0','\xbc'},{'\xf0','\xbb'},{'\xf0','\xd0'},{'\x00','\x00'},{'\xf0','\xc0'},
    {'\xf0','\xbf'},{'\xc2','\xcd'},{'\xf0','\xc8'},{'\xfb','\xab'},{'\xc2','\xcc'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc2','\xce'},{'\xf0','\xc3'},{'\xf0','\xcf'},
    {'\xfd','\x4d'},{'\xf2','\xde'},{'\xf2','\xdf'},{'\x00','\x00'},{'\xc3','\xc9'},
    {'\xf2','\xdc'},{'\xc3','\xc6'},{'\xf2','\xe4'},{'\x00','\x00'},{'\xc3','\xca'},
    {'\xf2','\xe6'},{'\xf2','\xdb'},{'\xf0','\xce'},{'\xf2','\xe8'},{'\xf2','\xdd'},
    {'\xfb','\x72'},{'\xc3','\xc7'},{'\xf2','\xe3'},{'\x91','\x67'},{'\xf2','\xe5'},
    {'\xf2','\xe0'},{'\xf2','\xe7'},{'\xf2','\xe2'},{'\xf2','\xe1'},{'\xc3','\xc8'},
    {'\x91','\x68'},{'\xfd','\x4e'},{'\xf4','\xc5'},{'\xf4','\xc6'},{'\x00','\x00'},
    {'\xf4','\xc8'},{'\xc4','\xae'},{'\xc4','\xaf'},{'\xf4','\xc9'},{'\xf4','\xc7'},
    {'\xfd','\x4f'},{'\xf4','\xc4'},{'\x00','\x00'},{'\xf6','\x42'},{'\xf6','\x45'},
    {'\xf6','\x41'},{'\x00','\x00'},{'\xc4','\xfa'},{'\xf6','\x43'},{'\xc4','\xf9'},
    {'\xc4','\xf8'},{'\xc4','\xf7'},{'\xf6','\x44'},{'\xf7','\x51'},{'\xf7','\x4f'},
    {'\x91','\x69'},{'\xf7','\x4e'},{'\xf6','\x40'},{'\xf7','\x50'},{'\xf6','\x46'},
    {'\xf7','\x4d'},{'\xfd','\x50'},{'\xf7','\xf9'},{'\xf7','\xd7'},{'\xf7','\xf7'},
    {'\xc5','\xdb'},{'\xf7','\xf8'},{'\xf7','\xfa'},{'\x00','\x00'},{'\xf8','\xbf'},
    {'\xc5','\xfa'},{'\xf8','\xbe'},{'\xf8','\xbd'},{'\xc5','\xfb'},{'\x00','\x00'},
    {'\xc6','\x5a'},{'\xf9','\x6e'},{'\xf9','\xa7'},{'\xf9','\xa6'},{'\xf9','\xa8'},
    {'\xa6','\xe5'},{'\xd0','\xaa'},{'\xfd','\x51'},{'\xd3','\xcf'},{'\xd3','\xd0'},
    {'\x8d','\x75'},{'\x92','\xdb'},{'\x00','\x00'},{'\xdb','\xc0'},{'\x00','\x00'},
    {'\xf6','\x47'},{'\xf8','\xc0'},{'\xa6','\xe6'},{'\xad','\x6c'},{'\xd0','\xab'},
    {'\xfe','\xc6'},{'\x00','\x00'},{'\x00','\x00'},{'\xd7','\xb1'},{'\xb3','\x4e'},
    {'\x83','\xf5'},{'\xdb','\xc2'},{'\xdb','\xc1'},{'\xb5','\xf3'},{'\x00','\x00'},
    {'\xb8','\xc5'},{'\xe7','\xc1'},{'\xbd','\xc3'},{'\x00','\x00'},{'\xbd','\xc4'},
    {'\xfd','\x5b'},{'\x00','\x00'},{'\xfe','\xc7'},{'\xbf','\xc5'},{'\xc5','\xfc'},
    {'\xa6','\xe7'},{'\x91','\xd6'},{'\x86','\x44'},{'\x00','\x00'},{'\xd0','\xac'},
    {'\xaa','\xed'},{'\xd0','\xae'},{'\xd0','\xad'},{'\xad','\x6d'},{'\x8c','\xdc'},
    {'\xd3','\xd1'},{'\x84','\x7c'},{'\xd3','\xd8'},{'\xb0','\x49'},{'\xd3','\xd6'},
    {'\xd3','\xd4'},{'\x00','\x00'},{'\xd3','\xdb'},{'\xd3','\xd2'},{'\xd3','\xd3'},
    {'\xb0','\x4a'},{'\x00','\x00'},{'\xb0','\x4e'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xd3','\xdc'},{'\xb0','\x4d'},{'\xd3','\xda'},{'\xd3','\xd7'},{'\xd3','\xd5'},
    {'\xb0','\x4b'},{'\xb0','\x4c'},{'\xd3','\xd9'},{'\x8b','\xbd'},{'\x88','\xd3'},
    {'\x00','\x00'},{'\xfe','\xc8'},{'\xb3','\x50'},{'\xd7','\xb2'},{'\x00','\x00'},
    {'\xb3','\x55'},{'\xd7','\xc2'},{'\xb3','\x54'},{'\xd7','\xc4'},{'\xfe','\xc9'},
    {'\xfe','\xca'},{'\xd7','\xb8'},{'\xb3','\x52'},{'\xd7','\xc3'},{'\x00','\x00'},
    {'\xd7','\xb3'},{'\xb3','\x53'},{'\xd7','\xbf'},{'\xd7','\xbb'},{'\xd7','\xbd'},
    {'\xd7','\xb7'},{'\xd7','\xbe'},{'\x90','\xba'},{'\x00','\x00'},{'\xb3','\x4f'},
    {'\xd7','\xba'},{'\xfd','\x56'},{'\xd7','\xb9'},{'\xd7','\xb5'},{'\x00','\x00'},
    {'\xd7','\xc0'},{'\x00','\x00'},{'\x00','\x00'},{'\xd7','\xbc'},{'\xd7','\xb4'},
    {'\x00','\x00'},{'\xd7','\xb6'},{'\xb3','\x51'},{'\xd7','\xc1'},{'\x8c','\xdb'},
    {'\x91','\x6a'},{'\x00','\x00'},{'\x94','\xce'},{'\xb5','\xf6'},{'\xdb','\xcd'},
    {'\x00','\x00'},{'\x95','\xdd'},{'\x91','\x6c'},{'\xdb','\xc9'},{'\xdb','\xcb'},
    {'\xdb','\xc6'},{'\xdb','\xc5'},{'\xdb','\xc3'},{'\x00','\x00'},{'\xdb','\xca'},
    {'\xdb','\xcc'},{'\xdb','\xc8'},{'\x91','\x6d'},{'\xdb','\xc7'},{'\xb5','\xf4'},
    {'\xb5','\xf5'},{'\x94','\xcf'},{'\x94','\xd0'},{'\x86','\x45'},{'\x8b','\xbc'},
    {'\xfb','\x63'},{'\x00','\x00'},{'\xdb','\xcf'},{'\xb8','\xcd'},{'\xdf','\xf2'},
    {'\xdf','\xf8'},{'\xdf','\xf3'},{'\xdf','\xf4'},{'\xf9','\xd8'},{'\xdf','\xf9'},
    {'\x00','\x00'},{'\xb8','\xcf'},{'\x00','\x00'},{'\xb8','\xc7'},{'\xb8','\xce'},
    {'\xdf','\xf1'},{'\xdb','\xc4'},{'\xb8','\xca'},{'\xb8','\xc8'},{'\xdf','\xf7'},
    {'\xdf','\xf6'},{'\xb8','\xc9'},{'\xb8','\xcb'},{'\xdf','\xf5'},{'\xb8','\xc6'},
    {'\x00','\x00'},{'\xb8','\xcc'},{'\x8f','\x62'},{'\x8f','\xc5'},{'\x89','\x5c'},
    {'\x91','\x6e'},{'\xfe','\xcb'},{'\xe3','\xf6'},{'\xbb','\x74'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe4','\x42'},{'\xe4','\x41'},{'\x00','\x00'},{'\xe3','\xfb'},
    {'\xbb','\x76'},{'\xe4','\x40'},{'\xe3','\xf7'},{'\xe3','\xf8'},{'\xbb','\x6e'},
    {'\xbb','\x70'},{'\x91','\x6f'},{'\xe3','\xfd'},{'\xe3','\xf5'},{'\xbb','\x72'},
    {'\xbb','\x71'},{'\xe3','\xf9'},{'\xe3','\xfe'},{'\xe3','\xfc'},{'\xbb','\x73'},
    {'\xe3','\xfa'},{'\xfe','\xcc'},{'\xfe','\xcd'},{'\xdb','\xce'},{'\xbb','\x6f'},
    {'\x00','\x00'},{'\x94','\xd1'},{'\xe7','\xc2'},{'\xe7','\xc9'},{'\xbd','\xc6'},
    {'\x00','\x00'},{'\xe7','\xcd'},{'\xbd','\xca'},{'\xe7','\xc5'},{'\xe7','\xc3'},
    {'\x00','\x00'},{'\xe7','\xcc'},{'\x00','\x00'},{'\xbd','\xc5'},{'\xe7','\xcb'},
    {'\xbd','\xc7'},{'\xbd','\xc8'},{'\xe7','\xc4'},{'\xbd','\xc9'},{'\xe7','\xca'},
    {'\xe7','\xc6'},{'\xe7','\xc7'},{'\xe7','\xc8'},{'\xbb','\x75'},{'\x8a','\x63'},
    {'\x91','\x70'},{'\x91','\x71'},{'\xeb','\x70'},{'\xeb','\x7c'},{'\x00','\x00'},
    {'\xbf','\xca'},{'\xeb','\x77'},{'\xeb','\x79'},{'\xfe','\xce'},{'\xbf','\xc8'},
    {'\xeb','\x71'},{'\xeb','\x75'},{'\x00','\x00'},{'\xeb','\x78'},{'\xbf','\xc6'},
    {'\xbf','\xc9'},{'\xeb','\x7b'},{'\xeb','\x73'},{'\xeb','\x74'},{'\xeb','\x7a'},
    {'\xeb','\x72'},{'\xeb','\x76'},{'\xbf','\xc7'},{'\xee','\x72'},{'\x8c','\x53'},
    {'\xee','\x71'},{'\xc1','\xb7'},{'\xee','\x77'},{'\xc1','\xb9'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc1','\xb6'},{'\xee','\x73'},{'\xc1','\xba'},{'\xee','\x74'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xee','\x75'},{'\xee','\x78'},{'\xfd','\x58'},
    {'\xc1','\xb8'},{'\x00','\x00'},{'\xf0','\xd6'},{'\xfe','\xcf'},{'\x00','\x00'},
    {'\xf0','\xd9'},{'\x00','\x00'},{'\xf0','\xd3'},{'\xf0','\xd5'},{'\xfd','\x59'},
    {'\x00','\x00'},{'\xf0','\xd4'},{'\xf0','\xd7'},{'\xf0','\xd8'},{'\xee','\x76'},
    {'\xf0','\xd2'},{'\xfe','\xd0'},{'\x00','\x00'},{'\xc3','\xcd'},{'\xf2','\xec'},
    {'\xf2','\xef'},{'\xf2','\xf1'},{'\xf2','\xea'},{'\xf2','\xeb'},{'\xf2','\xee'},
    {'\xf2','\xf0'},{'\xc3','\xce'},{'\xc3','\xcc'},{'\xc3','\xcb'},{'\xf2','\xed'},
    {'\xf2','\xe9'},{'\xf4','\xca'},{'\xc4','\xb0'},{'\xfe','\xd1'},{'\xf4','\xcb'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf6','\x49'},{'\xc4','\xfb'},{'\xf6','\x4b'},
    {'\xc4','\xfc'},{'\xf6','\x48'},{'\xf6','\x4a'},{'\xc5','\xa8'},{'\x00','\x00'},
    {'\xf7','\x52'},{'\xc5','\xa7'},{'\xf7','\xfd'},{'\xf7','\xfc'},{'\x00','\x00'},
    {'\xf7','\xfb'},{'\x91','\x72'},{'\x00','\x00'},{'\xf9','\x48'},{'\xf9','\x49'},
    {'\xf9','\x4b'},{'\xf9','\x4a'},{'\x00','\x00'},{'\xca','\x50'},{'\xa6','\xe8'},
    {'\xfe','\xd2'},{'\xad','\x6e'},{'\xd7','\xc5'},{'\xb5','\xf7'},{'\x00','\x00'},
    {'\xdf','\xfa'},{'\xc2','\xd0'},{'\x95','\xf6'},{'\xf2','\xf2'},{'\xfd','\x6d'},
    {'\xfd','\x6e'},{'\xa8','\xa3'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb3','\x57'},{'\x00','\x00'},{'\xfe','\xd3'},{'\x00','\x00'},{'\xb3','\x56'},
    {'\xfd','\x6f'},{'\xdb','\xd0'},{'\xb5','\xf8'},{'\xdb','\xd2'},{'\xdb','\xd1'},
    {'\x00','\x00'},{'\x92','\x60'},{'\xdf','\xfb'},{'\xb8','\xd0'},{'\xe4','\x43'},
    {'\xe4','\x46'},{'\xe4','\x45'},{'\x00','\x00'},{'\xe4','\x44'},{'\xe7','\xce'},
    {'\xe7','\xd0'},{'\xe7','\xcf'},{'\xfb','\xaf'},{'\xbf','\xcc'},{'\x93','\xe1'},
    {'\x00','\x00'},{'\x95','\xc5'},{'\xbf','\xcb'},{'\x00','\x00'},{'\xc1','\xbb'},
    {'\xee','\x79'},{'\xee','\x7b'},{'\xee','\x7a'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc2','\xd1'},{'\x92','\x6d'},{'\x00','\x00'},{'\x00','\x00'},{'\xf2','\xf4'},
    {'\xf2','\xf3'},{'\x00','\x00'},{'\xf4','\xcc'},{'\xc4','\xb1'},{'\x00','\x00'},
    {'\xfd','\x71'},{'\xc4','\xfd'},{'\xf7','\x54'},{'\xf7','\x53'},{'\xc6','\x5b'},
    {'\x83','\x4e'},{'\x8d','\x73'},{'\x00','\x00'},{'\x84','\x7e'},{'\x84','\x7d'},
    {'\x85','\x53'},{'\x8d','\xe6'},{'\x8c','\xa6'},{'\x8c','\x54'},{'\x8a','\x64'},
    {'\x8e','\x7e'},{'\x90','\x5c'},{'\x00','\x00'},{'\x89','\x5e'},{'\x8f','\x63'},
    {'\x8a','\xfc'},{'\x8f','\xc6'},{'\xa8','\xa4'},{'\xd0','\xaf'},{'\xad','\x6f'},
    {'\xd7','\xc8'},{'\xd7','\xc6'},{'\x00','\x00'},{'\x00','\x00'},{'\xd7','\xc7'},
    {'\xdb','\xd4'},{'\xdb','\xd5'},{'\xe0','\x43'},{'\xdb','\xd3'},{'\x8a','\xfd'},
    {'\xdf','\xfc'},{'\xe0','\x41'},{'\xe0','\x40'},{'\xe0','\x42'},{'\xb8','\xd1'},
    {'\xdf','\xfe'},{'\xdf','\xfd'},{'\xe0','\x44'},{'\x91','\x73'},{'\xe4','\x49'},
    {'\xe4','\x47'},{'\x00','\x00'},{'\xe4','\x48'},{'\xe7','\xd3'},{'\xe7','\xd1'},
    {'\x00','\x00'},{'\x8f','\xc7'},{'\xe7','\xd2'},{'\xeb','\x7d'},{'\xee','\x7c'},
    {'\xee','\x7d'},{'\xc2','\xd2'},{'\x00','\x00'},{'\xf2','\xf5'},{'\xf4','\xcd'},
    {'\xc4','\xb2'},{'\x00','\x00'},{'\xf6','\x4c'},{'\xf7','\x55'},{'\xc5','\xa9'},
    {'\x00','\x00'},{'\xf7','\xfe'},{'\xf9','\x4c'},{'\xa8','\xa5'},{'\x00','\x00'},
    {'\xad','\x71'},{'\xad','\x72'},{'\xd0','\xb0'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xd0','\xb1'},{'\xad','\x70'},{'\x00','\x00'},{'\xb0','\x54'},{'\x00','\x00'},
    {'\xb0','\x52'},{'\x00','\x00'},{'\xb0','\x51'},{'\xb0','\x58'},{'\xb0','\x50'},
    {'\xb0','\x59'},{'\xd3','\xdd'},{'\xb0','\x56'},{'\x00','\x00'},{'\xb0','\x53'},
    {'\xb0','\x57'},{'\xb0','\x55'},{'\xb0','\x4f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb3','\x5f'},{'\xfe','\xd4'},{'\xb3','\x59'},{'\xd7','\xcc'},{'\xb3','\x5e'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb3','\x60'},{'\xb3','\x5a'},{'\x00','\x00'},
    {'\xb3','\x5b'},{'\x00','\x00'},{'\xd7','\xca'},{'\x00','\x00'},{'\xfe','\xd5'},
    {'\xb3','\x58'},{'\xfe','\xd6'},{'\xd7','\xcb'},{'\xb3','\x5d'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd7','\xc9'},{'\xb3','\x5c'},{'\x00','\x00'},{'\x93','\xd5'},
    {'\xb6','\x44'},{'\x00','\x00'},{'\xb6','\x46'},{'\x91','\x74'},{'\xfe','\xd7'},
    {'\xdb','\xd8'},{'\xb6','\x45'},{'\xb5','\xf9'},{'\xb5','\xfd'},{'\xfe','\xd8'},
    {'\xb8','\xe4'},{'\xe0','\x49'},{'\xdb','\xda'},{'\xb5','\xfe'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xdb','\xdd'},{'\xdb','\xde'},{'\xb6','\x43'},{'\x00','\x00'},
    {'\xdb','\xe0'},{'\xfd','\x73'},{'\xdb','\xe2'},{'\x00','\x00'},{'\xdb','\xe3'},
    {'\xdb','\xd7'},{'\xdb','\xd6'},{'\xdb','\xe4'},{'\xb6','\x42'},{'\xdb','\xe1'},
    {'\xdb','\xdf'},{'\x00','\x00'},{'\xb6','\x40'},{'\xb5','\xfb'},{'\xb6','\x47'},
    {'\xdb','\xdb'},{'\xdb','\xdc'},{'\xdb','\xd9'},{'\x00','\x00'},{'\xb6','\x41'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb5','\xfc'},{'\x00','\x00'},{'\xb5','\xfa'},
    {'\xe0','\x48'},{'\xb8','\xdf'},{'\xb8','\xda'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb8','\xd5'},{'\xfc','\xda'},{'\xb8','\xe5'},{'\xb8','\xd6'},{'\x00','\x00'},
    {'\xb8','\xd2'},{'\xb8','\xe1'},{'\xb8','\xde'},{'\xb8','\xe0'},{'\x00','\x00'},
    {'\xb8','\xd7'},{'\xb8','\xdc'},{'\xb8','\xd3'},{'\xb8','\xd4'},{'\xe0','\x50'},
    {'\xe0','\x4d'},{'\xe0','\x45'},{'\xe0','\x4a'},{'\x00','\x00'},{'\xb8','\xe2'},
    {'\xe0','\x51'},{'\xb8','\xe3'},{'\xb8','\xd9'},{'\x00','\x00'},{'\xfd','\x72'},
    {'\xe0','\x47'},{'\x00','\x00'},{'\xe0','\x4f'},{'\xe0','\x4b'},{'\xe0','\x4e'},
    {'\xe0','\x4c'},{'\xb8','\xdd'},{'\xe0','\x46'},{'\xb8','\xd8'},{'\x00','\x00'},
    {'\x8c','\xa9'},{'\x8a','\x6c'},{'\xe4','\x4c'},{'\xbb','\x78'},{'\xbb','\x7b'},
    {'\x00','\x00'},{'\xe4','\x4e'},{'\xfe','\xda'},{'\xbb','\xa5'},{'\xe4','\x4d'},
    {'\xbb','\x7d'},{'\xfe','\xdb'},{'\xbd','\xcf'},{'\xe4','\x4f'},{'\x00','\x00'},
    {'\xbb','\xa4'},{'\xe4','\x4b'},{'\xbb','\xa6'},{'\x00','\x00'},{'\xfe','\xdc'},
    {'\x00','\x00'},{'\xbb','\x79'},{'\x00','\x00'},{'\xb8','\xdb'},{'\xbb','\x7c'},
    {'\x00','\x00'},{'\xbb','\x7a'},{'\xbb','\x7e'},{'\xbb','\xa2'},{'\xbb','\x77'},
    {'\xbb','\xa7'},{'\xbb','\xa3'},{'\xfe','\xdd'},{'\xbb','\xa1'},{'\xe4','\x4a'},
    {'\x91','\x75'},{'\x93','\xab'},{'\x00','\x00'},{'\xfe','\xde'},{'\xbd','\xd6'},
    {'\x00','\x00'},{'\xbd','\xd2'},{'\x00','\x00'},{'\xfe','\xdf'},{'\x00','\x00'},
    {'\xbd','\xd9'},{'\x00','\x00'},{'\xe7','\xd6'},{'\xbd','\xda'},{'\xe7','\xe2'},
    {'\xe7','\xdb'},{'\xbd','\xcb'},{'\xe7','\xe3'},{'\xe7','\xdd'},{'\xbd','\xd5'},
    {'\xe7','\xde'},{'\x00','\x00'},{'\xbd','\xd4'},{'\xe7','\xe1'},{'\xbd','\xce'},
    {'\xe7','\xdf'},{'\xe7','\xd5'},{'\xbd','\xcd'},{'\xeb','\xaa'},{'\xbd','\xd3'},
    {'\x00','\x00'},{'\xbd','\xd0'},{'\x82','\x51'},{'\xbd','\xd8'},{'\x00','\x00'},
    {'\xe7','\xd4'},{'\x00','\x00'},{'\xe7','\xd8'},{'\xbd','\xcc'},{'\xe7','\xd7'},
    {'\xe7','\xd9'},{'\xe7','\xda'},{'\xbd','\xd7'},{'\xe7','\xdc'},{'\xe7','\xe0'},
    {'\xe7','\xe4'},{'\x91','\x76'},{'\xbd','\xdb'},{'\xbf','\xd2'},{'\xeb','\xa5'},
    {'\xeb','\xab'},{'\xeb','\xa8'},{'\xeb','\x7e'},{'\xeb','\xac'},{'\xeb','\xa1'},
    {'\x00','\x00'},{'\xeb','\xa7'},{'\x00','\x00'},{'\xbf','\xcd'},{'\xbf','\xd3'},
    {'\xeb','\xad'},{'\x00','\x00'},{'\xfe','\xe0'},{'\xbf','\xcf'},{'\x00','\x00'},
    {'\xbf','\xd9'},{'\xbf','\xd4'},{'\xeb','\xaf'},{'\xeb','\xa9'},{'\xbf','\xd0'},
    {'\xeb','\xa2'},{'\xbf','\xda'},{'\xeb','\xa3'},{'\xeb','\xa4'},{'\xbf','\xdb'},
    {'\xbf','\xd8'},{'\xbd','\xd1'},{'\x9d','\xd1'},{'\xbf','\xce'},{'\xeb','\xb0'},
    {'\xbf','\xdc'},{'\x00','\x00'},{'\xbf','\xd5'},{'\xeb','\xae'},{'\xbf','\xd1'},
    {'\xbf','\xd6'},{'\xbf','\xd7'},{'\x00','\x00'},{'\xc1','\xc3'},{'\xee','\xa4'},
    {'\xee','\xad'},{'\xee','\xaa'},{'\xee','\xac'},{'\x00','\x00'},{'\xc1','\xc0'},
    {'\xee','\xa5'},{'\xfd','\x74'},{'\xee','\xab'},{'\xc1','\xbc'},{'\xee','\xa7'},
    {'\xc1','\xc4'},{'\xee','\xa3'},{'\xee','\xa8'},{'\xee','\xaf'},{'\xeb','\xa6'},
    {'\xee','\xa9'},{'\xee','\xa2'},{'\xc1','\xbd'},{'\xee','\xa1'},{'\xc1','\xbe'},
    {'\xee','\xb0'},{'\xc1','\xbf'},{'\xee','\xae'},{'\xc1','\xc2'},{'\xee','\x7e'},
    {'\xfe','\xe1'},{'\xc1','\xc1'},{'\x93','\xdc'},{'\xee','\xa6'},{'\xf0','\xdc'},
    {'\xf0','\xea'},{'\xf0','\xe5'},{'\xf0','\xe7'},{'\xf0','\xdb'},{'\xc2','\xd3'},
    {'\x00','\x00'},{'\xf0','\xda'},{'\xc2','\xd6'},{'\xc2','\xd5'},{'\x96','\xc1'},
    {'\xf0','\xe9'},{'\xf0','\xe1'},{'\xf0','\xde'},{'\xf0','\xe4'},{'\x00','\x00'},
    {'\xf0','\xdd'},{'\x00','\x00'},{'\xf0','\xdf'},{'\xf0','\xe8'},{'\xf0','\xe6'},
    {'\x00','\x00'},{'\xc2','\xd4'},{'\xf0','\xed'},{'\xf0','\xeb'},{'\xf0','\xe2'},
    {'\xf0','\xec'},{'\xf0','\xe3'},{'\xfe','\xe3'},{'\xf2','\xf9'},{'\xc3','\xcf'},
    {'\xf3','\x41'},{'\xfd','\x75'},{'\x00','\x00'},{'\xf6','\x4f'},{'\xc3','\xd6'},
    {'\xf0','\xe0'},{'\xf2','\xf7'},{'\xc3','\xd2'},{'\xf2','\xf8'},{'\xf2','\xfd'},
    {'\xfd','\x77'},{'\xfe','\xe4'},{'\xc3','\xd4'},{'\xc3','\xd5'},{'\xf2','\xf6'},
    {'\xf3','\x40'},{'\xf3','\x42'},{'\xf2','\xfa'},{'\xf2','\xfc'},{'\xf2','\xfe'},
    {'\xf2','\xfb'},{'\xf3','\x43'},{'\xc3','\xd1'},{'\xc3','\xd7'},{'\xc3','\xd3'},
    {'\x91','\x77'},{'\xc3','\xd0'},{'\xf4','\xd0'},{'\xfe','\xe5'},{'\xc4','\xb7'},
    {'\xf4','\xce'},{'\x00','\x00'},{'\xfe','\xe6'},{'\xf4','\xd2'},{'\x00','\x00'},
    {'\xf4','\xd3'},{'\xc4','\xb5'},{'\xf4','\xd4'},{'\xf4','\xd1'},{'\xfe','\xe7'},
    {'\xf4','\xcf'},{'\xc4','\xb8'},{'\xc4','\xb4'},{'\xf4','\xd5'},{'\x00','\x00'},
    {'\xc4','\xb6'},{'\xc4','\xb3'},{'\x91','\x78'},{'\x92','\xf0'},{'\x00','\x00'},
    {'\xc4','\xfe'},{'\x00','\x00'},{'\x00','\x00'},{'\xc5','\x40'},{'\xf6','\x4e'},
    {'\xf6','\x4d'},{'\xf6','\x50'},{'\xf6','\x51'},{'\x00','\x00'},{'\xc5','\x41'},
    {'\xf7','\x56'},{'\xf7','\x5b'},{'\xc5','\xaa'},{'\xfd','\x76'},{'\xf7','\x58'},
    {'\x82','\x63'},{'\xf7','\x57'},{'\xf7','\x5a'},{'\xf7','\x59'},{'\x00','\x00'},
    {'\xf8','\x43'},{'\x00','\x00'},{'\xc5','\xdc'},{'\xf8','\x42'},{'\xf8','\x40'},
    {'\x00','\x00'},{'\xf8','\x41'},{'\x00','\x00'},{'\x95','\xf8'},{'\x00','\x00'},
    {'\xc5','\xfe'},{'\xc5','\xfd'},{'\xf8','\xc1'},{'\xf8','\xc2'},{'\xc6','\x40'},
    {'\x00','\x00'},{'\xf9','\x4d'},{'\xf9','\x4e'},{'\xc6','\x67'},{'\xfe','\xe8'},
    {'\xc6','\x6d'},{'\x00','\x00'},{'\xf9','\xa9'},{'\xf9','\xc8'},{'\x9c','\xec'},
    {'\x83','\x79'},{'\x83','\x7a'},{'\x83','\x7b'},{'\x87','\x50'},{'\x8b','\xc2'},
    {'\x83','\xd4'},{'\x83','\xd6'},{'\x83','\xd5'},{'\x8d','\x58'},{'\x83','\xd7'},
    {'\x83','\xda'},{'\x00','\x00'},{'\x83','\xd9'},{'\x8c','\x56'},{'\x83','\xd8'},
    {'\x83','\xd3'},{'\x00','\x00'},{'\x8a','\x68'},{'\x89','\x62'},{'\x8f','\x7e'},
    {'\x8d','\xe7'},{'\x84','\xa2'},{'\x84','\xa4'},{'\x84','\xa5'},{'\x84','\xa8'},
    {'\x88','\x62'},{'\x00','\x00'},{'\x84','\xa7'},{'\x89','\x6a'},{'\x84','\xa6'},
    {'\x84','\xa1'},{'\x84','\xa3'},{'\x85','\x56'},{'\x85','\x57'},{'\x85','\x5e'},
    {'\x85','\x54'},{'\x85','\x59'},{'\x8b','\xbf'},{'\x00','\x00'},{'\x85','\x5a'},
    {'\x85','\x5c'},{'\x85','\x5d'},{'\x85','\x5b'},{'\x8f','\x65'},{'\x85','\x55'},
    {'\x8d','\xe8'},{'\x85','\x58'},{'\x00','\x00'},{'\x8c','\x57'},{'\x8d','\xe9'},
    {'\x8e','\x4f'},{'\x8e','\x52'},{'\x86','\x49'},{'\x8e','\x50'},{'\x86','\x4a'},
    {'\x86','\x4b'},{'\x86','\x4c'},{'\x86','\x4e'},{'\x86','\x50'},{'\x8e','\x53'},
    {'\x86','\x4f'},{'\x88','\x5a'},{'\x86','\x54'},{'\x86','\x53'},{'\x86','\x51'},
    {'\x86','\x52'},{'\x86','\x4d'},{'\x88','\x63'},{'\x86','\x47'},{'\x86','\x48'},
    {'\x86','\x46'},{'\x8e','\xf8'},{'\x8e','\x51'},{'\x00','\x00'},{'\x87','\x51'},
    {'\x87','\x4f'},{'\x87','\x4e'},{'\x87','\x58'},{'\x87','\x52'},{'\x87','\x54'},
    {'\x87','\x56'},{'\x87','\x55'},{'\x87','\x57'},{'\x87','\x53'},{'\x87','\x4d'},
    {'\x8e','\xa1'},{'\x88','\x5b'},{'\x88','\x5c'},{'\x8e','\xcb'},{'\x89','\x67'},
    {'\x8c','\xdd'},{'\x8e','\xcc'},{'\x88','\x65'},{'\x88','\x5d'},{'\x88','\x5e'},
    {'\x88','\x66'},{'\x88','\x61'},{'\x8e','\xcd'},{'\x88','\x60'},{'\x88','\x5f'},
    {'\x88','\x57'},{'\x88','\x59'},{'\x88','\x64'},{'\x88','\x58'},{'\x00','\x00'},
    {'\x88','\x56'},{'\x89','\x63'},{'\x89','\x6d'},{'\x89','\x64'},{'\x8a','\x69'},
    {'\x89','\x61'},{'\x89','\x65'},{'\x8e','\xf9'},{'\x89','\x68'},{'\x89','\x69'},
    {'\x8e','\xfa'},{'\x89','\x6b'},{'\x89','\x6e'},{'\x8d','\x59'},{'\x89','\x66'},
    {'\x89','\x6c'},{'\x89','\x60'},{'\x89','\x5f'},{'\x8a','\x65'},{'\x8e','\xfb'},
    {'\x00','\x00'},{'\x8a','\xfe'},{'\x8d','\xa4'},{'\x8f','\x64'},{'\x8a','\x6b'},
    {'\x8a','\x6a'},{'\x8a','\x66'},{'\x8f','\x66'},{'\x8a','\x67'},{'\x8a','\x6d'},
    {'\x8b','\x40'},{'\x8f','\xa1'},{'\x8b','\x42'},{'\x91','\x79'},{'\x8b','\x41'},
    {'\x8b','\xc0'},{'\x8f','\xc8'},{'\x8b','\xc3'},{'\x90','\x78'},{'\x8b','\xbe'},
    {'\x8b','\xc1'},{'\x90','\xa6'},{'\x8c','\xa7'},{'\x8c','\x58'},{'\x8d','\x5a'},
    {'\xa8','\xa6'},{'\x00','\x00'},{'\xd7','\xcd'},{'\x91','\x7a'},{'\xd7','\xce'},
    {'\xe0','\x52'},{'\xe4','\x50'},{'\xe7','\xe5'},{'\xc1','\xc6'},{'\x00','\x00'},
    {'\xc1','\xc5'},{'\xf0','\xee'},{'\xf3','\x44'},{'\x00','\x00'},{'\xf8','\x44'},
    {'\xa8','\xa7'},{'\xd3','\xde'},{'\xb0','\x5a'},{'\xb3','\x61'},{'\xe0','\x54'},
    {'\xe0','\x53'},{'\xbd','\xdc'},{'\xe7','\xe6'},{'\xbd','\xdd'},{'\xee','\xb1'},
    {'\xc2','\xd7'},{'\xfe','\xe9'},{'\x00','\x00'},{'\x00','\x00'},{'\xc6','\x76'},
    {'\xa8','\xa8'},{'\xcd','\xcb'},{'\xd3','\xdf'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb3','\x62'},{'\x00','\x00'},{'\xd7','\xcf'},{'\xd7','\xd0'},{'\x00','\x00'},
    {'\xdb','\xe5'},{'\x00','\x00'},{'\xb6','\x48'},{'\xb8','\xe6'},{'\x00','\x00'},
    {'\xe0','\x56'},{'\xe0','\x55'},{'\xe0','\x57'},{'\x00','\x00'},{'\xe4','\x51'},
    {'\xe4','\x52'},{'\xbb','\xa8'},{'\xbf','\xdd'},{'\xbd','\xde'},{'\xbf','\xde'},
    {'\x00','\x00'},{'\xee','\xb5'},{'\xee','\xb2'},{'\xee','\xb4'},{'\xee','\xb3'},
    {'\xc1','\xc7'},{'\x00','\x00'},{'\xf0','\xef'},{'\xf3','\x46'},{'\xf3','\x45'},
    {'\xcb','\xa4'},{'\xb0','\x5c'},{'\xb0','\x5b'},{'\xd3','\xe0'},{'\x91','\x7b'},
    {'\xd7','\xd1'},{'\x00','\x00'},{'\x00','\x00'},{'\xdb','\xe7'},{'\xdb','\xe6'},
    {'\xb6','\x49'},{'\x00','\x00'},{'\xe0','\x59'},{'\xe0','\x5a'},{'\xe0','\x58'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xb8','\xe8'},{'\xb8','\xe7'},{'\x00','\x00'},
    {'\xbb','\xaa'},{'\xbb','\xa9'},{'\x91','\x7c'},{'\xe7','\xe7'},{'\xeb','\xb3'},
    {'\xeb','\xb1'},{'\xeb','\xb2'},{'\xbf','\xdf'},{'\xee','\xb7'},{'\xee','\xb6'},
    {'\x00','\x00'},{'\xf0','\xf2'},{'\xf0','\xf1'},{'\xf0','\xf0'},{'\xf3','\x47'},
    {'\xfe','\xea'},{'\xf9','\xaa'},{'\xa8','\xa9'},{'\xad','\x73'},{'\xfe','\xeb'},
    {'\xad','\x74'},{'\xb0','\x5d'},{'\xb0','\x5e'},{'\xd3','\xe2'},{'\xd3','\xe1'},
    {'\xd7','\xd2'},{'\x00','\x00'},{'\xb3','\x68'},{'\xb3','\x66'},{'\xb3','\x63'},
    {'\xb3','\x67'},{'\xb3','\x65'},{'\xb3','\x64'},{'\xfd','\x79'},{'\x91','\x7d'},
    {'\xb6','\x4a'},{'\xdb','\xea'},{'\x00','\x00'},{'\xb8','\xed'},{'\xb6','\x4c'},
    {'\xb6','\x51'},{'\xdb','\xec'},{'\xb6','\x53'},{'\xb6','\x52'},{'\xb6','\x55'},
    {'\xdb','\xeb'},{'\xdb','\xe8'},{'\xb6','\x4f'},{'\xb6','\x4b'},{'\xb6','\x4d'},
    {'\xdb','\xe9'},{'\xb6','\x54'},{'\xb6','\x50'},{'\xb6','\x4e'},{'\xb8','\xef'},
    {'\xb8','\xee'},{'\xb8','\xec'},{'\xb8','\xf0'},{'\x00','\x00'},{'\xb8','\xea'},
    {'\xb8','\xeb'},{'\x00','\x00'},{'\xb8','\xe9'},{'\x00','\x00'},{'\xe0','\x5b'},
    {'\x95','\x60'},{'\x82','\x62'},{'\xe4','\x54'},{'\x00','\x00'},{'\xbb','\xac'},
    {'\xbb','\xad'},{'\xbb','\xab'},{'\xfe','\xec'},{'\xe4','\x53'},{'\xfe','\xed'},
    {'\xe4','\x55'},{'\x00','\x00'},{'\xe7','\xea'},{'\xe7','\xec'},{'\x92','\xce'},
    {'\xbd','\xe7'},{'\xe7','\xed'},{'\xbd','\xe0'},{'\xe7','\xe9'},{'\xbd','\xdf'},
    {'\xbd','\xe9'},{'\xbd','\xe5'},{'\xbd','\xe6'},{'\xbd','\xe2'},{'\xe7','\xe8'},
    {'\xbd','\xe1'},{'\xe7','\xee'},{'\xe7','\xeb'},{'\x9e','\x40'},{'\xbd','\xe8'},
    {'\xfd','\x7a'},{'\xbd','\xe3'},{'\xbd','\xe4'},{'\xeb','\xb5'},{'\x00','\x00'},
    {'\xeb','\xb7'},{'\xeb','\xb6'},{'\x9e','\x41'},{'\xeb','\xb8'},{'\xbf','\xe0'},
    {'\xeb','\xb4'},{'\x00','\x00'},{'\xfd','\x7b'},{'\xc1','\xcb'},{'\xee','\xb8'},
    {'\xc1','\xc8'},{'\xc1','\xcc'},{'\xc1','\xca'},{'\xc1','\xc9'},{'\xf0','\xf3'},
    {'\x00','\x00'},{'\xf0','\xf6'},{'\x00','\x00'},{'\xf0','\xf5'},{'\x9e','\x42'},
    {'\xf0','\xf4'},{'\xc2','\xd8'},{'\xf3','\x48'},{'\xf3','\x49'},{'\xc3','\xd8'},
    {'\xf3','\x4a'},{'\xc3','\xd9'},{'\x82','\x57'},{'\xfd','\x7c'},{'\xc4','\xba'},
    {'\x00','\x00'},{'\xc4','\xb9'},{'\xf6','\x52'},{'\x9e','\x43'},{'\x91','\x7e'},
    {'\xc5','\x42'},{'\xf6','\x53'},{'\xf7','\x5c'},{'\xc5','\xab'},{'\xc5','\xac'},
    {'\x95','\x76'},{'\xf8','\x45'},{'\x00','\x00'},{'\xc6','\x42'},{'\x9e','\x44'},
    {'\x83','\x50'},{'\x83','\x7c'},{'\x83','\x7d'},{'\x00','\x00'},{'\x83','\xdd'},
    {'\x83','\xdc'},{'\x84','\xaa'},{'\x88','\x6e'},{'\x84','\x50'},{'\x88','\x6c'},
    {'\x84','\xac'},{'\x88','\x71'},{'\x84','\xa9'},{'\x84','\xad'},{'\x84','\xae'},
    {'\x85','\x68'},{'\x8a','\x70'},{'\x85','\x5f'},{'\x84','\xab'},{'\x85','\x61'},
    {'\x88','\x6b'},{'\x85','\x63'},{'\x8d','\xeb'},{'\x85','\x60'},{'\x85','\x66'},
    {'\x8d','\xea'},{'\x85','\x6a'},{'\x85','\x69'},{'\x85','\x64'},{'\x85','\x65'},
    {'\x85','\x62'},{'\x86','\x55'},{'\x8f','\xa3'},{'\x86','\x57'},{'\x86','\x58'},
    {'\x86','\x59'},{'\x86','\x5a'},{'\x86','\x5b'},{'\x8c','\xaa'},{'\x86','\x56'},
    {'\x86','\x5c'},{'\x90','\x47'},{'\x8e','\xa2'},{'\x87','\x5a'},{'\x91','\xa1'},
    {'\x87','\x5b'},{'\x88','\x6a'},{'\x88','\x6d'},{'\x91','\xa2'},{'\x8c','\xde'},
    {'\x88','\x69'},{'\x88','\x70'},{'\x00','\x00'},{'\x00','\x00'},{'\x88','\x72'},
    {'\x88','\x68'},{'\x8e','\xce'},{'\x89','\x6f'},{'\x00','\x00'},{'\x8b','\x43'},
    {'\x8a','\x71'},{'\x8a','\x6e'},{'\x8a','\x6f'},{'\x8f','\xa2'},{'\x8c','\xdf'},
    {'\x8b','\xc5'},{'\x00','\x00'},{'\x8b','\xc4'},{'\x8c','\x5a'},{'\x8c','\x59'},
    {'\x8d','\x5c'},{'\xa8','\xaa'},{'\x00','\x00'},{'\xb3','\x6a'},{'\xb3','\x69'},
    {'\xe0','\x5c'},{'\xe0','\x5d'},{'\x00','\x00'},{'\xbb','\xae'},{'\xeb','\xb9'},
    {'\xbd','\xea'},{'\xeb','\xba'},{'\xee','\xb9'},{'\xa8','\xab'},{'\x91','\xa3'},
    {'\xd0','\xb2'},{'\xad','\x76'},{'\xad','\x75'},{'\x87','\x5c'},{'\xd3','\xe3'},
    {'\xb0','\x5f'},{'\xd3','\xe4'},{'\xd7','\xd5'},{'\x9e','\x45'},{'\xd7','\xd4'},
    {'\x00','\x00'},{'\xd7','\xd3'},{'\x00','\x00'},{'\x00','\x00'},{'\xdb','\xee'},
    {'\xb6','\x58'},{'\xfd','\x7d'},{'\x00','\x00'},{'\xdb','\xed'},{'\xb6','\x57'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xdb','\xef'},{'\xb6','\x56'},
    {'\x8a','\x72'},{'\xe0','\x5f'},{'\xe0','\x62'},{'\xe0','\x60'},{'\xe0','\x61'},
    {'\xe0','\x65'},{'\xe0','\x5e'},{'\xe0','\x66'},{'\xe0','\x63'},{'\xe0','\x64'},
    {'\xbb','\xb0'},{'\xe4','\x56'},{'\x00','\x00'},{'\x00','\x00'},{'\xbb','\xaf'},
    {'\x00','\x00'},{'\xe7','\xf2'},{'\xe7','\xf0'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xbd','\xeb'},{'\xe7','\xef'},{'\xe7','\xf1'},{'\x00','\x00'},{'\xbd','\xec'},
    {'\x00','\x00'},{'\xeb','\xbb'},{'\xfd','\x7e'},{'\xeb','\xbc'},{'\xc1','\xcd'},
    {'\x9e','\x46'},{'\xf3','\x4c'},{'\xf3','\x4e'},{'\xf3','\x4b'},{'\xf3','\x4d'},
    {'\xf4','\xd6'},{'\xf6','\x54'},{'\x00','\x00'},{'\x90','\xa3'},{'\xf9','\x6f'},
    {'\xa8','\xac'},{'\xad','\x77'},{'\xd3','\xe5'},{'\xd3','\xe7'},{'\xd3','\xe6'},
    {'\x8c','\x5b'},{'\xd7','\xd8'},{'\xb3','\x6c'},{'\x00','\x00'},{'\xd7','\xd6'},
    {'\x00','\x00'},{'\xb3','\x6b'},{'\xd7','\xd9'},{'\x9e','\x47'},{'\xd7','\xda'},
    {'\xd7','\xd7'},{'\x8c','\xac'},{'\x8f','\x67'},{'\xdb','\xfb'},{'\xb6','\x60'},
    {'\xdb','\xf3'},{'\xdb','\xf9'},{'\x00','\x00'},{'\x00','\x00'},{'\xb6','\x5b'},
    {'\xb6','\x5e'},{'\xdb','\xf2'},{'\xb6','\x59'},{'\xdb','\xf6'},{'\xe0','\x6c'},
    {'\xb6','\x5d'},{'\x00','\x00'},{'\xdb','\xf1'},{'\xfd','\xa1'},{'\xdb','\xf7'},
    {'\xdb','\xf4'},{'\xdb','\xfa'},{'\xdb','\xf0'},{'\xdb','\xf8'},{'\xb6','\x5c'},
    {'\xb6','\x5f'},{'\xdb','\xf5'},{'\xb6','\x5a'},{'\x90','\x5e'},{'\xb8','\xf2'},
    {'\xe0','\x68'},{'\xb8','\xf1'},{'\xe0','\x6f'},{'\xe0','\x6e'},{'\xb8','\xf8'},
    {'\x00','\x00'},{'\xb8','\xf9'},{'\xe0','\x70'},{'\xb8','\xf3'},{'\xe0','\x6d'},
    {'\xb8','\xf7'},{'\xe0','\x72'},{'\xe0','\x69'},{'\x00','\x00'},{'\xe0','\x6b'},
    {'\xb8','\xf4'},{'\xe0','\x67'},{'\xe0','\x6a'},{'\xe0','\x71'},{'\xb8','\xf5'},
    {'\xe0','\x73'},{'\x88','\x73'},{'\x00','\x00'},{'\x8b','\xc6'},{'\x8b','\x46'},
    {'\x90','\x5d'},{'\xb8','\xf6'},{'\x8c','\xad'},{'\xbb','\xb1'},{'\xe4','\x5b'},
    {'\xe4','\x61'},{'\xe4','\x59'},{'\xe4','\x62'},{'\x9e','\x48'},{'\xe4','\x58'},
    {'\xe4','\x5d'},{'\xe4','\x63'},{'\xe4','\x60'},{'\xe4','\x5f'},{'\xe4','\x5e'},
    {'\x91','\xa4'},{'\xe4','\x57'},{'\xe4','\x5c'},{'\x00','\x00'},{'\x8c','\xab'},
    {'\xe4','\x5a'},{'\x9e','\x49'},{'\xbd','\xf1'},{'\xbd','\xee'},{'\xe7','\xfb'},
    {'\xe8','\x41'},{'\xe8','\x43'},{'\xe8','\x40'},{'\xe7','\xf8'},{'\xe7','\xfa'},
    {'\xe8','\x45'},{'\xe8','\x42'},{'\xe7','\xfc'},{'\xe8','\x46'},{'\xe7','\xf9'},
    {'\xe8','\x44'},{'\xbd','\xef'},{'\xbd','\xf5'},{'\xbd','\xf3'},{'\xe7','\xf3'},
    {'\xbd','\xf4'},{'\xbd','\xf0'},{'\xe7','\xf4'},{'\xe7','\xf6'},{'\xe7','\xf5'},
    {'\xe7','\xfd'},{'\xe7','\xfe'},{'\xfd','\xa2'},{'\xbd','\xf2'},{'\x95','\x57'},
    {'\xbd','\xed'},{'\x8c','\xe1'},{'\xfb','\x6d'},{'\xe7','\xf7'},{'\x8c','\xe0'},
    {'\xeb','\xc6'},{'\xbf','\xe2'},{'\x00','\x00'},{'\xeb','\xbd'},{'\xbf','\xe3'},
    {'\xbf','\xe6'},{'\xeb','\xc2'},{'\x00','\x00'},{'\xeb','\xbf'},{'\xbf','\xe5'},
    {'\x91','\xa5'},{'\x00','\x00'},{'\xeb','\xc3'},{'\xeb','\xc4'},{'\xeb','\xbe'},
    {'\xeb','\xc7'},{'\xeb','\xc0'},{'\xeb','\xc5'},{'\xbf','\xe4'},{'\x00','\x00'},
    {'\xbf','\xe1'},{'\xeb','\xc1'},{'\x9e','\x4a'},{'\xee','\xbf'},{'\xc1','\xd0'},
    {'\xc1','\xce'},{'\xc1','\xd1'},{'\xc1','\xcf'},{'\xee','\xbe'},{'\xee','\xbb'},
    {'\xee','\xba'},{'\xfd','\xa3'},{'\xee','\xbd'},{'\x8d','\x74'},{'\x8b','\x44'},
    {'\xee','\xbc'},{'\xf1','\x45'},{'\xc2','\xde'},{'\xf0','\xfb'},{'\xf0','\xfa'},
    {'\x00','\x00'},{'\xc2','\xd9'},{'\xf1','\x41'},{'\xf1','\x40'},{'\xf0','\xf7'},
    {'\xf1','\x43'},{'\xf0','\xfc'},{'\xc2','\xdd'},{'\xf0','\xf9'},{'\xf1','\x42'},
    {'\xf0','\xf8'},{'\xc2','\xda'},{'\xc2','\xdc'},{'\xf0','\xfd'},{'\xc2','\xdb'},
    {'\xf0','\xfe'},{'\x9e','\x4b'},{'\xf1','\x44'},{'\xf3','\x52'},{'\x00','\x00'},
    {'\xc3','\xde'},{'\xf3','\x4f'},{'\x00','\x00'},{'\xf3','\x53'},{'\x91','\xa6'},
    {'\x9e','\x4c'},{'\xc3','\xdb'},{'\xf3','\x51'},{'\xc3','\xe0'},{'\xfd','\xa5'},
    {'\xc3','\xdd'},{'\xfd','\xa4'},{'\xf3','\x50'},{'\x00','\x00'},{'\xc3','\xdf'},
    {'\xf3','\x54'},{'\xc3','\xda'},{'\x00','\x00'},{'\x9e','\x4d'},{'\x90','\x7e'},
    {'\x9e','\x4e'},{'\xc4','\xbc'},{'\xc4','\xbe'},{'\x00','\x00'},{'\xf4','\xd9'},
    {'\xc4','\xbd'},{'\xf4','\xd7'},{'\xc3','\xdc'},{'\xf4','\xd8'},{'\xc4','\xbb'},
    {'\xc5','\x43'},{'\xc5','\x45'},{'\xf6','\x56'},{'\xc5','\x44'},{'\xf6','\x55'},
    {'\x8d','\xa5'},{'\xf7','\x61'},{'\xc5','\xad'},{'\xf7','\x60'},{'\xc5','\xae'},
    {'\xf7','\x5e'},{'\xf7','\x5d'},{'\xf7','\x62'},{'\xf7','\x63'},{'\xf8','\x46'},
    {'\x91','\xa7'},{'\xf7','\x5f'},{'\x00','\x00'},{'\x90','\xa4'},{'\xf8','\xc6'},
    {'\xf8','\xc3'},{'\xf8','\xc4'},{'\xf8','\xc5'},{'\xc6','\x5c'},{'\x00','\x00'},
    {'\xf9','\x51'},{'\xf9','\x50'},{'\xf9','\x4f'},{'\xf9','\x70'},{'\xfd','\xa6'},
    {'\xf9','\xbe'},{'\xf9','\xab'},{'\xc6','\x6e'},{'\xa8','\xad'},{'\xb0','\x60'},
    {'\x95','\xdf'},{'\x00','\x00'},{'\x82','\x49'},{'\x91','\xa8'},{'\x91','\xa9'},
    {'\xb8','\xfa'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9e','\x4f'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9e','\x50'},{'\xbd','\xf6'},{'\x00','\x00'},
    {'\x9e','\x51'},{'\xeb','\xc8'},{'\x94','\xd3'},{'\x00','\x00'},{'\xc2','\xdf'},
    {'\x00','\x00'},{'\xf3','\x55'},{'\x9e','\x52'},{'\x00','\x00'},{'\x91','\xaa'},
    {'\x91','\xab'},{'\x00','\x00'},{'\x94','\xd4'},{'\xf9','\xac'},{'\xa8','\xae'},
    {'\xaa','\xee'},{'\xad','\x79'},{'\xad','\x78'},{'\x91','\xac'},{'\xb0','\x63'},
    {'\x00','\x00'},{'\xd3','\xe8'},{'\xb0','\x61'},{'\xd3','\xe9'},{'\xb0','\x62'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xd7','\xdf'},{'\xd7','\xdb'},{'\x00','\x00'},
    {'\xfb','\xa1'},{'\xb3','\x6d'},{'\xd7','\xde'},{'\xd7','\xdd'},{'\xd7','\xdc'},
    {'\xb3','\x6e'},{'\xd7','\xe0'},{'\xd7','\xe1'},{'\x93','\x7d'},{'\x91','\xad'},
    {'\x9e','\x53'},{'\xdc','\x43'},{'\xdc','\x41'},{'\xdc','\x45'},{'\xdc','\x46'},
    {'\xdc','\x4c'},{'\x00','\x00'},{'\xdc','\x48'},{'\xdc','\x4a'},{'\x9e','\x54'},
    {'\xdc','\x42'},{'\xdb','\xfc'},{'\x00','\x00'},{'\xdc','\x49'},{'\x9e','\x55'},
    {'\x00','\x00'},{'\xdc','\x4b'},{'\xdc','\x44'},{'\xdc','\x47'},{'\xdb','\xfd'},
    {'\xb6','\x62'},{'\xdc','\x40'},{'\xdb','\xfe'},{'\xb6','\x61'},{'\xb6','\x63'},
    {'\x92','\xad'},{'\xb8','\xfd'},{'\xe0','\x75'},{'\xe0','\x77'},{'\xe0','\x76'},
    {'\xe0','\x7b'},{'\xb8','\xfb'},{'\x00','\x00'},{'\xe0','\x78'},{'\xe0','\x74'},
    {'\xe0','\x79'},{'\xe0','\x7a'},{'\xb8','\xfc'},{'\xb8','\xfe'},{'\xe0','\x7c'},
    {'\x91','\xae'},{'\xe4','\x67'},{'\xe4','\x66'},{'\x00','\x00'},{'\xe4','\x64'},
    {'\xe4','\x65'},{'\xbb','\xb3'},{'\xbb','\xb5'},{'\xbb','\xb2'},{'\xbb','\xb4'},
    {'\xe8','\x4d'},{'\xe8','\x4e'},{'\xe8','\x49'},{'\xfd','\xa7'},{'\xe8','\x4a'},
    {'\xbd','\xf8'},{'\xbd','\xfd'},{'\xbd','\xf7'},{'\xbd','\xfe'},{'\xbd','\xf9'},
    {'\xe8','\x4b'},{'\x00','\x00'},{'\x00','\x00'},{'\xe8','\x4c'},{'\xe8','\x48'},
    {'\xbe','\x40'},{'\xbd','\xfb'},{'\x00','\x00'},{'\x00','\x00'},{'\xbd','\xfa'},
    {'\xbd','\xfc'},{'\x00','\x00'},{'\xe8','\x47'},{'\x95','\x70'},{'\xeb','\xca'},
    {'\xbf','\xe8'},{'\x9e','\x56'},{'\x00','\x00'},{'\xeb','\xcc'},{'\xbf','\xea'},
    {'\xeb','\xcf'},{'\xeb','\xcb'},{'\xeb','\xc9'},{'\xeb','\xce'},{'\xbf','\xe9'},
    {'\xeb','\xcd'},{'\x00','\x00'},{'\xbf','\xe7'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc1','\xd3'},{'\xc1','\xd6'},{'\xee','\xc1'},{'\x9e','\x57'},{'\xc1','\xd4'},
    {'\xee','\xc0'},{'\xc1','\xd2'},{'\xc1','\xd5'},{'\xf1','\x46'},{'\xf1','\x47'},
    {'\xf1','\x48'},{'\xc2','\xe0'},{'\x9e','\x58'},{'\xf1','\x49'},{'\x94','\xd5'},
    {'\xc2','\xe1'},{'\xc3','\xe2'},{'\xf3','\x58'},{'\xf3','\x59'},{'\xf3','\x57'},
    {'\xf3','\x56'},{'\xf3','\x5a'},{'\xc3','\xe1'},{'\xf4','\xdd'},{'\xf4','\xdb'},
    {'\xf4','\xdc'},{'\xf4','\xde'},{'\xf4','\xda'},{'\xf4','\xdf'},{'\xf6','\x58'},
    {'\xfd','\xa9'},{'\xf6','\x59'},{'\xf6','\x57'},{'\xc5','\x46'},{'\xf7','\x64'},
    {'\xc5','\xaf'},{'\xf7','\x65'},{'\xf8','\x48'},{'\xf8','\x47'},{'\x00','\x00'},
    {'\x83','\x51'},{'\x83','\x61'},{'\x83','\xa1'},{'\x83','\xde'},{'\x00','\x00'},
    {'\x83','\xdf'},{'\x8b','\x48'},{'\x84','\xaf'},{'\x88','\x79'},{'\x84','\xb0'},
    {'\x8c','\xae'},{'\x91','\xaf'},{'\x85','\x6b'},{'\x90','\x6e'},{'\x85','\x6c'},
    {'\x8d','\xed'},{'\x85','\x6d'},{'\x91','\xb0'},{'\x8d','\xee'},{'\x90','\x5f'},
    {'\x8d','\xec'},{'\x87','\x60'},{'\x86','\x5f'},{'\x86','\x5e'},{'\x86','\x60'},
    {'\x8b','\xc8'},{'\x00','\x00'},{'\x8e','\x56'},{'\x8e','\x55'},{'\x86','\x5d'},
    {'\x87','\x5f'},{'\x87','\x5e'},{'\x88','\x75'},{'\x88','\x78'},{'\x88','\x77'},
    {'\x88','\x74'},{'\x88','\x7c'},{'\x88','\x7b'},{'\x00','\x00'},{'\x88','\x76'},
    {'\x88','\x7a'},{'\x89','\x73'},{'\x89','\x70'},{'\x89','\x71'},{'\x00','\x00'},
    {'\x89','\x72'},{'\x8c','\xe2'},{'\x8a','\x76'},{'\x8a','\x73'},{'\x8a','\x74'},
    {'\x8f','\xa4'},{'\x8b','\x49'},{'\x8b','\xc7'},{'\xa8','\xaf'},{'\xb6','\x64'},
    {'\x00','\x00'},{'\x8b','\xc9'},{'\xb9','\x40'},{'\xfd','\x41'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xbb','\xb6'},{'\x00','\x00'},{'\x9e','\x59'},{'\xbf','\xec'},
    {'\x91','\xb1'},{'\xbf','\xeb'},{'\x8c','\xaf'},{'\x00','\x00'},{'\x8c','\x47'},
    {'\x00','\x00'},{'\xc3','\xe3'},{'\xc4','\x7c'},{'\xc5','\x47'},{'\xa8','\xb0'},
    {'\xb0','\x64'},{'\xb9','\x41'},{'\x9e','\x5a'},{'\xf3','\x5b'},{'\xc6','\xd6'},
    {'\x9c','\xe0'},{'\x94','\xd6'},{'\x9e','\x5b'},{'\x8b','\xca'},{'\x93','\xc3'},
    {'\x94','\x4e'},{'\x94','\x44'},{'\x89','\x77'},{'\x86','\x63'},{'\xcb','\xa6'},
    {'\x00','\x00'},{'\x88','\x7e'},{'\xa8','\xb1'},{'\x00','\x00'},{'\xa8','\xb4'},
    {'\xa8','\xb3'},{'\xa8','\xb2'},{'\x86','\x65'},{'\x8a','\x79'},{'\xcb','\xa5'},
    {'\x9e','\x5c'},{'\xcd','\xcd'},{'\xa0','\xa4'},{'\xcd','\xcf'},{'\xaa','\xef'},
    {'\x9e','\x5d'},{'\x86','\x62'},{'\xaa','\xf1'},{'\xcd','\xcc'},{'\xcd','\xce'},
    {'\xaa','\xf0'},{'\xcd','\xd1'},{'\xcd','\xd0'},{'\xcd','\xd2'},{'\x8a','\x78'},
    {'\x84','\xb1'},{'\x94','\xd7'},{'\x85','\x6e'},{'\x87','\x61'},{'\x86','\x64'},
    {'\x84','\xb2'},{'\x89','\x76'},{'\xd0','\xb6'},{'\xd0','\xb4'},{'\xad','\x7c'},
    {'\xd0','\xb3'},{'\xad','\xa3'},{'\xad','\x7e'},{'\xad','\x7b'},{'\x00','\x00'},
    {'\xad','\xa4'},{'\x8b','\x4a'},{'\xad','\x7d'},{'\xad','\xa2'},{'\x00','\x00'},
    {'\xad','\xa1'},{'\xd0','\xb5'},{'\x91','\xb2'},{'\xad','\x7a'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x84','\xb3'},{'\xb0','\x6a'},{'\xd3','\xeb'},{'\xd3','\xf1'},
    {'\xb0','\x67'},{'\xb0','\x6e'},{'\x95','\xd9'},{'\xb0','\x69'},{'\xd3','\xee'},
    {'\xd3','\xf0'},{'\xb0','\x6c'},{'\xd3','\xea'},{'\xd3','\xed'},{'\xb0','\x68'},
    {'\xb0','\x65'},{'\xd3','\xec'},{'\xb0','\x6b'},{'\xd3','\xef'},{'\xb0','\x6d'},
    {'\xb0','\x66'},{'\x00','\x00'},{'\x9e','\x5e'},{'\x89','\x75'},{'\x87','\x62'},
    {'\xd7','\xe3'},{'\xd7','\xe6'},{'\xb3','\x70'},{'\x91','\xb3'},{'\xb3','\x7a'},
    {'\xb3','\x76'},{'\xd7','\xe4'},{'\x87','\x63'},{'\x93','\x7a'},{'\xb3','\x7e'},
    {'\xb3','\x77'},{'\xb3','\x7c'},{'\xb3','\x72'},{'\x00','\x00'},{'\xb3','\x6f'},
    {'\xb3','\x71'},{'\xb3','\x7d'},{'\xd7','\xe5'},{'\xb3','\x75'},{'\xb3','\x78'},
    {'\xb3','\x74'},{'\xb3','\x79'},{'\xd7','\xe7'},{'\xb3','\x7b'},{'\xb3','\x73'},
    {'\xd7','\xe2'},{'\x00','\x00'},{'\x8d','\x41'},{'\x94','\xd8'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xdc','\x4d'},
    {'\xb6','\x65'},{'\xdc','\x4f'},{'\x00','\x00'},{'\xb6','\x67'},{'\xb6','\x69'},
    {'\x9e','\x5f'},{'\xdc','\x4e'},{'\xb6','\x66'},{'\xb6','\x6a'},{'\x9e','\x60'},
    {'\xb6','\x68'},{'\x91','\xb4'},{'\x00','\x00'},{'\x8d','\x42'},{'\xb9','\x47'},
    {'\xe0','\xa3'},{'\xb9','\x4f'},{'\xe0','\x7e'},{'\x00','\x00'},{'\xb9','\x50'},
    {'\xb9','\x45'},{'\x00','\x00'},{'\xe0','\xa1'},{'\x93','\x72'},{'\x00','\x00'},
    {'\xb9','\x4a'},{'\x00','\x00'},{'\xe0','\xa2'},{'\xb9','\x43'},{'\xb9','\x42'},
    {'\xfd','\xb6'},{'\xb9','\x4d'},{'\xb9','\x4c'},{'\xb9','\x4b'},{'\xb9','\x49'},
    {'\xb9','\x4e'},{'\xe0','\x7d'},{'\xb9','\x44'},{'\xb9','\x46'},{'\xb9','\x48'},
    {'\xfd','\xb5'},{'\x89','\x78'},{'\xbb','\xb8'},{'\xbb','\xbb'},{'\x00','\x00'},
    {'\xbb','\xbf'},{'\xbb','\xb9'},{'\xbb','\xbe'},{'\xbb','\xbc'},{'\x00','\x00'},
    {'\xbb','\xb7'},{'\xfe','\x61'},{'\xbb','\xbd'},{'\xbb','\xba'},{'\x9e','\x61'},
    {'\x91','\xb5'},{'\x00','\x00'},{'\xe8','\x52'},{'\xbe','\x43'},{'\xbe','\x41'},
    {'\x00','\x00'},{'\xe8','\x53'},{'\x9e','\x62'},{'\xbe','\x44'},{'\xbe','\x42'},
    {'\xe8','\x51'},{'\xe8','\x50'},{'\x00','\x00'},{'\xbf','\xf0'},{'\xe8','\x4f'},
    {'\xbf','\xee'},{'\xbf','\xed'},{'\xeb','\xd0'},{'\xbe','\x45'},{'\xbf','\xef'},
    {'\xeb','\xd1'},{'\xbf','\xf2'},{'\xeb','\xd2'},{'\xbf','\xf1'},{'\xc1','\xd8'},
    {'\xee','\xc3'},{'\xc1','\xd7'},{'\xc1','\xdc'},{'\xc1','\xda'},{'\xc1','\xdb'},
    {'\xc2','\xe3'},{'\xc1','\xd9'},{'\xee','\xc2'},{'\xeb','\xd3'},{'\xc2','\xe2'},
    {'\xc2','\xe4'},{'\x91','\xb6'},{'\xc3','\xe4'},{'\xc3','\xe5'},{'\x00','\x00'},
    {'\xf4','\xe0'},{'\x00','\x00'},{'\xc5','\xde'},{'\xc5','\xdd'},{'\xa8','\xb6'},
    {'\x00','\x00'},{'\x88','\xa3'},{'\xca','\x55'},{'\xb0','\x6f'},{'\x00','\x00'},
    {'\xca','\x52'},{'\xca','\x53'},{'\xca','\x51'},{'\x00','\x00'},{'\xca','\x54'},
    {'\x00','\x00'},{'\x8f','\xa5'},{'\xcb','\xaa'},{'\xcb','\xa7'},{'\xcb','\xac'},
    {'\xcb','\xa8'},{'\xa8','\xb7'},{'\xa8','\xba'},{'\x00','\x00'},{'\xcb','\xa9'},
    {'\xa8','\xb9'},{'\xcb','\xab'},{'\x95','\x40'},{'\x00','\x00'},{'\xa8','\xb8'},
    {'\x00','\x00'},{'\x8e','\x57'},{'\x00','\x00'},{'\x85','\x6f'},{'\xcd','\xd5'},
    {'\xcd','\xd7'},{'\xaa','\xf4'},{'\xcd','\xd3'},{'\xcd','\xd6'},{'\xcd','\xd4'},
    {'\xaa','\xf2'},{'\xaa','\xf5'},{'\x00','\x00'},{'\xaa','\xf3'},{'\x86','\x66'},
    {'\x89','\x79'},{'\x88','\xa1'},{'\x00','\x00'},{'\xd0','\xb8'},{'\xd0','\xbc'},
    {'\xd0','\xb9'},{'\x00','\x00'},{'\xad','\xa7'},{'\x00','\x00'},{'\xad','\xa8'},
    {'\xfd','\xab'},{'\xd0','\xbb'},{'\x00','\x00'},{'\xd0','\xbd'},{'\xd0','\xbf'},
    {'\x00','\x00'},{'\xad','\xa5'},{'\xd0','\xbe'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xad','\xa6'},{'\x8d','\xc6'},{'\x8e','\xfc'},{'\x88','\xa2'},{'\x00','\x00'},
    {'\x8d','\xf0'},{'\xd7','\xee'},{'\xd0','\xba'},{'\xd3','\xf2'},{'\xd3','\xfb'},
    {'\xd3','\xf9'},{'\xd3','\xf4'},{'\xd3','\xf5'},{'\xd3','\xfa'},{'\xd3','\xfc'},
    {'\xb0','\x71'},{'\x91','\xb7'},{'\xd3','\xf7'},{'\xd3','\xf3'},{'\xb0','\x70'},
    {'\xb0','\x72'},{'\xd3','\xf6'},{'\xd3','\xfd'},{'\xd3','\xf8'},{'\x8c','\xe3'},
    {'\x90','\xbb'},{'\xb3','\xa1'},{'\xd7','\xf1'},{'\xd7','\xe9'},{'\xd7','\xef'},
    {'\xd7','\xf0'},{'\xb3','\xa2'},{'\x00','\x00'},{'\xd7','\xe8'},{'\xd7','\xea'},
    {'\xd0','\xb7'},{'\xd7','\xec'},{'\xd7','\xed'},{'\xd7','\xeb'},{'\xb6','\x6c'},
    {'\x00','\x00'},{'\x92','\x7b'},{'\x8e','\xcf'},{'\xdc','\x56'},{'\xeb','\xd4'},
    {'\xdc','\x57'},{'\xdc','\x54'},{'\xb3','\xa3'},{'\xb6','\x6e'},{'\xdc','\x53'},
    {'\xdc','\x59'},{'\xdc','\x58'},{'\xb6','\x6b'},{'\xdc','\x5c'},{'\xdc','\x52'},
    {'\xdc','\x5b'},{'\xdc','\x50'},{'\xdc','\x5a'},{'\xdc','\x55'},{'\xb6','\x6d'},
    {'\x00','\x00'},{'\xe0','\xaa'},{'\x00','\x00'},{'\xe0','\xa5'},{'\xe0','\xab'},
    {'\xe0','\xa6'},{'\xe0','\xa4'},{'\xe0','\xa7'},{'\xb9','\x51'},{'\x00','\x00'},
    {'\xe0','\xa9'},{'\x91','\xb8'},{'\xe0','\xa8'},{'\xb9','\x52'},{'\xbb','\xc1'},
    {'\xbb','\xc0'},{'\xe4','\x6e'},{'\xe4','\x71'},{'\xe4','\x69'},{'\xe4','\x6d'},
    {'\xbb','\xc2'},{'\xe4','\x6c'},{'\xe4','\x6a'},{'\xe4','\x70'},{'\xe4','\x6b'},
    {'\xe4','\x68'},{'\xe4','\x6f'},{'\x00','\x00'},{'\xe8','\x59'},{'\xbe','\x48'},
    {'\xf1','\x4a'},{'\xe8','\x56'},{'\xe8','\x57'},{'\xe8','\x55'},{'\xdc','\x51'},
    {'\xbe','\x47'},{'\xe8','\x5a'},{'\xe8','\x54'},{'\xbe','\x46'},{'\xbe','\x49'},
    {'\xe8','\x58'},{'\xeb','\xd5'},{'\xbf','\xf3'},{'\xeb','\xd6'},{'\xeb','\xd7'},
    {'\x00','\x00'},{'\xee','\xc4'},{'\xc1','\xdd'},{'\xf1','\x4b'},{'\xf1','\x4c'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xf1','\x4d'},{'\xf3','\x5d'},{'\xf3','\x5c'},
    {'\xf4','\xe2'},{'\x00','\x00'},{'\xf4','\xe1'},{'\xf6','\x5b'},{'\xf6','\x5c'},
    {'\xf6','\x5a'},{'\xf7','\x66'},{'\xc5','\xb0'},{'\xa8','\xbb'},{'\xad','\xaa'},
    {'\xad','\xa9'},{'\xb0','\x75'},{'\xb0','\x74'},{'\xd4','\x40'},{'\xd4','\x41'},
    {'\xd3','\xfe'},{'\xfd','\xac'},{'\xb0','\x73'},{'\xd7','\xf5'},{'\x92','\xf8'},
    {'\xd7','\xf6'},{'\xd7','\xf2'},{'\xb3','\xa4'},{'\xd7','\xf3'},{'\xfd','\xaf'},
    {'\xd7','\xf4'},{'\x00','\x00'},{'\xfd','\xae'},{'\x8a','\x7a'},{'\x96','\xa8'},
    {'\xdc','\x5f'},{'\xdc','\x61'},{'\xdc','\x5d'},{'\xdc','\x60'},{'\xb6','\x6f'},
    {'\xdc','\x5e'},{'\xb6','\x70'},{'\x00','\x00'},{'\xfd','\xb0'},{'\xdd','\x73'},
    {'\xb9','\x55'},{'\xb9','\x54'},{'\x00','\x00'},{'\xb9','\x53'},{'\x00','\x00'},
    {'\xe0','\xac'},{'\xe0','\xad'},{'\x96','\xa9'},{'\x8b','\x4c'},{'\xe4','\x73'},
    {'\xe4','\x75'},{'\xbb','\xc6'},{'\xbb','\xc3'},{'\x96','\xa1'},{'\xbb','\xc5'},
    {'\xbb','\xc4'},{'\xe4','\x74'},{'\xe4','\x72'},{'\x00','\x00'},{'\xfd','\xb1'},
    {'\x8d','\xa6'},{'\x90','\xa5'},{'\x8d','\x5d'},{'\xe8','\x61'},{'\xe8','\x5e'},
    {'\xe8','\x5f'},{'\xbe','\x4d'},{'\xe8','\x60'},{'\xe8','\x5b'},{'\xe8','\x5c'},
    {'\xbe','\x4a'},{'\x00','\x00'},{'\xbe','\x4b'},{'\xe8','\x5d'},{'\xbe','\x4c'},
    {'\x96','\xaa'},{'\xeb','\xdb'},{'\xfd','\xb2'},{'\xeb','\xdc'},{'\xeb','\xd9'},
    {'\xeb','\xda'},{'\xbf','\xf4'},{'\xeb','\xd8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x82','\x79'},{'\x00','\x00'},{'\xee','\xc8'},{'\xee','\xc5'},
    {'\xee','\xc7'},{'\xc1','\xe0'},{'\xee','\xcb'},{'\xc1','\xdf'},{'\xee','\xc9'},
    {'\xee','\xcc'},{'\xee','\xca'},{'\xee','\xc6'},{'\xc1','\xde'},{'\x82','\x66'},
    {'\xf1','\x4f'},{'\x00','\x00'},{'\xf1','\x50'},{'\xf1','\x4e'},{'\x9e','\x63'},
    {'\xf1','\x52'},{'\xc2','\xe5'},{'\xc2','\xe6'},{'\xf3','\x5f'},{'\xc3','\xe7'},
    {'\xf1','\x51'},{'\xf3','\x5e'},{'\xc3','\xe6'},{'\xf4','\xe5'},{'\xf4','\xe6'},
    {'\xc4','\xbf'},{'\xf4','\xe4'},{'\x9e','\x64'},{'\xf4','\xe3'},{'\x92','\xf1'},
    {'\xf6','\x5d'},{'\xc5','\x48'},{'\xfd','\xb3'},{'\xf8','\x49'},{'\xf8','\xc8'},
    {'\xf8','\xc7'},{'\x00','\x00'},{'\xc6','\x43'},{'\xc6','\x5d'},{'\xf8','\xc9'},
    {'\xf9','\x71'},{'\x9e','\x65'},{'\xc6','\x6f'},{'\xa8','\xbc'},{'\xaa','\xf6'},
    {'\x92','\xd8'},{'\xb9','\x56'},{'\x8c','\x5c'},{'\xc4','\xc0'},{'\xa8','\xbd'},
    {'\xad','\xab'},{'\xb3','\xa5'},{'\xb6','\x71'},{'\xc2','\xe7'},{'\xaa','\xf7'},
    {'\x00','\x00'},{'\xd0','\xc1'},{'\xd0','\xc0'},{'\xd4','\x42'},{'\x91','\xb9'},
    {'\xb0','\x78'},{'\xb0','\x76'},{'\xb0','\x7a'},{'\xd4','\x44'},{'\x91','\xba'},
    {'\xb0','\x79'},{'\xb0','\x77'},{'\x91','\xbb'},{'\x96','\x49'},{'\x00','\x00'},
    {'\x91','\xbc'},{'\xd4','\x43'},{'\xb3','\xa8'},{'\xd7','\xfc'},{'\x91','\xbd'},
    {'\xb3','\xa7'},{'\xb3','\xa9'},{'\xd8','\x42'},{'\xb3','\xab'},{'\xd7','\xfe'},
    {'\xd8','\x40'},{'\xd7','\xf7'},{'\xb3','\xaa'},{'\xd8','\x43'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xd7','\xf9'},{'\x00','\x00'},{'\xd7','\xfa'},{'\xd7','\xf8'},
    {'\xb3','\xa6'},{'\x91','\xbe'},{'\xd8','\x41'},{'\xd7','\xfb'},{'\xd7','\xfd'},
    {'\x9e','\x66'},{'\x00','\x00'},{'\x91','\xbf'},{'\xdc','\x6d'},{'\xfd','\xb7'},
    {'\xdc','\x6c'},{'\xdc','\x6a'},{'\xdc','\x62'},{'\xdc','\x71'},{'\xdc','\x65'},
    {'\xdc','\x6f'},{'\xdc','\x76'},{'\xdc','\x6e'},{'\xb6','\x79'},{'\x9e','\x67'},
    {'\xb6','\x75'},{'\xdc','\x63'},{'\x00','\x00'},{'\xdc','\x69'},{'\xb6','\x77'},
    {'\x95','\x4c'},{'\xdc','\x68'},{'\xb6','\x78'},{'\xb6','\x7a'},{'\xdc','\x6b'},
    {'\x9e','\x68'},{'\xb6','\x72'},{'\xb6','\x73'},{'\xdc','\x77'},{'\xdc','\x75'},
    {'\x00','\x00'},{'\xdc','\x74'},{'\xdc','\x66'},{'\x00','\x00'},{'\xdc','\x72'},
    {'\x00','\x00'},{'\xb6','\x76'},{'\x00','\x00'},{'\x00','\x00'},{'\x9e','\x69'},
    {'\x00','\x00'},{'\xb6','\x74'},{'\xdc','\x73'},{'\xdc','\x64'},{'\xdc','\x67'},
    {'\xdc','\x70'},{'\x9e','\x6a'},{'\x91','\xc0'},{'\xfb','\x5f'},{'\x9e','\x6b'},
    {'\x91','\xc1'},{'\xe4','\xba'},{'\xe0','\xb7'},{'\x00','\x00'},{'\xe0','\xb0'},
    {'\xe0','\xc3'},{'\xe0','\xcc'},{'\xe0','\xb3'},{'\xb9','\x61'},{'\x9e','\x6c'},
    {'\xe0','\xc0'},{'\xb9','\x57'},{'\xb9','\x59'},{'\xb9','\x65'},{'\xe0','\xb1'},
    {'\x00','\x00'},{'\x9e','\x6d'},{'\xb9','\x5a'},{'\xb9','\x5c'},{'\xb9','\x66'},
    {'\xb9','\x5b'},{'\x9e','\x6e'},{'\x00','\x00'},{'\x00','\x00'},{'\x93','\x7b'},
    {'\xb9','\x64'},{'\xe0','\xb9'},{'\x00','\x00'},{'\xe0','\xae'},{'\xb9','\x62'},
    {'\xe0','\xb8'},{'\xb9','\x5e'},{'\xe0','\xca'},{'\xb9','\x63'},{'\xe0','\xc8'},
    {'\xe0','\xbc'},{'\xe0','\xc6'},{'\xb9','\x60'},{'\xe0','\xaf'},{'\xe0','\xc9'},
    {'\xe0','\xc4'},{'\x96','\x40'},{'\xe0','\xcb'},{'\xb9','\x58'},{'\x9e','\x6f'},
    {'\x91','\xc3'},{'\xb9','\x67'},{'\xb9','\x5d'},{'\x00','\x00'},{'\x9e','\x70'},
    {'\xe0','\xb5'},{'\x9e','\x71'},{'\xe0','\xbd'},{'\xe0','\xc1'},{'\x95','\xf1'},
    {'\xe0','\xc5'},{'\xb9','\x5f'},{'\xe0','\xb4'},{'\xe0','\xb2'},{'\xe0','\xbe'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x9e','\x72'},{'\xe0','\xbb'},
    {'\xe0','\xba'},{'\x9e','\x73'},{'\xe0','\xbf'},{'\xe0','\xc2'},{'\x92','\xc0'},
    {'\xe0','\xc7'},{'\x96','\x43'},{'\x8c','\xe5'},{'\x00','\x00'},{'\xe4','\x78'},
    {'\x91','\xc4'},{'\xbb','\xc7'},{'\xe4','\xa4'},{'\xe4','\x7a'},{'\xbb','\xcc'},
    {'\xbb','\xd0'},{'\xe4','\xad'},{'\xe4','\xb5'},{'\xe4','\xa6'},{'\xbb','\xc8'},
    {'\x9e','\x74'},{'\xe4','\xaa'},{'\xe0','\xb6'},{'\x9e','\x75'},{'\xbb','\xc9'},
    {'\xe4','\xb1'},{'\xe4','\xb6'},{'\xe4','\xae'},{'\x9e','\x76'},{'\xe4','\xb0'},
    {'\xe4','\xb9'},{'\xe4','\xb2'},{'\xe4','\x7e'},{'\xe4','\xa9'},{'\x9e','\x77'},
    {'\x00','\x00'},{'\xbb','\xd1'},{'\x00','\x00'},{'\xbb','\xcd'},{'\xe4','\x7c'},
    {'\xe4','\xab'},{'\xbb','\xcb'},{'\xe4','\xa5'},{'\xbb','\xca'},{'\xe4','\xb3'},
    {'\xe4','\xa2'},{'\xe4','\x79'},{'\xbb','\xce'},{'\xe4','\xb8'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe4','\x7b'},{'\xe4','\xaf'},{'\xe4','\xac'},{'\xe4','\xa7'},
    {'\xe4','\x77'},{'\xe4','\x76'},{'\xe4','\xa1'},{'\xe4','\xb4'},{'\xbb','\xcf'},
    {'\xe4','\xb7'},{'\xe4','\x7d'},{'\xe4','\xa3'},{'\xbe','\x52'},{'\x93','\x4b'},
    {'\x8d','\xa8'},{'\x00','\x00'},{'\x00','\x00'},{'\x9e','\x78'},{'\xbe','\x5a'},
    {'\xbe','\x55'},{'\xe8','\xa4'},{'\xe8','\xa1'},{'\xe8','\x67'},{'\xbe','\x50'},
    {'\x00','\x00'},{'\xf9','\xd7'},{'\x9e','\x79'},{'\xbe','\x4f'},{'\xbe','\x56'},
    {'\x00','\x00'},{'\xfd','\xb9'},{'\x9e','\x7a'},{'\xe8','\x65'},{'\xbe','\x54'},
    {'\xe8','\x71'},{'\xe8','\x63'},{'\xe8','\x64'},{'\xbe','\x4e'},{'\xe8','\xa3'},
    {'\xbe','\x58'},{'\xe8','\x74'},{'\xe8','\x79'},{'\xe8','\x73'},{'\xeb','\xee'},
    {'\xe8','\x6f'},{'\xe8','\x77'},{'\xe8','\x75'},{'\xe8','\x68'},{'\xe8','\x62'},
    {'\xe8','\x7d'},{'\xbe','\x57'},{'\xe8','\x7e'},{'\x9e','\x7b'},{'\xe8','\x78'},
    {'\x00','\x00'},{'\xe8','\x6d'},{'\xe8','\x6b'},{'\xe8','\x66'},{'\x00','\x00'},
    {'\x9e','\x7c'},{'\x00','\x00'},{'\xe8','\x6e'},{'\xe8','\x7b'},{'\xe8','\x6a'},
    {'\xe8','\x7a'},{'\xe8','\xa2'},{'\x00','\x00'},{'\x9e','\x7d'},{'\xbe','\x53'},
    {'\x9e','\x7e'},{'\xe8','\x76'},{'\xe8','\x7c'},{'\xe8','\x72'},{'\xe8','\x6c'},
    {'\xbe','\x51'},{'\x9e','\xa1'},{'\x9e','\xa2'},{'\x91','\xc5'},{'\xe4','\xa8'},
    {'\xe8','\x70'},{'\xbe','\x59'},{'\xe8','\x69'},{'\x94','\x58'},{'\x93','\x74'},
    {'\x9e','\xa3'},{'\x00','\x00'},{'\x9e','\xa4'},{'\xeb','\xf4'},{'\xbf','\xf7'},
    {'\xeb','\xf3'},{'\xeb','\xf0'},{'\xec','\x44'},{'\xbf','\xfb'},{'\x9e','\xa5'},
    {'\xec','\x41'},{'\xeb','\xf8'},{'\xec','\x43'},{'\xeb','\xe9'},{'\xeb','\xf6'},
    {'\x9e','\xa6'},{'\xbf','\xfd'},{'\x00','\x00'},{'\xeb','\xe1'},{'\x9e','\xa7'},
    {'\xeb','\xdf'},{'\xec','\x42'},{'\x00','\x00'},{'\xec','\x40'},{'\xeb','\xfe'},
    {'\xeb','\xed'},{'\xeb','\xec'},{'\xeb','\xe2'},{'\xc0','\x40'},{'\x00','\x00'},
    {'\xeb','\xe8'},{'\xeb','\xf2'},{'\xeb','\xfd'},{'\xc0','\x43'},{'\xec','\x45'},
    {'\x00','\x00'},{'\xc1','\xe8'},{'\xc0','\x45'},{'\xbf','\xfe'},{'\xeb','\xe6'},
    {'\x00','\x00'},{'\xeb','\xef'},{'\xeb','\xde'},{'\xeb','\xe0'},{'\xbf','\xf5'},
    {'\xc0','\x42'},{'\xbf','\xfa'},{'\xeb','\xe7'},{'\xeb','\xf7'},{'\xeb','\xf1'},
    {'\xc0','\x41'},{'\xeb','\xdd'},{'\xc1','\xe3'},{'\xeb','\xf9'},{'\xeb','\xfc'},
    {'\xbf','\xfc'},{'\x93','\xf3'},{'\xeb','\xeb'},{'\xc0','\x44'},{'\xbf','\xf9'},
    {'\x9e','\xa8'},{'\x9e','\xa9'},{'\x93','\xf7'},{'\xbf','\xf8'},{'\xeb','\xf5'},
    {'\xeb','\xfb'},{'\xbf','\xf6'},{'\x00','\x00'},{'\xeb','\xe4'},{'\xeb','\xfa'},
    {'\x91','\xc6'},{'\x94','\xdb'},{'\xeb','\xe5'},{'\x00','\x00'},{'\x8b','\xd6'},
    {'\x00','\x00'},{'\x9e','\xaa'},{'\xfe','\x7c'},{'\x9e','\xab'},{'\x9e','\xac'},
    {'\x97','\x55'},{'\x96','\x42'},{'\xeb','\xea'},{'\xee','\xd2'},{'\xfe','\x79'},
    {'\xee','\xd7'},{'\xc1','\xe5'},{'\xc1','\xe7'},{'\xee','\xdd'},{'\xc1','\xe1'},
    {'\xee','\xec'},{'\xee','\xe3'},{'\xee','\xd8'},{'\xee','\xd9'},{'\xee','\xe2'},
    {'\x00','\x00'},{'\xc1','\xee'},{'\xee','\xe1'},{'\xee','\xd1'},{'\xee','\xe0'},
    {'\xee','\xd4'},{'\xee','\xed'},{'\xc1','\xed'},{'\xc1','\xeb'},{'\xee','\xd5'},
    {'\x00','\x00'},{'\xee','\xe8'},{'\x9e','\xad'},{'\xee','\xda'},{'\xee','\xe7'},
    {'\x9e','\xae'},{'\xee','\xe9'},{'\xee','\xd0'},{'\xc1','\xe6'},{'\x9e','\xaf'},
    {'\xee','\xea'},{'\x9e','\xb0'},{'\x96','\x44'},{'\xee','\xde'},{'\xfd','\xba'},
    {'\xc1','\xea'},{'\xee','\xdb'},{'\xfd','\xbb'},{'\x00','\x00'},{'\xc1','\xec'},
    {'\xee','\xe4'},{'\x00','\x00'},{'\x9e','\xb1'},{'\x9e','\xb2'},{'\xc1','\xe4'},
    {'\xee','\xd6'},{'\xee','\xe5'},{'\x9e','\xb3'},{'\xee','\xdf'},{'\xeb','\xe3'},
    {'\xee','\xe6'},{'\xee','\xd3'},{'\x9e','\xb4'},{'\xc1','\xe9'},{'\x00','\x00'},
    {'\xee','\xeb'},{'\x9e','\xb5'},{'\xc1','\xe2'},{'\xee','\xce'},{'\x9e','\xb6'},
    {'\xfb','\x73'},{'\x9e','\xb7'},{'\x9e','\xb8'},{'\xf1','\x60'},{'\xf1','\x59'},
    {'\xc2','\xe9'},{'\x00','\x00'},{'\xf1','\x54'},{'\xf1','\x63'},{'\xf1','\x5b'},
    {'\xee','\xdc'},{'\x9e','\xb9'},{'\xf1','\x65'},{'\xf1','\x55'},{'\x00','\x00'},
    {'\xc2','\xe8'},{'\xf1','\x5f'},{'\xc2','\xea'},{'\xc2','\xf2'},{'\xc2','\xf0'},
    {'\xf1','\x61'},{'\xc2','\xf1'},{'\xf1','\x57'},{'\x9e','\xba'},{'\xf1','\x58'},
    {'\xf1','\x5d'},{'\xf1','\x62'},{'\x9e','\xbb'},{'\xee','\xcd'},{'\xc2','\xeb'},
    {'\xf1','\x6a'},{'\xf1','\x67'},{'\xf1','\x6b'},{'\xf1','\x5e'},{'\xf1','\x5a'},
    {'\xf1','\x68'},{'\xf3','\x6a'},{'\xf1','\x5c'},{'\x00','\x00'},{'\xc2','\xee'},
    {'\x97','\x56'},{'\xc2','\xed'},{'\xee','\xcf'},{'\xc2','\xef'},{'\xf1','\x64'},
    {'\xf1','\x66'},{'\xc2','\xec'},{'\xf1','\x69'},{'\xf1','\x53'},{'\x00','\x00'},
    {'\xf1','\x56'},{'\x9e','\xbc'},{'\x94','\xdc'},{'\xfd','\xbc'},{'\x9e','\xbd'},
    {'\x00','\x00'},{'\x9e','\xbe'},{'\x00','\x00'},{'\x9e','\xbf'},{'\xf3','\x73'},
    {'\x00','\x00'},{'\xf3','\x63'},{'\xc3','\xeb'},{'\xf3','\x71'},{'\x00','\x00'},
    {'\x97','\x57'},{'\xf3','\x61'},{'\xc3','\xec'},{'\x00','\x00'},{'\xf3','\x6c'},
    {'\x9e','\xc0'},{'\xf3','\x68'},{'\xc3','\xf1'},{'\xf3','\x72'},{'\xf3','\x62'},
    {'\xf3','\x65'},{'\xc3','\xe9'},{'\xf3','\x74'},{'\x9e','\xc1'},{'\xf3','\x6d'},
    {'\xf3','\x70'},{'\xc3','\xef'},{'\xc3','\xf4'},{'\xc3','\xf2'},{'\xf3','\x69'},
    {'\xf3','\x64'},{'\x9e','\xc2'},{'\xc3','\xed'},{'\xc3','\xee'},{'\xf3','\x60'},
    {'\xc3','\xea'},{'\x9e','\xc3'},{'\xc3','\xe8'},{'\xc3','\xf0'},{'\xf3','\x6f'},
    {'\xc3','\xf3'},{'\x97','\x58'},{'\xf3','\x6b'},{'\xf3','\x75'},{'\xc3','\xf5'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xf3','\x67'},{'\x00','\x00'},
    {'\xf3','\x6e'},{'\x00','\x00'},{'\x9e','\xc4'},{'\x9e','\xc5'},{'\x00','\x00'},
    {'\x9e','\xc6'},{'\x9e','\xc7'},{'\xf4','\xf3'},{'\xf5','\x42'},{'\xf4','\xf5'},
    {'\xf4','\xfc'},{'\xf3','\x66'},{'\xf4','\xfa'},{'\xf4','\xe9'},{'\xf5','\x40'},
    {'\xc4','\xc3'},{'\xf4','\xed'},{'\xf4','\xfe'},{'\xf4','\xf4'},{'\x9e','\xc8'},
    {'\x00','\x00'},{'\xc4','\xc2'},{'\x9e','\xc9'},{'\x00','\x00'},{'\xf5','\x44'},
    {'\xf4','\xf6'},{'\x9e','\xca'},{'\xf4','\xfb'},{'\xf4','\xfd'},{'\xf4','\xe7'},
    {'\xf5','\x41'},{'\xf4','\xf2'},{'\xf4','\xf7'},{'\xf4','\xeb'},{'\xf4','\xef'},
    {'\xf5','\x43'},{'\xf4','\xf9'},{'\xf4','\xe8'},{'\xf4','\xec'},{'\xf4','\xee'},
    {'\xf4','\xf8'},{'\x9e','\xcb'},{'\xc4','\xc1'},{'\xf4','\xf1'},{'\x97','\x59'},
    {'\x9e','\xcc'},{'\x00','\x00'},{'\x9e','\xcd'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf4','\xea'},{'\x97','\x5a'},{'\x00','\x00'},{'\x00','\x00'},{'\x9e','\xce'},
    {'\x9e','\xcf'},{'\x9e','\xd0'},{'\xfd','\xbd'},{'\xf4','\xf0'},{'\xf6','\x61'},
    {'\xf6','\x66'},{'\xc5','\x4f'},{'\xf6','\x68'},{'\x9e','\xd1'},{'\xc5','\x49'},
    {'\x00','\x00'},{'\xf6','\x64'},{'\xf6','\x6a'},{'\xc5','\x4e'},{'\xc5','\x4a'},
    {'\x00','\x00'},{'\xc5','\x4b'},{'\xf6','\x60'},{'\xf6','\x67'},{'\xc5','\x4d'},
    {'\xf6','\x65'},{'\xc5','\x4c'},{'\xf6','\x5f'},{'\xf6','\x63'},{'\xf6','\x62'},
    {'\x97','\x5b'},{'\xf6','\x5e'},{'\xf6','\x69'},{'\x97','\x5c'},{'\x9e','\xd2'},
    {'\x9e','\xd3'},{'\xc5','\xb1'},{'\xf7','\x6d'},{'\xf7','\x70'},{'\xf7','\x6c'},
    {'\xf7','\x6e'},{'\xf7','\x6f'},{'\xf7','\x69'},{'\xf7','\x6a'},{'\xf7','\x67'},
    {'\x9e','\xd4'},{'\x00','\x00'},{'\xf7','\x6b'},{'\xf7','\x68'},{'\xc5','\xb2'},
    {'\xc5','\xb3'},{'\x97','\x5d'},{'\x9e','\xd5'},{'\xf8','\x4b'},{'\x00','\x00'},
    {'\xf8','\x4d'},{'\x9e','\xd6'},{'\x00','\x00'},{'\x97','\x5e'},{'\x95','\x58'},
    {'\x00','\x00'},{'\xf8','\x4c'},{'\xf8','\x4e'},{'\x00','\x00'},{'\xc5','\xe0'},
    {'\x00','\x00'},{'\xf8','\x4a'},{'\xc5','\xdf'},{'\xc5','\xe1'},{'\x9e','\xd7'},
    {'\x00','\x00'},{'\x9e','\xd8'},{'\xf8','\xcb'},{'\xf8','\xcc'},{'\xc6','\x44'},
    {'\xf8','\xca'},{'\x9e','\xd9'},{'\xf9','\x53'},{'\xf9','\x52'},{'\xf9','\x54'},
    {'\xc6','\x5f'},{'\xf9','\x55'},{'\xc6','\x5e'},{'\xf9','\x56'},{'\xf9','\x72'},
    {'\xf9','\x75'},{'\xf9','\x74'},{'\xc6','\x68'},{'\xf9','\x73'},{'\x9e','\xda'},
    {'\x00','\x00'},{'\x9e','\xdb'},{'\xc6','\x72'},{'\xc6','\x70'},{'\xc6','\x71'},
    {'\xc6','\x77'},{'\xf9','\xc0'},{'\xf9','\xc1'},{'\xf9','\xbf'},{'\xf9','\xc9'},
    {'\x00','\x00'},{'\x9c','\xf0'},{'\x8d','\xc1'},{'\x8d','\xc0'},{'\x83','\xe1'},
    {'\x83','\xe0'},{'\x83','\xe2'},{'\x83','\xe3'},{'\x8d','\xc7'},{'\x8d','\xd9'},
    {'\x8d','\xd6'},{'\x84','\xb6'},{'\x8d','\xd7'},{'\x00','\x00'},{'\x84','\xb7'},
    {'\x84','\xb5'},{'\x8f','\x46'},{'\x8d','\xd8'},{'\x00','\x00'},{'\x84','\xb4'},
    {'\x00','\x00'},{'\x85','\x73'},{'\x97','\x5f'},{'\x8d','\xf4'},{'\x86','\x73'},
    {'\x85','\x76'},{'\x85','\x71'},{'\x8c','\x5d'},{'\x85','\x74'},{'\x88','\xae'},
    {'\x89','\xa1'},{'\x85','\x78'},{'\x85','\x77'},{'\x8d','\x76'},{'\x84','\xe8'},
    {'\x85','\x75'},{'\x8b','\x4f'},{'\x86','\x6e'},{'\x8d','\xf7'},{'\x8d','\xf2'},
    {'\x8d','\xf3'},{'\x8d','\xf6'},{'\x85','\x72'},{'\x8d','\xf5'},{'\x8e','\x5a'},
    {'\x89','\x7e'},{'\x8e','\x5b'},{'\x86','\x68'},{'\x86','\x67'},{'\x84','\x73'},
    {'\x8e','\x5c'},{'\x97','\x60'},{'\x86','\x6a'},{'\x86','\x69'},{'\x8d','\xb2'},
    {'\x8d','\xa7'},{'\x8e','\x60'},{'\x8e','\x5f'},{'\x86','\x6b'},{'\x86','\x75'},
    {'\x86','\x6c'},{'\x8c','\xb2'},{'\x86','\x6f'},{'\x86','\x70'},{'\x8d','\x44'},
    {'\x86','\x6d'},{'\x86','\x76'},{'\x00','\x00'},{'\x8e','\x59'},{'\x86','\x71'},
    {'\x8e','\x58'},{'\x86','\x72'},{'\x8e','\x5e'},{'\x86','\x74'},{'\x8c','\xb4'},
    {'\x00','\x00'},{'\x88','\xa8'},{'\x8e','\xa5'},{'\x8e','\xa4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8e','\xa6'},{'\x8e','\xac'},{'\x8e','\xd1'},{'\x97','\x61'},
    {'\x8c','\x5e'},{'\x00','\x00'},{'\x8c','\xb3'},{'\x87','\x66'},{'\x88','\xaa'},
    {'\x97','\x62'},{'\x8e','\xa7'},{'\x8f','\xa7'},{'\x8f','\x6a'},{'\x87','\x68'},
    {'\x87','\x6c'},{'\x8e','\xd5'},{'\x8e','\xad'},{'\x00','\x00'},{'\x8f','\xec'},
    {'\x87','\x6a'},{'\x8f','\xcd'},{'\x8e','\xaa'},{'\x8e','\xa8'},{'\x87','\x69'},
    {'\x87','\x67'},{'\x89','\xa4'},{'\x8e','\xa9'},{'\x87','\x64'},{'\x8e','\xa3'},
    {'\x85','\xb6'},{'\x97','\x63'},{'\x8f','\xe5'},{'\x87','\x6b'},{'\x87','\x65'},
    {'\x8e','\xab'},{'\x8c','\xe4'},{'\x8f','\xee'},{'\x88','\xa7'},{'\x00','\x00'},
    {'\x8f','\x42'},{'\x8e','\xd2'},{'\x8b','\xce'},{'\x8b','\xd5'},{'\x88','\xa6'},
    {'\x8b','\x4e'},{'\x88','\xaf'},{'\x97','\x64'},{'\x88','\xa9'},{'\x8a','\xa2'},
    {'\x8e','\xd6'},{'\x8e','\xd7'},{'\x8c','\x5f'},{'\x88','\xac'},{'\x8e','\xd4'},
    {'\x88','\xad'},{'\x88','\xa4'},{'\x8e','\x5d'},{'\x97','\x65'},{'\x97','\x66'},
    {'\x88','\xab'},{'\x88','\xa5'},{'\x8e','\xd0'},{'\x8e','\xd3'},{'\x8e','\xd8'},
    {'\x8f','\x44'},{'\x8f','\x40'},{'\x8f','\x41'},{'\x97','\x67'},{'\x89','\x7d'},
    {'\x8a','\x7d'},{'\x8f','\x43'},{'\x00','\x00'},{'\x97','\x68'},{'\x8f','\x45'},
    {'\x89','\xa7'},{'\x00','\x00'},{'\x89','\xa2'},{'\x89','\xa8'},{'\x8d','\xa9'},
    {'\x8a','\xa3'},{'\x89','\xa5'},{'\x89','\xa6'},{'\x00','\x00'},{'\x90','\xf1'},
    {'\x8e','\xfd'},{'\x97','\x69'},{'\x97','\x6a'},{'\x8e','\xfe'},{'\x89','\x7a'},
    {'\x8a','\x7e'},{'\x89','\x7b'},{'\x89','\x7c'},{'\x89','\xa9'},{'\x8a','\xa1'},
    {'\x00','\x00'},{'\x8f','\x69'},{'\x8b','\xd3'},{'\x8f','\x6b'},{'\x8a','\xa8'},
    {'\x8f','\x68'},{'\x8a','\xa5'},{'\x8a','\xa4'},{'\x8a','\xa6'},{'\x8f','\xa8'},
    {'\x00','\x00'},{'\x8a','\xa7'},{'\x97','\x6b'},{'\x8a','\x7b'},{'\x8a','\x7c'},
    {'\x8b','\xd4'},{'\x00','\x00'},{'\x8f','\xea'},{'\x97','\x6c'},{'\x8a','\x42'},
    {'\x8b','\x51'},{'\x00','\x00'},{'\x8b','\x54'},{'\x8d','\x7d'},{'\x00','\x00'},
    {'\x8c','\xb6'},{'\x8b','\x50'},{'\x97','\x6d'},{'\x8f','\xa9'},{'\x8b','\x52'},
    {'\x8b','\x4d'},{'\x8b','\x53'},{'\x8f','\xa6'},{'\x90','\x60'},{'\x00','\x00'},
    {'\x8b','\xd1'},{'\x8b','\xcf'},{'\x8b','\xd0'},{'\x8b','\xd2'},{'\x00','\x00'},
    {'\x8f','\xc9'},{'\x8b','\xcb'},{'\x8b','\xcc'},{'\x8b','\xcd'},{'\x8f','\xca'},
    {'\x00','\x00'},{'\x8f','\xe8'},{'\x97','\x6e'},{'\x8f','\xe9'},{'\x8f','\xed'},
    {'\x97','\x6f'},{'\x8f','\xe6'},{'\x90','\xa1'},{'\x8f','\xe7'},{'\x97','\x70'},
    {'\x8f','\xcb'},{'\x8f','\xeb'},{'\x90','\x61'},{'\x8c','\xb1'},{'\x00','\x00'},
    {'\x8c','\xb5'},{'\x8c','\xb0'},{'\x90','\x48'},{'\x97','\x71'},{'\x8d','\x43'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x8c','\x7c'},{'\xaa','\xf8'},{'\x9e','\xdc'},
    {'\x00','\x00'},{'\xd8','\x44'},{'\xdc','\x78'},{'\xe8','\xa5'},{'\xf3','\x76'},
    {'\x00','\x00'},{'\x83','\x63'},{'\xaa','\xf9'},{'\x00','\x00'},{'\xad','\xac'},
    {'\xb0','\x7b'},{'\x00','\x00'},{'\x9e','\xdd'},{'\xd8','\x45'},{'\x97','\x72'},
    {'\xd8','\x46'},{'\xb3','\xac'},{'\x94','\xdd'},{'\xb6','\x7d'},{'\xdc','\x7a'},
    {'\xdc','\x79'},{'\xb6','\xa3'},{'\xb6','\x7c'},{'\xdc','\x7b'},{'\xb6','\x7e'},
    {'\xb6','\xa2'},{'\xb6','\xa1'},{'\xb6','\x7b'},{'\x00','\x00'},{'\x94','\xde'},
    {'\xfd','\xbe'},{'\xb9','\x68'},{'\x97','\x73'},{'\x00','\x00'},{'\xe0','\xd0'},
    {'\xe0','\xce'},{'\x00','\x00'},{'\xe0','\xcf'},{'\xe0','\xcd'},{'\x97','\x74'},
    {'\xbb','\xd2'},{'\x92','\x6b'},{'\xbb','\xd5'},{'\xbb','\xd7'},{'\xbb','\xd6'},
    {'\x9e','\xde'},{'\xfd','\xbf'},{'\xbb','\xd3'},{'\xbb','\xd4'},{'\x9e','\xdf'},
    {'\xe8','\xa7'},{'\xe8','\xa6'},{'\xbe','\x5b'},{'\xe8','\xa8'},{'\x00','\x00'},
    {'\xe8','\xa9'},{'\xbe','\x5c'},{'\x97','\x75'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xec','\x4d'},{'\xec','\x4b'},{'\xee','\xf3'},{'\x00','\x00'},{'\xec','\x49'},
    {'\xec','\x4a'},{'\xc0','\x46'},{'\xec','\x46'},{'\xec','\x4e'},{'\xec','\x48'},
    {'\xec','\x4c'},{'\xee','\xef'},{'\x00','\x00'},{'\x00','\x00'},{'\xee','\xf1'},
    {'\x00','\x00'},{'\xee','\xf2'},{'\xc1','\xf3'},{'\xee','\xee'},{'\xc1','\xf2'},
    {'\xee','\xf0'},{'\xc1','\xef'},{'\xc1','\xf0'},{'\xc1','\xf1'},{'\xec','\x47'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc2','\xf5'},{'\xf1','\x6e'},{'\xf1','\x6c'},
    {'\xf1','\x6d'},{'\xc2','\xf3'},{'\xc2','\xf6'},{'\xc2','\xf4'},{'\x00','\x00'},
    {'\x93','\xa7'},{'\x00','\x00'},{'\xf3','\x77'},{'\xf3','\x78'},{'\xc3','\xf6'},
    {'\x00','\x00'},{'\xf5','\x45'},{'\xf5','\x47'},{'\xf5','\x46'},{'\xc4','\xc4'},
    {'\xc5','\x50'},{'\xf6','\x6d'},{'\xf6','\x6c'},{'\xf6','\x6b'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x83','\x64'},{'\x83','\xa2'},{'\x83','\xe4'},{'\x8d','\xda'},
    {'\x00','\x00'},{'\x84','\xb8'},{'\x83','\xf4'},{'\x8b','\x56'},{'\x85','\x7a'},
    {'\x8a','\xac'},{'\x85','\x7c'},{'\x85','\x7e'},{'\x85','\x7d'},{'\x85','\x79'},
    {'\x8d','\xf8'},{'\x84','\xdd'},{'\x86','\x77'},{'\x88','\xc1'},{'\x87','\x6e'},
    {'\x87','\x47'},{'\x90','\x49'},{'\x87','\x6f'},{'\x88','\xb0'},{'\x00','\x00'},
    {'\x87','\x71'},{'\x87','\x70'},{'\x87','\x6d'},{'\x8e','\xda'},{'\x90','\xac'},
    {'\x88','\xb1'},{'\x8e','\xd9'},{'\x00','\x00'},{'\x8f','\x48'},{'\x8f','\x49'},
    {'\x8f','\x4a'},{'\x8f','\xb0'},{'\x8f','\x4b'},{'\x8f','\x4c'},{'\x89','\xaa'},
    {'\x8f','\x47'},{'\x8c','\x60'},{'\x8a','\xab'},{'\x8f','\x6c'},{'\x00','\x00'},
    {'\x8a','\xa9'},{'\x8a','\xaa'},{'\x8b','\x55'},{'\x8b','\x57'},{'\x00','\x00'},
    {'\x8b','\x58'},{'\x8f','\xef'},{'\x00','\x00'},{'\xaa','\xfa'},{'\x9c','\xf1'},
    {'\xc9','\xaa'},{'\x85','\xa1'},{'\xca','\x58'},{'\xa6','\xe9'},{'\xca','\x56'},
    {'\xca','\x59'},{'\xca','\x57'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xcb','\xae'},{'\x00','\x00'},{'\xa8','\xc1'},{'\x00','\x00'},{'\xa8','\xc2'},
    {'\xcb','\xb0'},{'\xa8','\xbf'},{'\xcb','\xaf'},{'\xcb','\xad'},{'\xa8','\xc0'},
    {'\xa8','\xbe'},{'\x85','\xa3'},{'\x84','\xbb'},{'\x83','\xe5'},{'\x85','\xa2'},
    {'\x00','\x00'},{'\xfd','\xc1'},{'\xcd','\xd8'},{'\xcd','\xdb'},{'\xaa','\xfd'},
    {'\xcd','\xda'},{'\xcd','\xd9'},{'\x00','\x00'},{'\xaa','\xfc'},{'\xaa','\xfb'},
    {'\xfe','\x42'},{'\xab','\x40'},{'\xcd','\xdc'},{'\xaa','\xfe'},{'\x87','\x72'},
    {'\x84','\xba'},{'\x8b','\xd8'},{'\x84','\xb9'},{'\x83','\xe7'},{'\xd0','\xc6'},
    {'\xad','\xae'},{'\xad','\xaf'},{'\xad','\xb0'},{'\xd0','\xc7'},{'\xd0','\xc3'},
    {'\xad','\xad'},{'\xd0','\xc4'},{'\x00','\x00'},{'\xd0','\xc5'},{'\xd0','\xc2'},
    {'\x83','\xe6'},{'\x9e','\xe0'},{'\x00','\x00'},{'\xb0','\xa4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xb0','\xa1'},{'\xd4','\x45'},{'\xb0','\xa2'},{'\xb0','\xa5'},
    {'\xd4','\x46'},{'\x00','\x00'},{'\xb0','\x7e'},{'\xb0','\x7c'},{'\xb0','\x7d'},
    {'\xb0','\xa3'},{'\x92','\x67'},{'\x97','\x76'},{'\x8d','\xf9'},{'\x86','\x78'},
    {'\x89','\xac'},{'\xb3','\xad'},{'\xd8','\x49'},{'\xb3','\xb5'},{'\xd8','\x48'},
    {'\x00','\x00'},{'\xd8','\x4b'},{'\xb3','\xb1'},{'\xd8','\x4a'},{'\xb6','\xab'},
    {'\xb3','\xaf'},{'\xb3','\xb2'},{'\xb3','\xae'},{'\xb3','\xb3'},{'\xb3','\xb4'},
    {'\xb3','\xb0'},{'\x00','\x00'},{'\x92','\xb4'},{'\x9e','\xe1'},{'\xd8','\x47'},
    {'\xb6','\xa7'},{'\xdc','\x7d'},{'\x00','\x00'},{'\xdc','\xa3'},{'\xfd','\xc5'},
    {'\x00','\x00'},{'\xdc','\xa2'},{'\xb6','\xac'},{'\xb6','\xa8'},{'\xb6','\xa9'},
    {'\xdc','\x7c'},{'\xdc','\x7e'},{'\xdc','\xa1'},{'\xb6','\xa4'},{'\xb6','\xa6'},
    {'\x00','\x00'},{'\xb6','\xaa'},{'\xb6','\xa5'},{'\x92','\xfa'},{'\x8a','\xad'},
    {'\xe0','\xd3'},{'\xe0','\xd1'},{'\xe0','\xd2'},{'\xb9','\x6a'},{'\xb9','\x6b'},
    {'\xfd','\xc4'},{'\xe0','\xd4'},{'\xb9','\x69'},{'\xbb','\xd8'},{'\x00','\x00'},
    {'\xbb','\xda'},{'\xbb','\xd9'},{'\x97','\x77'},{'\xe4','\xbb'},{'\x00','\x00'},
    {'\x92','\x47'},{'\xe4','\xbc'},{'\xe8','\xab'},{'\x95','\xf9'},{'\xe8','\xaa'},
    {'\x9e','\xe2'},{'\x00','\x00'},{'\xc0','\x47'},{'\xc0','\x48'},{'\xec','\x4f'},
    {'\xc0','\x49'},{'\x00','\x00'},{'\xee','\xf6'},{'\x00','\x00'},{'\xee','\xf4'},
    {'\x97','\x78'},{'\xee','\xf5'},{'\xc1','\xf4'},{'\x97','\x79'},{'\xf1','\x6f'},
    {'\xc3','\xf7'},{'\x00','\x00'},{'\xc6','\xd7'},{'\x95','\xfb'},{'\xc1','\xf5'},
    {'\xab','\x41'},{'\x00','\x00'},{'\xb0','\xa6'},{'\xd4','\x47'},{'\x86','\x79'},
    {'\x8b','\xd9'},{'\xd8','\x4c'},{'\xb3','\xb6'},{'\xb6','\xad'},{'\xdc','\xa4'},
    {'\xdc','\xa6'},{'\xb6','\xaf'},{'\xb6','\xae'},{'\xb6','\xb0'},{'\xb6','\xb1'},
    {'\xdc','\xa5'},{'\xb9','\x6e'},{'\xb9','\x6f'},{'\xb9','\x6d'},{'\xbb','\xdb'},
    {'\xb9','\x6c'},{'\xe0','\xd5'},{'\x8b','\x5b'},{'\x00','\x00'},{'\x92','\xca'},
    {'\xbb','\xdc'},{'\xe8','\xac'},{'\xec','\x50'},{'\xc0','\x4a'},{'\xc1','\xf6'},
    {'\xf1','\x70'},{'\xf1','\x74'},{'\xc2','\xf9'},{'\xf1','\x71'},{'\xc2','\xfa'},
    {'\xc2','\xf8'},{'\xf1','\x75'},{'\xc2','\xfb'},{'\xf1','\x73'},{'\x90','\x6d'},
    {'\xf3','\x79'},{'\xc2','\xf7'},{'\xc3','\xf8'},{'\x00','\x00'},{'\xf8','\xcd'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xab','\x42'},{'\xb3','\xb8'},{'\xb3','\xb7'},
    {'\x94','\x48'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xb6','\xb2'},
    {'\xdc','\xa8'},{'\xdc','\xa7'},{'\xb6','\xb3'},{'\x8d','\x5e'},{'\x9e','\xe3'},
    {'\xe0','\xd9'},{'\xb9','\x73'},{'\xb9','\x70'},{'\xe0','\xd8'},{'\xb9','\x72'},
    {'\xe0','\xd6'},{'\xb9','\x71'},{'\x00','\x00'},{'\xe0','\xd7'},{'\x8b','\xda'},
    {'\xe4','\xbd'},{'\xbb','\xdd'},{'\x8c','\xe6'},{'\xe8','\xaf'},{'\xfd','\xc7'},
    {'\xbe','\x5d'},{'\xe8','\xad'},{'\xbe','\x5e'},{'\xbe','\x5f'},{'\xe8','\xae'},
    {'\xbe','\x60'},{'\x93','\xed'},{'\xec','\x51'},{'\x00','\x00'},{'\xc0','\x4e'},
    {'\xc0','\x4b'},{'\xc0','\x50'},{'\xec','\x53'},{'\xc0','\x4c'},{'\xec','\x52'},
    {'\xc0','\x4f'},{'\x00','\x00'},{'\x00','\x00'},{'\xc0','\x4d'},{'\x00','\x00'},
    {'\xee','\xf9'},{'\xee','\xfb'},{'\x00','\x00'},{'\x9e','\xe4'},{'\xc1','\xf7'},
    {'\xee','\xfa'},{'\xc1','\xf8'},{'\xee','\xf8'},{'\xee','\xf7'},{'\xfd','\xc8'},
    {'\xf1','\x77'},{'\xf1','\x76'},{'\xc2','\xfc'},{'\xf1','\x78'},{'\xf3','\x7e'},
    {'\xc3','\xfa'},{'\xf3','\x7d'},{'\xf3','\x7a'},{'\xc3','\xf9'},{'\xf3','\x7b'},
    {'\xf3','\x7c'},{'\x8d','\x60'},{'\xf5','\x48'},{'\xf5','\x49'},{'\xc4','\xc5'},
    {'\xfd','\xc9'},{'\xc5','\x53'},{'\x97','\x7a'},{'\x9d','\xbb'},{'\xf6','\x6e'},
    {'\x9e','\xe5'},{'\x00','\x00'},{'\xc5','\x51'},{'\xc5','\x52'},{'\xf6','\x6f'},
    {'\x97','\x7b'},{'\x00','\x00'},{'\xc5','\xb4'},{'\xc5','\xb5'},{'\xf7','\x71'},
    {'\x9e','\xe6'},{'\x9e','\xe7'},{'\xc6','\x45'},{'\xf8','\xcf'},{'\xc6','\x47'},
    {'\x00','\x00'},{'\xf8','\xce'},{'\xf8','\xd0'},{'\xc6','\x46'},{'\xf9','\x57'},
    {'\x00','\x00'},{'\xf9','\xad'},{'\x00','\x00'},{'\x97','\x7c'},{'\x00','\x00'},
    {'\x97','\x7d'},{'\x00','\x00'},{'\x97','\x7e'},{'\xab','\x43'},{'\x8e','\xdb'},
    {'\x00','\x00'},{'\x97','\xa1'},{'\xb9','\x74'},{'\x9e','\xe8'},{'\xe4','\xbe'},
    {'\x93','\x43'},{'\xe8','\xb0'},{'\xc0','\x51'},{'\xc0','\x52'},{'\xfe','\x6d'},
    {'\xab','\x44'},{'\xfd','\xca'},{'\xbe','\x61'},{'\xc3','\xfb'},{'\xad','\xb1'},
    {'\x00','\x00'},{'\x97','\xa2'},{'\x8d','\x45'},{'\xc0','\x53'},{'\x00','\x00'},
    {'\xc5','\xe2'},{'\xad','\xb2'},{'\xd8','\x4d'},{'\x97','\xa3'},{'\xdc','\xa9'},
    {'\x95','\xf7'},{'\xdc','\xab'},{'\x00','\x00'},{'\xdc','\xaa'},{'\x97','\xa4'},
    {'\xe0','\xdd'},{'\xe0','\xda'},{'\xb9','\x75'},{'\x00','\x00'},{'\xb9','\x76'},
    {'\xe0','\xdb'},{'\xe0','\xdc'},{'\x94','\xdf'},{'\xe4','\xc0'},{'\xe4','\xc5'},
    {'\xbb','\xde'},{'\xe4','\xbf'},{'\xe4','\xc1'},{'\xe4','\xc8'},{'\xe4','\xc3'},
    {'\xe4','\xc7'},{'\xe4','\xc4'},{'\xe4','\xc2'},{'\xe4','\xc6'},{'\xbb','\xdf'},
    {'\x94','\xe0'},{'\x9e','\xe9'},{'\xe8','\xb3'},{'\x9e','\xea'},{'\xe8','\xb1'},
    {'\xbe','\x63'},{'\x00','\x00'},{'\xbe','\x62'},{'\xe8','\xb2'},{'\xbe','\x64'},
    {'\x94','\xe1'},{'\x8c','\xe7'},{'\x97','\xa5'},{'\x00','\x00'},{'\xec','\x56'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xec','\x55'},{'\xc0','\x54'},{'\xec','\x54'},
    {'\xee','\xfc'},{'\x9e','\xeb'},{'\xee','\xfe'},{'\xef','\x41'},{'\xef','\x40'},
    {'\xfd','\xcb'},{'\xc1','\xf9'},{'\xee','\xfd'},{'\xf1','\xa1'},{'\xc2','\xfd'},
    {'\xf1','\x7d'},{'\xf1','\xa2'},{'\xc2','\xfe'},{'\x00','\x00'},{'\xf1','\x7b'},
    {'\x00','\x00'},{'\xf1','\x7e'},{'\xf1','\x7c'},{'\xf1','\x79'},{'\xc3','\x40'},
    {'\xf1','\x7a'},{'\x8d','\x7e'},{'\x00','\x00'},{'\x9e','\xec'},{'\x97','\xa6'},
    {'\xf3','\xa1'},{'\xfd','\xcc'},{'\x00','\x00'},{'\xf3','\xa3'},{'\xf3','\xa2'},
    {'\xfd','\xcd'},{'\xf5','\x4a'},{'\xfd','\xce'},{'\xf5','\x4b'},{'\x00','\x00'},
    {'\x9e','\xed'},{'\xfd','\xcf'},{'\xf6','\x70'},{'\x9e','\xee'},{'\xc5','\xb7'},
    {'\x9e','\xef'},{'\xc5','\xb6'},{'\xf8','\x4f'},{'\xf8','\x50'},{'\xc6','\x48'},
    {'\xf8','\xd1'},{'\xfd','\xd0'},{'\xc6','\x69'},{'\x00','\x00'},{'\xad','\xb3'},
    {'\xb6','\xb4'},{'\xe4','\xca'},{'\xe4','\xc9'},{'\xe8','\xb5'},{'\xe8','\xb4'},
    {'\x00','\x00'},{'\x9e','\xf0'},{'\xc1','\xfa'},{'\xef','\x43'},{'\xef','\x42'},
    {'\xf1','\xa5'},{'\xf1','\xa3'},{'\xf1','\xa6'},{'\xf1','\xa4'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xc3','\xfc'},{'\xf3','\xa4'},{'\xf3','\xa5'},{'\xf3','\xa6'},
    {'\x9e','\xf1'},{'\xf6','\x71'},{'\x00','\x00'},{'\xf7','\x72'},{'\x00','\x00'},
    {'\xf8','\xd2'},{'\x83','\xa3'},{'\x85','\xa4'},{'\x00','\x00'},{'\x8a','\xb0'},
    {'\x8f','\xab'},{'\x8f','\xce'},{'\x8b','\xdb'},{'\xad','\xb4'},{'\x95','\x61'},
    {'\x00','\x00'},{'\xec','\x57'},{'\xef','\x44'},{'\x97','\xa7'},{'\xad','\xb5'},
    {'\x00','\x00'},{'\x8b','\xdc'},{'\xbb','\xe0'},{'\x00','\x00'},{'\xec','\x58'},
    {'\xc3','\x41'},{'\xf1','\xa7'},{'\xc3','\xfd'},{'\x00','\x00'},{'\xf5','\x4c'},
    {'\xf5','\x4d'},{'\xc5','\x54'},{'\xf8','\x51'},{'\xad','\xb6'},{'\xb3','\xbb'},
    {'\xb3','\xbc'},{'\xd8','\x4e'},{'\xb6','\xb5'},{'\xb6','\xb6'},{'\xdc','\xac'},
    {'\xb6','\xb7'},{'\x00','\x00'},{'\xb9','\x7a'},{'\x00','\x00'},{'\xb9','\x7c'},
    {'\xe0','\xdf'},{'\xe0','\xe0'},{'\xe0','\xde'},{'\xb9','\x77'},{'\xb9','\x78'},
    {'\xb9','\x7b'},{'\xb9','\x79'},{'\x9e','\xf2'},{'\x9e','\xf3'},{'\xe4','\xcb'},
    {'\xbb','\xe1'},{'\xbb','\xe2'},{'\x00','\x00'},{'\x82','\x5b'},{'\xe8','\xbc'},
    {'\xbe','\x67'},{'\xe8','\xb7'},{'\xe8','\xb6'},{'\xfd','\xd2'},{'\xe8','\xbb'},
    {'\xbe','\x65'},{'\x00','\x00'},{'\x9e','\xf4'},{'\xc0','\x5b'},{'\x00','\x00'},
    {'\xe8','\xb8'},{'\xe8','\xbd'},{'\xe8','\xba'},{'\xe8','\xb9'},{'\x00','\x00'},
    {'\xbe','\x66'},{'\x82','\x7b'},{'\xc0','\x59'},{'\xfd','\xd3'},{'\xec','\x5a'},
    {'\xc0','\x55'},{'\x00','\x00'},{'\xec','\x5b'},{'\x9e','\xf5'},{'\x82','\x42'},
    {'\xec','\x59'},{'\x00','\x00'},{'\xc0','\x58'},{'\xc0','\x56'},{'\xc0','\x5a'},
    {'\x00','\x00'},{'\xc0','\x57'},{'\x93','\xdf'},{'\x97','\xa8'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xef','\x45'},{'\x00','\x00'},{'\xef','\x4a'},
    {'\xef','\x46'},{'\xef','\x49'},{'\xc1','\xfb'},{'\xfd','\xd5'},{'\xed','\xd4'},
    {'\xef','\x48'},{'\xef','\x47'},{'\xfd','\xd6'},{'\xc3','\x44'},{'\xc3','\x42'},
    {'\xc3','\x45'},{'\xc3','\x43'},{'\xf1','\xa8'},{'\xf1','\xa9'},{'\xf1','\xaa'},
    {'\xc3','\x46'},{'\x97','\xa9'},{'\x92','\xb8'},{'\x9d','\xd2'},{'\xf3','\xaa'},
    {'\xc4','\x40'},{'\xf3','\xa8'},{'\x00','\x00'},{'\xc4','\x41'},{'\xf3','\xa7'},
    {'\xf3','\xa9'},{'\xc3','\xfe'},{'\xf5','\x51'},{'\xf5','\x4e'},{'\x00','\x00'},
    {'\xf5','\x4f'},{'\xf5','\x50'},{'\xf6','\x72'},{'\xc5','\x56'},{'\xfd','\xd7'},
    {'\xc5','\x55'},{'\x9e','\xf6'},{'\xf7','\x74'},{'\xf7','\x73'},{'\xc5','\xb8'},
    {'\xfd','\xd8'},{'\x00','\x00'},{'\x00','\x00'},{'\xc5','\xe3'},{'\xc6','\x49'},
    {'\xc6','\x60'},{'\xf9','\x58'},{'\xf9','\xae'},{'\xf9','\xaf'},{'\x83','\xa4'},
    {'\x84','\xbc'},{'\x84','\xbd'},{'\x8d','\xfa'},{'\x85','\xa5'},{'\x85','\xa6'},
    {'\x85','\xa7'},{'\x86','\x7e'},{'\x86','\x7c'},{'\x8c','\xb8'},{'\x86','\x7d'},
    {'\x8e','\x62'},{'\x86','\xa1'},{'\x86','\xa2'},{'\x8e','\x61'},{'\x86','\x7b'},
    {'\x8d','\x77'},{'\x87','\x74'},{'\x87','\x73'},{'\x89','\xb0'},{'\x88','\xb3'},
    {'\x89','\xaf'},{'\x00','\x00'},{'\x88','\xb4'},{'\x8e','\xba'},{'\x00','\x00'},
    {'\x8e','\xdc'},{'\x89','\xb5'},{'\x89','\xb1'},{'\x00','\x00'},{'\x89','\xb4'},
    {'\x89','\xb2'},{'\x00','\x00'},{'\x89','\x46'},{'\x8a','\xb1'},{'\x8b','\x5f'},
    {'\x00','\x00'},{'\x8b','\x60'},{'\x8b','\x61'},{'\x8b','\x5e'},{'\x8b','\x5d'},
    {'\x90','\xa7'},{'\x8f','\xf0'},{'\x8b','\xde'},{'\x8f','\xcf'},{'\x8c','\xb9'},
    {'\x00','\x00'},{'\x8c','\xe9'},{'\x97','\xaa'},{'\x8d','\x61'},{'\x90','\xa8'},
    {'\xad','\xb7'},{'\xdc','\xad'},{'\x94','\xe2'},{'\x00','\x00'},{'\xe0','\xe1'},
    {'\xe4','\xcc'},{'\xe4','\xcd'},{'\xbb','\xe3'},{'\x00','\x00'},{'\xbb','\xe4'},
    {'\xe8','\xbe'},{'\xbe','\x68'},{'\xfd','\xd9'},{'\x00','\x00'},{'\xc1','\xfc'},
    {'\x9e','\xf7'},{'\xf1','\xab'},{'\x9e','\xf8'},{'\xc3','\x47'},{'\xf3','\xad'},
    {'\xc4','\x42'},{'\xf3','\xac'},{'\xf3','\xae'},{'\xf3','\xab'},{'\xf6','\x75'},
    {'\xf5','\x52'},{'\xf5','\x53'},{'\x97','\xab'},{'\xc4','\xc6'},{'\x00','\x00'},
    {'\xf6','\x74'},{'\x9e','\xf9'},{'\xfb','\xb2'},{'\xf6','\x73'},{'\x9e','\xfa'},
    {'\xf7','\x75'},{'\xf9','\xb0'},{'\x00','\x00'},{'\x83','\xa5'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8e','\xae'},{'\x87','\x75'},{'\x8a','\xb2'},{'\x00','\x00'},
    {'\x8b','\xdf'},{'\x00','\x00'},{'\x00','\x00'},{'\x8c','\x61'},{'\x90','\x4a'},
    {'\x97','\xac'},{'\xad','\xb8'},{'\xfd','\xdb'},{'\x00','\x00'},{'\x83','\xa6'},
    {'\xad','\xb9'},{'\x9e','\xfb'},{'\x9e','\xfc'},{'\xb0','\xa7'},{'\xd4','\x48'},
    {'\x00','\x00'},{'\xd8','\x4f'},{'\xfd','\xdc'},{'\xb6','\xb8'},{'\x8c','\xba'},
    {'\xb6','\xbb'},{'\xb6','\xb9'},{'\xdc','\xae'},{'\x9e','\xfd'},{'\xb6','\xbd'},
    {'\x97','\xad'},{'\xb6','\xba'},{'\x00','\x00'},{'\x95','\xda'},{'\xb6','\xbc'},
    {'\x00','\x00'},{'\xb9','\x7e'},{'\x9e','\xfe'},{'\xe0','\xe2'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xe0','\xe3'},{'\xe8','\xc0'},{'\x00','\x00'},{'\xb9','\x7d'},
    {'\xb9','\xa1'},{'\xb9','\xa2'},{'\x00','\x00'},{'\xe4','\xcf'},{'\x00','\x00'},
    {'\xe4','\xce'},{'\xbb','\xe5'},{'\x00','\x00'},{'\xbb','\xe6'},{'\x00','\x00'},
    {'\xe4','\xd0'},{'\xe8','\xbf'},{'\xbb','\xe8'},{'\xbe','\x69'},{'\x00','\x00'},
    {'\xbb','\xe7'},{'\x8d','\x47'},{'\x9f','\x70'},{'\x00','\x00'},{'\xc0','\x5c'},
    {'\xe8','\xc1'},{'\xbe','\x6b'},{'\xbe','\x6a'},{'\xe8','\xc2'},{'\xe8','\xc5'},
    {'\xe8','\xc3'},{'\xe8','\xc4'},{'\xbe','\x6c'},{'\x9f','\x71'},{'\xc0','\x61'},
    {'\xc0','\x5f'},{'\x9f','\x72'},{'\x97','\xae'},{'\xc0','\x5e'},{'\xec','\x5d'},
    {'\x97','\xaf'},{'\xc0','\x60'},{'\x00','\x00'},{'\x00','\x00'},{'\xec','\x5c'},
    {'\xef','\x4b'},{'\x00','\x00'},{'\xec','\x5e'},{'\xc0','\x5d'},{'\xec','\x5f'},
    {'\xef','\x4e'},{'\xef','\x4c'},{'\xef','\x4d'},{'\xef','\x52'},{'\xc3','\x4b'},
    {'\xef','\x51'},{'\xef','\x54'},{'\xef','\x53'},{'\xef','\x50'},{'\xef','\x4f'},
    {'\x00','\x00'},{'\xc1','\xfd'},{'\x00','\x00'},{'\x9f','\x73'},{'\xa0','\x44'},
    {'\xfd','\xde'},{'\xf1','\xae'},{'\xfd','\xdf'},{'\xf1','\xad'},{'\xc3','\x4a'},
    {'\xc3','\x48'},{'\xc3','\x49'},{'\xfb','\xb3'},{'\xf1','\xac'},{'\xfd','\xdd'},
    {'\xf3','\xb1'},{'\x00','\x00'},{'\xc4','\x43'},{'\x00','\x00'},{'\xf3','\xb0'},
    {'\xf3','\xaf'},{'\xc4','\x44'},{'\xfd','\xe1'},{'\xf5','\x58'},{'\xf5','\x57'},
    {'\xfb','\xb4'},{'\xf5','\x55'},{'\x00','\x00'},{'\xf5','\x54'},{'\xc4','\xc8'},
    {'\xc4','\xc7'},{'\xf5','\x59'},{'\xf7','\x76'},{'\xc5','\xb9'},{'\xf6','\x77'},
    {'\xc5','\x57'},{'\xf6','\x76'},{'\xf5','\x56'},{'\x00','\x00'},{'\xf7','\x77'},
    {'\xc5','\xe4'},{'\x9f','\x74'},{'\xc6','\x61'},{'\xf9','\x59'},{'\x00','\x00'},
    {'\xf9','\xb1'},{'\x9f','\x75'},{'\x97','\xb0'},{'\x00','\x00'},{'\x83','\xe8'},
    {'\x00','\x00'},{'\x8f','\x6d'},{'\x85','\xaa'},{'\x8f','\xac'},{'\x85','\xa8'},
    {'\x8d','\xfb'},{'\x85','\xac'},{'\x85','\xa9'},{'\x85','\xab'},{'\x89','\xb7'},
    {'\x86','\xa6'},{'\x86','\xa5'},{'\x86','\xa3'},{'\x00','\x00'},{'\x86','\xa4'},
    {'\x87','\x78'},{'\x8c','\x62'},{'\x87','\x79'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x87','\x76'},{'\x00','\x00'},{'\x87','\x77'},{'\x8e','\xdd'},{'\x00','\x00'},
    {'\x88','\xb6'},{'\x97','\xb1'},{'\x88','\xb7'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x89','\xb8'},{'\x89','\xb9'},{'\x89','\xb6'},{'\x97','\xb2'},{'\x8b','\x64'},
    {'\x00','\x00'},{'\x8b','\x63'},{'\x8d','\x78'},{'\x00','\x00'},{'\x97','\xb3'},
    {'\x00','\x00'},{'\x8b','\x62'},{'\x8f','\xd0'},{'\x8b','\xe1'},{'\x8b','\xe0'},
    {'\x97','\xb4'},{'\x8f','\xf1'},{'\x97','\xb5'},{'\xad','\xba'},{'\xd8','\x50'},
    {'\xef','\x55'},{'\xad','\xbb'},{'\x00','\x00'},{'\x9f','\x76'},{'\xe4','\xd2'},
    {'\xe4','\xd1'},{'\xec','\x60'},{'\x00','\x00'},{'\x00','\x00'},{'\xef','\x57'},
    {'\x00','\x00'},{'\xef','\x56'},{'\x9f','\x77'},{'\xc3','\x4c'},{'\xf3','\xb2'},
    {'\xf3','\xb3'},{'\xc4','\xc9'},{'\x00','\x00'},{'\x9f','\x78'},{'\xf9','\xb2'},
    {'\xb0','\xa8'},{'\xb6','\xbf'},{'\xb6','\xbe'},{'\xe0','\xe4'},{'\xe0','\xe6'},
    {'\xb9','\xa4'},{'\xe0','\xe5'},{'\xb9','\xa3'},{'\xb9','\xa5'},{'\xe0','\xe7'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x9f','\x79'},{'\xe4','\xd4'},{'\xe4','\xd6'},
    {'\xe4','\xd5'},{'\x97','\xb6'},{'\xe4','\xd8'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xbb','\xe9'},{'\xe4','\xd7'},{'\xe4','\xd3'},{'\x94','\x4b'},
    {'\x92','\x4a'},{'\x92','\xa3'},{'\xe4','\xd9'},{'\x97','\xb7'},{'\xe8','\xcc'},
    {'\x00','\x00'},{'\xe8','\xcf'},{'\xe8','\xd1'},{'\xe8','\xc7'},{'\xe8','\xcb'},
    {'\xe8','\xc8'},{'\xbe','\x6e'},{'\xbe','\x71'},{'\xbe','\x73'},{'\xe8','\xc9'},
    {'\xe8','\xca'},{'\xbe','\x72'},{'\xe8','\xcd'},{'\xe8','\xd0'},{'\xe8','\xce'},
    {'\xbe','\x74'},{'\xfd','\xe4'},{'\xbe','\x70'},{'\xe8','\xc6'},{'\xbe','\x6d'},
    {'\x00','\x00'},{'\xbe','\x6f'},{'\x9f','\x7a'},{'\x95','\xc4'},{'\xc0','\x63'},
    {'\xec','\x66'},{'\xec','\x64'},{'\xec','\x63'},{'\x9f','\x7b'},{'\xec','\x69'},
    {'\x00','\x00'},{'\xec','\x68'},{'\xec','\x67'},{'\x00','\x00'},{'\xec','\x62'},
    {'\xc0','\x62'},{'\xec','\x61'},{'\x00','\x00'},{'\xec','\x65'},{'\xc0','\x64'},
    {'\x97','\xb8'},{'\x00','\x00'},{'\xef','\x5a'},{'\x9f','\x7c'},{'\xef','\x5e'},
    {'\xef','\x5b'},{'\xef','\x5d'},{'\xef','\x5c'},{'\xef','\x59'},{'\xef','\x5f'},
    {'\xef','\x62'},{'\xef','\x60'},{'\xef','\x61'},{'\xc2','\x40'},{'\x00','\x00'},
    {'\xc1','\xfe'},{'\xef','\x58'},{'\xef','\x63'},{'\xf1','\xb3'},{'\xf1','\xb6'},
    {'\xf1','\xb8'},{'\xf1','\xb7'},{'\x00','\x00'},{'\xf1','\xb1'},{'\xf1','\xb5'},
    {'\xf1','\xb0'},{'\xfb','\xb5'},{'\xf1','\xb2'},{'\xc3','\x4d'},{'\xf1','\xaf'},
    {'\x95','\xe1'},{'\xf1','\xb4'},{'\x93','\x5d'},{'\x92','\xb9'},{'\xf3','\xc0'},
    {'\xf3','\xb5'},{'\xc4','\x45'},{'\x00','\x00'},{'\x00','\x00'},{'\xc4','\x46'},
    {'\xf3','\xb4'},{'\xf3','\xb9'},{'\xf3','\xbf'},{'\xf3','\xb7'},{'\xf3','\xbe'},
    {'\x9f','\x7d'},{'\xf3','\xbb'},{'\x9a','\xfb'},{'\xf3','\xba'},{'\xf3','\xbd'},
    {'\xf3','\xb8'},{'\xf3','\xb6'},{'\x9a','\xfc'},{'\xf3','\xbc'},{'\x82','\x55'},
    {'\xf5','\x60'},{'\xf5','\x5e'},{'\xc4','\xca'},{'\xf5','\x5d'},{'\xf5','\x63'},
    {'\xf5','\x61'},{'\x9a','\xfd'},{'\xc4','\xcb'},{'\xf5','\x5c'},{'\xf5','\x5a'},
    {'\x00','\x00'},{'\xf5','\x5b'},{'\xc4','\xcd'},{'\xf5','\x5f'},{'\xc4','\xcc'},
    {'\xf5','\x62'},{'\xf6','\x78'},{'\xf6','\x7e'},{'\x9c','\xfa'},{'\x9c','\xfb'},
    {'\xf6','\x79'},{'\xc5','\x5b'},{'\xf6','\xa1'},{'\xc5','\x5a'},{'\xf6','\x7d'},
    {'\xf6','\x7c'},{'\xc5','\x59'},{'\xf6','\x7b'},{'\xc5','\x58'},{'\xf6','\x7a'},
    {'\x00','\x00'},{'\xf7','\x7d'},{'\xf7','\xa1'},{'\xf7','\x7e'},{'\x00','\x00'},
    {'\xf7','\x7b'},{'\xc5','\xbb'},{'\xf7','\x78'},{'\xf7','\x7c'},{'\xf7','\xa3'},
    {'\x00','\x00'},{'\xf7','\xa2'},{'\xf7','\x79'},{'\xf7','\x7a'},{'\xc5','\xba'},
    {'\xf8','\x52'},{'\xc5','\xe7'},{'\x9c','\xfc'},{'\xf8','\x53'},{'\xc5','\xe5'},
    {'\xc5','\xe6'},{'\x9c','\xfd'},{'\x00','\x00'},{'\xf8','\xd3'},{'\xc6','\x4a'},
    {'\xf9','\x76'},{'\x00','\x00'},{'\xc6','\x6a'},{'\x9c','\xfe'},{'\xf9','\xb3'},
    {'\xc6','\x6b'},{'\xf9','\xb4'},{'\xf9','\xb5'},{'\xf9','\xc3'},{'\xf9','\xc2'},
    {'\xc6','\x7a'},{'\xf9','\xcd'},{'\x83','\xe9'},{'\x85','\xae'},{'\x86','\xa8'},
    {'\x86','\xa9'},{'\x86','\xa7'},{'\x8c','\xbb'},{'\x00','\x00'},{'\x87','\x7a'},
    {'\x8d','\xa1'},{'\x8e','\xde'},{'\x88','\xbb'},{'\x88','\xba'},{'\x88','\xbf'},
    {'\x88','\xbe'},{'\x8f','\xf2'},{'\x88','\xb9'},{'\x88','\xb8'},{'\x88','\xbc'},
    {'\x88','\xbd'},{'\x8d','\x49'},{'\x8e','\xdf'},{'\x8c','\xeb'},{'\x88','\x4c'},
    {'\x00','\x00'},{'\x8c','\xea'},{'\x90','\x63'},{'\x89','\xbc'},{'\x89','\xba'},
    {'\x89','\xbb'},{'\x00','\x00'},{'\x8d','\xaf'},{'\x8a','\xb3'},{'\x8d','\x4a'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x8a','\xb4'},{'\x8f','\xad'},{'\x8b','\x65'},
    {'\x8f','\xae'},{'\x8f','\xaf'},{'\x00','\x00'},{'\x00','\x00'},{'\x90','\x4c'},
    {'\x8b','\xe3'},{'\x8f','\xf5'},{'\x00','\x00'},{'\x8c','\x66'},{'\x8b','\xe2'},
    {'\x90','\x4d'},{'\x8f','\xf3'},{'\x8c','\x64'},{'\x8f','\xf4'},{'\x8c','\xbc'},
    {'\x8c','\xbe'},{'\x90','\x4b'},{'\x90','\x62'},{'\x8d','\x62'},{'\x8d','\xa2'},
    {'\x00','\x00'},{'\x90','\xa9'},{'\xb0','\xa9'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe0','\xe9'},{'\x00','\x00'},{'\xe0','\xe8'},{'\x00','\x00'},{'\xbb','\xea'},
    {'\xbb','\xeb'},{'\xe4','\xda'},{'\x9d','\xb0'},{'\xe8','\xd2'},{'\xec','\x6c'},
    {'\x00','\x00'},{'\x97','\xb9'},{'\xbe','\x75'},{'\xc0','\x65'},{'\xec','\x6a'},
    {'\xfd','\xe6'},{'\xec','\x6d'},{'\xc0','\x66'},{'\xfd','\xe7'},{'\xef','\x64'},
    {'\xec','\x6b'},{'\xf1','\xb9'},{'\xc3','\x4e'},{'\xf3','\xc1'},{'\x00','\x00'},
    {'\x92','\xfb'},{'\x8c','\xbf'},{'\xf5','\x66'},{'\xf5','\x64'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xf5','\x65'},{'\x8d','\x79'},{'\x90','\x79'},{'\xf6','\xa2'},
    {'\x00','\x00'},{'\xc5','\x5c'},{'\xf7','\xa4'},{'\xc5','\xea'},{'\xc5','\xbc'},
    {'\xc5','\xe8'},{'\xc5','\xe9'},{'\xf8','\xd4'},{'\xc6','\x62'},{'\xfb','\xb6'},
    {'\xb0','\xaa'},{'\x97','\xba'},{'\x00','\x00'},{'\x00','\x00'},{'\xf1','\xba'},
    {'\x00','\x00'},{'\x97','\xbb'},{'\xd4','\x49'},{'\x9d','\xb1'},{'\xb9','\xa6'},
    {'\xfd','\xec'},{'\xe4','\xdb'},{'\x00','\x00'},{'\x00','\x00'},{'\xbb','\xec'},
    {'\xe4','\xdc'},{'\x00','\x00'},{'\x00','\x00'},{'\x93','\xba'},{'\xe8','\xd4'},
    {'\xe8','\xd3'},{'\xc0','\x68'},{'\xbe','\x76'},{'\xbe','\x77'},{'\x00','\x00'},
    {'\xe8','\xd7'},{'\xe8','\xd6'},{'\xe8','\xd5'},{'\xfe','\x57'},{'\x00','\x00'},
    {'\xec','\x6e'},{'\xec','\x71'},{'\x00','\x00'},{'\xec','\x70'},{'\xec','\x6f'},
    {'\xc0','\x67'},{'\xef','\x68'},{'\xef','\x66'},{'\xef','\x65'},{'\xfd','\xee'},
    {'\x00','\x00'},{'\xef','\x67'},{'\xfd','\xed'},{'\xc3','\x4f'},{'\xf1','\xbc'},
    {'\xf1','\xbd'},{'\xc3','\x50'},{'\x00','\x00'},{'\xf1','\xbb'},{'\xfd','\xf0'},
    {'\xf3','\xc3'},{'\xf3','\xc2'},{'\xf3','\xc5'},{'\xc4','\x47'},{'\xf3','\xc4'},
    {'\x97','\xbc'},{'\xf5','\x67'},{'\xf5','\x69'},{'\xf5','\x68'},{'\x8d','\x63'},
    {'\x9d','\xb2'},{'\xf6','\xa3'},{'\xf6','\xa6'},{'\xf6','\xa4'},{'\xf6','\xa5'},
    {'\xf7','\xa5'},{'\xc5','\xbd'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf8','\x54'},{'\xf8','\x55'},{'\xf8','\x56'},{'\x00','\x00'},{'\xc6','\x4b'},
    {'\xc6','\x63'},{'\xf9','\xb6'},{'\xb0','\xab'},{'\x00','\x00'},{'\xbe','\x78'},
    {'\xc0','\x69'},{'\xf1','\xbe'},{'\xfd','\xe9'},{'\xf7','\xa6'},{'\x00','\x00'},
    {'\xfd','\xeb'},{'\xf9','\xc4'},{'\xd4','\x4a'},{'\x00','\x00'},{'\xc6','\x7b'},
    {'\xb0','\xac'},{'\xec','\x72'},{'\x9d','\xb3'},{'\xf1','\xbf'},{'\x00','\x00'},
    {'\xf3','\xc6'},{'\x00','\x00'},{'\x9d','\xb4'},{'\xf6','\xa7'},{'\xf7','\xa7'},
    {'\xb0','\xad'},{'\x00','\x00'},{'\xe4','\xdd'},{'\xe4','\xde'},{'\x9d','\xb5'},
    {'\xbb','\xed'},{'\xbb','\xee'},{'\xe8','\xd9'},{'\xbe','\x7a'},{'\xbe','\x79'},
    {'\xe8','\xd8'},{'\x8d','\x64'},{'\xef','\x69'},{'\x97','\xbd'},{'\xf1','\xc0'},
    {'\xf1','\xc2'},{'\xf1','\xc1'},{'\xc3','\x53'},{'\xc3','\x52'},{'\xc3','\x51'},
    {'\x9d','\xb6'},{'\xc5','\x5e'},{'\xf6','\xa8'},{'\x00','\x00'},{'\xc5','\x5d'},
    {'\xf7','\xa9'},{'\xf7','\xa8'},{'\x00','\x00'},{'\xc6','\x4c'},{'\xf8','\xd5'},
    {'\xb3','\xbd'},{'\xe0','\xea'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe4','\xe1'},{'\xe4','\xdf'},{'\xe4','\xe0'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xe8','\xe2'},{'\x00','\x00'},{'\xe8','\xdd'},{'\xe8','\xda'},{'\xe8','\xe1'},
    {'\xfe','\xaf'},{'\x00','\x00'},{'\x00','\x00'},{'\xe8','\xe3'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xbe','\x7c'},{'\xe8','\xe0'},{'\xe8','\xdc'},{'\x97','\xbe'},
    {'\x00','\x00'},{'\xe8','\xdb'},{'\xe8','\xdf'},{'\xe8','\xde'},{'\xbe','\x7b'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xec','\x7d'},{'\xec','\x78'},{'\xec','\x76'},
    {'\xec','\xa1'},{'\xec','\x77'},{'\x9d','\xb7'},{'\xec','\x73'},{'\x9d','\xee'},
    {'\xec','\x79'},{'\x97','\xbf'},{'\x00','\x00'},{'\xec','\x74'},{'\xef','\x72'},
    {'\xec','\x75'},{'\xec','\xa2'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xef'},
    {'\x00','\x00'},{'\x9d','\xf0'},{'\x94','\xfe'},{'\xfd','\xf3'},{'\xec','\x7c'},
    {'\xc0','\x6a'},{'\xec','\x7b'},{'\xec','\x7a'},{'\x00','\x00'},{'\xec','\x7e'},
    {'\x94','\xe3'},{'\x94','\xe4'},{'\x00','\x00'},{'\x00','\x00'},{'\xef','\x6a'},
    {'\xef','\x6d'},{'\x00','\x00'},{'\xfd','\xf4'},{'\xef','\x6c'},{'\x97','\xc0'},
    {'\xef','\x74'},{'\xef','\x6f'},{'\xef','\x73'},{'\x00','\x00'},{'\xef','\x71'},
    {'\xef','\x70'},{'\xef','\x6e'},{'\x00','\x00'},{'\xef','\x6b'},{'\x00','\x00'},
    {'\xc2','\x43'},{'\xc2','\x42'},{'\x00','\x00'},{'\xc2','\x44'},{'\xc2','\x41'},
    {'\xef','\x75'},{'\xfd','\xf5'},{'\x94','\xf5'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x94','\xe5'},{'\xf1','\xc8'},{'\xf1','\xcb'},{'\x00','\x00'},{'\xf1','\xc9'},
    {'\xf1','\xcd'},{'\x00','\x00'},{'\x97','\xc1'},{'\x00','\x00'},{'\xf1','\xce'},
    {'\x00','\x00'},{'\xf1','\xc6'},{'\xc3','\x58'},{'\xf1','\xc7'},{'\x00','\x00'},
    {'\xf1','\xc5'},{'\xf1','\xcc'},{'\x00','\x00'},{'\xf1','\xc4'},{'\xf1','\xc3'},
    {'\xc3','\x57'},{'\xc3','\x55'},{'\xc3','\x54'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x94','\xe6'},{'\x00','\x00'},{'\x94','\xe7'},
    {'\x94','\xe8'},{'\xf1','\xca'},{'\xf3','\xcf'},{'\xf3','\xd5'},{'\xc4','\x4a'},
    {'\xf3','\xd0'},{'\x00','\x00'},{'\xf3','\xd3'},{'\xf3','\xd7'},{'\xc4','\x4b'},
    {'\xf3','\xd2'},{'\x9d','\xf1'},{'\xf3','\xca'},{'\x00','\x00'},{'\xf3','\xc9'},
    {'\xf3','\xd6'},{'\xf3','\xcd'},{'\x97','\xc2'},{'\xf3','\xcb'},{'\xf3','\xd4'},
    {'\xf3','\xcc'},{'\xc4','\x49'},{'\xc4','\x48'},{'\x9d','\xf2'},{'\xf3','\xc7'},
    {'\xf3','\xc8'},{'\xf3','\xd1'},{'\x9d','\xf3'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf3','\xce'},{'\x94','\xea'},{'\x94','\xe9'},{'\x00','\x00'},{'\x9d','\xf4'},
    {'\x97','\xc3'},{'\x00','\x00'},{'\xf5','\x6c'},{'\xf5','\x6f'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\xc3','\x56'},{'\x00','\x00'},
    {'\xfd','\xf9'},{'\x97','\xc4'},{'\x00','\x00'},{'\xfe','\x50'},{'\x00','\x00'},
    {'\x97','\xc5'},{'\xf5','\x6d'},{'\xf5','\x73'},{'\xf5','\x71'},{'\xf5','\x6b'},
    {'\xf5','\x76'},{'\xfd','\xf8'},{'\xf5','\x6a'},{'\xfd','\xf6'},{'\xc4','\xcf'},
    {'\xf5','\x72'},{'\x00','\x00'},{'\x95','\xfd'},{'\x00','\x00'},{'\xf5','\x6e'},
    {'\xc4','\xce'},{'\xf5','\x75'},{'\xfd','\xf7'},{'\x00','\x00'},{'\xf5','\x74'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x97','\xc6'},{'\xf6','\xab'},
    {'\xf6','\xaa'},{'\x00','\x00'},{'\x9d','\xf5'},{'\x9d','\xf6'},{'\xf6','\xb1'},
    {'\x00','\x00'},{'\xf6','\xad'},{'\xf6','\xb0'},{'\xc5','\x60'},{'\x9d','\xf7'},
    {'\x00','\x00'},{'\xf6','\xae'},{'\xf6','\xaf'},{'\x00','\x00'},{'\xf6','\xa9'},
    {'\xf6','\xac'},{'\xc5','\x5f'},{'\xfd','\xfa'},{'\x94','\xf9'},{'\x94','\xeb'},
    {'\xc5','\xbf'},{'\xf7','\xb4'},{'\xf7','\xaf'},{'\xf7','\xb3'},{'\xfd','\x53'},
    {'\xf7','\xb6'},{'\xf7','\xb2'},{'\x00','\x00'},{'\xf7','\xae'},{'\xfc','\xcb'},
    {'\xc5','\xc1'},{'\xf7','\xb1'},{'\xf7','\xb5'},{'\xc5','\xc0'},{'\xf7','\xac'},
    {'\xf5','\x70'},{'\xf7','\xb0'},{'\x00','\x00'},{'\x00','\x00'},{'\xf7','\xad'},
    {'\xfd','\x70'},{'\xf7','\xaa'},{'\x94','\xec'},{'\xf7','\xab'},{'\xc5','\xbe'},
    {'\xf8','\x5a'},{'\xf8','\x5c'},{'\xf8','\x5f'},{'\xf8','\x5b'},{'\xf8','\x60'},
    {'\x9f','\x50'},{'\xf8','\x59'},{'\x00','\x00'},{'\xf8','\x57'},{'\x9d','\xf8'},
    {'\xc5','\xeb'},{'\xf8','\x5d'},{'\xc5','\xed'},{'\xc5','\xec'},{'\xf8','\x58'},
    {'\xf8','\x5e'},{'\x94','\xed'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xf9'},
    {'\xf8','\xda'},{'\xc6','\x4d'},{'\xf8','\xdb'},{'\x00','\x00'},{'\xf8','\xd9'},
    {'\xf8','\xd6'},{'\x00','\x00'},{'\x00','\x00'},{'\xf8','\xd8'},{'\xf8','\xd7'},
    {'\xf9','\x5a'},{'\x94','\xf6'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf9','\x5c'},{'\xf9','\x5b'},{'\x00','\x00'},{'\x00','\x00'},{'\xf9','\x79'},
    {'\xfb','\x78'},{'\xf9','\x78'},{'\xf9','\x77'},{'\xf9','\x7a'},{'\x98','\x40'},
    {'\xc6','\x73'},{'\xc6','\x74'},{'\xf9','\xca'},{'\xf9','\xce'},{'\x9d','\xfa'},
    {'\x84','\xbe'},{'\x00','\x00'},{'\x00','\x00'},{'\x88','\xc2'},{'\x00','\x00'},
    {'\x88','\xc3'},{'\x8e','\xe0'},{'\x00','\x00'},{'\x00','\x00'},{'\x98','\x4b'},
    {'\x98','\x4c'},{'\x98','\x4d'},{'\x8d','\xab'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x98','\x4e'},{'\x00','\x00'},{'\x89','\xbf'},{'\x8d','\x65'},{'\x00','\x00'},
    {'\x98','\x4f'},{'\x8a','\xb8'},{'\x8f','\x6e'},{'\x00','\x00'},{'\x8a','\xb7'},
    {'\x8f','\x6f'},{'\x00','\x00'},{'\x90','\xf2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x90','\xa2'},{'\x8a','\xb6'},{'\x8a','\xb5'},{'\x00','\x00'},{'\x98','\x50'},
    {'\x90','\x70'},{'\x8f','\xb2'},{'\x90','\xad'},{'\x8c','\xed'},{'\x90','\x65'},
    {'\x8b','\x68'},{'\x90','\x4e'},{'\x90','\x66'},{'\x8b','\x6a'},{'\x8b','\x67'},
    {'\x8f','\xb1'},{'\x00','\x00'},{'\x8b','\x69'},{'\x00','\x00'},{'\x8b','\xe6'},
    {'\x98','\x51'},{'\x00','\x00'},{'\x98','\x52'},{'\x8f','\xd5'},{'\x98','\x53'},
    {'\x8b','\xe5'},{'\x98','\x54'},{'\x8f','\xd2'},{'\x8f','\xd3'},{'\x8b','\xe7'},
    {'\x8b','\xe4'},{'\x00','\x00'},{'\x98','\x55'},{'\x8f','\xd4'},{'\x98','\x56'},
    {'\x98','\x57'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8c','\x67'},{'\x8d','\xaa'},{'\x8c','\x68'},{'\x98','\x58'},
    {'\x98','\x59'},{'\x00','\x00'},{'\x00','\x00'},{'\x98','\x5a'},{'\x98','\x5b'},
    {'\x8d','\x6a'},{'\x8c','\xc0'},{'\x90','\x4f'},{'\x8c','\xc1'},{'\x90','\x50'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x98','\x5c'},{'\x8c','\xee'},{'\x90','\x64'},
    {'\x8c','\xec'},{'\x8c','\xef'},{'\x98','\x5d'},{'\x98','\x5e'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x8d','\x4f'},{'\x8d','\x4d'},{'\x8d','\x4e'},{'\x90','\x6f'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x98','\x5f'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xb3','\xbe'},{'\xdc','\xaf'},{'\xe0','\xed'},{'\x00','\x00'},{'\xb9','\xa7'},
    {'\xe0','\xeb'},{'\x98','\x60'},{'\x98','\x61'},{'\xe0','\xec'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x94','\xee'},{'\xe4','\xe2'},{'\xe4','\xe3'},{'\xbb','\xf1'},
    {'\xbb','\xef'},{'\xe4','\xe4'},{'\xbb','\xf0'},{'\xe8','\xe8'},{'\x00','\x00'},
    {'\xe8','\xeb'},{'\xe8','\xe5'},{'\xe8','\xec'},{'\xe8','\xe4'},{'\xe8','\xe6'},
    {'\x00','\x00'},{'\xe8','\xe7'},{'\xe8','\xea'},{'\x00','\x00'},{'\xfd','\x61'},
    {'\xbe','\xa1'},{'\xe8','\xef'},{'\xe8','\xee'},{'\xbe','\x7d'},{'\xe8','\xe9'},
    {'\xe8','\xed'},{'\xbe','\x7e'},{'\x00','\x00'},{'\x00','\x00'},{'\x9d','\xfb'},
    {'\x00','\x00'},{'\x82','\x48'},{'\x00','\x00'},{'\xec','\xac'},{'\x00','\x00'},
    {'\xc0','\x6f'},{'\x00','\x00'},{'\xec','\xa7'},{'\xc0','\x6b'},{'\x9d','\xfc'},
    {'\xec','\xa4'},{'\xec','\xaa'},{'\xec','\xad'},{'\x00','\x00'},{'\xc0','\x70'},
    {'\x00','\x00'},{'\xec','\xa9'},{'\xec','\xa6'},{'\xec','\xae'},{'\xec','\xa5'},
    {'\x9f','\x40'},{'\xec','\xab'},{'\xc0','\x6c'},{'\x00','\x00'},{'\xec','\xa3'},
    {'\xc0','\x6d'},{'\x00','\x00'},{'\xc0','\x6e'},{'\xec','\xa8'},{'\x98','\x62'},
    {'\x94','\x47'},{'\x82','\x47'},{'\xef','\xa9'},{'\xef','\x7a'},{'\xef','\x7b'},
    {'\xef','\x7e'},{'\xef','\x7c'},{'\x00','\x00'},{'\xef','\x76'},{'\x9f','\x41'},
    {'\x00','\x00'},{'\xef','\x79'},{'\xef','\xa5'},{'\xef','\x7d'},{'\x9f','\x42'},
    {'\x00','\x00'},{'\xc2','\x45'},{'\x00','\x00'},{'\xef','\xa7'},{'\xef','\xa4'},
    {'\xc2','\x46'},{'\xef','\xa6'},{'\xef','\x77'},{'\xef','\xa2'},{'\xef','\xa3'},
    {'\xfd','\xaa'},{'\xef','\xa1'},{'\x94','\xef'},{'\x94','\xf7'},{'\x98','\x63'},
    {'\x9f','\x43'},{'\xf1','\xd2'},{'\xf1','\xd4'},{'\xf1','\xd7'},{'\x00','\x00'},
    {'\x9f','\x44'},{'\xf1','\xd1'},{'\x98','\x64'},{'\xc3','\x59'},{'\xf1','\xd9'},
    {'\xf1','\xd0'},{'\xf1','\xda'},{'\x00','\x00'},{'\xf1','\xd6'},{'\xf1','\xd8'},
    {'\xf1','\xdc'},{'\xf1','\xd5'},{'\xf1','\xdd'},{'\xf1','\xd3'},{'\xf1','\xcf'},
    {'\xc3','\x5a'},{'\x95','\x72'},{'\xf1','\xdb'},{'\xc3','\x5b'},{'\xc4','\x4d'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x94','\xf0'},{'\x94','\xf8'},{'\x00','\x00'},
    {'\xef','\x78'},{'\xf3','\xf1'},{'\xf3','\xe8'},{'\xc4','\x4f'},{'\xf3','\xe4'},
    {'\xc4','\x50'},{'\x9f','\x45'},{'\x9f','\x47'},{'\xf3','\xed'},{'\xf3','\xe7'},
    {'\xf3','\xdd'},{'\xc4','\x4e'},{'\xf3','\xea'},{'\xf3','\xe5'},{'\xf3','\xe6'},
    {'\x00','\x00'},{'\xf3','\xd8'},{'\xf3','\xdf'},{'\xf3','\xee'},{'\x98','\x65'},
    {'\xf3','\xeb'},{'\x9f','\x48'},{'\xf3','\xe3'},{'\xfc','\xc6'},{'\xf3','\xef'},
    {'\xf3','\xde'},{'\xf3','\xd9'},{'\xf3','\xec'},{'\x9f','\x49'},{'\xf3','\xdb'},
    {'\xf3','\xe9'},{'\xf3','\xe0'},{'\xf3','\xf0'},{'\xf3','\xdc'},{'\xc4','\x4c'},
    {'\xf3','\xda'},{'\xf3','\xe1'},{'\xf3','\xe2'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x92','\xaf'},{'\xf5','\x7d'},{'\x00','\x00'},{'\xf5','\x7b'},{'\x9f','\x4a'},
    {'\xf5','\xa2'},{'\x00','\x00'},{'\xf5','\xae'},{'\xf5','\xa5'},{'\xf5','\x7c'},
    {'\xf5','\x78'},{'\xf5','\xa7'},{'\xf5','\x7e'},{'\xf5','\xa3'},{'\xf5','\x7a'},
    {'\xf5','\xaa'},{'\xf5','\x77'},{'\xf5','\xa1'},{'\xf5','\xa6'},{'\xf5','\xa8'},
    {'\xf5','\xab'},{'\xf5','\x79'},{'\x9f','\x4b'},{'\xf5','\xaf'},{'\xf5','\xb0'},
    {'\xf5','\xa9'},{'\xf5','\xad'},{'\xf5','\xa4'},{'\x94','\xf1'},{'\xf6','\xc1'},
    {'\xf6','\xc4'},{'\x00','\x00'},{'\xc5','\x61'},{'\x00','\x00'},{'\xf6','\xc3'},
    {'\xf6','\xc8'},{'\xf6','\xc6'},{'\xc5','\x62'},{'\xf6','\xbd'},{'\xf6','\xb3'},
    {'\xf6','\xb2'},{'\xc5','\x64'},{'\xf6','\xbf'},{'\xf6','\xc0'},{'\xf6','\xbc'},
    {'\xf6','\xb4'},{'\x9f','\x4d'},{'\xf6','\xb9'},{'\xf5','\xac'},{'\x9f','\x52'},
    {'\xf6','\xb5'},{'\xc5','\x63'},{'\xf6','\xbb'},{'\x95','\x75'},{'\xf6','\xba'},
    {'\x98','\x66'},{'\xf6','\xb6'},{'\xf6','\xc2'},{'\x9f','\x5e'},{'\xf6','\xb7'},
    {'\xf7','\xbb'},{'\xf6','\xc5'},{'\xf6','\xc7'},{'\xf6','\xbe'},{'\xf6','\xb8'},
    {'\xf7','\xbc'},{'\xf7','\xbe'},{'\xf7','\xb8'},{'\xc5','\xc2'},{'\x9f','\x5f'},
    {'\xf7','\xc5'},{'\xf7','\xc3'},{'\xc5','\xc3'},{'\xf7','\xc2'},{'\xf7','\xc1'},
    {'\xf7','\xba'},{'\xf7','\xb7'},{'\xf7','\xbd'},{'\xf7','\xc6'},{'\xf7','\xb9'},
    {'\xf7','\xbf'},{'\x00','\x00'},{'\xf8','\x69'},{'\xf8','\x6e'},{'\xf8','\x64'},
    {'\xf8','\x67'},{'\xc5','\xee'},{'\xf8','\x6b'},{'\x00','\x00'},{'\xf8','\x72'},
    {'\xf7','\xc0'},{'\x00','\x00'},{'\xf8','\x65'},{'\xf8','\x6f'},{'\xf8','\x73'},
    {'\xf8','\x6a'},{'\xf8','\x63'},{'\xf8','\x6d'},{'\x00','\x00'},{'\xf8','\x6c'},
    {'\xf8','\x71'},{'\xf8','\x70'},{'\xf7','\xc4'},{'\xf8','\x68'},{'\xf8','\x62'},
    {'\xf8','\x66'},{'\xc6','\x4e'},{'\xc6','\x4f'},{'\xf8','\x61'},{'\x9f','\x60'},
    {'\xf8','\xe6'},{'\xf8','\xdd'},{'\xf8','\xe5'},{'\xf8','\xe2'},{'\xf8','\xe3'},
    {'\xf8','\xdc'},{'\xf8','\xdf'},{'\xf8','\xe7'},{'\xf8','\xe1'},{'\xf8','\xe0'},
    {'\xf8','\xde'},{'\x00','\x00'},{'\xf8','\xe4'},{'\x9f','\x61'},{'\xf9','\x5d'},
    {'\x9f','\x62'},{'\xf9','\x5e'},{'\x9f','\x63'},{'\xf9','\x60'},{'\xf9','\x5f'},
    {'\xf9','\x62'},{'\xf9','\x61'},{'\xf9','\x7c'},{'\xf9','\x7b'},{'\xf9','\xb7'},
    {'\x00','\x00'},{'\xf9','\xb8'},{'\x9f','\x64'},{'\xf9','\xc5'},{'\xc6','\x78'},
    {'\xc6','\x7c'},{'\xfd','\x4a'},{'\xf9','\xcf'},{'\xc6','\x7d'},{'\x84','\xbf'},
    {'\x86','\xaa'},{'\x8b','\x5c'},{'\x87','\x7e'},{'\x87','\x7d'},{'\x00','\x00'},
    {'\x8c','\xf1'},{'\x88','\xc5'},{'\x00','\x00'},{'\x8e','\xe1'},{'\x88','\xc4'},
    {'\x89','\xc1'},{'\x8f','\xd7'},{'\x90','\xaa'},{'\x89','\xc3'},{'\x00','\x00'},
    {'\x89','\xc2'},{'\x00','\x00'},{'\x8f','\x4e'},{'\x8f','\x4d'},{'\x89','\xc4'},
    {'\x00','\x00'},{'\x89','\xc0'},{'\x8d','\x50'},{'\x90','\x68'},{'\x8f','\x70'},
    {'\x8f','\x71'},{'\x8f','\x72'},{'\x00','\x00'},{'\x00','\x00'},{'\x8a','\xba'},
    {'\x8d','\xb1'},{'\x8a','\xb9'},{'\x00','\x00'},{'\x8f','\xb4'},{'\x90','\xae'},
    {'\x8b','\x6b'},{'\x8b','\x6d'},{'\x8b','\x6c'},{'\x8f','\xb5'},{'\x90','\x75'},
    {'\x8f','\xb3'},{'\x8b','\xe9'},{'\x8b','\xea'},{'\x98','\x67'},{'\x8b','\xeb'},
    {'\x00','\x00'},{'\x8f','\xd6'},{'\x8b','\xec'},{'\x00','\x00'},{'\x8b','\xe8'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x98','\x68'},{'\x00','\x00'},
    {'\x8f','\xf6'},{'\x90','\x52'},{'\x00','\x00'},{'\x8f','\xf7'},{'\x98','\x69'},
    {'\x8f','\xf8'},{'\x00','\x00'},{'\x8c','\xc4'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x90','\x51'},{'\x8c','\xc3'},{'\x00','\x00'},
    {'\x8d','\xae'},{'\x8c','\xf0'},{'\x90','\x67'},{'\x90','\x71'},{'\x90','\x73'},
    {'\x90','\x74'},{'\x90','\x72'},{'\x8d','\x67'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x8d','\x66'},{'\x98','\x6a'},{'\x00','\x00'},{'\x8d','\xb0'},{'\x00','\x00'},
    {'\xb3','\xbf'},{'\x00','\x00'},{'\x00','\x00'},{'\x82','\x5e'},{'\xc4','\xd0'},
    {'\xf6','\xc9'},{'\x9f','\x65'},{'\xc6','\x50'},{'\xc6','\x51'},{'\x90','\x53'},
    {'\xb3','\xc0'},{'\xe0','\xee'},{'\xfc','\xfd'},{'\xb9','\xa8'},{'\xe8','\xf0'},
    {'\xfb','\x5e'},{'\x9f','\x66'},{'\xec','\xb0'},{'\xec','\xb1'},{'\xec','\xaf'},
    {'\xef','\xab'},{'\xef','\xaa'},{'\xc2','\x47'},{'\xf1','\xdf'},{'\xef','\xac'},
    {'\xf1','\xde'},{'\x00','\x00'},{'\x9f','\x51'},{'\xf3','\xf3'},{'\xc4','\x51'},
    {'\xc4','\x53'},{'\xf3','\xf2'},{'\xfc','\xf4'},{'\xfb','\x7c'},{'\xc4','\x52'},
    {'\xfb','\xb7'},{'\xf5','\xb1'},{'\xf5','\xb3'},{'\xf5','\xb2'},{'\xf6','\xca'},
    {'\xc5','\x65'},{'\xfd','\x48'},{'\xc5','\xef'},{'\xf8','\xe8'},{'\xf9','\x63'},
    {'\x9f','\x67'},{'\x00','\x00'},{'\xf9','\xd2'},{'\xb3','\xc1'},{'\x84','\xc1'},
    {'\xe4','\xe5'},{'\xfd','\xb4'},{'\xbe','\xa2'},{'\x98','\x6b'},{'\xfb','\xa2'},
    {'\x9f','\x68'},{'\xec','\xb3'},{'\xec','\xb2'},{'\x95','\x73'},{'\xef','\xad'},
    {'\x9f','\x69'},{'\x00','\x00'},{'\x00','\x00'},{'\xc4','\x54'},{'\xc4','\xd1'},
    {'\xf7','\xc7'},{'\xf9','\xcb'},{'\x88','\xc6'},{'\x82','\x60'},{'\x82','\x61'},
    {'\xb3','\xc2'},{'\xbb','\xf2'},{'\x98','\x6c'},{'\xbe','\xa3'},{'\x94','\xfa'},
    {'\xf3','\xf4'},{'\x9f','\x6a'},{'\xf8','\x74'},{'\xb6','\xc0'},{'\x98','\x6d'},
    {'\x00','\x00'},{'\x9f','\x6b'},{'\x9f','\x6c'},{'\xef','\xae'},{'\x8d','\x7a'},
    {'\x00','\x00'},{'\x00','\x00'},{'\xc6','\x64'},{'\xb6','\xc1'},{'\xbe','\xa4'},
    {'\xc2','\x48'},{'\xf8','\x75'},{'\xb6','\xc2'},{'\x92','\xc3'},{'\xe8','\xf1'},
    {'\xc0','\x72'},{'\xec','\xb4'},{'\xec','\xb5'},{'\x00','\x00'},{'\xc0','\x71'},
    {'\x93','\xd4'},{'\xef','\xaf'},{'\xc2','\x4c'},{'\xc2','\x4a'},{'\xc2','\x4b'},
    {'\xc2','\x49'},{'\xf1','\xe0'},{'\xc3','\x5c'},{'\x00','\x00'},{'\x98','\x6e'},
    {'\x00','\x00'},{'\xf5','\xb5'},{'\xf5','\xb4'},{'\xf5','\xb7'},{'\xf5','\xb6'},
    {'\xc4','\xd2'},{'\x8d','\xac'},{'\x98','\x6f'},{'\xf6','\xcb'},{'\x00','\x00'},
    {'\xf6','\xcd'},{'\xf6','\xcc'},{'\xc5','\x66'},{'\xf7','\xc8'},{'\x9f','\x6d'},
    {'\xf8','\x76'},{'\xf8','\x77'},{'\xc5','\xf0'},{'\xf9','\x64'},{'\xf9','\x7d'},
    {'\xc6','\x75'},{'\x9f','\x6e'},{'\xdc','\xb0'},{'\xec','\xb6'},{'\xef','\xb0'},
    {'\xf3','\xf5'},{'\xe0','\xef'},{'\x8e','\x64'},{'\xef','\xb1'},{'\xf1','\xe2'},
    {'\xf1','\xe1'},{'\xfd','\xe8'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf8','\x78'},{'\xc6','\x52'},{'\x98','\x70'},{'\xf9','\x65'},{'\xf9','\x7e'},
    {'\x98','\x71'},{'\x00','\x00'},{'\x98','\x72'},{'\xb9','\xa9'},{'\xe8','\xf2'},
    {'\xe8','\xf3'},{'\x00','\x00'},{'\xec','\xb7'},{'\xb9','\xaa'},{'\x00','\x00'},
    {'\xc3','\x5d'},{'\xf1','\xe3'},{'\xfc','\xdb'},{'\xf6','\xcf'},{'\xc5','\x67'},
    {'\xf6','\xd0'},{'\xf6','\xce'},{'\xf8','\x79'},{'\x00','\x00'},{'\xf8','\xe9'},
    {'\x00','\x00'},{'\xb9','\xab'},{'\x98','\x73'},{'\xef','\xb4'},{'\xef','\xb3'},
    {'\xef','\xb2'},{'\xf1','\xe4'},{'\xfb','\xb8'},{'\x9f','\x6f'},{'\xf1','\xe8'},
    {'\xf1','\xe7'},{'\xf1','\xe6'},{'\xf1','\xe5'},{'\xc3','\x5e'},{'\xf3','\xf6'},
    {'\xf5','\xb9'},{'\xc4','\xd3'},{'\xf5','\xb8'},{'\xf6','\xd1'},{'\xf7','\xcb'},
    {'\xf7','\xca'},{'\xc5','\xc4'},{'\xf7','\xc9'},{'\xf8','\x7c'},{'\xf8','\x7b'},
    {'\xf8','\x7a'},{'\x8c','\xf2'},{'\x00','\x00'},{'\xbb','\xf3'},{'\x00','\x00'},
    {'\xec','\xb8'},{'\xc2','\x4d'},{'\x00','\x00'},{'\xf3','\xf7'},{'\xf3','\xf8'},
    {'\xf7','\xcc'},{'\xf8','\x7d'},{'\x98','\x74'},{'\xfd','\xe2'},{'\xf8','\xea'},
    {'\xf9','\x66'},{'\xf9','\xb9'},{'\xf9','\xd4'},{'\xbb','\xf4'},{'\xc2','\x4e'},
    {'\xf1','\xe9'},{'\xf3','\xf9'},{'\xf6','\xd2'},{'\xf8','\x7e'},{'\x87','\xa2'},
    {'\x98','\x75'},{'\xbe','\xa6'},{'\xfd','\xe0'},{'\xef','\xb5'},{'\xf1','\xea'},
    {'\xf3','\xfa'},{'\xf3','\xfb'},{'\xf3','\xfc'},{'\xf5','\xbe'},{'\xfd','\xda'},
    {'\xf5','\xba'},{'\xc5','\x68'},{'\xf5','\xbd'},{'\xf5','\xbc'},{'\xc4','\xd4'},
    {'\xf5','\xbb'},{'\xc4','\xd6'},{'\x93','\xee'},{'\xc4','\xd5'},{'\xf6','\xd4'},
    {'\xf6','\xd3'},{'\xc5','\x69'},{'\xc5','\x6a'},{'\x00','\x00'},{'\xfd','\x62'},
    {'\xc5','\xc6'},{'\xf7','\xcd'},{'\xc5','\xc5'},{'\x00','\x00'},{'\xf8','\xa3'},
    {'\xf8','\xa4'},{'\xf8','\xa2'},{'\xf8','\xa1'},{'\xc6','\x54'},{'\x00','\x00'},
    {'\xf8','\xeb'},{'\xf8','\xec'},{'\xf8','\xed'},{'\xc6','\x53'},{'\xf9','\x67'},
    {'\xf9','\x6a'},{'\xf9','\x69'},{'\xf9','\x68'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xf9','\xd3'},{'\x88','\xc7'},{'\x8f','\x73'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x8c','\x6a'},{'\x8c','\x6b'},{'\x8f','\xfa'},{'\x8f','\xf9'},{'\x8c','\xc5'},
    {'\x8c','\xc6'},{'\x8c','\xf3'},{'\x8c','\xf4'},{'\x8d','\x6c'},{'\x8d','\x6b'},
    {'\xc0','\x73'},{'\xfb','\xd8'},{'\x00','\x00'},{'\xc3','\x65'},{'\xf5','\xbf'},
    {'\xf6','\xd5'},{'\x00','\x00'},{'\xc5','\xc7'},{'\xf7','\xce'},{'\x00','\x00'},
    {'\x00','\x00'},{'\xf9','\xd5'},{'\x89','\xc5'},{'\x8c','\xf5'},{'\x90','\x69'},
    {'\xc0','\x74'},{'\x98','\x76'},{'\x00','\x00'},{'\x89','\xc6'},{'\xef','\xb6'},
    {'\x00','\x00'},{'\xf7','\xcf'},{'\x00','\x00'},{'\xf9','\xa1'},{'\xfd','\xd4'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\xc8','\xa1'},{'\xc8','\xa3'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},
    {'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'},{'\x00','\x00'