/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.torque.engine.database.transform;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.List;
import org.apache.turbine.services.db.TurbineDB;
import org.apache.turbine.torque.engine.database.model.AppData;
import org.apache.turbine.torque.engine.database.model.Column;
import org.apache.turbine.torque.engine.database.model.Database;
import org.apache.turbine.torque.engine.database.model.ForeignKey;
import org.apache.turbine.torque.engine.database.model.Index;
import org.apache.turbine.torque.engine.database.model.Table;
import org.apache.turbine.torque.engine.database.model.Unique;
import org.apache.turbine.torque.engine.database.transform.DTDResolver;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private AppData app = null;
    private Database currDB;
    private Table currTable;
    private Column currColumn;
    private ForeignKey currFK;
    private Index currIndex;
    private Unique currUnique;
    private boolean firstPass = true;
    private Table foreignTable;
    private String errorMessage = "";

    public AppData parseFile(String xmlFile) {
        try {
            if (this.firstPass) {
                this.app = new AppData();
            }
            SAXParser parser = new SAXParser();
            DTDResolver dtdResolver = new DTDResolver();
            parser.setEntityResolver(dtdResolver);
            parser.setContentHandler(this);
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setErrorHandler(this);
            FileReader fr = new FileReader(xmlFile);
            BufferedReader br = new BufferedReader(fr);
            try {
                InputSource is = new InputSource(br);
                parser.parse(is);
            }
            finally {
                Object var7_8 = null;
                br.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.firstPass = false;
        if (this.errorMessage.length() > 0) {
            System.out.println("ERROR in schema!!!\n" + this.errorMessage);
        }
        return this.app;
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        try {
            if (!this.firstPass) {
                if (rawName.equals("database")) {
                    String s = attributes.getValue("name");
                    if (s == null) {
                        s = TurbineDB.getDefaultDB();
                    }
                    this.currDB = this.app.getDatabase(s);
                }
                if (rawName.equals("table")) {
                    this.currTable = this.currDB.getTable(attributes.getValue("name"));
                    if (this.currTable.getIdMethod().equals("autoincrement")) {
                        Column[] columns = this.currTable.getColumns();
                        boolean foundOne = false;
                        int i = 0;
                        while (i < columns.length && !foundOne) {
                            foundOne = columns[i].isAutoIncrement();
                            ++i;
                        }
                        if (!foundOne) {
                            this.errorMessage = this.errorMessage + "Table '" + this.currTable.getName() + "' is marked as autoincrement, but it does not " + "have a column which declared as the one to " + "auto increment (i.e. autoIncrement=\"true\")\n";
                        }
                    }
                } else if (rawName.equals("foreign-key")) {
                    String foreignTableName = attributes.getValue("foreignTable");
                    this.foreignTable = this.currDB.getTable(foreignTableName);
                    if (this.foreignTable == null) {
                        System.out.println("ERROR!! Attempt to set foreign key to nonexistent table, " + attributes.getValue("foreignTable") + "!");
                    }
                } else if (rawName.equals("reference")) {
                    Column foreign;
                    Column local;
                    ForeignKey fk = this.currTable.getForeignKey(attributes.getValue("local"));
                    List referrers = this.foreignTable.getReferrers();
                    if (referrers == null || !referrers.contains(fk)) {
                        this.foreignTable.addReferrer(fk);
                    }
                    if ((local = this.currTable.getColumn(attributes.getValue("local"))) == null) {
                        System.out.println("ERROR!! Attempt to define foreign key with nonexistent column, " + attributes.getValue("local") + ", in table, " + this.currTable.getName() + "!");
                    }
                    if (local.isPrimaryKey()) {
                        this.currTable.setContainsForeignPK(true);
                    }
                    if ((foreign = this.foreignTable.getColumn(attributes.getValue("foreign"))) == null) {
                        System.out.println("ERROR!! Attempt to set foreign key to nonexistent column, " + attributes.getValue("foreign") + ", in table, " + this.foreignTable.getName() + "!");
                    }
                    foreign.addReferrer(fk);
                }
            } else if (rawName.equals("database")) {
                this.currDB = this.app.addDatabase(attributes);
            } else if (rawName.equals("table")) {
                this.currTable = this.currDB.addTable(attributes);
            } else if (rawName.equals("column")) {
                this.currColumn = this.currTable.addColumn(attributes);
            } else if (rawName.equals("inheritance")) {
                this.currColumn.addInheritance(attributes);
            } else if (rawName.equals("foreign-key")) {
                this.currFK = this.currTable.addForeignKey(attributes);
            } else if (rawName.equals("reference")) {
                this.currFK.addReference(attributes);
            } else if (rawName.equals("index")) {
                this.currIndex = this.currTable.addIndex(attributes);
            } else if (rawName.equals("index-column")) {
                this.currIndex.addColumn(attributes);
            } else if (rawName.equals("unique")) {
                this.currUnique = this.currTable.addUnique(attributes);
            } else if (rawName.equals("unique-column")) {
                this.currUnique.addColumn(attributes);
            } else if (rawName.equals("id-method-parameter")) {
                this.currTable.addIdMethodParameter(attributes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void warning(SAXParseException spe) {
        System.out.println("Warning Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void error(SAXParseException spe) {
        System.out.println("Error Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }

    public void fatalError(SAXParseException spe) {
        System.out.println("Fatal Error Line: " + spe.getLineNumber() + " Row: " + spe.getColumnNumber() + " Msg: " + spe.getMessage());
    }
}

