/**
 * @file
 *
 * @author jeffrey.daily@gmail.com
 *
 * Copyright (c) 2015 Battelle Memorial Institute.
 *
 * This file was converted to C code from the raw file found at
 * ftp://ftp.cbi.pku.edu.cn/pub/software/blast/matrices/PAM50, the
 * Center for Bioinformatics, Peking University, China.
 */
#ifndef _PARASAIL_PAM50_H_
#define _PARASAIL_PAM50_H_

#include "parasail.h"
#include "pam_map.h"

#ifdef __cplusplus
extern "C" {
#endif

/* # */
/* # This matrix was produced by "pam" Version 1.0.6 [28-Jul-93] */
/* # */
/* # PAM 50 substitution matrix, scale = ln(2)/2 = 0.346574 */
/* # */
/* # Expected score = -3.70, Entropy = 2.00 bits */
/* # */
/* # Lowest score = -13, Highest score = 13 */
/* # */

static const int parasail_pam50_[] = {
/*        A   R   N   D   C   Q   E   G   H   I   L   K   M   F   P   S   T   W   Y   V   B   Z   X   * */
/* A */   5, -5, -2, -2, -5, -3, -1, -1, -5, -3, -5, -5, -4, -7,  0,  0,  0,-11, -6, -1, -2, -2, -2,-13,
/* R */  -5,  8, -4, -7, -6,  0, -7, -7,  0, -4, -7,  1, -3, -8, -3, -2, -5, -1, -8, -6, -5, -2, -4,-13,
/* N */  -2, -4,  7,  2, -8, -2, -1, -2,  1, -4, -6,  0, -6, -7, -4,  1, -1, -7, -3, -6,  5, -1, -2,-13,
/* D */  -2, -7,  2,  7,-11, -1,  3, -2, -2, -6,-10, -3, -8,-12, -6, -2, -3,-12, -9, -6,  6,  2, -4,-13,
/* C */  -5, -6, -8,-11,  9,-11,-11, -7, -6, -5,-12,-11,-11,-10, -6, -2, -6,-13, -3, -5, -9,-11, -7,-13,
/* Q */  -3,  0, -2, -1,-11,  8,  2, -5,  2, -6, -4, -2, -3,-10, -2, -4, -4,-10, -9, -5, -2,  6, -3,-13,
/* E */  -1, -7, -1,  3,-11,  2,  7, -3, -3, -4, -7, -3, -5,-11, -4, -3, -4,-13, -7, -5,  2,  6, -3,-13,
/* G */  -1, -7, -2, -2, -7, -5, -3,  6, -7, -8, -9, -6, -7, -8, -4, -1, -4,-12,-11, -4, -2, -4, -4,-13,
/* H */  -5,  0,  1, -2, -6,  2, -3, -7,  9, -7, -5, -4, -8, -5, -3, -4, -5, -6, -2, -5,  0,  0, -4,-13,
/* I */  -3, -4, -4, -6, -5, -6, -4, -8, -7,  8,  0, -5,  0, -1, -7, -5, -1,-11, -5,  3, -5, -5, -3,-13,
/* L */  -5, -7, -6,-10,-12, -4, -7, -9, -5,  0,  6, -6,  2, -1, -6, -7, -5, -5, -5, -1, -7, -5, -5,-13,
/* K */  -5,  1,  0, -3,-11, -2, -3, -6, -4, -5, -6,  6, -1,-11, -5, -3, -2, -9, -8, -7, -1, -2, -4,-13,
/* M */  -4, -3, -6, -8,-11, -3, -5, -7, -8,  0,  2, -1, 10, -3, -6, -4, -3,-10, -8,  0, -7, -4, -4,-13,
/* F */  -7, -8, -7,-12,-10,-10,-11, -8, -5, -1, -1,-11, -3,  9, -8, -5, -7, -3,  3, -6, -9,-11, -6,-13,
/* P */   0, -3, -4, -6, -6, -2, -4, -4, -3, -7, -6, -5, -6, -8,  8, -1, -3,-11,-11, -4, -5, -3, -4,-13,
/* S */   0, -2,  1, -2, -2, -4, -3, -1, -4, -5, -7, -3, -4, -5, -1,  6,  1, -4, -5, -4, -1, -3, -2,-13,
/* T */   0, -5, -1, -3, -6, -4, -4, -4, -5, -1, -5, -2, -3, -7, -3,  1,  6,-10, -5, -2, -2, -4, -2,-13,
/* W */ -11, -1, -7,-12,-13,-10,-13,-12, -6,-11, -5, -9,-10, -3,-11, -4,-10, 13, -4,-12, -8,-11, -9,-13,
/* Y */  -6, -8, -3, -9, -3, -9, -7,-11, -2, -5, -5, -8, -8,  3,-11, -5, -5, -4,  9, -6, -5, -8, -6,-13,
/* V */  -1, -6, -6, -6, -5, -5, -5, -4, -5,  3, -1, -7,  0, -6, -4, -4, -2,-12, -6,  7, -6, -5, -3,-13,
/* B */  -2, -5,  5,  6, -9, -2,  2, -2,  0, -5, -7, -1, -7, -9, -5, -1, -2, -8, -5, -6,  5,  1, -3,-13,
/* Z */  -2, -2, -1,  2,-11,  6,  6, -4,  0, -5, -5, -2, -4,-11, -3, -3, -4,-11, -8, -5,  1,  6, -3,-13,
/* X */  -2, -4, -2, -4, -7, -3, -3, -4, -4, -3, -5, -4, -4, -6, -4, -2, -2, -9, -6, -3, -3, -3, -4,-13,
/* * */ -13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,  1
};

static const parasail_matrix_t parasail_pam50 = {
    "pam50",
    parasail_pam50_,
    parasail_pam_map,
    24,
    13,
    -13,
    NULL
};

#ifdef __cplusplus
}
#endif

#endif /* _PARASAIL_PAM50_H_ */

