
-- some transform() regression

-- prime spatial_ref_sys table with two projections

--- EPSG 100001 : WGS 84 / UTM zone 33N
INSERT INTO "spatial_ref_sys" ("srid","auth_name","auth_srid","srtext","proj4text") VALUES (100001,'EPSG',100001,'PROJCS["WGS 84 / UTM zone 33N",GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","1000002"]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",15],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],PARAMETER["false_northing",0],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AUTHORITY["EPSG","100001"]]','+proj=utm +zone=33 +ellps=WGS84 +datum=WGS84 +units=m +no_defs ');
--- EPSG 100002 : WGS 84
INSERT INTO "spatial_ref_sys" ("srid","auth_name","auth_srid","srtext","proj4text") VALUES (100002,'EPSG',100002,'GEOGCS["WGS 84",DATUM["WGS_1984",SPHEROID["WGS 84",6378137,298.257223563,AUTHORITY["EPSG","7030"]],AUTHORITY["EPSG","6326"]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.01745329251994328,AUTHORITY["EPSG","9122"]],AUTHORITY["EPSG","100002"]]','+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ');

-- Repeat all tests with the new function names.
--- test #0: NULL values
SELECT 0,coalesce(ST_AsText(ST_transform(NULL::geometry, 100001)),'EMPTY');

--- test #1: a simple projection
SELECT 1,ST_AsEWKT(ST_SnapToGrid(ST_transform(ST_GeomFromEWKT('SRID=100002;POINT(16 48)'),100001),10));

--- test #2: same in 3D
SELECT 2,ST_AsEWKT(ST_SnapToGrid(ST_transform(ST_GeomFromEWKT('SRID=100002;POINT(16 48 171)'),100001),10));

--- test #3: same in 4D
SELECT 3,ST_AsEWKT(ST_SnapToGrid(ST_transform(ST_GeomFromEWKT('SRID=100002;POINT(16 48 171 -500)'),100001),10));

--- test #4: LINESTRING projection, 2 points
SELECT 4,ST_AsEWKT(ST_SnapToGrid(ST_transform(ST_GeomFromEWKT('SRID=100002;LINESTRING(16 48, 16 49)'),100001),10));

--- test #5: LINESTRING projection, 2 points, 4D
SELECT 5,ST_AsEWKT(ST_SnapToGrid(ST_transform(ST_GeomFromEWKT('SRID=100002;LINESTRING(16 48 0 0, 16 49 0 0)'),100001),10));

--- test #6: re-projecting a projected value
SELECT 6,round(ST_X(ST_transform(ST_transform(ST_GeomFromEWKT('SRID=100002;POINT(16 48)'),100001), 100002))::numeric,8),round(ST_Y(ST_transform(ST_transform(ST_GeomFromEWKT('SRID=100002;POINT(16 48)'),100001), 100002))::numeric,8);

--- test #7: Should yield an error since input SRID is unknown
SELECT ST_transform(ST_GeomFromEWKT('SRID=0;POINT(0 0)'),100002);

--- test #8: Transforming to same SRID
SELECT 8,ST_AsEWKT(ST_transform(ST_GeomFromEWKT('SRID=100002;POINT(0 0)'),100002));

SELECT 9, ST_AsEWKT(ST_SnapToGrid(ST_Transform(
               ST_GeomFromEWKT('SRID=100002;POINT(16 48)'),
               '+proj=utm +zone=33 +ellps=WGS84 +datum=WGS84 +units=m +no_defs '), 10));

--- test #10: Transform from_proj to_proj
SELECT 10, ST_AsEWKT(ST_SnapToGrid(ST_Transform(
               ST_GeomFromEWKT('POINT(16 48)'),
               '+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ',
               '+proj=utm +zone=33 +ellps=WGS84 +datum=WGS84 +units=m +no_defs '), 10));

--- test #11: Transform from_proj to_srid
SELECT 11, ST_AsEWKT(ST_SnapToGrid(ST_Transform(
               ST_GeomFromEWKT('POINT(16 48)'),
               '+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs ', 100001), 10));

--- test #12: Transform with bad to_proj
SELECT 12, ST_AsEWKT(ST_Transform(
           ST_GeomFromEWKT('SRID=100002;POINT(16 48)'),
           'invalid projection'));

DELETE FROM spatial_ref_sys WHERE srid in (100001, 100002);

--- Overflow proj cache
SELECT 13, count(*) FROM
(
    SELECT ST_Transform('SRID=4326; POINT(0 0)'::geometry, srid) AS g
    FROM
        ( Select srid from spatial_ref_sys where srid IN (3819,  3821,  3824,  3889,  3906,  4001,  4002,  4003,  4004,  4005,  4006,  4007,  4008,  4009,  4010,  4011,  4012,  4013,  4014,  4015,  4016,  4018,  4019,  4020,  4021,  4022,  4023,  4024,  4025,  4027,  4028,  4029,  4030,  4031,  4032,  4033,  4034,  4035,  4036,  4041,  4042,  4043,  4044,  4045,  4046,  4047,  4052,  4053,  4054,  4055,  4075,  4081,  4120,  4121,  4122,  4123,  4124,  4125,  4126,  4127,  4128,  4129,  4130,  4131,  4132,  4133,  4134,  4135,  4139,  4140,  4141,  4142,  4143,  4144,  4145,  4146,  4147,  4148,  4149,  4150,  4151,  4152,  4153,  4154,  4155,  4156,  4157,  4158,  4159,  4160,  4161,  4162,  4163,  4164,  4165,  4166,  4167,  4168,  4169,  4170,  4171,  4172,  4173,  4174,  4175,  4176,  4178,  4179,  4180,  4181,  4182,  4183,  4184,  4185,  4188,  4189,  4190,  4191,  4192,  4193,  4194,  4195,  4196,  4197,  4198,  4199,  4200,  4201,  4202,  4203,  4204,  4205,  4206,  4207,  4208,  4209,  4210,  4211,  4212,  4213,  4214,  4215,  4216,  4218,  4219,  4220,  4221)) _a
) _b WHERE g IS NOT NULL;
