% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors-day.r
\name{day}
\alias{day}
\alias{mday}
\alias{wday}
\alias{qday}
\alias{yday}
\alias{day<-}
\alias{mday<-}
\alias{qday<-}
\alias{wday<-}
\alias{yday<-}
\title{Get/set days component of a date-time}
\usage{
day(x)

mday(x)

wday(
  x,
  label = FALSE,
  abbr = TRUE,
  week_start = getOption("lubridate.week.start", 7),
  locale = Sys.getlocale("LC_TIME")
)

qday(x)

yday(x)

day(x) <- value

mday(x) <- value

qday(x) <- value

wday(x, week_start = getOption("lubridate.week.start", 7)) <- value

yday(x) <- value
}
\arguments{
\item{x}{a POSIXct, POSIXlt, Date, chron, yearmon, yearqtr, zoo, zooreg,
timeDate, xts, its, ti, jul, timeSeries, or fts object.}

\item{label}{logical. Only available for wday. TRUE will display the day of
the week as an ordered factor of character strings, such as "Sunday." FALSE
will display the day of the week as a number.}

\item{abbr}{logical. Only available for wday. FALSE will display the day of
the week as an ordered factor of character strings, such as "Sunday." TRUE
will display an abbreviated version of the label, such as "Sun". abbr is
disregarded if label = FALSE.}

\item{week_start}{day on which week starts following ISO conventions - 1
means Monday, 7 means Sunday (default). When \code{label = TRUE}, this will be
the first level of the returned factor. You can set \code{lubridate.week.start}
option to control this parameter globally.}

\item{locale}{locale to use for day names. Default to current locale.}

\item{value}{a numeric object}
}
\value{
\code{wday()} returns the day of the week as a decimal number or an
ordered factor if label is \code{TRUE}.
}
\description{
Get/set days component of a date-time
}
\details{
\code{mday()} and \code{yday()} return the day of the month and day of the
year respectively. \code{day()} and \verb{day<-()} are aliases for \code{mday()} and
\verb{mday<-()}.
}
\examples{
x <- as.Date("2009-09-02")
wday(x) #4

wday(ymd(080101))
wday(ymd(080101), label = TRUE, abbr = FALSE)
wday(ymd(080101), label = TRUE, abbr = TRUE)
wday(ymd(080101) + days(-2:4), label = TRUE, abbr = TRUE)

x <- as.Date("2009-09-02")
yday(x) #245
mday(x) #2
yday(x) <- 1  #"2009-01-01"
yday(x) <- 366 #"2010-01-01"
mday(x) > 3
}
\keyword{chron}
\keyword{manip}
\keyword{methods}
\keyword{utilities}
