/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.input;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.fest.swing.awt.AWT;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.input.DragDropInfo;
import org.fest.swing.input.EventNormalizer;
import org.fest.swing.input.MouseInfo;
import org.fest.swing.listener.EventDispatchThreadedEventListener;

@ThreadSafe
public class InputState {
    @GuardedBy(value="this")
    private final MouseInfo mouseInfo = new MouseInfo();
    @GuardedBy(value="this")
    private final DragDropInfo dragDropInfo = new DragDropInfo();
    @GuardedBy(value="this")
    private int modifiers;
    @GuardedBy(value="this")
    private long lastEventTime;
    private EventNormalizer normalizer;

    public InputState(Toolkit toolkit) {
        long mask = 56L;
        EventDispatchThreadedEventListener listener = new EventDispatchThreadedEventListener(){

            protected void processEvent(AWTEvent event) {
                InputState.this.update(event);
            }
        };
        this.normalizer = new EventNormalizer();
        this.normalizer.startListening(toolkit, listener, mask);
    }

    public synchronized void clear() {
        this.mouseInfo.clear();
        this.dragDropInfo.clear();
        this.modifiers = 0;
        this.lastEventTime = 0L;
    }

    public void dispose() {
        this.normalizer.stopListening();
        this.normalizer = null;
    }

    public void update(AWTEvent event) {
        if (event instanceof KeyEvent) {
            this.updateState((KeyEvent)event);
        }
        if (event instanceof MouseEvent) {
            this.updateState((MouseEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(KeyEvent event) {
        if (this.isOld(event)) {
            return;
        }
        InputState inputState = this;
        synchronized (inputState) {
            this.lastEventTime(event);
            this.modifiers(event.getModifiers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(MouseEvent event) {
        Point eventScreenLocation;
        block7: {
            if (this.isOld(event)) {
                return;
            }
            eventScreenLocation = null;
            try {
                eventScreenLocation = AWT.locationOnScreenOf(event.getComponent());
            }
            catch (IllegalComponentStateException e) {
            }
            catch (UnexpectedException e) {
                if (e.getCause() instanceof IllegalComponentStateException) break block7;
                throw e;
            }
        }
        InputState inputState = this;
        synchronized (inputState) {
            this.lastEventTime(event);
            this.dragDropInfo.update(event);
            this.mouseInfo.modifiers(this.modifiers);
            this.mouseInfo.update(event, eventScreenLocation);
            this.modifiers(this.mouseInfo.modifiers());
        }
    }

    private boolean isOld(InputEvent event) {
        return event.getWhen() < this.lastEventTime();
    }

    private void lastEventTime(InputEvent event) {
        this.lastEventTime = event.getWhen();
    }

    private void modifiers(int newModifiers) {
        this.modifiers = newModifiers;
    }

    public synchronized Component deepestComponentUnderMousePointer() {
        Component c = this.mouseComponent();
        if (c != null) {
            c = InputState.childAt(c, this.mouseLocation());
        }
        return c;
    }

    public synchronized Component mouseComponent() {
        return this.mouseInfo.component();
    }

    public static Component childAt(Component parent, Point where) {
        return SwingUtilities.getDeepestComponentAt(parent, where.x, where.y);
    }

    public synchronized boolean dragInProgress() {
        return this.dragDropInfo.isDragging();
    }

    public synchronized Component dragSource() {
        return this.dragDropInfo.source();
    }

    public synchronized Point dragOrigin() {
        return this.dragDropInfo.origin();
    }

    public synchronized int clickCount() {
        return this.mouseInfo.clickCount();
    }

    public synchronized long lastEventTime() {
        return this.lastEventTime;
    }

    public synchronized int modifiers() {
        return this.modifiers;
    }

    public synchronized int keyModifiers() {
        return this.modifiers & 0xFFFFFFE3;
    }

    public synchronized int buttons() {
        return this.mouseInfo.buttons();
    }

    public synchronized Point mouseLocation() {
        return this.mouseInfo.location();
    }

    public synchronized Point mouseLocationOnScreen() {
        return this.mouseInfo.locationOnScreen();
    }

    public boolean isNativeDragActive() {
        return this.dragDropInfo.isNativeDragActive();
    }
}

