#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sherlock Holmes Versus Jack the Ripper
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240826.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='sherlock-holmes-5-versus-jack-the-ripper'
GAME_NAME='Sherlock Holmes Versus Jack the Ripper'

ARCHIVE_BASE_0_NAME='setup_sherlock_holmes_vs_jack_the_ripper_2.0.0.2.exe'
ARCHIVE_BASE_0_MD5='65d2d3ee20a5d4db4017c90701ab91cd'
ARCHIVE_BASE_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_0_EXTRACTOR_OPTIONS='--lowercase --gog'
ARCHIVE_BASE_0_PART1_NAME='setup_sherlock_holmes_vs_jack_the_ripper_2.0.0.2-1.bin'
ARCHIVE_BASE_0_PART1_MD5='17c054477fe1fe12e79513ae71ff1a5d'
ARCHIVE_BASE_0_PART1_EXTRACTOR='unar'
ARCHIVE_BASE_0_PART2_NAME='setup_sherlock_holmes_vs_jack_the_ripper_2.0.0.2-2.bin'
ARCHIVE_BASE_0_PART2_MD5='26eebfcd9a171eb3a380876681803597'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.2'
ARCHIVE_BASE_0_SIZE='3200000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sherlock_holmes_versus_jack_the_ripper'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
*.dll
*.exe'
CONTENT_GAME_L10N_EN_FILES='
000/en.pak
000/sounds_en.pak'
CONTENT_GAME_L10N_FR_FILES='
000/fr.pak
000/sounds_fr.pak'
CONTENT_GAME_DATA_FILES='
logo
data.txt
shaders.0050
splash_screen.jpg
000/game.pak
000/sounds.pak
000/texture.pak
000/texture3d.pak'
CONTENT_GAME0_BIN_PATH='support/app'
CONTENT_GAME0_BIN_FILES='
user.ini'

## TODO: We should divert a single path, and set the other localized paths as symbolic links
WINE_PERSISTENT_DIRECTORIES="
users/\${USER}/AppData/Roaming/Games/sherlock holmes versus jack the ripper
users/\${USER}/AppData/Roaming/Games/sherlock holmes contre jack l'eventreur"
## Install PhysX in the WINE prefix
## Provided installers can not be used:
## - with PhysX-9.13.0604-SystemSoftware-Legacy.msi, the game fails to load PhysX
## - with PhysX-9.15.0428-SystemSoftware.exe, PhysX installation fails
WINE_WINETRICKS_VERBS='physx'

APP_MAIN_EXE='game.exe'
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --language=0'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_EN
PKG_L10N_FR
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N
PKG_DATA'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_EN_ID="${PKG_L10N_ID}-en"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_EN_DESCRIPTION='English localization'
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_EN_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'

## Include language-specific configuration file
install -D --mode=644 \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/_loc/en" \
	"$(package_path 'PKG_L10N_EN')$(path_game_data)/game.ini"
install -D --mode=644 \
	"${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/_loc/fr" \
	"$(package_path 'PKG_L10N_FR')$(path_game_data)/game.ini"

content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
case "$(messages_language)" in
	('fr')
		lang_string='version %s :'
		lang_en='anglaise'
		lang_fr='française'
	;;
	('en'|*)
		lang_string='%s version:'
		lang_en='English'
		lang_fr='French'
	;;
esac
printf '\n'
printf "$lang_string" "$lang_en"
print_instructions 'PKG_L10N_EN' 'PKG_DATA' 'PKG_BIN'
printf "$lang_string" "$lang_fr"
print_instructions 'PKG_L10N_FR' 'PKG_DATA' 'PKG_BIN'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
