
set(PACKAGE_VERSION_FILE "${PROJECT_BINARY_DIR}/${PACKAGE_NAME}-config-version.cmake")

if(NOT EXISTS "${PACKAGE_VERSION_FILE}")
  message(FATAL_ERROR "Config version file not found at ${PACKAGE_VERSION_FILE}")
endif()

message(STATUS "Testing version file: ${PACKAGE_VERSION_FILE}")

# Test 1: Exact match
set(PACKAGE_FIND_VERSION "${PACKAGE_VERSION}")
set(PACKAGE_FIND_VERSION_MAJOR "${PACKAGE_VERSION_MAJOR}")
unset(PACKAGE_FIND_VERSION_RANGE)
include("${PACKAGE_VERSION_FILE}")
if(NOT PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should be compatible with ${PACKAGE_FIND_VERSION}")
endif()
if(NOT PACKAGE_VERSION_EXACT)
  message(FATAL_ERROR "${PACKAGE_VERSION} should be compatible with ${PACKAGE_FIND_VERSION}")
endif()
message(STATUS "Test 1 Passed: Exact Match")

# Test 2: Compatible version (older requested, same major)
set(PACKAGE_FIND_VERSION "${PACKAGE_VERSION_MAJOR}.${PACKAGE_VERSION_MINOR}.0")
set(PACKAGE_FIND_VERSION_MAJOR "${PACKAGE_VERSION_MAJOR}")
unset(PACKAGE_FIND_VERSION_RANGE)
include("${PACKAGE_VERSION_FILE}")
if(NOT PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should be compatible with ${PACKAGE_FIND_VERSION}")
endif()
message(STATUS "Test 2 Passed: Backward Compatibility")

# Test 3: Incompatible version (newer requested)
math(EXPR PACKAGE_VERSION_MINOR_PLUS_ONE "${PACKAGE_VERSION_MINOR} + 1")
set(PACKAGE_FIND_VERSION "${PACKAGE_VERSION_MAJOR}.${PACKAGE_VERSION_MINOR_PLUS_ONE}.0")
set(PACKAGE_FIND_VERSION_MAJOR "${PACKAGE_VERSION_MAJOR}")
unset(PACKAGE_FIND_VERSION_RANGE)
include("${PACKAGE_VERSION_FILE}")
if(PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should NOT be compatible with ${PACKAGE_FIND_VERSION}")
endif()
message(STATUS "Test 3 Passed: Forward Incompatibility")

# Test 4: Incompatible version (different major)
math(EXPR PACKAGE_VERSION_MAJOR_MINUS_ONE "${PACKAGE_VERSION_MAJOR} - 1")
set(PACKAGE_FIND_VERSION "${PACKAGE_VERSION_MAJOR_MINUS_ONE}.${PACKAGE_VERSION_MINOR}.0")
set(PACKAGE_FIND_VERSION_MAJOR "${PACKAGE_VERSION_MAJOR_MINUS_ONE}")
unset(PACKAGE_FIND_VERSION_RANGE)
include("${PACKAGE_VERSION_FILE}")
if(PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should NOT be compatible with ${PACKAGE_FIND_VERSION}")
endif()
message(STATUS "Test 4 Passed: Major Version Mismatch")

# Test 5: Version Range (Included) 2.0...3.0
math(EXPR PACKAGE_VERSION_MAJOR_PLUS_ONE "${PACKAGE_VERSION_MAJOR} + 1")
set(PACKAGE_FIND_VERSION_RANGE "${PACKAGE_VERSION_MAJOR}.0...${PACKAGE_VERSION_MAJOR_PLUS_ONE}.0")
set(PACKAGE_FIND_VERSION_MIN "${PACKAGE_VERSION_MAJOR}.0")
set(PACKAGE_FIND_VERSION_MAX "${PACKAGE_VERSION_MAJOR_PLUS_ONE}.0")
set(PACKAGE_FIND_VERSION_RANGE_MIN "INCLUDE")
set(PACKAGE_FIND_VERSION_RANGE_MAX "EXCLUDE")
include("${PACKAGE_VERSION_FILE}")
if(NOT PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should be in range ${PACKAGE_FIND_VERSION_RANGE}")
endif()
message(STATUS "Test 5 Passed: Range Include")

# Test 6: Version Range (Excluded - too high) 3.0...4.0
math(EXPR PACKAGE_VERSION_MAJOR_PLUS_TWO "${PACKAGE_VERSION_MAJOR} + 2")
set(PACKAGE_FIND_VERSION_RANGE "${PACKAGE_VERSION_MAJOR_PLUS_ONE}.0...${PACKAGE_VERSION_MAJOR_PLUS_TWO}.0")
set(PACKAGE_FIND_VERSION_MIN "${PACKAGE_VERSION_MAJOR_PLUS_ONE}.0")
set(PACKAGE_FIND_VERSION_MAX "${PACKAGE_VERSION_MAJOR_PLUS_TWO}.0")
set(PACKAGE_FIND_VERSION_RANGE_MIN "INCLUDE")
set(PACKAGE_FIND_VERSION_RANGE_MAX "EXCLUDE")
include("${PACKAGE_VERSION_FILE}")
if(PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should NOT be in range ${PACKAGE_FIND_VERSION_RANGE}")
endif()
message(STATUS "Test 6 Passed: Range Exclude (Too High)")

# Test 7: Version Range (Excluded - too low) 1.0...2.0
math(EXPR PACKAGE_VERSION_MAJOR_MINUS_TWO "${PACKAGE_VERSION_MAJOR} - 2")
set(PACKAGE_FIND_VERSION_RANGE "${PACKAGE_VERSION_MAJOR_MINUS_TWO}.0...${PACKAGE_VERSION_MAJOR_MINUS_ONE}.0")
set(PACKAGE_FIND_VERSION_MIN "${PACKAGE_VERSION_MAJOR_MINUS_TWO}.0")
set(PACKAGE_FIND_VERSION_MAX "${PACKAGE_VERSION_MAJOR_MINUS_ONE}.0")
set(PACKAGE_FIND_VERSION_RANGE_MIN "INCLUDE")
set(PACKAGE_FIND_VERSION_RANGE_MAX "EXCLUDE")
include("${PACKAGE_VERSION_FILE}")
if(PACKAGE_VERSION_COMPATIBLE)
  message(FATAL_ERROR "${PACKAGE_VERSION} should NOT be in range ${PACKAGE_FIND_VERSION_RANGE}")
endif()
message(STATUS "Test 7 Passed: Range Exclude (Too Low)")

message(STATUS "All find_package() version checks passed!")
