//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatafactory

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AccessPolicyResponse.
func (a AccessPolicyResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", a.AccessToken)
	populate(objectMap, "dataPlaneUrl", a.DataPlaneURL)
	populate(objectMap, "policy", a.Policy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessPolicyResponse.
func (a *AccessPolicyResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &a.AccessToken)
			delete(rawMsg, key)
		case "dataPlaneUrl":
			err = unpopulate(val, "DataPlaneURL", &a.DataPlaneURL)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &a.Policy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Activity.
func (a Activity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "state", a.State)
	objectMap["type"] = a.Type
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Activity.
func (a *Activity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityDependency.
func (a ActivityDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activity", a.Activity)
	populate(objectMap, "dependencyConditions", a.DependencyConditions)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityDependency.
func (a *ActivityDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activity":
			err = unpopulate(val, "Activity", &a.Activity)
			delete(rawMsg, key)
		case "dependencyConditions":
			err = unpopulate(val, "DependencyConditions", &a.DependencyConditions)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityPolicy.
func (a ActivityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "retry", a.Retry)
	populate(objectMap, "retryIntervalInSeconds", a.RetryIntervalInSeconds)
	populate(objectMap, "secureInput", a.SecureInput)
	populate(objectMap, "secureOutput", a.SecureOutput)
	populateAny(objectMap, "timeout", a.Timeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityPolicy.
func (a *ActivityPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "retry":
			err = unpopulate(val, "Retry", &a.Retry)
			delete(rawMsg, key)
		case "retryIntervalInSeconds":
			err = unpopulate(val, "RetryIntervalInSeconds", &a.RetryIntervalInSeconds)
			delete(rawMsg, key)
		case "secureInput":
			err = unpopulate(val, "SecureInput", &a.SecureInput)
			delete(rawMsg, key)
		case "secureOutput":
			err = unpopulate(val, "SecureOutput", &a.SecureOutput)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &a.Timeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityRun.
func (a ActivityRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityName", a.ActivityName)
	populateDateTimeRFC3339(objectMap, "activityRunEnd", a.ActivityRunEnd)
	populate(objectMap, "activityRunId", a.ActivityRunID)
	populateDateTimeRFC3339(objectMap, "activityRunStart", a.ActivityRunStart)
	populate(objectMap, "activityType", a.ActivityType)
	populate(objectMap, "durationInMs", a.DurationInMs)
	populateAny(objectMap, "error", a.Error)
	populateAny(objectMap, "input", a.Input)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populateAny(objectMap, "output", a.Output)
	populate(objectMap, "pipelineName", a.PipelineName)
	populate(objectMap, "pipelineRunId", a.PipelineRunID)
	populate(objectMap, "status", a.Status)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityRun.
func (a *ActivityRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityName":
			err = unpopulate(val, "ActivityName", &a.ActivityName)
			delete(rawMsg, key)
		case "activityRunEnd":
			err = unpopulateDateTimeRFC3339(val, "ActivityRunEnd", &a.ActivityRunEnd)
			delete(rawMsg, key)
		case "activityRunId":
			err = unpopulate(val, "ActivityRunID", &a.ActivityRunID)
			delete(rawMsg, key)
		case "activityRunStart":
			err = unpopulateDateTimeRFC3339(val, "ActivityRunStart", &a.ActivityRunStart)
			delete(rawMsg, key)
		case "activityType":
			err = unpopulate(val, "ActivityType", &a.ActivityType)
			delete(rawMsg, key)
		case "durationInMs":
			err = unpopulate(val, "DurationInMs", &a.DurationInMs)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &a.Input)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &a.Output)
			delete(rawMsg, key)
		case "pipelineName":
			err = unpopulate(val, "PipelineName", &a.PipelineName)
			delete(rawMsg, key)
		case "pipelineRunId":
			err = unpopulate(val, "PipelineRunID", &a.PipelineRunID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ActivityRunsQueryResponse.
func (a ActivityRunsQueryResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "continuationToken", a.ContinuationToken)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ActivityRunsQueryResponse.
func (a *ActivityRunsQueryResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "continuationToken":
			err = unpopulate(val, "ContinuationToken", &a.ContinuationToken)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AddDataFlowToDebugSessionResponse.
func (a AddDataFlowToDebugSessionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobVersion", a.JobVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddDataFlowToDebugSessionResponse.
func (a *AddDataFlowToDebugSessionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobVersion":
			err = unpopulate(val, "JobVersion", &a.JobVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonMWSLinkedService.
func (a AmazonMWSLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AmazonMWS"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonMWSLinkedService.
func (a *AmazonMWSLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonMWSLinkedServiceTypeProperties.
func (a AmazonMWSLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accessKeyId", a.AccessKeyID)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "endpoint", a.Endpoint)
	populateAny(objectMap, "marketplaceID", a.MarketplaceID)
	populate(objectMap, "mwsAuthToken", a.MwsAuthToken)
	populate(objectMap, "secretKey", a.SecretKey)
	populateAny(objectMap, "sellerID", a.SellerID)
	populateAny(objectMap, "useEncryptedEndpoints", a.UseEncryptedEndpoints)
	populateAny(objectMap, "useHostVerification", a.UseHostVerification)
	populateAny(objectMap, "usePeerVerification", a.UsePeerVerification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonMWSLinkedServiceTypeProperties.
func (a *AmazonMWSLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKeyId":
			err = unpopulate(val, "AccessKeyID", &a.AccessKeyID)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "marketplaceID":
			err = unpopulate(val, "MarketplaceID", &a.MarketplaceID)
			delete(rawMsg, key)
		case "mwsAuthToken":
			a.MwsAuthToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "secretKey":
			a.SecretKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "sellerID":
			err = unpopulate(val, "SellerID", &a.SellerID)
			delete(rawMsg, key)
		case "useEncryptedEndpoints":
			err = unpopulate(val, "UseEncryptedEndpoints", &a.UseEncryptedEndpoints)
			delete(rawMsg, key)
		case "useHostVerification":
			err = unpopulate(val, "UseHostVerification", &a.UseHostVerification)
			delete(rawMsg, key)
		case "usePeerVerification":
			err = unpopulate(val, "UsePeerVerification", &a.UsePeerVerification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonMWSObjectDataset.
func (a AmazonMWSObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AmazonMWSObject"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonMWSObjectDataset.
func (a *AmazonMWSObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonMWSSource.
func (a AmazonMWSSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AmazonMWSSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonMWSSource.
func (a *AmazonMWSSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForLinkedServiceTypeProperties.
func (a AmazonRdsForLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForLinkedServiceTypeProperties.
func (a *AmazonRdsForLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			a.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForOracleLinkedService.
func (a AmazonRdsForOracleLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AmazonRdsForOracle"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForOracleLinkedService.
func (a *AmazonRdsForOracleLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForOraclePartitionSettings.
func (a AmazonRdsForOraclePartitionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "partitionColumnName", a.PartitionColumnName)
	populateAny(objectMap, "partitionLowerBound", a.PartitionLowerBound)
	populateAny(objectMap, "partitionNames", a.PartitionNames)
	populateAny(objectMap, "partitionUpperBound", a.PartitionUpperBound)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForOraclePartitionSettings.
func (a *AmazonRdsForOraclePartitionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "partitionColumnName":
			err = unpopulate(val, "PartitionColumnName", &a.PartitionColumnName)
			delete(rawMsg, key)
		case "partitionLowerBound":
			err = unpopulate(val, "PartitionLowerBound", &a.PartitionLowerBound)
			delete(rawMsg, key)
		case "partitionNames":
			err = unpopulate(val, "PartitionNames", &a.PartitionNames)
			delete(rawMsg, key)
		case "partitionUpperBound":
			err = unpopulate(val, "PartitionUpperBound", &a.PartitionUpperBound)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForOracleSource.
func (a AmazonRdsForOracleSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "oracleReaderQuery", a.OracleReaderQuery)
	populateAny(objectMap, "partitionOption", a.PartitionOption)
	populate(objectMap, "partitionSettings", a.PartitionSettings)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AmazonRdsForOracleSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForOracleSource.
func (a *AmazonRdsForOracleSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "oracleReaderQuery":
			err = unpopulate(val, "OracleReaderQuery", &a.OracleReaderQuery)
			delete(rawMsg, key)
		case "partitionOption":
			err = unpopulate(val, "PartitionOption", &a.PartitionOption)
			delete(rawMsg, key)
		case "partitionSettings":
			err = unpopulate(val, "PartitionSettings", &a.PartitionSettings)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForOracleTableDataset.
func (a AmazonRdsForOracleTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AmazonRdsForOracleTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForOracleTableDataset.
func (a *AmazonRdsForOracleTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForOracleTableDatasetTypeProperties.
func (a AmazonRdsForOracleTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForOracleTableDatasetTypeProperties.
func (a *AmazonRdsForOracleTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForSQLServerLinkedService.
func (a AmazonRdsForSQLServerLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AmazonRdsForSqlServer"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForSQLServerLinkedService.
func (a *AmazonRdsForSQLServerLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForSQLServerLinkedServiceTypeProperties.
func (a AmazonRdsForSQLServerLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alwaysEncryptedSettings", a.AlwaysEncryptedSettings)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	populateAny(objectMap, "userName", a.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForSQLServerLinkedServiceTypeProperties.
func (a *AmazonRdsForSQLServerLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alwaysEncryptedSettings":
			err = unpopulate(val, "AlwaysEncryptedSettings", &a.AlwaysEncryptedSettings)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			a.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &a.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForSQLServerSource.
func (a AmazonRdsForSQLServerSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "isolationLevel", a.IsolationLevel)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "partitionOption", a.PartitionOption)
	populate(objectMap, "partitionSettings", a.PartitionSettings)
	populateAny(objectMap, "produceAdditionalTypes", a.ProduceAdditionalTypes)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sqlReaderQuery", a.SQLReaderQuery)
	populateAny(objectMap, "sqlReaderStoredProcedureName", a.SQLReaderStoredProcedureName)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	populateAny(objectMap, "storedProcedureParameters", a.StoredProcedureParameters)
	objectMap["type"] = "AmazonRdsForSqlServerSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForSQLServerSource.
func (a *AmazonRdsForSQLServerSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "isolationLevel":
			err = unpopulate(val, "IsolationLevel", &a.IsolationLevel)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "partitionOption":
			err = unpopulate(val, "PartitionOption", &a.PartitionOption)
			delete(rawMsg, key)
		case "partitionSettings":
			err = unpopulate(val, "PartitionSettings", &a.PartitionSettings)
			delete(rawMsg, key)
		case "produceAdditionalTypes":
			err = unpopulate(val, "ProduceAdditionalTypes", &a.ProduceAdditionalTypes)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sqlReaderQuery":
			err = unpopulate(val, "SQLReaderQuery", &a.SQLReaderQuery)
			delete(rawMsg, key)
		case "sqlReaderStoredProcedureName":
			err = unpopulate(val, "SQLReaderStoredProcedureName", &a.SQLReaderStoredProcedureName)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "storedProcedureParameters":
			err = unpopulate(val, "StoredProcedureParameters", &a.StoredProcedureParameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForSQLServerTableDataset.
func (a AmazonRdsForSQLServerTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AmazonRdsForSqlServerTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForSQLServerTableDataset.
func (a *AmazonRdsForSQLServerTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRdsForSQLServerTableDatasetTypeProperties.
func (a AmazonRdsForSQLServerTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRdsForSQLServerTableDatasetTypeProperties.
func (a *AmazonRdsForSQLServerTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRedshiftLinkedService.
func (a AmazonRedshiftLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AmazonRedshift"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRedshiftLinkedService.
func (a *AmazonRedshiftLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRedshiftLinkedServiceTypeProperties.
func (a AmazonRedshiftLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "database", a.Database)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	populateAny(objectMap, "port", a.Port)
	populateAny(objectMap, "server", a.Server)
	populateAny(objectMap, "username", a.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRedshiftLinkedServiceTypeProperties.
func (a *AmazonRedshiftLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			a.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &a.Server)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &a.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRedshiftSource.
func (a AmazonRedshiftSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populate(objectMap, "redshiftUnloadSettings", a.RedshiftUnloadSettings)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AmazonRedshiftSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRedshiftSource.
func (a *AmazonRedshiftSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "redshiftUnloadSettings":
			err = unpopulate(val, "RedshiftUnloadSettings", &a.RedshiftUnloadSettings)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRedshiftTableDataset.
func (a AmazonRedshiftTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AmazonRedshiftTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRedshiftTableDataset.
func (a *AmazonRedshiftTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonRedshiftTableDatasetTypeProperties.
func (a AmazonRedshiftTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonRedshiftTableDatasetTypeProperties.
func (a *AmazonRedshiftTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3CompatibleLinkedService.
func (a AmazonS3CompatibleLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AmazonS3Compatible"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3CompatibleLinkedService.
func (a *AmazonS3CompatibleLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3CompatibleLinkedServiceTypeProperties.
func (a AmazonS3CompatibleLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accessKeyId", a.AccessKeyID)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "forcePathStyle", a.ForcePathStyle)
	populate(objectMap, "secretAccessKey", a.SecretAccessKey)
	populateAny(objectMap, "serviceUrl", a.ServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3CompatibleLinkedServiceTypeProperties.
func (a *AmazonS3CompatibleLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKeyId":
			err = unpopulate(val, "AccessKeyID", &a.AccessKeyID)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "forcePathStyle":
			err = unpopulate(val, "ForcePathStyle", &a.ForcePathStyle)
			delete(rawMsg, key)
		case "secretAccessKey":
			a.SecretAccessKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3CompatibleLocation.
func (a AmazonS3CompatibleLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "bucketName", a.BucketName)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	objectMap["type"] = "AmazonS3CompatibleLocation"
	populateAny(objectMap, "version", a.Version)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3CompatibleLocation.
func (a *AmazonS3CompatibleLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bucketName":
			err = unpopulate(val, "BucketName", &a.BucketName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3CompatibleReadSettings.
func (a AmazonS3CompatibleReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", a.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", a.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", a.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", a.PartitionRootPath)
	populateAny(objectMap, "prefix", a.Prefix)
	populateAny(objectMap, "recursive", a.Recursive)
	objectMap["type"] = "AmazonS3CompatibleReadSettings"
	populateAny(objectMap, "wildcardFileName", a.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", a.WildcardFolderPath)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3CompatibleReadSettings.
func (a *AmazonS3CompatibleReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &a.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &a.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &a.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &a.PartitionRootPath)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &a.Prefix)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &a.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &a.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3Dataset.
func (a AmazonS3Dataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AmazonS3Object"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3Dataset.
func (a *AmazonS3Dataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3DatasetTypeProperties.
func (a AmazonS3DatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "bucketName", a.BucketName)
	populate(objectMap, "compression", a.Compression)
	populate(objectMap, "format", a.Format)
	populateAny(objectMap, "key", a.Key)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "prefix", a.Prefix)
	populateAny(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3DatasetTypeProperties.
func (a *AmazonS3DatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bucketName":
			err = unpopulate(val, "BucketName", &a.BucketName)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &a.Compression)
			delete(rawMsg, key)
		case "format":
			a.Format, err = unmarshalDatasetStorageFormatClassification(val)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &a.Key)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &a.Prefix)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3LinkedService.
func (a AmazonS3LinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AmazonS3"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3LinkedService.
func (a *AmazonS3LinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3LinkedServiceTypeProperties.
func (a AmazonS3LinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accessKeyId", a.AccessKeyID)
	populateAny(objectMap, "authenticationType", a.AuthenticationType)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "secretAccessKey", a.SecretAccessKey)
	populateAny(objectMap, "serviceUrl", a.ServiceURL)
	populate(objectMap, "sessionToken", a.SessionToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3LinkedServiceTypeProperties.
func (a *AmazonS3LinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKeyId":
			err = unpopulate(val, "AccessKeyID", &a.AccessKeyID)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &a.AuthenticationType)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "secretAccessKey":
			a.SecretAccessKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &a.ServiceURL)
			delete(rawMsg, key)
		case "sessionToken":
			a.SessionToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3Location.
func (a AmazonS3Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "bucketName", a.BucketName)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	objectMap["type"] = "AmazonS3Location"
	populateAny(objectMap, "version", a.Version)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3Location.
func (a *AmazonS3Location) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bucketName":
			err = unpopulate(val, "BucketName", &a.BucketName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmazonS3ReadSettings.
func (a AmazonS3ReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", a.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", a.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", a.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", a.PartitionRootPath)
	populateAny(objectMap, "prefix", a.Prefix)
	populateAny(objectMap, "recursive", a.Recursive)
	objectMap["type"] = "AmazonS3ReadSettings"
	populateAny(objectMap, "wildcardFileName", a.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", a.WildcardFolderPath)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmazonS3ReadSettings.
func (a *AmazonS3ReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &a.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &a.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &a.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &a.PartitionRootPath)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &a.Prefix)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &a.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &a.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppFiguresLinkedService.
func (a AppFiguresLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AppFigures"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppFiguresLinkedService.
func (a *AppFiguresLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppFiguresLinkedServiceTypeProperties.
func (a AppFiguresLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientKey", a.ClientKey)
	populate(objectMap, "password", a.Password)
	populateAny(objectMap, "userName", a.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppFiguresLinkedServiceTypeProperties.
func (a *AppFiguresLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientKey":
			a.ClientKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "password":
			a.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &a.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppendVariableActivity.
func (a AppendVariableActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "state", a.State)
	objectMap["type"] = "AppendVariable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppendVariableActivity.
func (a *AppendVariableActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppendVariableActivityTypeProperties.
func (a AppendVariableActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "value", a.Value)
	populate(objectMap, "variableName", a.VariableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppendVariableActivityTypeProperties.
func (a *AppendVariableActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		case "variableName":
			err = unpopulate(val, "VariableName", &a.VariableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmIDWrapper.
func (a ArmIDWrapper) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmIDWrapper.
func (a *ArmIDWrapper) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsanaLinkedService.
func (a AsanaLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "Asana"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsanaLinkedService.
func (a *AsanaLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AsanaLinkedServiceTypeProperties.
func (a AsanaLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiToken", a.APIToken)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AsanaLinkedServiceTypeProperties.
func (a *AsanaLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiToken":
			a.APIToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroDataset.
func (a AvroDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "Avro"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroDataset.
func (a *AvroDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroDatasetTypeProperties.
func (a AvroDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "avroCompressionCodec", a.AvroCompressionCodec)
	populate(objectMap, "avroCompressionLevel", a.AvroCompressionLevel)
	populate(objectMap, "location", a.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroDatasetTypeProperties.
func (a *AvroDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "avroCompressionCodec":
			err = unpopulate(val, "AvroCompressionCodec", &a.AvroCompressionCodec)
			delete(rawMsg, key)
		case "avroCompressionLevel":
			err = unpopulate(val, "AvroCompressionLevel", &a.AvroCompressionLevel)
			delete(rawMsg, key)
		case "location":
			a.Location, err = unmarshalDatasetLocationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroFormat.
func (a AvroFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deserializer", a.Deserializer)
	populateAny(objectMap, "serializer", a.Serializer)
	objectMap["type"] = "AvroFormat"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroFormat.
func (a *AvroFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deserializer":
			err = unpopulate(val, "Deserializer", &a.Deserializer)
			delete(rawMsg, key)
		case "serializer":
			err = unpopulate(val, "Serializer", &a.Serializer)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroSink.
func (a AvroSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populate(objectMap, "formatSettings", a.FormatSettings)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	populate(objectMap, "storeSettings", a.StoreSettings)
	objectMap["type"] = "AvroSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroSink.
func (a *AvroSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "formatSettings":
			err = unpopulate(val, "FormatSettings", &a.FormatSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			a.StoreSettings, err = unmarshalStoreWriteSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroSource.
func (a AvroSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	populate(objectMap, "storeSettings", a.StoreSettings)
	objectMap["type"] = "AvroSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroSource.
func (a *AvroSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			a.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvroWriteSettings.
func (a AvroWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileNamePrefix", a.FileNamePrefix)
	populateAny(objectMap, "maxRowsPerFile", a.MaxRowsPerFile)
	populate(objectMap, "recordName", a.RecordName)
	populate(objectMap, "recordNamespace", a.RecordNamespace)
	objectMap["type"] = "AvroWriteSettings"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvroWriteSettings.
func (a *AvroWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileNamePrefix":
			err = unpopulate(val, "FileNamePrefix", &a.FileNamePrefix)
			delete(rawMsg, key)
		case "maxRowsPerFile":
			err = unpopulate(val, "MaxRowsPerFile", &a.MaxRowsPerFile)
			delete(rawMsg, key)
		case "recordName":
			err = unpopulate(val, "RecordName", &a.RecordName)
			delete(rawMsg, key)
		case "recordNamespace":
			err = unpopulate(val, "RecordNamespace", &a.RecordNamespace)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzPowerShellSetup.
func (a AzPowerShellSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "AzPowerShellSetup"
	populate(objectMap, "typeProperties", a.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzPowerShellSetup.
func (a *AzPowerShellSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzPowerShellSetupTypeProperties.
func (a AzPowerShellSetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzPowerShellSetupTypeProperties.
func (a *AzPowerShellSetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBatchLinkedService.
func (a AzureBatchLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureBatch"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBatchLinkedService.
func (a *AzureBatchLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBatchLinkedServiceTypeProperties.
func (a AzureBatchLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", a.AccessKey)
	populateAny(objectMap, "accountName", a.AccountName)
	populateAny(objectMap, "batchUri", a.BatchURI)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populateAny(objectMap, "poolName", a.PoolName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBatchLinkedServiceTypeProperties.
func (a *AzureBatchLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			a.AccessKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "batchUri":
			err = unpopulate(val, "BatchURI", &a.BatchURI)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "poolName":
			err = unpopulate(val, "PoolName", &a.PoolName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobDataset.
func (a AzureBlobDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureBlob"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobDataset.
func (a *AzureBlobDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobDatasetTypeProperties.
func (a AzureBlobDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", a.Compression)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	populate(objectMap, "format", a.Format)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "tableRootLocation", a.TableRootLocation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobDatasetTypeProperties.
func (a *AzureBlobDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &a.Compression)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "format":
			a.Format, err = unmarshalDatasetStorageFormatClassification(val)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "tableRootLocation":
			err = unpopulate(val, "TableRootLocation", &a.TableRootLocation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSDataset.
func (a AzureBlobFSDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureBlobFSFile"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSDataset.
func (a *AzureBlobFSDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSDatasetTypeProperties.
func (a AzureBlobFSDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", a.Compression)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	populate(objectMap, "format", a.Format)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSDatasetTypeProperties.
func (a *AzureBlobFSDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &a.Compression)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "format":
			a.Format, err = unmarshalDatasetStorageFormatClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSLinkedService.
func (a AzureBlobFSLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureBlobFS"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSLinkedService.
func (a *AzureBlobFSLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSLinkedServiceTypeProperties.
func (a AzureBlobFSLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accountKey", a.AccountKey)
	populateAny(objectMap, "azureCloudType", a.AzureCloudType)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "sasToken", a.SasToken)
	populateAny(objectMap, "sasUri", a.SasURI)
	populate(objectMap, "servicePrincipalCredential", a.ServicePrincipalCredential)
	populateAny(objectMap, "servicePrincipalCredentialType", a.ServicePrincipalCredentialType)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	populateAny(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSLinkedServiceTypeProperties.
func (a *AzureBlobFSLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &a.AzureCloudType)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "sasToken":
			a.SasToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "sasUri":
			err = unpopulate(val, "SasURI", &a.SasURI)
			delete(rawMsg, key)
		case "servicePrincipalCredential":
			a.ServicePrincipalCredential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "servicePrincipalCredentialType":
			err = unpopulate(val, "ServicePrincipalCredentialType", &a.ServicePrincipalCredentialType)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSLocation.
func (a AzureBlobFSLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "fileSystem", a.FileSystem)
	populateAny(objectMap, "folderPath", a.FolderPath)
	objectMap["type"] = "AzureBlobFSLocation"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSLocation.
func (a *AzureBlobFSLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &a.FileSystem)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSReadSettings.
func (a AzureBlobFSReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", a.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", a.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", a.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", a.PartitionRootPath)
	populateAny(objectMap, "recursive", a.Recursive)
	objectMap["type"] = "AzureBlobFSReadSettings"
	populateAny(objectMap, "wildcardFileName", a.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", a.WildcardFolderPath)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSReadSettings.
func (a *AzureBlobFSReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &a.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &a.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &a.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &a.PartitionRootPath)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &a.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &a.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSSink.
func (a AzureBlobFSSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", a.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populate(objectMap, "metadata", a.Metadata)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureBlobFSSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSSink.
func (a *AzureBlobFSSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &a.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &a.Metadata)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSSource.
func (a AzureBlobFSSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "recursive", a.Recursive)
	populateAny(objectMap, "skipHeaderLineCount", a.SkipHeaderLineCount)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	populateAny(objectMap, "treatEmptyAsNull", a.TreatEmptyAsNull)
	objectMap["type"] = "AzureBlobFSSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSSource.
func (a *AzureBlobFSSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "skipHeaderLineCount":
			err = unpopulate(val, "SkipHeaderLineCount", &a.SkipHeaderLineCount)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "treatEmptyAsNull":
			err = unpopulate(val, "TreatEmptyAsNull", &a.TreatEmptyAsNull)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobFSWriteSettings.
func (a AzureBlobFSWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "blockSizeInMB", a.BlockSizeInMB)
	populateAny(objectMap, "copyBehavior", a.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	objectMap["type"] = "AzureBlobFSWriteSettings"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobFSWriteSettings.
func (a *AzureBlobFSWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blockSizeInMB":
			err = unpopulate(val, "BlockSizeInMB", &a.BlockSizeInMB)
			delete(rawMsg, key)
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &a.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageLinkedService.
func (a AzureBlobStorageLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureBlobStorage"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageLinkedService.
func (a *AzureBlobStorageLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageLinkedServiceTypeProperties.
func (a AzureBlobStorageLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", a.AccountKey)
	populateAny(objectMap, "accountKind", a.AccountKind)
	populate(objectMap, "authenticationType", a.AuthenticationType)
	populateAny(objectMap, "azureCloudType", a.AzureCloudType)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populateAny(objectMap, "containerUri", a.ContainerURI)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "sasToken", a.SasToken)
	populateAny(objectMap, "sasUri", a.SasURI)
	populateAny(objectMap, "serviceEndpoint", a.ServiceEndpoint)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageLinkedServiceTypeProperties.
func (a *AzureBlobStorageLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "accountKind":
			err = unpopulate(val, "AccountKind", &a.AccountKind)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &a.AuthenticationType)
			delete(rawMsg, key)
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &a.AzureCloudType)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "containerUri":
			err = unpopulate(val, "ContainerURI", &a.ContainerURI)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &a.SasToken)
			delete(rawMsg, key)
		case "sasUri":
			err = unpopulate(val, "SasURI", &a.SasURI)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &a.ServiceEndpoint)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageLocation.
func (a AzureBlobStorageLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "container", a.Container)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	objectMap["type"] = "AzureBlobStorageLocation"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageLocation.
func (a *AzureBlobStorageLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "container":
			err = unpopulate(val, "Container", &a.Container)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageReadSettings.
func (a AzureBlobStorageReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", a.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", a.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", a.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", a.PartitionRootPath)
	populateAny(objectMap, "prefix", a.Prefix)
	populateAny(objectMap, "recursive", a.Recursive)
	objectMap["type"] = "AzureBlobStorageReadSettings"
	populateAny(objectMap, "wildcardFileName", a.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", a.WildcardFolderPath)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageReadSettings.
func (a *AzureBlobStorageReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &a.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &a.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &a.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &a.PartitionRootPath)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &a.Prefix)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &a.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &a.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobStorageWriteSettings.
func (a AzureBlobStorageWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "blockSizeInMB", a.BlockSizeInMB)
	populateAny(objectMap, "copyBehavior", a.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	objectMap["type"] = "AzureBlobStorageWriteSettings"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobStorageWriteSettings.
func (a *AzureBlobStorageWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blockSizeInMB":
			err = unpopulate(val, "BlockSizeInMB", &a.BlockSizeInMB)
			delete(rawMsg, key)
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &a.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerCommandActivity.
func (a AzureDataExplorerCommandActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "policy", a.Policy)
	populate(objectMap, "state", a.State)
	objectMap["type"] = "AzureDataExplorerCommand"
	populate(objectMap, "typeProperties", a.TypeProperties)
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerCommandActivity.
func (a *AzureDataExplorerCommandActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &a.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerCommandActivityTypeProperties.
func (a AzureDataExplorerCommandActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "command", a.Command)
	populateAny(objectMap, "commandTimeout", a.CommandTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerCommandActivityTypeProperties.
func (a *AzureDataExplorerCommandActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "command":
			err = unpopulate(val, "Command", &a.Command)
			delete(rawMsg, key)
		case "commandTimeout":
			err = unpopulate(val, "CommandTimeout", &a.CommandTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerDatasetTypeProperties.
func (a AzureDataExplorerDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerDatasetTypeProperties.
func (a *AzureDataExplorerDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerLinkedService.
func (a AzureDataExplorerLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureDataExplorer"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerLinkedService.
func (a *AzureDataExplorerLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerLinkedServiceTypeProperties.
func (a AzureDataExplorerLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credential", a.Credential)
	populateAny(objectMap, "database", a.Database)
	populateAny(objectMap, "endpoint", a.Endpoint)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerLinkedServiceTypeProperties.
func (a *AzureDataExplorerLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerSink.
func (a AzureDataExplorerSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "flushImmediately", a.FlushImmediately)
	populateAny(objectMap, "ingestionMappingAsJson", a.IngestionMappingAsJSON)
	populateAny(objectMap, "ingestionMappingName", a.IngestionMappingName)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureDataExplorerSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerSink.
func (a *AzureDataExplorerSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "flushImmediately":
			err = unpopulate(val, "FlushImmediately", &a.FlushImmediately)
			delete(rawMsg, key)
		case "ingestionMappingAsJson":
			err = unpopulate(val, "IngestionMappingAsJSON", &a.IngestionMappingAsJSON)
			delete(rawMsg, key)
		case "ingestionMappingName":
			err = unpopulate(val, "IngestionMappingName", &a.IngestionMappingName)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerSource.
func (a AzureDataExplorerSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "noTruncation", a.NoTruncation)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzureDataExplorerSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerSource.
func (a *AzureDataExplorerSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "noTruncation":
			err = unpopulate(val, "NoTruncation", &a.NoTruncation)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataExplorerTableDataset.
func (a AzureDataExplorerTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureDataExplorerTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataExplorerTableDataset.
func (a *AzureDataExplorerTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeAnalyticsLinkedService.
func (a AzureDataLakeAnalyticsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureDataLakeAnalytics"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeAnalyticsLinkedService.
func (a *AzureDataLakeAnalyticsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeAnalyticsLinkedServiceTypeProperties.
func (a AzureDataLakeAnalyticsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accountName", a.AccountName)
	populateAny(objectMap, "dataLakeAnalyticsUri", a.DataLakeAnalyticsURI)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "resourceGroupName", a.ResourceGroupName)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "subscriptionId", a.SubscriptionID)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeAnalyticsLinkedServiceTypeProperties.
func (a *AzureDataLakeAnalyticsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "dataLakeAnalyticsUri":
			err = unpopulate(val, "DataLakeAnalyticsURI", &a.DataLakeAnalyticsURI)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &a.ResourceGroupName)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreDataset.
func (a AzureDataLakeStoreDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureDataLakeStoreFile"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreDataset.
func (a *AzureDataLakeStoreDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreDatasetTypeProperties.
func (a AzureDataLakeStoreDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", a.Compression)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	populate(objectMap, "format", a.Format)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreDatasetTypeProperties.
func (a *AzureDataLakeStoreDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &a.Compression)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "format":
			a.Format, err = unmarshalDatasetStorageFormatClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreLinkedService.
func (a AzureDataLakeStoreLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureDataLakeStore"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreLinkedService.
func (a *AzureDataLakeStoreLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreLinkedServiceTypeProperties.
func (a AzureDataLakeStoreLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accountName", a.AccountName)
	populateAny(objectMap, "azureCloudType", a.AzureCloudType)
	populate(objectMap, "credential", a.Credential)
	populateAny(objectMap, "dataLakeStoreUri", a.DataLakeStoreURI)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "resourceGroupName", a.ResourceGroupName)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "subscriptionId", a.SubscriptionID)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreLinkedServiceTypeProperties.
func (a *AzureDataLakeStoreLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &a.AzureCloudType)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "dataLakeStoreUri":
			err = unpopulate(val, "DataLakeStoreURI", &a.DataLakeStoreURI)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &a.ResourceGroupName)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreLocation.
func (a AzureDataLakeStoreLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	objectMap["type"] = "AzureDataLakeStoreLocation"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreLocation.
func (a *AzureDataLakeStoreLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreReadSettings.
func (a AzureDataLakeStoreReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", a.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", a.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", a.FileListPath)
	populateAny(objectMap, "listAfter", a.ListAfter)
	populateAny(objectMap, "listBefore", a.ListBefore)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", a.PartitionRootPath)
	populateAny(objectMap, "recursive", a.Recursive)
	objectMap["type"] = "AzureDataLakeStoreReadSettings"
	populateAny(objectMap, "wildcardFileName", a.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", a.WildcardFolderPath)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreReadSettings.
func (a *AzureDataLakeStoreReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &a.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &a.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &a.FileListPath)
			delete(rawMsg, key)
		case "listAfter":
			err = unpopulate(val, "ListAfter", &a.ListAfter)
			delete(rawMsg, key)
		case "listBefore":
			err = unpopulate(val, "ListBefore", &a.ListBefore)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &a.PartitionRootPath)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &a.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &a.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreSink.
func (a AzureDataLakeStoreSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", a.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enableAdlsSingleFileParallel", a.EnableAdlsSingleFileParallel)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureDataLakeStoreSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreSink.
func (a *AzureDataLakeStoreSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &a.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enableAdlsSingleFileParallel":
			err = unpopulate(val, "EnableAdlsSingleFileParallel", &a.EnableAdlsSingleFileParallel)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreSource.
func (a AzureDataLakeStoreSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "recursive", a.Recursive)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzureDataLakeStoreSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreSource.
func (a *AzureDataLakeStoreSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeStoreWriteSettings.
func (a AzureDataLakeStoreWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", a.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "expiryDateTime", a.ExpiryDateTime)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	objectMap["type"] = "AzureDataLakeStoreWriteSettings"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeStoreWriteSettings.
func (a *AzureDataLakeStoreWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &a.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "expiryDateTime":
			err = unpopulate(val, "ExpiryDateTime", &a.ExpiryDateTime)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeDataset.
func (a AzureDatabricksDeltaLakeDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureDatabricksDeltaLakeDataset"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeDataset.
func (a *AzureDatabricksDeltaLakeDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeDatasetTypeProperties.
func (a AzureDatabricksDeltaLakeDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "database", a.Database)
	populateAny(objectMap, "table", a.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeDatasetTypeProperties.
func (a *AzureDatabricksDeltaLakeDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "database":
			err = unpopulate(val, "Database", &a.Database)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeExportCommand.
func (a AzureDatabricksDeltaLakeExportCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "dateFormat", a.DateFormat)
	populateAny(objectMap, "timestampFormat", a.TimestampFormat)
	objectMap["type"] = "AzureDatabricksDeltaLakeExportCommand"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeExportCommand.
func (a *AzureDatabricksDeltaLakeExportCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &a.DateFormat)
			delete(rawMsg, key)
		case "timestampFormat":
			err = unpopulate(val, "TimestampFormat", &a.TimestampFormat)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeImportCommand.
func (a AzureDatabricksDeltaLakeImportCommand) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "dateFormat", a.DateFormat)
	populateAny(objectMap, "timestampFormat", a.TimestampFormat)
	objectMap["type"] = "AzureDatabricksDeltaLakeImportCommand"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeImportCommand.
func (a *AzureDatabricksDeltaLakeImportCommand) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dateFormat":
			err = unpopulate(val, "DateFormat", &a.DateFormat)
			delete(rawMsg, key)
		case "timestampFormat":
			err = unpopulate(val, "TimestampFormat", &a.TimestampFormat)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeLinkedService.
func (a AzureDatabricksDeltaLakeLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureDatabricksDeltaLake"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeLinkedService.
func (a *AzureDatabricksDeltaLakeLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeSink.
func (a AzureDatabricksDeltaLakeSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populate(objectMap, "importSettings", a.ImportSettings)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "preCopyScript", a.PreCopyScript)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureDatabricksDeltaLakeSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeSink.
func (a *AzureDatabricksDeltaLakeSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "importSettings":
			err = unpopulate(val, "ImportSettings", &a.ImportSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "preCopyScript":
			err = unpopulate(val, "PreCopyScript", &a.PreCopyScript)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDeltaLakeSource.
func (a AzureDatabricksDeltaLakeSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populate(objectMap, "exportSettings", a.ExportSettings)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzureDatabricksDeltaLakeSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDeltaLakeSource.
func (a *AzureDatabricksDeltaLakeSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "exportSettings":
			err = unpopulate(val, "ExportSettings", &a.ExportSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksDetltaLakeLinkedServiceTypeProperties.
func (a AzureDatabricksDetltaLakeLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", a.AccessToken)
	populateAny(objectMap, "clusterId", a.ClusterID)
	populate(objectMap, "credential", a.Credential)
	populateAny(objectMap, "domain", a.Domain)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "workspaceResourceId", a.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksDetltaLakeLinkedServiceTypeProperties.
func (a *AzureDatabricksDetltaLakeLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			a.AccessToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "clusterId":
			err = unpopulate(val, "ClusterID", &a.ClusterID)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "domain":
			err = unpopulate(val, "Domain", &a.Domain)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "workspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &a.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksLinkedService.
func (a AzureDatabricksLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureDatabricks"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksLinkedService.
func (a *AzureDatabricksLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDatabricksLinkedServiceTypeProperties.
func (a AzureDatabricksLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", a.AccessToken)
	populateAny(objectMap, "authentication", a.Authentication)
	populate(objectMap, "credential", a.Credential)
	populateAny(objectMap, "domain", a.Domain)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "existingClusterId", a.ExistingClusterID)
	populateAny(objectMap, "instancePoolId", a.InstancePoolID)
	populate(objectMap, "newClusterCustomTags", a.NewClusterCustomTags)
	populateAny(objectMap, "newClusterDriverNodeType", a.NewClusterDriverNodeType)
	populateAny(objectMap, "newClusterEnableElasticDisk", a.NewClusterEnableElasticDisk)
	populateAny(objectMap, "newClusterInitScripts", a.NewClusterInitScripts)
	populateAny(objectMap, "newClusterLogDestination", a.NewClusterLogDestination)
	populateAny(objectMap, "newClusterNodeType", a.NewClusterNodeType)
	populateAny(objectMap, "newClusterNumOfWorker", a.NewClusterNumOfWorker)
	populate(objectMap, "newClusterSparkConf", a.NewClusterSparkConf)
	populate(objectMap, "newClusterSparkEnvVars", a.NewClusterSparkEnvVars)
	populateAny(objectMap, "newClusterVersion", a.NewClusterVersion)
	populateAny(objectMap, "policyId", a.PolicyID)
	populateAny(objectMap, "workspaceResourceId", a.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDatabricksLinkedServiceTypeProperties.
func (a *AzureDatabricksLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			a.AccessToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "authentication":
			err = unpopulate(val, "Authentication", &a.Authentication)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "domain":
			err = unpopulate(val, "Domain", &a.Domain)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "existingClusterId":
			err = unpopulate(val, "ExistingClusterID", &a.ExistingClusterID)
			delete(rawMsg, key)
		case "instancePoolId":
			err = unpopulate(val, "InstancePoolID", &a.InstancePoolID)
			delete(rawMsg, key)
		case "newClusterCustomTags":
			err = unpopulate(val, "NewClusterCustomTags", &a.NewClusterCustomTags)
			delete(rawMsg, key)
		case "newClusterDriverNodeType":
			err = unpopulate(val, "NewClusterDriverNodeType", &a.NewClusterDriverNodeType)
			delete(rawMsg, key)
		case "newClusterEnableElasticDisk":
			err = unpopulate(val, "NewClusterEnableElasticDisk", &a.NewClusterEnableElasticDisk)
			delete(rawMsg, key)
		case "newClusterInitScripts":
			err = unpopulate(val, "NewClusterInitScripts", &a.NewClusterInitScripts)
			delete(rawMsg, key)
		case "newClusterLogDestination":
			err = unpopulate(val, "NewClusterLogDestination", &a.NewClusterLogDestination)
			delete(rawMsg, key)
		case "newClusterNodeType":
			err = unpopulate(val, "NewClusterNodeType", &a.NewClusterNodeType)
			delete(rawMsg, key)
		case "newClusterNumOfWorker":
			err = unpopulate(val, "NewClusterNumOfWorker", &a.NewClusterNumOfWorker)
			delete(rawMsg, key)
		case "newClusterSparkConf":
			err = unpopulate(val, "NewClusterSparkConf", &a.NewClusterSparkConf)
			delete(rawMsg, key)
		case "newClusterSparkEnvVars":
			err = unpopulate(val, "NewClusterSparkEnvVars", &a.NewClusterSparkEnvVars)
			delete(rawMsg, key)
		case "newClusterVersion":
			err = unpopulate(val, "NewClusterVersion", &a.NewClusterVersion)
			delete(rawMsg, key)
		case "policyId":
			err = unpopulate(val, "PolicyID", &a.PolicyID)
			delete(rawMsg, key)
		case "workspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &a.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileStorageLinkedService.
func (a AzureFileStorageLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureFileStorage"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileStorageLinkedService.
func (a *AzureFileStorageLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileStorageLinkedServiceTypeProperties.
func (a AzureFileStorageLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", a.AccountKey)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "fileShare", a.FileShare)
	populateAny(objectMap, "host", a.Host)
	populate(objectMap, "password", a.Password)
	populate(objectMap, "sasToken", a.SasToken)
	populateAny(objectMap, "sasUri", a.SasURI)
	populateAny(objectMap, "snapshot", a.Snapshot)
	populateAny(objectMap, "userId", a.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileStorageLinkedServiceTypeProperties.
func (a *AzureFileStorageLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "fileShare":
			err = unpopulate(val, "FileShare", &a.FileShare)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &a.Host)
			delete(rawMsg, key)
		case "password":
			a.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &a.SasToken)
			delete(rawMsg, key)
		case "sasUri":
			err = unpopulate(val, "SasURI", &a.SasURI)
			delete(rawMsg, key)
		case "snapshot":
			err = unpopulate(val, "Snapshot", &a.Snapshot)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &a.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileStorageLocation.
func (a AzureFileStorageLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", a.FileName)
	populateAny(objectMap, "folderPath", a.FolderPath)
	objectMap["type"] = "AzureFileStorageLocation"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileStorageLocation.
func (a *AzureFileStorageLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &a.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileStorageReadSettings.
func (a AzureFileStorageReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", a.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", a.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", a.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", a.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", a.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", a.PartitionRootPath)
	populateAny(objectMap, "prefix", a.Prefix)
	populateAny(objectMap, "recursive", a.Recursive)
	objectMap["type"] = "AzureFileStorageReadSettings"
	populateAny(objectMap, "wildcardFileName", a.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", a.WildcardFolderPath)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileStorageReadSettings.
func (a *AzureFileStorageReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &a.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &a.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &a.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &a.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &a.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &a.PartitionRootPath)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &a.Prefix)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &a.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &a.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &a.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileStorageWriteSettings.
func (a AzureFileStorageWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", a.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	objectMap["type"] = "AzureFileStorageWriteSettings"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileStorageWriteSettings.
func (a *AzureFileStorageWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &a.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionActivity.
func (a AzureFunctionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "policy", a.Policy)
	populate(objectMap, "state", a.State)
	objectMap["type"] = "AzureFunctionActivity"
	populate(objectMap, "typeProperties", a.TypeProperties)
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionActivity.
func (a *AzureFunctionActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &a.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionActivityTypeProperties.
func (a AzureFunctionActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "body", a.Body)
	populateAny(objectMap, "functionName", a.FunctionName)
	populateAny(objectMap, "headers", a.Headers)
	populate(objectMap, "method", a.Method)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionActivityTypeProperties.
func (a *AzureFunctionActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "body":
			err = unpopulate(val, "Body", &a.Body)
			delete(rawMsg, key)
		case "functionName":
			err = unpopulate(val, "FunctionName", &a.FunctionName)
			delete(rawMsg, key)
		case "headers":
			err = unpopulate(val, "Headers", &a.Headers)
			delete(rawMsg, key)
		case "method":
			err = unpopulate(val, "Method", &a.Method)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionLinkedService.
func (a AzureFunctionLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureFunction"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionLinkedService.
func (a *AzureFunctionLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFunctionLinkedServiceTypeProperties.
func (a AzureFunctionLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authentication", a.Authentication)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "functionAppUrl", a.FunctionAppURL)
	populate(objectMap, "functionKey", a.FunctionKey)
	populateAny(objectMap, "resourceId", a.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFunctionLinkedServiceTypeProperties.
func (a *AzureFunctionLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &a.Authentication)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "functionAppUrl":
			err = unpopulate(val, "FunctionAppURL", &a.FunctionAppURL)
			delete(rawMsg, key)
		case "functionKey":
			a.FunctionKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureKeyVaultLinkedService.
func (a AzureKeyVaultLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureKeyVault"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureKeyVaultLinkedService.
func (a *AzureKeyVaultLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureKeyVaultLinkedServiceTypeProperties.
func (a AzureKeyVaultLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "baseUrl", a.BaseURL)
	populate(objectMap, "credential", a.Credential)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureKeyVaultLinkedServiceTypeProperties.
func (a *AzureKeyVaultLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseUrl":
			err = unpopulate(val, "BaseURL", &a.BaseURL)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureKeyVaultSecretReference.
func (a AzureKeyVaultSecretReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "secretName", a.SecretName)
	populateAny(objectMap, "secretVersion", a.SecretVersion)
	populate(objectMap, "store", a.Store)
	objectMap["type"] = "AzureKeyVaultSecret"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureKeyVaultSecretReference.
func (a *AzureKeyVaultSecretReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretName":
			err = unpopulate(val, "SecretName", &a.SecretName)
			delete(rawMsg, key)
		case "secretVersion":
			err = unpopulate(val, "SecretVersion", &a.SecretVersion)
			delete(rawMsg, key)
		case "store":
			err = unpopulate(val, "Store", &a.Store)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLBatchExecutionActivity.
func (a AzureMLBatchExecutionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "policy", a.Policy)
	populate(objectMap, "state", a.State)
	objectMap["type"] = "AzureMLBatchExecution"
	populate(objectMap, "typeProperties", a.TypeProperties)
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLBatchExecutionActivity.
func (a *AzureMLBatchExecutionActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &a.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLBatchExecutionActivityTypeProperties.
func (a AzureMLBatchExecutionActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "globalParameters", a.GlobalParameters)
	populate(objectMap, "webServiceInputs", a.WebServiceInputs)
	populate(objectMap, "webServiceOutputs", a.WebServiceOutputs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLBatchExecutionActivityTypeProperties.
func (a *AzureMLBatchExecutionActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "globalParameters":
			err = unpopulate(val, "GlobalParameters", &a.GlobalParameters)
			delete(rawMsg, key)
		case "webServiceInputs":
			err = unpopulate(val, "WebServiceInputs", &a.WebServiceInputs)
			delete(rawMsg, key)
		case "webServiceOutputs":
			err = unpopulate(val, "WebServiceOutputs", &a.WebServiceOutputs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLExecutePipelineActivity.
func (a AzureMLExecutePipelineActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "policy", a.Policy)
	populate(objectMap, "state", a.State)
	objectMap["type"] = "AzureMLExecutePipeline"
	populate(objectMap, "typeProperties", a.TypeProperties)
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLExecutePipelineActivity.
func (a *AzureMLExecutePipelineActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &a.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLExecutePipelineActivityTypeProperties.
func (a AzureMLExecutePipelineActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "continueOnStepFailure", a.ContinueOnStepFailure)
	populateAny(objectMap, "dataPathAssignments", a.DataPathAssignments)
	populateAny(objectMap, "experimentName", a.ExperimentName)
	populateAny(objectMap, "mlParentRunId", a.MlParentRunID)
	populateAny(objectMap, "mlPipelineEndpointId", a.MlPipelineEndpointID)
	populateAny(objectMap, "mlPipelineId", a.MlPipelineID)
	populateAny(objectMap, "mlPipelineParameters", a.MlPipelineParameters)
	populateAny(objectMap, "version", a.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLExecutePipelineActivityTypeProperties.
func (a *AzureMLExecutePipelineActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "continueOnStepFailure":
			err = unpopulate(val, "ContinueOnStepFailure", &a.ContinueOnStepFailure)
			delete(rawMsg, key)
		case "dataPathAssignments":
			err = unpopulate(val, "DataPathAssignments", &a.DataPathAssignments)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &a.ExperimentName)
			delete(rawMsg, key)
		case "mlParentRunId":
			err = unpopulate(val, "MlParentRunID", &a.MlParentRunID)
			delete(rawMsg, key)
		case "mlPipelineEndpointId":
			err = unpopulate(val, "MlPipelineEndpointID", &a.MlPipelineEndpointID)
			delete(rawMsg, key)
		case "mlPipelineId":
			err = unpopulate(val, "MlPipelineID", &a.MlPipelineID)
			delete(rawMsg, key)
		case "mlPipelineParameters":
			err = unpopulate(val, "MlPipelineParameters", &a.MlPipelineParameters)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &a.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLLinkedService.
func (a AzureMLLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureML"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLLinkedService.
func (a *AzureMLLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLLinkedServiceTypeProperties.
func (a AzureMLLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiKey", a.APIKey)
	populateAny(objectMap, "authentication", a.Authentication)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "mlEndpoint", a.MlEndpoint)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	populateAny(objectMap, "updateResourceEndpoint", a.UpdateResourceEndpoint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLLinkedServiceTypeProperties.
func (a *AzureMLLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiKey":
			a.APIKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "authentication":
			err = unpopulate(val, "Authentication", &a.Authentication)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "mlEndpoint":
			err = unpopulate(val, "MlEndpoint", &a.MlEndpoint)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		case "updateResourceEndpoint":
			err = unpopulate(val, "UpdateResourceEndpoint", &a.UpdateResourceEndpoint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLServiceLinkedService.
func (a AzureMLServiceLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureMLService"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLServiceLinkedService.
func (a *AzureMLServiceLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLServiceLinkedServiceTypeProperties.
func (a AzureMLServiceLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authentication", a.Authentication)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populateAny(objectMap, "mlWorkspaceName", a.MlWorkspaceName)
	populateAny(objectMap, "resourceGroupName", a.ResourceGroupName)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "subscriptionId", a.SubscriptionID)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLServiceLinkedServiceTypeProperties.
func (a *AzureMLServiceLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &a.Authentication)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "mlWorkspaceName":
			err = unpopulate(val, "MlWorkspaceName", &a.MlWorkspaceName)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &a.ResourceGroupName)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLUpdateResourceActivity.
func (a AzureMLUpdateResourceActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", a.DependsOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "onInactiveMarkAs", a.OnInactiveMarkAs)
	populate(objectMap, "policy", a.Policy)
	populate(objectMap, "state", a.State)
	objectMap["type"] = "AzureMLUpdateResource"
	populate(objectMap, "typeProperties", a.TypeProperties)
	populate(objectMap, "userProperties", a.UserProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLUpdateResourceActivity.
func (a *AzureMLUpdateResourceActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &a.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &a.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &a.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &a.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &a.UserProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLUpdateResourceActivityTypeProperties.
func (a AzureMLUpdateResourceActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "trainedModelFilePath", a.TrainedModelFilePath)
	populate(objectMap, "trainedModelLinkedServiceName", a.TrainedModelLinkedServiceName)
	populateAny(objectMap, "trainedModelName", a.TrainedModelName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLUpdateResourceActivityTypeProperties.
func (a *AzureMLUpdateResourceActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "trainedModelFilePath":
			err = unpopulate(val, "TrainedModelFilePath", &a.TrainedModelFilePath)
			delete(rawMsg, key)
		case "trainedModelLinkedServiceName":
			err = unpopulate(val, "TrainedModelLinkedServiceName", &a.TrainedModelLinkedServiceName)
			delete(rawMsg, key)
		case "trainedModelName":
			err = unpopulate(val, "TrainedModelName", &a.TrainedModelName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMLWebServiceFile.
func (a AzureMLWebServiceFile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "filePath", a.FilePath)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMLWebServiceFile.
func (a *AzureMLWebServiceFile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filePath":
			err = unpopulate(val, "FilePath", &a.FilePath)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMariaDBLinkedService.
func (a AzureMariaDBLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureMariaDB"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMariaDBLinkedService.
func (a *AzureMariaDBLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMariaDBLinkedServiceTypeProperties.
func (a AzureMariaDBLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "pwd", a.Pwd)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMariaDBLinkedServiceTypeProperties.
func (a *AzureMariaDBLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "pwd":
			err = unpopulate(val, "Pwd", &a.Pwd)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMariaDBSource.
func (a AzureMariaDBSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzureMariaDBSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMariaDBSource.
func (a *AzureMariaDBSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMariaDBTableDataset.
func (a AzureMariaDBTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureMariaDBTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMariaDBTableDataset.
func (a *AzureMariaDBTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMySQLLinkedService.
func (a AzureMySQLLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureMySql"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMySQLLinkedService.
func (a *AzureMySQLLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMySQLLinkedServiceTypeProperties.
func (a AzureMySQLLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMySQLLinkedServiceTypeProperties.
func (a *AzureMySQLLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMySQLSink.
func (a AzureMySQLSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "preCopyScript", a.PreCopyScript)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureMySqlSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMySQLSink.
func (a *AzureMySQLSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "preCopyScript":
			err = unpopulate(val, "PreCopyScript", &a.PreCopyScript)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMySQLSource.
func (a AzureMySQLSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzureMySqlSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMySQLSource.
func (a *AzureMySQLSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMySQLTableDataset.
func (a AzureMySQLTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureMySqlTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMySQLTableDataset.
func (a *AzureMySQLTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureMySQLTableDatasetTypeProperties.
func (a AzureMySQLTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "table", a.Table)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureMySQLTableDatasetTypeProperties.
func (a *AzureMySQLTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePostgreSQLLinkedService.
func (a AzurePostgreSQLLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzurePostgreSql"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePostgreSQLLinkedService.
func (a *AzurePostgreSQLLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePostgreSQLLinkedServiceTypeProperties.
func (a AzurePostgreSQLLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePostgreSQLLinkedServiceTypeProperties.
func (a *AzurePostgreSQLLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePostgreSQLSink.
func (a AzurePostgreSQLSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "preCopyScript", a.PreCopyScript)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzurePostgreSqlSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePostgreSQLSink.
func (a *AzurePostgreSQLSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "preCopyScript":
			err = unpopulate(val, "PreCopyScript", &a.PreCopyScript)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePostgreSQLSource.
func (a AzurePostgreSQLSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "query", a.Query)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzurePostgreSqlSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePostgreSQLSource.
func (a *AzurePostgreSQLSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &a.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePostgreSQLTableDataset.
func (a AzurePostgreSQLTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzurePostgreSqlTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePostgreSQLTableDataset.
func (a *AzurePostgreSQLTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzurePostgreSQLTableDatasetTypeProperties.
func (a AzurePostgreSQLTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzurePostgreSQLTableDatasetTypeProperties.
func (a *AzurePostgreSQLTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureQueueSink.
func (a AzureQueueSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureQueueSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureQueueSink.
func (a *AzureQueueSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDWLinkedService.
func (a AzureSQLDWLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureSqlDW"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDWLinkedService.
func (a *AzureSQLDWLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDWLinkedServiceTypeProperties.
func (a AzureSQLDWLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "azureCloudType", a.AzureCloudType)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDWLinkedServiceTypeProperties.
func (a *AzureSQLDWLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &a.AzureCloudType)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDWTableDataset.
func (a AzureSQLDWTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureSqlDWTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDWTableDataset.
func (a *AzureSQLDWTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDWTableDatasetTypeProperties.
func (a AzureSQLDWTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDWTableDatasetTypeProperties.
func (a *AzureSQLDWTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDatabaseLinkedService.
func (a AzureSQLDatabaseLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureSqlDatabase"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDatabaseLinkedService.
func (a *AzureSQLDatabaseLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLDatabaseLinkedServiceTypeProperties.
func (a AzureSQLDatabaseLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alwaysEncryptedSettings", a.AlwaysEncryptedSettings)
	populateAny(objectMap, "azureCloudType", a.AzureCloudType)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLDatabaseLinkedServiceTypeProperties.
func (a *AzureSQLDatabaseLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alwaysEncryptedSettings":
			err = unpopulate(val, "AlwaysEncryptedSettings", &a.AlwaysEncryptedSettings)
			delete(rawMsg, key)
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &a.AzureCloudType)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLMILinkedService.
func (a AzureSQLMILinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureSqlMI"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLMILinkedService.
func (a *AzureSQLMILinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLMILinkedServiceTypeProperties.
func (a AzureSQLMILinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "alwaysEncryptedSettings", a.AlwaysEncryptedSettings)
	populateAny(objectMap, "azureCloudType", a.AzureCloudType)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "credential", a.Credential)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "password", a.Password)
	populateAny(objectMap, "servicePrincipalId", a.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", a.ServicePrincipalKey)
	populateAny(objectMap, "tenant", a.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLMILinkedServiceTypeProperties.
func (a *AzureSQLMILinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alwaysEncryptedSettings":
			err = unpopulate(val, "AlwaysEncryptedSettings", &a.AlwaysEncryptedSettings)
			delete(rawMsg, key)
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &a.AzureCloudType)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &a.Credential)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &a.Password)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &a.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			a.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &a.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLMITableDataset.
func (a AzureSQLMITableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureSqlMITable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLMITableDataset.
func (a *AzureSQLMITableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLMITableDatasetTypeProperties.
func (a AzureSQLMITableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLMITableDatasetTypeProperties.
func (a *AzureSQLMITableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLSink.
func (a AzureSQLSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "preCopyScript", a.PreCopyScript)
	populateAny(objectMap, "sqlWriterStoredProcedureName", a.SQLWriterStoredProcedureName)
	populateAny(objectMap, "sqlWriterTableType", a.SQLWriterTableType)
	populateAny(objectMap, "sqlWriterUseTableLock", a.SQLWriterUseTableLock)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	populateAny(objectMap, "storedProcedureParameters", a.StoredProcedureParameters)
	populateAny(objectMap, "storedProcedureTableTypeParameterName", a.StoredProcedureTableTypeParameterName)
	populateAny(objectMap, "tableOption", a.TableOption)
	objectMap["type"] = "AzureSqlSink"
	populate(objectMap, "upsertSettings", a.UpsertSettings)
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	populateAny(objectMap, "writeBehavior", a.WriteBehavior)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLSink.
func (a *AzureSQLSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "preCopyScript":
			err = unpopulate(val, "PreCopyScript", &a.PreCopyScript)
			delete(rawMsg, key)
		case "sqlWriterStoredProcedureName":
			err = unpopulate(val, "SQLWriterStoredProcedureName", &a.SQLWriterStoredProcedureName)
			delete(rawMsg, key)
		case "sqlWriterTableType":
			err = unpopulate(val, "SQLWriterTableType", &a.SQLWriterTableType)
			delete(rawMsg, key)
		case "sqlWriterUseTableLock":
			err = unpopulate(val, "SQLWriterUseTableLock", &a.SQLWriterUseTableLock)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "storedProcedureParameters":
			err = unpopulate(val, "StoredProcedureParameters", &a.StoredProcedureParameters)
			delete(rawMsg, key)
		case "storedProcedureTableTypeParameterName":
			err = unpopulate(val, "StoredProcedureTableTypeParameterName", &a.StoredProcedureTableTypeParameterName)
			delete(rawMsg, key)
		case "tableOption":
			err = unpopulate(val, "TableOption", &a.TableOption)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "upsertSettings":
			err = unpopulate(val, "UpsertSettings", &a.UpsertSettings)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &a.WriteBehavior)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLSource.
func (a AzureSQLSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "isolationLevel", a.IsolationLevel)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "partitionOption", a.PartitionOption)
	populate(objectMap, "partitionSettings", a.PartitionSettings)
	populateAny(objectMap, "produceAdditionalTypes", a.ProduceAdditionalTypes)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sqlReaderQuery", a.SQLReaderQuery)
	populateAny(objectMap, "sqlReaderStoredProcedureName", a.SQLReaderStoredProcedureName)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	populateAny(objectMap, "storedProcedureParameters", a.StoredProcedureParameters)
	objectMap["type"] = "AzureSqlSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLSource.
func (a *AzureSQLSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "isolationLevel":
			err = unpopulate(val, "IsolationLevel", &a.IsolationLevel)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "partitionOption":
			err = unpopulate(val, "PartitionOption", &a.PartitionOption)
			delete(rawMsg, key)
		case "partitionSettings":
			err = unpopulate(val, "PartitionSettings", &a.PartitionSettings)
			delete(rawMsg, key)
		case "produceAdditionalTypes":
			err = unpopulate(val, "ProduceAdditionalTypes", &a.ProduceAdditionalTypes)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sqlReaderQuery":
			err = unpopulate(val, "SQLReaderQuery", &a.SQLReaderQuery)
			delete(rawMsg, key)
		case "sqlReaderStoredProcedureName":
			err = unpopulate(val, "SQLReaderStoredProcedureName", &a.SQLReaderStoredProcedureName)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "storedProcedureParameters":
			err = unpopulate(val, "StoredProcedureParameters", &a.StoredProcedureParameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLTableDataset.
func (a AzureSQLTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureSqlTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLTableDataset.
func (a *AzureSQLTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSQLTableDatasetTypeProperties.
func (a AzureSQLTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "table", a.Table)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSQLTableDatasetTypeProperties.
func (a *AzureSQLTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &a.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchIndexDataset.
func (a AzureSearchIndexDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureSearchIndex"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchIndexDataset.
func (a *AzureSearchIndexDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchIndexDatasetTypeProperties.
func (a AzureSearchIndexDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "indexName", a.IndexName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchIndexDatasetTypeProperties.
func (a *AzureSearchIndexDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "indexName":
			err = unpopulate(val, "IndexName", &a.IndexName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchIndexSink.
func (a AzureSearchIndexSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureSearchIndexSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	populate(objectMap, "writeBehavior", a.WriteBehavior)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchIndexSink.
func (a *AzureSearchIndexSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &a.WriteBehavior)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchLinkedService.
func (a AzureSearchLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureSearch"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchLinkedService.
func (a *AzureSearchLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSearchLinkedServiceTypeProperties.
func (a AzureSearchLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "key", a.Key)
	populateAny(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSearchLinkedServiceTypeProperties.
func (a *AzureSearchLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "key":
			a.Key, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageLinkedService.
func (a AzureStorageLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureStorage"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageLinkedService.
func (a *AzureStorageLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureStorageLinkedServiceTypeProperties.
func (a AzureStorageLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", a.AccountKey)
	populateAny(objectMap, "connectionString", a.ConnectionString)
	populate(objectMap, "encryptedCredential", a.EncryptedCredential)
	populate(objectMap, "sasToken", a.SasToken)
	populateAny(objectMap, "sasUri", a.SasURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureStorageLinkedServiceTypeProperties.
func (a *AzureStorageLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &a.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &a.EncryptedCredential)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &a.SasToken)
			delete(rawMsg, key)
		case "sasUri":
			err = unpopulate(val, "SasURI", &a.SasURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSynapseArtifactsLinkedService.
func (a AzureSynapseArtifactsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureSynapseArtifacts"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSynapseArtifactsLinkedService.
func (a *AzureSynapseArtifactsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureSynapseArtifactsLinkedServiceTypeProperties.
func (a AzureSynapseArtifactsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authentication", a.Authentication)
	populateAny(objectMap, "endpoint", a.Endpoint)
	populateAny(objectMap, "workspaceResourceId", a.WorkspaceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureSynapseArtifactsLinkedServiceTypeProperties.
func (a *AzureSynapseArtifactsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authentication":
			err = unpopulate(val, "Authentication", &a.Authentication)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "workspaceResourceId":
			err = unpopulate(val, "WorkspaceResourceID", &a.WorkspaceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableDataset.
func (a AzureTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "folder", a.Folder)
	populate(objectMap, "linkedServiceName", a.LinkedServiceName)
	populate(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "schema", a.Schema)
	populateAny(objectMap, "structure", a.Structure)
	objectMap["type"] = "AzureTable"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableDataset.
func (a *AzureTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &a.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &a.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &a.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &a.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableDatasetTypeProperties.
func (a AzureTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "tableName", a.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableDatasetTypeProperties.
func (a *AzureTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tableName":
			err = unpopulate(val, "TableName", &a.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableSink.
func (a AzureTableSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "azureTableDefaultPartitionKeyValue", a.AzureTableDefaultPartitionKeyValue)
	populateAny(objectMap, "azureTableInsertType", a.AzureTableInsertType)
	populateAny(objectMap, "azureTablePartitionKeyName", a.AzureTablePartitionKeyName)
	populateAny(objectMap, "azureTableRowKeyName", a.AzureTableRowKeyName)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", a.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", a.SinkRetryWait)
	objectMap["type"] = "AzureTableSink"
	populateAny(objectMap, "writeBatchSize", a.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", a.WriteBatchTimeout)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableSink.
func (a *AzureTableSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureTableDefaultPartitionKeyValue":
			err = unpopulate(val, "AzureTableDefaultPartitionKeyValue", &a.AzureTableDefaultPartitionKeyValue)
			delete(rawMsg, key)
		case "azureTableInsertType":
			err = unpopulate(val, "AzureTableInsertType", &a.AzureTableInsertType)
			delete(rawMsg, key)
		case "azureTablePartitionKeyName":
			err = unpopulate(val, "AzureTablePartitionKeyName", &a.AzureTablePartitionKeyName)
			delete(rawMsg, key)
		case "azureTableRowKeyName":
			err = unpopulate(val, "AzureTableRowKeyName", &a.AzureTableRowKeyName)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &a.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &a.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &a.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &a.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableSource.
func (a AzureTableSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", a.AdditionalColumns)
	populateAny(objectMap, "azureTableSourceIgnoreTableNotFound", a.AzureTableSourceIgnoreTableNotFound)
	populateAny(objectMap, "azureTableSourceQuery", a.AzureTableSourceQuery)
	populateAny(objectMap, "disableMetricsCollection", a.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", a.MaxConcurrentConnections)
	populateAny(objectMap, "queryTimeout", a.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", a.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", a.SourceRetryWait)
	objectMap["type"] = "AzureTableSource"
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableSource.
func (a *AzureTableSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &a.AdditionalColumns)
			delete(rawMsg, key)
		case "azureTableSourceIgnoreTableNotFound":
			err = unpopulate(val, "AzureTableSourceIgnoreTableNotFound", &a.AzureTableSourceIgnoreTableNotFound)
			delete(rawMsg, key)
		case "azureTableSourceQuery":
			err = unpopulate(val, "AzureTableSourceQuery", &a.AzureTableSourceQuery)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &a.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &a.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &a.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &a.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &a.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureTableStorageLinkedService.
func (a AzureTableStorageLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", a.Annotations)
	populate(objectMap, "connectVia", a.ConnectVia)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "parameters", a.Parameters)
	objectMap["type"] = "AzureTableStorage"
	populate(objectMap, "typeProperties", a.TypeProperties)
	if a.AdditionalProperties != nil {
		for key, val := range a.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureTableStorageLinkedService.
func (a *AzureTableStorageLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &a.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &a.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &a.TypeProperties)
			delete(rawMsg, key)
		default:
			if a.AdditionalProperties == nil {
				a.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				a.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BigDataPoolParametrizationReference.
func (b BigDataPoolParametrizationReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "referenceName", b.ReferenceName)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BigDataPoolParametrizationReference.
func (b *BigDataPoolParametrizationReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &b.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryDataset.
func (b BinaryDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", b.Annotations)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "folder", b.Folder)
	populate(objectMap, "linkedServiceName", b.LinkedServiceName)
	populate(objectMap, "parameters", b.Parameters)
	populateAny(objectMap, "schema", b.Schema)
	populateAny(objectMap, "structure", b.Structure)
	objectMap["type"] = "Binary"
	populate(objectMap, "typeProperties", b.TypeProperties)
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryDataset.
func (b *BinaryDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &b.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &b.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &b.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &b.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &b.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &b.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &b.TypeProperties)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryDatasetTypeProperties.
func (b BinaryDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", b.Compression)
	populate(objectMap, "location", b.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryDatasetTypeProperties.
func (b *BinaryDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &b.Compression)
			delete(rawMsg, key)
		case "location":
			b.Location, err = unmarshalDatasetLocationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinaryReadSettings.
func (b BinaryReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compressionProperties", b.CompressionProperties)
	objectMap["type"] = "BinaryReadSettings"
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinaryReadSettings.
func (b *BinaryReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compressionProperties":
			b.CompressionProperties, err = unmarshalCompressionReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinarySink.
func (b BinarySink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", b.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", b.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", b.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", b.SinkRetryWait)
	populate(objectMap, "storeSettings", b.StoreSettings)
	objectMap["type"] = "BinarySink"
	populateAny(objectMap, "writeBatchSize", b.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", b.WriteBatchTimeout)
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinarySink.
func (b *BinarySink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &b.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &b.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &b.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &b.SinkRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			b.StoreSettings, err = unmarshalStoreWriteSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &b.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &b.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BinarySource.
func (b BinarySource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", b.DisableMetricsCollection)
	populate(objectMap, "formatSettings", b.FormatSettings)
	populateAny(objectMap, "maxConcurrentConnections", b.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", b.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", b.SourceRetryWait)
	populate(objectMap, "storeSettings", b.StoreSettings)
	objectMap["type"] = "BinarySource"
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BinarySource.
func (b *BinarySource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &b.DisableMetricsCollection)
			delete(rawMsg, key)
		case "formatSettings":
			err = unpopulate(val, "FormatSettings", &b.FormatSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &b.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &b.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &b.SourceRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			b.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobEventsTrigger.
func (b BlobEventsTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", b.Annotations)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "pipelines", b.Pipelines)
	populate(objectMap, "runtimeState", b.RuntimeState)
	objectMap["type"] = "BlobEventsTrigger"
	populate(objectMap, "typeProperties", b.TypeProperties)
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobEventsTrigger.
func (b *BlobEventsTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &b.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "pipelines":
			err = unpopulate(val, "Pipelines", &b.Pipelines)
			delete(rawMsg, key)
		case "runtimeState":
			err = unpopulate(val, "RuntimeState", &b.RuntimeState)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &b.TypeProperties)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobEventsTriggerTypeProperties.
func (b BlobEventsTriggerTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobPathBeginsWith", b.BlobPathBeginsWith)
	populate(objectMap, "blobPathEndsWith", b.BlobPathEndsWith)
	populate(objectMap, "events", b.Events)
	populate(objectMap, "ignoreEmptyBlobs", b.IgnoreEmptyBlobs)
	populate(objectMap, "scope", b.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobEventsTriggerTypeProperties.
func (b *BlobEventsTriggerTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobPathBeginsWith":
			err = unpopulate(val, "BlobPathBeginsWith", &b.BlobPathBeginsWith)
			delete(rawMsg, key)
		case "blobPathEndsWith":
			err = unpopulate(val, "BlobPathEndsWith", &b.BlobPathEndsWith)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &b.Events)
			delete(rawMsg, key)
		case "ignoreEmptyBlobs":
			err = unpopulate(val, "IgnoreEmptyBlobs", &b.IgnoreEmptyBlobs)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &b.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobSink.
func (b BlobSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "blobWriterAddHeader", b.BlobWriterAddHeader)
	populateAny(objectMap, "blobWriterDateTimeFormat", b.BlobWriterDateTimeFormat)
	populateAny(objectMap, "blobWriterOverwriteFiles", b.BlobWriterOverwriteFiles)
	populateAny(objectMap, "copyBehavior", b.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", b.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", b.MaxConcurrentConnections)
	populate(objectMap, "metadata", b.Metadata)
	populateAny(objectMap, "sinkRetryCount", b.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", b.SinkRetryWait)
	objectMap["type"] = "BlobSink"
	populateAny(objectMap, "writeBatchSize", b.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", b.WriteBatchTimeout)
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobSink.
func (b *BlobSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobWriterAddHeader":
			err = unpopulate(val, "BlobWriterAddHeader", &b.BlobWriterAddHeader)
			delete(rawMsg, key)
		case "blobWriterDateTimeFormat":
			err = unpopulate(val, "BlobWriterDateTimeFormat", &b.BlobWriterDateTimeFormat)
			delete(rawMsg, key)
		case "blobWriterOverwriteFiles":
			err = unpopulate(val, "BlobWriterOverwriteFiles", &b.BlobWriterOverwriteFiles)
			delete(rawMsg, key)
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &b.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &b.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &b.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "metadata":
			err = unpopulate(val, "Metadata", &b.Metadata)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &b.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &b.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &b.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &b.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobSource.
func (b BlobSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", b.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", b.MaxConcurrentConnections)
	populateAny(objectMap, "recursive", b.Recursive)
	populateAny(objectMap, "skipHeaderLineCount", b.SkipHeaderLineCount)
	populateAny(objectMap, "sourceRetryCount", b.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", b.SourceRetryWait)
	populateAny(objectMap, "treatEmptyAsNull", b.TreatEmptyAsNull)
	objectMap["type"] = "BlobSource"
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobSource.
func (b *BlobSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &b.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &b.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &b.Recursive)
			delete(rawMsg, key)
		case "skipHeaderLineCount":
			err = unpopulate(val, "SkipHeaderLineCount", &b.SkipHeaderLineCount)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &b.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &b.SourceRetryWait)
			delete(rawMsg, key)
		case "treatEmptyAsNull":
			err = unpopulate(val, "TreatEmptyAsNull", &b.TreatEmptyAsNull)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobTrigger.
func (b BlobTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", b.Annotations)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "pipelines", b.Pipelines)
	populate(objectMap, "runtimeState", b.RuntimeState)
	objectMap["type"] = "BlobTrigger"
	populate(objectMap, "typeProperties", b.TypeProperties)
	if b.AdditionalProperties != nil {
		for key, val := range b.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobTrigger.
func (b *BlobTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &b.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "pipelines":
			err = unpopulate(val, "Pipelines", &b.Pipelines)
			delete(rawMsg, key)
		case "runtimeState":
			err = unpopulate(val, "RuntimeState", &b.RuntimeState)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &b.TypeProperties)
			delete(rawMsg, key)
		default:
			if b.AdditionalProperties == nil {
				b.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				b.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobTriggerTypeProperties.
func (b BlobTriggerTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "folderPath", b.FolderPath)
	populate(objectMap, "linkedService", b.LinkedService)
	populate(objectMap, "maxConcurrency", b.MaxConcurrency)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobTriggerTypeProperties.
func (b *BlobTriggerTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "folderPath":
			err = unpopulate(val, "FolderPath", &b.FolderPath)
			delete(rawMsg, key)
		case "linkedService":
			err = unpopulate(val, "LinkedService", &b.LinkedService)
			delete(rawMsg, key)
		case "maxConcurrency":
			err = unpopulate(val, "MaxConcurrency", &b.MaxConcurrency)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CMKIdentityDefinition.
func (c CMKIdentityDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userAssignedIdentity", c.UserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CMKIdentityDefinition.
func (c *CMKIdentityDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userAssignedIdentity":
			err = unpopulate(val, "UserAssignedIdentity", &c.UserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CassandraLinkedService.
func (c CassandraLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "Cassandra"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CassandraLinkedService.
func (c *CassandraLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CassandraLinkedServiceTypeProperties.
func (c CassandraLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authenticationType", c.AuthenticationType)
	populate(objectMap, "encryptedCredential", c.EncryptedCredential)
	populateAny(objectMap, "host", c.Host)
	populate(objectMap, "password", c.Password)
	populateAny(objectMap, "port", c.Port)
	populateAny(objectMap, "username", c.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CassandraLinkedServiceTypeProperties.
func (c *CassandraLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &c.AuthenticationType)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &c.EncryptedCredential)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &c.Host)
			delete(rawMsg, key)
		case "password":
			c.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &c.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CassandraSource.
func (c CassandraSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", c.AdditionalColumns)
	populate(objectMap, "consistencyLevel", c.ConsistencyLevel)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "query", c.Query)
	populateAny(objectMap, "queryTimeout", c.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = "CassandraSource"
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CassandraSource.
func (c *CassandraSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &c.AdditionalColumns)
			delete(rawMsg, key)
		case "consistencyLevel":
			err = unpopulate(val, "ConsistencyLevel", &c.ConsistencyLevel)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &c.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &c.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CassandraTableDataset.
func (c CassandraTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "CassandraTable"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CassandraTableDataset.
func (c *CassandraTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CassandraTableDatasetTypeProperties.
func (c CassandraTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "keyspace", c.Keyspace)
	populateAny(objectMap, "tableName", c.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CassandraTableDatasetTypeProperties.
func (c *CassandraTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyspace":
			err = unpopulate(val, "Keyspace", &c.Keyspace)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &c.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChainingTrigger.
func (c ChainingTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "pipeline", c.Pipeline)
	populate(objectMap, "runtimeState", c.RuntimeState)
	objectMap["type"] = "ChainingTrigger"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChainingTrigger.
func (c *ChainingTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "pipeline":
			err = unpopulate(val, "Pipeline", &c.Pipeline)
			delete(rawMsg, key)
		case "runtimeState":
			err = unpopulate(val, "RuntimeState", &c.RuntimeState)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChainingTriggerTypeProperties.
func (c ChainingTriggerTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", c.DependsOn)
	populate(objectMap, "runDimension", c.RunDimension)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChainingTriggerTypeProperties.
func (c *ChainingTriggerTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &c.DependsOn)
			delete(rawMsg, key)
		case "runDimension":
			err = unpopulate(val, "RunDimension", &c.RunDimension)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDataCapture.
func (c ChangeDataCapture) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowVNetOverride", c.AllowVNetOverride)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "policy", c.Policy)
	populate(objectMap, "sourceConnectionsInfo", c.SourceConnectionsInfo)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "targetConnectionsInfo", c.TargetConnectionsInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDataCapture.
func (c *ChangeDataCapture) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowVNetOverride":
			err = unpopulate(val, "AllowVNetOverride", &c.AllowVNetOverride)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &c.Policy)
			delete(rawMsg, key)
		case "sourceConnectionsInfo":
			err = unpopulate(val, "SourceConnectionsInfo", &c.SourceConnectionsInfo)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "targetConnectionsInfo":
			err = unpopulate(val, "TargetConnectionsInfo", &c.TargetConnectionsInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDataCaptureFolder.
func (c ChangeDataCaptureFolder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDataCaptureFolder.
func (c *ChangeDataCaptureFolder) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDataCaptureListResponse.
func (c ChangeDataCaptureListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDataCaptureListResponse.
func (c *ChangeDataCaptureListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDataCaptureResource.
func (c ChangeDataCaptureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", c.Etag)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDataCaptureResource.
func (c *ChangeDataCaptureResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &c.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CmdkeySetup.
func (c CmdkeySetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "CmdkeySetup"
	populate(objectMap, "typeProperties", c.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CmdkeySetup.
func (c *CmdkeySetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CmdkeySetupTypeProperties.
func (c CmdkeySetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", c.Password)
	populateAny(objectMap, "targetName", c.TargetName)
	populateAny(objectMap, "userName", c.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CmdkeySetupTypeProperties.
func (c *CmdkeySetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			c.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "targetName":
			err = unpopulate(val, "TargetName", &c.TargetName)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDataServiceForAppsEntityDataset.
func (c CommonDataServiceForAppsEntityDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "CommonDataServiceForAppsEntity"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDataServiceForAppsEntityDataset.
func (c *CommonDataServiceForAppsEntityDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDataServiceForAppsEntityDatasetTypeProperties.
func (c CommonDataServiceForAppsEntityDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "entityName", c.EntityName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDataServiceForAppsEntityDatasetTypeProperties.
func (c *CommonDataServiceForAppsEntityDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityName":
			err = unpopulate(val, "EntityName", &c.EntityName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDataServiceForAppsLinkedService.
func (c CommonDataServiceForAppsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "CommonDataServiceForApps"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDataServiceForAppsLinkedService.
func (c *CommonDataServiceForAppsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDataServiceForAppsLinkedServiceTypeProperties.
func (c CommonDataServiceForAppsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authenticationType", c.AuthenticationType)
	populateAny(objectMap, "deploymentType", c.DeploymentType)
	populate(objectMap, "encryptedCredential", c.EncryptedCredential)
	populateAny(objectMap, "hostName", c.HostName)
	populateAny(objectMap, "organizationName", c.OrganizationName)
	populate(objectMap, "password", c.Password)
	populateAny(objectMap, "port", c.Port)
	populate(objectMap, "servicePrincipalCredential", c.ServicePrincipalCredential)
	populateAny(objectMap, "servicePrincipalCredentialType", c.ServicePrincipalCredentialType)
	populateAny(objectMap, "servicePrincipalId", c.ServicePrincipalID)
	populateAny(objectMap, "serviceUri", c.ServiceURI)
	populateAny(objectMap, "username", c.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDataServiceForAppsLinkedServiceTypeProperties.
func (c *CommonDataServiceForAppsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &c.AuthenticationType)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &c.DeploymentType)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &c.EncryptedCredential)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &c.HostName)
			delete(rawMsg, key)
		case "organizationName":
			err = unpopulate(val, "OrganizationName", &c.OrganizationName)
			delete(rawMsg, key)
		case "password":
			c.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		case "servicePrincipalCredential":
			c.ServicePrincipalCredential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "servicePrincipalCredentialType":
			err = unpopulate(val, "ServicePrincipalCredentialType", &c.ServicePrincipalCredentialType)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &c.ServicePrincipalID)
			delete(rawMsg, key)
		case "serviceUri":
			err = unpopulate(val, "ServiceURI", &c.ServiceURI)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &c.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDataServiceForAppsSink.
func (c CommonDataServiceForAppsSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "alternateKeyName", c.AlternateKeyName)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "ignoreNullValues", c.IgnoreNullValues)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", c.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", c.SinkRetryWait)
	objectMap["type"] = "CommonDataServiceForAppsSink"
	populateAny(objectMap, "writeBatchSize", c.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", c.WriteBatchTimeout)
	populate(objectMap, "writeBehavior", c.WriteBehavior)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDataServiceForAppsSink.
func (c *CommonDataServiceForAppsSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateKeyName":
			err = unpopulate(val, "AlternateKeyName", &c.AlternateKeyName)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "ignoreNullValues":
			err = unpopulate(val, "IgnoreNullValues", &c.IgnoreNullValues)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &c.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &c.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &c.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &c.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &c.WriteBehavior)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonDataServiceForAppsSource.
func (c CommonDataServiceForAppsSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", c.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "query", c.Query)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = "CommonDataServiceForAppsSource"
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonDataServiceForAppsSource.
func (c *CommonDataServiceForAppsSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &c.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &c.Query)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentSetup.
func (c ComponentSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "ComponentSetup"
	populate(objectMap, "typeProperties", c.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentSetup.
func (c *ComponentSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompressionReadSettings.
func (c CompressionReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompressionReadSettings.
func (c *CompressionReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConcurLinkedService.
func (c ConcurLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "Concur"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConcurLinkedService.
func (c *ConcurLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConcurLinkedServiceTypeProperties.
func (c ConcurLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "clientId", c.ClientID)
	populateAny(objectMap, "connectionProperties", c.ConnectionProperties)
	populate(objectMap, "encryptedCredential", c.EncryptedCredential)
	populate(objectMap, "password", c.Password)
	populateAny(objectMap, "useEncryptedEndpoints", c.UseEncryptedEndpoints)
	populateAny(objectMap, "useHostVerification", c.UseHostVerification)
	populateAny(objectMap, "usePeerVerification", c.UsePeerVerification)
	populateAny(objectMap, "username", c.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConcurLinkedServiceTypeProperties.
func (c *ConcurLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "connectionProperties":
			err = unpopulate(val, "ConnectionProperties", &c.ConnectionProperties)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &c.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			c.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "useEncryptedEndpoints":
			err = unpopulate(val, "UseEncryptedEndpoints", &c.UseEncryptedEndpoints)
			delete(rawMsg, key)
		case "useHostVerification":
			err = unpopulate(val, "UseHostVerification", &c.UseHostVerification)
			delete(rawMsg, key)
		case "usePeerVerification":
			err = unpopulate(val, "UsePeerVerification", &c.UsePeerVerification)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &c.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConcurObjectDataset.
func (c ConcurObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "ConcurObject"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConcurObjectDataset.
func (c *ConcurObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConcurSource.
func (c ConcurSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", c.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "query", c.Query)
	populateAny(objectMap, "queryTimeout", c.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = "ConcurSource"
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConcurSource.
func (c *ConcurSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &c.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &c.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &c.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConnectionStateProperties.
func (c ConnectionStateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", c.ActionsRequired)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConnectionStateProperties.
func (c *ConnectionStateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &c.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlActivity.
func (c ControlActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", c.DependsOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "onInactiveMarkAs", c.OnInactiveMarkAs)
	populate(objectMap, "state", c.State)
	objectMap["type"] = "Container"
	populate(objectMap, "userProperties", c.UserProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlActivity.
func (c *ControlActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &c.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &c.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &c.UserProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyActivity.
func (c CopyActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", c.DependsOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "inputs", c.Inputs)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "onInactiveMarkAs", c.OnInactiveMarkAs)
	populate(objectMap, "outputs", c.Outputs)
	populate(objectMap, "policy", c.Policy)
	populate(objectMap, "state", c.State)
	objectMap["type"] = "Copy"
	populate(objectMap, "typeProperties", c.TypeProperties)
	populate(objectMap, "userProperties", c.UserProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyActivity.
func (c *CopyActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &c.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "inputs":
			err = unpopulate(val, "Inputs", &c.Inputs)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &c.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, "Outputs", &c.Outputs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &c.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &c.UserProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyActivityLogSettings.
func (c CopyActivityLogSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "enableReliableLogging", c.EnableReliableLogging)
	populateAny(objectMap, "logLevel", c.LogLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyActivityLogSettings.
func (c *CopyActivityLogSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableReliableLogging":
			err = unpopulate(val, "EnableReliableLogging", &c.EnableReliableLogging)
			delete(rawMsg, key)
		case "logLevel":
			err = unpopulate(val, "LogLevel", &c.LogLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyActivityTypeProperties.
func (c CopyActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "dataIntegrationUnits", c.DataIntegrationUnits)
	populateAny(objectMap, "enableSkipIncompatibleRow", c.EnableSkipIncompatibleRow)
	populateAny(objectMap, "enableStaging", c.EnableStaging)
	populate(objectMap, "logSettings", c.LogSettings)
	populate(objectMap, "logStorageSettings", c.LogStorageSettings)
	populateAny(objectMap, "parallelCopies", c.ParallelCopies)
	populate(objectMap, "preserve", c.Preserve)
	populate(objectMap, "preserveRules", c.PreserveRules)
	populate(objectMap, "redirectIncompatibleRowSettings", c.RedirectIncompatibleRowSettings)
	populate(objectMap, "sink", c.Sink)
	populate(objectMap, "skipErrorFile", c.SkipErrorFile)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "stagingSettings", c.StagingSettings)
	populateAny(objectMap, "translator", c.Translator)
	populateAny(objectMap, "validateDataConsistency", c.ValidateDataConsistency)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyActivityTypeProperties.
func (c *CopyActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataIntegrationUnits":
			err = unpopulate(val, "DataIntegrationUnits", &c.DataIntegrationUnits)
			delete(rawMsg, key)
		case "enableSkipIncompatibleRow":
			err = unpopulate(val, "EnableSkipIncompatibleRow", &c.EnableSkipIncompatibleRow)
			delete(rawMsg, key)
		case "enableStaging":
			err = unpopulate(val, "EnableStaging", &c.EnableStaging)
			delete(rawMsg, key)
		case "logSettings":
			err = unpopulate(val, "LogSettings", &c.LogSettings)
			delete(rawMsg, key)
		case "logStorageSettings":
			err = unpopulate(val, "LogStorageSettings", &c.LogStorageSettings)
			delete(rawMsg, key)
		case "parallelCopies":
			err = unpopulate(val, "ParallelCopies", &c.ParallelCopies)
			delete(rawMsg, key)
		case "preserve":
			err = unpopulate(val, "Preserve", &c.Preserve)
			delete(rawMsg, key)
		case "preserveRules":
			err = unpopulate(val, "PreserveRules", &c.PreserveRules)
			delete(rawMsg, key)
		case "redirectIncompatibleRowSettings":
			err = unpopulate(val, "RedirectIncompatibleRowSettings", &c.RedirectIncompatibleRowSettings)
			delete(rawMsg, key)
		case "sink":
			c.Sink, err = unmarshalCopySinkClassification(val)
			delete(rawMsg, key)
		case "skipErrorFile":
			err = unpopulate(val, "SkipErrorFile", &c.SkipErrorFile)
			delete(rawMsg, key)
		case "source":
			c.Source, err = unmarshalCopySourceClassification(val)
			delete(rawMsg, key)
		case "stagingSettings":
			err = unpopulate(val, "StagingSettings", &c.StagingSettings)
			delete(rawMsg, key)
		case "translator":
			err = unpopulate(val, "Translator", &c.Translator)
			delete(rawMsg, key)
		case "validateDataConsistency":
			err = unpopulate(val, "ValidateDataConsistency", &c.ValidateDataConsistency)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopyComputeScaleProperties.
func (c CopyComputeScaleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataIntegrationUnit", c.DataIntegrationUnit)
	populate(objectMap, "timeToLive", c.TimeToLive)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopyComputeScaleProperties.
func (c *CopyComputeScaleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataIntegrationUnit":
			err = unpopulate(val, "DataIntegrationUnit", &c.DataIntegrationUnit)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &c.TimeToLive)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopySink.
func (c CopySink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", c.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", c.SinkRetryWait)
	objectMap["type"] = c.Type
	populateAny(objectMap, "writeBatchSize", c.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", c.WriteBatchTimeout)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopySink.
func (c *CopySink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &c.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &c.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &c.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &c.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CopySource.
func (c CopySource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = c.Type
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CopySource.
func (c *CopySource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbLinkedService.
func (c CosmosDbLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "CosmosDb"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbLinkedService.
func (c *CosmosDbLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbLinkedServiceTypeProperties.
func (c CosmosDbLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accountEndpoint", c.AccountEndpoint)
	populate(objectMap, "accountKey", c.AccountKey)
	populateAny(objectMap, "azureCloudType", c.AzureCloudType)
	populate(objectMap, "connectionMode", c.ConnectionMode)
	populateAny(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "credential", c.Credential)
	populateAny(objectMap, "database", c.Database)
	populate(objectMap, "encryptedCredential", c.EncryptedCredential)
	populate(objectMap, "servicePrincipalCredential", c.ServicePrincipalCredential)
	populateAny(objectMap, "servicePrincipalCredentialType", c.ServicePrincipalCredentialType)
	populateAny(objectMap, "servicePrincipalId", c.ServicePrincipalID)
	populateAny(objectMap, "tenant", c.Tenant)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbLinkedServiceTypeProperties.
func (c *CosmosDbLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountEndpoint":
			err = unpopulate(val, "AccountEndpoint", &c.AccountEndpoint)
			delete(rawMsg, key)
		case "accountKey":
			c.AccountKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "azureCloudType":
			err = unpopulate(val, "AzureCloudType", &c.AzureCloudType)
			delete(rawMsg, key)
		case "connectionMode":
			err = unpopulate(val, "ConnectionMode", &c.ConnectionMode)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &c.Credential)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &c.Database)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &c.EncryptedCredential)
			delete(rawMsg, key)
		case "servicePrincipalCredential":
			c.ServicePrincipalCredential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "servicePrincipalCredentialType":
			err = unpopulate(val, "ServicePrincipalCredentialType", &c.ServicePrincipalCredentialType)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &c.ServicePrincipalID)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &c.Tenant)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbMongoDbAPICollectionDataset.
func (c CosmosDbMongoDbAPICollectionDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "CosmosDbMongoDbApiCollection"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbMongoDbAPICollectionDataset.
func (c *CosmosDbMongoDbAPICollectionDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbMongoDbAPICollectionDatasetTypeProperties.
func (c CosmosDbMongoDbAPICollectionDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "collection", c.Collection)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbMongoDbAPICollectionDatasetTypeProperties.
func (c *CosmosDbMongoDbAPICollectionDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collection":
			err = unpopulate(val, "Collection", &c.Collection)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbMongoDbAPILinkedService.
func (c CosmosDbMongoDbAPILinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "CosmosDbMongoDbApi"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbMongoDbAPILinkedService.
func (c *CosmosDbMongoDbAPILinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbMongoDbAPILinkedServiceTypeProperties.
func (c CosmosDbMongoDbAPILinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", c.ConnectionString)
	populateAny(objectMap, "database", c.Database)
	populateAny(objectMap, "isServerVersionAbove32", c.IsServerVersionAbove32)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbMongoDbAPILinkedServiceTypeProperties.
func (c *CosmosDbMongoDbAPILinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &c.Database)
			delete(rawMsg, key)
		case "isServerVersionAbove32":
			err = unpopulate(val, "IsServerVersionAbove32", &c.IsServerVersionAbove32)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbMongoDbAPISink.
func (c CosmosDbMongoDbAPISink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", c.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", c.SinkRetryWait)
	objectMap["type"] = "CosmosDbMongoDbApiSink"
	populateAny(objectMap, "writeBatchSize", c.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", c.WriteBatchTimeout)
	populateAny(objectMap, "writeBehavior", c.WriteBehavior)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbMongoDbAPISink.
func (c *CosmosDbMongoDbAPISink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &c.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &c.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &c.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &c.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &c.WriteBehavior)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbMongoDbAPISource.
func (c CosmosDbMongoDbAPISource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", c.AdditionalColumns)
	populateAny(objectMap, "batchSize", c.BatchSize)
	populate(objectMap, "cursorMethods", c.CursorMethods)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "filter", c.Filter)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "queryTimeout", c.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = "CosmosDbMongoDbApiSource"
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbMongoDbAPISource.
func (c *CosmosDbMongoDbAPISource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &c.AdditionalColumns)
			delete(rawMsg, key)
		case "batchSize":
			err = unpopulate(val, "BatchSize", &c.BatchSize)
			delete(rawMsg, key)
		case "cursorMethods":
			err = unpopulate(val, "CursorMethods", &c.CursorMethods)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &c.Filter)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &c.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbSQLAPICollectionDataset.
func (c CosmosDbSQLAPICollectionDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "CosmosDbSqlApiCollection"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbSQLAPICollectionDataset.
func (c *CosmosDbSQLAPICollectionDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbSQLAPICollectionDatasetTypeProperties.
func (c CosmosDbSQLAPICollectionDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "collectionName", c.CollectionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbSQLAPICollectionDatasetTypeProperties.
func (c *CosmosDbSQLAPICollectionDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionName":
			err = unpopulate(val, "CollectionName", &c.CollectionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbSQLAPISink.
func (c CosmosDbSQLAPISink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", c.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", c.SinkRetryWait)
	objectMap["type"] = "CosmosDbSqlApiSink"
	populateAny(objectMap, "writeBatchSize", c.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", c.WriteBatchTimeout)
	populateAny(objectMap, "writeBehavior", c.WriteBehavior)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbSQLAPISink.
func (c *CosmosDbSQLAPISink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &c.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &c.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &c.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &c.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &c.WriteBehavior)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbSQLAPISource.
func (c CosmosDbSQLAPISource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", c.AdditionalColumns)
	populateAny(objectMap, "detectDatetime", c.DetectDatetime)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "pageSize", c.PageSize)
	populateAny(objectMap, "preferredRegions", c.PreferredRegions)
	populateAny(objectMap, "query", c.Query)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = "CosmosDbSqlApiSource"
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbSQLAPISource.
func (c *CosmosDbSQLAPISource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &c.AdditionalColumns)
			delete(rawMsg, key)
		case "detectDatetime":
			err = unpopulate(val, "DetectDatetime", &c.DetectDatetime)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "pageSize":
			err = unpopulate(val, "PageSize", &c.PageSize)
			delete(rawMsg, key)
		case "preferredRegions":
			err = unpopulate(val, "PreferredRegions", &c.PreferredRegions)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &c.Query)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CouchbaseLinkedService.
func (c CouchbaseLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "Couchbase"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CouchbaseLinkedService.
func (c *CouchbaseLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CouchbaseLinkedServiceTypeProperties.
func (c CouchbaseLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", c.ConnectionString)
	populate(objectMap, "credString", c.CredString)
	populate(objectMap, "encryptedCredential", c.EncryptedCredential)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CouchbaseLinkedServiceTypeProperties.
func (c *CouchbaseLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &c.ConnectionString)
			delete(rawMsg, key)
		case "credString":
			err = unpopulate(val, "CredString", &c.CredString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &c.EncryptedCredential)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CouchbaseSource.
func (c CouchbaseSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", c.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", c.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", c.MaxConcurrentConnections)
	populateAny(objectMap, "query", c.Query)
	populateAny(objectMap, "queryTimeout", c.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", c.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", c.SourceRetryWait)
	objectMap["type"] = "CouchbaseSource"
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CouchbaseSource.
func (c *CouchbaseSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &c.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &c.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &c.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &c.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &c.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &c.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &c.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CouchbaseTableDataset.
func (c CouchbaseTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "CouchbaseTable"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CouchbaseTableDataset.
func (c *CouchbaseTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateDataFlowDebugSessionRequest.
func (c CreateDataFlowDebugSessionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeType", c.ComputeType)
	populate(objectMap, "coreCount", c.CoreCount)
	populate(objectMap, "integrationRuntime", c.IntegrationRuntime)
	populate(objectMap, "timeToLive", c.TimeToLive)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateDataFlowDebugSessionRequest.
func (c *CreateDataFlowDebugSessionRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeType":
			err = unpopulate(val, "ComputeType", &c.ComputeType)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &c.CoreCount)
			delete(rawMsg, key)
		case "integrationRuntime":
			err = unpopulate(val, "IntegrationRuntime", &c.IntegrationRuntime)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &c.TimeToLive)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateDataFlowDebugSessionResponse.
func (c CreateDataFlowDebugSessionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sessionId", c.SessionID)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateDataFlowDebugSessionResponse.
func (c *CreateDataFlowDebugSessionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sessionId":
			err = unpopulate(val, "SessionID", &c.SessionID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateLinkedIntegrationRuntimeRequest.
func (c CreateLinkedIntegrationRuntimeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFactoryLocation", c.DataFactoryLocation)
	populate(objectMap, "dataFactoryName", c.DataFactoryName)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "subscriptionId", c.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateLinkedIntegrationRuntimeRequest.
func (c *CreateLinkedIntegrationRuntimeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryLocation":
			err = unpopulate(val, "DataFactoryLocation", &c.DataFactoryLocation)
			delete(rawMsg, key)
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &c.DataFactoryName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &c.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateRunResponse.
func (c CreateRunResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "runId", c.RunID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateRunResponse.
func (c *CreateRunResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runId":
			err = unpopulate(val, "RunID", &c.RunID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Credential.
func (c Credential) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	objectMap["type"] = c.Type
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Credential.
func (c *Credential) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialListResponse.
func (c CredentialListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialListResponse.
func (c *CredentialListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialReference.
func (c CredentialReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "referenceName", c.ReferenceName)
	populate(objectMap, "type", c.Type)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialReference.
func (c *CredentialReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &c.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomActivity.
func (c CustomActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", c.DependsOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "onInactiveMarkAs", c.OnInactiveMarkAs)
	populate(objectMap, "policy", c.Policy)
	populate(objectMap, "state", c.State)
	objectMap["type"] = "Custom"
	populate(objectMap, "typeProperties", c.TypeProperties)
	populate(objectMap, "userProperties", c.UserProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomActivity.
func (c *CustomActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &c.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &c.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &c.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &c.UserProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomActivityReferenceObject.
func (c CustomActivityReferenceObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasets", c.Datasets)
	populate(objectMap, "linkedServices", c.LinkedServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomActivityReferenceObject.
func (c *CustomActivityReferenceObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasets":
			err = unpopulate(val, "Datasets", &c.Datasets)
			delete(rawMsg, key)
		case "linkedServices":
			err = unpopulate(val, "LinkedServices", &c.LinkedServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomActivityTypeProperties.
func (c CustomActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "autoUserSpecification", c.AutoUserSpecification)
	populateAny(objectMap, "command", c.Command)
	populate(objectMap, "extendedProperties", c.ExtendedProperties)
	populateAny(objectMap, "folderPath", c.FolderPath)
	populate(objectMap, "referenceObjects", c.ReferenceObjects)
	populate(objectMap, "resourceLinkedService", c.ResourceLinkedService)
	populateAny(objectMap, "retentionTimeInDays", c.RetentionTimeInDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomActivityTypeProperties.
func (c *CustomActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUserSpecification":
			err = unpopulate(val, "AutoUserSpecification", &c.AutoUserSpecification)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &c.Command)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &c.ExtendedProperties)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &c.FolderPath)
			delete(rawMsg, key)
		case "referenceObjects":
			err = unpopulate(val, "ReferenceObjects", &c.ReferenceObjects)
			delete(rawMsg, key)
		case "resourceLinkedService":
			err = unpopulate(val, "ResourceLinkedService", &c.ResourceLinkedService)
			delete(rawMsg, key)
		case "retentionTimeInDays":
			err = unpopulate(val, "RetentionTimeInDays", &c.RetentionTimeInDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDataSourceLinkedService.
func (c CustomDataSourceLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "connectVia", c.ConnectVia)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "parameters", c.Parameters)
	objectMap["type"] = "CustomDataSource"
	populateAny(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDataSourceLinkedService.
func (c *CustomDataSourceLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &c.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomDataset.
func (c CustomDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "folder", c.Folder)
	populate(objectMap, "linkedServiceName", c.LinkedServiceName)
	populate(objectMap, "parameters", c.Parameters)
	populateAny(objectMap, "schema", c.Schema)
	populateAny(objectMap, "structure", c.Structure)
	objectMap["type"] = "CustomDataset"
	populateAny(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomDataset.
func (c *CustomDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &c.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &c.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &c.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &c.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEventsTrigger.
func (c CustomEventsTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", c.Annotations)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "pipelines", c.Pipelines)
	populate(objectMap, "runtimeState", c.RuntimeState)
	objectMap["type"] = "CustomEventsTrigger"
	populate(objectMap, "typeProperties", c.TypeProperties)
	if c.AdditionalProperties != nil {
		for key, val := range c.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEventsTrigger.
func (c *CustomEventsTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &c.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "pipelines":
			err = unpopulate(val, "Pipelines", &c.Pipelines)
			delete(rawMsg, key)
		case "runtimeState":
			err = unpopulate(val, "RuntimeState", &c.RuntimeState)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &c.TypeProperties)
			delete(rawMsg, key)
		default:
			if c.AdditionalProperties == nil {
				c.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				c.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomEventsTriggerTypeProperties.
func (c CustomEventsTriggerTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "events", c.Events)
	populate(objectMap, "scope", c.Scope)
	populate(objectMap, "subjectBeginsWith", c.SubjectBeginsWith)
	populate(objectMap, "subjectEndsWith", c.SubjectEndsWith)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomEventsTriggerTypeProperties.
func (c *CustomEventsTriggerTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "events":
			err = unpopulate(val, "Events", &c.Events)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &c.Scope)
			delete(rawMsg, key)
		case "subjectBeginsWith":
			err = unpopulate(val, "SubjectBeginsWith", &c.SubjectBeginsWith)
			delete(rawMsg, key)
		case "subjectEndsWith":
			err = unpopulate(val, "SubjectEndsWith", &c.SubjectEndsWith)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomSetupBase.
func (c CustomSetupBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = c.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomSetupBase.
func (c *CustomSetupBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DWCopyCommandDefaultValue.
func (d DWCopyCommandDefaultValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "columnName", d.ColumnName)
	populateAny(objectMap, "defaultValue", d.DefaultValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DWCopyCommandDefaultValue.
func (d *DWCopyCommandDefaultValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnName":
			err = unpopulate(val, "ColumnName", &d.ColumnName)
			delete(rawMsg, key)
		case "defaultValue":
			err = unpopulate(val, "DefaultValue", &d.DefaultValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DWCopyCommandSettings.
func (d DWCopyCommandSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalOptions", d.AdditionalOptions)
	populate(objectMap, "defaultValues", d.DefaultValues)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DWCopyCommandSettings.
func (d *DWCopyCommandSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalOptions":
			err = unpopulate(val, "AdditionalOptions", &d.AdditionalOptions)
			delete(rawMsg, key)
		case "defaultValues":
			err = unpopulate(val, "DefaultValues", &d.DefaultValues)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlow.
func (d DataFlow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	objectMap["type"] = d.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlow.
func (d *DataFlow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugCommandPayload.
func (d DataFlowDebugCommandPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", d.Columns)
	populate(objectMap, "expression", d.Expression)
	populate(objectMap, "rowLimits", d.RowLimits)
	populate(objectMap, "streamName", d.StreamName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugCommandPayload.
func (d *DataFlowDebugCommandPayload) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &d.Columns)
			delete(rawMsg, key)
		case "expression":
			err = unpopulate(val, "Expression", &d.Expression)
			delete(rawMsg, key)
		case "rowLimits":
			err = unpopulate(val, "RowLimits", &d.RowLimits)
			delete(rawMsg, key)
		case "streamName":
			err = unpopulate(val, "StreamName", &d.StreamName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugCommandRequest.
func (d DataFlowDebugCommandRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "command", d.Command)
	populate(objectMap, "commandPayload", d.CommandPayload)
	populate(objectMap, "sessionId", d.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugCommandRequest.
func (d *DataFlowDebugCommandRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "command":
			err = unpopulate(val, "Command", &d.Command)
			delete(rawMsg, key)
		case "commandPayload":
			err = unpopulate(val, "CommandPayload", &d.CommandPayload)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &d.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugCommandResponse.
func (d DataFlowDebugCommandResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", d.Data)
	populate(objectMap, "status", d.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugCommandResponse.
func (d *DataFlowDebugCommandResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &d.Data)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &d.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugPackage.
func (d DataFlowDebugPackage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFlow", d.DataFlow)
	populate(objectMap, "dataFlows", d.DataFlows)
	populate(objectMap, "datasets", d.Datasets)
	populate(objectMap, "debugSettings", d.DebugSettings)
	populate(objectMap, "linkedServices", d.LinkedServices)
	populate(objectMap, "sessionId", d.SessionID)
	populate(objectMap, "staging", d.Staging)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugPackage.
func (d *DataFlowDebugPackage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFlow":
			err = unpopulate(val, "DataFlow", &d.DataFlow)
			delete(rawMsg, key)
		case "dataFlows":
			err = unpopulate(val, "DataFlows", &d.DataFlows)
			delete(rawMsg, key)
		case "datasets":
			err = unpopulate(val, "Datasets", &d.Datasets)
			delete(rawMsg, key)
		case "debugSettings":
			err = unpopulate(val, "DebugSettings", &d.DebugSettings)
			delete(rawMsg, key)
		case "linkedServices":
			err = unpopulate(val, "LinkedServices", &d.LinkedServices)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &d.SessionID)
			delete(rawMsg, key)
		case "staging":
			err = unpopulate(val, "Staging", &d.Staging)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugPackageDebugSettings.
func (d DataFlowDebugPackageDebugSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "datasetParameters", d.DatasetParameters)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "sourceSettings", d.SourceSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugPackageDebugSettings.
func (d *DataFlowDebugPackageDebugSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasetParameters":
			err = unpopulate(val, "DatasetParameters", &d.DatasetParameters)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "sourceSettings":
			err = unpopulate(val, "SourceSettings", &d.SourceSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugResource.
func (d DataFlowDebugResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugResource.
func (d *DataFlowDebugResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDataFlowClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowDebugSessionInfo.
func (d DataFlowDebugSessionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeType", d.ComputeType)
	populate(objectMap, "coreCount", d.CoreCount)
	populate(objectMap, "dataFlowName", d.DataFlowName)
	populate(objectMap, "integrationRuntimeName", d.IntegrationRuntimeName)
	populate(objectMap, "lastActivityTime", d.LastActivityTime)
	populate(objectMap, "nodeCount", d.NodeCount)
	populate(objectMap, "sessionId", d.SessionID)
	populate(objectMap, "startTime", d.StartTime)
	populate(objectMap, "timeToLiveInMinutes", d.TimeToLiveInMinutes)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowDebugSessionInfo.
func (d *DataFlowDebugSessionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &d.CoreCount)
			delete(rawMsg, key)
		case "dataFlowName":
			err = unpopulate(val, "DataFlowName", &d.DataFlowName)
			delete(rawMsg, key)
		case "integrationRuntimeName":
			err = unpopulate(val, "IntegrationRuntimeName", &d.IntegrationRuntimeName)
			delete(rawMsg, key)
		case "lastActivityTime":
			err = unpopulate(val, "LastActivityTime", &d.LastActivityTime)
			delete(rawMsg, key)
		case "nodeCount":
			err = unpopulate(val, "NodeCount", &d.NodeCount)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &d.SessionID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &d.StartTime)
			delete(rawMsg, key)
		case "timeToLiveInMinutes":
			err = unpopulate(val, "TimeToLiveInMinutes", &d.TimeToLiveInMinutes)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowFolder.
func (d DataFlowFolder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowFolder.
func (d *DataFlowFolder) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowListResponse.
func (d DataFlowListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowListResponse.
func (d *DataFlowListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowReference.
func (d DataFlowReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "datasetParameters", d.DatasetParameters)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "referenceName", d.ReferenceName)
	populate(objectMap, "type", d.Type)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowReference.
func (d *DataFlowReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasetParameters":
			err = unpopulate(val, "DatasetParameters", &d.DatasetParameters)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &d.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowResource.
func (d DataFlowResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowResource.
func (d *DataFlowResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDataFlowClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowSink.
func (d DataFlowSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", d.Dataset)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "flowlet", d.Flowlet)
	populate(objectMap, "linkedService", d.LinkedService)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "rejectedDataLinkedService", d.RejectedDataLinkedService)
	populate(objectMap, "schemaLinkedService", d.SchemaLinkedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowSink.
func (d *DataFlowSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &d.Dataset)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "flowlet":
			err = unpopulate(val, "Flowlet", &d.Flowlet)
			delete(rawMsg, key)
		case "linkedService":
			err = unpopulate(val, "LinkedService", &d.LinkedService)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "rejectedDataLinkedService":
			err = unpopulate(val, "RejectedDataLinkedService", &d.RejectedDataLinkedService)
			delete(rawMsg, key)
		case "schemaLinkedService":
			err = unpopulate(val, "SchemaLinkedService", &d.SchemaLinkedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowSource.
func (d DataFlowSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", d.Dataset)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "flowlet", d.Flowlet)
	populate(objectMap, "linkedService", d.LinkedService)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "schemaLinkedService", d.SchemaLinkedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowSource.
func (d *DataFlowSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &d.Dataset)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "flowlet":
			err = unpopulate(val, "Flowlet", &d.Flowlet)
			delete(rawMsg, key)
		case "linkedService":
			err = unpopulate(val, "LinkedService", &d.LinkedService)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "schemaLinkedService":
			err = unpopulate(val, "SchemaLinkedService", &d.SchemaLinkedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowSourceSetting.
func (d DataFlowSourceSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rowLimit", d.RowLimit)
	populate(objectMap, "sourceName", d.SourceName)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowSourceSetting.
func (d *DataFlowSourceSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rowLimit":
			err = unpopulate(val, "RowLimit", &d.RowLimit)
			delete(rawMsg, key)
		case "sourceName":
			err = unpopulate(val, "SourceName", &d.SourceName)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFlowStagingInfo.
func (d DataFlowStagingInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "folderPath", d.FolderPath)
	populate(objectMap, "linkedService", d.LinkedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFlowStagingInfo.
func (d *DataFlowStagingInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "folderPath":
			err = unpopulate(val, "FolderPath", &d.FolderPath)
			delete(rawMsg, key)
		case "linkedService":
			err = unpopulate(val, "LinkedService", &d.LinkedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeAnalyticsUSQLActivity.
func (d DataLakeAnalyticsUSQLActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "onInactiveMarkAs", d.OnInactiveMarkAs)
	populate(objectMap, "policy", d.Policy)
	populate(objectMap, "state", d.State)
	objectMap["type"] = "DataLakeAnalyticsU-SQL"
	populate(objectMap, "typeProperties", d.TypeProperties)
	populate(objectMap, "userProperties", d.UserProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeAnalyticsUSQLActivity.
func (d *DataLakeAnalyticsUSQLActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &d.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &d.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &d.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &d.UserProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeAnalyticsUSQLActivityTypeProperties.
func (d DataLakeAnalyticsUSQLActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "compilationMode", d.CompilationMode)
	populateAny(objectMap, "degreeOfParallelism", d.DegreeOfParallelism)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "priority", d.Priority)
	populateAny(objectMap, "runtimeVersion", d.RuntimeVersion)
	populate(objectMap, "scriptLinkedService", d.ScriptLinkedService)
	populateAny(objectMap, "scriptPath", d.ScriptPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeAnalyticsUSQLActivityTypeProperties.
func (d *DataLakeAnalyticsUSQLActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compilationMode":
			err = unpopulate(val, "CompilationMode", &d.CompilationMode)
			delete(rawMsg, key)
		case "degreeOfParallelism":
			err = unpopulate(val, "DegreeOfParallelism", &d.DegreeOfParallelism)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "priority":
			err = unpopulate(val, "Priority", &d.Priority)
			delete(rawMsg, key)
		case "runtimeVersion":
			err = unpopulate(val, "RuntimeVersion", &d.RuntimeVersion)
			delete(rawMsg, key)
		case "scriptLinkedService":
			err = unpopulate(val, "ScriptLinkedService", &d.ScriptLinkedService)
			delete(rawMsg, key)
		case "scriptPath":
			err = unpopulate(val, "ScriptPath", &d.ScriptPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataMapperMapping.
func (d DataMapperMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attributeMappingInfo", d.AttributeMappingInfo)
	populate(objectMap, "sourceConnectionReference", d.SourceConnectionReference)
	populateAny(objectMap, "sourceDenormalizeInfo", d.SourceDenormalizeInfo)
	populate(objectMap, "sourceEntityName", d.SourceEntityName)
	populate(objectMap, "targetEntityName", d.TargetEntityName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataMapperMapping.
func (d *DataMapperMapping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attributeMappingInfo":
			err = unpopulate(val, "AttributeMappingInfo", &d.AttributeMappingInfo)
			delete(rawMsg, key)
		case "sourceConnectionReference":
			err = unpopulate(val, "SourceConnectionReference", &d.SourceConnectionReference)
			delete(rawMsg, key)
		case "sourceDenormalizeInfo":
			err = unpopulate(val, "SourceDenormalizeInfo", &d.SourceDenormalizeInfo)
			delete(rawMsg, key)
		case "sourceEntityName":
			err = unpopulate(val, "SourceEntityName", &d.SourceEntityName)
			delete(rawMsg, key)
		case "targetEntityName":
			err = unpopulate(val, "TargetEntityName", &d.TargetEntityName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksNotebookActivity.
func (d DatabricksNotebookActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "onInactiveMarkAs", d.OnInactiveMarkAs)
	populate(objectMap, "policy", d.Policy)
	populate(objectMap, "state", d.State)
	objectMap["type"] = "DatabricksNotebook"
	populate(objectMap, "typeProperties", d.TypeProperties)
	populate(objectMap, "userProperties", d.UserProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksNotebookActivity.
func (d *DatabricksNotebookActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &d.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &d.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &d.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &d.UserProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksNotebookActivityTypeProperties.
func (d DatabricksNotebookActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "baseParameters", d.BaseParameters)
	populate(objectMap, "libraries", d.Libraries)
	populateAny(objectMap, "notebookPath", d.NotebookPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksNotebookActivityTypeProperties.
func (d *DatabricksNotebookActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "baseParameters":
			err = unpopulate(val, "BaseParameters", &d.BaseParameters)
			delete(rawMsg, key)
		case "libraries":
			err = unpopulate(val, "Libraries", &d.Libraries)
			delete(rawMsg, key)
		case "notebookPath":
			err = unpopulate(val, "NotebookPath", &d.NotebookPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksSparkJarActivity.
func (d DatabricksSparkJarActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "onInactiveMarkAs", d.OnInactiveMarkAs)
	populate(objectMap, "policy", d.Policy)
	populate(objectMap, "state", d.State)
	objectMap["type"] = "DatabricksSparkJar"
	populate(objectMap, "typeProperties", d.TypeProperties)
	populate(objectMap, "userProperties", d.UserProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksSparkJarActivity.
func (d *DatabricksSparkJarActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &d.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &d.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &d.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &d.UserProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksSparkJarActivityTypeProperties.
func (d DatabricksSparkJarActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "libraries", d.Libraries)
	populateAny(objectMap, "mainClassName", d.MainClassName)
	populate(objectMap, "parameters", d.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksSparkJarActivityTypeProperties.
func (d *DatabricksSparkJarActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "libraries":
			err = unpopulate(val, "Libraries", &d.Libraries)
			delete(rawMsg, key)
		case "mainClassName":
			err = unpopulate(val, "MainClassName", &d.MainClassName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksSparkPythonActivity.
func (d DatabricksSparkPythonActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "onInactiveMarkAs", d.OnInactiveMarkAs)
	populate(objectMap, "policy", d.Policy)
	populate(objectMap, "state", d.State)
	objectMap["type"] = "DatabricksSparkPython"
	populate(objectMap, "typeProperties", d.TypeProperties)
	populate(objectMap, "userProperties", d.UserProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksSparkPythonActivity.
func (d *DatabricksSparkPythonActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &d.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &d.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &d.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &d.UserProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksSparkPythonActivityTypeProperties.
func (d DatabricksSparkPythonActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "libraries", d.Libraries)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "pythonFile", d.PythonFile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksSparkPythonActivityTypeProperties.
func (d *DatabricksSparkPythonActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "libraries":
			err = unpopulate(val, "Libraries", &d.Libraries)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "pythonFile":
			err = unpopulate(val, "PythonFile", &d.PythonFile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dataset.
func (d Dataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = d.Type
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dataset.
func (d *Dataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetCompression.
func (d DatasetCompression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "level", d.Level)
	populateAny(objectMap, "type", d.Type)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetCompression.
func (d *DatasetCompression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "level":
			err = unpopulate(val, "Level", &d.Level)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetDebugResource.
func (d DatasetDebugResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetDebugResource.
func (d *DatasetDebugResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDatasetClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetFolder.
func (d DatasetFolder) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", d.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetFolder.
func (d *DatasetFolder) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetListResponse.
func (d DatasetListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetListResponse.
func (d *DatasetListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetLocation.
func (d DatasetLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", d.FileName)
	populateAny(objectMap, "folderPath", d.FolderPath)
	objectMap["type"] = d.Type
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetLocation.
func (d *DatasetLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &d.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &d.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetReference.
func (d DatasetReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "referenceName", d.ReferenceName)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetReference.
func (d *DatasetReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &d.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetResource.
func (d DatasetResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", d.Etag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetResource.
func (d *DatasetResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &d.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDatasetClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatasetStorageFormat.
func (d DatasetStorageFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deserializer", d.Deserializer)
	populateAny(objectMap, "serializer", d.Serializer)
	objectMap["type"] = d.Type
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatasetStorageFormat.
func (d *DatasetStorageFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deserializer":
			err = unpopulate(val, "Deserializer", &d.Deserializer)
			delete(rawMsg, key)
		case "serializer":
			err = unpopulate(val, "Serializer", &d.Serializer)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataworldLinkedService.
func (d DataworldLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "connectVia", d.ConnectVia)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["type"] = "Dataworld"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataworldLinkedService.
func (d *DataworldLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &d.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataworldLinkedServiceTypeProperties.
func (d DataworldLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiToken", d.APIToken)
	populate(objectMap, "encryptedCredential", d.EncryptedCredential)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataworldLinkedServiceTypeProperties.
func (d *DataworldLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiToken":
			d.APIToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &d.EncryptedCredential)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Db2LinkedService.
func (d Db2LinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "connectVia", d.ConnectVia)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["type"] = "Db2"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Db2LinkedService.
func (d *Db2LinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &d.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Db2LinkedServiceTypeProperties.
func (d Db2LinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationType", d.AuthenticationType)
	populateAny(objectMap, "certificateCommonName", d.CertificateCommonName)
	populateAny(objectMap, "connectionString", d.ConnectionString)
	populateAny(objectMap, "database", d.Database)
	populate(objectMap, "encryptedCredential", d.EncryptedCredential)
	populateAny(objectMap, "packageCollection", d.PackageCollection)
	populate(objectMap, "password", d.Password)
	populateAny(objectMap, "server", d.Server)
	populateAny(objectMap, "username", d.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Db2LinkedServiceTypeProperties.
func (d *Db2LinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &d.AuthenticationType)
			delete(rawMsg, key)
		case "certificateCommonName":
			err = unpopulate(val, "CertificateCommonName", &d.CertificateCommonName)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &d.ConnectionString)
			delete(rawMsg, key)
		case "database":
			err = unpopulate(val, "Database", &d.Database)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &d.EncryptedCredential)
			delete(rawMsg, key)
		case "packageCollection":
			err = unpopulate(val, "PackageCollection", &d.PackageCollection)
			delete(rawMsg, key)
		case "password":
			d.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "server":
			err = unpopulate(val, "Server", &d.Server)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &d.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Db2Source.
func (d Db2Source) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "query", d.Query)
	populateAny(objectMap, "queryTimeout", d.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	objectMap["type"] = "Db2Source"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Db2Source.
func (d *Db2Source) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &d.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &d.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Db2TableDataset.
func (d Db2TableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "Db2Table"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Db2TableDataset.
func (d *Db2TableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Db2TableDatasetTypeProperties.
func (d Db2TableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "table", d.Table)
	populateAny(objectMap, "tableName", d.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Db2TableDatasetTypeProperties.
func (d *Db2TableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &d.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &d.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeleteActivity.
func (d DeleteActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "onInactiveMarkAs", d.OnInactiveMarkAs)
	populate(objectMap, "policy", d.Policy)
	populate(objectMap, "state", d.State)
	objectMap["type"] = "Delete"
	populate(objectMap, "typeProperties", d.TypeProperties)
	populate(objectMap, "userProperties", d.UserProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeleteActivity.
func (d *DeleteActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &d.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &d.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &d.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &d.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &d.UserProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeleteActivityTypeProperties.
func (d DeleteActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", d.Dataset)
	populateAny(objectMap, "enableLogging", d.EnableLogging)
	populate(objectMap, "logStorageSettings", d.LogStorageSettings)
	populate(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "recursive", d.Recursive)
	populate(objectMap, "storeSettings", d.StoreSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeleteActivityTypeProperties.
func (d *DeleteActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &d.Dataset)
			delete(rawMsg, key)
		case "enableLogging":
			err = unpopulate(val, "EnableLogging", &d.EnableLogging)
			delete(rawMsg, key)
		case "logStorageSettings":
			err = unpopulate(val, "LogStorageSettings", &d.LogStorageSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &d.Recursive)
			delete(rawMsg, key)
		case "storeSettings":
			d.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeleteDataFlowDebugSessionRequest.
func (d DeleteDataFlowDebugSessionRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sessionId", d.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeleteDataFlowDebugSessionRequest.
func (d *DeleteDataFlowDebugSessionRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sessionId":
			err = unpopulate(val, "SessionID", &d.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelimitedTextDataset.
func (d DelimitedTextDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "DelimitedText"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelimitedTextDataset.
func (d *DelimitedTextDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelimitedTextDatasetTypeProperties.
func (d DelimitedTextDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "columnDelimiter", d.ColumnDelimiter)
	populateAny(objectMap, "compressionCodec", d.CompressionCodec)
	populateAny(objectMap, "compressionLevel", d.CompressionLevel)
	populateAny(objectMap, "encodingName", d.EncodingName)
	populateAny(objectMap, "escapeChar", d.EscapeChar)
	populateAny(objectMap, "firstRowAsHeader", d.FirstRowAsHeader)
	populate(objectMap, "location", d.Location)
	populateAny(objectMap, "nullValue", d.NullValue)
	populateAny(objectMap, "quoteChar", d.QuoteChar)
	populateAny(objectMap, "rowDelimiter", d.RowDelimiter)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelimitedTextDatasetTypeProperties.
func (d *DelimitedTextDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columnDelimiter":
			err = unpopulate(val, "ColumnDelimiter", &d.ColumnDelimiter)
			delete(rawMsg, key)
		case "compressionCodec":
			err = unpopulate(val, "CompressionCodec", &d.CompressionCodec)
			delete(rawMsg, key)
		case "compressionLevel":
			err = unpopulate(val, "CompressionLevel", &d.CompressionLevel)
			delete(rawMsg, key)
		case "encodingName":
			err = unpopulate(val, "EncodingName", &d.EncodingName)
			delete(rawMsg, key)
		case "escapeChar":
			err = unpopulate(val, "EscapeChar", &d.EscapeChar)
			delete(rawMsg, key)
		case "firstRowAsHeader":
			err = unpopulate(val, "FirstRowAsHeader", &d.FirstRowAsHeader)
			delete(rawMsg, key)
		case "location":
			d.Location, err = unmarshalDatasetLocationClassification(val)
			delete(rawMsg, key)
		case "nullValue":
			err = unpopulate(val, "NullValue", &d.NullValue)
			delete(rawMsg, key)
		case "quoteChar":
			err = unpopulate(val, "QuoteChar", &d.QuoteChar)
			delete(rawMsg, key)
		case "rowDelimiter":
			err = unpopulate(val, "RowDelimiter", &d.RowDelimiter)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelimitedTextReadSettings.
func (d DelimitedTextReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compressionProperties", d.CompressionProperties)
	populateAny(objectMap, "skipLineCount", d.SkipLineCount)
	objectMap["type"] = "DelimitedTextReadSettings"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelimitedTextReadSettings.
func (d *DelimitedTextReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compressionProperties":
			d.CompressionProperties, err = unmarshalCompressionReadSettingsClassification(val)
			delete(rawMsg, key)
		case "skipLineCount":
			err = unpopulate(val, "SkipLineCount", &d.SkipLineCount)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelimitedTextSink.
func (d DelimitedTextSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populate(objectMap, "formatSettings", d.FormatSettings)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", d.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", d.SinkRetryWait)
	populate(objectMap, "storeSettings", d.StoreSettings)
	objectMap["type"] = "DelimitedTextSink"
	populateAny(objectMap, "writeBatchSize", d.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", d.WriteBatchTimeout)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelimitedTextSink.
func (d *DelimitedTextSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "formatSettings":
			err = unpopulate(val, "FormatSettings", &d.FormatSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &d.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &d.SinkRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			d.StoreSettings, err = unmarshalStoreWriteSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &d.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &d.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelimitedTextSource.
func (d DelimitedTextSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populate(objectMap, "formatSettings", d.FormatSettings)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	populate(objectMap, "storeSettings", d.StoreSettings)
	objectMap["type"] = "DelimitedTextSource"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelimitedTextSource.
func (d *DelimitedTextSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "formatSettings":
			err = unpopulate(val, "FormatSettings", &d.FormatSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			d.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelimitedTextWriteSettings.
func (d DelimitedTextWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileExtension", d.FileExtension)
	populateAny(objectMap, "fileNamePrefix", d.FileNamePrefix)
	populateAny(objectMap, "maxRowsPerFile", d.MaxRowsPerFile)
	populateAny(objectMap, "quoteAllText", d.QuoteAllText)
	objectMap["type"] = "DelimitedTextWriteSettings"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelimitedTextWriteSettings.
func (d *DelimitedTextWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileExtension":
			err = unpopulate(val, "FileExtension", &d.FileExtension)
			delete(rawMsg, key)
		case "fileNamePrefix":
			err = unpopulate(val, "FileNamePrefix", &d.FileNamePrefix)
			delete(rawMsg, key)
		case "maxRowsPerFile":
			err = unpopulate(val, "MaxRowsPerFile", &d.MaxRowsPerFile)
			delete(rawMsg, key)
		case "quoteAllText":
			err = unpopulate(val, "QuoteAllText", &d.QuoteAllText)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DependencyReference.
func (d DependencyReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = d.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DependencyReference.
func (d *DependencyReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DistcpSettings.
func (d DistcpSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "distcpOptions", d.DistcpOptions)
	populateAny(objectMap, "resourceManagerEndpoint", d.ResourceManagerEndpoint)
	populateAny(objectMap, "tempScriptPath", d.TempScriptPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DistcpSettings.
func (d *DistcpSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distcpOptions":
			err = unpopulate(val, "DistcpOptions", &d.DistcpOptions)
			delete(rawMsg, key)
		case "resourceManagerEndpoint":
			err = unpopulate(val, "ResourceManagerEndpoint", &d.ResourceManagerEndpoint)
			delete(rawMsg, key)
		case "tempScriptPath":
			err = unpopulate(val, "TempScriptPath", &d.TempScriptPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbCollectionDataset.
func (d DocumentDbCollectionDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "DocumentDbCollection"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbCollectionDataset.
func (d *DocumentDbCollectionDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbCollectionDatasetTypeProperties.
func (d DocumentDbCollectionDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "collectionName", d.CollectionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbCollectionDatasetTypeProperties.
func (d *DocumentDbCollectionDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionName":
			err = unpopulate(val, "CollectionName", &d.CollectionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbCollectionSink.
func (d DocumentDbCollectionSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "nestingSeparator", d.NestingSeparator)
	populateAny(objectMap, "sinkRetryCount", d.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", d.SinkRetryWait)
	objectMap["type"] = "DocumentDbCollectionSink"
	populateAny(objectMap, "writeBatchSize", d.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", d.WriteBatchTimeout)
	populateAny(objectMap, "writeBehavior", d.WriteBehavior)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbCollectionSink.
func (d *DocumentDbCollectionSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "nestingSeparator":
			err = unpopulate(val, "NestingSeparator", &d.NestingSeparator)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &d.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &d.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &d.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &d.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &d.WriteBehavior)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DocumentDbCollectionSource.
func (d DocumentDbCollectionSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "nestingSeparator", d.NestingSeparator)
	populateAny(objectMap, "query", d.Query)
	populateAny(objectMap, "queryTimeout", d.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	objectMap["type"] = "DocumentDbCollectionSource"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DocumentDbCollectionSource.
func (d *DocumentDbCollectionSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "nestingSeparator":
			err = unpopulate(val, "NestingSeparator", &d.NestingSeparator)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &d.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &d.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DrillDatasetTypeProperties.
func (d DrillDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "table", d.Table)
	populateAny(objectMap, "tableName", d.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DrillDatasetTypeProperties.
func (d *DrillDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &d.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &d.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DrillLinkedService.
func (d DrillLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "connectVia", d.ConnectVia)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["type"] = "Drill"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DrillLinkedService.
func (d *DrillLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &d.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DrillLinkedServiceTypeProperties.
func (d DrillLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", d.ConnectionString)
	populate(objectMap, "encryptedCredential", d.EncryptedCredential)
	populate(objectMap, "pwd", d.Pwd)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DrillLinkedServiceTypeProperties.
func (d *DrillLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &d.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &d.EncryptedCredential)
			delete(rawMsg, key)
		case "pwd":
			err = unpopulate(val, "Pwd", &d.Pwd)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DrillSource.
func (d DrillSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "query", d.Query)
	populateAny(objectMap, "queryTimeout", d.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	objectMap["type"] = "DrillSource"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DrillSource.
func (d *DrillSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &d.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &d.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DrillTableDataset.
func (d DrillTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "DrillTable"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DrillTableDataset.
func (d *DrillTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsAXLinkedService.
func (d DynamicsAXLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "connectVia", d.ConnectVia)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["type"] = "DynamicsAX"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsAXLinkedService.
func (d *DynamicsAXLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &d.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsAXLinkedServiceTypeProperties.
func (d DynamicsAXLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "aadResourceId", d.AADResourceID)
	populate(objectMap, "encryptedCredential", d.EncryptedCredential)
	populateAny(objectMap, "servicePrincipalId", d.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", d.ServicePrincipalKey)
	populateAny(objectMap, "tenant", d.Tenant)
	populateAny(objectMap, "url", d.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsAXLinkedServiceTypeProperties.
func (d *DynamicsAXLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadResourceId":
			err = unpopulate(val, "AADResourceID", &d.AADResourceID)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &d.EncryptedCredential)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &d.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			d.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &d.Tenant)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &d.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsAXResourceDataset.
func (d DynamicsAXResourceDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "DynamicsAXResource"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsAXResourceDataset.
func (d *DynamicsAXResourceDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsAXResourceDatasetTypeProperties.
func (d DynamicsAXResourceDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "path", d.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsAXResourceDatasetTypeProperties.
func (d *DynamicsAXResourceDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &d.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsAXSource.
func (d DynamicsAXSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "httpRequestTimeout", d.HTTPRequestTimeout)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "query", d.Query)
	populateAny(objectMap, "queryTimeout", d.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	objectMap["type"] = "DynamicsAXSource"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsAXSource.
func (d *DynamicsAXSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "httpRequestTimeout":
			err = unpopulate(val, "HTTPRequestTimeout", &d.HTTPRequestTimeout)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &d.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &d.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsCrmEntityDataset.
func (d DynamicsCrmEntityDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "DynamicsCrmEntity"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsCrmEntityDataset.
func (d *DynamicsCrmEntityDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsCrmEntityDatasetTypeProperties.
func (d DynamicsCrmEntityDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "entityName", d.EntityName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsCrmEntityDatasetTypeProperties.
func (d *DynamicsCrmEntityDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityName":
			err = unpopulate(val, "EntityName", &d.EntityName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsCrmLinkedService.
func (d DynamicsCrmLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "connectVia", d.ConnectVia)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["type"] = "DynamicsCrm"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsCrmLinkedService.
func (d *DynamicsCrmLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &d.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsCrmLinkedServiceTypeProperties.
func (d DynamicsCrmLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authenticationType", d.AuthenticationType)
	populateAny(objectMap, "deploymentType", d.DeploymentType)
	populate(objectMap, "encryptedCredential", d.EncryptedCredential)
	populateAny(objectMap, "hostName", d.HostName)
	populateAny(objectMap, "organizationName", d.OrganizationName)
	populate(objectMap, "password", d.Password)
	populateAny(objectMap, "port", d.Port)
	populate(objectMap, "servicePrincipalCredential", d.ServicePrincipalCredential)
	populateAny(objectMap, "servicePrincipalCredentialType", d.ServicePrincipalCredentialType)
	populateAny(objectMap, "servicePrincipalId", d.ServicePrincipalID)
	populateAny(objectMap, "serviceUri", d.ServiceURI)
	populateAny(objectMap, "username", d.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsCrmLinkedServiceTypeProperties.
func (d *DynamicsCrmLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &d.AuthenticationType)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &d.DeploymentType)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &d.EncryptedCredential)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &d.HostName)
			delete(rawMsg, key)
		case "organizationName":
			err = unpopulate(val, "OrganizationName", &d.OrganizationName)
			delete(rawMsg, key)
		case "password":
			d.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &d.Port)
			delete(rawMsg, key)
		case "servicePrincipalCredential":
			d.ServicePrincipalCredential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "servicePrincipalCredentialType":
			err = unpopulate(val, "ServicePrincipalCredentialType", &d.ServicePrincipalCredentialType)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &d.ServicePrincipalID)
			delete(rawMsg, key)
		case "serviceUri":
			err = unpopulate(val, "ServiceURI", &d.ServiceURI)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &d.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsCrmSink.
func (d DynamicsCrmSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "alternateKeyName", d.AlternateKeyName)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "ignoreNullValues", d.IgnoreNullValues)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", d.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", d.SinkRetryWait)
	objectMap["type"] = "DynamicsCrmSink"
	populateAny(objectMap, "writeBatchSize", d.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", d.WriteBatchTimeout)
	populate(objectMap, "writeBehavior", d.WriteBehavior)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsCrmSink.
func (d *DynamicsCrmSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateKeyName":
			err = unpopulate(val, "AlternateKeyName", &d.AlternateKeyName)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "ignoreNullValues":
			err = unpopulate(val, "IgnoreNullValues", &d.IgnoreNullValues)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &d.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &d.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &d.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &d.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &d.WriteBehavior)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsCrmSource.
func (d DynamicsCrmSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "query", d.Query)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	objectMap["type"] = "DynamicsCrmSource"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsCrmSource.
func (d *DynamicsCrmSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &d.Query)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsEntityDataset.
func (d DynamicsEntityDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "folder", d.Folder)
	populate(objectMap, "linkedServiceName", d.LinkedServiceName)
	populate(objectMap, "parameters", d.Parameters)
	populateAny(objectMap, "schema", d.Schema)
	populateAny(objectMap, "structure", d.Structure)
	objectMap["type"] = "DynamicsEntity"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsEntityDataset.
func (d *DynamicsEntityDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &d.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &d.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &d.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &d.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsEntityDatasetTypeProperties.
func (d DynamicsEntityDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "entityName", d.EntityName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsEntityDatasetTypeProperties.
func (d *DynamicsEntityDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "entityName":
			err = unpopulate(val, "EntityName", &d.EntityName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsLinkedService.
func (d DynamicsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", d.Annotations)
	populate(objectMap, "connectVia", d.ConnectVia)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "parameters", d.Parameters)
	objectMap["type"] = "Dynamics"
	populate(objectMap, "typeProperties", d.TypeProperties)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsLinkedService.
func (d *DynamicsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &d.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &d.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &d.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &d.TypeProperties)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsLinkedServiceTypeProperties.
func (d DynamicsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authenticationType", d.AuthenticationType)
	populate(objectMap, "credential", d.Credential)
	populateAny(objectMap, "deploymentType", d.DeploymentType)
	populate(objectMap, "encryptedCredential", d.EncryptedCredential)
	populateAny(objectMap, "hostName", d.HostName)
	populateAny(objectMap, "organizationName", d.OrganizationName)
	populate(objectMap, "password", d.Password)
	populateAny(objectMap, "port", d.Port)
	populate(objectMap, "servicePrincipalCredential", d.ServicePrincipalCredential)
	populateAny(objectMap, "servicePrincipalCredentialType", d.ServicePrincipalCredentialType)
	populateAny(objectMap, "servicePrincipalId", d.ServicePrincipalID)
	populateAny(objectMap, "serviceUri", d.ServiceURI)
	populateAny(objectMap, "username", d.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsLinkedServiceTypeProperties.
func (d *DynamicsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &d.AuthenticationType)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &d.Credential)
			delete(rawMsg, key)
		case "deploymentType":
			err = unpopulate(val, "DeploymentType", &d.DeploymentType)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &d.EncryptedCredential)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &d.HostName)
			delete(rawMsg, key)
		case "organizationName":
			err = unpopulate(val, "OrganizationName", &d.OrganizationName)
			delete(rawMsg, key)
		case "password":
			d.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &d.Port)
			delete(rawMsg, key)
		case "servicePrincipalCredential":
			d.ServicePrincipalCredential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "servicePrincipalCredentialType":
			err = unpopulate(val, "ServicePrincipalCredentialType", &d.ServicePrincipalCredentialType)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &d.ServicePrincipalID)
			delete(rawMsg, key)
		case "serviceUri":
			err = unpopulate(val, "ServiceURI", &d.ServiceURI)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &d.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsSink.
func (d DynamicsSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "alternateKeyName", d.AlternateKeyName)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "ignoreNullValues", d.IgnoreNullValues)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", d.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", d.SinkRetryWait)
	objectMap["type"] = "DynamicsSink"
	populateAny(objectMap, "writeBatchSize", d.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", d.WriteBatchTimeout)
	populate(objectMap, "writeBehavior", d.WriteBehavior)
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsSink.
func (d *DynamicsSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "alternateKeyName":
			err = unpopulate(val, "AlternateKeyName", &d.AlternateKeyName)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "ignoreNullValues":
			err = unpopulate(val, "IgnoreNullValues", &d.IgnoreNullValues)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &d.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &d.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &d.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &d.WriteBatchTimeout)
			delete(rawMsg, key)
		case "writeBehavior":
			err = unpopulate(val, "WriteBehavior", &d.WriteBehavior)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DynamicsSource.
func (d DynamicsSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", d.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", d.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", d.MaxConcurrentConnections)
	populateAny(objectMap, "query", d.Query)
	populateAny(objectMap, "sourceRetryCount", d.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", d.SourceRetryWait)
	objectMap["type"] = "DynamicsSource"
	if d.AdditionalProperties != nil {
		for key, val := range d.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DynamicsSource.
func (d *DynamicsSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &d.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &d.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &d.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &d.Query)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &d.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &d.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		default:
			if d.AdditionalProperties == nil {
				d.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				d.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EloquaLinkedService.
func (e EloquaLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", e.Annotations)
	populate(objectMap, "connectVia", e.ConnectVia)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "parameters", e.Parameters)
	objectMap["type"] = "Eloqua"
	populate(objectMap, "typeProperties", e.TypeProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EloquaLinkedService.
func (e *EloquaLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &e.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &e.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EloquaLinkedServiceTypeProperties.
func (e EloquaLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptedCredential", e.EncryptedCredential)
	populateAny(objectMap, "endpoint", e.Endpoint)
	populate(objectMap, "password", e.Password)
	populateAny(objectMap, "useEncryptedEndpoints", e.UseEncryptedEndpoints)
	populateAny(objectMap, "useHostVerification", e.UseHostVerification)
	populateAny(objectMap, "usePeerVerification", e.UsePeerVerification)
	populateAny(objectMap, "username", e.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EloquaLinkedServiceTypeProperties.
func (e *EloquaLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &e.EncryptedCredential)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &e.Endpoint)
			delete(rawMsg, key)
		case "password":
			e.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "useEncryptedEndpoints":
			err = unpopulate(val, "UseEncryptedEndpoints", &e.UseEncryptedEndpoints)
			delete(rawMsg, key)
		case "useHostVerification":
			err = unpopulate(val, "UseHostVerification", &e.UseHostVerification)
			delete(rawMsg, key)
		case "usePeerVerification":
			err = unpopulate(val, "UsePeerVerification", &e.UsePeerVerification)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &e.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EloquaObjectDataset.
func (e EloquaObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", e.Annotations)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "folder", e.Folder)
	populate(objectMap, "linkedServiceName", e.LinkedServiceName)
	populate(objectMap, "parameters", e.Parameters)
	populateAny(objectMap, "schema", e.Schema)
	populateAny(objectMap, "structure", e.Structure)
	objectMap["type"] = "EloquaObject"
	populate(objectMap, "typeProperties", e.TypeProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EloquaObjectDataset.
func (e *EloquaObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &e.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &e.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &e.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &e.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &e.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EloquaSource.
func (e EloquaSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", e.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", e.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", e.MaxConcurrentConnections)
	populateAny(objectMap, "query", e.Query)
	populateAny(objectMap, "queryTimeout", e.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", e.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", e.SourceRetryWait)
	objectMap["type"] = "EloquaSource"
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EloquaSource.
func (e *EloquaSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &e.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &e.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &e.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &e.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &e.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &e.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &e.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionConfiguration.
func (e EncryptionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", e.Identity)
	populate(objectMap, "keyName", e.KeyName)
	populate(objectMap, "keyVersion", e.KeyVersion)
	populate(objectMap, "vaultBaseUrl", e.VaultBaseURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionConfiguration.
func (e *EncryptionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &e.Identity)
			delete(rawMsg, key)
		case "keyName":
			err = unpopulate(val, "KeyName", &e.KeyName)
			delete(rawMsg, key)
		case "keyVersion":
			err = unpopulate(val, "KeyVersion", &e.KeyVersion)
			delete(rawMsg, key)
		case "vaultBaseUrl":
			err = unpopulate(val, "VaultBaseURL", &e.VaultBaseURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EntityReference.
func (e EntityReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "referenceName", e.ReferenceName)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EntityReference.
func (e *EntityReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &e.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariableSetup.
func (e EnvironmentVariableSetup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = "EnvironmentVariableSetup"
	populate(objectMap, "typeProperties", e.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariableSetup.
func (e *EnvironmentVariableSetup) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVariableSetupTypeProperties.
func (e EnvironmentVariableSetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "variableName", e.VariableName)
	populate(objectMap, "variableValue", e.VariableValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVariableSetupTypeProperties.
func (e *EnvironmentVariableSetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "variableName":
			err = unpopulate(val, "VariableName", &e.VariableName)
			delete(rawMsg, key)
		case "variableValue":
			err = unpopulate(val, "VariableValue", &e.VariableValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExcelDataset.
func (e ExcelDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", e.Annotations)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "folder", e.Folder)
	populate(objectMap, "linkedServiceName", e.LinkedServiceName)
	populate(objectMap, "parameters", e.Parameters)
	populateAny(objectMap, "schema", e.Schema)
	populateAny(objectMap, "structure", e.Structure)
	objectMap["type"] = "Excel"
	populate(objectMap, "typeProperties", e.TypeProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExcelDataset.
func (e *ExcelDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &e.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &e.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &e.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &e.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &e.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExcelDatasetTypeProperties.
func (e ExcelDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", e.Compression)
	populateAny(objectMap, "firstRowAsHeader", e.FirstRowAsHeader)
	populate(objectMap, "location", e.Location)
	populateAny(objectMap, "nullValue", e.NullValue)
	populateAny(objectMap, "range", e.Range)
	populateAny(objectMap, "sheetIndex", e.SheetIndex)
	populateAny(objectMap, "sheetName", e.SheetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExcelDatasetTypeProperties.
func (e *ExcelDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &e.Compression)
			delete(rawMsg, key)
		case "firstRowAsHeader":
			err = unpopulate(val, "FirstRowAsHeader", &e.FirstRowAsHeader)
			delete(rawMsg, key)
		case "location":
			e.Location, err = unmarshalDatasetLocationClassification(val)
			delete(rawMsg, key)
		case "nullValue":
			err = unpopulate(val, "NullValue", &e.NullValue)
			delete(rawMsg, key)
		case "range":
			err = unpopulate(val, "Range", &e.Range)
			delete(rawMsg, key)
		case "sheetIndex":
			err = unpopulate(val, "SheetIndex", &e.SheetIndex)
			delete(rawMsg, key)
		case "sheetName":
			err = unpopulate(val, "SheetName", &e.SheetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExcelSource.
func (e ExcelSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", e.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", e.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", e.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", e.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", e.SourceRetryWait)
	populate(objectMap, "storeSettings", e.StoreSettings)
	objectMap["type"] = "ExcelSource"
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExcelSource.
func (e *ExcelSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &e.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &e.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &e.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &e.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &e.SourceRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			e.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteDataFlowActivity.
func (e ExecuteDataFlowActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", e.DependsOn)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "linkedServiceName", e.LinkedServiceName)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "onInactiveMarkAs", e.OnInactiveMarkAs)
	populate(objectMap, "policy", e.Policy)
	populate(objectMap, "state", e.State)
	objectMap["type"] = "ExecuteDataFlow"
	populate(objectMap, "typeProperties", e.TypeProperties)
	populate(objectMap, "userProperties", e.UserProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteDataFlowActivity.
func (e *ExecuteDataFlowActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &e.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &e.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &e.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &e.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &e.UserProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteDataFlowActivityTypeProperties.
func (e ExecuteDataFlowActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compute", e.Compute)
	populateAny(objectMap, "continueOnError", e.ContinueOnError)
	populate(objectMap, "dataFlow", e.DataFlow)
	populate(objectMap, "integrationRuntime", e.IntegrationRuntime)
	populateAny(objectMap, "runConcurrently", e.RunConcurrently)
	populateAny(objectMap, "sourceStagingConcurrency", e.SourceStagingConcurrency)
	populate(objectMap, "staging", e.Staging)
	populateAny(objectMap, "traceLevel", e.TraceLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteDataFlowActivityTypeProperties.
func (e *ExecuteDataFlowActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compute":
			err = unpopulate(val, "Compute", &e.Compute)
			delete(rawMsg, key)
		case "continueOnError":
			err = unpopulate(val, "ContinueOnError", &e.ContinueOnError)
			delete(rawMsg, key)
		case "dataFlow":
			err = unpopulate(val, "DataFlow", &e.DataFlow)
			delete(rawMsg, key)
		case "integrationRuntime":
			err = unpopulate(val, "IntegrationRuntime", &e.IntegrationRuntime)
			delete(rawMsg, key)
		case "runConcurrently":
			err = unpopulate(val, "RunConcurrently", &e.RunConcurrently)
			delete(rawMsg, key)
		case "sourceStagingConcurrency":
			err = unpopulate(val, "SourceStagingConcurrency", &e.SourceStagingConcurrency)
			delete(rawMsg, key)
		case "staging":
			err = unpopulate(val, "Staging", &e.Staging)
			delete(rawMsg, key)
		case "traceLevel":
			err = unpopulate(val, "TraceLevel", &e.TraceLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteDataFlowActivityTypePropertiesCompute.
func (e ExecuteDataFlowActivityTypePropertiesCompute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "computeType", e.ComputeType)
	populateAny(objectMap, "coreCount", e.CoreCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteDataFlowActivityTypePropertiesCompute.
func (e *ExecuteDataFlowActivityTypePropertiesCompute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeType":
			err = unpopulate(val, "ComputeType", &e.ComputeType)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &e.CoreCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecutePipelineActivity.
func (e ExecutePipelineActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", e.DependsOn)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "onInactiveMarkAs", e.OnInactiveMarkAs)
	populate(objectMap, "policy", e.Policy)
	populate(objectMap, "state", e.State)
	objectMap["type"] = "ExecutePipeline"
	populate(objectMap, "typeProperties", e.TypeProperties)
	populate(objectMap, "userProperties", e.UserProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecutePipelineActivity.
func (e *ExecutePipelineActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &e.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &e.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &e.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &e.UserProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecutePipelineActivityPolicy.
func (e ExecutePipelineActivityPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "secureInput", e.SecureInput)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecutePipelineActivityPolicy.
func (e *ExecutePipelineActivityPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secureInput":
			err = unpopulate(val, "SecureInput", &e.SecureInput)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecutePipelineActivityTypeProperties.
func (e ExecutePipelineActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", e.Parameters)
	populate(objectMap, "pipeline", e.Pipeline)
	populate(objectMap, "waitOnCompletion", e.WaitOnCompletion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecutePipelineActivityTypeProperties.
func (e *ExecutePipelineActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		case "pipeline":
			err = unpopulate(val, "Pipeline", &e.Pipeline)
			delete(rawMsg, key)
		case "waitOnCompletion":
			err = unpopulate(val, "WaitOnCompletion", &e.WaitOnCompletion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecutePowerQueryActivityTypeProperties.
func (e ExecutePowerQueryActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compute", e.Compute)
	populateAny(objectMap, "continueOnError", e.ContinueOnError)
	populate(objectMap, "dataFlow", e.DataFlow)
	populate(objectMap, "integrationRuntime", e.IntegrationRuntime)
	populate(objectMap, "queries", e.Queries)
	populateAny(objectMap, "runConcurrently", e.RunConcurrently)
	populate(objectMap, "sinks", e.Sinks)
	populateAny(objectMap, "sourceStagingConcurrency", e.SourceStagingConcurrency)
	populate(objectMap, "staging", e.Staging)
	populateAny(objectMap, "traceLevel", e.TraceLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecutePowerQueryActivityTypeProperties.
func (e *ExecutePowerQueryActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compute":
			err = unpopulate(val, "Compute", &e.Compute)
			delete(rawMsg, key)
		case "continueOnError":
			err = unpopulate(val, "ContinueOnError", &e.ContinueOnError)
			delete(rawMsg, key)
		case "dataFlow":
			err = unpopulate(val, "DataFlow", &e.DataFlow)
			delete(rawMsg, key)
		case "integrationRuntime":
			err = unpopulate(val, "IntegrationRuntime", &e.IntegrationRuntime)
			delete(rawMsg, key)
		case "queries":
			err = unpopulate(val, "Queries", &e.Queries)
			delete(rawMsg, key)
		case "runConcurrently":
			err = unpopulate(val, "RunConcurrently", &e.RunConcurrently)
			delete(rawMsg, key)
		case "sinks":
			err = unpopulate(val, "Sinks", &e.Sinks)
			delete(rawMsg, key)
		case "sourceStagingConcurrency":
			err = unpopulate(val, "SourceStagingConcurrency", &e.SourceStagingConcurrency)
			delete(rawMsg, key)
		case "staging":
			err = unpopulate(val, "Staging", &e.Staging)
			delete(rawMsg, key)
		case "traceLevel":
			err = unpopulate(val, "TraceLevel", &e.TraceLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteSSISPackageActivity.
func (e ExecuteSSISPackageActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", e.DependsOn)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "linkedServiceName", e.LinkedServiceName)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "onInactiveMarkAs", e.OnInactiveMarkAs)
	populate(objectMap, "policy", e.Policy)
	populate(objectMap, "state", e.State)
	objectMap["type"] = "ExecuteSSISPackage"
	populate(objectMap, "typeProperties", e.TypeProperties)
	populate(objectMap, "userProperties", e.UserProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteSSISPackageActivity.
func (e *ExecuteSSISPackageActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &e.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &e.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &e.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &e.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &e.UserProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteSSISPackageActivityTypeProperties.
func (e ExecuteSSISPackageActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectVia", e.ConnectVia)
	populateAny(objectMap, "environmentPath", e.EnvironmentPath)
	populate(objectMap, "executionCredential", e.ExecutionCredential)
	populate(objectMap, "logLocation", e.LogLocation)
	populateAny(objectMap, "loggingLevel", e.LoggingLevel)
	populate(objectMap, "packageConnectionManagers", e.PackageConnectionManagers)
	populate(objectMap, "packageLocation", e.PackageLocation)
	populate(objectMap, "packageParameters", e.PackageParameters)
	populate(objectMap, "projectConnectionManagers", e.ProjectConnectionManagers)
	populate(objectMap, "projectParameters", e.ProjectParameters)
	populate(objectMap, "propertyOverrides", e.PropertyOverrides)
	populateAny(objectMap, "runtime", e.Runtime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteSSISPackageActivityTypeProperties.
func (e *ExecuteSSISPackageActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &e.ConnectVia)
			delete(rawMsg, key)
		case "environmentPath":
			err = unpopulate(val, "EnvironmentPath", &e.EnvironmentPath)
			delete(rawMsg, key)
		case "executionCredential":
			err = unpopulate(val, "ExecutionCredential", &e.ExecutionCredential)
			delete(rawMsg, key)
		case "logLocation":
			err = unpopulate(val, "LogLocation", &e.LogLocation)
			delete(rawMsg, key)
		case "loggingLevel":
			err = unpopulate(val, "LoggingLevel", &e.LoggingLevel)
			delete(rawMsg, key)
		case "packageConnectionManagers":
			err = unpopulate(val, "PackageConnectionManagers", &e.PackageConnectionManagers)
			delete(rawMsg, key)
		case "packageLocation":
			err = unpopulate(val, "PackageLocation", &e.PackageLocation)
			delete(rawMsg, key)
		case "packageParameters":
			err = unpopulate(val, "PackageParameters", &e.PackageParameters)
			delete(rawMsg, key)
		case "projectConnectionManagers":
			err = unpopulate(val, "ProjectConnectionManagers", &e.ProjectConnectionManagers)
			delete(rawMsg, key)
		case "projectParameters":
			err = unpopulate(val, "ProjectParameters", &e.ProjectParameters)
			delete(rawMsg, key)
		case "propertyOverrides":
			err = unpopulate(val, "PropertyOverrides", &e.PropertyOverrides)
			delete(rawMsg, key)
		case "runtime":
			err = unpopulate(val, "Runtime", &e.Runtime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecuteWranglingDataflowActivity.
func (e ExecuteWranglingDataflowActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", e.DependsOn)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "onInactiveMarkAs", e.OnInactiveMarkAs)
	populate(objectMap, "policy", e.Policy)
	populate(objectMap, "state", e.State)
	objectMap["type"] = "ExecuteWranglingDataflow"
	populate(objectMap, "typeProperties", e.TypeProperties)
	populate(objectMap, "userProperties", e.UserProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecuteWranglingDataflowActivity.
func (e *ExecuteWranglingDataflowActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &e.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &e.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &e.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &e.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &e.UserProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExecutionActivity.
func (e ExecutionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", e.DependsOn)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "linkedServiceName", e.LinkedServiceName)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "onInactiveMarkAs", e.OnInactiveMarkAs)
	populate(objectMap, "policy", e.Policy)
	populate(objectMap, "state", e.State)
	objectMap["type"] = "Execution"
	populate(objectMap, "userProperties", e.UserProperties)
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExecutionActivity.
func (e *ExecutionActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &e.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &e.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &e.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &e.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &e.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &e.UserProperties)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportSettings.
func (e ExportSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = e.Type
	if e.AdditionalProperties != nil {
		for key, val := range e.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportSettings.
func (e *ExportSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		default:
			if e.AdditionalProperties == nil {
				e.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				e.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExposureControlBatchRequest.
func (e ExposureControlBatchRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exposureControlRequests", e.ExposureControlRequests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExposureControlBatchRequest.
func (e *ExposureControlBatchRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exposureControlRequests":
			err = unpopulate(val, "ExposureControlRequests", &e.ExposureControlRequests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExposureControlBatchResponse.
func (e ExposureControlBatchResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exposureControlResponses", e.ExposureControlResponses)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExposureControlBatchResponse.
func (e *ExposureControlBatchResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exposureControlResponses":
			err = unpopulate(val, "ExposureControlResponses", &e.ExposureControlResponses)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExposureControlRequest.
func (e ExposureControlRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featureName", e.FeatureName)
	populate(objectMap, "featureType", e.FeatureType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExposureControlRequest.
func (e *ExposureControlRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureName":
			err = unpopulate(val, "FeatureName", &e.FeatureName)
			delete(rawMsg, key)
		case "featureType":
			err = unpopulate(val, "FeatureType", &e.FeatureType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExposureControlResponse.
func (e ExposureControlResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featureName", e.FeatureName)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExposureControlResponse.
func (e *ExposureControlResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featureName":
			err = unpopulate(val, "FeatureName", &e.FeatureName)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Expression.
func (e Expression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", e.Type)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Expression.
func (e *Expression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Factory.
func (f Factory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", f.ETag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "identity", f.Identity)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Factory.
func (f *Factory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &f.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &f.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryGitHubConfiguration.
func (f FactoryGitHubConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", f.AccountName)
	populate(objectMap, "clientId", f.ClientID)
	populate(objectMap, "clientSecret", f.ClientSecret)
	populate(objectMap, "collaborationBranch", f.CollaborationBranch)
	populate(objectMap, "disablePublish", f.DisablePublish)
	populate(objectMap, "hostName", f.HostName)
	populate(objectMap, "lastCommitId", f.LastCommitID)
	populate(objectMap, "repositoryName", f.RepositoryName)
	populate(objectMap, "rootFolder", f.RootFolder)
	objectMap["type"] = "FactoryGitHubConfiguration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryGitHubConfiguration.
func (f *FactoryGitHubConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &f.AccountName)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &f.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &f.ClientSecret)
			delete(rawMsg, key)
		case "collaborationBranch":
			err = unpopulate(val, "CollaborationBranch", &f.CollaborationBranch)
			delete(rawMsg, key)
		case "disablePublish":
			err = unpopulate(val, "DisablePublish", &f.DisablePublish)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &f.HostName)
			delete(rawMsg, key)
		case "lastCommitId":
			err = unpopulate(val, "LastCommitID", &f.LastCommitID)
			delete(rawMsg, key)
		case "repositoryName":
			err = unpopulate(val, "RepositoryName", &f.RepositoryName)
			delete(rawMsg, key)
		case "rootFolder":
			err = unpopulate(val, "RootFolder", &f.RootFolder)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryIdentity.
func (f FactoryIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", f.PrincipalID)
	populate(objectMap, "tenantId", f.TenantID)
	populate(objectMap, "type", f.Type)
	populate(objectMap, "userAssignedIdentities", f.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryIdentity.
func (f *FactoryIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &f.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &f.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &f.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryListResponse.
func (f FactoryListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryListResponse.
func (f *FactoryListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryProperties.
func (f FactoryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", f.CreateTime)
	populate(objectMap, "encryption", f.Encryption)
	populate(objectMap, "globalParameters", f.GlobalParameters)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", f.PublicNetworkAccess)
	populate(objectMap, "purviewConfiguration", f.PurviewConfiguration)
	populate(objectMap, "repoConfiguration", f.RepoConfiguration)
	populate(objectMap, "version", f.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryProperties.
func (f *FactoryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &f.CreateTime)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &f.Encryption)
			delete(rawMsg, key)
		case "globalParameters":
			err = unpopulate(val, "GlobalParameters", &f.GlobalParameters)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &f.PublicNetworkAccess)
			delete(rawMsg, key)
		case "purviewConfiguration":
			err = unpopulate(val, "PurviewConfiguration", &f.PurviewConfiguration)
			delete(rawMsg, key)
		case "repoConfiguration":
			f.RepoConfiguration, err = unmarshalFactoryRepoConfigurationClassification(val)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &f.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryRepoConfiguration.
func (f FactoryRepoConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", f.AccountName)
	populate(objectMap, "collaborationBranch", f.CollaborationBranch)
	populate(objectMap, "disablePublish", f.DisablePublish)
	populate(objectMap, "lastCommitId", f.LastCommitID)
	populate(objectMap, "repositoryName", f.RepositoryName)
	populate(objectMap, "rootFolder", f.RootFolder)
	objectMap["type"] = f.Type
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryRepoConfiguration.
func (f *FactoryRepoConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &f.AccountName)
			delete(rawMsg, key)
		case "collaborationBranch":
			err = unpopulate(val, "CollaborationBranch", &f.CollaborationBranch)
			delete(rawMsg, key)
		case "disablePublish":
			err = unpopulate(val, "DisablePublish", &f.DisablePublish)
			delete(rawMsg, key)
		case "lastCommitId":
			err = unpopulate(val, "LastCommitID", &f.LastCommitID)
			delete(rawMsg, key)
		case "repositoryName":
			err = unpopulate(val, "RepositoryName", &f.RepositoryName)
			delete(rawMsg, key)
		case "rootFolder":
			err = unpopulate(val, "RootFolder", &f.RootFolder)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryRepoUpdate.
func (f FactoryRepoUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "factoryResourceId", f.FactoryResourceID)
	populate(objectMap, "repoConfiguration", f.RepoConfiguration)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryRepoUpdate.
func (f *FactoryRepoUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "factoryResourceId":
			err = unpopulate(val, "FactoryResourceID", &f.FactoryResourceID)
			delete(rawMsg, key)
		case "repoConfiguration":
			f.RepoConfiguration, err = unmarshalFactoryRepoConfigurationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryUpdateParameters.
func (f FactoryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", f.Identity)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryUpdateParameters.
func (f *FactoryUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &f.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryUpdateProperties.
func (f FactoryUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicNetworkAccess", f.PublicNetworkAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryUpdateProperties.
func (f *FactoryUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &f.PublicNetworkAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FactoryVSTSConfiguration.
func (f FactoryVSTSConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", f.AccountName)
	populate(objectMap, "collaborationBranch", f.CollaborationBranch)
	populate(objectMap, "disablePublish", f.DisablePublish)
	populate(objectMap, "lastCommitId", f.LastCommitID)
	populate(objectMap, "projectName", f.ProjectName)
	populate(objectMap, "repositoryName", f.RepositoryName)
	populate(objectMap, "rootFolder", f.RootFolder)
	populate(objectMap, "tenantId", f.TenantID)
	objectMap["type"] = "FactoryVSTSConfiguration"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FactoryVSTSConfiguration.
func (f *FactoryVSTSConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &f.AccountName)
			delete(rawMsg, key)
		case "collaborationBranch":
			err = unpopulate(val, "CollaborationBranch", &f.CollaborationBranch)
			delete(rawMsg, key)
		case "disablePublish":
			err = unpopulate(val, "DisablePublish", &f.DisablePublish)
			delete(rawMsg, key)
		case "lastCommitId":
			err = unpopulate(val, "LastCommitID", &f.LastCommitID)
			delete(rawMsg, key)
		case "projectName":
			err = unpopulate(val, "ProjectName", &f.ProjectName)
			delete(rawMsg, key)
		case "repositoryName":
			err = unpopulate(val, "RepositoryName", &f.RepositoryName)
			delete(rawMsg, key)
		case "rootFolder":
			err = unpopulate(val, "RootFolder", &f.RootFolder)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &f.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailActivity.
func (f FailActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", f.DependsOn)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "onInactiveMarkAs", f.OnInactiveMarkAs)
	populate(objectMap, "state", f.State)
	objectMap["type"] = "Fail"
	populate(objectMap, "typeProperties", f.TypeProperties)
	populate(objectMap, "userProperties", f.UserProperties)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailActivity.
func (f *FailActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &f.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &f.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &f.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &f.UserProperties)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailActivityTypeProperties.
func (f FailActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "errorCode", f.ErrorCode)
	populateAny(objectMap, "message", f.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailActivityTypeProperties.
func (f *FailActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorCode":
			err = unpopulate(val, "ErrorCode", &f.ErrorCode)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &f.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServerLinkedService.
func (f FileServerLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", f.Annotations)
	populate(objectMap, "connectVia", f.ConnectVia)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "parameters", f.Parameters)
	objectMap["type"] = "FileServer"
	populate(objectMap, "typeProperties", f.TypeProperties)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServerLinkedService.
func (f *FileServerLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &f.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &f.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &f.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServerLinkedServiceTypeProperties.
func (f FileServerLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptedCredential", f.EncryptedCredential)
	populateAny(objectMap, "host", f.Host)
	populate(objectMap, "password", f.Password)
	populateAny(objectMap, "userId", f.UserID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServerLinkedServiceTypeProperties.
func (f *FileServerLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &f.EncryptedCredential)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &f.Host)
			delete(rawMsg, key)
		case "password":
			f.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "userId":
			err = unpopulate(val, "UserID", &f.UserID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServerLocation.
func (f FileServerLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", f.FileName)
	populateAny(objectMap, "folderPath", f.FolderPath)
	objectMap["type"] = "FileServerLocation"
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServerLocation.
func (f *FileServerLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &f.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &f.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServerReadSettings.
func (f FileServerReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", f.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", f.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", f.EnablePartitionDiscovery)
	populateAny(objectMap, "fileFilter", f.FileFilter)
	populateAny(objectMap, "fileListPath", f.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", f.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", f.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", f.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", f.PartitionRootPath)
	populateAny(objectMap, "recursive", f.Recursive)
	objectMap["type"] = "FileServerReadSettings"
	populateAny(objectMap, "wildcardFileName", f.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", f.WildcardFolderPath)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServerReadSettings.
func (f *FileServerReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &f.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &f.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &f.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileFilter":
			err = unpopulate(val, "FileFilter", &f.FileFilter)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &f.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &f.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &f.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &f.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &f.PartitionRootPath)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &f.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &f.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &f.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileServerWriteSettings.
func (f FileServerWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", f.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", f.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", f.MaxConcurrentConnections)
	objectMap["type"] = "FileServerWriteSettings"
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileServerWriteSettings.
func (f *FileServerWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &f.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &f.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &f.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileShareDataset.
func (f FileShareDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", f.Annotations)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "folder", f.Folder)
	populate(objectMap, "linkedServiceName", f.LinkedServiceName)
	populate(objectMap, "parameters", f.Parameters)
	populateAny(objectMap, "schema", f.Schema)
	populateAny(objectMap, "structure", f.Structure)
	objectMap["type"] = "FileShare"
	populate(objectMap, "typeProperties", f.TypeProperties)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileShareDataset.
func (f *FileShareDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &f.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &f.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &f.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &f.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &f.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &f.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileShareDatasetTypeProperties.
func (f FileShareDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", f.Compression)
	populateAny(objectMap, "fileFilter", f.FileFilter)
	populateAny(objectMap, "fileName", f.FileName)
	populateAny(objectMap, "folderPath", f.FolderPath)
	populate(objectMap, "format", f.Format)
	populateAny(objectMap, "modifiedDatetimeEnd", f.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", f.ModifiedDatetimeStart)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileShareDatasetTypeProperties.
func (f *FileShareDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &f.Compression)
			delete(rawMsg, key)
		case "fileFilter":
			err = unpopulate(val, "FileFilter", &f.FileFilter)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &f.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &f.FolderPath)
			delete(rawMsg, key)
		case "format":
			f.Format, err = unmarshalDatasetStorageFormatClassification(val)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &f.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &f.ModifiedDatetimeStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemSink.
func (f FileSystemSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", f.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", f.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", f.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", f.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", f.SinkRetryWait)
	objectMap["type"] = "FileSystemSink"
	populateAny(objectMap, "writeBatchSize", f.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", f.WriteBatchTimeout)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemSink.
func (f *FileSystemSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &f.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &f.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &f.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &f.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &f.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &f.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &f.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileSystemSource.
func (f FileSystemSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", f.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", f.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", f.MaxConcurrentConnections)
	populateAny(objectMap, "recursive", f.Recursive)
	populateAny(objectMap, "sourceRetryCount", f.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", f.SourceRetryWait)
	objectMap["type"] = "FileSystemSource"
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileSystemSource.
func (f *FileSystemSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &f.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &f.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &f.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &f.Recursive)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &f.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &f.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterActivity.
func (f FilterActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", f.DependsOn)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "onInactiveMarkAs", f.OnInactiveMarkAs)
	populate(objectMap, "state", f.State)
	objectMap["type"] = "Filter"
	populate(objectMap, "typeProperties", f.TypeProperties)
	populate(objectMap, "userProperties", f.UserProperties)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterActivity.
func (f *FilterActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &f.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &f.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &f.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &f.UserProperties)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FilterActivityTypeProperties.
func (f FilterActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "condition", f.Condition)
	populate(objectMap, "items", f.Items)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FilterActivityTypeProperties.
func (f *FilterActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "condition":
			err = unpopulate(val, "Condition", &f.Condition)
			delete(rawMsg, key)
		case "items":
			err = unpopulate(val, "Items", &f.Items)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Flowlet.
func (f Flowlet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", f.Annotations)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "folder", f.Folder)
	objectMap["type"] = "Flowlet"
	populate(objectMap, "typeProperties", f.TypeProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Flowlet.
func (f *Flowlet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &f.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &f.Folder)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlowletTypeProperties.
func (f FlowletTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "script", f.Script)
	populate(objectMap, "scriptLines", f.ScriptLines)
	populate(objectMap, "sinks", f.Sinks)
	populate(objectMap, "sources", f.Sources)
	populate(objectMap, "transformations", f.Transformations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlowletTypeProperties.
func (f *FlowletTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "script":
			err = unpopulate(val, "Script", &f.Script)
			delete(rawMsg, key)
		case "scriptLines":
			err = unpopulate(val, "ScriptLines", &f.ScriptLines)
			delete(rawMsg, key)
		case "sinks":
			err = unpopulate(val, "Sinks", &f.Sinks)
			delete(rawMsg, key)
		case "sources":
			err = unpopulate(val, "Sources", &f.Sources)
			delete(rawMsg, key)
		case "transformations":
			err = unpopulate(val, "Transformations", &f.Transformations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForEachActivity.
func (f ForEachActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", f.DependsOn)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "onInactiveMarkAs", f.OnInactiveMarkAs)
	populate(objectMap, "state", f.State)
	objectMap["type"] = "ForEach"
	populate(objectMap, "typeProperties", f.TypeProperties)
	populate(objectMap, "userProperties", f.UserProperties)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForEachActivity.
func (f *ForEachActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &f.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &f.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &f.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &f.UserProperties)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForEachActivityTypeProperties.
func (f ForEachActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activities", f.Activities)
	populate(objectMap, "batchCount", f.BatchCount)
	populate(objectMap, "isSequential", f.IsSequential)
	populate(objectMap, "items", f.Items)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForEachActivityTypeProperties.
func (f *ForEachActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activities":
			f.Activities, err = unmarshalActivityClassificationArray(val)
			delete(rawMsg, key)
		case "batchCount":
			err = unpopulate(val, "BatchCount", &f.BatchCount)
			delete(rawMsg, key)
		case "isSequential":
			err = unpopulate(val, "IsSequential", &f.IsSequential)
			delete(rawMsg, key)
		case "items":
			err = unpopulate(val, "Items", &f.Items)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FormatReadSettings.
func (f FormatReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = f.Type
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormatReadSettings.
func (f *FormatReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FormatWriteSettings.
func (f FormatWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = f.Type
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormatWriteSettings.
func (f *FormatWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FtpReadSettings.
func (f FtpReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", f.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableChunking", f.DisableChunking)
	populateAny(objectMap, "disableMetricsCollection", f.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", f.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", f.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", f.MaxConcurrentConnections)
	populateAny(objectMap, "partitionRootPath", f.PartitionRootPath)
	populateAny(objectMap, "recursive", f.Recursive)
	objectMap["type"] = "FtpReadSettings"
	populateAny(objectMap, "useBinaryTransfer", f.UseBinaryTransfer)
	populateAny(objectMap, "wildcardFileName", f.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", f.WildcardFolderPath)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FtpReadSettings.
func (f *FtpReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &f.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableChunking":
			err = unpopulate(val, "DisableChunking", &f.DisableChunking)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &f.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &f.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &f.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &f.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &f.PartitionRootPath)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &f.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "useBinaryTransfer":
			err = unpopulate(val, "UseBinaryTransfer", &f.UseBinaryTransfer)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &f.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &f.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FtpServerLinkedService.
func (f FtpServerLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", f.Annotations)
	populate(objectMap, "connectVia", f.ConnectVia)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "parameters", f.Parameters)
	objectMap["type"] = "FtpServer"
	populate(objectMap, "typeProperties", f.TypeProperties)
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FtpServerLinkedService.
func (f *FtpServerLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &f.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &f.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &f.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &f.TypeProperties)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FtpServerLinkedServiceTypeProperties.
func (f FtpServerLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationType", f.AuthenticationType)
	populateAny(objectMap, "enableSsl", f.EnableSSL)
	populateAny(objectMap, "enableServerCertificateValidation", f.EnableServerCertificateValidation)
	populate(objectMap, "encryptedCredential", f.EncryptedCredential)
	populateAny(objectMap, "host", f.Host)
	populate(objectMap, "password", f.Password)
	populateAny(objectMap, "port", f.Port)
	populateAny(objectMap, "userName", f.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FtpServerLinkedServiceTypeProperties.
func (f *FtpServerLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &f.AuthenticationType)
			delete(rawMsg, key)
		case "enableSsl":
			err = unpopulate(val, "EnableSSL", &f.EnableSSL)
			delete(rawMsg, key)
		case "enableServerCertificateValidation":
			err = unpopulate(val, "EnableServerCertificateValidation", &f.EnableServerCertificateValidation)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &f.EncryptedCredential)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &f.Host)
			delete(rawMsg, key)
		case "password":
			f.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &f.Port)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &f.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FtpServerLocation.
func (f FtpServerLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", f.FileName)
	populateAny(objectMap, "folderPath", f.FolderPath)
	objectMap["type"] = "FtpServerLocation"
	if f.AdditionalProperties != nil {
		for key, val := range f.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FtpServerLocation.
func (f *FtpServerLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &f.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &f.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		default:
			if f.AdditionalProperties == nil {
				f.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				f.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenericDatasetTypeProperties.
func (g GenericDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "tableName", g.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenericDatasetTypeProperties.
func (g *GenericDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tableName":
			err = unpopulate(val, "TableName", &g.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetMetadataActivity.
func (g GetMetadataActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", g.DependsOn)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "linkedServiceName", g.LinkedServiceName)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "onInactiveMarkAs", g.OnInactiveMarkAs)
	populate(objectMap, "policy", g.Policy)
	populate(objectMap, "state", g.State)
	objectMap["type"] = "GetMetadata"
	populate(objectMap, "typeProperties", g.TypeProperties)
	populate(objectMap, "userProperties", g.UserProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetMetadataActivity.
func (g *GetMetadataActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &g.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &g.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &g.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &g.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &g.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &g.UserProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetMetadataActivityTypeProperties.
func (g GetMetadataActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", g.Dataset)
	populate(objectMap, "fieldList", g.FieldList)
	populate(objectMap, "formatSettings", g.FormatSettings)
	populate(objectMap, "storeSettings", g.StoreSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetMetadataActivityTypeProperties.
func (g *GetMetadataActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &g.Dataset)
			delete(rawMsg, key)
		case "fieldList":
			err = unpopulate(val, "FieldList", &g.FieldList)
			delete(rawMsg, key)
		case "formatSettings":
			g.FormatSettings, err = unmarshalFormatReadSettingsClassification(val)
			delete(rawMsg, key)
		case "storeSettings":
			g.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GetSsisObjectMetadataRequest.
func (g GetSsisObjectMetadataRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metadataPath", g.MetadataPath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GetSsisObjectMetadataRequest.
func (g *GetSsisObjectMetadataRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metadataPath":
			err = unpopulate(val, "MetadataPath", &g.MetadataPath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubAccessTokenRequest.
func (g GitHubAccessTokenRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "gitHubAccessCode", g.GitHubAccessCode)
	populate(objectMap, "gitHubAccessTokenBaseUrl", g.GitHubAccessTokenBaseURL)
	populate(objectMap, "gitHubClientId", g.GitHubClientID)
	populate(objectMap, "gitHubClientSecret", g.GitHubClientSecret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubAccessTokenRequest.
func (g *GitHubAccessTokenRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "gitHubAccessCode":
			err = unpopulate(val, "GitHubAccessCode", &g.GitHubAccessCode)
			delete(rawMsg, key)
		case "gitHubAccessTokenBaseUrl":
			err = unpopulate(val, "GitHubAccessTokenBaseURL", &g.GitHubAccessTokenBaseURL)
			delete(rawMsg, key)
		case "gitHubClientId":
			err = unpopulate(val, "GitHubClientID", &g.GitHubClientID)
			delete(rawMsg, key)
		case "gitHubClientSecret":
			err = unpopulate(val, "GitHubClientSecret", &g.GitHubClientSecret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubAccessTokenResponse.
func (g GitHubAccessTokenResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "gitHubAccessToken", g.GitHubAccessToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubAccessTokenResponse.
func (g *GitHubAccessTokenResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "gitHubAccessToken":
			err = unpopulate(val, "GitHubAccessToken", &g.GitHubAccessToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitHubClientSecret.
func (g GitHubClientSecret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "byoaSecretAkvUrl", g.ByoaSecretAkvURL)
	populate(objectMap, "byoaSecretName", g.ByoaSecretName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitHubClientSecret.
func (g *GitHubClientSecret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "byoaSecretAkvUrl":
			err = unpopulate(val, "ByoaSecretAkvURL", &g.ByoaSecretAkvURL)
			delete(rawMsg, key)
		case "byoaSecretName":
			err = unpopulate(val, "ByoaSecretName", &g.ByoaSecretName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalParameterListResponse.
func (g GlobalParameterListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalParameterListResponse.
func (g *GlobalParameterListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalParameterResource.
func (g GlobalParameterResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", g.Etag)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalParameterResource.
func (g *GlobalParameterResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &g.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GlobalParameterSpecification.
func (g GlobalParameterSpecification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", g.Type)
	populateAny(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GlobalParameterSpecification.
func (g *GlobalParameterSpecification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleAdWordsLinkedService.
func (g GoogleAdWordsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "connectVia", g.ConnectVia)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "parameters", g.Parameters)
	objectMap["type"] = "GoogleAdWords"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleAdWordsLinkedService.
func (g *GoogleAdWordsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &g.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleAdWordsLinkedServiceTypeProperties.
func (g GoogleAdWordsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationType", g.AuthenticationType)
	populateAny(objectMap, "clientCustomerID", g.ClientCustomerID)
	populateAny(objectMap, "clientId", g.ClientID)
	populate(objectMap, "clientSecret", g.ClientSecret)
	populateAny(objectMap, "connectionProperties", g.ConnectionProperties)
	populate(objectMap, "developerToken", g.DeveloperToken)
	populateAny(objectMap, "email", g.Email)
	populate(objectMap, "encryptedCredential", g.EncryptedCredential)
	populateAny(objectMap, "googleAdsApiVersion", g.GoogleAdsAPIVersion)
	populateAny(objectMap, "keyFilePath", g.KeyFilePath)
	populateAny(objectMap, "loginCustomerID", g.LoginCustomerID)
	populate(objectMap, "privateKey", g.PrivateKey)
	populate(objectMap, "refreshToken", g.RefreshToken)
	populateAny(objectMap, "supportLegacyDataTypes", g.SupportLegacyDataTypes)
	populateAny(objectMap, "trustedCertPath", g.TrustedCertPath)
	populateAny(objectMap, "useSystemTrustStore", g.UseSystemTrustStore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleAdWordsLinkedServiceTypeProperties.
func (g *GoogleAdWordsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &g.AuthenticationType)
			delete(rawMsg, key)
		case "clientCustomerID":
			err = unpopulate(val, "ClientCustomerID", &g.ClientCustomerID)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &g.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			g.ClientSecret, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "connectionProperties":
			err = unpopulate(val, "ConnectionProperties", &g.ConnectionProperties)
			delete(rawMsg, key)
		case "developerToken":
			g.DeveloperToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &g.Email)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &g.EncryptedCredential)
			delete(rawMsg, key)
		case "googleAdsApiVersion":
			err = unpopulate(val, "GoogleAdsAPIVersion", &g.GoogleAdsAPIVersion)
			delete(rawMsg, key)
		case "keyFilePath":
			err = unpopulate(val, "KeyFilePath", &g.KeyFilePath)
			delete(rawMsg, key)
		case "loginCustomerID":
			err = unpopulate(val, "LoginCustomerID", &g.LoginCustomerID)
			delete(rawMsg, key)
		case "privateKey":
			g.PrivateKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "refreshToken":
			g.RefreshToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "supportLegacyDataTypes":
			err = unpopulate(val, "SupportLegacyDataTypes", &g.SupportLegacyDataTypes)
			delete(rawMsg, key)
		case "trustedCertPath":
			err = unpopulate(val, "TrustedCertPath", &g.TrustedCertPath)
			delete(rawMsg, key)
		case "useSystemTrustStore":
			err = unpopulate(val, "UseSystemTrustStore", &g.UseSystemTrustStore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleAdWordsObjectDataset.
func (g GoogleAdWordsObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "folder", g.Folder)
	populate(objectMap, "linkedServiceName", g.LinkedServiceName)
	populate(objectMap, "parameters", g.Parameters)
	populateAny(objectMap, "schema", g.Schema)
	populateAny(objectMap, "structure", g.Structure)
	objectMap["type"] = "GoogleAdWordsObject"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleAdWordsObjectDataset.
func (g *GoogleAdWordsObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &g.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &g.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &g.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &g.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleAdWordsSource.
func (g GoogleAdWordsSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", g.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", g.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", g.MaxConcurrentConnections)
	populateAny(objectMap, "query", g.Query)
	populateAny(objectMap, "queryTimeout", g.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", g.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", g.SourceRetryWait)
	objectMap["type"] = "GoogleAdWordsSource"
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleAdWordsSource.
func (g *GoogleAdWordsSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &g.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &g.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &g.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &g.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &g.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &g.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &g.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleBigQueryDatasetTypeProperties.
func (g GoogleBigQueryDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "dataset", g.Dataset)
	populateAny(objectMap, "table", g.Table)
	populateAny(objectMap, "tableName", g.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleBigQueryDatasetTypeProperties.
func (g *GoogleBigQueryDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &g.Dataset)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &g.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &g.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleBigQueryLinkedService.
func (g GoogleBigQueryLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "connectVia", g.ConnectVia)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "parameters", g.Parameters)
	objectMap["type"] = "GoogleBigQuery"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleBigQueryLinkedService.
func (g *GoogleBigQueryLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &g.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleBigQueryLinkedServiceTypeProperties.
func (g GoogleBigQueryLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalProjects", g.AdditionalProjects)
	populate(objectMap, "authenticationType", g.AuthenticationType)
	populateAny(objectMap, "clientId", g.ClientID)
	populate(objectMap, "clientSecret", g.ClientSecret)
	populateAny(objectMap, "email", g.Email)
	populate(objectMap, "encryptedCredential", g.EncryptedCredential)
	populateAny(objectMap, "keyFilePath", g.KeyFilePath)
	populateAny(objectMap, "project", g.Project)
	populate(objectMap, "refreshToken", g.RefreshToken)
	populateAny(objectMap, "requestGoogleDriveScope", g.RequestGoogleDriveScope)
	populateAny(objectMap, "trustedCertPath", g.TrustedCertPath)
	populateAny(objectMap, "useSystemTrustStore", g.UseSystemTrustStore)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleBigQueryLinkedServiceTypeProperties.
func (g *GoogleBigQueryLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalProjects":
			err = unpopulate(val, "AdditionalProjects", &g.AdditionalProjects)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &g.AuthenticationType)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &g.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			g.ClientSecret, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "email":
			err = unpopulate(val, "Email", &g.Email)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &g.EncryptedCredential)
			delete(rawMsg, key)
		case "keyFilePath":
			err = unpopulate(val, "KeyFilePath", &g.KeyFilePath)
			delete(rawMsg, key)
		case "project":
			err = unpopulate(val, "Project", &g.Project)
			delete(rawMsg, key)
		case "refreshToken":
			g.RefreshToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "requestGoogleDriveScope":
			err = unpopulate(val, "RequestGoogleDriveScope", &g.RequestGoogleDriveScope)
			delete(rawMsg, key)
		case "trustedCertPath":
			err = unpopulate(val, "TrustedCertPath", &g.TrustedCertPath)
			delete(rawMsg, key)
		case "useSystemTrustStore":
			err = unpopulate(val, "UseSystemTrustStore", &g.UseSystemTrustStore)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleBigQueryObjectDataset.
func (g GoogleBigQueryObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "folder", g.Folder)
	populate(objectMap, "linkedServiceName", g.LinkedServiceName)
	populate(objectMap, "parameters", g.Parameters)
	populateAny(objectMap, "schema", g.Schema)
	populateAny(objectMap, "structure", g.Structure)
	objectMap["type"] = "GoogleBigQueryObject"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleBigQueryObjectDataset.
func (g *GoogleBigQueryObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &g.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &g.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &g.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &g.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleBigQuerySource.
func (g GoogleBigQuerySource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", g.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", g.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", g.MaxConcurrentConnections)
	populateAny(objectMap, "query", g.Query)
	populateAny(objectMap, "queryTimeout", g.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", g.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", g.SourceRetryWait)
	objectMap["type"] = "GoogleBigQuerySource"
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleBigQuerySource.
func (g *GoogleBigQuerySource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &g.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &g.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &g.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &g.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &g.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &g.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &g.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleCloudStorageLinkedService.
func (g GoogleCloudStorageLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "connectVia", g.ConnectVia)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "parameters", g.Parameters)
	objectMap["type"] = "GoogleCloudStorage"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleCloudStorageLinkedService.
func (g *GoogleCloudStorageLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &g.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleCloudStorageLinkedServiceTypeProperties.
func (g GoogleCloudStorageLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "accessKeyId", g.AccessKeyID)
	populate(objectMap, "encryptedCredential", g.EncryptedCredential)
	populate(objectMap, "secretAccessKey", g.SecretAccessKey)
	populateAny(objectMap, "serviceUrl", g.ServiceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleCloudStorageLinkedServiceTypeProperties.
func (g *GoogleCloudStorageLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKeyId":
			err = unpopulate(val, "AccessKeyID", &g.AccessKeyID)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &g.EncryptedCredential)
			delete(rawMsg, key)
		case "secretAccessKey":
			g.SecretAccessKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "serviceUrl":
			err = unpopulate(val, "ServiceURL", &g.ServiceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleCloudStorageLocation.
func (g GoogleCloudStorageLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "bucketName", g.BucketName)
	populateAny(objectMap, "fileName", g.FileName)
	populateAny(objectMap, "folderPath", g.FolderPath)
	objectMap["type"] = "GoogleCloudStorageLocation"
	populateAny(objectMap, "version", g.Version)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleCloudStorageLocation.
func (g *GoogleCloudStorageLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bucketName":
			err = unpopulate(val, "BucketName", &g.BucketName)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &g.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &g.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &g.Version)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleCloudStorageReadSettings.
func (g GoogleCloudStorageReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", g.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", g.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", g.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", g.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", g.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", g.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", g.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", g.PartitionRootPath)
	populateAny(objectMap, "prefix", g.Prefix)
	populateAny(objectMap, "recursive", g.Recursive)
	objectMap["type"] = "GoogleCloudStorageReadSettings"
	populateAny(objectMap, "wildcardFileName", g.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", g.WildcardFolderPath)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleCloudStorageReadSettings.
func (g *GoogleCloudStorageReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &g.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &g.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &g.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &g.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &g.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &g.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &g.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &g.PartitionRootPath)
			delete(rawMsg, key)
		case "prefix":
			err = unpopulate(val, "Prefix", &g.Prefix)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &g.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &g.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &g.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleSheetsLinkedService.
func (g GoogleSheetsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "connectVia", g.ConnectVia)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "parameters", g.Parameters)
	objectMap["type"] = "GoogleSheets"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleSheetsLinkedService.
func (g *GoogleSheetsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &g.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GoogleSheetsLinkedServiceTypeProperties.
func (g GoogleSheetsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiToken", g.APIToken)
	populate(objectMap, "encryptedCredential", g.EncryptedCredential)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GoogleSheetsLinkedServiceTypeProperties.
func (g *GoogleSheetsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiToken":
			g.APIToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &g.EncryptedCredential)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GreenplumDatasetTypeProperties.
func (g GreenplumDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", g.Schema)
	populateAny(objectMap, "table", g.Table)
	populateAny(objectMap, "tableName", g.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GreenplumDatasetTypeProperties.
func (g *GreenplumDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &g.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &g.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &g.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GreenplumLinkedService.
func (g GreenplumLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "connectVia", g.ConnectVia)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "parameters", g.Parameters)
	objectMap["type"] = "Greenplum"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GreenplumLinkedService.
func (g *GreenplumLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &g.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GreenplumLinkedServiceTypeProperties.
func (g GreenplumLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "connectionString", g.ConnectionString)
	populate(objectMap, "encryptedCredential", g.EncryptedCredential)
	populate(objectMap, "pwd", g.Pwd)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GreenplumLinkedServiceTypeProperties.
func (g *GreenplumLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &g.ConnectionString)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &g.EncryptedCredential)
			delete(rawMsg, key)
		case "pwd":
			err = unpopulate(val, "Pwd", &g.Pwd)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GreenplumSource.
func (g GreenplumSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", g.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", g.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", g.MaxConcurrentConnections)
	populateAny(objectMap, "query", g.Query)
	populateAny(objectMap, "queryTimeout", g.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", g.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", g.SourceRetryWait)
	objectMap["type"] = "GreenplumSource"
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GreenplumSource.
func (g *GreenplumSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &g.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &g.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &g.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &g.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &g.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &g.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &g.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GreenplumTableDataset.
func (g GreenplumTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", g.Annotations)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "folder", g.Folder)
	populate(objectMap, "linkedServiceName", g.LinkedServiceName)
	populate(objectMap, "parameters", g.Parameters)
	populateAny(objectMap, "schema", g.Schema)
	populateAny(objectMap, "structure", g.Structure)
	objectMap["type"] = "GreenplumTable"
	populate(objectMap, "typeProperties", g.TypeProperties)
	if g.AdditionalProperties != nil {
		for key, val := range g.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GreenplumTableDataset.
func (g *GreenplumTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &g.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &g.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &g.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &g.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &g.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &g.TypeProperties)
			delete(rawMsg, key)
		default:
			if g.AdditionalProperties == nil {
				g.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				g.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HBaseLinkedService.
func (h HBaseLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "HBase"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HBaseLinkedService.
func (h *HBaseLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HBaseLinkedServiceTypeProperties.
func (h HBaseLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "allowHostNameCNMismatch", h.AllowHostNameCNMismatch)
	populateAny(objectMap, "allowSelfSignedServerCert", h.AllowSelfSignedServerCert)
	populate(objectMap, "authenticationType", h.AuthenticationType)
	populateAny(objectMap, "enableSsl", h.EnableSSL)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populateAny(objectMap, "httpPath", h.HTTPPath)
	populateAny(objectMap, "host", h.Host)
	populate(objectMap, "password", h.Password)
	populateAny(objectMap, "port", h.Port)
	populateAny(objectMap, "trustedCertPath", h.TrustedCertPath)
	populateAny(objectMap, "username", h.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HBaseLinkedServiceTypeProperties.
func (h *HBaseLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowHostNameCNMismatch":
			err = unpopulate(val, "AllowHostNameCNMismatch", &h.AllowHostNameCNMismatch)
			delete(rawMsg, key)
		case "allowSelfSignedServerCert":
			err = unpopulate(val, "AllowSelfSignedServerCert", &h.AllowSelfSignedServerCert)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &h.AuthenticationType)
			delete(rawMsg, key)
		case "enableSsl":
			err = unpopulate(val, "EnableSSL", &h.EnableSSL)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "httpPath":
			err = unpopulate(val, "HTTPPath", &h.HTTPPath)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &h.Host)
			delete(rawMsg, key)
		case "password":
			h.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &h.Port)
			delete(rawMsg, key)
		case "trustedCertPath":
			err = unpopulate(val, "TrustedCertPath", &h.TrustedCertPath)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &h.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HBaseObjectDataset.
func (h HBaseObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "folder", h.Folder)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "parameters", h.Parameters)
	populateAny(objectMap, "schema", h.Schema)
	populateAny(objectMap, "structure", h.Structure)
	objectMap["type"] = "HBaseObject"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HBaseObjectDataset.
func (h *HBaseObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &h.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &h.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &h.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HBaseSource.
func (h HBaseSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", h.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "query", h.Query)
	populateAny(objectMap, "queryTimeout", h.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", h.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", h.SourceRetryWait)
	objectMap["type"] = "HBaseSource"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HBaseSource.
func (h *HBaseSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &h.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &h.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &h.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &h.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &h.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightHiveActivity.
func (h HDInsightHiveActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", h.DependsOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "onInactiveMarkAs", h.OnInactiveMarkAs)
	populate(objectMap, "policy", h.Policy)
	populate(objectMap, "state", h.State)
	objectMap["type"] = "HDInsightHive"
	populate(objectMap, "typeProperties", h.TypeProperties)
	populate(objectMap, "userProperties", h.UserProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightHiveActivity.
func (h *HDInsightHiveActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &h.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &h.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &h.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &h.UserProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightHiveActivityTypeProperties.
func (h HDInsightHiveActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", h.Arguments)
	populate(objectMap, "defines", h.Defines)
	populate(objectMap, "getDebugInfo", h.GetDebugInfo)
	populate(objectMap, "queryTimeout", h.QueryTimeout)
	populate(objectMap, "scriptLinkedService", h.ScriptLinkedService)
	populateAny(objectMap, "scriptPath", h.ScriptPath)
	populate(objectMap, "storageLinkedServices", h.StorageLinkedServices)
	populate(objectMap, "variables", h.Variables)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightHiveActivityTypeProperties.
func (h *HDInsightHiveActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "defines":
			err = unpopulate(val, "Defines", &h.Defines)
			delete(rawMsg, key)
		case "getDebugInfo":
			err = unpopulate(val, "GetDebugInfo", &h.GetDebugInfo)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &h.QueryTimeout)
			delete(rawMsg, key)
		case "scriptLinkedService":
			err = unpopulate(val, "ScriptLinkedService", &h.ScriptLinkedService)
			delete(rawMsg, key)
		case "scriptPath":
			err = unpopulate(val, "ScriptPath", &h.ScriptPath)
			delete(rawMsg, key)
		case "storageLinkedServices":
			err = unpopulate(val, "StorageLinkedServices", &h.StorageLinkedServices)
			delete(rawMsg, key)
		case "variables":
			err = unpopulate(val, "Variables", &h.Variables)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightLinkedService.
func (h HDInsightLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "HDInsight"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightLinkedService.
func (h *HDInsightLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightLinkedServiceTypeProperties.
func (h HDInsightLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "clusterUri", h.ClusterURI)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populateAny(objectMap, "fileSystem", h.FileSystem)
	populate(objectMap, "hcatalogLinkedServiceName", h.HcatalogLinkedServiceName)
	populateAny(objectMap, "isEspEnabled", h.IsEspEnabled)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "password", h.Password)
	populateAny(objectMap, "userName", h.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightLinkedServiceTypeProperties.
func (h *HDInsightLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterUri":
			err = unpopulate(val, "ClusterURI", &h.ClusterURI)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "fileSystem":
			err = unpopulate(val, "FileSystem", &h.FileSystem)
			delete(rawMsg, key)
		case "hcatalogLinkedServiceName":
			err = unpopulate(val, "HcatalogLinkedServiceName", &h.HcatalogLinkedServiceName)
			delete(rawMsg, key)
		case "isEspEnabled":
			err = unpopulate(val, "IsEspEnabled", &h.IsEspEnabled)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "password":
			h.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &h.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightMapReduceActivity.
func (h HDInsightMapReduceActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", h.DependsOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "onInactiveMarkAs", h.OnInactiveMarkAs)
	populate(objectMap, "policy", h.Policy)
	populate(objectMap, "state", h.State)
	objectMap["type"] = "HDInsightMapReduce"
	populate(objectMap, "typeProperties", h.TypeProperties)
	populate(objectMap, "userProperties", h.UserProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightMapReduceActivity.
func (h *HDInsightMapReduceActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &h.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &h.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &h.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &h.UserProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightMapReduceActivityTypeProperties.
func (h HDInsightMapReduceActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", h.Arguments)
	populateAny(objectMap, "className", h.ClassName)
	populate(objectMap, "defines", h.Defines)
	populate(objectMap, "getDebugInfo", h.GetDebugInfo)
	populateAny(objectMap, "jarFilePath", h.JarFilePath)
	populate(objectMap, "jarLibs", h.JarLibs)
	populate(objectMap, "jarLinkedService", h.JarLinkedService)
	populate(objectMap, "storageLinkedServices", h.StorageLinkedServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightMapReduceActivityTypeProperties.
func (h *HDInsightMapReduceActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "className":
			err = unpopulate(val, "ClassName", &h.ClassName)
			delete(rawMsg, key)
		case "defines":
			err = unpopulate(val, "Defines", &h.Defines)
			delete(rawMsg, key)
		case "getDebugInfo":
			err = unpopulate(val, "GetDebugInfo", &h.GetDebugInfo)
			delete(rawMsg, key)
		case "jarFilePath":
			err = unpopulate(val, "JarFilePath", &h.JarFilePath)
			delete(rawMsg, key)
		case "jarLibs":
			err = unpopulate(val, "JarLibs", &h.JarLibs)
			delete(rawMsg, key)
		case "jarLinkedService":
			err = unpopulate(val, "JarLinkedService", &h.JarLinkedService)
			delete(rawMsg, key)
		case "storageLinkedServices":
			err = unpopulate(val, "StorageLinkedServices", &h.StorageLinkedServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightOnDemandLinkedService.
func (h HDInsightOnDemandLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "HDInsightOnDemand"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightOnDemandLinkedService.
func (h *HDInsightOnDemandLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightOnDemandLinkedServiceTypeProperties.
func (h HDInsightOnDemandLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalLinkedServiceNames", h.AdditionalLinkedServiceNames)
	populateAny(objectMap, "clusterNamePrefix", h.ClusterNamePrefix)
	populate(objectMap, "clusterPassword", h.ClusterPassword)
	populateAny(objectMap, "clusterResourceGroup", h.ClusterResourceGroup)
	populate(objectMap, "clusterSshPassword", h.ClusterSSHPassword)
	populateAny(objectMap, "clusterSshUserName", h.ClusterSSHUserName)
	populateAny(objectMap, "clusterSize", h.ClusterSize)
	populateAny(objectMap, "clusterType", h.ClusterType)
	populateAny(objectMap, "clusterUserName", h.ClusterUserName)
	populateAny(objectMap, "coreConfiguration", h.CoreConfiguration)
	populate(objectMap, "credential", h.Credential)
	populateAny(objectMap, "dataNodeSize", h.DataNodeSize)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populateAny(objectMap, "hBaseConfiguration", h.HBaseConfiguration)
	populate(objectMap, "hcatalogLinkedServiceName", h.HcatalogLinkedServiceName)
	populateAny(objectMap, "hdfsConfiguration", h.HdfsConfiguration)
	populateAny(objectMap, "headNodeSize", h.HeadNodeSize)
	populateAny(objectMap, "hiveConfiguration", h.HiveConfiguration)
	populateAny(objectMap, "hostSubscriptionId", h.HostSubscriptionID)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populateAny(objectMap, "mapReduceConfiguration", h.MapReduceConfiguration)
	populateAny(objectMap, "oozieConfiguration", h.OozieConfiguration)
	populate(objectMap, "scriptActions", h.ScriptActions)
	populateAny(objectMap, "servicePrincipalId", h.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", h.ServicePrincipalKey)
	populateAny(objectMap, "sparkVersion", h.SparkVersion)
	populateAny(objectMap, "stormConfiguration", h.StormConfiguration)
	populateAny(objectMap, "subnetName", h.SubnetName)
	populateAny(objectMap, "tenant", h.Tenant)
	populateAny(objectMap, "timeToLive", h.TimeToLive)
	populateAny(objectMap, "version", h.Version)
	populateAny(objectMap, "virtualNetworkId", h.VirtualNetworkID)
	populateAny(objectMap, "yarnConfiguration", h.YarnConfiguration)
	populateAny(objectMap, "zookeeperNodeSize", h.ZookeeperNodeSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightOnDemandLinkedServiceTypeProperties.
func (h *HDInsightOnDemandLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalLinkedServiceNames":
			err = unpopulate(val, "AdditionalLinkedServiceNames", &h.AdditionalLinkedServiceNames)
			delete(rawMsg, key)
		case "clusterNamePrefix":
			err = unpopulate(val, "ClusterNamePrefix", &h.ClusterNamePrefix)
			delete(rawMsg, key)
		case "clusterPassword":
			h.ClusterPassword, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "clusterResourceGroup":
			err = unpopulate(val, "ClusterResourceGroup", &h.ClusterResourceGroup)
			delete(rawMsg, key)
		case "clusterSshPassword":
			h.ClusterSSHPassword, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "clusterSshUserName":
			err = unpopulate(val, "ClusterSSHUserName", &h.ClusterSSHUserName)
			delete(rawMsg, key)
		case "clusterSize":
			err = unpopulate(val, "ClusterSize", &h.ClusterSize)
			delete(rawMsg, key)
		case "clusterType":
			err = unpopulate(val, "ClusterType", &h.ClusterType)
			delete(rawMsg, key)
		case "clusterUserName":
			err = unpopulate(val, "ClusterUserName", &h.ClusterUserName)
			delete(rawMsg, key)
		case "coreConfiguration":
			err = unpopulate(val, "CoreConfiguration", &h.CoreConfiguration)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &h.Credential)
			delete(rawMsg, key)
		case "dataNodeSize":
			err = unpopulate(val, "DataNodeSize", &h.DataNodeSize)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "hBaseConfiguration":
			err = unpopulate(val, "HBaseConfiguration", &h.HBaseConfiguration)
			delete(rawMsg, key)
		case "hcatalogLinkedServiceName":
			err = unpopulate(val, "HcatalogLinkedServiceName", &h.HcatalogLinkedServiceName)
			delete(rawMsg, key)
		case "hdfsConfiguration":
			err = unpopulate(val, "HdfsConfiguration", &h.HdfsConfiguration)
			delete(rawMsg, key)
		case "headNodeSize":
			err = unpopulate(val, "HeadNodeSize", &h.HeadNodeSize)
			delete(rawMsg, key)
		case "hiveConfiguration":
			err = unpopulate(val, "HiveConfiguration", &h.HiveConfiguration)
			delete(rawMsg, key)
		case "hostSubscriptionId":
			err = unpopulate(val, "HostSubscriptionID", &h.HostSubscriptionID)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "mapReduceConfiguration":
			err = unpopulate(val, "MapReduceConfiguration", &h.MapReduceConfiguration)
			delete(rawMsg, key)
		case "oozieConfiguration":
			err = unpopulate(val, "OozieConfiguration", &h.OozieConfiguration)
			delete(rawMsg, key)
		case "scriptActions":
			err = unpopulate(val, "ScriptActions", &h.ScriptActions)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &h.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			h.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "sparkVersion":
			err = unpopulate(val, "SparkVersion", &h.SparkVersion)
			delete(rawMsg, key)
		case "stormConfiguration":
			err = unpopulate(val, "StormConfiguration", &h.StormConfiguration)
			delete(rawMsg, key)
		case "subnetName":
			err = unpopulate(val, "SubnetName", &h.SubnetName)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &h.Tenant)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &h.TimeToLive)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &h.Version)
			delete(rawMsg, key)
		case "virtualNetworkId":
			err = unpopulate(val, "VirtualNetworkID", &h.VirtualNetworkID)
			delete(rawMsg, key)
		case "yarnConfiguration":
			err = unpopulate(val, "YarnConfiguration", &h.YarnConfiguration)
			delete(rawMsg, key)
		case "zookeeperNodeSize":
			err = unpopulate(val, "ZookeeperNodeSize", &h.ZookeeperNodeSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightPigActivity.
func (h HDInsightPigActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", h.DependsOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "onInactiveMarkAs", h.OnInactiveMarkAs)
	populate(objectMap, "policy", h.Policy)
	populate(objectMap, "state", h.State)
	objectMap["type"] = "HDInsightPig"
	populate(objectMap, "typeProperties", h.TypeProperties)
	populate(objectMap, "userProperties", h.UserProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightPigActivity.
func (h *HDInsightPigActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &h.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &h.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &h.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &h.UserProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightPigActivityTypeProperties.
func (h HDInsightPigActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "arguments", h.Arguments)
	populate(objectMap, "defines", h.Defines)
	populate(objectMap, "getDebugInfo", h.GetDebugInfo)
	populate(objectMap, "scriptLinkedService", h.ScriptLinkedService)
	populateAny(objectMap, "scriptPath", h.ScriptPath)
	populate(objectMap, "storageLinkedServices", h.StorageLinkedServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightPigActivityTypeProperties.
func (h *HDInsightPigActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "defines":
			err = unpopulate(val, "Defines", &h.Defines)
			delete(rawMsg, key)
		case "getDebugInfo":
			err = unpopulate(val, "GetDebugInfo", &h.GetDebugInfo)
			delete(rawMsg, key)
		case "scriptLinkedService":
			err = unpopulate(val, "ScriptLinkedService", &h.ScriptLinkedService)
			delete(rawMsg, key)
		case "scriptPath":
			err = unpopulate(val, "ScriptPath", &h.ScriptPath)
			delete(rawMsg, key)
		case "storageLinkedServices":
			err = unpopulate(val, "StorageLinkedServices", &h.StorageLinkedServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightSparkActivity.
func (h HDInsightSparkActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", h.DependsOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "onInactiveMarkAs", h.OnInactiveMarkAs)
	populate(objectMap, "policy", h.Policy)
	populate(objectMap, "state", h.State)
	objectMap["type"] = "HDInsightSpark"
	populate(objectMap, "typeProperties", h.TypeProperties)
	populate(objectMap, "userProperties", h.UserProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightSparkActivity.
func (h *HDInsightSparkActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &h.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &h.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &h.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &h.UserProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightSparkActivityTypeProperties.
func (h HDInsightSparkActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", h.Arguments)
	populate(objectMap, "className", h.ClassName)
	populateAny(objectMap, "entryFilePath", h.EntryFilePath)
	populate(objectMap, "getDebugInfo", h.GetDebugInfo)
	populateAny(objectMap, "proxyUser", h.ProxyUser)
	populateAny(objectMap, "rootPath", h.RootPath)
	populate(objectMap, "sparkConfig", h.SparkConfig)
	populate(objectMap, "sparkJobLinkedService", h.SparkJobLinkedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightSparkActivityTypeProperties.
func (h *HDInsightSparkActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "className":
			err = unpopulate(val, "ClassName", &h.ClassName)
			delete(rawMsg, key)
		case "entryFilePath":
			err = unpopulate(val, "EntryFilePath", &h.EntryFilePath)
			delete(rawMsg, key)
		case "getDebugInfo":
			err = unpopulate(val, "GetDebugInfo", &h.GetDebugInfo)
			delete(rawMsg, key)
		case "proxyUser":
			err = unpopulate(val, "ProxyUser", &h.ProxyUser)
			delete(rawMsg, key)
		case "rootPath":
			err = unpopulate(val, "RootPath", &h.RootPath)
			delete(rawMsg, key)
		case "sparkConfig":
			err = unpopulate(val, "SparkConfig", &h.SparkConfig)
			delete(rawMsg, key)
		case "sparkJobLinkedService":
			err = unpopulate(val, "SparkJobLinkedService", &h.SparkJobLinkedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightStreamingActivity.
func (h HDInsightStreamingActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", h.DependsOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "onInactiveMarkAs", h.OnInactiveMarkAs)
	populate(objectMap, "policy", h.Policy)
	populate(objectMap, "state", h.State)
	objectMap["type"] = "HDInsightStreaming"
	populate(objectMap, "typeProperties", h.TypeProperties)
	populate(objectMap, "userProperties", h.UserProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightStreamingActivity.
func (h *HDInsightStreamingActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &h.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &h.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &h.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &h.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &h.UserProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightStreamingActivityTypeProperties.
func (h HDInsightStreamingActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "arguments", h.Arguments)
	populateAny(objectMap, "combiner", h.Combiner)
	populate(objectMap, "commandEnvironment", h.CommandEnvironment)
	populate(objectMap, "defines", h.Defines)
	populate(objectMap, "fileLinkedService", h.FileLinkedService)
	populate(objectMap, "filePaths", h.FilePaths)
	populate(objectMap, "getDebugInfo", h.GetDebugInfo)
	populateAny(objectMap, "input", h.Input)
	populateAny(objectMap, "mapper", h.Mapper)
	populateAny(objectMap, "output", h.Output)
	populateAny(objectMap, "reducer", h.Reducer)
	populate(objectMap, "storageLinkedServices", h.StorageLinkedServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightStreamingActivityTypeProperties.
func (h *HDInsightStreamingActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "arguments":
			err = unpopulate(val, "Arguments", &h.Arguments)
			delete(rawMsg, key)
		case "combiner":
			err = unpopulate(val, "Combiner", &h.Combiner)
			delete(rawMsg, key)
		case "commandEnvironment":
			err = unpopulate(val, "CommandEnvironment", &h.CommandEnvironment)
			delete(rawMsg, key)
		case "defines":
			err = unpopulate(val, "Defines", &h.Defines)
			delete(rawMsg, key)
		case "fileLinkedService":
			err = unpopulate(val, "FileLinkedService", &h.FileLinkedService)
			delete(rawMsg, key)
		case "filePaths":
			err = unpopulate(val, "FilePaths", &h.FilePaths)
			delete(rawMsg, key)
		case "getDebugInfo":
			err = unpopulate(val, "GetDebugInfo", &h.GetDebugInfo)
			delete(rawMsg, key)
		case "input":
			err = unpopulate(val, "Input", &h.Input)
			delete(rawMsg, key)
		case "mapper":
			err = unpopulate(val, "Mapper", &h.Mapper)
			delete(rawMsg, key)
		case "output":
			err = unpopulate(val, "Output", &h.Output)
			delete(rawMsg, key)
		case "reducer":
			err = unpopulate(val, "Reducer", &h.Reducer)
			delete(rawMsg, key)
		case "storageLinkedServices":
			err = unpopulate(val, "StorageLinkedServices", &h.StorageLinkedServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPDataset.
func (h HTTPDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "folder", h.Folder)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "parameters", h.Parameters)
	populateAny(objectMap, "schema", h.Schema)
	populateAny(objectMap, "structure", h.Structure)
	objectMap["type"] = "HttpFile"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPDataset.
func (h *HTTPDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &h.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &h.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &h.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPDatasetTypeProperties.
func (h HTTPDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalHeaders", h.AdditionalHeaders)
	populate(objectMap, "compression", h.Compression)
	populate(objectMap, "format", h.Format)
	populateAny(objectMap, "relativeUrl", h.RelativeURL)
	populateAny(objectMap, "requestBody", h.RequestBody)
	populateAny(objectMap, "requestMethod", h.RequestMethod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPDatasetTypeProperties.
func (h *HTTPDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalHeaders":
			err = unpopulate(val, "AdditionalHeaders", &h.AdditionalHeaders)
			delete(rawMsg, key)
		case "compression":
			err = unpopulate(val, "Compression", &h.Compression)
			delete(rawMsg, key)
		case "format":
			h.Format, err = unmarshalDatasetStorageFormatClassification(val)
			delete(rawMsg, key)
		case "relativeUrl":
			err = unpopulate(val, "RelativeURL", &h.RelativeURL)
			delete(rawMsg, key)
		case "requestBody":
			err = unpopulate(val, "RequestBody", &h.RequestBody)
			delete(rawMsg, key)
		case "requestMethod":
			err = unpopulate(val, "RequestMethod", &h.RequestMethod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPLinkedService.
func (h HTTPLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "HttpServer"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPLinkedService.
func (h *HTTPLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPLinkedServiceTypeProperties.
func (h HTTPLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authHeaders", h.AuthHeaders)
	populate(objectMap, "authenticationType", h.AuthenticationType)
	populateAny(objectMap, "certThumbprint", h.CertThumbprint)
	populateAny(objectMap, "embeddedCertData", h.EmbeddedCertData)
	populateAny(objectMap, "enableServerCertificateValidation", h.EnableServerCertificateValidation)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populate(objectMap, "password", h.Password)
	populateAny(objectMap, "url", h.URL)
	populateAny(objectMap, "userName", h.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPLinkedServiceTypeProperties.
func (h *HTTPLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authHeaders":
			err = unpopulate(val, "AuthHeaders", &h.AuthHeaders)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &h.AuthenticationType)
			delete(rawMsg, key)
		case "certThumbprint":
			err = unpopulate(val, "CertThumbprint", &h.CertThumbprint)
			delete(rawMsg, key)
		case "embeddedCertData":
			err = unpopulate(val, "EmbeddedCertData", &h.EmbeddedCertData)
			delete(rawMsg, key)
		case "enableServerCertificateValidation":
			err = unpopulate(val, "EnableServerCertificateValidation", &h.EnableServerCertificateValidation)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			h.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &h.URL)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &h.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPReadSettings.
func (h HTTPReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", h.AdditionalColumns)
	populateAny(objectMap, "additionalHeaders", h.AdditionalHeaders)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "requestBody", h.RequestBody)
	populateAny(objectMap, "requestMethod", h.RequestMethod)
	populateAny(objectMap, "requestTimeout", h.RequestTimeout)
	objectMap["type"] = "HttpReadSettings"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPReadSettings.
func (h *HTTPReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &h.AdditionalColumns)
			delete(rawMsg, key)
		case "additionalHeaders":
			err = unpopulate(val, "AdditionalHeaders", &h.AdditionalHeaders)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "requestBody":
			err = unpopulate(val, "RequestBody", &h.RequestBody)
			delete(rawMsg, key)
		case "requestMethod":
			err = unpopulate(val, "RequestMethod", &h.RequestMethod)
			delete(rawMsg, key)
		case "requestTimeout":
			err = unpopulate(val, "RequestTimeout", &h.RequestTimeout)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPServerLocation.
func (h HTTPServerLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", h.FileName)
	populateAny(objectMap, "folderPath", h.FolderPath)
	populateAny(objectMap, "relativeUrl", h.RelativeURL)
	objectMap["type"] = "HttpServerLocation"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPServerLocation.
func (h *HTTPServerLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &h.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &h.FolderPath)
			delete(rawMsg, key)
		case "relativeUrl":
			err = unpopulate(val, "RelativeURL", &h.RelativeURL)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HTTPSource.
func (h HTTPSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populateAny(objectMap, "httpRequestTimeout", h.HTTPRequestTimeout)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", h.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", h.SourceRetryWait)
	objectMap["type"] = "HttpSource"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HTTPSource.
func (h *HTTPSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "httpRequestTimeout":
			err = unpopulate(val, "HTTPRequestTimeout", &h.HTTPRequestTimeout)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &h.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &h.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HdfsLinkedService.
func (h HdfsLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "Hdfs"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HdfsLinkedService.
func (h *HdfsLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HdfsLinkedServiceTypeProperties.
func (h HdfsLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authenticationType", h.AuthenticationType)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populate(objectMap, "password", h.Password)
	populateAny(objectMap, "url", h.URL)
	populateAny(objectMap, "userName", h.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HdfsLinkedServiceTypeProperties.
func (h *HdfsLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &h.AuthenticationType)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			h.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &h.URL)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &h.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HdfsLocation.
func (h HdfsLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", h.FileName)
	populateAny(objectMap, "folderPath", h.FolderPath)
	objectMap["type"] = "HdfsLocation"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HdfsLocation.
func (h *HdfsLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &h.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &h.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HdfsReadSettings.
func (h HdfsReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", h.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populate(objectMap, "distcpSettings", h.DistcpSettings)
	populateAny(objectMap, "enablePartitionDiscovery", h.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", h.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", h.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", h.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", h.PartitionRootPath)
	populateAny(objectMap, "recursive", h.Recursive)
	objectMap["type"] = "HdfsReadSettings"
	populateAny(objectMap, "wildcardFileName", h.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", h.WildcardFolderPath)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HdfsReadSettings.
func (h *HdfsReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &h.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "distcpSettings":
			err = unpopulate(val, "DistcpSettings", &h.DistcpSettings)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &h.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &h.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &h.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &h.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &h.PartitionRootPath)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &h.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &h.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &h.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HdfsSource.
func (h HdfsSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populate(objectMap, "distcpSettings", h.DistcpSettings)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "recursive", h.Recursive)
	populateAny(objectMap, "sourceRetryCount", h.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", h.SourceRetryWait)
	objectMap["type"] = "HdfsSource"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HdfsSource.
func (h *HdfsSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "distcpSettings":
			err = unpopulate(val, "DistcpSettings", &h.DistcpSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &h.Recursive)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &h.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &h.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HiveDatasetTypeProperties.
func (h HiveDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", h.Schema)
	populateAny(objectMap, "table", h.Table)
	populateAny(objectMap, "tableName", h.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HiveDatasetTypeProperties.
func (h *HiveDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &h.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &h.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &h.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HiveLinkedService.
func (h HiveLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "Hive"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HiveLinkedService.
func (h *HiveLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HiveLinkedServiceTypeProperties.
func (h HiveLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "allowHostNameCNMismatch", h.AllowHostNameCNMismatch)
	populateAny(objectMap, "allowSelfSignedServerCert", h.AllowSelfSignedServerCert)
	populate(objectMap, "authenticationType", h.AuthenticationType)
	populateAny(objectMap, "enableSsl", h.EnableSSL)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populateAny(objectMap, "httpPath", h.HTTPPath)
	populateAny(objectMap, "host", h.Host)
	populate(objectMap, "password", h.Password)
	populateAny(objectMap, "port", h.Port)
	populate(objectMap, "serverType", h.ServerType)
	populateAny(objectMap, "serviceDiscoveryMode", h.ServiceDiscoveryMode)
	populate(objectMap, "thriftTransportProtocol", h.ThriftTransportProtocol)
	populateAny(objectMap, "trustedCertPath", h.TrustedCertPath)
	populateAny(objectMap, "useNativeQuery", h.UseNativeQuery)
	populateAny(objectMap, "useSystemTrustStore", h.UseSystemTrustStore)
	populateAny(objectMap, "username", h.Username)
	populateAny(objectMap, "zooKeeperNameSpace", h.ZooKeeperNameSpace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HiveLinkedServiceTypeProperties.
func (h *HiveLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowHostNameCNMismatch":
			err = unpopulate(val, "AllowHostNameCNMismatch", &h.AllowHostNameCNMismatch)
			delete(rawMsg, key)
		case "allowSelfSignedServerCert":
			err = unpopulate(val, "AllowSelfSignedServerCert", &h.AllowSelfSignedServerCert)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &h.AuthenticationType)
			delete(rawMsg, key)
		case "enableSsl":
			err = unpopulate(val, "EnableSSL", &h.EnableSSL)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "httpPath":
			err = unpopulate(val, "HTTPPath", &h.HTTPPath)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &h.Host)
			delete(rawMsg, key)
		case "password":
			h.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &h.Port)
			delete(rawMsg, key)
		case "serverType":
			err = unpopulate(val, "ServerType", &h.ServerType)
			delete(rawMsg, key)
		case "serviceDiscoveryMode":
			err = unpopulate(val, "ServiceDiscoveryMode", &h.ServiceDiscoveryMode)
			delete(rawMsg, key)
		case "thriftTransportProtocol":
			err = unpopulate(val, "ThriftTransportProtocol", &h.ThriftTransportProtocol)
			delete(rawMsg, key)
		case "trustedCertPath":
			err = unpopulate(val, "TrustedCertPath", &h.TrustedCertPath)
			delete(rawMsg, key)
		case "useNativeQuery":
			err = unpopulate(val, "UseNativeQuery", &h.UseNativeQuery)
			delete(rawMsg, key)
		case "useSystemTrustStore":
			err = unpopulate(val, "UseSystemTrustStore", &h.UseSystemTrustStore)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &h.Username)
			delete(rawMsg, key)
		case "zooKeeperNameSpace":
			err = unpopulate(val, "ZooKeeperNameSpace", &h.ZooKeeperNameSpace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HiveObjectDataset.
func (h HiveObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "folder", h.Folder)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "parameters", h.Parameters)
	populateAny(objectMap, "schema", h.Schema)
	populateAny(objectMap, "structure", h.Structure)
	objectMap["type"] = "HiveObject"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HiveObjectDataset.
func (h *HiveObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &h.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &h.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &h.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HiveSource.
func (h HiveSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", h.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "query", h.Query)
	populateAny(objectMap, "queryTimeout", h.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", h.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", h.SourceRetryWait)
	objectMap["type"] = "HiveSource"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HiveSource.
func (h *HiveSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &h.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &h.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &h.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &h.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &h.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubspotLinkedService.
func (h HubspotLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "connectVia", h.ConnectVia)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "parameters", h.Parameters)
	objectMap["type"] = "Hubspot"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubspotLinkedService.
func (h *HubspotLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &h.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubspotLinkedServiceTypeProperties.
func (h HubspotLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", h.AccessToken)
	populateAny(objectMap, "clientId", h.ClientID)
	populate(objectMap, "clientSecret", h.ClientSecret)
	populate(objectMap, "encryptedCredential", h.EncryptedCredential)
	populate(objectMap, "refreshToken", h.RefreshToken)
	populateAny(objectMap, "useEncryptedEndpoints", h.UseEncryptedEndpoints)
	populateAny(objectMap, "useHostVerification", h.UseHostVerification)
	populateAny(objectMap, "usePeerVerification", h.UsePeerVerification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubspotLinkedServiceTypeProperties.
func (h *HubspotLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			h.AccessToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &h.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			h.ClientSecret, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &h.EncryptedCredential)
			delete(rawMsg, key)
		case "refreshToken":
			h.RefreshToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "useEncryptedEndpoints":
			err = unpopulate(val, "UseEncryptedEndpoints", &h.UseEncryptedEndpoints)
			delete(rawMsg, key)
		case "useHostVerification":
			err = unpopulate(val, "UseHostVerification", &h.UseHostVerification)
			delete(rawMsg, key)
		case "usePeerVerification":
			err = unpopulate(val, "UsePeerVerification", &h.UsePeerVerification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubspotObjectDataset.
func (h HubspotObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", h.Annotations)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "folder", h.Folder)
	populate(objectMap, "linkedServiceName", h.LinkedServiceName)
	populate(objectMap, "parameters", h.Parameters)
	populateAny(objectMap, "schema", h.Schema)
	populateAny(objectMap, "structure", h.Structure)
	objectMap["type"] = "HubspotObject"
	populate(objectMap, "typeProperties", h.TypeProperties)
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubspotObjectDataset.
func (h *HubspotObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &h.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &h.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &h.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &h.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &h.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &h.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &h.TypeProperties)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HubspotSource.
func (h HubspotSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", h.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", h.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", h.MaxConcurrentConnections)
	populateAny(objectMap, "query", h.Query)
	populateAny(objectMap, "queryTimeout", h.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", h.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", h.SourceRetryWait)
	objectMap["type"] = "HubspotSource"
	if h.AdditionalProperties != nil {
		for key, val := range h.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HubspotSource.
func (h *HubspotSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &h.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &h.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &h.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &h.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &h.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &h.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &h.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		default:
			if h.AdditionalProperties == nil {
				h.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				h.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IfConditionActivity.
func (i IfConditionActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", i.DependsOn)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "onInactiveMarkAs", i.OnInactiveMarkAs)
	populate(objectMap, "state", i.State)
	objectMap["type"] = "IfCondition"
	populate(objectMap, "typeProperties", i.TypeProperties)
	populate(objectMap, "userProperties", i.UserProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IfConditionActivity.
func (i *IfConditionActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &i.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &i.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &i.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &i.UserProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IfConditionActivityTypeProperties.
func (i IfConditionActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "expression", i.Expression)
	populate(objectMap, "ifFalseActivities", i.IfFalseActivities)
	populate(objectMap, "ifTrueActivities", i.IfTrueActivities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IfConditionActivityTypeProperties.
func (i *IfConditionActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "expression":
			err = unpopulate(val, "Expression", &i.Expression)
			delete(rawMsg, key)
		case "ifFalseActivities":
			i.IfFalseActivities, err = unmarshalActivityClassificationArray(val)
			delete(rawMsg, key)
		case "ifTrueActivities":
			i.IfTrueActivities, err = unmarshalActivityClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpalaDatasetTypeProperties.
func (i ImpalaDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "schema", i.Schema)
	populateAny(objectMap, "table", i.Table)
	populateAny(objectMap, "tableName", i.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpalaDatasetTypeProperties.
func (i *ImpalaDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "schema":
			err = unpopulate(val, "Schema", &i.Schema)
			delete(rawMsg, key)
		case "table":
			err = unpopulate(val, "Table", &i.Table)
			delete(rawMsg, key)
		case "tableName":
			err = unpopulate(val, "TableName", &i.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpalaLinkedService.
func (i ImpalaLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", i.Annotations)
	populate(objectMap, "connectVia", i.ConnectVia)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "parameters", i.Parameters)
	objectMap["type"] = "Impala"
	populate(objectMap, "typeProperties", i.TypeProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpalaLinkedService.
func (i *ImpalaLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &i.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &i.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &i.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &i.TypeProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpalaLinkedServiceTypeProperties.
func (i ImpalaLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "allowHostNameCNMismatch", i.AllowHostNameCNMismatch)
	populateAny(objectMap, "allowSelfSignedServerCert", i.AllowSelfSignedServerCert)
	populate(objectMap, "authenticationType", i.AuthenticationType)
	populateAny(objectMap, "enableSsl", i.EnableSSL)
	populate(objectMap, "encryptedCredential", i.EncryptedCredential)
	populateAny(objectMap, "host", i.Host)
	populate(objectMap, "password", i.Password)
	populateAny(objectMap, "port", i.Port)
	populateAny(objectMap, "trustedCertPath", i.TrustedCertPath)
	populateAny(objectMap, "useSystemTrustStore", i.UseSystemTrustStore)
	populateAny(objectMap, "username", i.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpalaLinkedServiceTypeProperties.
func (i *ImpalaLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowHostNameCNMismatch":
			err = unpopulate(val, "AllowHostNameCNMismatch", &i.AllowHostNameCNMismatch)
			delete(rawMsg, key)
		case "allowSelfSignedServerCert":
			err = unpopulate(val, "AllowSelfSignedServerCert", &i.AllowSelfSignedServerCert)
			delete(rawMsg, key)
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &i.AuthenticationType)
			delete(rawMsg, key)
		case "enableSsl":
			err = unpopulate(val, "EnableSSL", &i.EnableSSL)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &i.EncryptedCredential)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &i.Host)
			delete(rawMsg, key)
		case "password":
			i.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &i.Port)
			delete(rawMsg, key)
		case "trustedCertPath":
			err = unpopulate(val, "TrustedCertPath", &i.TrustedCertPath)
			delete(rawMsg, key)
		case "useSystemTrustStore":
			err = unpopulate(val, "UseSystemTrustStore", &i.UseSystemTrustStore)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &i.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpalaObjectDataset.
func (i ImpalaObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", i.Annotations)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "folder", i.Folder)
	populate(objectMap, "linkedServiceName", i.LinkedServiceName)
	populate(objectMap, "parameters", i.Parameters)
	populateAny(objectMap, "schema", i.Schema)
	populateAny(objectMap, "structure", i.Structure)
	objectMap["type"] = "ImpalaObject"
	populate(objectMap, "typeProperties", i.TypeProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpalaObjectDataset.
func (i *ImpalaObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &i.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &i.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &i.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &i.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &i.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &i.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &i.TypeProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImpalaSource.
func (i ImpalaSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", i.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", i.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", i.MaxConcurrentConnections)
	populateAny(objectMap, "query", i.Query)
	populateAny(objectMap, "queryTimeout", i.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", i.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", i.SourceRetryWait)
	objectMap["type"] = "ImpalaSource"
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImpalaSource.
func (i *ImpalaSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &i.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &i.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &i.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &i.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &i.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &i.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &i.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportSettings.
func (i ImportSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["type"] = i.Type
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportSettings.
func (i *ImportSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformixLinkedService.
func (i InformixLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", i.Annotations)
	populate(objectMap, "connectVia", i.ConnectVia)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "parameters", i.Parameters)
	objectMap["type"] = "Informix"
	populate(objectMap, "typeProperties", i.TypeProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformixLinkedService.
func (i *InformixLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &i.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &i.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &i.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &i.TypeProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformixLinkedServiceTypeProperties.
func (i InformixLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "authenticationType", i.AuthenticationType)
	populateAny(objectMap, "connectionString", i.ConnectionString)
	populate(objectMap, "credential", i.Credential)
	populate(objectMap, "encryptedCredential", i.EncryptedCredential)
	populate(objectMap, "password", i.Password)
	populateAny(objectMap, "userName", i.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformixLinkedServiceTypeProperties.
func (i *InformixLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationType":
			err = unpopulate(val, "AuthenticationType", &i.AuthenticationType)
			delete(rawMsg, key)
		case "connectionString":
			err = unpopulate(val, "ConnectionString", &i.ConnectionString)
			delete(rawMsg, key)
		case "credential":
			i.Credential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &i.EncryptedCredential)
			delete(rawMsg, key)
		case "password":
			i.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &i.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformixSink.
func (i InformixSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", i.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", i.MaxConcurrentConnections)
	populateAny(objectMap, "preCopyScript", i.PreCopyScript)
	populateAny(objectMap, "sinkRetryCount", i.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", i.SinkRetryWait)
	objectMap["type"] = "InformixSink"
	populateAny(objectMap, "writeBatchSize", i.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", i.WriteBatchTimeout)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformixSink.
func (i *InformixSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &i.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &i.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "preCopyScript":
			err = unpopulate(val, "PreCopyScript", &i.PreCopyScript)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &i.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &i.SinkRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &i.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &i.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformixSource.
func (i InformixSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", i.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", i.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", i.MaxConcurrentConnections)
	populateAny(objectMap, "query", i.Query)
	populateAny(objectMap, "queryTimeout", i.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", i.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", i.SourceRetryWait)
	objectMap["type"] = "InformixSource"
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformixSource.
func (i *InformixSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &i.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &i.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &i.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &i.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &i.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &i.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &i.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformixTableDataset.
func (i InformixTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", i.Annotations)
	populate(objectMap, "description", i.Description)
	populate(objectMap, "folder", i.Folder)
	populate(objectMap, "linkedServiceName", i.LinkedServiceName)
	populate(objectMap, "parameters", i.Parameters)
	populateAny(objectMap, "schema", i.Schema)
	populateAny(objectMap, "structure", i.Structure)
	objectMap["type"] = "InformixTable"
	populate(objectMap, "typeProperties", i.TypeProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformixTableDataset.
func (i *InformixTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &i.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &i.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &i.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &i.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &i.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &i.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &i.TypeProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InformixTableDatasetTypeProperties.
func (i InformixTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "tableName", i.TableName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InformixTableDatasetTypeProperties.
func (i *InformixTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tableName":
			err = unpopulate(val, "TableName", &i.TableName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntime.
func (i IntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", i.Description)
	objectMap["type"] = i.Type
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntime.
func (i *IntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &i.Description)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeAuthKeys.
func (i IntegrationRuntimeAuthKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authKey1", i.AuthKey1)
	populate(objectMap, "authKey2", i.AuthKey2)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeAuthKeys.
func (i *IntegrationRuntimeAuthKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authKey1":
			err = unpopulate(val, "AuthKey1", &i.AuthKey1)
			delete(rawMsg, key)
		case "authKey2":
			err = unpopulate(val, "AuthKey2", &i.AuthKey2)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeComputeProperties.
func (i IntegrationRuntimeComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "copyComputeScaleProperties", i.CopyComputeScaleProperties)
	populate(objectMap, "dataFlowProperties", i.DataFlowProperties)
	populate(objectMap, "location", i.Location)
	populate(objectMap, "maxParallelExecutionsPerNode", i.MaxParallelExecutionsPerNode)
	populate(objectMap, "nodeSize", i.NodeSize)
	populate(objectMap, "numberOfNodes", i.NumberOfNodes)
	populate(objectMap, "pipelineExternalComputeScaleProperties", i.PipelineExternalComputeScaleProperties)
	populate(objectMap, "vNetProperties", i.VNetProperties)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeComputeProperties.
func (i *IntegrationRuntimeComputeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyComputeScaleProperties":
			err = unpopulate(val, "CopyComputeScaleProperties", &i.CopyComputeScaleProperties)
			delete(rawMsg, key)
		case "dataFlowProperties":
			err = unpopulate(val, "DataFlowProperties", &i.DataFlowProperties)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &i.Location)
			delete(rawMsg, key)
		case "maxParallelExecutionsPerNode":
			err = unpopulate(val, "MaxParallelExecutionsPerNode", &i.MaxParallelExecutionsPerNode)
			delete(rawMsg, key)
		case "nodeSize":
			err = unpopulate(val, "NodeSize", &i.NodeSize)
			delete(rawMsg, key)
		case "numberOfNodes":
			err = unpopulate(val, "NumberOfNodes", &i.NumberOfNodes)
			delete(rawMsg, key)
		case "pipelineExternalComputeScaleProperties":
			err = unpopulate(val, "PipelineExternalComputeScaleProperties", &i.PipelineExternalComputeScaleProperties)
			delete(rawMsg, key)
		case "vNetProperties":
			err = unpopulate(val, "VNetProperties", &i.VNetProperties)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeConnectionInfo.
func (i IntegrationRuntimeConnectionInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostServiceUri", i.HostServiceURI)
	populate(objectMap, "identityCertThumbprint", i.IdentityCertThumbprint)
	populate(objectMap, "isIdentityCertExprired", i.IsIdentityCertExprired)
	populate(objectMap, "publicKey", i.PublicKey)
	populate(objectMap, "serviceToken", i.ServiceToken)
	populate(objectMap, "version", i.Version)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeConnectionInfo.
func (i *IntegrationRuntimeConnectionInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostServiceUri":
			err = unpopulate(val, "HostServiceURI", &i.HostServiceURI)
			delete(rawMsg, key)
		case "identityCertThumbprint":
			err = unpopulate(val, "IdentityCertThumbprint", &i.IdentityCertThumbprint)
			delete(rawMsg, key)
		case "isIdentityCertExprired":
			err = unpopulate(val, "IsIdentityCertExprired", &i.IsIdentityCertExprired)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &i.PublicKey)
			delete(rawMsg, key)
		case "serviceToken":
			err = unpopulate(val, "ServiceToken", &i.ServiceToken)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &i.Version)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeCustomSetupScriptProperties.
func (i IntegrationRuntimeCustomSetupScriptProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobContainerUri", i.BlobContainerURI)
	populate(objectMap, "sasToken", i.SasToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeCustomSetupScriptProperties.
func (i *IntegrationRuntimeCustomSetupScriptProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobContainerUri":
			err = unpopulate(val, "BlobContainerURI", &i.BlobContainerURI)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &i.SasToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeCustomerVirtualNetwork.
func (i IntegrationRuntimeCustomerVirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subnetId", i.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeCustomerVirtualNetwork.
func (i *IntegrationRuntimeCustomerVirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subnetId":
			err = unpopulate(val, "SubnetID", &i.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDataFlowProperties.
func (i IntegrationRuntimeDataFlowProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cleanup", i.Cleanup)
	populate(objectMap, "computeType", i.ComputeType)
	populate(objectMap, "coreCount", i.CoreCount)
	populate(objectMap, "customProperties", i.CustomProperties)
	populate(objectMap, "timeToLive", i.TimeToLive)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDataFlowProperties.
func (i *IntegrationRuntimeDataFlowProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cleanup":
			err = unpopulate(val, "Cleanup", &i.Cleanup)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &i.ComputeType)
			delete(rawMsg, key)
		case "coreCount":
			err = unpopulate(val, "CoreCount", &i.CoreCount)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &i.CustomProperties)
			delete(rawMsg, key)
		case "timeToLive":
			err = unpopulate(val, "TimeToLive", &i.TimeToLive)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem.
func (i IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem.
func (i *IntegrationRuntimeDataFlowPropertiesCustomPropertiesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDataProxyProperties.
func (i IntegrationRuntimeDataProxyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "connectVia", i.ConnectVia)
	populate(objectMap, "path", i.Path)
	populate(objectMap, "stagingLinkedService", i.StagingLinkedService)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDataProxyProperties.
func (i *IntegrationRuntimeDataProxyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &i.ConnectVia)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &i.Path)
			delete(rawMsg, key)
		case "stagingLinkedService":
			err = unpopulate(val, "StagingLinkedService", &i.StagingLinkedService)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeDebugResource.
func (i IntegrationRuntimeDebugResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeDebugResource.
func (i *IntegrationRuntimeDebugResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeListResponse.
func (i IntegrationRuntimeListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", i.NextLink)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeListResponse.
func (i *IntegrationRuntimeListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &i.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeMonitoringData.
func (i IntegrationRuntimeMonitoringData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "nodes", i.Nodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeMonitoringData.
func (i *IntegrationRuntimeMonitoringData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &i.Nodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeNodeIPAddress.
func (i IntegrationRuntimeNodeIPAddress) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipAddress", i.IPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeNodeIPAddress.
func (i *IntegrationRuntimeNodeIPAddress) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &i.IPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeNodeMonitoringData.
func (i IntegrationRuntimeNodeMonitoringData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availableMemoryInMB", i.AvailableMemoryInMB)
	populate(objectMap, "cpuUtilization", i.CPUUtilization)
	populate(objectMap, "concurrentJobsLimit", i.ConcurrentJobsLimit)
	populate(objectMap, "concurrentJobsRunning", i.ConcurrentJobsRunning)
	populate(objectMap, "maxConcurrentJobs", i.MaxConcurrentJobs)
	populate(objectMap, "nodeName", i.NodeName)
	populate(objectMap, "receivedBytes", i.ReceivedBytes)
	populate(objectMap, "sentBytes", i.SentBytes)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeNodeMonitoringData.
func (i *IntegrationRuntimeNodeMonitoringData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availableMemoryInMB":
			err = unpopulate(val, "AvailableMemoryInMB", &i.AvailableMemoryInMB)
			delete(rawMsg, key)
		case "cpuUtilization":
			err = unpopulate(val, "CPUUtilization", &i.CPUUtilization)
			delete(rawMsg, key)
		case "concurrentJobsLimit":
			err = unpopulate(val, "ConcurrentJobsLimit", &i.ConcurrentJobsLimit)
			delete(rawMsg, key)
		case "concurrentJobsRunning":
			err = unpopulate(val, "ConcurrentJobsRunning", &i.ConcurrentJobsRunning)
			delete(rawMsg, key)
		case "maxConcurrentJobs":
			err = unpopulate(val, "MaxConcurrentJobs", &i.MaxConcurrentJobs)
			delete(rawMsg, key)
		case "nodeName":
			err = unpopulate(val, "NodeName", &i.NodeName)
			delete(rawMsg, key)
		case "receivedBytes":
			err = unpopulate(val, "ReceivedBytes", &i.ReceivedBytes)
			delete(rawMsg, key)
		case "sentBytes":
			err = unpopulate(val, "SentBytes", &i.SentBytes)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint.
func (i IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "endpoints", i.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint.
func (i *IntegrationRuntimeOutboundNetworkDependenciesCategoryEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &i.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpoint.
func (i IntegrationRuntimeOutboundNetworkDependenciesEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", i.DomainName)
	populate(objectMap, "endpointDetails", i.EndpointDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpoint.
func (i *IntegrationRuntimeOutboundNetworkDependenciesEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &i.DomainName)
			delete(rawMsg, key)
		case "endpointDetails":
			err = unpopulate(val, "EndpointDetails", &i.EndpointDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails.
func (i IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", i.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails.
func (i *IntegrationRuntimeOutboundNetworkDependenciesEndpointDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &i.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse.
func (i IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", i.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse.
func (i *IntegrationRuntimeOutboundNetworkDependenciesEndpointsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &i.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeReference.
func (i IntegrationRuntimeReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", i.Parameters)
	populate(objectMap, "referenceName", i.ReferenceName)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeReference.
func (i *IntegrationRuntimeReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &i.Parameters)
			delete(rawMsg, key)
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &i.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeRegenerateKeyParameters.
func (i IntegrationRuntimeRegenerateKeyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyName", i.KeyName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeRegenerateKeyParameters.
func (i *IntegrationRuntimeRegenerateKeyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyName":
			err = unpopulate(val, "KeyName", &i.KeyName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeResource.
func (i IntegrationRuntimeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", i.Etag)
	populate(objectMap, "id", i.ID)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeResource.
func (i *IntegrationRuntimeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &i.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeSsisCatalogInfo.
func (i IntegrationRuntimeSsisCatalogInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogAdminPassword", i.CatalogAdminPassword)
	populate(objectMap, "catalogAdminUserName", i.CatalogAdminUserName)
	populate(objectMap, "catalogPricingTier", i.CatalogPricingTier)
	populate(objectMap, "catalogServerEndpoint", i.CatalogServerEndpoint)
	populate(objectMap, "dualStandbyPairName", i.DualStandbyPairName)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeSsisCatalogInfo.
func (i *IntegrationRuntimeSsisCatalogInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogAdminPassword":
			err = unpopulate(val, "CatalogAdminPassword", &i.CatalogAdminPassword)
			delete(rawMsg, key)
		case "catalogAdminUserName":
			err = unpopulate(val, "CatalogAdminUserName", &i.CatalogAdminUserName)
			delete(rawMsg, key)
		case "catalogPricingTier":
			err = unpopulate(val, "CatalogPricingTier", &i.CatalogPricingTier)
			delete(rawMsg, key)
		case "catalogServerEndpoint":
			err = unpopulate(val, "CatalogServerEndpoint", &i.CatalogServerEndpoint)
			delete(rawMsg, key)
		case "dualStandbyPairName":
			err = unpopulate(val, "DualStandbyPairName", &i.DualStandbyPairName)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeSsisProperties.
func (i IntegrationRuntimeSsisProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "catalogInfo", i.CatalogInfo)
	populate(objectMap, "credential", i.Credential)
	populate(objectMap, "customSetupScriptProperties", i.CustomSetupScriptProperties)
	populate(objectMap, "dataProxyProperties", i.DataProxyProperties)
	populate(objectMap, "edition", i.Edition)
	populate(objectMap, "expressCustomSetupProperties", i.ExpressCustomSetupProperties)
	populate(objectMap, "licenseType", i.LicenseType)
	populate(objectMap, "packageStores", i.PackageStores)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeSsisProperties.
func (i *IntegrationRuntimeSsisProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "catalogInfo":
			err = unpopulate(val, "CatalogInfo", &i.CatalogInfo)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &i.Credential)
			delete(rawMsg, key)
		case "customSetupScriptProperties":
			err = unpopulate(val, "CustomSetupScriptProperties", &i.CustomSetupScriptProperties)
			delete(rawMsg, key)
		case "dataProxyProperties":
			err = unpopulate(val, "DataProxyProperties", &i.DataProxyProperties)
			delete(rawMsg, key)
		case "edition":
			err = unpopulate(val, "Edition", &i.Edition)
			delete(rawMsg, key)
		case "expressCustomSetupProperties":
			i.ExpressCustomSetupProperties, err = unmarshalCustomSetupBaseClassificationArray(val)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &i.LicenseType)
			delete(rawMsg, key)
		case "packageStores":
			err = unpopulate(val, "PackageStores", &i.PackageStores)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeStatus.
func (i IntegrationRuntimeStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataFactoryName", i.DataFactoryName)
	populate(objectMap, "state", i.State)
	objectMap["type"] = i.Type
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStatus.
func (i *IntegrationRuntimeStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &i.DataFactoryName)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &i.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeStatusResponse.
func (i IntegrationRuntimeStatusResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeStatusResponse.
func (i *IntegrationRuntimeStatusResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			i.Properties, err = unmarshalIntegrationRuntimeStatusClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IntegrationRuntimeVNetProperties.
func (i IntegrationRuntimeVNetProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPs", i.PublicIPs)
	populate(objectMap, "subnet", i.Subnet)
	populate(objectMap, "subnetId", i.SubnetID)
	populate(objectMap, "vNetId", i.VNetID)
	if i.AdditionalProperties != nil {
		for key, val := range i.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IntegrationRuntimeVNetProperties.
func (i *IntegrationRuntimeVNetProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPs":
			err = unpopulate(val, "PublicIPs", &i.PublicIPs)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &i.Subnet)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &i.SubnetID)
			delete(rawMsg, key)
		case "vNetId":
			err = unpopulate(val, "VNetID", &i.VNetID)
			delete(rawMsg, key)
		default:
			if i.AdditionalProperties == nil {
				i.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				i.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONDataset.
func (j JSONDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", j.Annotations)
	populate(objectMap, "description", j.Description)
	populate(objectMap, "folder", j.Folder)
	populate(objectMap, "linkedServiceName", j.LinkedServiceName)
	populate(objectMap, "parameters", j.Parameters)
	populateAny(objectMap, "schema", j.Schema)
	populateAny(objectMap, "structure", j.Structure)
	objectMap["type"] = "Json"
	populate(objectMap, "typeProperties", j.TypeProperties)
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONDataset.
func (j *JSONDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &j.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &j.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &j.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &j.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &j.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &j.TypeProperties)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONDatasetTypeProperties.
func (j JSONDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compression", j.Compression)
	populateAny(objectMap, "encodingName", j.EncodingName)
	populate(objectMap, "location", j.Location)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONDatasetTypeProperties.
func (j *JSONDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compression":
			err = unpopulate(val, "Compression", &j.Compression)
			delete(rawMsg, key)
		case "encodingName":
			err = unpopulate(val, "EncodingName", &j.EncodingName)
			delete(rawMsg, key)
		case "location":
			j.Location, err = unmarshalDatasetLocationClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONFormat.
func (j JSONFormat) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deserializer", j.Deserializer)
	populateAny(objectMap, "encodingName", j.EncodingName)
	populateAny(objectMap, "filePattern", j.FilePattern)
	populateAny(objectMap, "jsonNodeReference", j.JSONNodeReference)
	populateAny(objectMap, "jsonPathDefinition", j.JSONPathDefinition)
	populateAny(objectMap, "nestingSeparator", j.NestingSeparator)
	populateAny(objectMap, "serializer", j.Serializer)
	objectMap["type"] = "JsonFormat"
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONFormat.
func (j *JSONFormat) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deserializer":
			err = unpopulate(val, "Deserializer", &j.Deserializer)
			delete(rawMsg, key)
		case "encodingName":
			err = unpopulate(val, "EncodingName", &j.EncodingName)
			delete(rawMsg, key)
		case "filePattern":
			err = unpopulate(val, "FilePattern", &j.FilePattern)
			delete(rawMsg, key)
		case "jsonNodeReference":
			err = unpopulate(val, "JSONNodeReference", &j.JSONNodeReference)
			delete(rawMsg, key)
		case "jsonPathDefinition":
			err = unpopulate(val, "JSONPathDefinition", &j.JSONPathDefinition)
			delete(rawMsg, key)
		case "nestingSeparator":
			err = unpopulate(val, "NestingSeparator", &j.NestingSeparator)
			delete(rawMsg, key)
		case "serializer":
			err = unpopulate(val, "Serializer", &j.Serializer)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONReadSettings.
func (j JSONReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compressionProperties", j.CompressionProperties)
	objectMap["type"] = "JsonReadSettings"
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONReadSettings.
func (j *JSONReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compressionProperties":
			j.CompressionProperties, err = unmarshalCompressionReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSink.
func (j JSONSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", j.DisableMetricsCollection)
	populate(objectMap, "formatSettings", j.FormatSettings)
	populateAny(objectMap, "maxConcurrentConnections", j.MaxConcurrentConnections)
	populateAny(objectMap, "sinkRetryCount", j.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", j.SinkRetryWait)
	populate(objectMap, "storeSettings", j.StoreSettings)
	objectMap["type"] = "JsonSink"
	populateAny(objectMap, "writeBatchSize", j.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", j.WriteBatchTimeout)
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSink.
func (j *JSONSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &j.DisableMetricsCollection)
			delete(rawMsg, key)
		case "formatSettings":
			err = unpopulate(val, "FormatSettings", &j.FormatSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &j.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &j.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &j.SinkRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			j.StoreSettings, err = unmarshalStoreWriteSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &j.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &j.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONSource.
func (j JSONSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", j.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", j.DisableMetricsCollection)
	populate(objectMap, "formatSettings", j.FormatSettings)
	populateAny(objectMap, "maxConcurrentConnections", j.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", j.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", j.SourceRetryWait)
	populate(objectMap, "storeSettings", j.StoreSettings)
	objectMap["type"] = "JsonSource"
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONSource.
func (j *JSONSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &j.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &j.DisableMetricsCollection)
			delete(rawMsg, key)
		case "formatSettings":
			err = unpopulate(val, "FormatSettings", &j.FormatSettings)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &j.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &j.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &j.SourceRetryWait)
			delete(rawMsg, key)
		case "storeSettings":
			j.StoreSettings, err = unmarshalStoreReadSettingsClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JSONWriteSettings.
func (j JSONWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "filePattern", j.FilePattern)
	objectMap["type"] = "JsonWriteSettings"
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JSONWriteSettings.
func (j *JSONWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "filePattern":
			err = unpopulate(val, "FilePattern", &j.FilePattern)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JiraLinkedService.
func (j JiraLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", j.Annotations)
	populate(objectMap, "connectVia", j.ConnectVia)
	populate(objectMap, "description", j.Description)
	populate(objectMap, "parameters", j.Parameters)
	objectMap["type"] = "Jira"
	populate(objectMap, "typeProperties", j.TypeProperties)
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JiraLinkedService.
func (j *JiraLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &j.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &j.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &j.TypeProperties)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JiraLinkedServiceTypeProperties.
func (j JiraLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "encryptedCredential", j.EncryptedCredential)
	populateAny(objectMap, "host", j.Host)
	populate(objectMap, "password", j.Password)
	populateAny(objectMap, "port", j.Port)
	populateAny(objectMap, "useEncryptedEndpoints", j.UseEncryptedEndpoints)
	populateAny(objectMap, "useHostVerification", j.UseHostVerification)
	populateAny(objectMap, "usePeerVerification", j.UsePeerVerification)
	populateAny(objectMap, "username", j.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JiraLinkedServiceTypeProperties.
func (j *JiraLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &j.EncryptedCredential)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &j.Host)
			delete(rawMsg, key)
		case "password":
			j.Password, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &j.Port)
			delete(rawMsg, key)
		case "useEncryptedEndpoints":
			err = unpopulate(val, "UseEncryptedEndpoints", &j.UseEncryptedEndpoints)
			delete(rawMsg, key)
		case "useHostVerification":
			err = unpopulate(val, "UseHostVerification", &j.UseHostVerification)
			delete(rawMsg, key)
		case "usePeerVerification":
			err = unpopulate(val, "UsePeerVerification", &j.UsePeerVerification)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &j.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JiraObjectDataset.
func (j JiraObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", j.Annotations)
	populate(objectMap, "description", j.Description)
	populate(objectMap, "folder", j.Folder)
	populate(objectMap, "linkedServiceName", j.LinkedServiceName)
	populate(objectMap, "parameters", j.Parameters)
	populateAny(objectMap, "schema", j.Schema)
	populateAny(objectMap, "structure", j.Structure)
	objectMap["type"] = "JiraObject"
	populate(objectMap, "typeProperties", j.TypeProperties)
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JiraObjectDataset.
func (j *JiraObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &j.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &j.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &j.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &j.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &j.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &j.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &j.TypeProperties)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JiraSource.
func (j JiraSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", j.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", j.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", j.MaxConcurrentConnections)
	populateAny(objectMap, "query", j.Query)
	populateAny(objectMap, "queryTimeout", j.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", j.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", j.SourceRetryWait)
	objectMap["type"] = "JiraSource"
	if j.AdditionalProperties != nil {
		for key, val := range j.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JiraSource.
func (j *JiraSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &j.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &j.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &j.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &j.Query)
			delete(rawMsg, key)
		case "queryTimeout":
			err = unpopulate(val, "QueryTimeout", &j.QueryTimeout)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &j.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &j.SourceRetryWait)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		default:
			if j.AdditionalProperties == nil {
				j.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				j.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseLinkedService.
func (l LakeHouseLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", l.Annotations)
	populate(objectMap, "connectVia", l.ConnectVia)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "parameters", l.Parameters)
	objectMap["type"] = "LakeHouse"
	populate(objectMap, "typeProperties", l.TypeProperties)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseLinkedService.
func (l *LakeHouseLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &l.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &l.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &l.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &l.TypeProperties)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseLinkedServiceTypeProperties.
func (l LakeHouseLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "artifactId", l.ArtifactID)
	populate(objectMap, "encryptedCredential", l.EncryptedCredential)
	populate(objectMap, "servicePrincipalCredential", l.ServicePrincipalCredential)
	populateAny(objectMap, "servicePrincipalCredentialType", l.ServicePrincipalCredentialType)
	populateAny(objectMap, "servicePrincipalId", l.ServicePrincipalID)
	populate(objectMap, "servicePrincipalKey", l.ServicePrincipalKey)
	populateAny(objectMap, "tenant", l.Tenant)
	populateAny(objectMap, "workspaceId", l.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseLinkedServiceTypeProperties.
func (l *LakeHouseLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactId":
			err = unpopulate(val, "ArtifactID", &l.ArtifactID)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &l.EncryptedCredential)
			delete(rawMsg, key)
		case "servicePrincipalCredential":
			l.ServicePrincipalCredential, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "servicePrincipalCredentialType":
			err = unpopulate(val, "ServicePrincipalCredentialType", &l.ServicePrincipalCredentialType)
			delete(rawMsg, key)
		case "servicePrincipalId":
			err = unpopulate(val, "ServicePrincipalID", &l.ServicePrincipalID)
			delete(rawMsg, key)
		case "servicePrincipalKey":
			l.ServicePrincipalKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "tenant":
			err = unpopulate(val, "Tenant", &l.Tenant)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &l.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseLocation.
func (l LakeHouseLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "fileName", l.FileName)
	populateAny(objectMap, "folderPath", l.FolderPath)
	objectMap["type"] = "LakeHouseLocation"
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseLocation.
func (l *LakeHouseLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &l.FileName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &l.FolderPath)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseReadSettings.
func (l LakeHouseReadSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "deleteFilesAfterCompletion", l.DeleteFilesAfterCompletion)
	populateAny(objectMap, "disableMetricsCollection", l.DisableMetricsCollection)
	populateAny(objectMap, "enablePartitionDiscovery", l.EnablePartitionDiscovery)
	populateAny(objectMap, "fileListPath", l.FileListPath)
	populateAny(objectMap, "maxConcurrentConnections", l.MaxConcurrentConnections)
	populateAny(objectMap, "modifiedDatetimeEnd", l.ModifiedDatetimeEnd)
	populateAny(objectMap, "modifiedDatetimeStart", l.ModifiedDatetimeStart)
	populateAny(objectMap, "partitionRootPath", l.PartitionRootPath)
	populateAny(objectMap, "recursive", l.Recursive)
	objectMap["type"] = "LakeHouseReadSettings"
	populateAny(objectMap, "wildcardFileName", l.WildcardFileName)
	populateAny(objectMap, "wildcardFolderPath", l.WildcardFolderPath)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseReadSettings.
func (l *LakeHouseReadSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deleteFilesAfterCompletion":
			err = unpopulate(val, "DeleteFilesAfterCompletion", &l.DeleteFilesAfterCompletion)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &l.DisableMetricsCollection)
			delete(rawMsg, key)
		case "enablePartitionDiscovery":
			err = unpopulate(val, "EnablePartitionDiscovery", &l.EnablePartitionDiscovery)
			delete(rawMsg, key)
		case "fileListPath":
			err = unpopulate(val, "FileListPath", &l.FileListPath)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &l.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "modifiedDatetimeEnd":
			err = unpopulate(val, "ModifiedDatetimeEnd", &l.ModifiedDatetimeEnd)
			delete(rawMsg, key)
		case "modifiedDatetimeStart":
			err = unpopulate(val, "ModifiedDatetimeStart", &l.ModifiedDatetimeStart)
			delete(rawMsg, key)
		case "partitionRootPath":
			err = unpopulate(val, "PartitionRootPath", &l.PartitionRootPath)
			delete(rawMsg, key)
		case "recursive":
			err = unpopulate(val, "Recursive", &l.Recursive)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "wildcardFileName":
			err = unpopulate(val, "WildcardFileName", &l.WildcardFileName)
			delete(rawMsg, key)
		case "wildcardFolderPath":
			err = unpopulate(val, "WildcardFolderPath", &l.WildcardFolderPath)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseTableDataset.
func (l LakeHouseTableDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", l.Annotations)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "folder", l.Folder)
	populate(objectMap, "linkedServiceName", l.LinkedServiceName)
	populate(objectMap, "parameters", l.Parameters)
	populateAny(objectMap, "schema", l.Schema)
	populateAny(objectMap, "structure", l.Structure)
	objectMap["type"] = "LakeHouseTable"
	populate(objectMap, "typeProperties", l.TypeProperties)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseTableDataset.
func (l *LakeHouseTableDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &l.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &l.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &l.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &l.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &l.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &l.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &l.TypeProperties)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseTableDatasetTypeProperties.
func (l LakeHouseTableDatasetTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "table", l.Table)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseTableDatasetTypeProperties.
func (l *LakeHouseTableDatasetTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "table":
			err = unpopulate(val, "Table", &l.Table)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseTableSink.
func (l LakeHouseTableSink) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "disableMetricsCollection", l.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", l.MaxConcurrentConnections)
	populateAny(objectMap, "partitionNameList", l.PartitionNameList)
	populateAny(objectMap, "partitionOption", l.PartitionOption)
	populateAny(objectMap, "sinkRetryCount", l.SinkRetryCount)
	populateAny(objectMap, "sinkRetryWait", l.SinkRetryWait)
	populateAny(objectMap, "tableActionOption", l.TableActionOption)
	objectMap["type"] = "LakeHouseTableSink"
	populateAny(objectMap, "writeBatchSize", l.WriteBatchSize)
	populateAny(objectMap, "writeBatchTimeout", l.WriteBatchTimeout)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseTableSink.
func (l *LakeHouseTableSink) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &l.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &l.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "partitionNameList":
			err = unpopulate(val, "PartitionNameList", &l.PartitionNameList)
			delete(rawMsg, key)
		case "partitionOption":
			err = unpopulate(val, "PartitionOption", &l.PartitionOption)
			delete(rawMsg, key)
		case "sinkRetryCount":
			err = unpopulate(val, "SinkRetryCount", &l.SinkRetryCount)
			delete(rawMsg, key)
		case "sinkRetryWait":
			err = unpopulate(val, "SinkRetryWait", &l.SinkRetryWait)
			delete(rawMsg, key)
		case "tableActionOption":
			err = unpopulate(val, "TableActionOption", &l.TableActionOption)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "writeBatchSize":
			err = unpopulate(val, "WriteBatchSize", &l.WriteBatchSize)
			delete(rawMsg, key)
		case "writeBatchTimeout":
			err = unpopulate(val, "WriteBatchTimeout", &l.WriteBatchTimeout)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseTableSource.
func (l LakeHouseTableSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", l.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", l.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", l.MaxConcurrentConnections)
	populateAny(objectMap, "sourceRetryCount", l.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", l.SourceRetryWait)
	populateAny(objectMap, "timestampAsOf", l.TimestampAsOf)
	objectMap["type"] = "LakeHouseTableSource"
	populateAny(objectMap, "versionAsOf", l.VersionAsOf)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseTableSource.
func (l *LakeHouseTableSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &l.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &l.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &l.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "sourceRetryCount":
			err = unpopulate(val, "SourceRetryCount", &l.SourceRetryCount)
			delete(rawMsg, key)
		case "sourceRetryWait":
			err = unpopulate(val, "SourceRetryWait", &l.SourceRetryWait)
			delete(rawMsg, key)
		case "timestampAsOf":
			err = unpopulate(val, "TimestampAsOf", &l.TimestampAsOf)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "versionAsOf":
			err = unpopulate(val, "VersionAsOf", &l.VersionAsOf)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LakeHouseWriteSettings.
func (l LakeHouseWriteSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "copyBehavior", l.CopyBehavior)
	populateAny(objectMap, "disableMetricsCollection", l.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", l.MaxConcurrentConnections)
	objectMap["type"] = "LakeHouseWriteSettings"
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LakeHouseWriteSettings.
func (l *LakeHouseWriteSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyBehavior":
			err = unpopulate(val, "CopyBehavior", &l.CopyBehavior)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &l.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &l.MaxConcurrentConnections)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LicensedComponentSetupTypeProperties.
func (l LicensedComponentSetupTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentName", l.ComponentName)
	populate(objectMap, "licenseKey", l.LicenseKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LicensedComponentSetupTypeProperties.
func (l *LicensedComponentSetupTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentName":
			err = unpopulate(val, "ComponentName", &l.ComponentName)
			delete(rawMsg, key)
		case "licenseKey":
			l.LicenseKey, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntime.
func (l LinkedIntegrationRuntime) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createTime", l.CreateTime)
	populate(objectMap, "dataFactoryLocation", l.DataFactoryLocation)
	populate(objectMap, "dataFactoryName", l.DataFactoryName)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "subscriptionId", l.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntime.
func (l *LinkedIntegrationRuntime) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createTime":
			err = unpopulateDateTimeRFC3339(val, "CreateTime", &l.CreateTime)
			delete(rawMsg, key)
		case "dataFactoryLocation":
			err = unpopulate(val, "DataFactoryLocation", &l.DataFactoryLocation)
			delete(rawMsg, key)
		case "dataFactoryName":
			err = unpopulate(val, "DataFactoryName", &l.DataFactoryName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &l.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l LinkedIntegrationRuntimeKeyAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authorizationType"] = "Key"
	populate(objectMap, "key", l.Key)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeKeyAuthorization.
func (l *LinkedIntegrationRuntimeKeyAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &l.Key)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l LinkedIntegrationRuntimeRbacAuthorization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authorizationType"] = "RBAC"
	populate(objectMap, "credential", l.Credential)
	populate(objectMap, "resourceId", l.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeRbacAuthorization.
func (l *LinkedIntegrationRuntimeRbacAuthorization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		case "credential":
			err = unpopulate(val, "Credential", &l.Credential)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeRequest.
func (l LinkedIntegrationRuntimeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "factoryName", l.LinkedFactoryName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeRequest.
func (l *LinkedIntegrationRuntimeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "factoryName":
			err = unpopulate(val, "LinkedFactoryName", &l.LinkedFactoryName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedIntegrationRuntimeType.
func (l LinkedIntegrationRuntimeType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authorizationType"] = l.AuthorizationType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedIntegrationRuntimeType.
func (l *LinkedIntegrationRuntimeType) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizationType":
			err = unpopulate(val, "AuthorizationType", &l.AuthorizationType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedService.
func (l LinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", l.Annotations)
	populate(objectMap, "connectVia", l.ConnectVia)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "parameters", l.Parameters)
	objectMap["type"] = l.Type
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedService.
func (l *LinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &l.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &l.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &l.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedServiceDebugResource.
func (l LinkedServiceDebugResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedServiceDebugResource.
func (l *LinkedServiceDebugResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			l.Properties, err = unmarshalLinkedServiceClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedServiceListResponse.
func (l LinkedServiceListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedServiceListResponse.
func (l *LinkedServiceListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedServiceReference.
func (l LinkedServiceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "parameters", l.Parameters)
	populate(objectMap, "referenceName", l.ReferenceName)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedServiceReference.
func (l *LinkedServiceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &l.Parameters)
			delete(rawMsg, key)
		case "referenceName":
			err = unpopulate(val, "ReferenceName", &l.ReferenceName)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkedServiceResource.
func (l LinkedServiceResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", l.Etag)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkedServiceResource.
func (l *LinkedServiceResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &l.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			l.Properties, err = unmarshalLinkedServiceClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogLocationSettings.
func (l LogLocationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linkedServiceName", l.LinkedServiceName)
	populateAny(objectMap, "path", l.Path)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogLocationSettings.
func (l *LogLocationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &l.LinkedServiceName)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &l.Path)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogSettings.
func (l LogSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "copyActivityLogSettings", l.CopyActivityLogSettings)
	populateAny(objectMap, "enableCopyActivityLog", l.EnableCopyActivityLog)
	populate(objectMap, "logLocationSettings", l.LogLocationSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogSettings.
func (l *LogSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "copyActivityLogSettings":
			err = unpopulate(val, "CopyActivityLogSettings", &l.CopyActivityLogSettings)
			delete(rawMsg, key)
		case "enableCopyActivityLog":
			err = unpopulate(val, "EnableCopyActivityLog", &l.EnableCopyActivityLog)
			delete(rawMsg, key)
		case "logLocationSettings":
			err = unpopulate(val, "LogLocationSettings", &l.LogLocationSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LogStorageSettings.
func (l LogStorageSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "enableReliableLogging", l.EnableReliableLogging)
	populate(objectMap, "linkedServiceName", l.LinkedServiceName)
	populateAny(objectMap, "logLevel", l.LogLevel)
	populateAny(objectMap, "path", l.Path)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LogStorageSettings.
func (l *LogStorageSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableReliableLogging":
			err = unpopulate(val, "EnableReliableLogging", &l.EnableReliableLogging)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &l.LinkedServiceName)
			delete(rawMsg, key)
		case "logLevel":
			err = unpopulate(val, "LogLevel", &l.LogLevel)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &l.Path)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LookupActivity.
func (l LookupActivity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", l.DependsOn)
	populate(objectMap, "description", l.Description)
	populate(objectMap, "linkedServiceName", l.LinkedServiceName)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "onInactiveMarkAs", l.OnInactiveMarkAs)
	populate(objectMap, "policy", l.Policy)
	populate(objectMap, "state", l.State)
	objectMap["type"] = "Lookup"
	populate(objectMap, "typeProperties", l.TypeProperties)
	populate(objectMap, "userProperties", l.UserProperties)
	if l.AdditionalProperties != nil {
		for key, val := range l.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LookupActivity.
func (l *LookupActivity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &l.DependsOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &l.LinkedServiceName)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "onInactiveMarkAs":
			err = unpopulate(val, "OnInactiveMarkAs", &l.OnInactiveMarkAs)
			delete(rawMsg, key)
		case "policy":
			err = unpopulate(val, "Policy", &l.Policy)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &l.State)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &l.TypeProperties)
			delete(rawMsg, key)
		case "userProperties":
			err = unpopulate(val, "UserProperties", &l.UserProperties)
			delete(rawMsg, key)
		default:
			if l.AdditionalProperties == nil {
				l.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				l.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LookupActivityTypeProperties.
func (l LookupActivityTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", l.Dataset)
	populateAny(objectMap, "firstRowOnly", l.FirstRowOnly)
	populate(objectMap, "source", l.Source)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LookupActivityTypeProperties.
func (l *LookupActivityTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &l.Dataset)
			delete(rawMsg, key)
		case "firstRowOnly":
			err = unpopulate(val, "FirstRowOnly", &l.FirstRowOnly)
			delete(rawMsg, key)
		case "source":
			l.Source, err = unmarshalCopySourceClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MagentoLinkedService.
func (m MagentoLinkedService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", m.Annotations)
	populate(objectMap, "connectVia", m.ConnectVia)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "parameters", m.Parameters)
	objectMap["type"] = "Magento"
	populate(objectMap, "typeProperties", m.TypeProperties)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MagentoLinkedService.
func (m *MagentoLinkedService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &m.Annotations)
			delete(rawMsg, key)
		case "connectVia":
			err = unpopulate(val, "ConnectVia", &m.ConnectVia)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &m.Parameters)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &m.TypeProperties)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MagentoLinkedServiceTypeProperties.
func (m MagentoLinkedServiceTypeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", m.AccessToken)
	populate(objectMap, "encryptedCredential", m.EncryptedCredential)
	populateAny(objectMap, "host", m.Host)
	populateAny(objectMap, "useEncryptedEndpoints", m.UseEncryptedEndpoints)
	populateAny(objectMap, "useHostVerification", m.UseHostVerification)
	populateAny(objectMap, "usePeerVerification", m.UsePeerVerification)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MagentoLinkedServiceTypeProperties.
func (m *MagentoLinkedServiceTypeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			m.AccessToken, err = unmarshalSecretBaseClassification(val)
			delete(rawMsg, key)
		case "encryptedCredential":
			err = unpopulate(val, "EncryptedCredential", &m.EncryptedCredential)
			delete(rawMsg, key)
		case "host":
			err = unpopulate(val, "Host", &m.Host)
			delete(rawMsg, key)
		case "useEncryptedEndpoints":
			err = unpopulate(val, "UseEncryptedEndpoints", &m.UseEncryptedEndpoints)
			delete(rawMsg, key)
		case "useHostVerification":
			err = unpopulate(val, "UseHostVerification", &m.UseHostVerification)
			delete(rawMsg, key)
		case "usePeerVerification":
			err = unpopulate(val, "UsePeerVerification", &m.UsePeerVerification)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MagentoObjectDataset.
func (m MagentoObjectDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "annotations", m.Annotations)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "folder", m.Folder)
	populate(objectMap, "linkedServiceName", m.LinkedServiceName)
	populate(objectMap, "parameters", m.Parameters)
	populateAny(objectMap, "schema", m.Schema)
	populateAny(objectMap, "structure", m.Structure)
	objectMap["type"] = "MagentoObject"
	populate(objectMap, "typeProperties", m.TypeProperties)
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MagentoObjectDataset.
func (m *MagentoObjectDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "annotations":
			err = unpopulate(val, "Annotations", &m.Annotations)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "folder":
			err = unpopulate(val, "Folder", &m.Folder)
			delete(rawMsg, key)
		case "linkedServiceName":
			err = unpopulate(val, "LinkedServiceName", &m.LinkedServiceName)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &m.Parameters)
			delete(rawMsg, key)
		case "schema":
			err = unpopulate(val, "Schema", &m.Schema)
			delete(rawMsg, key)
		case "structure":
			err = unpopulate(val, "Structure", &m.Structure)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "typeProperties":
			err = unpopulate(val, "TypeProperties", &m.TypeProperties)
			delete(rawMsg, key)
		default:
			if m.AdditionalProperties == nil {
				m.AdditionalProperties = map[string]any{}
			}
			if val != nil {
				var aux any
				err = json.Unmarshal(val, &aux)
				m.AdditionalProperties[key] = aux
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MagentoSource.
func (m MagentoSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "additionalColumns", m.AdditionalColumns)
	populateAny(objectMap, "disableMetricsCollection", m.DisableMetricsCollection)
	populateAny(objectMap, "maxConcurrentConnections", m.MaxConcurrentConnections)
	populateAny(objectMap, "query", m.Query)
	populateAny(objectMap, "queryTimeout", m.QueryTimeout)
	populateAny(objectMap, "sourceRetryCount", m.SourceRetryCount)
	populateAny(objectMap, "sourceRetryWait", m.SourceRetryWait)
	objectMap["type"] = "MagentoSource"
	if m.AdditionalProperties != nil {
		for key, val := range m.AdditionalProperties {
			objectMap[key] = val
		}
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MagentoSource.
func (m *MagentoSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalColumns":
			err = unpopulate(val, "AdditionalColumns", &m.AdditionalColumns)
			delete(rawMsg, key)
		case "disableMetricsCollection":
			err = unpopulate(val, "DisableMetricsCollection", &m.DisableMetricsCollection)
			delete(rawMsg, key)
		case "maxConcurrentConnections":
			err = unpopulate(val, "MaxConcurrentConnections", &m.MaxConcurrentConnections)
			delete(rawMsg, key)
		case