//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/dataprotection/armdataprotection/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ResourceGuardsServer is a fake server for instances of the armdataprotection.ResourceGuardsClient type.
type ResourceGuardsServer struct {
	// Delete is the fake for method ResourceGuardsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientDeleteOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ResourceGuardsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetResponse], errResp azfake.ErrorResponder)

	// NewGetBackupSecurityPINRequestsObjectsPager is the fake for method ResourceGuardsClient.NewGetBackupSecurityPINRequestsObjectsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetBackupSecurityPINRequestsObjectsPager func(resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetBackupSecurityPINRequestsObjectsOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse])

	// GetDefaultBackupSecurityPINRequestsObject is the fake for method ResourceGuardsClient.GetDefaultBackupSecurityPINRequestsObject
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultBackupSecurityPINRequestsObject func(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *armdataprotection.ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetDefaultBackupSecurityPINRequestsObjectResponse], errResp azfake.ErrorResponder)

	// GetDefaultDeleteProtectedItemRequestsObject is the fake for method ResourceGuardsClient.GetDefaultDeleteProtectedItemRequestsObject
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultDeleteProtectedItemRequestsObject func(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *armdataprotection.ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetDefaultDeleteProtectedItemRequestsObjectResponse], errResp azfake.ErrorResponder)

	// GetDefaultDeleteResourceGuardProxyRequestsObject is the fake for method ResourceGuardsClient.GetDefaultDeleteResourceGuardProxyRequestsObject
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultDeleteResourceGuardProxyRequestsObject func(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *armdataprotection.ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetDefaultDeleteResourceGuardProxyRequestsObjectResponse], errResp azfake.ErrorResponder)

	// GetDefaultDisableSoftDeleteRequestsObject is the fake for method ResourceGuardsClient.GetDefaultDisableSoftDeleteRequestsObject
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultDisableSoftDeleteRequestsObject func(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *armdataprotection.ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetDefaultDisableSoftDeleteRequestsObjectResponse], errResp azfake.ErrorResponder)

	// GetDefaultUpdateProtectedItemRequestsObject is the fake for method ResourceGuardsClient.GetDefaultUpdateProtectedItemRequestsObject
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultUpdateProtectedItemRequestsObject func(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *armdataprotection.ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetDefaultUpdateProtectedItemRequestsObjectResponse], errResp azfake.ErrorResponder)

	// GetDefaultUpdateProtectionPolicyRequestsObject is the fake for method ResourceGuardsClient.GetDefaultUpdateProtectionPolicyRequestsObject
	// HTTP status codes to indicate success: http.StatusOK
	GetDefaultUpdateProtectionPolicyRequestsObject func(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string, options *armdataprotection.ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientGetDefaultUpdateProtectionPolicyRequestsObjectResponse], errResp azfake.ErrorResponder)

	// NewGetDeleteProtectedItemRequestsObjectsPager is the fake for method ResourceGuardsClient.NewGetDeleteProtectedItemRequestsObjectsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetDeleteProtectedItemRequestsObjectsPager func(resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse])

	// NewGetDeleteResourceGuardProxyRequestsObjectsPager is the fake for method ResourceGuardsClient.NewGetDeleteResourceGuardProxyRequestsObjectsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetDeleteResourceGuardProxyRequestsObjectsPager func(resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse])

	// NewGetDisableSoftDeleteRequestsObjectsPager is the fake for method ResourceGuardsClient.NewGetDisableSoftDeleteRequestsObjectsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetDisableSoftDeleteRequestsObjectsPager func(resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse])

	// NewGetResourcesInResourceGroupPager is the fake for method ResourceGuardsClient.NewGetResourcesInResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetResourcesInResourceGroupPager func(resourceGroupName string, options *armdataprotection.ResourceGuardsClientGetResourcesInResourceGroupOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetResourcesInResourceGroupResponse])

	// NewGetResourcesInSubscriptionPager is the fake for method ResourceGuardsClient.NewGetResourcesInSubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetResourcesInSubscriptionPager func(options *armdataprotection.ResourceGuardsClientGetResourcesInSubscriptionOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetResourcesInSubscriptionResponse])

	// NewGetUpdateProtectedItemRequestsObjectsPager is the fake for method ResourceGuardsClient.NewGetUpdateProtectedItemRequestsObjectsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetUpdateProtectedItemRequestsObjectsPager func(resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse])

	// NewGetUpdateProtectionPolicyRequestsObjectsPager is the fake for method ResourceGuardsClient.NewGetUpdateProtectionPolicyRequestsObjectsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetUpdateProtectionPolicyRequestsObjectsPager func(resourceGroupName string, resourceGuardsName string, options *armdataprotection.ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsOptions) (resp azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse])

	// Patch is the fake for method ResourceGuardsClient.Patch
	// HTTP status codes to indicate success: http.StatusOK
	Patch func(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters armdataprotection.PatchResourceGuardInput, options *armdataprotection.ResourceGuardsClientPatchOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientPatchResponse], errResp azfake.ErrorResponder)

	// Put is the fake for method ResourceGuardsClient.Put
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Put func(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters armdataprotection.ResourceGuardResource, options *armdataprotection.ResourceGuardsClientPutOptions) (resp azfake.Responder[armdataprotection.ResourceGuardsClientPutResponse], errResp azfake.ErrorResponder)
}

// NewResourceGuardsServerTransport creates a new instance of ResourceGuardsServerTransport with the provided implementation.
// The returned ResourceGuardsServerTransport instance is connected to an instance of armdataprotection.ResourceGuardsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewResourceGuardsServerTransport(srv *ResourceGuardsServer) *ResourceGuardsServerTransport {
	return &ResourceGuardsServerTransport{
		srv: srv,
		newGetBackupSecurityPINRequestsObjectsPager:        newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse]](),
		newGetDeleteProtectedItemRequestsObjectsPager:      newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse]](),
		newGetDeleteResourceGuardProxyRequestsObjectsPager: newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse]](),
		newGetDisableSoftDeleteRequestsObjectsPager:        newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse]](),
		newGetResourcesInResourceGroupPager:                newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetResourcesInResourceGroupResponse]](),
		newGetResourcesInSubscriptionPager:                 newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetResourcesInSubscriptionResponse]](),
		newGetUpdateProtectedItemRequestsObjectsPager:      newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse]](),
		newGetUpdateProtectionPolicyRequestsObjectsPager:   newTracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse]](),
	}
}

// ResourceGuardsServerTransport connects instances of armdataprotection.ResourceGuardsClient to instances of ResourceGuardsServer.
// Don't use this type directly, use NewResourceGuardsServerTransport instead.
type ResourceGuardsServerTransport struct {
	srv                                                *ResourceGuardsServer
	newGetBackupSecurityPINRequestsObjectsPager        *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse]]
	newGetDeleteProtectedItemRequestsObjectsPager      *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse]]
	newGetDeleteResourceGuardProxyRequestsObjectsPager *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse]]
	newGetDisableSoftDeleteRequestsObjectsPager        *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse]]
	newGetResourcesInResourceGroupPager                *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetResourcesInResourceGroupResponse]]
	newGetResourcesInSubscriptionPager                 *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetResourcesInSubscriptionResponse]]
	newGetUpdateProtectedItemRequestsObjectsPager      *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse]]
	newGetUpdateProtectionPolicyRequestsObjectsPager   *tracker[azfake.PagerResponder[armdataprotection.ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse]]
}

// Do implements the policy.Transporter interface for ResourceGuardsServerTransport.
func (r *ResourceGuardsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ResourceGuardsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "ResourceGuardsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ResourceGuardsClient.NewGetBackupSecurityPINRequestsObjectsPager":
		resp, err = r.dispatchNewGetBackupSecurityPINRequestsObjectsPager(req)
	case "ResourceGuardsClient.GetDefaultBackupSecurityPINRequestsObject":
		resp, err = r.dispatchGetDefaultBackupSecurityPINRequestsObject(req)
	case "ResourceGuardsClient.GetDefaultDeleteProtectedItemRequestsObject":
		resp, err = r.dispatchGetDefaultDeleteProtectedItemRequestsObject(req)
	case "ResourceGuardsClient.GetDefaultDeleteResourceGuardProxyRequestsObject":
		resp, err = r.dispatchGetDefaultDeleteResourceGuardProxyRequestsObject(req)
	case "ResourceGuardsClient.GetDefaultDisableSoftDeleteRequestsObject":
		resp, err = r.dispatchGetDefaultDisableSoftDeleteRequestsObject(req)
	case "ResourceGuardsClient.GetDefaultUpdateProtectedItemRequestsObject":
		resp, err = r.dispatchGetDefaultUpdateProtectedItemRequestsObject(req)
	case "ResourceGuardsClient.GetDefaultUpdateProtectionPolicyRequestsObject":
		resp, err = r.dispatchGetDefaultUpdateProtectionPolicyRequestsObject(req)
	case "ResourceGuardsClient.NewGetDeleteProtectedItemRequestsObjectsPager":
		resp, err = r.dispatchNewGetDeleteProtectedItemRequestsObjectsPager(req)
	case "ResourceGuardsClient.NewGetDeleteResourceGuardProxyRequestsObjectsPager":
		resp, err = r.dispatchNewGetDeleteResourceGuardProxyRequestsObjectsPager(req)
	case "ResourceGuardsClient.NewGetDisableSoftDeleteRequestsObjectsPager":
		resp, err = r.dispatchNewGetDisableSoftDeleteRequestsObjectsPager(req)
	case "ResourceGuardsClient.NewGetResourcesInResourceGroupPager":
		resp, err = r.dispatchNewGetResourcesInResourceGroupPager(req)
	case "ResourceGuardsClient.NewGetResourcesInSubscriptionPager":
		resp, err = r.dispatchNewGetResourcesInSubscriptionPager(req)
	case "ResourceGuardsClient.NewGetUpdateProtectedItemRequestsObjectsPager":
		resp, err = r.dispatchNewGetUpdateProtectedItemRequestsObjectsPager(req)
	case "ResourceGuardsClient.NewGetUpdateProtectionPolicyRequestsObjectsPager":
		resp, err = r.dispatchNewGetUpdateProtectionPolicyRequestsObjectsPager(req)
	case "ResourceGuardsClient.Patch":
		resp, err = r.dispatchPatch(req)
	case "ResourceGuardsClient.Put":
		resp, err = r.dispatchPut(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceGuardResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetBackupSecurityPINRequestsObjectsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetBackupSecurityPINRequestsObjectsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetBackupSecurityPINRequestsObjectsPager not implemented")}
	}
	newGetBackupSecurityPINRequestsObjectsPager := r.newGetBackupSecurityPINRequestsObjectsPager.get(req)
	if newGetBackupSecurityPINRequestsObjectsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getBackupSecurityPINRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetBackupSecurityPINRequestsObjectsPager(resourceGroupNameParam, resourceGuardsNameParam, nil)
		newGetBackupSecurityPINRequestsObjectsPager = &resp
		r.newGetBackupSecurityPINRequestsObjectsPager.add(req, newGetBackupSecurityPINRequestsObjectsPager)
		server.PagerResponderInjectNextLinks(newGetBackupSecurityPINRequestsObjectsPager, req, func(page *armdataprotection.ResourceGuardsClientGetBackupSecurityPINRequestsObjectsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetBackupSecurityPINRequestsObjectsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetBackupSecurityPINRequestsObjectsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetBackupSecurityPINRequestsObjectsPager) {
		r.newGetBackupSecurityPINRequestsObjectsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGetDefaultBackupSecurityPINRequestsObject(req *http.Request) (*http.Response, error) {
	if r.srv.GetDefaultBackupSecurityPINRequestsObject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultBackupSecurityPINRequestsObject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getBackupSecurityPINRequests/(?P<requestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	requestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetDefaultBackupSecurityPINRequestsObject(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, requestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DppBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGetDefaultDeleteProtectedItemRequestsObject(req *http.Request) (*http.Response, error) {
	if r.srv.GetDefaultDeleteProtectedItemRequestsObject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultDeleteProtectedItemRequestsObject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteProtectedItemRequests/(?P<requestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	requestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetDefaultDeleteProtectedItemRequestsObject(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, requestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DppBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGetDefaultDeleteResourceGuardProxyRequestsObject(req *http.Request) (*http.Response, error) {
	if r.srv.GetDefaultDeleteResourceGuardProxyRequestsObject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultDeleteResourceGuardProxyRequestsObject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteResourceGuardProxyRequests/(?P<requestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	requestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetDefaultDeleteResourceGuardProxyRequestsObject(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, requestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DppBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGetDefaultDisableSoftDeleteRequestsObject(req *http.Request) (*http.Response, error) {
	if r.srv.GetDefaultDisableSoftDeleteRequestsObject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultDisableSoftDeleteRequestsObject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableSoftDeleteRequests/(?P<requestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	requestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetDefaultDisableSoftDeleteRequestsObject(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, requestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DppBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGetDefaultUpdateProtectedItemRequestsObject(req *http.Request) (*http.Response, error) {
	if r.srv.GetDefaultUpdateProtectedItemRequestsObject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultUpdateProtectedItemRequestsObject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateProtectedItemRequests/(?P<requestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	requestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetDefaultUpdateProtectedItemRequestsObject(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, requestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DppBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchGetDefaultUpdateProtectionPolicyRequestsObject(req *http.Request) (*http.Response, error) {
	if r.srv.GetDefaultUpdateProtectionPolicyRequestsObject == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDefaultUpdateProtectionPolicyRequestsObject not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateProtectionPolicyRequests/(?P<requestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	requestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("requestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetDefaultUpdateProtectionPolicyRequestsObject(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, requestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DppBaseResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetDeleteProtectedItemRequestsObjectsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetDeleteProtectedItemRequestsObjectsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetDeleteProtectedItemRequestsObjectsPager not implemented")}
	}
	newGetDeleteProtectedItemRequestsObjectsPager := r.newGetDeleteProtectedItemRequestsObjectsPager.get(req)
	if newGetDeleteProtectedItemRequestsObjectsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteProtectedItemRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetDeleteProtectedItemRequestsObjectsPager(resourceGroupNameParam, resourceGuardsNameParam, nil)
		newGetDeleteProtectedItemRequestsObjectsPager = &resp
		r.newGetDeleteProtectedItemRequestsObjectsPager.add(req, newGetDeleteProtectedItemRequestsObjectsPager)
		server.PagerResponderInjectNextLinks(newGetDeleteProtectedItemRequestsObjectsPager, req, func(page *armdataprotection.ResourceGuardsClientGetDeleteProtectedItemRequestsObjectsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetDeleteProtectedItemRequestsObjectsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetDeleteProtectedItemRequestsObjectsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetDeleteProtectedItemRequestsObjectsPager) {
		r.newGetDeleteProtectedItemRequestsObjectsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetDeleteResourceGuardProxyRequestsObjectsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetDeleteResourceGuardProxyRequestsObjectsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetDeleteResourceGuardProxyRequestsObjectsPager not implemented")}
	}
	newGetDeleteResourceGuardProxyRequestsObjectsPager := r.newGetDeleteResourceGuardProxyRequestsObjectsPager.get(req)
	if newGetDeleteResourceGuardProxyRequestsObjectsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deleteResourceGuardProxyRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetDeleteResourceGuardProxyRequestsObjectsPager(resourceGroupNameParam, resourceGuardsNameParam, nil)
		newGetDeleteResourceGuardProxyRequestsObjectsPager = &resp
		r.newGetDeleteResourceGuardProxyRequestsObjectsPager.add(req, newGetDeleteResourceGuardProxyRequestsObjectsPager)
		server.PagerResponderInjectNextLinks(newGetDeleteResourceGuardProxyRequestsObjectsPager, req, func(page *armdataprotection.ResourceGuardsClientGetDeleteResourceGuardProxyRequestsObjectsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetDeleteResourceGuardProxyRequestsObjectsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetDeleteResourceGuardProxyRequestsObjectsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetDeleteResourceGuardProxyRequestsObjectsPager) {
		r.newGetDeleteResourceGuardProxyRequestsObjectsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetDisableSoftDeleteRequestsObjectsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetDisableSoftDeleteRequestsObjectsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetDisableSoftDeleteRequestsObjectsPager not implemented")}
	}
	newGetDisableSoftDeleteRequestsObjectsPager := r.newGetDisableSoftDeleteRequestsObjectsPager.get(req)
	if newGetDisableSoftDeleteRequestsObjectsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableSoftDeleteRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetDisableSoftDeleteRequestsObjectsPager(resourceGroupNameParam, resourceGuardsNameParam, nil)
		newGetDisableSoftDeleteRequestsObjectsPager = &resp
		r.newGetDisableSoftDeleteRequestsObjectsPager.add(req, newGetDisableSoftDeleteRequestsObjectsPager)
		server.PagerResponderInjectNextLinks(newGetDisableSoftDeleteRequestsObjectsPager, req, func(page *armdataprotection.ResourceGuardsClientGetDisableSoftDeleteRequestsObjectsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetDisableSoftDeleteRequestsObjectsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetDisableSoftDeleteRequestsObjectsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetDisableSoftDeleteRequestsObjectsPager) {
		r.newGetDisableSoftDeleteRequestsObjectsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetResourcesInResourceGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetResourcesInResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetResourcesInResourceGroupPager not implemented")}
	}
	newGetResourcesInResourceGroupPager := r.newGetResourcesInResourceGroupPager.get(req)
	if newGetResourcesInResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetResourcesInResourceGroupPager(resourceGroupNameParam, nil)
		newGetResourcesInResourceGroupPager = &resp
		r.newGetResourcesInResourceGroupPager.add(req, newGetResourcesInResourceGroupPager)
		server.PagerResponderInjectNextLinks(newGetResourcesInResourceGroupPager, req, func(page *armdataprotection.ResourceGuardsClientGetResourcesInResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetResourcesInResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetResourcesInResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetResourcesInResourceGroupPager) {
		r.newGetResourcesInResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetResourcesInSubscriptionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetResourcesInSubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetResourcesInSubscriptionPager not implemented")}
	}
	newGetResourcesInSubscriptionPager := r.newGetResourcesInSubscriptionPager.get(req)
	if newGetResourcesInSubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := r.srv.NewGetResourcesInSubscriptionPager(nil)
		newGetResourcesInSubscriptionPager = &resp
		r.newGetResourcesInSubscriptionPager.add(req, newGetResourcesInSubscriptionPager)
		server.PagerResponderInjectNextLinks(newGetResourcesInSubscriptionPager, req, func(page *armdataprotection.ResourceGuardsClientGetResourcesInSubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetResourcesInSubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetResourcesInSubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetResourcesInSubscriptionPager) {
		r.newGetResourcesInSubscriptionPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetUpdateProtectedItemRequestsObjectsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetUpdateProtectedItemRequestsObjectsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetUpdateProtectedItemRequestsObjectsPager not implemented")}
	}
	newGetUpdateProtectedItemRequestsObjectsPager := r.newGetUpdateProtectedItemRequestsObjectsPager.get(req)
	if newGetUpdateProtectedItemRequestsObjectsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateProtectedItemRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetUpdateProtectedItemRequestsObjectsPager(resourceGroupNameParam, resourceGuardsNameParam, nil)
		newGetUpdateProtectedItemRequestsObjectsPager = &resp
		r.newGetUpdateProtectedItemRequestsObjectsPager.add(req, newGetUpdateProtectedItemRequestsObjectsPager)
		server.PagerResponderInjectNextLinks(newGetUpdateProtectedItemRequestsObjectsPager, req, func(page *armdataprotection.ResourceGuardsClientGetUpdateProtectedItemRequestsObjectsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetUpdateProtectedItemRequestsObjectsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetUpdateProtectedItemRequestsObjectsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetUpdateProtectedItemRequestsObjectsPager) {
		r.newGetUpdateProtectedItemRequestsObjectsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchNewGetUpdateProtectionPolicyRequestsObjectsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewGetUpdateProtectionPolicyRequestsObjectsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetUpdateProtectionPolicyRequestsObjectsPager not implemented")}
	}
	newGetUpdateProtectionPolicyRequestsObjectsPager := r.newGetUpdateProtectionPolicyRequestsObjectsPager.get(req)
	if newGetUpdateProtectionPolicyRequestsObjectsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateProtectionPolicyRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewGetUpdateProtectionPolicyRequestsObjectsPager(resourceGroupNameParam, resourceGuardsNameParam, nil)
		newGetUpdateProtectionPolicyRequestsObjectsPager = &resp
		r.newGetUpdateProtectionPolicyRequestsObjectsPager.add(req, newGetUpdateProtectionPolicyRequestsObjectsPager)
		server.PagerResponderInjectNextLinks(newGetUpdateProtectionPolicyRequestsObjectsPager, req, func(page *armdataprotection.ResourceGuardsClientGetUpdateProtectionPolicyRequestsObjectsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetUpdateProtectionPolicyRequestsObjectsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newGetUpdateProtectionPolicyRequestsObjectsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetUpdateProtectionPolicyRequestsObjectsPager) {
		r.newGetUpdateProtectionPolicyRequestsObjectsPager.remove(req)
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchPatch(req *http.Request) (*http.Response, error) {
	if r.srv.Patch == nil {
		return nil, &nonRetriableError{errors.New("fake for method Patch not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdataprotection.PatchResourceGuardInput](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Patch(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceGuardResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ResourceGuardsServerTransport) dispatchPut(req *http.Request) (*http.Response, error) {
	if r.srv.Put == nil {
		return nil, &nonRetriableError{errors.New("fake for method Put not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DataProtection/resourceGuards/(?P<resourceGuardsName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdataprotection.ResourceGuardResource](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceGuardsNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGuardsName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Put(req.Context(), resourceGroupNameParam, resourceGuardsNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourceGuardResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
