//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/subscription/armsubscription"
	"net/http"
)

// PolicyServer is a fake server for instances of the armsubscription.PolicyClient type.
type PolicyServer struct {
	// AddUpdatePolicyForTenant is the fake for method PolicyClient.AddUpdatePolicyForTenant
	// HTTP status codes to indicate success: http.StatusOK
	AddUpdatePolicyForTenant func(ctx context.Context, body armsubscription.PutTenantPolicyRequestProperties, options *armsubscription.PolicyClientAddUpdatePolicyForTenantOptions) (resp azfake.Responder[armsubscription.PolicyClientAddUpdatePolicyForTenantResponse], errResp azfake.ErrorResponder)

	// GetPolicyForTenant is the fake for method PolicyClient.GetPolicyForTenant
	// HTTP status codes to indicate success: http.StatusOK
	GetPolicyForTenant func(ctx context.Context, options *armsubscription.PolicyClientGetPolicyForTenantOptions) (resp azfake.Responder[armsubscription.PolicyClientGetPolicyForTenantResponse], errResp azfake.ErrorResponder)

	// NewListPolicyForTenantPager is the fake for method PolicyClient.NewListPolicyForTenantPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPolicyForTenantPager func(options *armsubscription.PolicyClientListPolicyForTenantOptions) (resp azfake.PagerResponder[armsubscription.PolicyClientListPolicyForTenantResponse])
}

// NewPolicyServerTransport creates a new instance of PolicyServerTransport with the provided implementation.
// The returned PolicyServerTransport instance is connected to an instance of armsubscription.PolicyClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPolicyServerTransport(srv *PolicyServer) *PolicyServerTransport {
	return &PolicyServerTransport{
		srv:                         srv,
		newListPolicyForTenantPager: newTracker[azfake.PagerResponder[armsubscription.PolicyClientListPolicyForTenantResponse]](),
	}
}

// PolicyServerTransport connects instances of armsubscription.PolicyClient to instances of PolicyServer.
// Don't use this type directly, use NewPolicyServerTransport instead.
type PolicyServerTransport struct {
	srv                         *PolicyServer
	newListPolicyForTenantPager *tracker[azfake.PagerResponder[armsubscription.PolicyClientListPolicyForTenantResponse]]
}

// Do implements the policy.Transporter interface for PolicyServerTransport.
func (p *PolicyServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PolicyClient.AddUpdatePolicyForTenant":
		resp, err = p.dispatchAddUpdatePolicyForTenant(req)
	case "PolicyClient.GetPolicyForTenant":
		resp, err = p.dispatchGetPolicyForTenant(req)
	case "PolicyClient.NewListPolicyForTenantPager":
		resp, err = p.dispatchNewListPolicyForTenantPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PolicyServerTransport) dispatchAddUpdatePolicyForTenant(req *http.Request) (*http.Response, error) {
	if p.srv.AddUpdatePolicyForTenant == nil {
		return nil, &nonRetriableError{errors.New("fake for method AddUpdatePolicyForTenant not implemented")}
	}
	body, err := server.UnmarshalRequestAsJSON[armsubscription.PutTenantPolicyRequestProperties](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.AddUpdatePolicyForTenant(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GetTenantPolicyResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyServerTransport) dispatchGetPolicyForTenant(req *http.Request) (*http.Response, error) {
	if p.srv.GetPolicyForTenant == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPolicyForTenant not implemented")}
	}
	respr, errRespr := p.srv.GetPolicyForTenant(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).GetTenantPolicyResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PolicyServerTransport) dispatchNewListPolicyForTenantPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListPolicyForTenantPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPolicyForTenantPager not implemented")}
	}
	newListPolicyForTenantPager := p.newListPolicyForTenantPager.get(req)
	if newListPolicyForTenantPager == nil {
		resp := p.srv.NewListPolicyForTenantPager(nil)
		newListPolicyForTenantPager = &resp
		p.newListPolicyForTenantPager.add(req, newListPolicyForTenantPager)
		server.PagerResponderInjectNextLinks(newListPolicyForTenantPager, req, func(page *armsubscription.PolicyClientListPolicyForTenantResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPolicyForTenantPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListPolicyForTenantPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPolicyForTenantPager) {
		p.newListPolicyForTenantPager.remove(req)
	}
	return resp, nil
}
