
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_struct_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_CycRedCreateCoarseOp( hypre_StructMatrix *A, hypre_StructGrid *coarse_grid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CycRedCreateCoarseOp)( A, coarse_grid, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CycRedSetupCoarseOp( hypre_StructMatrix *A, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CycRedSetupCoarseOp)( A, Ac, cindex, cstride, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CyclicReduction( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CyclicReduction)( cyc_red_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_CyclicReductionCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CyclicReductionCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CyclicReductionDestroy( void *cyc_red_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CyclicReductionDestroy)( cyc_red_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CyclicReductionSetBase( void *cyc_red_vdata, hypre_Index base_index, hypre_Index base_stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CyclicReductionSetBase)( cyc_red_vdata, base_index, base_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CyclicReductionSetCDir( void *cyc_red_vdata, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CyclicReductionSetCDir)( cyc_red_vdata, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CyclicReductionSetup( void *cyc_red_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CyclicReductionSetup)( cyc_red_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_HybridCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridDestroy( void *hybrid_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridDestroy)( hybrid_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridGetDSCGNumIterations( void *hybrid_vdata, HYPRE_Int *dscg_num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridGetDSCGNumIterations)( hybrid_vdata, dscg_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridGetFinalRelativeResidualNorm( void *hybrid_vdata, HYPRE_Real *final_rel_res_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridGetFinalRelativeResidualNorm)( hybrid_vdata, final_rel_res_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridGetNumIterations( void *hybrid_vdata, HYPRE_Int *num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridGetNumIterations)( hybrid_vdata, num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridGetPCGNumIterations( void *hybrid_vdata, HYPRE_Int *pcg_num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridGetPCGNumIterations)( hybrid_vdata, pcg_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridGetRecomputeResidual( void *hybrid_vdata, HYPRE_Int *recompute_residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridGetRecomputeResidual)( hybrid_vdata, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridGetRecomputeResidualP( void *hybrid_vdata, HYPRE_Int *recompute_residual_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridGetRecomputeResidualP)( hybrid_vdata, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetConvergenceTol( void *hybrid_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetConvergenceTol)( hybrid_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetDSCGMaxIter( void *hybrid_vdata, HYPRE_Int dscg_max_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetDSCGMaxIter)( hybrid_vdata, dscg_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetKDim( void *hybrid_vdata, HYPRE_Int k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetKDim)( hybrid_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetLogging( void *hybrid_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetLogging)( hybrid_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetPCGAbsoluteTolFactor( void *hybrid_vdata, HYPRE_Real pcg_atolf )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetPCGAbsoluteTolFactor)( hybrid_vdata, pcg_atolf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetPCGMaxIter( void *hybrid_vdata, HYPRE_Int pcg_max_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetPCGMaxIter)( hybrid_vdata, pcg_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetPrintLevel( void *hybrid_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetPrintLevel)( hybrid_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetRecomputeResidual( void *hybrid_vdata, HYPRE_Int recompute_residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetRecomputeResidual)( hybrid_vdata, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetRecomputeResidualP( void *hybrid_vdata, HYPRE_Int recompute_residual_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetRecomputeResidualP)( hybrid_vdata, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetRelChange( void *hybrid_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetRelChange)( hybrid_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetSolverType( void *hybrid_vdata, HYPRE_Int solver_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetSolverType)( hybrid_vdata, solver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetStopCrit( void *hybrid_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetStopCrit)( hybrid_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetTol( void *hybrid_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetTol)( hybrid_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetTwoNorm( void *hybrid_vdata, HYPRE_Int two_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetTwoNorm)( hybrid_vdata, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSetup( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSetup)( hybrid_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_HybridSolve( void *hybrid_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_HybridSolve)( hybrid_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPNoSym( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPNoSym)( A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPNoSym_onebox_FSS5_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPNoSym_onebox_FSS9_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPSym( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPSym)( A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPSym_onebox_FSS5_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS5_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPSym_onebox_FSS5_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPSym_onebox_FSS9_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG2BuildRAPSym_onebox_FSS9_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2BuildRAPSym_onebox_FSS9_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_PFMG2CreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG2CreateRAPOp)( R, A, P, coarse_grid, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym)( A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym_onebox_FSS07_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym_onebox_FSS19_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPNoSym_onebox_FSS27_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym)( A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym_onebox_FSS07_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS07_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym_onebox_FSS07_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym_onebox_FSS19_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS19_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym_onebox_FSS19_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC0( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym_onebox_FSS27_CC0)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMG3BuildRAPSym_onebox_FSS27_CC1( HYPRE_Int ci, HYPRE_Int fi, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3BuildRAPSym_onebox_FSS27_CC1)( ci, fi, A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_PFMG3CreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMG3CreateRAPOp)( R, A, P, coarse_grid, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGBuildCoarseOp5( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGBuildCoarseOp5)( A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGBuildCoarseOp7( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGBuildCoarseOp7)( A, P, R, cdir, cindex, cstride, RAP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGCoarsen( hypre_Box *cbox, hypre_Index periodic, HYPRE_Int max_levels, HYPRE_Int dxyz_flag, HYPRE_Real *dxyz, HYPRE_Int **cdir_l_ptr, HYPRE_Int **active_l_ptr, HYPRE_Real **relax_weights_ptr, HYPRE_Int *num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGCoarsen)( cbox, periodic, max_levels, dxyz_flag, dxyz, cdir_l_ptr, active_l_ptr, relax_weights_ptr, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGComputeCxyz( hypre_StructMatrix *A, HYPRE_Real *cxyz, HYPRE_Real *sqcxyz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGComputeCxyz)( A, cxyz, sqcxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGComputeDxyz( hypre_StructMatrix *A, HYPRE_Real *dxyz, HYPRE_Int *dxyz_flag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGComputeDxyz)( A, dxyz, dxyz_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGComputeMaxLevels( hypre_StructGrid *grid, HYPRE_Int *max_levels_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGComputeMaxLevels)( grid, max_levels_ptr );
}

/*--------------------------------------------------------------------------*/

void *
hypre_PFMGCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGCreate)( comm );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_PFMGCreateCoarseOp5( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGCreateCoarseOp5)( R, A, P, coarse_grid, cdir );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_PFMGCreateCoarseOp7( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGCreateCoarseOp7)( R, A, P, coarse_grid, cdir );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_PFMGCreateInterpOp( hypre_StructMatrix *A, HYPRE_Int cdir, hypre_Index stride, HYPRE_Int rap_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGCreateInterpOp)( A, cdir, stride, rap_type );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_PFMGCreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int rap_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGCreateRAPOp)( R, A, P, coarse_grid, cdir, rap_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGDestroy( void *pfmg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGDestroy)( pfmg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetFinalRelativeResidualNorm( void *pfmg_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetFinalRelativeResidualNorm)( pfmg_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetJacobiWeight( void *pfmg_vdata, HYPRE_Real *weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetJacobiWeight)( pfmg_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetLogging( void *pfmg_vdata, HYPRE_Int *logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetLogging)( pfmg_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetMatmultType( void *pfmg_vdata, HYPRE_Int *matmult_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetMatmultType)( pfmg_vdata, matmult_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetMaxIter( void *pfmg_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetMaxIter)( pfmg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetMaxLevels( void *pfmg_vdata, HYPRE_Int *max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetMaxLevels)( pfmg_vdata, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetNumIterations( void *pfmg_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetNumIterations)( pfmg_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetNumPostRelax( void *pfmg_vdata, HYPRE_Int *num_post_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetNumPostRelax)( pfmg_vdata, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetNumPreRelax( void *pfmg_vdata, HYPRE_Int *num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetNumPreRelax)( pfmg_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetPrintFreq( void *pfmg_vdata, HYPRE_Int *print_freq )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetPrintFreq)( pfmg_vdata, print_freq );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetPrintLevel( void *pfmg_vdata, HYPRE_Int *print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetPrintLevel)( pfmg_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetRAPType( void *pfmg_vdata, HYPRE_Int *rap_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetRAPType)( pfmg_vdata, rap_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetRelChange( void *pfmg_vdata, HYPRE_Int *rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetRelChange)( pfmg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetRelaxType( void *pfmg_vdata, HYPRE_Int *relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetRelaxType)( pfmg_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetSkipRelax( void *pfmg_vdata, HYPRE_Int *skip_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetSkipRelax)( pfmg_vdata, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetTol( void *pfmg_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetTol)( pfmg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGGetZeroGuess( void *pfmg_vdata, HYPRE_Int *zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGGetZeroGuess)( pfmg_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGPrintLogging( void *pfmg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGPrintLogging)( pfmg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelax( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelax)( pfmg_relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_PFMGRelaxCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxDestroy( void *pfmg_relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxDestroy)( pfmg_relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetJacobiWeight( void *pfmg_relax_vdata, HYPRE_Real weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetJacobiWeight)( pfmg_relax_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetMaxIter( void *pfmg_relax_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetMaxIter)( pfmg_relax_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetPostRelax( void *pfmg_relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetPostRelax)( pfmg_relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetPreRelax( void *pfmg_relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetPreRelax)( pfmg_relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetTempVec( void *pfmg_relax_vdata, hypre_StructVector *t )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetTempVec)( pfmg_relax_vdata, t );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetTol( void *pfmg_relax_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetTol)( pfmg_relax_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetType( void *pfmg_relax_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetType)( pfmg_relax_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetZeroGuess( void *pfmg_relax_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetZeroGuess)( pfmg_relax_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGRelaxSetup( void *pfmg_relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGRelaxSetup)( pfmg_relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetDxyz( void *pfmg_vdata, HYPRE_Real *dxyz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetDxyz)( pfmg_vdata, dxyz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetJacobiWeight( void *pfmg_vdata, HYPRE_Real weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetJacobiWeight)( pfmg_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetLogging( void *pfmg_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetLogging)( pfmg_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetMatmultType( void *pfmg_vdata, HYPRE_Int matmult_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetMatmultType)( pfmg_vdata, matmult_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetMaxIter( void *pfmg_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetMaxIter)( pfmg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetMaxLevels( void *pfmg_vdata, HYPRE_Int max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetMaxLevels)( pfmg_vdata, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetNumPostRelax( void *pfmg_vdata, HYPRE_Int num_post_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetNumPostRelax)( pfmg_vdata, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetNumPreRelax( void *pfmg_vdata, HYPRE_Int num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetNumPreRelax)( pfmg_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetPrintFreq( void *pfmg_vdata, HYPRE_Int print_freq )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetPrintFreq)( pfmg_vdata, print_freq );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetPrintLevel( void *pfmg_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetPrintLevel)( pfmg_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetRAPType( void *pfmg_vdata, HYPRE_Int rap_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetRAPType)( pfmg_vdata, rap_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetRelChange( void *pfmg_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetRelChange)( pfmg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetRelaxType( void *pfmg_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetRelaxType)( pfmg_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetSkipRelax( void *pfmg_vdata, HYPRE_Int skip_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetSkipRelax)( pfmg_vdata, skip_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetTol( void *pfmg_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetTol)( pfmg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetZeroGuess( void *pfmg_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetZeroGuess)( pfmg_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetup( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetup)( pfmg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetupInterpOp( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetupInterpOp)( P, A, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetupInterpOp_core_CC( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, HYPRE_Complex *Pconst0_ptr, HYPRE_Complex *Pconst1_ptr, HYPRE_Complex *Pconst2_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetupInterpOp_core_CC)( P, A, cdir, Pconst0_ptr, Pconst1_ptr, Pconst2_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetupInterpOp_core_VC( hypre_StructMatrix *P, hypre_StructMatrix *A, HYPRE_Int cdir, HYPRE_Complex Pconst0, HYPRE_Complex Pconst1, HYPRE_Complex Pconst2 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetupInterpOp_core_VC)( P, A, cdir, Pconst0, Pconst1, Pconst2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSetupRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int rap_type, hypre_StructMatrix *Ac )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSetupRAPOp)( R, A, P, cdir, cindex, cstride, rap_type, Ac );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_PFMGSolve( void *pfmg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_PFMGSolve)( pfmg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackConstantCoefGS( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackConstantCoefGS)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGS( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGS)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_RedBlackGSCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSDestroy( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSDestroy)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSSetMaxIter( void *relax_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSSetMaxIter)( relax_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSSetStartBlack( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSSetStartBlack)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSSetStartRed( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSSetStartRed)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSSetTol( void *relax_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSSetTol)( relax_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSSetZeroGuess( void *relax_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSSetZeroGuess)( relax_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_RedBlackGSSetup( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_RedBlackGSSetup)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG2BuildRAPNoSym( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG2BuildRAPNoSym)( A, PT, R, RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG2BuildRAPSym( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG2BuildRAPSym)( A, PT, R, RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_SMG2CreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG2CreateRAPOp)( R, A, PT, coarse_grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG2RAPPeriodicNoSym( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG2RAPPeriodicNoSym)( RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG2RAPPeriodicSym( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG2RAPPeriodicSym)( RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG3BuildRAPNoSym( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG3BuildRAPNoSym)( A, PT, R, RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG3BuildRAPSym( hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *R, hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG3BuildRAPSym)( A, PT, R, RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_SMG3CreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG3CreateRAPOp)( R, A, PT, coarse_grid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG3RAPPeriodicNoSym( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG3RAPPeriodicNoSym)( RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMG3RAPPeriodicSym( hypre_StructMatrix *RAP, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMG3RAPPeriodicSym)( RAP, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGAxpy( HYPRE_Real alpha, hypre_StructVector *x, hypre_StructVector *y, hypre_Index base_index, hypre_Index base_stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGAxpy)( alpha, x, y, base_index, base_stride );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SMGCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGCreate)( comm );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_SMGCreateInterpOp( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGCreateInterpOp)( A, cgrid, cdir );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_SMGCreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructGrid *coarse_grid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGCreateRAPOp)( R, A, PT, coarse_grid );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_SMGCreateRestrictOp( hypre_StructMatrix *A, hypre_StructGrid *cgrid, HYPRE_Int cdir )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGCreateRestrictOp)( A, cgrid, cdir );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGDestroy( void *smg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGDestroy)( smg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetFinalRelativeResidualNorm( void *smg_vdata, HYPRE_Real *relative_residual_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetFinalRelativeResidualNorm)( smg_vdata, relative_residual_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetLogging( void *smg_vdata, HYPRE_Int *logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetLogging)( smg_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetMaxIter( void *smg_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetMaxIter)( smg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetMemoryUse( void *smg_vdata, HYPRE_Int *memory_use )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetMemoryUse)( smg_vdata, memory_use );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetNumIterations( void *smg_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetNumIterations)( smg_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetNumPostRelax( void *smg_vdata, HYPRE_Int *num_post_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetNumPostRelax)( smg_vdata, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetNumPreRelax( void *smg_vdata, HYPRE_Int *num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetNumPreRelax)( smg_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetPrintLevel( void *smg_vdata, HYPRE_Int *print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetPrintLevel)( smg_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetRelChange( void *smg_vdata, HYPRE_Int *rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetRelChange)( smg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetTol( void *smg_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetTol)( smg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGGetZeroGuess( void *smg_vdata, HYPRE_Int *zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGGetZeroGuess)( smg_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGPrintLogging( void *smg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGPrintLogging)( smg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelax( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelax)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SMGRelaxCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxDestroy( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxDestroy)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxDestroyARem( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxDestroyARem)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxDestroyASol( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxDestroyASol)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxDestroyTempVec( void *relax_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxDestroyTempVec)( relax_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetBase( void *relax_vdata, hypre_Index base_index, hypre_Index base_stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetBase)( relax_vdata, base_index, base_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetMaxIter( void *relax_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetMaxIter)( relax_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetMaxLevel( void *relax_vdata, HYPRE_Int num_max_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetMaxLevel)( relax_vdata, num_max_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetMemoryUse( void *relax_vdata, HYPRE_Int memory_use )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetMemoryUse)( relax_vdata, memory_use );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetNewMatrixStencil( void *relax_vdata, hypre_StructStencil *diff_stencil )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetNewMatrixStencil)( relax_vdata, diff_stencil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetNumPostRelax( void *relax_vdata, HYPRE_Int num_post_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetNumPostRelax)( relax_vdata, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetNumPreRelax( void *relax_vdata, HYPRE_Int num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetNumPreRelax)( relax_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetNumPreSpaces( void *relax_vdata, HYPRE_Int num_pre_spaces )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetNumPreSpaces)( relax_vdata, num_pre_spaces );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetNumRegSpaces( void *relax_vdata, HYPRE_Int num_reg_spaces )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetNumRegSpaces)( relax_vdata, num_reg_spaces );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetNumSpaces( void *relax_vdata, HYPRE_Int num_spaces )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetNumSpaces)( relax_vdata, num_spaces );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetPreSpaceRank( void *relax_vdata, HYPRE_Int i, HYPRE_Int pre_space_rank )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetPreSpaceRank)( relax_vdata, i, pre_space_rank );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetRegSpaceRank( void *relax_vdata, HYPRE_Int i, HYPRE_Int reg_space_rank )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetRegSpaceRank)( relax_vdata, i, reg_space_rank );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetSpace( void *relax_vdata, HYPRE_Int i, HYPRE_Int space_index, HYPRE_Int space_stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetSpace)( relax_vdata, i, space_index, space_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetTempVec( void *relax_vdata, hypre_StructVector *temp_vec )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetTempVec)( relax_vdata, temp_vec );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetTol( void *relax_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetTol)( relax_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetZeroGuess( void *relax_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetZeroGuess)( relax_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetup( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetup)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetupARem( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetupARem)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetupASol( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetupASol)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetupBaseBoxArray( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetupBaseBoxArray)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGRelaxSetupTempVec( void *relax_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGRelaxSetupTempVec)( relax_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGResidual( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGResidual)( residual_vdata, A, x, b, r );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SMGResidualCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGResidualCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGResidualDestroy( void *residual_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGResidualDestroy)( residual_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGResidualSetBase( void *residual_vdata, hypre_Index base_index, hypre_Index base_stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGResidualSetBase)( residual_vdata, base_index, base_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGResidualSetup( void *residual_vdata, hypre_StructMatrix *A, hypre_StructVector *x, hypre_StructVector *b, hypre_StructVector *r )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGResidualSetup)( residual_vdata, A, x, b, r );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetBase( void *smg_vdata, hypre_Index base_index, hypre_Index base_stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetBase)( smg_vdata, base_index, base_stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetLogging( void *smg_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetLogging)( smg_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetMaxIter( void *smg_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetMaxIter)( smg_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetMaxLevel( void *smg_vdata, HYPRE_Int max_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetMaxLevel)( smg_vdata, max_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetMemoryUse( void *smg_vdata, HYPRE_Int memory_use )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetMemoryUse)( smg_vdata, memory_use );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetNumPostRelax( void *smg_vdata, HYPRE_Int num_post_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetNumPostRelax)( smg_vdata, num_post_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetNumPreRelax( void *smg_vdata, HYPRE_Int num_pre_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetNumPreRelax)( smg_vdata, num_pre_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetPrintLevel( void *smg_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetPrintLevel)( smg_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetRelChange( void *smg_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetRelChange)( smg_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetStructVectorConstantValues( hypre_StructVector *vector, HYPRE_Real values, hypre_BoxArray *box_array, hypre_Index stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetStructVectorConstantValues)( vector, values, box_array, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetTol( void *smg_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetTol)( smg_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetZeroGuess( void *smg_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetZeroGuess)( smg_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetup( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetup)( smg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetupInterpOp( void *relax_data, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x, hypre_StructMatrix *PT, HYPRE_Int cdir, hypre_Index cindex, hypre_Index findex, hypre_Index stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetupInterpOp)( relax_data, A, b, x, PT, cdir, cindex, findex, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetupRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *PT, hypre_StructMatrix *Ac, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetupRAPOp)( R, A, PT, Ac, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSetupRestrictOp( hypre_StructMatrix *A, hypre_StructMatrix *R, hypre_StructVector *temp_vec, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSetupRestrictOp)( A, R, temp_vec, cdir, cindex, cstride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SMGSolve( void *smg_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SMGSolve)( smg_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiBuildRAP( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix *R, HYPRE_Int cdir, hypre_Index cindex, hypre_Index cstride, HYPRE_Int P_stored_as_transpose, hypre_StructMatrix *RAP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiBuildRAP)( A, P, R, cdir, cindex, cstride, P_stored_as_transpose, RAP );
}

/*--------------------------------------------------------------------------*/

hypre_StructMatrix *
hypre_SemiCreateRAPOp( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructGrid *coarse_grid, HYPRE_Int cdir, HYPRE_Int P_stored_as_transpose )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiCreateRAPOp)( R, A, P, coarse_grid, cdir, P_stored_as_transpose );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiInterp( void *interp_vdata, hypre_StructMatrix *P, hypre_StructVector *xc, hypre_StructVector *e )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiInterp)( interp_vdata, P, xc, e );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SemiInterpCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiInterpCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiInterpDestroy( void *interp_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiInterpDestroy)( interp_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiInterpSetup( void *interp_vdata, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, hypre_StructVector *xc, hypre_StructVector *e, hypre_Index cindex, hypre_Index findex, hypre_Index stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiInterpSetup)( interp_vdata, P, P_stored_as_transpose, xc, e, cindex, findex, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiRestrict( void *restrict_vdata, hypre_StructMatrix *R, hypre_StructVector *r, hypre_StructVector *rc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiRestrict)( restrict_vdata, R, r, rc );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SemiRestrictCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiRestrictCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiRestrictDestroy( void *restrict_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiRestrictDestroy)( restrict_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SemiRestrictSetup( void *restrict_vdata, hypre_StructMatrix *R, HYPRE_Int R_stored_as_transpose, hypre_StructVector *r, hypre_StructVector *rc, hypre_Index cindex, hypre_Index findex, hypre_Index stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SemiRestrictSetup)( restrict_vdata, R, R_stored_as_transpose, r, rc, cindex, findex, stride );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructDiagScale( hypre_StructMatrix *A, hypre_StructVector *y, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructDiagScale)( A, y, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructInterpAssemble( hypre_StructMatrix *A, hypre_StructMatrix *P, HYPRE_Int P_stored_as_transpose, HYPRE_Int cdir, hypre_Index index, hypre_Index stride )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructInterpAssemble)( A, P, P_stored_as_transpose, cdir, index, stride );
}

/*--------------------------------------------------------------------------*/

void *
hypre_StructJacobiCreate( MPI_Comm comm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiCreate)( comm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiDestroy( void *jacobi_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiDestroy)( jacobi_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiGetFinalRelativeResidualNorm( void *jacobi_vdata, HYPRE_Real *norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiGetFinalRelativeResidualNorm)( jacobi_vdata, norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiGetMaxIter( void *jacobi_vdata, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiGetMaxIter)( jacobi_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiGetNumIterations( void *jacobi_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiGetNumIterations)( jacobi_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiGetTol( void *jacobi_vdata, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiGetTol)( jacobi_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiGetZeroGuess( void *jacobi_vdata, HYPRE_Int *zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiGetZeroGuess)( jacobi_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSetMaxIter( void *jacobi_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSetMaxIter)( jacobi_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSetTempVec( void *jacobi_vdata, hypre_StructVector *t )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSetTempVec)( jacobi_vdata, t );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSetTol( void *jacobi_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSetTol)( jacobi_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSetWeight( void *jacobi_vdata, HYPRE_Real weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSetWeight)( jacobi_vdata, weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSetZeroGuess( void *jacobi_vdata, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSetZeroGuess)( jacobi_vdata, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSetup( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSetup)( jacobi_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructJacobiSolve( void *jacobi_vdata, hypre_StructMatrix *A, hypre_StructVector *b, hypre_StructVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructJacobiSolve)( jacobi_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovAxpy( HYPRE_Complex alpha, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_StructKrylovCAlloc( size_t count, size_t elt_size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovCAlloc)( count, elt_size, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovClearVector( void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovClearVector)( x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovCommInfo( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovCommInfo)( A, my_id, num_procs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovCopyVector( void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovCopyVector)( x, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_StructKrylovCreateVector( void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovCreateVector)( vvector );
}

/*--------------------------------------------------------------------------*/

void *
hypre_StructKrylovCreateVectorArray( HYPRE_Int n, void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovCreateVectorArray)( n, vvector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovDestroyVector( void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovDestroyVector)( vvector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovFree( void *ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovFree)( ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovIdentity( void *vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovIdentity)( vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovIdentitySetup( void *vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovIdentitySetup)( vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_StructKrylovInnerProd( void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovInnerProdTagged( void *x, void *y, HYPRE_Int *num_tags_ptr, HYPRE_Complex **iprod_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovInnerProdTagged)( x, y, num_tags_ptr, iprod_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovMatvec( void *matvec_data, HYPRE_Complex alpha, void *A, void *x, HYPRE_Complex beta, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovMatvec)( matvec_data, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_StructKrylovMatvecCreate( void *A, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovMatvecCreate)( A, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovMatvecDestroy( void *matvec_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovMatvecDestroy)( matvec_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovScaleVector( HYPRE_Complex alpha, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovScaleVector)( alpha, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_StructKrylovSetRandomValues( void *x, HYPRE_Int seed )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_StructKrylovSetRandomValues)( x, seed );
}


#endif

