; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686--   -no-integrated-as | FileCheck %s -check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-- -no-integrated-as | FileCheck %s -check-prefix=X64

define i32 @test_cca(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_cca:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    seta %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_cca:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    seta %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@cca},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccae(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccae:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setae %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccae:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccae},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccb(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccb:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setb %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccb:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccb},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccbe(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccbe:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setbe %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccbe:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccbe},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccc(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccc:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setb %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccc:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccc},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_cce(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_cce:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    sete %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_cce:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@cce},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccz(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccz:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    sete %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    sete %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccz},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccg(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccg:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setg %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccg:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setg %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccg},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccge(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccge:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setge %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccge:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccge},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccl(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccl:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setl %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccl:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccl},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccle(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccle:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setle %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccle:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setle %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccle},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccna(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccna:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setbe %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccna:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccna},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnae(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnae:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setb %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnae:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setb %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnae},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnb(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnb:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setae %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnb:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnb},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnbe(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnbe:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    seta %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnbe:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    seta %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnbe},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnc(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnc:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setae %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnc:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setae %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnc},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccne(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccne:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setne %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccne:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccne},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnz(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnz:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setne %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnz:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setne %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnz},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccng(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccng:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setle %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccng:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setle %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccng},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnge(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnge:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setl %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnge:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setl %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnge},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnl(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnl:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setge %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnl:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setge %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnl},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnle(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnle:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setg %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnle:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setg %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnle},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccno(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccno:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setno %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccno:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setno %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccno},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccnp(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnp:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setnp %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setnp %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccnp},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccns(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccns:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setns %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccns:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setns %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccns},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_cco(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_cco:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    seto %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_cco:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    seto %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@cco},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccp(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccp:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    setp %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccp:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    setp %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccp},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}


define i32 @test_ccs(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccs:
; X32:       # %bb.0: # %entry
; X32-NEXT:    pushl %esi
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X32-NEXT:    xorl %eax, %eax
; X32-NEXT:    #APP
; X32-NEXT:    cmp %ecx,(%esi)
; X32-NEXT:    #NO_APP
; X32-NEXT:    sets %al
; X32-NEXT:    popl %esi
; X32-NEXT:    retl
;
; X64-LABEL: test_ccs:
; X64:       # %bb.0: # %entry
; X64-NEXT:    xorl %eax, %eax
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    sets %al
; X64-NEXT:    retq
entry:
  %cc = tail call i32 asm "cmp $2,$1", "={@ccs},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i32 %cc, 0
  %rv = zext i1 %tobool to i32
  ret i32 %rv
}

declare void @bar()

define void @test_cca_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_cca_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jbe .LBB28_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB28_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_cca_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jbe .LBB28_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB28_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@cca},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccae_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccae_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jb .LBB29_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB29_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccae_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jb .LBB29_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB29_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccae},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccb_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccb_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jae .LBB30_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB30_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccb_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jae .LBB30_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB30_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccb},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccbe_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccbe_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    ja .LBB31_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB31_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccbe_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    ja .LBB31_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB31_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccbe},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccc_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccc_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jae .LBB32_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB32_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccc_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jae .LBB32_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB32_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccc},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_cce_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_cce_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jne .LBB33_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB33_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_cce_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jne .LBB33_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB33_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@cce},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccz_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccz_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jne .LBB34_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB34_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccz_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jne .LBB34_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB34_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccz},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccg_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccg_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jle .LBB35_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB35_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccg_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jle .LBB35_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB35_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccg},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccge_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccge_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jl .LBB36_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB36_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccge_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jl .LBB36_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB36_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccge},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccl_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccl_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jge .LBB37_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB37_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccl_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jge .LBB37_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB37_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccl},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccle_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccle_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jg .LBB38_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB38_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccle_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jg .LBB38_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB38_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccle},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccna_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccna_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    ja .LBB39_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB39_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccna_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    ja .LBB39_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB39_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccna},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnae_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnae_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jae .LBB40_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB40_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnae_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jae .LBB40_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB40_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnae},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnb_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnb_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jb .LBB41_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB41_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnb_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jb .LBB41_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB41_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnb},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnbe_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnbe_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jbe .LBB42_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB42_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnbe_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jbe .LBB42_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB42_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnbe},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnc_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnc_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jb .LBB43_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB43_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnc_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jb .LBB43_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB43_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnc},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccne_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccne_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    je .LBB44_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB44_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccne_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    je .LBB44_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB44_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccne},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnz_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnz_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    je .LBB45_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB45_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnz_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    je .LBB45_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB45_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnz},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccng_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccng_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jg .LBB46_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB46_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccng_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jg .LBB46_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB46_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccng},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnge_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnge_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jge .LBB47_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB47_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnge_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jge .LBB47_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB47_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnge},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnl_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnl_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jl .LBB48_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB48_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnl_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jl .LBB48_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB48_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnl},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnle_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnle_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jle .LBB49_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB49_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnle_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jle .LBB49_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB49_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnle},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccno_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccno_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jo .LBB50_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB50_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccno_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jo .LBB50_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB50_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccno},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccnp_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccnp_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jp .LBB51_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB51_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccnp_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jp .LBB51_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB51_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccnp},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccns_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccns_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    js .LBB52_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB52_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccns_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    js .LBB52_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB52_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccns},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_cco_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_cco_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jno .LBB53_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB53_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_cco_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jno .LBB53_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB53_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@cco},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccp_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccp_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jnp .LBB54_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB54_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccp_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jnp .LBB54_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB54_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccp},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}

define void @test_ccs_branch(i64 %nr, ptr %addr) nounwind {
; X32-LABEL: test_ccs_branch:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X32-NEXT:    #APP
; X32-NEXT:    cmp %eax,(%edx)
; X32-NEXT:    #NO_APP
; X32-NEXT:    jns .LBB55_2
; X32-NEXT:  # %bb.1: # %then
; X32-NEXT:    calll bar@PLT
; X32-NEXT:  .LBB55_2: # %exit
; X32-NEXT:    retl
;
; X64-LABEL: test_ccs_branch:
; X64:       # %bb.0: # %entry
; X64-NEXT:    #APP
; X64-NEXT:    cmp %rdi,(%rsi)
; X64-NEXT:    #NO_APP
; X64-NEXT:    jns .LBB55_2
; X64-NEXT:  # %bb.1: # %then
; X64-NEXT:    pushq %rax
; X64-NEXT:    callq bar@PLT
; X64-NEXT:    addq $8, %rsp
; X64-NEXT:  .LBB55_2: # %exit
; X64-NEXT:    retq
entry:
  %cc = tail call i8 asm "cmp $2,$1", "={@ccs},=*m,r,~{cc},~{dirflag},~{fpsr},~{flags}"(ptr elementtype(i64) %addr, i64 %nr) nounwind
  %tobool = icmp ne i8 %cc, 0
  br i1 %tobool, label %then, label %exit

then:
  call void @bar()
  br label %exit

exit:
  ret void
}
