/*############################################################################*/
/*#                                                                          #*/
/*#  Ambisonic C++ Library                                                   #*/
/*#  AmbisonicBase - Ambisonic Base                                         #*/
/*#  Copyright © 2007 Aristotel Digenis                                      #*/
/*#                                                                          #*/
/*#  Filename:      AmbisonicBase.h                                          #*/
/*#  Version:       0.1                                                      #*/
/*#  Date:          19/05/2007                                               #*/
/*#  Author(s):     Aristotel Digenis                                        #*/
/*#  Licence:       MIT                                                      #*/
/*#                                                                          #*/
/*############################################################################*/


#ifndef SPATIALAUDIO_AMBISONIC_BASE_H
#define SPATIALAUDIO_AMBISONIC_BASE_H

#include "SpatialaudioAPI.h"
#include "AmbisonicCommons.h"

namespace spaudio {

    /// Ambisonic base class.

    /** This is the base class for most if not all of the classes that make up this
        library. */

    class SPAUDIO_API AmbisonicBase
    {
    public:
        AmbisonicBase();
        virtual ~AmbisonicBase() = default;

        /**
         *  Gets the order of the current Ambisonic configuration.
         */
        unsigned GetOrder();

        /**
         *  Gets true or false depending on whether the current Ambisonic
         *  configuration has height(3D).
         */
        bool GetHeight();

        /**
         *  Gets the number of B-Format channels in the current Ambisonic
         *  configuration.
         */
        unsigned GetChannelCount();

        /** Re-create the object for the given configuration. Previous data is
         *  lost.
         *
         * @param nOrder    The ambisonic order.
         * @param b3D       Flag true if the signal is 3D.
         * @param nMisc     Unused input.
         * @return          Returns true if correctly configured.
         */
        virtual bool Configure(unsigned nOrder, bool b3D, unsigned nMisc);

        /**
         *  Not implemented.
         */
        virtual void Reset() = 0;

        /**
         *  Not implemented.
         */
        virtual void Refresh() = 0;

    protected:
        unsigned m_nOrder;
        bool m_b3D;
        unsigned m_nChannelCount;
    };

} // namespace spaudio

#endif // SPATIALAUDIO_AMBISONIC_BASE_H
