# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.secretsstoreextension.aio import SecretsStoreExtensionMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecretsStoreExtensionMgmtAzureKeyVaultSecretProviderClassesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecretsStoreExtensionMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_key_vault_secret_provider_classes_get(self, resource_group):
        response = await self.client.azure_key_vault_secret_provider_classes.get(
            resource_group_name=resource_group.name,
            azure_key_vault_secret_provider_class_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_key_vault_secret_provider_classes_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.azure_key_vault_secret_provider_classes.begin_create_or_update(
                resource_group_name=resource_group.name,
                azure_key_vault_secret_provider_class_name="str",
                resource={
                    "location": "str",
                    "extendedLocation": {"name": "str", "type": "str"},
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "clientId": "str",
                        "keyvaultName": "str",
                        "tenantId": "str",
                        "objects": "str",
                        "provisioningState": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_key_vault_secret_provider_classes_begin_update(self, resource_group):
        response = await (
            await self.client.azure_key_vault_secret_provider_classes.begin_update(
                resource_group_name=resource_group.name,
                azure_key_vault_secret_provider_class_name="str",
                properties={
                    "properties": {"clientId": "str", "keyvaultName": "str", "objects": "str", "tenantId": "str"},
                    "tags": {"str": "str"},
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_key_vault_secret_provider_classes_begin_delete(self, resource_group):
        response = await (
            await self.client.azure_key_vault_secret_provider_classes.begin_delete(
                resource_group_name=resource_group.name,
                azure_key_vault_secret_provider_class_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_key_vault_secret_provider_classes_list_by_resource_group(self, resource_group):
        response = self.client.azure_key_vault_secret_provider_classes.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_azure_key_vault_secret_provider_classes_list_by_subscription(self, resource_group):
        response = self.client.azure_key_vault_secret_provider_classes.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
