% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_to_labels.R
\name{dictionary_to_variable_labels}
\alias{dictionary_to_variable_labels}
\alias{dictionary_to_value_labels}
\title{Convert a dictionary data frame into a list of variable / value labels}
\usage{
dictionary_to_variable_labels(dictionary, names_from = 1, labels_from = 2)

dictionary_to_value_labels(
  dictionary,
  names_from = 1,
  values_from = 2,
  labels_from = 3,
  delim_entries = NULL,
  delim_value_label = NULL,
  data = NULL
)
}
\arguments{
\item{dictionary}{A data frame or a tibble containing the definitions of the
variable / value labels.}

\item{names_from}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Column
containing the names of the variables.}

\item{labels_from}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Column
containing the labels (unused if \code{delim_value_label} is provided).}

\item{values_from}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Column
containing the values or the pairs of values and labels (see examples).}

\item{delim_entries}{Optional string giving the delimiter between several
pairs of value and labels if provided in a unique row. \code{NULL} if each pair
is defined in a separate row (see examples).}

\item{delim_value_label}{Optional string giving the delimiter between the
value and the label.}

\item{data}{A data frame or a tibble containing the raw data to identify
the type (integer, numeric, character) of each variable.}
}
\description{
These helpers could be used to generate, from a data frame corresponding to
a variable dictionary, a list of variable or value labels that could be
passed to \code{\link[=set_variable_labels]{set_variable_labels()}} or to \code{\link[=set_value_labels]{set_value_labels()}}.
}
\details{
It should be noted that value labels could be
}
\examples{
dic <- dplyr::tibble(
  variable = c("mpg", "vs", "am", "cyl"),
  label = c("miles / gallon", "Engine", "Transmission", NA),
  values = c(NA, "0:V-Shaped,1:straight", "0:automatic,1:manual", NA)
)
dic

l <- dic \%>\% dictionary_to_variable_labels()
l
mtcars \%>\%
  set_variable_labels(.labels = l) \%>\%
  look_for()

\dontshow{if (rlang::is_installed("purrr")) withAutoprint(\{ # examplesIf}
vl <- dic \%>\%
  dictionary_to_value_labels(
    values_from = values,
    delim_entries = ",",
    delim_value_label = ":",
    data = mtcars
  )
mtcars \%>\%
  set_value_labels(.labels = vl) \%>\%
  look_for()

dic2 <- dplyr::tibble(
  variable = c("am", "am", "vs", "vs"),
  labels = c("0:automatic", "1:manual", "0:V-shaped", "1:straight")
)
dic2 \%>\%
  dictionary_to_value_labels(
    delim_value_label = ":",
    data = mtcars
  )

dic3 <- dplyr::tibble(
  code = c(0, 1, 0, 1),
  label = c("automatic", "manual", "V-shaped", "straight"),
  var = c("am", "am", "vs", "vs")
)
dic3 \%>\%
  dictionary_to_value_labels(
    names_from = var,
    values_from = code,
    labels_from = label,
    data = mtcars
  )
\dontshow{\}) # examplesIf}
}
