class oci::configure_backports(
  $ceph_configure_osbpo       = false,
  $nova_use_qemu_backports    = false,
  $nova_use_libvirt_backports = false,
){
  # This part makes it possible to use Qemu 7.2 and libvirt 8.0 on Bullseye
  if $facts['os']['distro']['codename'] == "bullseye" {
    if $nova_use_qemu_backports {
      file { '/etc/apt/preferences.d/90-libvirt-prio-from-bullseye-backports':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Package: libvirt0 libvirt-clients libvirt-daemon libvirt-daemon-config-network libvirt-daemon-config-nwfilter libvirt-daemon-driver-qemu libvirt-daemon-system libvirt-daemon-system-systemd
Pin: release a=bullseye-backports
Pin-Priority: 900
',
        notify                  => Exec['apt-update-after-bullseye-bpo'],
      }
    }
    if $nova_use_libvirt_backports {
      file { '/etc/apt/preferences.d/90-qemu-prio-from-bullseye-backports':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Package: qemu-block-extra qemu-system-common qemu-system-data qemu-system-x86 qemu-utils
Pin: release a=bullseye-backports
Pin-Priority: 900
',
        notify                  => Exec['apt-update-after-bullseye-bpo'],
      }
    }
    # apt-update if repo files where created.
    exec { "apt-update-after-bullseye-bpo":
      command     => "/bin/true # comment to satisfy puppet syntax requirements
apt-get update
",
      logoutput   => 'on_failure',
      tries       => 3,
      try_sleep   => 1,
      refreshonly => true,
    }
  }

  if $facts['os']['distro']['codename'] == "bookworm" {
    if $ceph_configure_osbpo or $nova_use_qemu_backports or $nova_use_libvirt_backports {
      # Always set priority to the osbpo repo.
      # Later, we set or not the *.source files.
      file { '/etc/apt/preferences.d/99-prio-from-osbpo':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Package: *
Pin: release o=osbpo
Pin-Priority: 900
',
        notify                  => Exec['apt-update-after-osbpo'],
      }
    }else{
      file { '/etc/apt/preferences.d/99-prio-from-osbpo':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }
    # Always remove this file, this is legacy, we're now using
    # a unique /etc/oci/oci-repository-key.asc key that contains
    # them all.
    file { '/etc/oci/osbpo.asc':
      ensure => absent,
      notify => Exec['apt-update-after-osbpo'],
    }

    # ceph-reef repo from osbpo
    if $ceph_configure_osbpo {
      file { '/etc/apt/sources.list.d/ceph_reef.sources':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Types: deb deb-src
Uris: http://osbpo.debian.net/debian
Suites: ceph-reef
Components: main
Architectures: amd64 arm64
Signed-By: /etc/oci/oci-repository-key.asc
',
        notify                  => Exec['apt-update-after-osbpo'],
      }

    }else{
      file { '/etc/apt/sources.list.d/ceph_reef.sources':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }

    # QEMU from official Debian backports
    if $nova_use_qemu_backports {
      file { '/etc/apt/sources.list.d/qemu.sources':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Types: deb deb-src
Uris: http://osbpo.debian.net/debian
Suites: bookworm-qemu
Components: main
Architectures: amd64 arm64
Signed-By: /etc/oci/oci-repository-key.asc
',
        notify                  => Exec['apt-update-after-osbpo'],
      }
    }else{
      file { '/etc/apt/sources.list.d/qemu.sources':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }

    if $nova_use_libvirt_backports {
      file { '/etc/apt/sources.list.d/libvirt.sources':
        ensure                  => present,
        owner                   => 'root',
        group                   => 'root',
        mode                    => '0644',
        selinux_ignore_defaults => true,
        content                 => 'Types: deb deb-src
Uris: http://osbpo.debian.net/debian
Suites: bookworm-libvirt
Components: main
Architectures: amd64 arm64
Signed-By: /etc/oci/oci-repository-key.asc
',
        notify                  => Exec['apt-update-after-osbpo'],
      }
    }else{
      file { '/etc/apt/sources.list.d/libvirt.sources':
        ensure => absent,
        notify => Exec['apt-update-after-osbpo'],
      }
    }

    # apt-update if repo files where created.
    exec { "apt-update-after-osbpo":
      command     => "/bin/true # comment to satisfy puppet syntax requirements
apt-get update
",
      logoutput   => 'on_failure',
      tries       => 3,
      try_sleep   => 1,
      refreshonly => true,
    }
  }
}
